
#include <iostream>

#include <AMReX.H>
#include <AMReX_BLProfiler.H>
#include <AMReX_ParallelDescriptor.H>
#include <AMReX_ParmParse.H>

#include <AmrCoreProblem.H>

using namespace amrex;

int main(int argc, char* argv[])
{
    amrex::Initialize(argc, argv, /*build_parm_parse=*/true, MPI_COMM_WORLD,
    				      [](){
                     	  amrex::ParmParse pp("amrex");
                          // We require managed memory for now on GPUs
                          // (doesn't do anything on CPUs)
                          bool the_arena_is_managed = true;
                          pp.queryAdd("the_arena_is_managed", the_arena_is_managed);
                      });
    {
        // timer for profiling
        BL_PROFILE("main()");

        // wallclock time
        const auto strt_total = amrex::second();

        
        // constructor - reads in parameters from inputs file
        //             - sizes multilevel arrays and data structures
        AmrCoreProblem amr_core_adv;

        // initialize AMR data
        amr_core_adv.InitData();

        // advance solution to final time
        amr_core_adv.Evolve();

        // wallclock time
        auto end_total = amrex::second() - strt_total;

        if (amr_core_adv.Verbose()) {
            // print wallclock time
            ParallelDescriptor::ReduceRealMax(end_total ,ParallelDescriptor::IOProcessorNumber());
            amrex::Print() << "\nTotal Time: " << end_total << '\n';
        }
    }

    amrex::Finalize();
}
