#ifndef TAGGING_H
#define TAGGING_H

#include <AMReX_Array4.H>

AMREX_GPU_HOST_DEVICE
AMREX_FORCE_INLINE
void
state_error (int i, int j, int k,
             amrex::Array4<char> const& tag,
             amrex::Array4<amrex::Real const> const& state,
             amrex::Real tagerr, char tagval, int varIdx)
{
    if (state(i,j,k, varIdx) > tagerr) {
        tag(i,j,k) = tagval;
        tag(i-1,j,k) = tagval;
        tag(i-1,j-1,k) = tagval;
        tag(i,j-1,k) = tagval;
        tag(i,j,k-1) = tagval;
        tag(i-1,j,k-1) = tagval;
        tag(i-1,j-1,k-1) = tagval;
        tag(i,j-1,k-1) = tagval;

    }
}

AMREX_GPU_HOST_DEVICE
AMREX_FORCE_INLINE
void
state_error (int i, int j, int k,
             amrex::Array4<char> const& tag,
             amrex::Array4<amrex::Real const> const& state,
             amrex::Array4<amrex::Real const> const& shadow_state,
             amrex::Real tagerr, char tagval, int varIdx)
{
    double error = fabs(state(i,j,k, varIdx) - shadow_state(i,j,k, varIdx));
    if (error > tagerr) {
        tag(i,j,k) = tagval;
        tag(i-1,j,k) = tagval;
        tag(i-1,j-1,k) = tagval;
        tag(i,j-1,k) = tagval;
        tag(i,j,k-1) = tagval;
        tag(i-1,j,k-1) = tagval;
        tag(i-1,j-1,k-1) = tagval;
        tag(i,j-1,k-1) = tagval;

    }
}

#endif
