#ifndef included_SphereDataWriter
#define included_SphereDataWriter

#include <AMReX_Config.H>

#include <AMReX_Geometry.H>
#include <AMReX_MultiFab.H>
#include <AMReX_PlotFileDataImpl.H>
#include <AMReX_PlotFileUtil.H>

#include <string>

using namespace amrex;

namespace simflowny
{

   void WriteMultiLevelSpherePlot (const std::string &plotfilename,
                                  int nlevels,
                                  const Vector<const MultiFab*> &mf,
                                  const Vector<std::string> &varnames,
                                  const Vector<Geometry> &geom,
                                  Real time,
                                  const Vector<int> &level_steps,
                                  const Vector<IntVect> &ref_ratio,
                                  const Real radius,
                                  const Vector<Real> center,
                                  const Vector<int> resolution,
                                  const std::string &versionName = "HyperCLaw-V1.1");

   MultiFab sphereMultifab (const Vector<const MultiFab*> &mf_v,
                  const Vector<Geometry> geom,
                  int finest_level,
                  const Real radius,
                  const Vector<Real> center,
                  const Vector<int> resolution);

   AMREX_GPU_DEVICE
   AMREX_FORCE_INLINE
   void calculateSphericalPoint(
      const Array4<const Real> data, 
      Real *sphere,
      int *minLevel,
      int *minLevelLocal,
      const int i,
      const int j,
      const double center_x,
      const double center_y,
      const double center_z,
      const int resolution_x,
      const Real radius,
      const double delta_phi,
      const double delta_theta,
      const GpuArray<Real,BL_SPACEDIM> problo, 
      const GpuArray<Real,BL_SPACEDIM> dx, 
      const Dim3 loVec, 
      const Dim3 hiVec, 
      const int lev,
      const int comp);

};

#endif
