#ifndef included_SliceDataWriter
#define included_SliceDataWriter

#include <AMReX_Config.H>

#include <AMReX_Geometry.H>
#include <AMReX_MultiFab.H>
#include <AMReX_PlotFileDataImpl.H>
#include <AMReX_PlotFileUtil.H>

#include <string>

using namespace amrex;

namespace simflowny
{

   void WriteMultiLevelSlicePlot (const std::string &plotfilename,
                                  int nlevels,
                                  const Vector<const MultiFab*> &mf,
                                  const Vector<std::string> &varnames,
                                  const Vector<Geometry> &geom,
                                  Real time,
                                  const Vector<int> &level_steps,
                                  const Vector<IntVect> &ref_ratio,
                                  const int plane_normal_axis,
                                  const float distance_to_origin,
                                  const std::string &versionName = "HyperCLaw-V1.1");

   void sliceMultifab (const Vector<const MultiFab*> &mf_v,
                                   const Vector<Geometry> geom,
                                   int finest_level,
                                   const int plane_normal_axis,
                                   const float distance_to_origin,
                                   Vector<MultiFab> &slice_mf);

};

#endif
