#ifndef included_PointDataWriter
#define included_PointDataWriter

#include <AMReX_Config.H>

#include <AMReX_Geometry.H>
#include <AMReX_MultiFab.H>
#include <AMReX_PlotFileUtil.H>

#include <string>

using namespace amrex;

namespace simflowny
{

   void WriteMultiLevelPointPlot (const std::string &plotdirname,
                                     int nlevels,
                                     const Vector<const MultiFab*> &mf,
                                     const Vector<std::string> &varnames,
                                     const Vector<Geometry> &geom,
                                     Real time,
                                     const Vector<Real> &coordinates);

   /*
    * Performs the calculations
    */
   void 
   calculatePoint(const Vector<const MultiFab*> &mf_v, 
                  const Vector<Real> coordinates, 
                  Gpu::ManagedVector<Real>* result_data, 
                  int* maxLevel, 
                  const Vector<Geometry> geom,
                  int finest_level);
};

#endif
