#ifndef included_IntegrateDataWriter
#define included_IntegrateDataWriter

#include <AMReX_Config.H>

#include <AMReX_Geometry.H>
#include <AMReX_MultiFab.H>
#include <AMReX_PlotFileUtil.H>

#include <string>

using namespace amrex;

namespace simflowny
{

   struct IntegralData {
      Vector<Real> integral;
      Vector<Real> l2norm;
      Vector<Real> min;
      Vector<Real> max;
      Vector<Real> absmin;
      Vector<Real> absmax;
   };

	   // These tuples are used by amrex::ParReduce to store the reduction results

   using IntegralDataTuple = amrex::GpuTuple<amrex::Real, amrex::Real>;
   using MinMaxDataTuple = amrex::GpuTuple<amrex::Real, amrex::Real,
                                           amrex::Real, amrex::Real>;


   void WriteMultiLevelIntegralPlot (const std::string &plotdirname,
                                     int nlevels,
                                     const Vector<const MultiFab*> &mf,
                                     const Vector<std::string> &varnames,
                                     const Vector<Geometry> &geom,
                                     Real time,
                                     const Vector<IntVect> &ref_ratios, 
                                     const Vector<std::string> &calculations);

   void 
   calculateReductions(const Vector<const MultiFab*> &mf_nd_v,
                       const Vector<IntVect> &ref_ratios,
                       IntegralData& result_data,
                       const Vector<Geometry> geom,
                       int finest_level);
};

#endif
