#ifndef InitialCondition_H_
#define InitialCondition_H_

#include <AMReX_Box.H>
#include <AMReX_FArrayBox.H>
#include <AMReX_Geometry.H>
#include <Commons.h>
#include "Functions.H"
#include "AmrCoreProblem.H"

using namespace amrex;
using namespace simflowny_vars;

AMREX_GPU_DEVICE
AMREX_INLINE
void AmrCoreProblem::initdata(Box const& bx, Array4<Real> const& regions, Array4<Real> const& unp1,Array4<Real> const& unSyncAuxFieldGroup, 
         GpuArray<Real,AMREX_SPACEDIM> const& prob_lo,
         GpuArray<Real,AMREX_SPACEDIM> const& dx, Simflowny_par const parameters) noexcept {
	//Get fields, auxiliary fields and local variables that are going to be used.
	Real cgamma, pos_x, pos_y, pos_z, r, psi_p, drpsi_p, alpha_p, dralpha_p, phi_p, drphi_p, B0, temp, C0, alpha_1, betax_1, k11, k12, k13, k22, k23, k33, h11, h12, h13, h22, h23, h33, aux1, aux2, huu11, huu12, huu13, huu22, huu23, huu33, deth, chi_tmp, trK_tmp;

	const auto lo = bx.loVect();
	const auto hi = bx.hiVect();

	const auto bx_lo = amrex::lbound(bx);
	const auto bx_hi = amrex::ubound(bx);

	for(int k = lo[2]; k <= hi[2]; k++) {
		for(int j = lo[1]; j <= hi[1]; j++) {
			for(int i = lo[0]; i <= hi[0]; i++) {
				cgamma = 1.0 / sqrt(1.0 - parameters.vx1 * parameters.vx1);
				pos_x = xcoord(i) - parameters.xcenter1;
				pos_y = ycoord(j) - parameters.ycenter1;
				pos_z = zcoord(k) - parameters.zcenter1;
				r = std::max(sqrt(cgamma * cgamma * pos_x * pos_x + pos_y * pos_y + pos_z * pos_z), 0.0001);
				psi_p = 0.0;
				readFromFileQuintic(1.0, 1.0, r, psi_p, 0.0, coord0_data_psi1d_1, coord0_dx_psi1d_1, coord0_size_psi1d_1, vars_data_psi1d_1, vars_size_psi1d_1, exists_psi1d_1);
				drpsi_p = 0.0;
				readFromFileQuintic(1.0, 1.0, r, drpsi_p, 0.0, coord0_data_drpsi1d_1, coord0_dx_drpsi1d_1, coord0_size_drpsi1d_1, vars_data_drpsi1d_1, vars_size_drpsi1d_1, exists_drpsi1d_1);
				alpha_p = 0.0;
				readFromFileQuintic(1.0, 1.0, r, alpha_p, 0.0, coord0_data_alpha1d_1, coord0_dx_alpha1d_1, coord0_size_alpha1d_1, vars_data_alpha1d_1, vars_size_alpha1d_1, exists_alpha1d_1);
				dralpha_p = 0.0;
				readFromFileQuintic(1.0, 1.0, r, dralpha_p, 0.0, coord0_data_dralpha1d_1, coord0_dx_dralpha1d_1, coord0_size_dralpha1d_1, vars_data_dralpha1d_1, vars_size_dralpha1d_1, exists_dralpha1d_1);
				phi_p = 0.0;
				readFromFileQuintic(1.0, 1.0, r, phi_p, 0.0, coord0_data_phi1d_1, coord0_dx_phi1d_1, coord0_size_phi1d_1, vars_data_phi1d_1, vars_size_phi1d_1, exists_phi1d_1);
				drphi_p = 0.0;
				readFromFileQuintic(1.0, 1.0, r, drphi_p, 0.0, coord0_data_drphi1d_1, coord0_dx_drphi1d_1, coord0_size_drphi1d_1, vars_data_drphi1d_1, vars_size_drphi1d_1, exists_drphi1d_1);
				B0 = cgamma * sqrt(1.0 - ((parameters.vx1 * parameters.vx1) * (alpha_p * alpha_p)) / (psi_p * psi_p * psi_p * psi_p));
				temp = 4.0 * (psi_p * psi_p * psi_p) * drpsi_p - 2.0 * alpha_p * dralpha_p * (parameters.vx1 * parameters.vx1);
				C0 = temp / (psi_p * psi_p * psi_p * psi_p - (alpha_p * parameters.vx1) * (alpha_p * parameters.vx1));
				alpha_1 = alpha_p / B0;
				unp1(i, j, k, Alpha) = alpha_1;
				betax_1 = (-(psi_p * psi_p * psi_p * psi_p - alpha_p * alpha_p) * parameters.vx1) / (psi_p * psi_p * psi_p * psi_p - (alpha_p * parameters.vx1) * (alpha_p * parameters.vx1));
				unp1(i, j, k, Betau_x) = betax_1;
				unp1(i, j, k, Betau_y) = 0.0;
				unp1(i, j, k, Betau_z) = 0.0;
				k11 = (cgamma * cgamma * B0 * pos_x * parameters.vx1) / r * (2.0 * dralpha_p - 0.5 * alpha_p * C0);
				k12 = (B0 * pos_y * parameters.vx1) / r * (dralpha_p - 0.5 * alpha_p * C0);
				k13 = (B0 * pos_z * parameters.vx1) / r * (dralpha_p - 0.5 * alpha_p * C0);
				k22 = (2.0 * cgamma * cgamma * pos_x * parameters.vx1 * alpha_p * drpsi_p) / (psi_p * B0 * r);
				k23 = 0.0;
				k33 = (2.0 * cgamma * cgamma * pos_x * parameters.vx1 * alpha_p * drpsi_p) / (psi_p * B0 * r);
				h11 = (psi_p * psi_p * psi_p * psi_p) * (B0 * B0);
				h12 = 0.0;
				h13 = 0.0;
				h22 = psi_p * psi_p * psi_p * psi_p;
				h23 = 0.0;
				h33 = psi_p * psi_p * psi_p * psi_p;
				unp1(i, j, k, phiR) = phi_p * cos(cgamma * parameters.vx1 * pos_x * parameters.omega1);
				unp1(i, j, k, phiI) = phi_p * sin(cgamma * parameters.vx1 * pos_x * parameters.omega1);
				aux1 = cgamma * cgamma * pos_x * (betax_1 + parameters.vx1) * drphi_p * cos(cgamma * parameters.vx1 * pos_x * parameters.omega1) - cgamma * r * parameters.omega1 * phi_p * (betax_1 * parameters.vx1 + 1.0) * sin(cgamma * parameters.vx1 * pos_x * parameters.omega1);
				aux2 = cgamma * cgamma * pos_x * (betax_1 + parameters.vx1) * drphi_p * sin(cgamma * parameters.vx1 * pos_x * parameters.omega1) + cgamma * r * parameters.omega1 * phi_p * (betax_1 * parameters.vx1 + 1.0) * cos(cgamma * parameters.vx1 * pos_x * parameters.omega1);
				unp1(i, j, k, piR) = aux1 / (alpha_1 * r);
				unp1(i, j, k, piI) = aux2 / (alpha_1 * r);
				temp = (2.0 * parameters.vx1 * parameters.vx1 * cgamma * cgamma * alpha_p) / (psi_p * psi_p * psi_p * psi_p * psi_p) * (2.0 * alpha_p * drpsi_p - psi_p * dralpha_p);
				unp1(i, j, k, Gamh_x) = 2.0 / (3.0 * (pow(B0, (10.0 / 3.0)))) * temp * (cgamma * cgamma * pos_x) / r;
				unp1(i, j, k, Gamh_y) = (-1.0 / (3.0 * (pow(B0, (4.0 / 3.0))))) * temp * pos_y / r;
				unp1(i, j, k, Gamh_z) = (-1.0 / (3.0 * (pow(B0, (4.0 / 3.0))))) * temp * pos_z / r;
				huu11 = (-h23 * h23) + h22 * h33;
				huu12 = h13 * h23 - h12 * h33;
				huu13 = (-h13 * h22) + h12 * h23;
				huu22 = (-h13 * h13) + h11 * h33;
				huu23 = h12 * h13 - h11 * h23;
				huu33 = (-h12 * h12) + h11 * h22;
				deth = h11 * huu11 + h12 * huu12 + h13 * huu13;
				huu11 = huu11 / deth;
				huu12 = huu12 / deth;
				huu13 = huu13 / deth;
				huu22 = huu22 / deth;
				huu23 = huu23 / deth;
				huu33 = huu33 / deth;
				chi_tmp = pow(deth, ((-1.0) / 3.0));
				unp1(i, j, k, chi) = chi_tmp;
				trK_tmp = huu11 * k11 + huu22 * k22 + huu33 * k33 + 2.0 * (huu12 * k12 + huu13 * k13 + huu23 * k23);
				unp1(i, j, k, trK) = trK_tmp;
				unp1(i, j, k, gtd_xx) = chi_tmp * h11;
				unp1(i, j, k, gtd_xy) = chi_tmp * h12;
				unp1(i, j, k, gtd_xz) = chi_tmp * h13;
				unp1(i, j, k, gtd_yy) = chi_tmp * h22;
				unp1(i, j, k, gtd_yz) = chi_tmp * h23;
				unp1(i, j, k, gtd_zz) = chi_tmp * h33;
				unp1(i, j, k, Atd_xx) = chi_tmp * (k11 - (h11 * trK_tmp) / 3.0);
				unp1(i, j, k, Atd_xy) = chi_tmp * (k12 - (h12 * trK_tmp) / 3.0);
				unp1(i, j, k, Atd_xz) = chi_tmp * (k13 - (h13 * trK_tmp) / 3.0);
				unp1(i, j, k, Atd_yy) = chi_tmp * (k22 - (h22 * trK_tmp) / 3.0);
				unp1(i, j, k, Atd_yz) = chi_tmp * (k23 - (h23 * trK_tmp) / 3.0);
				unp1(i, j, k, Atd_zz) = chi_tmp * (k33 - (h33 * trK_tmp) / 3.0);
				unp1(i, j, k, theta) = 0.0;
				if (equalsEq(parameters.nstars, 2.0)) {
					cgamma = 1.0 / sqrt(1.0 - parameters.vx2 * parameters.vx2);
					pos_x = xcoord(i) - parameters.xcenter2;
					pos_y = ycoord(j) - parameters.ycenter2;
					pos_z = zcoord(k) - parameters.zcenter2;
					r = std::max(sqrt(cgamma * cgamma * pos_x * pos_x + pos_y * pos_y + pos_z * pos_z), 0.0001);
					psi_p = 0.0;
					readFromFileQuintic(1.0, 1.0, r, psi_p, 0.0, coord0_data_psi1d_2, coord0_dx_psi1d_2, coord0_size_psi1d_2, vars_data_psi1d_2, vars_size_psi1d_2, exists_psi1d_2);
					drpsi_p = 0.0;
					readFromFileQuintic(1.0, 1.0, r, drpsi_p, 0.0, coord0_data_drpsi1d_2, coord0_dx_drpsi1d_2, coord0_size_drpsi1d_2, vars_data_drpsi1d_2, vars_size_drpsi1d_2, exists_drpsi1d_2);
					alpha_p = 0.0;
					readFromFileQuintic(1.0, 1.0, r, alpha_p, 0.0, coord0_data_alpha1d_2, coord0_dx_alpha1d_2, coord0_size_alpha1d_2, vars_data_alpha1d_2, vars_size_alpha1d_2, exists_alpha1d_2);
					dralpha_p = 0.0;
					readFromFileQuintic(1.0, 1.0, r, dralpha_p, 0.0, coord0_data_dralpha1d_2, coord0_dx_dralpha1d_2, coord0_size_dralpha1d_2, vars_data_dralpha1d_2, vars_size_dralpha1d_2, exists_dralpha1d_2);
					phi_p = 0.0;
					readFromFileQuintic(1.0, 1.0, r, phi_p, 0.0, coord0_data_phi1d_2, coord0_dx_phi1d_2, coord0_size_phi1d_2, vars_data_phi1d_2, vars_size_phi1d_2, exists_phi1d_2);
					drphi_p = 0.0;
					readFromFileQuintic(1.0, 1.0, r, drphi_p, 0.0, coord0_data_drphi1d_2, coord0_dx_drphi1d_2, coord0_size_drphi1d_2, vars_data_drphi1d_2, vars_size_drphi1d_2, exists_drphi1d_2);
					B0 = cgamma * sqrt(1.0 - ((parameters.vx2 * parameters.vx2) * (alpha_p * alpha_p)) / (psi_p * psi_p * psi_p * psi_p));
					temp = 4.0 * (psi_p * psi_p * psi_p) * drpsi_p - 2.0 * alpha_p * dralpha_p * (parameters.vx2 * parameters.vx2);
					C0 = temp / (psi_p * psi_p * psi_p * psi_p - (alpha_p * parameters.vx2) * (alpha_p * parameters.vx2));
					alpha_1 = alpha_p / B0;
					unp1(i, j, k, Alpha) = (unp1(i, j, k, Alpha) + alpha_1) - 1.0;
					betax_1 = (-(psi_p * psi_p * psi_p * psi_p - alpha_p * alpha_p) * parameters.vx2) / (psi_p * psi_p * psi_p * psi_p - (alpha_p * parameters.vx2) * (alpha_p * parameters.vx2));
					unp1(i, j, k, Betau_x) = unp1(i, j, k, Betau_x) + betax_1;
					k11 = (cgamma * cgamma * B0 * pos_x * parameters.vx2) / r * (2.0 * dralpha_p - 0.5 * alpha_p * C0);
					k12 = (B0 * pos_y * parameters.vx2) / r * (dralpha_p - 0.5 * alpha_p * C0);
					k13 = (B0 * pos_z * parameters.vx2) / r * (dralpha_p - 0.5 * alpha_p * C0);
					k22 = (2.0 * cgamma * cgamma * pos_x * parameters.vx2 * alpha_p * drpsi_p) / (psi_p * B0 * r);
					k23 = 0.0;
					k33 = (2.0 * cgamma * cgamma * pos_x * parameters.vx2 * alpha_p * drpsi_p) / (psi_p * B0 * r);
					h11 = (psi_p * psi_p * psi_p * psi_p) * (B0 * B0);
					h12 = 0.0;
					h13 = 0.0;
					h22 = psi_p * psi_p * psi_p * psi_p;
					h23 = 0.0;
					h33 = psi_p * psi_p * psi_p * psi_p;
					unp1(i, j, k, pheR) = phi_p * cos(cgamma * parameters.vx2 * pos_x * parameters.omega2);
					unp1(i, j, k, pheI) = phi_p * sin(cgamma * parameters.vx2 * pos_x * parameters.omega2);
					aux1 = cgamma * cgamma * pos_x * (betax_1 + parameters.vx2) * drphi_p * cos(cgamma * parameters.vx2 * pos_x * parameters.omega2) - cgamma * r * parameters.omega2 * phi_p * (betax_1 * parameters.vx2 + 1.0) * sin(cgamma * parameters.vx2 * pos_x * parameters.omega2);
					aux2 = cgamma * cgamma * pos_x * (betax_1 + parameters.vx2) * drphi_p * sin(cgamma * parameters.vx2 * pos_x * parameters.omega2) + cgamma * r * parameters.omega2 * phi_p * (betax_1 * parameters.vx2 + 1.0) * cos(cgamma * parameters.vx2 * pos_x * parameters.omega2);
					unp1(i, j, k, peR) = aux1 / (alpha_1 * r);
					unp1(i, j, k, peI) = aux2 / (alpha_1 * r);
					temp = (2.0 * parameters.vx2 * parameters.vx2 * cgamma * cgamma * alpha_p) / (psi_p * psi_p * psi_p * psi_p * psi_p) * (2.0 * alpha_p * drpsi_p - psi_p * dralpha_p);
					unp1(i, j, k, Gamh_x) = unp1(i, j, k, Gamh_x) + 2.0 / (3.0 * (pow(B0, (10.0 / 3.0)))) * temp * (cgamma * cgamma * pos_x) / r;
					unp1(i, j, k, Gamh_y) = unp1(i, j, k, Gamh_y) + (-1.0 / (3.0 * (pow(B0, (4.0 / 3.0)))) * temp * pos_y / r);
					unp1(i, j, k, Gamh_z) = unp1(i, j, k, Gamh_z) + (-1.0 / (3.0 * (pow(B0, (4.0 / 3.0)))) * temp * pos_z / r);
					huu11 = (-h23 * h23) + h22 * h33;
					huu12 = h13 * h23 - h12 * h33;
					huu13 = (-h13 * h22) + h12 * h23;
					huu22 = (-h13 * h13) + h11 * h33;
					huu23 = h12 * h13 - h11 * h23;
					huu33 = (-h12 * h12) + h11 * h22;
					deth = h11 * huu11 + h12 * huu12 + h13 * huu13;
					huu11 = huu11 / deth;
					huu12 = huu12 / deth;
					huu13 = huu13 / deth;
					huu22 = huu22 / deth;
					huu23 = huu23 / deth;
					huu33 = huu33 / deth;
					chi_tmp = pow(deth, ((-1.0) / 3.0));
					unp1(i, j, k, chi) = (unp1(i, j, k, chi) + chi_tmp) - 1.0;
					trK_tmp = huu11 * k11 + huu22 * k22 + huu33 * k33 + 2.0 * (huu12 * k12 + huu13 * k13 + huu23 * k23);
					unp1(i, j, k, trK) = unp1(i, j, k, trK) + trK_tmp;
					unp1(i, j, k, gtd_xx) = unp1(i, j, k, gtd_xx) + chi_tmp * h11 + (-1.0);
					unp1(i, j, k, gtd_xy) = unp1(i, j, k, gtd_xy) + chi_tmp * h12;
					unp1(i, j, k, gtd_xz) = unp1(i, j, k, gtd_xz) + chi_tmp * h13;
					unp1(i, j, k, gtd_yy) = unp1(i, j, k, gtd_yy) + chi_tmp * h22 + (-1.0);
					unp1(i, j, k, gtd_yz) = unp1(i, j, k, gtd_yz) + chi_tmp * h23;
					unp1(i, j, k, gtd_zz) = unp1(i, j, k, gtd_zz) + chi_tmp * h33 + (-1.0);
					unp1(i, j, k, Atd_xx) = unp1(i, j, k, Atd_xx) + chi_tmp * (k11 - (h11 * trK_tmp) / 3.0);
					unp1(i, j, k, Atd_xy) = unp1(i, j, k, Atd_xy) + chi_tmp * (k12 - (h12 * trK_tmp) / 3.0);
					unp1(i, j, k, Atd_xz) = unp1(i, j, k, Atd_xz) + chi_tmp * (k13 - (h13 * trK_tmp) / 3.0);
					unp1(i, j, k, Atd_yy) = unp1(i, j, k, Atd_yy) + chi_tmp * (k22 - (h22 * trK_tmp) / 3.0);
					unp1(i, j, k, Atd_yz) = unp1(i, j, k, Atd_yz) + chi_tmp * (k23 - (h23 * trK_tmp) / 3.0);
					unp1(i, j, k, Atd_zz) = unp1(i, j, k, Atd_zz) + chi_tmp * (k33 - (h33 * trK_tmp) / 3.0);
				}
				unSyncAuxFieldGroup(i, j, k, phi2) = unp1(i, j, k, phiR) * unp1(i, j, k, phiR) + unp1(i, j, k, phiI) * unp1(i, j, k, phiI) + unp1(i, j, k, pheR) * unp1(i, j, k, pheR) + unp1(i, j, k, pheI) * unp1(i, j, k, pheI);
			}
		}
	}

}

#endif
