#ifndef included_CommonsXD
#define included_CommonsXD

#ifdef EXTERNAL_EOS
#include "reprimand/con2prim_imhd.h"
#include "reprimand/eos_idealgas.h"
#include "reprimand/eos_hybrid.h"
#include "reprimand/eos_barotropic.h"
#include "reprimand/eos_barotr_file.h"
#include "reprimand/eos_thermal_file.h"
#endif

#include <AMReX_Array.H>
#include <gsl/gsl_rng.h>

//Simulation constants 
#define xcoord(i) (prob_lo[0] + (i) * dx[0])
#define ycoord(j) (prob_lo[1] + (j) * dx[1])
#define zcoord(k) (prob_lo[2] + (k) * dx[2])
#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))
#define SIGN(X) (((X) > 0) - ((X) < 0))
#define greaterEq(a,b) ((fabs((a) - (b))/1.0E-15 > 10 ? false : (floor(fabs((a) - (b))/1.0E-15) < 1)) || (b)<(a))
#define lessEq(a,b) ((fabs((a) - (b))/1.0E-15 > 10 ? false: (floor(fabs((a) - (b))/1.0E-15) < 1)) || (a)<(b))
#define equalsEq(a,b) ((fabs((a) - (b))/1.0E-15 > 10 ? false: (floor(fabs((a) - (b))/1.0E-15) < 1)))
#define reducePrecision(x, p) (floor(((x) * pow(10, (p)) + 0.5)) / pow(10, (p)))


#ifdef EXTERNAL_EOS
using namespace EOS_Toolkit;
#endif

class Commons {
public:
	static gsl_rng *r_var;

	/* 
	 * ReprimAnd EOS
	 * External library based on https://arxiv.org/abs/2005.01821
	 * Requires installation of the library at https://zenodo.org/record/4075317#.X9nVJ8J7nJk
	 */
	//Variables for external equation of state calculation using RePrimAnd
	#ifdef EXTERNAL_EOS
    class ExternalEos {
    public:
    	static eos_thermal eos;
    	static con2prim_mhd*  cv2pv;
    	static int reprimand_eos_type;
		static double reprimand_c2p_acc;
		static double reprimand_atmo_Ye;
		static double reprimand_max_z;
		static double reprimand_max_b;
		static double reprimand_atmo_rho;
		static double reprimand_rho_strict;
		static double reprimand_gamma_th;
		static double reprimand_max_rho;
		static double reprimand_max_eps;
    };
	#endif


    static void initialization() {
    	#ifdef EXTERNAL_EOS
    	// Ideal Gas
    	if (ExternalEos::reprimand_eos_type == 0) {
    		double adiabatic_index = 1 / (ExternalEos::reprimand_gamma_th - 1);
	  		ExternalEos::eos = make_eos_idealgas(adiabatic_index, ExternalEos::reprimand_max_eps, ExternalEos::reprimand_max_rho);
		}
		//Hybrid
		if (ExternalEos::reprimand_eos_type == 1) {
			eos_barotr eos_c = load_eos_barotr("external.eos.h5");
	  		ExternalEos::eos = make_eos_hybrid(eos_c, ExternalEos::reprimand_gamma_th, ExternalEos::reprimand_max_eps, ExternalEos::reprimand_max_rho);
	  	}
		// Tabular 
		if (ExternalEos::reprimand_eos_type == 2) {
			ExternalEos::eos = load_eos_thermal("external.eos.h5");
		}
		
		//Some values to print
		std::cout<<"range rho "<<ExternalEos::eos.range_rho().min()<<" "<<ExternalEos::eos.range_rho().max()<<std::endl;
		std::cout<<"range eps (rho min) "<<ExternalEos::eos.range_eps(0, 0).min()<<" "<<ExternalEos::eos.range_eps(0, 0).max()<<std::endl;
		std::cout<<"range eps (rho max) "<<ExternalEos::eos.range_eps(ExternalEos::eos.range_rho().max(), 0).min()<<" "<<ExternalEos::eos.range_eps(ExternalEos::eos.range_rho().max(), 0).max()<<std::endl;

	  	//Set up atmosphere
		real_t atmo_eps = ExternalEos::eos.range_eps(ExternalEos::reprimand_atmo_rho, ExternalEos::reprimand_atmo_Ye).min();
   
	  	real_t atmo_cut = ExternalEos::reprimand_atmo_rho * 1.01;
	  	real_t atmo_p = ExternalEos::eos.at_rho_eps_ye(ExternalEos::reprimand_atmo_rho, atmo_eps, ExternalEos::reprimand_atmo_Ye).press();

	  	atmosphere atmo{ExternalEos::reprimand_atmo_rho, atmo_eps, ExternalEos::reprimand_atmo_Ye, atmo_p, atmo_cut};

	  	//Primitive recovery parameters
	  	bool  ye_lenient = false;
	  	int max_iter = 40;
		ExternalEos::cv2pv = new con2prim_mhd(ExternalEos::eos, ExternalEos::reprimand_rho_strict, ye_lenient, ExternalEos::reprimand_max_z, ExternalEos::reprimand_max_b, atmo, ExternalEos::reprimand_c2p_acc, max_iter);
		#endif
    }

};

namespace external {
	
AMREX_GPU_DEVICE
int externalCon2prim(amrex::Real& parEfu_x, amrex::Real& parEfu_y, amrex::Real& parEfu_z, amrex::Real& parrhof, amrex::Real& parpf, amrex::Real& parepsf, amrex::Real& parvfd_x, amrex::Real& parvfd_y, amrex::Real& parvfd_z, amrex::Real& parsqcs, amrex::Real& pardpfdrho, amrex::Real& pardpfdeps, amrex::Real parDf, amrex::Real& parSfd_x, amrex::Real& parSfd_y, amrex::Real& parSfd_z, amrex::Real& partauf, amrex::Real& parW, amrex::Real parchi, amrex::Real pargtu_xx, amrex::Real pargtu_xy, amrex::Real pargtu_xz, amrex::Real pargtu_yy, amrex::Real pargtu_yz, amrex::Real pargtu_zz, amrex::Real pargtd_xx, amrex::Real pargtd_xy, amrex::Real pargtd_xz, amrex::Real pargtd_yy, amrex::Real pargtd_yz, amrex::Real pargtd_zz, amrex::Real parBfu_x, amrex::Real parBfu_y, amrex::Real parBfu_z, const amrex::GpuArray<double, 3> dx, const double simPlat_dt);
}


#endif
