
#include "Commons.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef EXTERNAL_EOS
eos_thermal Commons::ExternalEos::eos;
con2prim_mhd * Commons::ExternalEos::cv2pv;
double Commons::ExternalEos::reprimand_c2p_acc;
double Commons::ExternalEos::reprimand_atmo_Ye;
double Commons::ExternalEos::reprimand_max_z;
double Commons::ExternalEos::reprimand_max_b;
double Commons::ExternalEos::reprimand_atmo_rho;
double Commons::ExternalEos::reprimand_rho_strict;
double Commons::ExternalEos::reprimand_gamma_th;
double Commons::ExternalEos::reprimand_max_rho;
double Commons::ExternalEos::reprimand_max_eps;
int Commons::ExternalEos::reprimand_eos_type;
        

/* 
 * ReprimAnd EOS
 * External library based on https://arxiv.org/abs/2005.01821
 * Requires installation of the library at https://zenodo.org/record/4075317#.X9nVJ8J7nJk
 */
AMREX_GPU_DEVICE
int external::externalCon2prim(amrex::Real& parEfu_x, amrex::Real& parEfu_y, amrex::Real& parEfu_z, amrex::Real& parrhof, amrex::Real& parpf, amrex::Real& parepsf, amrex::Real& parvfd_x, amrex::Real& parvfd_y, amrex::Real& parvfd_z, amrex::Real& parsqcs, amrex::Real& pardpfdrho, amrex::Real& pardpfdeps, amrex::Real parDf, amrex::Real& parSfd_x, amrex::Real& parSfd_y, amrex::Real& parSfd_z, amrex::Real& partauf, amrex::Real& parW, amrex::Real parchi, amrex::Real pargtu_xx, amrex::Real pargtu_xy, amrex::Real pargtu_xz, amrex::Real pargtu_yy, amrex::Real pargtu_yz, amrex::Real pargtu_zz, amrex::Real pargtd_xx, amrex::Real pargtd_xy, amrex::Real pargtd_xz, amrex::Real pargtd_yy, amrex::Real pargtd_yz, amrex::Real pargtd_zz, amrex::Real parBfu_x, amrex::Real parBfu_y, amrex::Real parBfu_z, const amrex::GpuArray<double, 3> dx, const double simPlat_dt) {

    //Collect variables
    cons_vars_mhd evolved{parDf, partauf, 0.5 * parDf, {parSfd_x,parSfd_y,parSfd_z}, {parBfu_x,parBfu_y,parBfu_z}};    

    //Create metric variable
    sm_tensor2_sym<double, 3, false, false> lo(pargtd_xx/parchi, pargtd_xy/parchi, pargtd_yy/parchi, pargtd_xz/parchi, pargtd_yz/parchi, pargtd_zz/parchi);
    sm_metric3 g((sm_metric<double, 3>) lo);

    prim_vars_mhd primitives;
    con2prim_mhd::report rep;

    //Conservative to primitive variables
    (*Commons::ExternalEos::cv2pv)(primitives, evolved, g, rep);

    if (rep.failed()) {
        std::cerr << rep.debug_message()<<std::endl; 
        return -1;
    }
    //Conservative variables were adjusted
    if (rep.adjust_cons) {
        parSfd_x = evolved.scon(0);
        parSfd_y = evolved.scon(1);
        parSfd_z = evolved.scon(2);
        partauf = evolved.tau;
        parDf = evolved.dens;
        parBfu_x = evolved.bcons(0);
        parBfu_y = evolved.bcons(1);
        parBfu_z = evolved.bcons(2);
    }
    //Primitive variables assignment
    parrhof = primitives.rho;
    parepsf = primitives.eps;
    parpf = primitives.press;
    parW = primitives.w_lor;

    double vux = primitives.vel(0);
    double vuy = primitives.vel(1);
    double vuz = primitives.vel(2);

    parvfd_x = (pargtd_xx * vux + pargtd_xy * vuy + pargtd_xz * vuz) / parchi;
    parvfd_y = (pargtd_xy * vux + pargtd_yy * vuy + pargtd_yz * vuz) / parchi;
    parvfd_z = (pargtd_xz * vux + pargtd_yz * vuy + pargtd_zz * vuz) / parchi;
    parEfu_x = primitives.E(0);
    parEfu_y = primitives.E(1);
    parEfu_z = primitives.E(2);

    pardpfdrho = Commons::ExternalEos::eos.at_rho_eps_ye(primitives.rho, primitives.eps, primitives.ye).dpress_drho();
    pardpfdeps = Commons::ExternalEos::eos.at_rho_eps_ye(primitives.rho, primitives.eps, primitives.ye).dpress_deps();
    parsqcs = Commons::ExternalEos::eos.at_rho_eps_ye(primitives.rho, primitives.eps, primitives.ye).csnd();

    return  1;
}

#endif

#ifndef EXTERNAL_EOS
AMREX_GPU_DEVICE
int external::externalCon2prim(amrex::Real& parEfu_x, amrex::Real& parEfu_y, amrex::Real& parEfu_z, amrex::Real& parrhof, amrex::Real& parpf, amrex::Real& parepsf, amrex::Real& parvfd_x, amrex::Real& parvfd_y, amrex::Real& parvfd_z, amrex::Real& parsqcs, amrex::Real& pardpfdrho, amrex::Real& pardpfdeps, amrex::Real parDf, amrex::Real& parSfd_x, amrex::Real& parSfd_y, amrex::Real& parSfd_z, amrex::Real& partauf, amrex::Real& parW, amrex::Real parchi, amrex::Real pargtu_xx, amrex::Real pargtu_xy, amrex::Real pargtu_xz, amrex::Real pargtu_yy, amrex::Real pargtu_yz, amrex::Real pargtu_zz, amrex::Real pargtd_xx, amrex::Real pargtd_xy, amrex::Real pargtd_xz, amrex::Real pargtd_yy, amrex::Real pargtd_yz, amrex::Real pargtd_zz, amrex::Real parBfu_x, amrex::Real parBfu_y, amrex::Real parBfu_z, const amrex::GpuArray<double, 3> dx, const double simPlat_dt) {

    amrex::Abort("Error in externalCon2prim: compile using Reprimand to use externalCon2prim");
}
#endif
