#ifndef AmrCoreProblem_H_
#define AmrCoreProblem_H_

#include <string>
#include <limits>
#include <memory>

#ifdef AMREX_USE_OMP
#include <omp.h>
#endif

#include <AMReX_Gpu.H>
#include <AMReX_AmrCore.H>
#include <AMReX_FluxRegister.H>
#include <AMReX_BCRec.H>
#include <Parameters.H>
#include <AMReX_FillPatchUtil_mod.H>

//Variable indexes
namespace simflowny_vars {
  enum regionIndices {FOV_1, stalled_1, FOV_xLower, FOV_xUpper, FOV_yLower, FOV_yUpper, FOV_zLower, FOV_zUpper, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, NumRegions};
  enum fieldIndices {pheI, trK, phiI, theta, Atd_yy, Atd_yz, Betau_y, Betau_x, gtd_yy, gtd_yz, Gamh_z, Betau_z, chi, Atd_xz, pheR, piI, Atd_xx, Atd_zz, Atd_xy, phiR, peI, Alpha, piR, gtd_xx, gtd_zz, Gamh_x, peR, gtd_xy, Gamh_y, gtd_xz, NumFields};
	enum unSyncAuxFieldIndices {phi2, NumUnSyncAuxFields};
	enum analysisIndices {Rscalar, HamCon, MomCon_x, MomCon_y, MomCon_z, trA, detgtm1, M_ADM_surf, Jz_ADM_surf, N_Noetheri, N_Noethere, M_Komar, Jz_Komar, psi4R, psi4I, Z_x, Z_y, Z_z, NumAnalysisVars};

  enum AllVariables {pheI_plt, trK_plt, phiI_plt, theta_plt, Atd_yy_plt, Atd_yz_plt, phi2_plt, Betau_y_plt, Betau_x_plt, gtd_yy_plt, gtd_yz_plt, Gamh_z_plt, Betau_z_plt, chi_plt, Atd_xz_plt, pheR_plt, piI_plt, Atd_xx_plt, Atd_zz_plt, Atd_xy_plt, phiR_plt, peI_plt, Alpha_plt, piR_plt, gtd_xx_plt, gtd_zz_plt, Gamh_x_plt, peR_plt, gtd_xy_plt, Gamh_y_plt, gtd_xz_plt, Rscalar_plt, HamCon_plt, MomCon_x_plt, MomCon_y_plt, MomCon_z_plt, trA_plt, detgtm1_plt, M_ADM_surf_plt, Jz_ADM_surf_plt, N_Noetheri_plt, N_Noethere_plt, M_Komar_plt, Jz_Komar_plt, psi4R_plt, psi4I_plt, Z_x_plt, Z_y_plt, Z_z_plt, regrid_tag_plt};
}

#define NUM_GHOST_CELLS 3
#define REGION_THICKNESS 3

	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_dralpha1d_2;
	extern AMREX_GPU_MANAGED int vars_size_dralpha1d_2;
	extern AMREX_GPU_MANAGED Real coord0_dx_dralpha1d_2;
	extern AMREX_GPU_MANAGED int coord0_size_dralpha1d_2;
	extern AMREX_GPU_MANAGED Real* coord0_data_dralpha1d_2;
	extern AMREX_GPU_MANAGED bool exists_dralpha1d_2;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_dralpha1d_1;
	extern AMREX_GPU_MANAGED int vars_size_dralpha1d_1;
	extern AMREX_GPU_MANAGED Real coord0_dx_dralpha1d_1;
	extern AMREX_GPU_MANAGED int coord0_size_dralpha1d_1;
	extern AMREX_GPU_MANAGED Real* coord0_data_dralpha1d_1;
	extern AMREX_GPU_MANAGED bool exists_dralpha1d_1;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_drpsi1d_1;
	extern AMREX_GPU_MANAGED int vars_size_drpsi1d_1;
	extern AMREX_GPU_MANAGED Real coord0_dx_drpsi1d_1;
	extern AMREX_GPU_MANAGED int coord0_size_drpsi1d_1;
	extern AMREX_GPU_MANAGED Real* coord0_data_drpsi1d_1;
	extern AMREX_GPU_MANAGED bool exists_drpsi1d_1;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_phi1d_2;
	extern AMREX_GPU_MANAGED int vars_size_phi1d_2;
	extern AMREX_GPU_MANAGED Real coord0_dx_phi1d_2;
	extern AMREX_GPU_MANAGED int coord0_size_phi1d_2;
	extern AMREX_GPU_MANAGED Real* coord0_data_phi1d_2;
	extern AMREX_GPU_MANAGED bool exists_phi1d_2;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_drpsi1d_2;
	extern AMREX_GPU_MANAGED int vars_size_drpsi1d_2;
	extern AMREX_GPU_MANAGED Real coord0_dx_drpsi1d_2;
	extern AMREX_GPU_MANAGED int coord0_size_drpsi1d_2;
	extern AMREX_GPU_MANAGED Real* coord0_data_drpsi1d_2;
	extern AMREX_GPU_MANAGED bool exists_drpsi1d_2;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_phi1d_1;
	extern AMREX_GPU_MANAGED int vars_size_phi1d_1;
	extern AMREX_GPU_MANAGED Real coord0_dx_phi1d_1;
	extern AMREX_GPU_MANAGED int coord0_size_phi1d_1;
	extern AMREX_GPU_MANAGED Real* coord0_data_phi1d_1;
	extern AMREX_GPU_MANAGED bool exists_phi1d_1;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_alpha1d_2;
	extern AMREX_GPU_MANAGED int vars_size_alpha1d_2;
	extern AMREX_GPU_MANAGED Real coord0_dx_alpha1d_2;
	extern AMREX_GPU_MANAGED int coord0_size_alpha1d_2;
	extern AMREX_GPU_MANAGED Real* coord0_data_alpha1d_2;
	extern AMREX_GPU_MANAGED bool exists_alpha1d_2;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_psi1d_2;
	extern AMREX_GPU_MANAGED int vars_size_psi1d_2;
	extern AMREX_GPU_MANAGED Real coord0_dx_psi1d_2;
	extern AMREX_GPU_MANAGED int coord0_size_psi1d_2;
	extern AMREX_GPU_MANAGED Real* coord0_data_psi1d_2;
	extern AMREX_GPU_MANAGED bool exists_psi1d_2;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_drphi1d_1;
	extern AMREX_GPU_MANAGED int vars_size_drphi1d_1;
	extern AMREX_GPU_MANAGED Real coord0_dx_drphi1d_1;
	extern AMREX_GPU_MANAGED int coord0_size_drphi1d_1;
	extern AMREX_GPU_MANAGED Real* coord0_data_drphi1d_1;
	extern AMREX_GPU_MANAGED bool exists_drphi1d_1;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_drphi1d_2;
	extern AMREX_GPU_MANAGED int vars_size_drphi1d_2;
	extern AMREX_GPU_MANAGED Real coord0_dx_drphi1d_2;
	extern AMREX_GPU_MANAGED int coord0_size_drphi1d_2;
	extern AMREX_GPU_MANAGED Real* coord0_data_drphi1d_2;
	extern AMREX_GPU_MANAGED bool exists_drphi1d_2;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_psi1d_1;
	extern AMREX_GPU_MANAGED int vars_size_psi1d_1;
	extern AMREX_GPU_MANAGED Real coord0_dx_psi1d_1;
	extern AMREX_GPU_MANAGED int coord0_size_psi1d_1;
	extern AMREX_GPU_MANAGED Real* coord0_data_psi1d_1;
	extern AMREX_GPU_MANAGED bool exists_psi1d_1;
	//Files to read
	extern AMREX_GPU_MANAGED Real* vars_data_alpha1d_1;
	extern AMREX_GPU_MANAGED int vars_size_alpha1d_1;
	extern AMREX_GPU_MANAGED Real coord0_dx_alpha1d_1;
	extern AMREX_GPU_MANAGED int coord0_size_alpha1d_1;
	extern AMREX_GPU_MANAGED Real* coord0_data_alpha1d_1;
	extern AMREX_GPU_MANAGED bool exists_alpha1d_1;


class AmrCoreProblem
    : public amrex::AmrCore
{
public:

    ////////////////
    // public member functions

    // constructor - reads in parameters from inputs file
    //             - sizes multilevel arrays and data structures
    AmrCoreProblem ();
    virtual ~AmrCoreProblem();

    // advance solution to final time
    void Evolve ();

    // initializes multilevel data
    void InitData ();

    // post initialization synchronization and boundaries
    void postInitialization(const int lev, Real time, Simflowny_par const parameters);

    // initial analysis calculation
    void postInitialAnalysis(Simflowny_par const parameters);

    // Overload from AmrCore to add fmr capabilities.
    void InitFromScratch (Real time);

    // Overload from AmrCore to add fmr capabilities.
    virtual void regrid (int lbase, Real time, bool initial=false);

    //Map regions on mesh
    void mapDataOnPatch(Real time, const int lev, MultiFab& regions);

    //Initial condition
    AMREX_GPU_DEVICE
    AMREX_INLINE
    void initdata(Box const& bx, Array4<Real> const& regions, Array4<Real> const& unp1,Array4<Real> const& unSyncAuxFieldGroup, 
         GpuArray<Real,AMREX_SPACEDIM> const& prob_lo,
         GpuArray<Real,AMREX_SPACEDIM> const& dx, Simflowny_par const parameters) noexcept;


	//Calculate variables for interpolation
	void calculateExtrapolationVars(Real time, const int lev, MultiFab& regions_mf);

	//Calculate variables for interpolation
	AMREX_GPU_DEVICE
	AMREX_FORCE_INLINE
	bool calculateExtrapolationDistance(const Box& gbx, Array4<Real> regions, int i, int j, int k, int FOV);



    // Make a new level using provided BoxArray and DistributionMapping and
    // fill with interpolated coarse level data.
    // overrides the pure virtual function in AmrCore
    virtual void MakeNewLevelFromCoarse (int lev, amrex::Real time, const amrex::BoxArray& ba,
                                         const amrex::DistributionMapping& dm) override;

    // Remake an existing level using provided BoxArray and DistributionMapping and
    // fill with existing fine and coarse data.
    // overrides the pure virtual function in AmrCore
    virtual void RemakeLevel (int lev, amrex::Real time, const amrex::BoxArray& ba,
                              const amrex::DistributionMapping& dm) override;

    // Delete level data
    // overrides the pure virtual function in AmrCore
    virtual void ClearLevel (int lev) override;

    // Make a new level from scratch using provided BoxArray and DistributionMapping.
    // Only used during initialization.
    // overrides the pure virtual function in AmrCore
    virtual void MakeNewLevelFromScratch (int lev, amrex::Real time, const amrex::BoxArray& ba,
                                          const amrex::DistributionMapping& dm) override;

    // Gets the multifab corresponding to the given level and variable name
    const MultiFab* getMultifab (std::string varname, int level) const;

    // Gets the index corresponding to the given variable name
    int getVarIdx (std::string varname);

    // tag all cells for refinement
    // overrides the pure virtual function in AmrCore
    virtual void ErrorEst (int lev, amrex::TagBoxArray& tags, amrex::Real time, int ngrow) override;

    // Advance phi at a single level for a single time step, update flux registers
    void AdvanceLevel (int lev, amrex::Real time, amrex::Real dt_lev, int iteration, int ncycle, bool do_subcycle, Simflowny_par const parameters);

	// reset fields (optionally called after a restart)
    void ResetFields();

    // compute dt from CFL considerations
    amrex::Real EstTimeStep (int lev, amrex::Real time);

    //Parameters
    Simflowny_par parameters;

    //Variable index maps
    static std::map<std::string, simflowny_vars::AllVariables> mapVariableValues;
    static std::map<std::string, simflowny_vars::fieldIndices> mapVarFieldIdx;
    	static std::map<std::string, simflowny_vars::unSyncAuxFieldIndices> mapVarUnSyncAuxFieldIdx;
	static std::map<std::string, simflowny_vars::analysisIndices> mapVarAnalysisIdx;


	Gpu::ManagedVector<Real> gpu_coord0_data_dralpha1d_2;
	Gpu::ManagedVector<Real> gpu_vars_data_dralpha1d_2;
	Gpu::ManagedVector<Real> gpu_coord0_data_dralpha1d_1;
	Gpu::ManagedVector<Real> gpu_vars_data_dralpha1d_1;
	Gpu::ManagedVector<Real> gpu_coord0_data_drpsi1d_1;
	Gpu::ManagedVector<Real> gpu_vars_data_drpsi1d_1;
	Gpu::ManagedVector<Real> gpu_coord0_data_phi1d_2;
	Gpu::ManagedVector<Real> gpu_vars_data_phi1d_2;
	Gpu::ManagedVector<Real> gpu_coord0_data_drpsi1d_2;
	Gpu::ManagedVector<Real> gpu_vars_data_drpsi1d_2;
	Gpu::ManagedVector<Real> gpu_coord0_data_phi1d_1;
	Gpu::ManagedVector<Real> gpu_vars_data_phi1d_1;
	Gpu::ManagedVector<Real> gpu_coord0_data_alpha1d_2;
	Gpu::ManagedVector<Real> gpu_vars_data_alpha1d_2;
	Gpu::ManagedVector<Real> gpu_coord0_data_psi1d_2;
	Gpu::ManagedVector<Real> gpu_vars_data_psi1d_2;
	Gpu::ManagedVector<Real> gpu_coord0_data_drphi1d_1;
	Gpu::ManagedVector<Real> gpu_vars_data_drphi1d_1;
	Gpu::ManagedVector<Real> gpu_coord0_data_drphi1d_2;
	Gpu::ManagedVector<Real> gpu_vars_data_drphi1d_2;
	Gpu::ManagedVector<Real> gpu_coord0_data_psi1d_1;
	Gpu::ManagedVector<Real> gpu_vars_data_psi1d_1;
	Gpu::ManagedVector<Real> gpu_coord0_data_alpha1d_1;
	Gpu::ManagedVector<Real> gpu_vars_data_alpha1d_1;


private:

    ////////////////
    // private member functions

    // read in some parameters from inputs file
    void ReadParameters();

    // set covered coarse cells to be the average of overlying fine cells
    void AverageDown ();

    // more flexible version of AverageDown() that lets you average down across multiple levels
    void AverageDownTo (int crse_lev);

    // Fills vectors with alternative interpolation variables
    void FillInterpolatorAlternativeSets();

    // compute a new multifab by coping in phi from valid region and filling ghost cells
    // works for single level and 2-level cases (fill fine grid ghost by interpolating from coarse)
		void FillPatch (int lev, amrex::Real time, amrex::MultiFab& mf, amrex::Vector<amrex::MultiFab>& origin_data_un, amrex::Vector<amrex::MultiFab>& origin_data_rk1, amrex::Vector<amrex::MultiFab>& origin_data_rk2, amrex::Vector<amrex::MultiFab>& origin_data_rk3, amrex::Vector<amrex::MultiFab>& origin_data_unp1, int tcomp, int interp_step, int time_substep_number, std::set<int> interpolator_mapper_changes, bool syncSingleLevel=false);

    void FillPatch (int lev, amrex::Real time, amrex::MultiFab& mf, amrex::Vector<amrex::MultiFab>& origin_data, int tcomp, std::set<int> interpolator_mapper_changes, bool syncSingleLevel=false);

    // fill an entire multifab by interpolating from the coarser level
    // this comes into play when a new level of refinement appears
    void FillCoarsePatch (int lev, amrex::Real time, amrex::MultiFab& mf, amrex::Vector<amrex::MultiFab>& origin_data, int icomp, int ncomp);

    // utility to copy in data from another multifab
    void GetData (int lev, amrex::Real time, amrex::Vector<amrex::MultiFab*>& data,
                  amrex::Vector<amrex::Real>& datatime, amrex::Vector<amrex::MultiFab>& origin_data);
		void GetData (int lev, amrex::Real time, amrex::Vector<amrex::MultiFab*>& data, amrex::Vector<amrex::Real>& datatime, amrex::Vector<amrex::MultiFab>& origin_data_un, amrex::Vector<amrex::MultiFab>& origin_data_rk1, amrex::Vector<amrex::MultiFab>& origin_data_rk2, amrex::Vector<amrex::MultiFab>& origin_data_rk3, amrex::Vector<amrex::MultiFab>& origin_data_unp1);


    // Advance a level by dt - includes a recursive call for finer levels
    void timeStepWithSubcycling (int lev, amrex::Real time, int iteration);

    // Advance all levels by the same dt
    void timeStepNoSubcycling (amrex::Real time, int iteration);

    // a wrapper for EstTimeStep
    void ComputeDt ();

    // get plotfile name
    std::string PlotFileName (int lev) const;

    // put together an array of multifabs for writing
    amrex::Vector<std::unique_ptr<MultiFab> > PlotFileMF (amrex::Vector<std::string> varnames, bool withGhost=false) const;

    // write plotfile to disk
    void WritePlotFile (int outputCycle, Real time);
    void WritePlotIntegralFile (int index, Real time);
    void WritePlotPointFile (int index, Real time);
		void WritePlotSliceFile (int outputCycle, int index, Real time);
		void WritePlotSphereFile (int outputCycle, int index, Real time);


    // write checkpoint file to disk
    void WriteCheckpointFile () const;

    // read checkpoint file from disk
    void ReadCheckpointFile ();

    // Calculate mask for integral plot
    //void calculateMask(int fineLevel, int coarseLevel);

    // Check finalization condition
    bool checkFinalization(const double current_time, const double dt);

    ////////////////
    // private data members

    //FileWriter
    int next_mesh_dump_iteration;
    amrex::Vector<int> next_integration_dump_iteration;
    amrex::Vector<int> next_point_dump_iteration;
    amrex::Vector<int> current_iteration;
	amrex::Vector<int> next_slice_dump_iteration;
	amrex::Vector<int> next_sphere_dump_iteration;


    amrex::Vector<int> istep;      // which step?
    amrex::Vector<int> nsubsteps;  // how many substeps on each level?

    // keep track of old time, new time, and time step at each level
    amrex::Vector<amrex::Real> t_new;
    amrex::Vector<amrex::Real> t_old;
    amrex::Vector<amrex::Real> dt;

    // array of multifabs to store the variables at each level of refinement
    amrex::Vector<amrex::MultiFab> regions_var;
		amrex::Vector<amrex::MultiFab> unstate_var;
		amrex::Vector<amrex::MultiFab> rk1state_var;
		amrex::Vector<amrex::MultiFab> rk2state_var;
		amrex::Vector<amrex::MultiFab> rk3state_var;
		amrex::Vector<amrex::MultiFab> unp1state_var;
		amrex::Vector<amrex::MultiFab> unSyncAuxFieldGroup_var;
		amrex::Vector<amrex::MultiFab> analysisGroup_var;


    // this is essentially a 2*DIM integer array storing the physical boundary
    // condition types at the lo/hi walls in each direction
    amrex::Vector<amrex::BCRec> bcs;  // 1-component

    //Regridding tag
    amrex::Vector<amrex::MultiFab> regrid_tag_var;

    //Mask variable
    //amrex::Vector<amrex::MultiFab> hierarchy_mask;

    amrex::Interpolater* mapper;
    amrex::Interpolater* alternative_mapper;

    ////////////////
    // runtime parameters

    // if >= 0 we restart from a checkpoint
    std::string restart_chkfile = "";
    
    // whether to reset the fields when restarting from a checkpoint
    bool restart_field_reset = false;

    // advective cfl number - dt = cfl*dx/umax
    amrex::Real cfl = 0.7;

    // how often each level regrids the higher levels of refinement
    // (after a level advances that many time steps)
    int regrid_int = 0;

    //Spatial interpolation parameters
    std::string spatialInterpolator;
    std::string alternativeSpatialInterpolator;
    Vector<std::string> alternative_interpolator_variables;

    std::set<int> state_interpolator_change;
    std::set<int> auxFieldGroup_interpolator_change;
    
    //FMR info
    int fmr_levels = 0;
    Vector<Vector<int> > fmr_lo;
    Vector<Vector<int> > fmr_hi;

    // do we subcycle in time?
    int do_subcycle = 0;

    //random parameter
    double random_seed_param = 1;

    // plotfile parameters
    std::string plot_dir;
    std::string plot_file {"plt"};
    Vector<std::string> plot_varnames;
    bool plot_overwrite = true;
    int plot_int = -1;
    bool first_plot = true;

    //Integral plot
    Vector<std::string> plot_integral_dir;
    Vector<int> plot_integral_int;
    Vector<Vector<std::string> > plot_integral_varnames;
    Vector<Vector<std::string> > plot_integral_calculations;
    std::vector<bool> first_plot_integral;

    //Point plot
    Vector<std::string> plot_point_dir;
    Vector<int> plot_point_int;
    Vector<Vector<std::string> > plot_point_varnames;
    Vector<Vector<Real> > plot_point_coordinates;
    std::vector<bool> first_plot_point;

		//Slice plot
		Vector<std::string> plot_slice_dir;
		Vector<int> plot_slice_int;
		Vector<Vector<std::string> > plot_slice_varnames;
		Vector<int> plot_slice_plane_normal_axis;
		Vector<Real> plot_slice_distance_to_origin;
		std::vector<bool> first_plot_slice;

		//Sphere plot
		Vector<std::string> plot_sphere_dir;
		Vector<int> plot_sphere_int;
		Vector<Vector<std::string> > plot_sphere_varnames;
		Vector<Vector<Real> > plot_sphere_center;
		Vector<Real> plot_sphere_radius;
		Vector<Vector<int> > plot_sphere_resolution;
		std::vector<bool> first_plot_sphere;


    // checkpoint prefix and frequency
    std::string chk_file {"chk"};
    int chk_int = -1;
};

#endif
