#include <AmrCoreProblem.H>
#include <Functions.H>
#include "Commons.h"

using namespace amrex;
using namespace simflowny_vars;
using namespace external;

// Advance a single level for a single time step, updates flux registers
void AmrCoreProblem::AdvanceLevel (int lev, Real current_time, Real dt_lev, int iteration, int ncycle, bool do_subcycle, Simflowny_par const parameters) {
    BL_PROFILE("AmrCoreProblem::AdvanceLevel()");

    Real new_time = current_time + dt_lev;
    if (do_subcycle && iteration == 0 && lev > 0) {
        current_iteration[lev] = (current_iteration[lev - 1] - 1) * MaxRefRatio(lev - 1) + 1;
    } else {
        current_iteration[lev] = current_iteration[lev] + 1;
    }
    int previous_iteration = current_iteration[lev] - 1;
    int outputCycle = current_iteration[lev];
    if (max_level > lev) {
        int currentLevelNumber = lev;
        while (currentLevelNumber < max_level) {
            int ratio = MaxRefRatio(currentLevelNumber);
            outputCycle = outputCycle * ratio;
            previous_iteration = previous_iteration * ratio;
            currentLevelNumber++;
        }
    }

	std::swap(unstate_var[lev], unp1state_var[lev]);


    MultiFab& regions_mf = regions_var[lev];
	MultiFab& un_mf = unstate_var[lev];
	MultiFab& rk1_mf = rk1state_var[lev];
	MultiFab& rk2_mf = rk2state_var[lev];
	MultiFab& rk3_mf = rk3state_var[lev];
	MultiFab& unp1_mf = unp1state_var[lev];
	MultiFab& unSyncAuxFieldGroup_mf = unSyncAuxFieldGroup_var[lev];
	MultiFab& analysisGroup_mf = analysisGroup_var[lev];


    const auto dx = geom[lev].CellSizeArray();
    const auto prob_lo = geom[lev].ProbLoArray();

#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> un = un_mf.array(mfi);
			Array4<Real> regions = regions_mf.array(mfi);
			Array4<Real> rk1 = rk1_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {
				Real d_div_Beta_o0_t0_m0_l0, d_Betau_x_o1_t0_m0_l0, d_Betau_x_o2_t0_m0_l0, d_gtd_xy_o2_t0_m0_l0, d_Betau_x_o1_t1_m0_l0, d_Betau_x_o2_t1_m0_l0, d_gtd_xz_o2_t0_m0_l0, d_Betau_x_o1_t2_m0_l0, d_Betau_x_o2_t2_m0_l0, d_d_div_Beta_x_o0_t0_m0_l0, d_d_div_Beta_y_o0_t0_m0_l0, d_d_div_Beta_z_o0_t0_m0_l0, d_Gamh_x_o2_t6_m0_l0, d_Gamh_x_o2_t7_m0_l0, d_Gamh_x_o2_t8_m0_l0, d_gtd_xx_o2_t1_m0_l0, d_Betau_y_o1_t0_m0_l0, d_Betau_y_o2_t0_m0_l0, d_div_Beta_o0_t1_m0_l0, d_Betau_y_o1_t1_m0_l0, d_Betau_y_o2_t1_m0_l0, d_gtd_xz_o2_t1_m0_l0, d_Betau_y_o1_t2_m0_l0, d_Betau_y_o2_t2_m0_l0, d_Gamh_y_o2_t4_m0_l0, d_d_div_Beta_x_o0_t1_m0_l0, d_Gamh_y_o2_t6_m0_l0, d_d_div_Beta_y_o0_t1_m0_l0, d_d_div_Beta_z_o0_t1_m0_l0, d_Gamh_y_o2_t9_m0_l0, d_gtd_xx_o2_t2_m0_l0, d_Betau_z_o1_t0_m0_l0, d_Betau_z_o2_t0_m0_l0, d_gtd_xy_o2_t2_m0_l0, d_Betau_z_o1_t1_m0_l0, d_Betau_z_o2_t1_m0_l0, d_div_Beta_o0_t2_m0_l0, d_Betau_z_o1_t2_m0_l0, d_Betau_z_o2_t2_m0_l0, d_Gamh_z_o2_t14_m0_l0, d_Gamh_z_o2_t15_m0_l0, d_d_div_Beta_x_o0_t2_m0_l0, d_Gamh_z_o2_t17_m0_l0, d_d_div_Beta_y_o0_t2_m0_l0, d_d_div_Beta_z_o0_t2_m0_l0, d_Ctd_xxx_o0_t0_m0_l0, d_gtd_xx_o0_t0_m0_l0, d_gtd_xx_o1_t0_m0_l0, d_Ctd_xxy_o0_t0_m0_l0, d_gtd_xx_o0_t1_m0_l0, d_gtd_xx_o1_t1_m0_l0, d_Ctd_xxz_o0_t0_m0_l0, d_gtd_xx_o0_t2_m0_l0, d_gtd_xx_o1_t2_m0_l0, d_Ctd_yxx_o0_t0_m0_l0, d_gtd_xy_o0_t0_m0_l0, d_gtd_xy_o1_t0_m0_l0, d_Ctd_xyy_o0_t0_m0_l0, d_gtd_xy_o0_t1_m0_l0, d_gtd_xy_o1_t1_m0_l0, d_Ctd_xyz_o0_t1_m0_l0, d_gtd_xy_o0_t2_m0_l0, d_gtd_xy_o1_t2_m0_l0, d_Ctd_xyy_o0_t1_m0_l0, d_gtd_yy_o0_t0_m0_l0, d_gtd_yy_o1_t0_m0_l0, d_Ctd_yyy_o0_t0_m0_l0, d_gtd_yy_o0_t1_m0_l0, d_gtd_yy_o1_t1_m0_l0, d_Ctd_yyz_o0_t0_m0_l0, d_gtd_yy_o0_t2_m0_l0, d_gtd_yy_o1_t2_m0_l0, d_Ctd_zxx_o0_t0_m0_l0, d_gtd_xz_o0_t0_m0_l0, d_gtd_xz_o1_t0_m0_l0, d_Ctd_xyz_o0_t0_m0_l0, d_gtd_xz_o0_t1_m0_l0, d_gtd_xz_o1_t1_m0_l0, d_Ctd_xzz_o0_t0_m0_l0, d_gtd_xz_o0_t2_m0_l0, d_gtd_xz_o1_t2_m0_l0, d_Ctd_xyz_o0_t2_m0_l0, d_gtd_yz_o0_t0_m0_l0, d_gtd_yz_o1_t0_m0_l0, d_Ctd_zyy_o0_t0_m0_l0, d_gtd_yz_o0_t1_m0_l0, d_gtd_yz_o1_t1_m0_l0, d_Ctd_yzz_o0_t0_m0_l0, d_gtd_yz_o0_t2_m0_l0, d_gtd_yz_o1_t2_m0_l0, d_Ctd_xzz_o0_t1_m0_l0, d_gtd_zz_o0_t0_m0_l0, d_gtd_zz_o1_t0_m0_l0, d_Ctd_yzz_o0_t1_m0_l0, d_gtd_zz_o0_t1_m0_l0, d_gtd_zz_o1_t1_m0_l0, d_Ctd_zzz_o0_t0_m0_l0, d_gtd_zz_o0_t2_m0_l0, d_gtd_zz_o1_t2_m0_l0, d_Rpd_xx_o0_t0_m0_l0, d_chi_o0_t0_m0_l0, d_chi_o1_t0_m0_l0, d_Rpd_xx_o0_t1_m0_l0, d_chi_o0_t1_m0_l0, d_chi_o1_t1_m0_l0, d_Rpd_xx_o0_t2_m0_l0, d_chi_o0_t2_m0_l0, d_chi_o1_t2_m0_l0, d_Rtd_xx_o0_t6_m0_l0, d_Gamh_x_o0_t0_m0_l0, d_Gamh_x_o1_t0_m0_l0, d_Rtd_xy_o0_t6_m0_l0, d_Gamh_x_o0_t1_m0_l0, d_Gamh_x_o1_t1_m0_l0, d_Rtd_xz_o0_t6_m0_l0, d_Gamh_x_o0_t2_m0_l0, d_Gamh_x_o1_t2_m0_l0, d_Rtd_xx_o0_t7_m0_l0, d_Gamh_y_o0_t0_m0_l0, d_Gamh_y_o1_t0_m0_l0, d_Rtd_xy_o0_t7_m0_l0, d_Gamh_y_o0_t1_m0_l0, d_Gamh_y_o1_t1_m0_l0, d_Rtd_xz_o0_t7_m0_l0, d_Gamh_y_o0_t2_m0_l0, d_Gamh_y_o1_t2_m0_l0, d_Rtd_xx_o0_t8_m0_l0, d_Gamh_z_o0_t1_m0_l0, d_Gamh_z_o1_t0_m0_l0, d_Rtd_xy_o0_t8_m0_l0, d_Gamh_z_o0_t2_m0_l0, d_Gamh_z_o1_t1_m0_l0, d_Rtd_xz_o0_t8_m0_l0, d_Gamh_z_o0_t0_m0_l0, d_Gamh_z_o1_t2_m0_l0, d_Psi1_xx_o0_t1_m0_l0, d_Alpha_o0_t0_m0_l0, d_Alpha_o1_t0_m0_l0, d_Psi1_xx_o0_t2_m0_l0, d_Alpha_o0_t1_m0_l0, d_Alpha_o1_t1_m0_l0, d_Psi1_xx_o0_t3_m0_l0, d_Alpha_o0_t2_m0_l0, d_Alpha_o1_t2_m0_l0, d_Psi1_xx_o0_t0_m0_l0, d_Psi1_xy_o0_t0_m0_l0, d_Psi1_xz_o0_t0_m0_l0, d_Psi1_yy_o0_t0_m0_l0, d_Psi1_yz_o0_t0_m0_l0, d_Psi1_zz_o0_t0_m0_l0, d_d_phiR4d_t_o0_t1_m0_l0, d_phiR_o0_t0_m0_l0, d_phiR_o1_t0_m0_l0, d_d_phiR4d_t_o0_t2_m0_l0, d_phiR_o0_t1_m0_l0, d_phiR_o1_t1_m0_l0, d_d_phiR4d_t_o0_t3_m0_l0, d_phiR_o0_t2_m0_l0, d_phiR_o1_t2_m0_l0, d_piR_o2_t26_m0_l0, d_piR_o2_t0_m0_l0, d_piR_o2_t1_m0_l0, d_piR_o2_t2_m0_l0, d_piR_o2_t3_m0_l0, d_piR_o2_t4_m0_l0, d_d_phiI4d_t_o0_t1_m0_l0, d_phiI_o0_t0_m0_l0, d_phiI_o1_t0_m0_l0, d_d_phiI4d_t_o0_t2_m0_l0, d_phiI_o0_t1_m0_l0, d_phiI_o1_t1_m0_l0, d_d_phiI4d_t_o0_t3_m0_l0, d_phiI_o0_t2_m0_l0, d_phiI_o1_t2_m0_l0, d_piI_o2_t24_m0_l0, d_piI_o2_t25_m0_l0, d_piI_o2_t26_m0_l0, d_piI_o2_t0_m0_l0, d_piI_o2_t1_m0_l0, d_piI_o2_t2_m0_l0, d_d_pheR4d_t_o0_t1_m0_l0, d_pheR_o0_t0_m0_l0, d_pheR_o1_t0_m0_l0, d_d_pheR4d_t_o0_t2_m0_l0, d_pheR_o0_t1_m0_l0, d_pheR_o1_t1_m0_l0, d_d_pheR4d_t_o0_t3_m0_l0, d_pheR_o0_t2_m0_l0, d_pheR_o1_t2_m0_l0, d_peR_o2_t24_m0_l0, d_peR_o2_t25_m0_l0, d_peR_o2_t26_m0_l0, d_peR_o2_t0_m0_l0, d_peR_o2_t1_m0_l0, d_peR_o2_t2_m0_l0, d_d_pheI4d_t_o0_t1_m0_l0, d_pheI_o0_t0_m0_l0, d_pheI_o1_t0_m0_l0, d_d_pheI4d_t_o0_t2_m0_l0, d_pheI_o0_t1_m0_l0, d_pheI_o1_t1_m0_l0, d_d_pheI4d_t_o0_t3_m0_l0, d_pheI_o0_t2_m0_l0, d_pheI_o1_t2_m0_l0, d_peI_o2_t22_m0_l0, d_peI_o2_t23_m0_l0, d_peI_o2_t24_m0_l0, d_peI_o2_t25_m0_l0, d_peI_o2_t26_m0_l0, d_peI_o2_t0_m0_l0, d_Atd_xx_o0_t0_m0_l0, d_Atd_xx_o1_t0_m0_l0, d_Atd_xx_o0_t1_m0_l0, d_Atd_xx_o1_t1_m0_l0, d_Atd_xx_o0_t2_m0_l0, d_Atd_xx_o1_t2_m0_l0, d_Atd_xy_o0_t0_m0_l0, d_Atd_xy_o1_t0_m0_l0, d_Atd_xy_o0_t1_m0_l0, d_Atd_xy_o1_t1_m0_l0, d_Atd_xy_o0_t2_m0_l0, d_Atd_xy_o1_t2_m0_l0, d_Atd_xz_o0_t0_m0_l0, d_Atd_xz_o1_t0_m0_l0, d_Atd_xz_o0_t1_m0_l0, d_Atd_xz_o1_t1_m0_l0, d_Atd_xz_o0_t2_m0_l0, d_Atd_xz_o1_t2_m0_l0, d_Atd_yy_o0_t0_m0_l0, d_Atd_yy_o1_t0_m0_l0, d_Atd_yy_o0_t1_m0_l0, d_Atd_yy_o1_t1_m0_l0, d_Atd_yy_o0_t2_m0_l0, d_Atd_yy_o1_t2_m0_l0, d_Atd_yz_o0_t0_m0_l0, d_Atd_yz_o1_t0_m0_l0, d_Atd_yz_o0_t1_m0_l0, d_Atd_yz_o1_t1_m0_l0, d_Atd_yz_o0_t2_m0_l0, d_Atd_yz_o1_t2_m0_l0, d_Atd_zz_o0_t0_m0_l0, d_Atd_zz_o1_t0_m0_l0, d_Atd_zz_o0_t1_m0_l0, d_Atd_zz_o1_t1_m0_l0, d_Atd_zz_o0_t2_m0_l0, d_Atd_zz_o1_t2_m0_l0, d_Gamh_x_o2_t12_m0_l0, d_trK_o0_t0_m0_l0, d_trK_o1_t0_m0_l0, d_Gamh_x_o2_t13_m0_l0, d_trK_o0_t1_m0_l0, d_trK_o1_t1_m0_l0, d_Gamh_x_o2_t14_m0_l0, d_trK_o0_t2_m0_l0, d_trK_o1_t2_m0_l0, d_Gamh_x_o2_t15_m0_l0, d_theta_o0_t0_m0_l0, d_theta_o1_t0_m0_l0, d_Gamh_x_o2_t16_m0_l0, d_theta_o0_t1_m0_l0, d_theta_o1_t1_m0_l0, d_Gamh_x_o2_t17_m0_l0, d_theta_o0_t2_m0_l0, d_theta_o1_t2_m0_l0, d_piR_o0_t0_m0_l0, d_piR_o1_t0_m0_l0, d_piR_o0_t1_m0_l0, d_piR_o1_t1_m0_l0, d_piR_o0_t2_m0_l0, d_piR_o1_t2_m0_l0, d_peR_o0_t0_m0_l0, d_peR_o1_t0_m0_l0, d_peR_o0_t1_m0_l0, d_peR_o1_t1_m0_l0, d_peR_o0_t2_m0_l0, d_peR_o1_t2_m0_l0, d_piI_o0_t0_m0_l0, d_piI_o1_t0_m0_l0, d_piI_o0_t1_m0_l0, d_piI_o1_t1_m0_l0, d_piI_o0_t2_m0_l0, d_piI_o1_t2_m0_l0, d_peI_o0_t0_m0_l0, d_peI_o1_t2_m0_l0, d_peI_o0_t1_m0_l0, d_peI_o1_t0_m0_l0, d_peI_o0_t2_m0_l0, d_peI_o1_t1_m0_l0, d_Rtd_xx_o0_t0_m0_l0, d_Rtd_xx_o0_t1_m0_l0, d_Rtd_xx_o0_t2_m0_l0, d_Rtd_xx_o0_t3_m0_l0, d_Rtd_xx_o0_t4_m0_l0, d_Rtd_xx_o0_t5_m0_l0, d_Rtd_xy_o0_t0_m0_l0, d_Rtd_xy_o0_t1_m0_l0, d_Rtd_xy_o0_t2_m0_l0, d_Rtd_xy_o0_t3_m0_l0, d_Rtd_xy_o0_t4_m0_l0, d_Rtd_xy_o0_t5_m0_l0, d_Rtd_yy_o0_t0_m0_l0, d_Rtd_yy_o0_t1_m0_l0, d_Rtd_yy_o0_t2_m0_l0, d_Rtd_yy_o0_t3_m0_l0, d_Rtd_yy_o0_t4_m0_l0, d_Rtd_yy_o0_t5_m0_l0, d_Rtd_xz_o0_t0_m0_l0, d_Rtd_xz_o0_t1_m0_l0, d_Rtd_xz_o0_t2_m0_l0, d_Rtd_xz_o0_t3_m0_l0, d_Rtd_xz_o0_t4_m0_l0, d_Rtd_xz_o0_t5_m0_l0, d_Rtd_yz_o0_t0_m0_l0, d_Rtd_yz_o0_t1_m0_l0, d_Rtd_yz_o0_t2_m0_l0, d_Rtd_yz_o0_t3_m0_l0, d_Rtd_yz_o0_t4_m0_l0, d_Rtd_yz_o0_t5_m0_l0, d_Rtd_zz_o0_t0_m0_l0, d_Rtd_zz_o0_t1_m0_l0, d_Rtd_zz_o0_t2_m0_l0, d_Rtd_zz_o0_t3_m0_l0, d_Rtd_zz_o0_t4_m0_l0, d_Rtd_zz_o0_t5_m0_l0, d_Rpd_xx_o0_t3_m0_l0, d_Rpd_xx_o0_t4_m0_l0, d_Rpd_xx_o0_t5_m0_l0, d_Rpd_xx_o0_t6_m0_l0, d_Rpd_xx_o0_t7_m0_l0, d_Rpd_xx_o0_t8_m0_l0, m_Ctd_yyz_o0_t0_l0_p, Ctd_yyz_p, m_Ctd_yyy_o0_t0_l0_p, Ctd_yyy_p, div_Beta_p, m_Ctd_xxz_o0_t0_l0_p, Ctd_xxz_p, m_Ctd_xxx_o0_t0_l0_p, Ctd_xxx_p, m_Ctd_yzz_o0_t1_l0_p, m_Ctd_yzz_o0_t0_l0_p, Ctd_yzz_p, m_Ctd_xxy_o0_t0_l0_p, Ctd_xxy_p, sfmass_p, dVdphe2_p, kappa_z2_p, m_Ctd_xyy_o0_t1_l0_p, m_Ctd_xyy_o0_t0_l0_p, Ctd_xyy_p, m_Ctd_xyz_o0_t2_l0_p, m_Ctd_xyz_o0_t1_l0_p, m_Ctd_xyz_o0_t0_l0_p, Ctd_xyz_p, d_div_Beta_y_p, d_div_Beta_x_p, d_div_Beta_z_p, m_Ctd_xzz_o0_t1_l0_p, m_Ctd_xzz_o0_t0_l0_p, Ctd_xzz_p, dVdphi2_p, d_d_phiI4d_t_o0_t0_m0_l0_p, m_d_phiI4d_t_o0_t6_l0_p, m_d_phiI4d_t_o0_t5_l0_p, m_d_phiI4d_t_o0_t4_l0_p, m_d_phiI4d_t_o0_t3_l0_p, m_d_phiI4d_t_o0_t2_l0_p, m_d_phiI4d_t_o0_t1_l0_p, d_phiI4d_t_p, d_phiI4d_x_p, d_phiI4d_y_p, d_phiI4d_z_p, g4u_tx_p, g4u_tz_p, g4u_ty_p, g4u_tt_p, d_phiI4u_t_p, sfVe_p, sfVi_p, m_Ctd_zxz_o0_t0_l0_p, Ctd_zxz_p, m_Ctd_zxx_o0_t1_l0_p, m_Ctd_zxx_o0_t0_l0_p, Ctd_zxx_p, detgtd_p, d_d_phiR4d_t_o0_t0_m0_l0_p, m_d_phiR4d_t_o0_t6_l0_p, m_d_phiR4d_t_o0_t5_l0_p, m_d_phiR4d_t_o0_t4_l0_p, m_d_phiR4d_t_o0_t3_l0_p, m_d_phiR4d_t_o0_t2_l0_p, m_d_phiR4d_t_o0_t1_l0_p, d_phiR4d_t_p, d_phiR4d_x_p, d_phiR4d_z_p, d_phiR4d_y_p, d_phiR4u_t_p, chi_max_p, inv_chi_p, d_d_pheR4d_t_o0_t0_m0_l0_p, m_d_pheR4d_t_o0_t6_l0_p, m_d_pheR4d_t_o0_t5_l0_p, m_d_pheR4d_t_o0_t4_l0_p, m_d_pheR4d_t_o0_t3_l0_p, m_d_pheR4d_t_o0_t2_l0_p, m_d_pheR4d_t_o0_t1_l0_p, d_pheR4d_t_p, d_pheR4d_x_p, d_pheR4d_y_p, d_pheR4d_z_p, d_pheR4u_t_p, m_Ctd_zyy_o0_t1_l0_p, m_Ctd_zyy_o0_t0_l0_p, Ctd_zyy_p, m_Ctd_zyz_o0_t0_l0_p, Ctd_zyz_p, Betatd_x_p, Betatd_z_p, Betatd_y_p, idetgtd_p, gtu_zz_p, g4u_zz_p, gtu_yy_p, g4u_yy_p, gtu_yz_p, g4u_yz_p, gtu_xx_p, g4u_xx_p, gtu_xz_p, g4u_xz_p, d_pheR4u_z_p, d_phiR4u_z_p, d_phiI4u_z_p, Ct_zyz_p, Ct_zyy_p, Atud_zx_p, Atud_zz_p, Atud_zy_p, Atu_zz_p, gtu_xy_p, g4u_xy_p, d_pheR4u_x_p, d_pheR4u_y_p, d_phiR4u_y_p, d_phiR4u_x_p, d_phiI4u_y_p, d_phiI4u_x_p, dphi4sq_p, Atud_yy_p, Atud_yx_p, Atud_yz_p, Atu_yz_p, Atu_yy_p, Ct_yyy_p, Ct_yyz_p, Atud_xx_p, trAt_p, Atud_xz_p, Atud_xy_p, Atu_xz_p, Atu_xy_p, Atu_xx_p, decay_factor_p, kappa_z1_p, feta_p, m_Ctd_zzz_o0_t0_l0_p, Ctd_zzz_p, Ct_xzz_p, Ct_zzz_p, Ct_yzz_p, m_Ctd_yxy_o0_t0_l0_p, Ctd_yxy_p, Ct_xyz_p, m_Ctd_yxz_o0_t2_l0_p, m_Ctd_yxz_o0_t0_l0_p, Ctd_yxz_p, Ct_zxz_p, Ct_yxz_p, m_Ctd_zxy_o0_t2_l0_p, Ctd_zxy_p, Ct_zxy_p, Ct_yxy_p, Ct_xxy_p, Ct_xxz_p, Ct_xyy_p, m_Ctd_yxx_o0_t1_l0_p, m_Ctd_yxx_o0_t0_l0_p, Ctd_yxx_p, Ct_zxx_p, Gamt_z_p, Zu_z_p, Ct_yxx_p, Gamt_y_p, Zu_y_p, Ct_xxx_p, Gamt_x_p, Zu_x_p, d_Rtd_xx_o0_t9_m0_l0_p, m_Rtd_xx_o0_t8_l0_p, m_Rtd_xx_o0_t7_l0_p, m_Rtd_xx_o0_t6_l0_p, m_Rtd_xx_o0_t5_l0_p, m_Rtd_xx_o0_t4_l0_p, m_Rtd_xx_o0_t3_l0_p, m_Rtd_xx_o0_t2_l0_p, m_Rtd_xx_o0_t1_l0_p, m_Rtd_xx_o0_t0_l0_p, Rtd_xx_p, d_Rtd_xz_o0_t12_m0_l0_p, m_Rtd_xz_o0_t11_l0_p, m_Rtd_xz_o0_t10_l0_p, m_Rtd_xz_o0_t9_l0_p, m_Rtd_xz_o0_t8_l0_p, m_Rtd_xz_o0_t7_l0_p, m_Rtd_xz_o0_t6_l0_p, m_Rtd_xz_o0_t5_l0_p, m_Rtd_xz_o0_t4_l0_p, m_Rtd_xz_o0_t3_l0_p, m_Rtd_xz_o0_t2_l0_p, m_Rtd_xz_o0_t1_l0_p, m_Rtd_xz_o0_t0_l0_p, Rtd_xz_p, d_Rtd_zz_o0_t9_m0_l0_p, m_Rtd_zz_o0_t8_l0_p, m_Rtd_zz_o0_t7_l0_p, m_Rtd_zz_o0_t6_l0_p, m_Rtd_zz_o0_t5_l0_p, m_Rtd_zz_o0_t4_l0_p, m_Rtd_zz_o0_t3_l0_p, m_Rtd_zz_o0_t2_l0_p, m_Rtd_zz_o0_t1_l0_p, m_Rtd_zz_o0_t0_l0_p, Rtd_zz_p, d_Rtd_xy_o0_t12_m0_l0_p, m_Rtd_xy_o0_t11_l0_p, m_Rtd_xy_o0_t10_l0_p, m_Rtd_xy_o0_t9_l0_p, m_Rtd_xy_o0_t8_l0_p, m_Rtd_xy_o0_t7_l0_p, m_Rtd_xy_o0_t6_l0_p, m_Rtd_xy_o0_t5_l0_p, m_Rtd_xy_o0_t4_l0_p, m_Rtd_xy_o0_t3_l0_p, m_Rtd_xy_o0_t2_l0_p, m_Rtd_xy_o0_t1_l0_p, m_Rtd_xy_o0_t0_l0_p, Rtd_xy_p, d_Rtd_yy_o0_t9_m0_l0_p, m_Rtd_yy_o0_t8_l0_p, m_Rtd_yy_o0_t7_l0_p, m_Rtd_yy_o0_t6_l0_p, m_Rtd_yy_o0_t5_l0_p, m_Rtd_yy_o0_t4_l0_p, m_Rtd_yy_o0_t3_l0_p, m_Rtd_yy_o0_t2_l0_p, m_Rtd_yy_o0_t1_l0_p, m_Rtd_yy_o0_t0_l0_p, Rtd_yy_p, d_Rtd_yz_o0_t12_m0_l0_p, m_Rtd_yz_o0_t11_l0_p, m_Rtd_yz_o0_t10_l0_p, m_Rtd_yz_o0_t9_l0_p, m_Rtd_yz_o0_t8_l0_p, m_Rtd_yz_o0_t7_l0_p, m_Rtd_yz_o0_t6_l0_p, m_Rtd_yz_o0_t5_l0_p, m_Rtd_yz_o0_t4_l0_p, m_Rtd_yz_o0_t3_l0_p, m_Rtd_yz_o0_t2_l0_p, m_Rtd_yz_o0_t1_l0_p, m_Rtd_yz_o0_t0_l0_p, Rtd_yz_p, m_Rpd_xx_o0_t22_l0_p, m_Rpd_xx_o0_t21_l0_p, m_Rpd_xx_o0_t20_l0_p, m_Rpd_xx_o0_t19_l0_p, m_Rpd_xx_o0_t18_l0_p, m_Rpd_xx_o0_t17_l0_p, m_Rpd_xx_o0_t16_l0_p, m_Rpd_xx_o0_t15_l0_p, m_Rpd_xx_o0_t14_l0_p, m_Rpd_xx_o0_t13_l0_p, m_Rpd_xx_o0_t12_l0_p, m_Rpd_xx_o0_t11_l0_p, m_Rpd_xx_o0_t10_l0_p, m_Rpd_xx_o0_t9_l0_p, m_Rpd_xx_o0_t8_l0_p, m_Rpd_xx_o0_t7_l0_p, m_Rpd_xx_o0_t6_l0_p, m_Rpd_xx_o0_t5_l0_p, m_Rpd_xx_o0_t4_l0_p, m_Rpd_xx_o0_t3_l0_p, m_Rpd_xx_o0_t2_l0_p, m_Rpd_xx_o0_t1_l0_p, m_Rpd_xx_o0_t0_l0_p, Rpd_xx_p, m_Rpd_yy_o0_t22_l0_p, m_Rpd_yy_o0_t21_l0_p, m_Rpd_yy_o0_t20_l0_p, m_Rpd_yy_o0_t19_l0_p, m_Rpd_yy_o0_t18_l0_p, m_Rpd_yy_o0_t17_l0_p, m_Rpd_yy_o0_t16_l0_p, m_Rpd_yy_o0_t15_l0_p, m_Rpd_yy_o0_t14_l0_p, m_Rpd_yy_o0_t13_l0_p, m_Rpd_yy_o0_t12_l0_p, m_Rpd_yy_o0_t11_l0_p, m_Rpd_yy_o0_t10_l0_p, m_Rpd_yy_o0_t9_l0_p, m_Rpd_yy_o0_t8_l0_p, m_Rpd_yy_o0_t7_l0_p, m_Rpd_yy_o0_t6_l0_p, m_Rpd_yy_o0_t5_l0_p, m_Rpd_yy_o0_t4_l0_p, m_Rpd_yy_o0_t3_l0_p, m_Rpd_yy_o0_t2_l0_p, m_Rpd_yy_o0_t1_l0_p, m_Rpd_yy_o0_t0_l0_p, Rpd_yy_p, m_Rpd_yz_o0_t25_l0_p, m_Rpd_yz_o0_t24_l0_p, m_Rpd_yz_o0_t23_l0_p, m_Rpd_yz_o0_t22_l0_p, m_Rpd_yz_o0_t21_l0_p, m_Rpd_yz_o0_t20_l0_p, m_Rpd_yz_o0_t19_l0_p, m_Rpd_yz_o0_t18_l0_p, m_Rpd_yz_o0_t17_l0_p, m_Rpd_yz_o0_t16_l0_p, m_Rpd_yz_o0_t15_l0_p, m_Rpd_yz_o0_t14_l0_p, m_Rpd_yz_o0_t13_l0_p, m_Rpd_yz_o0_t12_l0_p, m_Rpd_yz_o0_t11_l0_p, m_Rpd_yz_o0_t10_l0_p, m_Rpd_yz_o0_t9_l0_p, m_Rpd_yz_o0_t8_l0_p, m_Rpd_yz_o0_t7_l0_p, m_Rpd_yz_o0_t6_l0_p, m_Rpd_yz_o0_t5_l0_p, m_Rpd_yz_o0_t4_l0_p, m_Rpd_yz_o0_t3_l0_p, m_Rpd_yz_o0_t2_l0_p, m_Rpd_yz_o0_t1_l0_p, m_Rpd_yz_o0_t0_l0_p, Rpd_yz_p, m_Rpd_xz_o0_t25_l0_p, m_Rpd_xz_o0_t24_l0_p, m_Rpd_xz_o0_t23_l0_p, m_Rpd_xz_o0_t22_l0_p, m_Rpd_xz_o0_t21_l0_p, m_Rpd_xz_o0_t20_l0_p, m_Rpd_xz_o0_t19_l0_p, m_Rpd_xz_o0_t18_l0_p, m_Rpd_xz_o0_t17_l0_p, m_Rpd_xz_o0_t16_l0_p, m_Rpd_xz_o0_t15_l0_p, m_Rpd_xz_o0_t14_l0_p, m_Rpd_xz_o0_t13_l0_p, m_Rpd_xz_o0_t12_l0_p, m_Rpd_xz_o0_t11_l0_p, m_Rpd_xz_o0_t10_l0_p, m_Rpd_xz_o0_t9_l0_p, m_Rpd_xz_o0_t8_l0_p, m_Rpd_xz_o0_t7_l0_p, m_Rpd_xz_o0_t6_l0_p, m_Rpd_xz_o0_t5_l0_p, m_Rpd_xz_o0_t4_l0_p, m_Rpd_xz_o0_t3_l0_p, m_Rpd_xz_o0_t2_l0_p, m_Rpd_xz_o0_t1_l0_p, m_Rpd_xz_o0_t0_l0_p, Rpd_xz_p, m_Rpd_xy_o0_t25_l0_p, m_Rpd_xy_o0_t24_l0_p, m_Rpd_xy_o0_t23_l0_p, m_Rpd_xy_o0_t22_l0_p, m_Rpd_xy_o0_t21_l0_p, m_Rpd_xy_o0_t20_l0_p, m_Rpd_xy_o0_t19_l0_p, m_Rpd_xy_o0_t18_l0_p, m_Rpd_xy_o0_t17_l0_p, m_Rpd_xy_o0_t16_l0_p, m_Rpd_xy_o0_t15_l0_p, m_Rpd_xy_o0_t14_l0_p, m_Rpd_xy_o0_t13_l0_p, m_Rpd_xy_o0_t12_l0_p, m_Rpd_xy_o0_t11_l0_p, m_Rpd_xy_o0_t10_l0_p, m_Rpd_xy_o0_t9_l0_p, m_Rpd_xy_o0_t8_l0_p, m_Rpd_xy_o0_t7_l0_p, m_Rpd_xy_o0_t6_l0_p, m_Rpd_xy_o0_t5_l0_p, m_Rpd_xy_o0_t4_l0_p, m_Rpd_xy_o0_t3_l0_p, m_Rpd_xy_o0_t2_l0_p, m_Rpd_xy_o0_t1_l0_p, m_Rpd_xy_o0_t0_l0_p, Rpd_xy_p, m_Rpd_zz_o0_t22_l0_p, m_Rpd_zz_o0_t21_l0_p, m_Rpd_zz_o0_t20_l0_p, m_Rpd_zz_o0_t19_l0_p, m_Rpd_zz_o0_t18_l0_p, m_Rpd_zz_o0_t17_l0_p, m_Rpd_zz_o0_t16_l0_p, m_Rpd_zz_o0_t15_l0_p, m_Rpd_zz_o0_t14_l0_p, m_Rpd_zz_o0_t13_l0_p, m_Rpd_zz_o0_t12_l0_p, m_Rpd_zz_o0_t11_l0_p, m_Rpd_zz_o0_t10_l0_p, m_Rpd_zz_o0_t9_l0_p, m_Rpd_zz_o0_t8_l0_p, m_Rpd_zz_o0_t7_l0_p, m_Rpd_zz_o0_t6_l0_p, m_Rpd_zz_o0_t5_l0_p, m_Rpd_zz_o0_t4_l0_p, m_Rpd_zz_o0_t3_l0_p, m_Rpd_zz_o0_t2_l0_p, m_Rpd_zz_o0_t1_l0_p, m_Rpd_zz_o0_t0_l0_p, Rpd_zz_p, Rscalar_p, d_d_pheI4d_t_o0_t0_m0_l0_p, m_d_pheI4d_t_o0_t6_l0_p, m_d_pheI4d_t_o0_t5_l0_p, m_d_pheI4d_t_o0_t4_l0_p, m_d_pheI4d_t_o0_t3_l0_p, m_d_pheI4d_t_o0_t2_l0_p, m_d_pheI4d_t_o0_t1_l0_p, d_pheI4d_t_p, d_pheI4d_z_p, d_pheI4d_y_p, d_pheI4d_x_p, d_pheI4u_t_p, d_pheI4u_z_p, d_pheI4u_y_p, d_pheI4u_x_p, dphe4sq_p, Tsfu_zz_p, Tu_zz_p, Tsfu_yz_p, Tu_yz_p, Tsfu_yy_p, Tu_yy_p, Tsfu_xz_p, Tu_xz_p, Tsfu_xy_p, Tu_xy_p, Tsfu_xx_p, Tu_xx_p, Tsfu_tt_p, Tu_tt_p, Tsfu_tz_p, Tu_tz_p, Tsfu_ty_p, Tu_ty_p, Tsfu_tx_p, Tu_tx_p, pTtd_ADM_xz_p, pTtd_ADM_xy_p, pTtd_ADM_xx_p, d_Psi1_xx_o0_t5_m0_l0_p, m_Psi1_xx_o0_t4_l0_p, m_Psi1_xx_o0_t3_l0_p, m_Psi1_xx_o0_t2_l0_p, m_Psi1_xx_o0_t1_l0_p, m_Psi1_xx_o0_t0_l0_p, Psi1_xx_p, d_Psi1_xy_o0_t6_m0_l0_p, m_Psi1_xy_o0_t5_l0_p, m_Psi1_xy_o0_t4_l0_p, m_Psi1_xy_o0_t3_l0_p, m_Psi1_xy_o0_t2_l0_p, m_Psi1_xy_o0_t1_l0_p, m_Psi1_xy_o0_t0_l0_p, Psi1_xy_p, d_Psi1_xz_o0_t6_m0_l0_p, m_Psi1_xz_o0_t5_l0_p, m_Psi1_xz_o0_t4_l0_p, m_Psi1_xz_o0_t3_l0_p, m_Psi1_xz_o0_t2_l0_p, m_Psi1_xz_o0_t1_l0_p, m_Psi1_xz_o0_t0_l0_p, Psi1_xz_p, Jtd_ADM_z_p, pTtd_ADM_zz_p, d_Psi1_zz_o0_t5_m0_l0_p, m_Psi1_zz_o0_t4_l0_p, m_Psi1_zz_o0_t3_l0_p, m_Psi1_zz_o0_t2_l0_p, m_Psi1_zz_o0_t1_l0_p, m_Psi1_zz_o0_t0_l0_p, Psi1_zz_p, Jtd_ADM_y_p, Jtd_ADM_x_p, pTtd_ADM_yz_p, d_Psi1_yz_o0_t6_m0_l0_p, m_Psi1_yz_o0_t5_l0_p, m_Psi1_yz_o0_t4_l0_p, m_Psi1_yz_o0_t3_l0_p, m_Psi1_yz_o0_t2_l0_p, m_Psi1_yz_o0_t1_l0_p, m_Psi1_yz_o0_t0_l0_p, Psi1_yz_p, pTtd_ADM_yy_p, tr_pT_p, d_Psi1_yy_o0_t5_m0_l0_p, m_Psi1_yy_o0_t4_l0_p, m_Psi1_yy_o0_t3_l0_p, m_Psi1_yy_o0_t2_l0_p, m_Psi1_yy_o0_t1_l0_p, m_Psi1_yy_o0_t0_l0_p, Psi1_yy_p, trPsi1_p, Psi1TF_yz_p, Psi1TF_yy_p, Psi1TF_xy_p, Psi1TF_xx_p, Psi1TF_xz_p, Psi1TF_zz_p, kappa_cc_p, rho_ADM_p, d_gtd_xx_o2_t3_m0_l0, d_gtd_xy_o2_t6_m0_l0, d_gtd_xz_o2_t6_m0_l0, d_gtd_yy_o2_t3_m0_l0, d_gtd_yz_o2_t6_m0_l0, d_gtd_zz_o2_t3_m0_l0, d_Atd_xx_o2_t3_m0_l0, d_Atd_xy_o2_t6_m0_l0, d_Atd_xz_o2_t6_m0_l0, d_Atd_yy_o2_t3_m0_l0, d_Atd_yz_o2_t6_m0_l0, d_Atd_zz_o2_t3_m0_l0, d_Gamh_x_o2_t24_m0_l0, d_Gamh_y_o2_t24_m0_l0, d_Betau_x_o0_t0_m0_l0, d_Betau_y_o0_t0_m0_l0, d_Betau_z_o0_t0_m0_l0, d_Gamh_z_o2_t24_m0_l0, d_Alpha_o2_t0_m0_l0, d_chi_o2_t0_m0_l0, d_trK_o2_t21_m0_l0, d_theta_o2_t3_m0_l0, d_piR_o2_t27_m0_l0, d_peR_o2_t27_m0_l0, d_piI_o2_t27_m0_l0, d_peI_o2_t27_m0_l0, m_peI_o2_t26_l0, m_peI_o2_t25_l0, m_peI_o2_t24_l0, m_peI_o2_t23_l0, m_peI_o2_t22_l0, m_peI_o2_t21_l0, m_peI_o2_t20_l0, m_peI_o2_t19_l0, m_peI_o2_t18_l0, m_peI_o2_t17_l0, m_peI_o2_t16_l0, m_peI_o2_t15_l0, m_peI_o2_t14_l0, m_peI_o2_t13_l0, m_peI_o2_t12_l0, m_peI_o2_t11_l0, m_peI_o2_t10_l0, m_peI_o2_t9_l0, m_peI_o2_t8_l0, m_peI_o2_t7_l0, m_peI_o2_t6_l0, m_peI_o2_t5_l0, m_peI_o2_t4_l0, m_peI_o2_t3_l0, m_peI_o2_t2_l0, m_peI_o2_t1_l0, m_peI_o2_t0_l0, m_peI_o1_t2_l0, m_peI_o1_t1_l0, m_peI_o1_t0_l0, m_peI_o0_t2_l0, m_peI_o0_t1_l0, m_peI_o0_t0_l0, m_piI_o2_t26_l0, m_piI_o2_t25_l0, m_piI_o2_t24_l0, m_piI_o2_t23_l0, m_piI_o2_t22_l0, m_piI_o2_t21_l0, m_piI_o2_t20_l0, m_piI_o2_t19_l0, m_piI_o2_t18_l0, m_piI_o2_t17_l0, m_piI_o2_t16_l0, m_piI_o2_t15_l0, m_piI_o2_t14_l0, m_piI_o2_t13_l0, m_piI_o2_t12_l0, m_piI_o2_t11_l0, m_piI_o2_t10_l0, m_piI_o2_t9_l0, m_piI_o2_t8_l0, m_piI_o2_t7_l0, m_piI_o2_t6_l0, m_piI_o2_t5_l0, m_piI_o2_t4_l0, m_piI_o2_t3_l0, m_piI_o2_t2_l0, m_piI_o2_t1_l0, m_piI_o2_t0_l0, m_piI_o1_t2_l0, m_piI_o1_t1_l0, m_piI_o1_t0_l0, m_piI_o0_t2_l0, m_piI_o0_t1_l0, m_piI_o0_t0_l0, m_peR_o2_t26_l0, m_peR_o2_t25_l0, m_peR_o2_t24_l0, m_peR_o2_t23_l0, m_peR_o2_t22_l0, m_peR_o2_t21_l0, m_peR_o2_t20_l0, m_peR_o2_t19_l0, m_peR_o2_t18_l0, m_peR_o2_t17_l0, m_peR_o2_t16_l0, m_peR_o2_t15_l0, m_peR_o2_t14_l0, m_peR_o2_t13_l0, m_peR_o2_t12_l0, m_peR_o2_t11_l0, m_peR_o2_t10_l0, m_peR_o2_t9_l0, m_peR_o2_t8_l0, m_peR_o2_t7_l0, m_peR_o2_t6_l0, m_peR_o2_t5_l0, m_peR_o2_t4_l0, m_peR_o2_t3_l0, m_peR_o2_t2_l0, m_peR_o2_t1_l0, m_peR_o2_t0_l0, m_peR_o1_t2_l0, m_peR_o1_t1_l0, m_peR_o1_t0_l0, m_peR_o0_t2_l0, m_peR_o0_t1_l0, m_peR_o0_t0_l0, m_piR_o2_t26_l0, m_piR_o2_t25_l0, m_piR_o2_t24_l0, m_piR_o2_t23_l0, m_piR_o2_t22_l0, m_piR_o2_t21_l0, m_piR_o2_t20_l0, m_piR_o2_t19_l0, m_piR_o2_t18_l0, m_piR_o2_t17_l0, m_piR_o2_t16_l0, m_piR_o2_t15_l0, m_piR_o2_t14_l0, m_piR_o2_t13_l0, m_piR_o2_t12_l0, m_piR_o2_t11_l0, m_piR_o2_t10_l0, m_piR_o2_t9_l0, m_piR_o2_t8_l0, m_piR_o2_t7_l0, m_piR_o2_t6_l0, m_piR_o2_t5_l0, m_piR_o2_t4_l0, m_piR_o2_t3_l0, m_piR_o2_t2_l0, m_piR_o2_t1_l0, m_piR_o2_t0_l0, m_piR_o1_t2_l0, m_piR_o1_t1_l0, m_piR_o1_t0_l0, m_piR_o0_t2_l0, m_piR_o0_t1_l0, m_piR_o0_t0_l0, m_pheI_o1_t2_l0, m_pheI_o1_t1_l0, m_pheI_o1_t0_l0, m_pheI_o0_t2_l0, m_pheI_o0_t1_l0, m_pheI_o0_t0_l0, m_phiI_o1_t2_l0, m_phiI_o1_t1_l0, m_phiI_o1_t0_l0, m_phiI_o0_t2_l0, m_phiI_o0_t1_l0, m_phiI_o0_t0_l0, m_pheR_o1_t2_l0, m_pheR_o1_t1_l0, m_pheR_o1_t0_l0, m_pheR_o0_t2_l0, m_pheR_o0_t1_l0, m_pheR_o0_t0_l0, m_phiR_o1_t2_l0, m_phiR_o1_t1_l0, m_phiR_o1_t0_l0, m_phiR_o0_t2_l0, m_phiR_o0_t1_l0, m_phiR_o0_t0_l0, m_theta_o2_t2_l0, m_theta_o2_t1_l0, m_theta_o2_t0_l0, m_theta_o1_t2_l0, m_theta_o1_t1_l0, m_theta_o1_t0_l0, m_theta_o0_t2_l0, m_theta_o0_t1_l0, m_theta_o0_t0_l0, m_trK_o2_t20_l0, m_trK_o2_t19_l0, m_trK_o2_t18_l0, m_trK_o2_t17_l0, m_trK_o2_t16_l0, m_trK_o2_t15_l0, m_trK_o2_t14_l0, m_trK_o2_t13_l0, m_trK_o2_t12_l0, m_trK_o2_t11_l0, m_trK_o2_t10_l0, m_trK_o2_t9_l0, m_trK_o2_t8_l0, m_trK_o2_t7_l0, m_trK_o2_t6_l0, m_trK_o2_t5_l0, m_trK_o2_t4_l0, m_trK_o2_t3_l0, m_trK_o2_t2_l0, m_trK_o2_t1_l0, m_trK_o2_t0_l0, m_trK_o1_t2_l0, m_trK_o1_t1_l0, m_trK_o1_t0_l0, m_trK_o0_t2_l0, m_trK_o0_t1_l0, m_trK_o0_t0_l0, m_chi_o1_t2_l0, m_chi_o1_t1_l0, m_chi_o1_t0_l0, m_chi_o0_t2_l0, m_chi_o0_t1_l0, m_chi_o0_t0_l0, m_Alpha_o1_t2_l0, m_Alpha_o1_t1_l0, m_Alpha_o1_t0_l0, m_Alpha_o0_t2_l0, m_Alpha_o0_t1_l0, m_Alpha_o0_t0_l0, m_Gamh_z_o2_t23_l0, m_Gamh_z_o2_t22_l0, m_Gamh_z_o2_t21_l0, m_Gamh_z_o2_t20_l0, m_Gamh_z_o2_t19_l0, m_Gamh_z_o2_t18_l0, m_Gamh_z_o2_t17_l0, m_Gamh_z_o2_t16_l0, m_Gamh_z_o2_t15_l0, m_Gamh_z_o2_t14_l0, m_Gamh_z_o2_t13_l0, m_Gamh_z_o2_t12_l0, m_Gamh_z_o2_t11_l0, m_Gamh_z_o2_t10_l0, m_Gamh_z_o2_t9_l0, m_Gamh_z_o2_t8_l0, m_Gamh_z_o2_t7_l0, m_Gamh_z_o2_t6_l0, m_Gamh_z_o2_t5_l0, m_Gamh_z_o2_t4_l0, m_Gamh_z_o2_t3_l0, m_Gamh_z_o2_t2_l0, m_Gamh_z_o2_t1_l0, m_Gamh_z_o2_t0_l0, m_Gamh_z_o1_t2_l0, m_Gamh_z_o1_t1_l0, m_Gamh_z_o1_t0_l0, m_Gamh_z_o0_t2_l0, m_Gamh_z_o0_t1_l0, m_Gamh_z_o0_t0_l0, m_Betau_z_o2_t2_l0, m_Betau_z_o2_t1_l0, m_Betau_z_o2_t0_l0, m_Betau_z_o1_t2_l0, m_Betau_z_o1_t1_l0, m_Betau_z_o1_t0_l0, m_Betau_y_o2_t2_l0, m_Betau_y_o2_t1_l0, m_Betau_y_o2_t0_l0, m_Betau_y_o1_t2_l0, m_Betau_y_o1_t1_l0, m_Betau_y_o1_t0_l0, m_Betau_x_o2_t2_l0, m_Betau_x_o2_t1_l0, m_Betau_x_o2_t0_l0, m_Betau_x_o1_t2_l0, m_Betau_x_o1_t1_l0, m_Betau_x_o1_t0_l0, m_Gamh_y_o2_t23_l0, m_Gamh_y_o2_t22_l0, m_Gamh_y_o2_t21_l0, m_Gamh_y_o2_t20_l0, m_Gamh_y_o2_t19_l0, m_Gamh_y_o2_t18_l0, m_Gamh_y_o2_t17_l0, m_Gamh_y_o2_t16_l0, m_Gamh_y_o2_t15_l0, m_Gamh_y_o2_t14_l0, m_Gamh_y_o2_t13_l0, m_Gamh_y_o2_t12_l0, m_Gamh_y_o2_t11_l0, m_Gamh_y_o2_t10_l0, m_Gamh_y_o2_t9_l0, m_Gamh_y_o2_t8_l0, m_Gamh_y_o2_t7_l0, m_Gamh_y_o2_t6_l0, m_Gamh_y_o2_t5_l0, m_Gamh_y_o2_t4_l0, m_Gamh_y_o2_t3_l0, m_Gamh_y_o2_t2_l0, m_Gamh_y_o2_t1_l0, m_Gamh_y_o2_t0_l0, m_Gamh_y_o1_t2_l0, m_Gamh_y_o1_t1_l0, m_Gamh_y_o1_t0_l0, m_Gamh_y_o0_t2_l0, m_Gamh_y_o0_t1_l0, m_Gamh_y_o0_t0_l0, m_Gamh_x_o2_t23_l0, m_Gamh_x_o2_t22_l0, m_Gamh_x_o2_t21_l0, m_Gamh_x_o2_t20_l0, m_Gamh_x_o2_t19_l0, m_Gamh_x_o2_t18_l0, m_Gamh_x_o2_t17_l0, m_Gamh_x_o2_t16_l0, m_Gamh_x_o2_t15_l0, m_Gamh_x_o2_t14_l0, m_Gamh_x_o2_t13_l0, m_Gamh_x_o2_t12_l0, m_Gamh_x_o2_t11_l0, m_Gamh_x_o2_t10_l0, m_Gamh_x_o2_t9_l0, m_Gamh_x_o2_t8_l0, m_Gamh_x_o2_t7_l0, m_Gamh_x_o2_t6_l0, m_Gamh_x_o2_t5_l0, m_Gamh_x_o2_t4_l0, m_Gamh_x_o2_t3_l0, m_Gamh_x_o2_t2_l0, m_Gamh_x_o2_t1_l0, m_Gamh_x_o2_t0_l0, m_Gamh_x_o1_t2_l0, m_Gamh_x_o1_t1_l0, m_Gamh_x_o1_t0_l0, m_Gamh_x_o0_t2_l0, m_Gamh_x_o0_t1_l0, m_Gamh_x_o0_t0_l0, m_Atd_zz_o2_t2_l0, m_Atd_zz_o2_t1_l0, m_Atd_zz_o2_t0_l0, m_Atd_zz_o1_t2_l0, m_Atd_zz_o1_t1_l0, m_Atd_zz_o1_t0_l0, m_Atd_zz_o0_t2_l0, m_Atd_zz_o0_t1_l0, m_Atd_zz_o0_t0_l0, m_Atd_yz_o2_t5_l0, m_Atd_yz_o2_t4_l0, m_Atd_yz_o2_t3_l0, m_Atd_yz_o2_t2_l0, m_Atd_yz_o2_t1_l0, m_Atd_yz_o2_t0_l0, m_Atd_yz_o1_t2_l0, m_Atd_yz_o1_t1_l0, m_Atd_yz_o1_t0_l0, m_Atd_yz_o0_t2_l0, m_Atd_yz_o0_t1_l0, m_Atd_yz_o0_t0_l0, m_Atd_yy_o2_t2_l0, m_Atd_yy_o2_t1_l0, m_Atd_yy_o2_t0_l0, m_Atd_yy_o1_t2_l0, m_Atd_yy_o1_t1_l0, m_Atd_yy_o1_t0_l0, m_Atd_yy_o0_t2_l0, m_Atd_yy_o0_t1_l0, m_Atd_yy_o0_t0_l0, m_Atd_xz_o2_t5_l0, m_Atd_xz_o2_t4_l0, m_Atd_xz_o2_t3_l0, m_Atd_xz_o2_t2_l0, m_Atd_xz_o2_t1_l0, m_Atd_xz_o2_t0_l0, m_Atd_xz_o1_t2_l0, m_Atd_xz_o1_t1_l0, m_Atd_xz_o1_t0_l0, m_Atd_xz_o0_t2_l0, m_Atd_xz_o0_t1_l0, m_Atd_xz_o0_t0_l0, m_Atd_xy_o2_t5_l0, m_Atd_xy_o2_t4_l0, m_Atd_xy_o2_t3_l0, m_Atd_xy_o2_t2_l0, m_Atd_xy_o2_t1_l0, m_Atd_xy_o2_t0_l0, m_Atd_xy_o1_t2_l0, m_Atd_xy_o1_t1_l0, m_Atd_xy_o1_t0_l0, m_Atd_xy_o0_t2_l0, m_Atd_xy_o0_t1_l0, m_Atd_xy_o0_t0_l0, m_Atd_xx_o2_t2_l0, m_Atd_xx_o2_t1_l0, m_Atd_xx_o2_t0_l0, m_Atd_xx_o1_t2_l0, m_Atd_xx_o1_t1_l0, m_Atd_xx_o1_t0_l0, m_Atd_xx_o0_t2_l0, m_Atd_xx_o0_t1_l0, m_Atd_xx_o0_t0_l0, m_gtd_zz_o2_t2_l0, m_gtd_zz_o2_t1_l0, m_gtd_zz_o2_t0_l0, m_gtd_zz_o1_t2_l0, m_gtd_zz_o1_t1_l0, m_gtd_zz_o1_t0_l0, m_gtd_zz_o0_t2_l0, m_gtd_zz_o0_t1_l0, m_gtd_zz_o0_t0_l0, m_gtd_yz_o2_t5_l0, m_gtd_yz_o2_t4_l0, m_gtd_yz_o2_t3_l0, m_gtd_yz_o2_t2_l0, m_gtd_yz_o2_t1_l0, m_gtd_yz_o2_t0_l0, m_gtd_yz_o1_t2_l0, m_gtd_yz_o1_t1_l0, m_gtd_yz_o1_t0_l0, m_gtd_yz_o0_t2_l0, m_gtd_yz_o0_t1_l0, m_gtd_yz_o0_t0_l0, m_gtd_yy_o2_t2_l0, m_gtd_yy_o2_t1_l0, m_gtd_yy_o2_t0_l0, m_gtd_yy_o1_t2_l0, m_gtd_yy_o1_t1_l0, m_gtd_yy_o1_t0_l0, m_gtd_yy_o0_t2_l0, m_gtd_yy_o0_t1_l0, m_gtd_yy_o0_t0_l0, m_gtd_xz_o2_t5_l0, m_gtd_xz_o2_t4_l0, m_gtd_xz_o2_t3_l0, m_gtd_xz_o2_t2_l0, m_gtd_xz_o2_t1_l0, m_gtd_xz_o2_t0_l0, m_gtd_xz_o1_t2_l0, m_gtd_xz_o1_t1_l0, m_gtd_xz_o1_t0_l0, m_gtd_xz_o0_t2_l0, m_gtd_xz_o0_t1_l0, m_gtd_xz_o0_t0_l0, m_gtd_xy_o2_t5_l0, m_gtd_xy_o2_t4_l0, m_gtd_xy_o2_t3_l0, m_gtd_xy_o2_t2_l0, m_gtd_xy_o2_t1_l0, m_gtd_xy_o2_t0_l0, m_gtd_xy_o1_t2_l0, m_gtd_xy_o1_t1_l0, m_gtd_xy_o1_t0_l0, m_gtd_xy_o0_t2_l0, m_gtd_xy_o0_t1_l0, m_gtd_xy_o0_t0_l0, m_gtd_xx_o2_t2_l0, m_gtd_xx_o2_t1_l0, m_gtd_xx_o2_t0_l0, m_gtd_xx_o1_t2_l0, m_gtd_xx_o1_t1_l0, m_gtd_xx_o1_t0_l0, m_gtd_xx_o0_t2_l0, m_gtd_xx_o0_t1_l0, m_gtd_xx_o0_t0_l0, RHS_gtd_xx, RHS_gtd_xy, RHS_gtd_xz, RHS_gtd_yy, RHS_gtd_yz, RHS_gtd_zz, RHS_Atd_xx, RHS_Atd_xy, RHS_Atd_xz, RHS_Atd_yy, RHS_Atd_yz, RHS_Atd_zz, RHS_Gamh_x, RHS_Gamh_y, RHS_Betau_x, RHS_Betau_y, RHS_Betau_z, RHS_Gamh_z, RHS_Alpha, RHS_chi, RHS_trK, RHS_theta, RHS_phiR, RHS_pheR, RHS_phiI, RHS_pheI, RHS_piR, RHS_peR, RHS_piI, RHS_peI, n_x, n_y, n_z, interaction_index, mod_normal, i_d_Atd_xx_o0_t0_m0_l0, i_d_Atd_xx_o0_t1_m0_l0, i_d_Atd_xx_o0_t2_m0_l0, i_d_Atd_xy_o0_t0_m0_l0, i_d_Atd_xy_o0_t1_m0_l0, i_d_Atd_xy_o0_t2_m0_l0, i_d_Atd_xz_o0_t0_m0_l0, i_d_Atd_xz_o0_t1_m0_l0, i_d_Atd_xz_o0_t2_m0_l0, i_d_Atd_yy_o0_t0_m0_l0, i_d_Atd_yy_o0_t1_m0_l0, i_d_Atd_yy_o0_t2_m0_l0, i_d_Atd_yz_o0_t0_m0_l0, i_d_Atd_yz_o0_t1_m0_l0, i_d_Atd_yz_o0_t2_m0_l0, i_d_Atd_zz_o0_t0_m0_l0, i_d_Atd_zz_o0_t1_m0_l0, i_d_Atd_zz_o0_t2_m0_l0, i_d_piR_o0_t0_m0_l0, i_d_piR_o0_t1_m0_l0, i_d_piR_o0_t2_m0_l0, i_d_peR_o0_t0_m0_l0, i_d_peR_o0_t1_m0_l0, i_d_peR_o0_t2_m0_l0, i_d_piI_o0_t0_m0_l0, i_d_piI_o0_t1_m0_l0, i_d_piI_o0_t2_m0_l0, i_d_peI_o0_t0_m0_l0, i_d_peI_o0_t1_m0_l0, i_d_peI_o0_t2_m0_l0, i_d_gtd_xx_o0_t3_m0_l0, i_d_gtd_xy_o0_t3_m0_l0, i_d_gtd_xz_o0_t3_m0_l0, i_d_gtd_yy_o0_t3_m0_l0, i_d_gtd_yz_o0_t3_m0_l0, i_d_gtd_zz_o0_t3_m0_l0, i_d_Atd_xx_o0_t3_m0_l0, i_d_Atd_xy_o0_t3_m0_l0, i_d_Atd_xz_o0_t3_m0_l0, i_d_Atd_yy_o0_t3_m0_l0, i_d_Atd_yz_o0_t3_m0_l0, i_d_Atd_zz_o0_t3_m0_l0, i_d_Gamh_x_o0_t3_m0_l0, i_d_Gamh_y_o0_t3_m0_l0, i_d_Gamh_z_o0_t3_m0_l0, i_d_Betau_x_o0_t3_m0_l0, i_d_Betau_y_o0_t3_m0_l0, i_d_Betau_z_o0_t3_m0_l0, i_d_Alpha_o0_t3_m0_l0, i_d_chi_o0_t3_m0_l0, i_d_trK_o0_t3_m0_l0, i_d_theta_o0_t3_m0_l0, i_d_phiR_o0_t3_m0_l0, i_d_phiI_o0_t3_m0_l0, i_d_piR_o0_t3_m0_l0, i_d_piI_o0_t3_m0_l0, i_d_pheR_o0_t3_m0_l0, i_d_pheI_o0_t3_m0_l0, i_d_peR_o0_t3_m0_l0, i_d_peI_o0_t3_m0_l0, i_m_gtd_xx_o0_t0_l0, i_m_gtd_xx_o0_t1_l0, i_m_gtd_xx_o0_t2_l0, i_m_gtd_xy_o0_t0_l0, i_m_gtd_xy_o0_t1_l0, i_m_gtd_xy_o0_t2_l0, i_m_gtd_xz_o0_t0_l0, i_m_gtd_xz_o0_t1_l0, i_m_gtd_xz_o0_t2_l0, i_m_gtd_yy_o0_t0_l0, i_m_gtd_yy_o0_t1_l0, i_m_gtd_yy_o0_t2_l0, i_m_gtd_yz_o0_t0_l0, i_m_gtd_yz_o0_t1_l0, i_m_gtd_yz_o0_t2_l0, i_m_gtd_zz_o0_t0_l0, i_m_gtd_zz_o0_t1_l0, i_m_gtd_zz_o0_t2_l0, i_m_Atd_xx_o0_t0_l0, i_m_Atd_xx_o0_t1_l0, i_m_Atd_xx_o0_t2_l0, i_m_Atd_xy_o0_t0_l0, i_m_Atd_xy_o0_t1_l0, i_m_Atd_xy_o0_t2_l0, i_m_Atd_xz_o0_t0_l0, i_m_Atd_xz_o0_t1_l0, i_m_Atd_xz_o0_t2_l0, i_m_Atd_yy_o0_t0_l0, i_m_Atd_yy_o0_t1_l0, i_m_Atd_yy_o0_t2_l0, i_m_Atd_yz_o0_t0_l0, i_m_Atd_yz_o0_t1_l0, i_m_Atd_yz_o0_t2_l0, i_m_Atd_zz_o0_t0_l0, i_m_Atd_zz_o0_t1_l0, i_m_Atd_zz_o0_t2_l0, i_m_Gamh_x_o0_t0_l0, i_m_Gamh_x_o0_t1_l0, i_m_Gamh_x_o0_t2_l0, i_m_Gamh_y_o0_t0_l0, i_m_Gamh_y_o0_t1_l0, i_m_Gamh_y_o0_t2_l0, i_m_Gamh_z_o0_t0_l0, i_m_Gamh_z_o0_t1_l0, i_m_Gamh_z_o0_t2_l0, i_m_Betau_x_o0_t0_l0, i_m_Betau_x_o0_t1_l0, i_m_Betau_x_o0_t2_l0, i_m_Betau_y_o0_t0_l0, i_m_Betau_y_o0_t1_l0, i_m_Betau_y_o0_t2_l0, i_m_Betau_z_o0_t0_l0, i_m_Betau_z_o0_t1_l0, i_m_Betau_z_o0_t2_l0, i_m_Alpha_o0_t0_l0, i_m_Alpha_o0_t1_l0, i_m_Alpha_o0_t2_l0, i_m_chi_o0_t0_l0, i_m_chi_o0_t1_l0, i_m_chi_o0_t2_l0, i_m_trK_o0_t0_l0, i_m_trK_o0_t1_l0, i_m_trK_o0_t2_l0, i_m_theta_o0_t0_l0, i_m_theta_o0_t1_l0, i_m_theta_o0_t2_l0, i_m_phiR_o0_t0_l0, i_m_phiR_o0_t1_l0, i_m_phiR_o0_t2_l0, i_m_phiI_o0_t0_l0, i_m_phiI_o0_t1_l0, i_m_phiI_o0_t2_l0, i_m_piR_o0_t0_l0, i_m_piR_o0_t1_l0, i_m_piR_o0_t2_l0, i_m_piI_o0_t0_l0, i_m_piI_o0_t1_l0, i_m_piI_o0_t2_l0, i_m_pheR_o0_t0_l0, i_m_pheR_o0_t1_l0, i_m_pheR_o0_t2_l0, i_m_pheI_o0_t0_l0, i_m_pheI_o0_t1_l0, i_m_pheI_o0_t2_l0, i_m_peR_o0_t0_l0, i_m_peR_o0_t1_l0, i_m_peR_o0_t2_l0, i_m_peI_o0_t0_l0, i_m_peI_o0_t1_l0, i_m_peI_o0_t2_l0;

				if ((i + 3 <= bx_hi.x && i - 3 >= bx_lo.x && j + 3 <= bx_hi.y && j - 3 >= bx_lo.y && k + 3 <= bx_hi.z && k - 3 >= bx_lo.z)) {
					d_div_Beta_o0_t0_m0_l0 = D1CDO4_i(Betau_x, un, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t0_m0_l0 = lieforward_i(Betau_x, un, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t0_m0_l0 = liebackward_i(Betau_x, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o2_t0_m0_l0 = D1CDO4_j(Betau_x, un, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t1_m0_l0 = lieforward_j(Betau_x, un, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t1_m0_l0 = liebackward_j(Betau_x, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o2_t0_m0_l0 = D1CDO4_k(Betau_x, un, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t2_m0_l0 = lieforward_k(Betau_x, un, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t2_m0_l0 = liebackward_k(Betau_x, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t0_m0_l0 = D2CDO4_i(Betau_x, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t0_m0_l0 = D1CDO4crossed_ij(Betau_x, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t0_m0_l0 = D1CDO4crossed_ik(Betau_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t6_m0_l0 = D2CDO4_j(Betau_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t7_m0_l0 = D1CDO4crossed_jk(Betau_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t8_m0_l0 = D2CDO4_k(Betau_x, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o2_t1_m0_l0 = D1CDO4_i(Betau_y, un, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t0_m0_l0 = lieforward_i(Betau_y, un, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t0_m0_l0 = liebackward_i(Betau_y, un, i, j, k, dx, dt_lev);
					d_div_Beta_o0_t1_m0_l0 = D1CDO4_j(Betau_y, un, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t1_m0_l0 = lieforward_j(Betau_y, un, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t1_m0_l0 = liebackward_j(Betau_y, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o2_t1_m0_l0 = D1CDO4_k(Betau_y, un, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t2_m0_l0 = lieforward_k(Betau_y, un, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t2_m0_l0 = liebackward_k(Betau_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t4_m0_l0 = D2CDO4_i(Betau_y, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t1_m0_l0 = D1CDO4crossed_ij(Betau_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t6_m0_l0 = D1CDO4crossed_ik(Betau_y, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t1_m0_l0 = D2CDO4_j(Betau_y, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t1_m0_l0 = D1CDO4crossed_jk(Betau_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t9_m0_l0 = D2CDO4_k(Betau_y, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o2_t2_m0_l0 = D1CDO4_i(Betau_z, un, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t0_m0_l0 = lieforward_i(Betau_z, un, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t0_m0_l0 = liebackward_i(Betau_z, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o2_t2_m0_l0 = D1CDO4_j(Betau_z, un, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t1_m0_l0 = lieforward_j(Betau_z, un, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t1_m0_l0 = liebackward_j(Betau_z, un, i, j, k, dx, dt_lev);
					d_div_Beta_o0_t2_m0_l0 = D1CDO4_k(Betau_z, un, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t2_m0_l0 = lieforward_k(Betau_z, un, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t2_m0_l0 = liebackward_k(Betau_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t14_m0_l0 = D2CDO4_i(Betau_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t15_m0_l0 = D1CDO4crossed_ij(Betau_z, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t2_m0_l0 = D1CDO4crossed_ik(Betau_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t17_m0_l0 = D2CDO4_j(Betau_z, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t2_m0_l0 = D1CDO4crossed_jk(Betau_z, un, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t2_m0_l0 = D2CDO4_k(Betau_z, un, i, j, k, dx, dt_lev);
					d_Ctd_xxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xx, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t0_m0_l0 = lieforward_i(gtd_xx, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t0_m0_l0 = liebackward_i(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Ctd_xxy_o0_t0_m0_l0 = D1CDO4_j(gtd_xx, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t1_m0_l0 = lieforward_j(gtd_xx, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t1_m0_l0 = liebackward_j(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Ctd_xxz_o0_t0_m0_l0 = D1CDO4_k(gtd_xx, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t2_m0_l0 = lieforward_k(gtd_xx, un, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t2_m0_l0 = liebackward_k(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Ctd_yxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xy, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t0_m0_l0 = lieforward_i(gtd_xy, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t0_m0_l0 = liebackward_i(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Ctd_xyy_o0_t0_m0_l0 = D1CDO4_j(gtd_xy, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t1_m0_l0 = lieforward_j(gtd_xy, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t1_m0_l0 = liebackward_j(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t1_m0_l0 = D1CDO4_k(gtd_xy, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t2_m0_l0 = lieforward_k(gtd_xy, un, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t2_m0_l0 = liebackward_k(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Ctd_xyy_o0_t1_m0_l0 = D1CDO4_i(gtd_yy, un, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t0_m0_l0 = lieforward_i(gtd_yy, un, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t0_m0_l0 = liebackward_i(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Ctd_yyy_o0_t0_m0_l0 = D1CDO4_j(gtd_yy, un, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t1_m0_l0 = lieforward_j(gtd_yy, un, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t1_m0_l0 = liebackward_j(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Ctd_yyz_o0_t0_m0_l0 = D1CDO4_k(gtd_yy, un, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t2_m0_l0 = lieforward_k(gtd_yy, un, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t2_m0_l0 = liebackward_k(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Ctd_zxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xz, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t0_m0_l0 = lieforward_i(gtd_xz, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t0_m0_l0 = liebackward_i(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t0_m0_l0 = D1CDO4_j(gtd_xz, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t1_m0_l0 = lieforward_j(gtd_xz, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t1_m0_l0 = liebackward_j(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Ctd_xzz_o0_t0_m0_l0 = D1CDO4_k(gtd_xz, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t2_m0_l0 = lieforward_k(gtd_xz, un, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t2_m0_l0 = liebackward_k(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t2_m0_l0 = D1CDO4_i(gtd_yz, un, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t0_m0_l0 = lieforward_i(gtd_yz, un, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t0_m0_l0 = liebackward_i(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Ctd_zyy_o0_t0_m0_l0 = D1CDO4_j(gtd_yz, un, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t1_m0_l0 = lieforward_j(gtd_yz, un, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t1_m0_l0 = liebackward_j(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Ctd_yzz_o0_t0_m0_l0 = D1CDO4_k(gtd_yz, un, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t2_m0_l0 = lieforward_k(gtd_yz, un, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t2_m0_l0 = liebackward_k(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Ctd_xzz_o0_t1_m0_l0 = D1CDO4_i(gtd_zz, un, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t0_m0_l0 = lieforward_i(gtd_zz, un, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t0_m0_l0 = liebackward_i(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Ctd_yzz_o0_t1_m0_l0 = D1CDO4_j(gtd_zz, un, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t1_m0_l0 = lieforward_j(gtd_zz, un, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t1_m0_l0 = liebackward_j(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Ctd_zzz_o0_t0_m0_l0 = D1CDO4_k(gtd_zz, un, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t2_m0_l0 = lieforward_k(gtd_zz, un, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t2_m0_l0 = liebackward_k(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t0_m0_l0 = D1CDO4_i(chi, un, i, j, k, dx, dt_lev);
					d_chi_o0_t0_m0_l0 = lieforward_i(chi, un, i, j, k, dx, dt_lev);
					d_chi_o1_t0_m0_l0 = liebackward_i(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t1_m0_l0 = D1CDO4_j(chi, un, i, j, k, dx, dt_lev);
					d_chi_o0_t1_m0_l0 = lieforward_j(chi, un, i, j, k, dx, dt_lev);
					d_chi_o1_t1_m0_l0 = liebackward_j(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t2_m0_l0 = D1CDO4_k(chi, un, i, j, k, dx, dt_lev);
					d_chi_o0_t2_m0_l0 = lieforward_k(chi, un, i, j, k, dx, dt_lev);
					d_chi_o1_t2_m0_l0 = liebackward_k(chi, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t6_m0_l0 = D1CDO4_i(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t0_m0_l0 = lieforward_i(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t0_m0_l0 = liebackward_i(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t6_m0_l0 = D1CDO4_j(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t1_m0_l0 = lieforward_j(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t1_m0_l0 = liebackward_j(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t6_m0_l0 = D1CDO4_k(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t2_m0_l0 = lieforward_k(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t2_m0_l0 = liebackward_k(Gamh_x, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t7_m0_l0 = D1CDO4_i(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t0_m0_l0 = lieforward_i(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t0_m0_l0 = liebackward_i(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t7_m0_l0 = D1CDO4_j(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t1_m0_l0 = lieforward_j(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t1_m0_l0 = liebackward_j(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t7_m0_l0 = D1CDO4_k(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t2_m0_l0 = lieforward_k(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t2_m0_l0 = liebackward_k(Gamh_y, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t8_m0_l0 = D1CDO4_i(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t1_m0_l0 = lieforward_i(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t0_m0_l0 = liebackward_i(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t8_m0_l0 = D1CDO4_j(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t2_m0_l0 = lieforward_j(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t1_m0_l0 = liebackward_j(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t8_m0_l0 = D1CDO4_k(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t0_m0_l0 = lieforward_k(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t2_m0_l0 = liebackward_k(Gamh_z, un, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t1_m0_l0 = D1CDO4_i(Alpha, un, i, j, k, dx, dt_lev);
					d_Alpha_o0_t0_m0_l0 = lieforward_i(Alpha, un, i, j, k, dx, dt_lev);
					d_Alpha_o1_t0_m0_l0 = liebackward_i(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t2_m0_l0 = D1CDO4_j(Alpha, un, i, j, k, dx, dt_lev);
					d_Alpha_o0_t1_m0_l0 = lieforward_j(Alpha, un, i, j, k, dx, dt_lev);
					d_Alpha_o1_t1_m0_l0 = liebackward_j(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t3_m0_l0 = D1CDO4_k(Alpha, un, i, j, k, dx, dt_lev);
					d_Alpha_o0_t2_m0_l0 = lieforward_k(Alpha, un, i, j, k, dx, dt_lev);
					d_Alpha_o1_t2_m0_l0 = liebackward_k(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t0_m0_l0 = D2CDO4_i(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_xy_o0_t0_m0_l0 = D1CDO4crossed_ij(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_xz_o0_t0_m0_l0 = D1CDO4crossed_ik(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_yy_o0_t0_m0_l0 = D2CDO4_j(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_yz_o0_t0_m0_l0 = D1CDO4crossed_jk(Alpha, un, i, j, k, dx, dt_lev);
					d_Psi1_zz_o0_t0_m0_l0 = D2CDO4_k(Alpha, un, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t1_m0_l0 = D1CDO4_i(phiR, un, i, j, k, dx, dt_lev);
					d_phiR_o0_t0_m0_l0 = lieforward_i(phiR, un, i, j, k, dx, dt_lev);
					d_phiR_o1_t0_m0_l0 = liebackward_i(phiR, un, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t2_m0_l0 = D1CDO4_j(phiR, un, i, j, k, dx, dt_lev);
					d_phiR_o0_t1_m0_l0 = lieforward_j(phiR, un, i, j, k, dx, dt_lev);
					d_phiR_o1_t1_m0_l0 = liebackward_j(phiR, un, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t3_m0_l0 = D1CDO4_k(phiR, un, i, j, k, dx, dt_lev);
					d_phiR_o0_t2_m0_l0 = lieforward_k(phiR, un, i, j, k, dx, dt_lev);
					d_phiR_o1_t2_m0_l0 = liebackward_k(phiR, un, i, j, k, dx, dt_lev);
					d_piR_o2_t26_m0_l0 = D2CDO4_i(phiR, un, i, j, k, dx, dt_lev);
					d_piR_o2_t0_m0_l0 = D1CDO4crossed_ij(phiR, un, i, j, k, dx, dt_lev);
					d_piR_o2_t1_m0_l0 = D1CDO4crossed_ik(phiR, un, i, j, k, dx, dt_lev);
					d_piR_o2_t2_m0_l0 = D2CDO4_j(phiR, un, i, j, k, dx, dt_lev);
					d_piR_o2_t3_m0_l0 = D1CDO4crossed_jk(phiR, un, i, j, k, dx, dt_lev);
					d_piR_o2_t4_m0_l0 = D2CDO4_k(phiR, un, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t1_m0_l0 = D1CDO4_i(phiI, un, i, j, k, dx, dt_lev);
					d_phiI_o0_t0_m0_l0 = lieforward_i(phiI, un, i, j, k, dx, dt_lev);
					d_phiI_o1_t0_m0_l0 = liebackward_i(phiI, un, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t2_m0_l0 = D1CDO4_j(phiI, un, i, j, k, dx, dt_lev);
					d_phiI_o0_t1_m0_l0 = lieforward_j(phiI, un, i, j, k, dx, dt_lev);
					d_phiI_o1_t1_m0_l0 = liebackward_j(phiI, un, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t3_m0_l0 = D1CDO4_k(phiI, un, i, j, k, dx, dt_lev);
					d_phiI_o0_t2_m0_l0 = lieforward_k(phiI, un, i, j, k, dx, dt_lev);
					d_phiI_o1_t2_m0_l0 = liebackward_k(phiI, un, i, j, k, dx, dt_lev);
					d_piI_o2_t24_m0_l0 = D2CDO4_i(phiI, un, i, j, k, dx, dt_lev);
					d_piI_o2_t25_m0_l0 = D1CDO4crossed_ij(phiI, un, i, j, k, dx, dt_lev);
					d_piI_o2_t26_m0_l0 = D1CDO4crossed_ik(phiI, un, i, j, k, dx, dt_lev);
					d_piI_o2_t0_m0_l0 = D2CDO4_j(phiI, un, i, j, k, dx, dt_lev);
					d_piI_o2_t1_m0_l0 = D1CDO4crossed_jk(phiI, un, i, j, k, dx, dt_lev);
					d_piI_o2_t2_m0_l0 = D2CDO4_k(phiI, un, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t1_m0_l0 = D1CDO4_i(pheR, un, i, j, k, dx, dt_lev);
					d_pheR_o0_t0_m0_l0 = lieforward_i(pheR, un, i, j, k, dx, dt_lev);
					d_pheR_o1_t0_m0_l0 = liebackward_i(pheR, un, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t2_m0_l0 = D1CDO4_j(pheR, un, i, j, k, dx, dt_lev);
					d_pheR_o0_t1_m0_l0 = lieforward_j(pheR, un, i, j, k, dx, dt_lev);
					d_pheR_o1_t1_m0_l0 = liebackward_j(pheR, un, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t3_m0_l0 = D1CDO4_k(pheR, un, i, j, k, dx, dt_lev);
					d_pheR_o0_t2_m0_l0 = lieforward_k(pheR, un, i, j, k, dx, dt_lev);
					d_pheR_o1_t2_m0_l0 = liebackward_k(pheR, un, i, j, k, dx, dt_lev);
					d_peR_o2_t24_m0_l0 = D2CDO4_i(pheR, un, i, j, k, dx, dt_lev);
					d_peR_o2_t25_m0_l0 = D1CDO4crossed_ij(pheR, un, i, j, k, dx, dt_lev);
					d_peR_o2_t26_m0_l0 = D1CDO4crossed_ik(pheR, un, i, j, k, dx, dt_lev);
					d_peR_o2_t0_m0_l0 = D2CDO4_j(pheR, un, i, j, k, dx, dt_lev);
					d_peR_o2_t1_m0_l0 = D1CDO4crossed_jk(pheR, un, i, j, k, dx, dt_lev);
					d_peR_o2_t2_m0_l0 = D2CDO4_k(pheR, un, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t1_m0_l0 = D1CDO4_i(pheI, un, i, j, k, dx, dt_lev);
					d_pheI_o0_t0_m0_l0 = lieforward_i(pheI, un, i, j, k, dx, dt_lev);
					d_pheI_o1_t0_m0_l0 = liebackward_i(pheI, un, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t2_m0_l0 = D1CDO4_j(pheI, un, i, j, k, dx, dt_lev);
					d_pheI_o0_t1_m0_l0 = lieforward_j(pheI, un, i, j, k, dx, dt_lev);
					d_pheI_o1_t1_m0_l0 = liebackward_j(pheI, un, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t3_m0_l0 = D1CDO4_k(pheI, un, i, j, k, dx, dt_lev);
					d_pheI_o0_t2_m0_l0 = lieforward_k(pheI, un, i, j, k, dx, dt_lev);
					d_pheI_o1_t2_m0_l0 = liebackward_k(pheI, un, i, j, k, dx, dt_lev);
					d_peI_o2_t22_m0_l0 = D2CDO4_i(pheI, un, i, j, k, dx, dt_lev);
					d_peI_o2_t23_m0_l0 = D1CDO4crossed_ij(pheI, un, i, j, k, dx, dt_lev);
					d_peI_o2_t24_m0_l0 = D1CDO4crossed_ik(pheI, un, i, j, k, dx, dt_lev);
					d_peI_o2_t25_m0_l0 = D2CDO4_j(pheI, un, i, j, k, dx, dt_lev);
					d_peI_o2_t26_m0_l0 = D1CDO4crossed_jk(pheI, un, i, j, k, dx, dt_lev);
					d_peI_o2_t0_m0_l0 = D2CDO4_k(pheI, un, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t0_m0_l0 = lieforward_i(Atd_xx, un, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t0_m0_l0 = liebackward_i(Atd_xx, un, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t1_m0_l0 = lieforward_j(Atd_xx, un, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t1_m0_l0 = liebackward_j(Atd_xx, un, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t2_m0_l0 = lieforward_k(Atd_xx, un, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t2_m0_l0 = liebackward_k(Atd_xx, un, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t0_m0_l0 = lieforward_i(Atd_xy, un, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t0_m0_l0 = liebackward_i(Atd_xy, un, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t1_m0_l0 = lieforward_j(Atd_xy, un, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t1_m0_l0 = liebackward_j(Atd_xy, un, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t2_m0_l0 = lieforward_k(Atd_xy, un, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t2_m0_l0 = liebackward_k(Atd_xy, un, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t0_m0_l0 = lieforward_i(Atd_xz, un, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t0_m0_l0 = liebackward_i(Atd_xz, un, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t1_m0_l0 = lieforward_j(Atd_xz, un, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t1_m0_l0 = liebackward_j(Atd_xz, un, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t2_m0_l0 = lieforward_k(Atd_xz, un, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t2_m0_l0 = liebackward_k(Atd_xz, un, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t0_m0_l0 = lieforward_i(Atd_yy, un, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t0_m0_l0 = liebackward_i(Atd_yy, un, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t1_m0_l0 = lieforward_j(Atd_yy, un, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t1_m0_l0 = liebackward_j(Atd_yy, un, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t2_m0_l0 = lieforward_k(Atd_yy, un, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t2_m0_l0 = liebackward_k(Atd_yy, un, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t0_m0_l0 = lieforward_i(Atd_yz, un, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t0_m0_l0 = liebackward_i(Atd_yz, un, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t1_m0_l0 = lieforward_j(Atd_yz, un, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t1_m0_l0 = liebackward_j(Atd_yz, un, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t2_m0_l0 = lieforward_k(Atd_yz, un, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t2_m0_l0 = liebackward_k(Atd_yz, un, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t0_m0_l0 = lieforward_i(Atd_zz, un, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t0_m0_l0 = liebackward_i(Atd_zz, un, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t1_m0_l0 = lieforward_j(Atd_zz, un, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t1_m0_l0 = liebackward_j(Atd_zz, un, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t2_m0_l0 = lieforward_k(Atd_zz, un, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t2_m0_l0 = liebackward_k(Atd_zz, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t12_m0_l0 = D1CDO4_i(trK, un, i, j, k, dx, dt_lev);
					d_trK_o0_t0_m0_l0 = lieforward_i(trK, un, i, j, k, dx, dt_lev);
					d_trK_o1_t0_m0_l0 = liebackward_i(trK, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t13_m0_l0 = D1CDO4_j(trK, un, i, j, k, dx, dt_lev);
					d_trK_o0_t1_m0_l0 = lieforward_j(trK, un, i, j, k, dx, dt_lev);
					d_trK_o1_t1_m0_l0 = liebackward_j(trK, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t14_m0_l0 = D1CDO4_k(trK, un, i, j, k, dx, dt_lev);
					d_trK_o0_t2_m0_l0 = lieforward_k(trK, un, i, j, k, dx, dt_lev);
					d_trK_o1_t2_m0_l0 = liebackward_k(trK, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t15_m0_l0 = D1CDO4_i(theta, un, i, j, k, dx, dt_lev);
					d_theta_o0_t0_m0_l0 = lieforward_i(theta, un, i, j, k, dx, dt_lev);
					d_theta_o1_t0_m0_l0 = liebackward_i(theta, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t16_m0_l0 = D1CDO4_j(theta, un, i, j, k, dx, dt_lev);
					d_theta_o0_t1_m0_l0 = lieforward_j(theta, un, i, j, k, dx, dt_lev);
					d_theta_o1_t1_m0_l0 = liebackward_j(theta, un, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t17_m0_l0 = D1CDO4_k(theta, un, i, j, k, dx, dt_lev);
					d_theta_o0_t2_m0_l0 = lieforward_k(theta, un, i, j, k, dx, dt_lev);
					d_theta_o1_t2_m0_l0 = liebackward_k(theta, un, i, j, k, dx, dt_lev);
					d_piR_o0_t0_m0_l0 = lieforward_i(piR, un, i, j, k, dx, dt_lev);
					d_piR_o1_t0_m0_l0 = liebackward_i(piR, un, i, j, k, dx, dt_lev);
					d_piR_o0_t1_m0_l0 = lieforward_j(piR, un, i, j, k, dx, dt_lev);
					d_piR_o1_t1_m0_l0 = liebackward_j(piR, un, i, j, k, dx, dt_lev);
					d_piR_o0_t2_m0_l0 = lieforward_k(piR, un, i, j, k, dx, dt_lev);
					d_piR_o1_t2_m0_l0 = liebackward_k(piR, un, i, j, k, dx, dt_lev);
					d_peR_o0_t0_m0_l0 = lieforward_i(peR, un, i, j, k, dx, dt_lev);
					d_peR_o1_t0_m0_l0 = liebackward_i(peR, un, i, j, k, dx, dt_lev);
					d_peR_o0_t1_m0_l0 = lieforward_j(peR, un, i, j, k, dx, dt_lev);
					d_peR_o1_t1_m0_l0 = liebackward_j(peR, un, i, j, k, dx, dt_lev);
					d_peR_o0_t2_m0_l0 = lieforward_k(peR, un, i, j, k, dx, dt_lev);
					d_peR_o1_t2_m0_l0 = liebackward_k(peR, un, i, j, k, dx, dt_lev);
					d_piI_o0_t0_m0_l0 = lieforward_i(piI, un, i, j, k, dx, dt_lev);
					d_piI_o1_t0_m0_l0 = liebackward_i(piI, un, i, j, k, dx, dt_lev);
					d_piI_o0_t1_m0_l0 = lieforward_j(piI, un, i, j, k, dx, dt_lev);
					d_piI_o1_t1_m0_l0 = liebackward_j(piI, un, i, j, k, dx, dt_lev);
					d_piI_o0_t2_m0_l0 = lieforward_k(piI, un, i, j, k, dx, dt_lev);
					d_piI_o1_t2_m0_l0 = liebackward_k(piI, un, i, j, k, dx, dt_lev);
					d_peI_o0_t0_m0_l0 = lieforward_i(peI, un, i, j, k, dx, dt_lev);
					d_peI_o1_t2_m0_l0 = liebackward_i(peI, un, i, j, k, dx, dt_lev);
					d_peI_o0_t1_m0_l0 = lieforward_j(peI, un, i, j, k, dx, dt_lev);
					d_peI_o1_t0_m0_l0 = liebackward_j(peI, un, i, j, k, dx, dt_lev);
					d_peI_o0_t2_m0_l0 = lieforward_k(peI, un, i, j, k, dx, dt_lev);
					d_peI_o1_t1_m0_l0 = liebackward_k(peI, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t0_m0_l0 = D2CDO4_i(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t3_m0_l0 = D2CDO4_j(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t5_m0_l0 = D2CDO4_k(gtd_xx, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t0_m0_l0 = D2CDO4_i(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t3_m0_l0 = D2CDO4_j(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t5_m0_l0 = D2CDO4_k(gtd_xy, un, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t0_m0_l0 = D2CDO4_i(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t3_m0_l0 = D2CDO4_j(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t5_m0_l0 = D2CDO4_k(gtd_yy, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t0_m0_l0 = D2CDO4_i(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t3_m0_l0 = D2CDO4_j(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t5_m0_l0 = D2CDO4_k(gtd_xz, un, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t0_m0_l0 = D2CDO4_i(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t3_m0_l0 = D2CDO4_j(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t5_m0_l0 = D2CDO4_k(gtd_yz, un, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t0_m0_l0 = D2CDO4_i(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t3_m0_l0 = D2CDO4_j(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t5_m0_l0 = D2CDO4_k(gtd_zz, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t3_m0_l0 = D2CDO4_i(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t4_m0_l0 = D1CDO4crossed_ij(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t5_m0_l0 = D1CDO4crossed_ik(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t6_m0_l0 = D2CDO4_j(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t7_m0_l0 = D1CDO4crossed_jk(chi, un, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t8_m0_l0 = D2CDO4_k(chi, un, i, j, k, dx, dt_lev);
					m_Ctd_yyz_o0_t0_l0_p = .5 * d_Ctd_yyz_o0_t0_m0_l0;
					Ctd_yyz_p = m_Ctd_yyz_o0_t0_l0_p;
					m_Ctd_yyy_o0_t0_l0_p = .5 * d_Ctd_yyy_o0_t0_m0_l0;
					Ctd_yyy_p = m_Ctd_yyy_o0_t0_l0_p;
					div_Beta_p = (d_div_Beta_o0_t0_m0_l0 + d_div_Beta_o0_t1_m0_l0) + d_div_Beta_o0_t2_m0_l0;
					m_Ctd_xxz_o0_t0_l0_p = .5 * d_Ctd_xxz_o0_t0_m0_l0;
					Ctd_xxz_p = m_Ctd_xxz_o0_t0_l0_p;
					m_Ctd_xxx_o0_t0_l0_p = .5 * d_Ctd_xxx_o0_t0_m0_l0;
					Ctd_xxx_p = m_Ctd_xxx_o0_t0_l0_p;
					m_Ctd_yzz_o0_t1_l0_p = (-.5) * d_Ctd_yzz_o0_t1_m0_l0;
					m_Ctd_yzz_o0_t0_l0_p = 1.0 * d_Ctd_yzz_o0_t0_m0_l0;
					Ctd_yzz_p = m_Ctd_yzz_o0_t0_l0_p + m_Ctd_yzz_o0_t1_l0_p;
					m_Ctd_xxy_o0_t0_l0_p = .5 * d_Ctd_xxy_o0_t0_m0_l0;
					Ctd_xxy_p = m_Ctd_xxy_o0_t0_l0_p;
					sfmass_p = parameters.p_sfmass;
					dVdphe2_p = (sfmass_p * sfmass_p) * ((1.0 - 2.0 * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) + (-4.0 * ((sfmass_p * sfmass_p) * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) * (1.0 - 2.0 * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) / (parameters.sfsigma * parameters.sfsigma)) + parameters.sflambda * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI));
					kappa_z2_p = parameters.p_kappa_z2;
					m_Ctd_xyy_o0_t1_l0_p = (-.5) * d_Ctd_xyy_o0_t1_m0_l0;
					m_Ctd_xyy_o0_t0_l0_p = 1.0 * d_Ctd_xyy_o0_t0_m0_l0;
					Ctd_xyy_p = m_Ctd_xyy_o0_t0_l0_p + m_Ctd_xyy_o0_t1_l0_p;
					m_Ctd_xyz_o0_t2_l0_p = (-.5) * d_Ctd_xyz_o0_t2_m0_l0;
					m_Ctd_xyz_o0_t1_l0_p = .5 * d_Ctd_xyz_o0_t1_m0_l0;
					m_Ctd_xyz_o0_t0_l0_p = .5 * d_Ctd_xyz_o0_t0_m0_l0;
					Ctd_xyz_p = (m_Ctd_xyz_o0_t0_l0_p + m_Ctd_xyz_o0_t1_l0_p) + m_Ctd_xyz_o0_t2_l0_p;
					d_div_Beta_y_p = (d_d_div_Beta_y_o0_t0_m0_l0 + d_d_div_Beta_y_o0_t1_m0_l0) + d_d_div_Beta_y_o0_t2_m0_l0;
					d_div_Beta_x_p = (d_d_div_Beta_x_o0_t0_m0_l0 + d_d_div_Beta_x_o0_t1_m0_l0) + d_d_div_Beta_x_o0_t2_m0_l0;
					d_div_Beta_z_p = (d_d_div_Beta_z_o0_t0_m0_l0 + d_d_div_Beta_z_o0_t1_m0_l0) + d_d_div_Beta_z_o0_t2_m0_l0;
					m_Ctd_xzz_o0_t1_l0_p = (-.5) * d_Ctd_xzz_o0_t1_m0_l0;
					m_Ctd_xzz_o0_t0_l0_p = 1.0 * d_Ctd_xzz_o0_t0_m0_l0;
					Ctd_xzz_p = m_Ctd_xzz_o0_t0_l0_p + m_Ctd_xzz_o0_t1_l0_p;
					dVdphi2_p = (sfmass_p * sfmass_p) * ((1.0 - 2.0 * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) + (-4.0 * ((sfmass_p * sfmass_p) * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) * (1.0 - 2.0 * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) / (parameters.sfsigma * parameters.sfsigma)) + parameters.sflambda * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI));
					d_d_phiI4d_t_o0_t0_m0_l0_p = -un(i, j, k, Alpha) * un(i, j, k, piI);
					m_d_phiI4d_t_o0_t6_l0_p = std::min(0.0, un(i, j, k, Betau_z)) * d_d_phiI4d_t_o0_t3_m0_l0;
					m_d_phiI4d_t_o0_t5_l0_p = std::min(0.0, un(i, j, k, Betau_y)) * d_d_phiI4d_t_o0_t2_m0_l0;
					m_d_phiI4d_t_o0_t4_l0_p = std::min(0.0, un(i, j, k, Betau_x)) * d_d_phiI4d_t_o0_t1_m0_l0;
					m_d_phiI4d_t_o0_t3_l0_p = std::max(0.0, un(i, j, k, Betau_z)) * d_d_phiI4d_t_o0_t3_m0_l0;
					m_d_phiI4d_t_o0_t2_l0_p = std::max(0.0, un(i, j, k, Betau_y)) * d_d_phiI4d_t_o0_t2_m0_l0;
					m_d_phiI4d_t_o0_t1_l0_p = std::max(0.0, un(i, j, k, Betau_x)) * d_d_phiI4d_t_o0_t1_m0_l0;
					d_phiI4d_t_p = (((((d_d_phiI4d_t_o0_t0_m0_l0_p + m_d_phiI4d_t_o0_t1_l0_p) + m_d_phiI4d_t_o0_t2_l0_p) + m_d_phiI4d_t_o0_t3_l0_p) + m_d_phiI4d_t_o0_t4_l0_p) + m_d_phiI4d_t_o0_t5_l0_p) + m_d_phiI4d_t_o0_t6_l0_p;
					d_phiI4d_x_p = d_d_phiI4d_t_o0_t1_m0_l0;
					d_phiI4d_y_p = d_d_phiI4d_t_o0_t2_m0_l0;
					d_phiI4d_z_p = d_d_phiI4d_t_o0_t3_m0_l0;
					g4u_tx_p = un(i, j, k, Betau_x) / (un(i, j, k, Alpha) * un(i, j, k, Alpha));
					g4u_tz_p = un(i, j, k, Betau_z) / (un(i, j, k, Alpha) * un(i, j, k, Alpha));
					g4u_ty_p = un(i, j, k, Betau_y) / (un(i, j, k, Alpha) * un(i, j, k, Alpha));
					g4u_tt_p = -1.0 / (un(i, j, k, Alpha) * un(i, j, k, Alpha));
					d_phiI4u_t_p = g4u_tt_p * d_phiI4d_t_p + g4u_tx_p * d_phiI4d_x_p + g4u_ty_p * d_phiI4d_y_p + g4u_tz_p * d_phiI4d_z_p;
					sfVe_p = (sfmass_p * sfmass_p) * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) * ((1.0 - 2.0 * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) + parameters.sflambda / 2.0 * ((un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)) * (un(i, j, k, pheR) * un(i, j, k, pheR) + un(i, j, k, pheI) * un(i, j, k, pheI)));
					sfVi_p = (sfmass_p * sfmass_p) * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) * ((1.0 - 2.0 * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) + parameters.sflambda / 2.0 * ((un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)) * (un(i, j, k, phiR) * un(i, j, k, phiR) + un(i, j, k, phiI) * un(i, j, k, phiI)));
					m_Ctd_zxz_o0_t0_l0_p = .5 * d_Ctd_xzz_o0_t1_m0_l0;
					Ctd_zxz_p = m_Ctd_zxz_o0_t0_l0_p;
					m_Ctd_zxx_o0_t1_l0_p = (-.5) * d_Ctd_xxz_o0_t0_m0_l0;
					m_Ctd_zxx_o0_t0_l0_p = 1.0 * d_Ctd_zxx_o0_t0_m0_l0;
					Ctd_zxx_p = m_Ctd_zxx_o0_t0_l0_p + m_Ctd_zxx_o0_t1_l0_p;
					detgtd_p = un(i, j, k, gtd_yy) * un(i, j, k, gtd_zz) * un(i, j, k, gtd_xx) + (-un(i, j, k, gtd_yy) * (un(i, j, k, gtd_xz) * un(i, j, k, gtd_xz))) + (-un(i, j, k, gtd_zz) * (un(i, j, k, gtd_xy) * un(i, j, k, gtd_xy))) + (-(un(i, j, k, gtd_yz) * un(i, j, k, gtd_yz)) * un(i, j, k, gtd_xx)) + 2.0 * un(i, j, k, gtd_yz) * un(i, j, k, gtd_xy) * un(i, j, k, gtd_xz);
					d_d_phiR4d_t_o0_t0_m0_l0_p = -un(i, j, k, Alpha) * un(i, j, k, piR);
					m_d_phiR4d_t_o0_t6_l0_p = std::min(0.0, un(i, j, k, Betau_z)) * d_d_phiR4d_t_o0_t3_m0_l0;
					m_d_phiR4d_t_o0_t5_l0_p = std::min(0.0, un(i, j, k, Betau_y)) * d_d_phiR4d_t_o0_t2_m0_l0;
					m_d_phiR4d_t_o0_t4_l0_p = std::min(0.0, un(i, j, k, Betau_x)) * d_d_phiR4d_t_o0_t1_m0_l0;
					m_d_phiR4d_t_o0_t3_l0_p = std::max(0.0, un(i, j, k, Betau_z)) * d_d_phiR4d_t_o0_t3_m0_l0;
					m_d_phiR4d_t_o0_t2_l0_p = std::max(0.0, un(i, j, k, Betau_y)) * d_d_phiR4d_t_o0_t2_m0_l0;
					m_d_phiR4d_t_o0_t1_l0_p = std::max(0.0, un(i, j, k, Betau_x)) * d_d_phiR4d_t_o0_t1_m0_l0;
					d_phiR4d_t_p = (((((d_d_phiR4d_t_o0_t0_m0_l0_p + m_d_phiR4d_t_o0_t1_l0_p) + m_d_phiR4d_t_o0_t2_l0_p) + m_d_phiR4d_t_o0_t3_l0_p) + m_d_phiR4d_t_o0_t4_l0_p) + m_d_phiR4d_t_o0_t5_l0_p) + m_d_phiR4d_t_o0_t6_l0_p;
					d_phiR4d_x_p = d_d_phiR4d_t_o0_t1_m0_l0;
					d_phiR4d_z_p = d_d_phiR4d_t_o0_t3_m0_l0;
					d_phiR4d_y_p = d_d_phiR4d_t_o0_t2_m0_l0;
					d_phiR4u_t_p = g4u_tt_p * d_phiR4d_t_p + g4u_tx_p * d_phiR4d_x_p + g4u_ty_p * d_phiR4d_y_p + g4u_tz_p * d_phiR4d_z_p;
					chi_max_p = std::max(parameters.chi_floor, un(i, j, k, chi));
					inv_chi_p = 1.0 / fabs(chi_max_p);
					d_d_pheR4d_t_o0_t0_m0_l0_p = -un(i, j, k, Alpha) * un(i, j, k, peR);
					m_d_pheR4d_t_o0_t6_l0_p = std::min(0.0, un(i, j, k, Betau_z)) * d_d_pheR4d_t_o0_t3_m0_l0;
					m_d_pheR4d_t_o0_t5_l0_p = std::min(0.0, un(i, j, k, Betau_y)) * d_d_pheR4d_t_o0_t2_m0_l0;
					m_d_pheR4d_t_o0_t4_l0_p = std::min(0.0, un(i, j, k, Betau_x)) * d_d_pheR4d_t_o0_t1_m0_l0;
					m_d_pheR4d_t_o0_t3_l0_p = std::max(0.0, un(i, j, k, Betau_z)) * d_d_pheR4d_t_o0_t3_m0_l0;
					m_d_pheR4d_t_o0_t2_l0_p = std::max(0.0, un(i, j, k, Betau_y)) * d_d_pheR4d_t_o0_t2_m0_l0;
					m_d_pheR4d_t_o0_t1_l0_p = std::max(0.0, un(i, j, k, Betau_x)) * d_d_pheR4d_t_o0_t1_m0_l0;
					d_pheR4d_t_p = (((((d_d_pheR4d_t_o0_t0_m0_l0_p + m_d_pheR4d_t_o0_t1_l0_p) + m_d_pheR4d_t_o0_t2_l0_p) + m_d_pheR4d_t_o0_t3_l0_p) + m_d_pheR4d_t_o0_t4_l0_p) + m_d_pheR4d_t_o0_t5_l0_p) + m_d_pheR4d_t_o0_t6_l0_p;
					d_pheR4d_x_p = d_d_pheR4d_t_o0_t1_m0_l0;
					d_pheR4d_y_p = d_d_pheR4d_t_o0_t2_m0_l0;
					d_pheR4d_z_p = d_d_pheR4d_t_o0_t3_m0_l0;
					d_pheR4u_t_p = g4u_tt_p * d_pheR4d_t_p + g4u_tx_p * d_pheR4d_x_p + g4u_ty_p * d_pheR4d_y_p + g4u_tz_p * d_pheR4d_z_p;
					m_Ctd_zyy_o0_t1_l0_p = (-.5) * d_Ctd_yyz_o0_t0_m0_l0;
					m_Ctd_zyy_o0_t0_l0_p = 1.0 * d_Ctd_zyy_o0_t0_m0_l0;
					Ctd_zyy_p = m_Ctd_zyy_o0_t0_l0_p + m_Ctd_zyy_o0_t1_l0_p;
					m_Ctd_zyz_o0_t0_l0_p = .5 * d_Ctd_yzz_o0_t1_m0_l0;
					Ctd_zyz_p = m_Ctd_zyz_o0_t0_l0_p;
					Betatd_x_p = un(i, j, k, Betau_x) * un(i, j, k, gtd_xx) + un(i, j, k, Betau_y) * un(i, j, k, gtd_xy) + un(i, j, k, Betau_z) * un(i, j, k, gtd_xz);
					Betatd_z_p = un(i, j, k, Betau_x) * un(i, j, k, gtd_xz) + un(i, j, k, Betau_y) * un(i, j, k, gtd_yz) + un(i, j, k, Betau_z) * un(i, j, k, gtd_zz);
					Betatd_y_p = un(i, j, k, Betau_x) * un(i, j, k, gtd_xy) + un(i, j, k, Betau_y) * un(i, j, k, gtd_yy) + un(i, j, k, Betau_z) * un(i, j, k, gtd_yz);
					idetgtd_p = 1.0 / detgtd_p;
					gtu_zz_p = idetgtd_p * (un(i, j, k, gtd_xx) * un(i, j, k, gtd_yy) - un(i, j, k, gtd_xy) * un(i, j, k, gtd_xy));
					g4u_zz_p = chi_max_p * gtu_zz_p + (-(un(i, j, k, Betau_z) * un(i, j, k, Betau_z)) / (un(i, j, k, Alpha) * un(i, j, k, Alpha)));
					gtu_yy_p = idetgtd_p * (un(i, j, k, gtd_xx) * un(i, j, k, gtd_zz) - un(i, j, k, gtd_xz) * un(i, j, k, gtd_xz));
					g4u_yy_p = chi_max_p * gtu_yy_p + (-(un(i, j, k, Betau_y) * un(i, j, k, Betau_y)) / (un(i, j, k, Alpha) * un(i, j, k, Alpha)));
					gtu_yz_p = idetgtd_p * ((-un(i, j, k, gtd_xx) * un(i, j, k, gtd_yz)) + un(i, j, k, gtd_xy) * un(i, j, k, gtd_xz));
					g4u_yz_p = chi_max_p * gtu_yz_p + (-(un(i, j, k, Betau_y) * un(i, j, k, Betau_z)) / (un(i, j, k, Alpha) * un(i, j, k, Alpha)));
					gtu_xx_p = idetgtd_p * (un(i, j, k, gtd_yy) * un(i, j, k, gtd_zz) - un(i, j, k, gtd_yz) * un(i, j, k, gtd_yz));
					g4u_xx_p = chi_max_p * gtu_xx_p + (-(un(i, j, k, Betau_x) * un(i, j, k, Betau_x)) / (un(i, j, k, Alpha) * un(i, j, k, Alpha)));
					gtu_xz_p = idetgtd_p * (un(i, j, k, gtd_xy) * un(i, j, k, gtd_yz) - un(i, j, k, gtd_yy) * un(i, j, k, gtd_xz));
					g4u_xz_p = chi_max_p * gtu_xz_p + (-(un(i, j, k, Betau_x) * un(i, j, k, Betau_z)) / (un(i, j, k, Alpha) * un(i, j, k, Alpha)));
					d_pheR4u_z_p = g4u_tz_p * d_pheR4d_t_p + g4u_xz_p * d_pheR4d_x_p + g4u_yz_p * d_pheR4d_y_p + g4u_zz_p * d_pheR4d_z_p;
					d_phiR4u_z_p = g4u_tz_p * d_phiR4d_t_p + g4u_xz_p * d_phiR4d_x_p + g4u_yz_p * d_phiR4d_y_p + g4u_zz_p * d_phiR4d_z_p;
					d_phiI4u_z_p = g4u_tz_p * d_phiI4d_t_p + g4u_xz_p * d_phiI4d_x_p + g4u_yz_p * d_phiI4d_y_p + g4u_zz_p * d_phiI4d_z_p;
					Ct_zyz_p = gtu_xz_p * Ctd_xyz_p + gtu_yz_p * Ctd_yyz_p + gtu_zz_p * Ctd_zyz_p;
					Ct_zyy_p = gtu_xz_p * Ctd_xyy_p + gtu_yz_p * Ctd_yyy_p + gtu_zz_p * Ctd_zyy_p;
					Atud_zx_p = gtu_xz_p * un(i, j, k, Atd_xx) + gtu_yz_p * un(i, j, k, Atd_xy) + gtu_zz_p * un(i, j, k, Atd_xz);
					Atud_zz_p = gtu_xz_p * un(i, j, k, Atd_xz) + gtu_yz_p * un(i, j, k, Atd_yz) + gtu_zz_p * un(i, j, k, Atd_zz);
					Atud_zy_p = gtu_xz_p * un(i, j, k, Atd_xy) + gtu_yz_p * un(i, j, k, Atd_yy) + gtu_zz_p * un(i, j, k, Atd_yz);
					Atu_zz_p = Atud_zx_p * gtu_xz_p + Atud_zy_p * gtu_yz_p + Atud_zz_p * gtu_zz_p;
					gtu_xy_p = idetgtd_p * ((-un(i, j, k, gtd_xy) * un(i, j, k, gtd_zz)) + un(i, j, k, gtd_yz) * un(i, j, k, gtd_xz));
					g4u_xy_p = chi_max_p * gtu_xy_p + (-(un(i, j, k, Betau_x) * un(i, j, k, Betau_y)) / (un(i, j, k, Alpha) * un(i, j, k, Alpha)));
					d_pheR4u_x_p = g4u_tx_p * d_pheR4d_t_p + g4u_xx_p * d_pheR4d_x_p + g4u_xy_p * d_pheR4d_y_p + g4u_xz_p * d_pheR4d_z_p;
					d_pheR4u_y_p = g4u_ty_p * d_pheR4d_t_p + g4u_xy_p * d_pheR4d_x_p + g4u_yy_p * d_pheR4d_y_p + g4u_yz_p * d_pheR4d_z_p;
					d_phiR4u_y_p = g4u_ty_p * d_phiR4d_t_p + g4u_xy_p * d_phiR4d_x_p + g4u_yy_p * d_phiR4d_y_p + g4u_yz_p * d_phiR4d_z_p;
					d_phiR4u_x_p = g4u_tx_p * d_phiR4d_t_p + g4u_xx_p * d_phiR4d_x_p + g4u_xy_p * d_phiR4d_y_p + g4u_xz_p * d_phiR4d_z_p;
					d_phiI4u_y_p = g4u_ty_p * d_phiI4d_t_p + g4u_xy_p * d_phiI4d_x_p + g4u_yy_p * d_phiI4d_y_p + g4u_yz_p * d_phiI4d_z_p;
					d_phiI4u_x_p = g4u_tx_p * d_phiI4d_t_p + g4u_xx_p * d_phiI4d_x_p + g4u_xy_p * d_phiI4d_y_p + g4u_xz_p * d_phiI4d_z_p;
					dphi4sq_p = d_phiR4u_t_p * d_phiR4d_t_p + d_phiR4u_x_p * d_phiR4d_x_p + d_phiR4u_y_p * d_phiR4d_y_p + d_phiR4u_z_p * d_phiR4d_z_p + d_phiI4u_t_p * d_phiI4d_t_p + d_phiI4u_x_p * d_phiI4d_x_p + d_phiI4u_y_p * d_phiI4d_y_p + d_phiI4u_z_p * d_phiI4d_z_p;
					Atud_yy_p = gtu_xy_p * un(i, j, k, Atd_xy) + gtu_yy_p * un(i, j, k, Atd_yy) + gtu_yz_p * un(i, j, k, Atd_yz);
					Atud_yx_p = gtu_xy_p * un(i, j, k, Atd_xx) + gtu_yy_p * un(i, j, k, Atd_xy) + gtu_yz_p * un(i, j, k, Atd_xz);
					Atud_yz_p = gtu_xy_p * un(i, j, k, Atd_xz) + gtu_yy_p * un(i, j, k, Atd_yz) + gtu_yz_p * un(i, j, k, Atd_zz);
					Atu_yz_p = Atud_yx_p * gtu_xz_p + Atud_yy_p * gtu_yz_p + Atud_yz_p * gtu_zz_p;
					Atu_yy_p = Atud_yx_p * gtu_xy_p + Atud_yy_p * gtu_yy_p + Atud_yz_p * gtu_yz_p;
					Ct_yyy_p = gtu_xy_p * Ctd_xyy_p + gtu_yy_p * Ctd_yyy_p + gtu_yz_p * Ctd_zyy_p;
					Ct_yyz_p = gtu_xy_p * Ctd_xyz_p + gtu_yy_p * Ctd_yyz_p + gtu_yz_p * Ctd_zyz_p;
					Atud_xx_p = gtu_xx_p * un(i, j, k, Atd_xx) + gtu_xy_p * un(i, j, k, Atd_xy) + gtu_xz_p * un(i, j, k, Atd_xz);
					trAt_p = Atud_xx_p + Atud_yy_p + Atud_zz_p;
					Atud_xz_p = gtu_xx_p * un(i, j, k, Atd_xz) + gtu_xy_p * un(i, j, k, Atd_yz) + gtu_xz_p * un(i, j, k, Atd_zz);
					Atud_xy_p = gtu_xx_p * un(i, j, k, Atd_xy) + gtu_xy_p * un(i, j, k, Atd_yy) + gtu_xz_p * un(i, j, k, Atd_yz);
					Atu_xz_p = Atud_xx_p * gtu_xz_p + Atud_xy_p * gtu_yz_p + Atud_xz_p * gtu_zz_p;
					Atu_xy_p = Atud_xx_p * gtu_xy_p + Atud_xy_p * gtu_yy_p + Atud_xz_p * gtu_yz_p;
					Atu_xx_p = Atud_xx_p * gtu_xx_p + Atud_xy_p * gtu_xy_p + Atud_xz_p * gtu_xz_p;
					decay_factor_p = std::min(1.0, pow((parameters.R_0 / std::max(0.0000000001, sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k)))), parameters.eta_damping_exp));
					kappa_z1_p = std::min(parameters.p_kappa_z1, parameters.p_kappa_z1 * decay_factor_p) / un(i, j, k, Alpha);
					feta_p = std::min(parameters.p_feta, parameters.p_feta * decay_factor_p);
					m_Ctd_zzz_o0_t0_l0_p = .5 * d_Ctd_zzz_o0_t0_m0_l0;
					Ctd_zzz_p = m_Ctd_zzz_o0_t0_l0_p;
					Ct_xzz_p = gtu_xx_p * Ctd_xzz_p + gtu_xy_p * Ctd_yzz_p + gtu_xz_p * Ctd_zzz_p;
					Ct_zzz_p = gtu_xz_p * Ctd_xzz_p + gtu_yz_p * Ctd_yzz_p + gtu_zz_p * Ctd_zzz_p;
					Ct_yzz_p = gtu_xy_p * Ctd_xzz_p + gtu_yy_p * Ctd_yzz_p + gtu_yz_p * Ctd_zzz_p;
					m_Ctd_yxy_o0_t0_l0_p = .5 * d_Ctd_xyy_o0_t1_m0_l0;
					Ctd_yxy_p = m_Ctd_yxy_o0_t0_l0_p;
					Ct_xyz_p = gtu_xx_p * Ctd_xyz_p + gtu_xy_p * Ctd_yyz_p + gtu_xz_p * Ctd_zyz_p;
					m_Ctd_yxz_o0_t2_l0_p = (-.5) * d_Ctd_xyz_o0_t0_m0_l0;
					m_Ctd_yxz_o0_t0_l0_p = .5 * d_Ctd_xyz_o0_t2_m0_l0;
					Ctd_yxz_p = (m_Ctd_yxz_o0_t0_l0_p + m_Ctd_xyz_o0_t1_l0_p) + m_Ctd_yxz_o0_t2_l0_p;
					Ct_zxz_p = gtu_xz_p * Ctd_xxz_p + gtu_yz_p * Ctd_yxz_p + gtu_zz_p * Ctd_zxz_p;
					Ct_yxz_p = gtu_xy_p * Ctd_xxz_p + gtu_yy_p * Ctd_yxz_p + gtu_yz_p * Ctd_zxz_p;
					m_Ctd_zxy_o0_t2_l0_p = (-.5) * d_Ctd_xyz_o0_t1_m0_l0;
					Ctd_zxy_p = (m_Ctd_yxz_o0_t0_l0_p + m_Ctd_xyz_o0_t0_l0_p) + m_Ctd_zxy_o0_t2_l0_p;
					Ct_zxy_p = gtu_xz_p * Ctd_xxy_p + gtu_yz_p * Ctd_yxy_p + gtu_zz_p * Ctd_zxy_p;
					Ct_yxy_p = gtu_xy_p * Ctd_xxy_p + gtu_yy_p * Ctd_yxy_p + gtu_yz_p * Ctd_zxy_p;
					Ct_xxy_p = gtu_xx_p * Ctd_xxy_p + gtu_xy_p * Ctd_yxy_p + gtu_xz_p * Ctd_zxy_p;
					Ct_xxz_p = gtu_xx_p * Ctd_xxz_p + gtu_xy_p * Ctd_yxz_p + gtu_xz_p * Ctd_zxz_p;
					Ct_xyy_p = gtu_xx_p * Ctd_xyy_p + gtu_xy_p * Ctd_yyy_p + gtu_xz_p * Ctd_zyy_p;
					m_Ctd_yxx_o0_t1_l0_p = (-.5) * d_Ctd_xxy_o0_t0_m0_l0;
					m_Ctd_yxx_o0_t0_l0_p = 1.0 * d_Ctd_yxx_o0_t0_m0_l0;
					Ctd_yxx_p = m_Ctd_yxx_o0_t0_l0_p + m_Ctd_yxx_o0_t1_l0_p;
					Ct_zxx_p = gtu_xz_p * Ctd_xxx_p + gtu_yz_p * Ctd_yxx_p + gtu_zz_p * Ctd_zxx_p;
					Gamt_z_p = gtu_xx_p * Ct_zxx_p + 2.0 * gtu_xy_p * Ct_zxy_p + 2.0 * gtu_xz_p * Ct_zxz_p + gtu_yy_p * Ct_zyy_p + 2.0 * gtu_yz_p * Ct_zyz_p + gtu_zz_p * Ct_zzz_p;
					Zu_z_p = .5 * chi_max_p * (un(i, j, k, Gamh_z) - Gamt_z_p);
					Ct_yxx_p = gtu_xy_p * Ctd_xxx_p + gtu_yy_p * Ctd_yxx_p + gtu_yz_p * Ctd_zxx_p;
					Gamt_y_p = gtu_xx_p * Ct_yxx_p + 2.0 * gtu_xy_p * Ct_yxy_p + 2.0 * gtu_xz_p * Ct_yxz_p + gtu_yy_p * Ct_yyy_p + 2.0 * gtu_yz_p * Ct_yyz_p + gtu_zz_p * Ct_yzz_p;
					Zu_y_p = .5 * chi_max_p * (un(i, j, k, Gamh_y) - Gamt_y_p);
					Ct_xxx_p = gtu_xx_p * Ctd_xxx_p + gtu_xy_p * Ctd_yxx_p + gtu_xz_p * Ctd_zxx_p;
					Gamt_x_p = gtu_xx_p * Ct_xxx_p + 2.0 * gtu_xy_p * Ct_xxy_p + 2.0 * gtu_xz_p * Ct_xxz_p + gtu_yy_p * Ct_xyy_p + 2.0 * gtu_yz_p * Ct_xyz_p + gtu_zz_p * Ct_xzz_p;
					Zu_x_p = .5 * chi_max_p * (un(i, j, k, Gamh_x) - Gamt_x_p);
					d_Rtd_xx_o0_t9_m0_l0_p = gtu_zz_p * (3.0 * Ct_xxz_p * Ctd_xxz_p + 2.0 * Ct_yxz_p * Ctd_xyz_p + Ct_yxz_p * Ctd_yxz_p + 2.0 * Ct_zxz_p * Ctd_xzz_p + Ct_zxz_p * Ctd_zxz_p) + gtu_yz_p * (3.0 * Ct_xxy_p * Ctd_xxz_p + 2.0 * Ct_yxy_p * Ctd_xyz_p + Ct_yxy_p * Ctd_yxz_p + 2.0 * Ct_zxy_p * Ctd_xzz_p + Ct_zxy_p * Ctd_zxz_p) + gtu_xz_p * (3.0 * Ct_xxx_p * Ctd_xxz_p + 2.0 * Ct_yxx_p * Ctd_xyz_p + Ct_yxx_p * Ctd_yxz_p + 2.0 * Ct_zxx_p * Ctd_xzz_p + Ct_zxx_p * Ctd_zxz_p) + gtu_yz_p * (3.0 * Ct_xxz_p * Ctd_xxy_p + 2.0 * Ct_yxz_p * Ctd_xyy_p + Ct_yxz_p * Ctd_yxy_p + 2.0 * Ct_zxz_p * Ctd_xyz_p + Ct_zxz_p * Ctd_zxy_p) + gtu_yy_p * (3.0 * Ct_xxy_p * Ctd_xxy_p + 2.0 * Ct_yxy_p * Ctd_xyy_p + Ct_yxy_p * Ctd_yxy_p + 2.0 * Ct_zxy_p * Ctd_xyz_p + Ct_zxy_p * Ctd_zxy_p) + gtu_xy_p * (3.0 * Ct_xxx_p * Ctd_xxy_p + 2.0 * Ct_yxx_p * Ctd_xyy_p + Ct_yxx_p * Ctd_yxy_p + 2.0 * Ct_zxx_p * Ctd_xyz_p + Ct_zxx_p * Ctd_zxy_p) + gtu_xz_p * (3.0 * Ct_xxz_p * Ctd_xxx_p + 2.0 * Ct_yxz_p * Ctd_xxy_p + Ct_yxz_p * Ctd_yxx_p + 2.0 * Ct_zxz_p * Ctd_xxz_p + Ct_zxz_p * Ctd_zxx_p) + gtu_xy_p * (3.0 * Ct_xxy_p * Ctd_xxx_p + 2.0 * Ct_yxy_p * Ctd_xxy_p + Ct_yxy_p * Ctd_yxx_p + 2.0 * Ct_zxy_p * Ctd_xxz_p + Ct_zxy_p * Ctd_zxx_p) + gtu_xx_p * (3.0 * Ct_xxx_p * Ctd_xxx_p + 2.0 * Ct_yxx_p * Ctd_xxy_p + Ct_yxx_p * Ctd_yxx_p + 2.0 * Ct_zxx_p * Ctd_xxz_p + Ct_zxx_p * Ctd_zxx_p) + 1.0 * un(i, j, k, Gamh_z) * Ctd_xxz_p + 1.0 * un(i, j, k, Gamh_y) * Ctd_xxy_p + 1.0 * un(i, j, k, Gamh_x) * Ctd_xxx_p;
					m_Rtd_xx_o0_t8_l0_p = 1.0 * un(i, j, k, gtd_xz) * d_Rtd_xx_o0_t8_m0_l0;
					m_Rtd_xx_o0_t7_l0_p = 1.0 * un(i, j, k, gtd_xy) * d_Rtd_xx_o0_t7_m0_l0;
					m_Rtd_xx_o0_t6_l0_p = 1.0 * un(i, j, k, gtd_xx) * d_Rtd_xx_o0_t6_m0_l0;
					m_Rtd_xx_o0_t5_l0_p = (-.5 * gtu_zz_p) * d_Rtd_xx_o0_t5_m0_l0;
					m_Rtd_xx_o0_t4_l0_p = (-1.0 * gtu_yz_p) * d_Rtd_xx_o0_t4_m0_l0;
					m_Rtd_xx_o0_t3_l0_p = (-.5 * gtu_yy_p) * d_Rtd_xx_o0_t3_m0_l0;
					m_Rtd_xx_o0_t2_l0_p = (-1.0 * gtu_xz_p) * d_Rtd_xx_o0_t2_m0_l0;
					m_Rtd_xx_o0_t1_l0_p = (-1.0 * gtu_xy_p) * d_Rtd_xx_o0_t1_m0_l0;
					m_Rtd_xx_o0_t0_l0_p = (-.5 * gtu_xx_p) * d_Rtd_xx_o0_t0_m0_l0;
					Rtd_xx_p = ((((((((m_Rtd_xx_o0_t0_l0_p + m_Rtd_xx_o0_t1_l0_p) + m_Rtd_xx_o0_t2_l0_p) + m_Rtd_xx_o0_t3_l0_p) + m_Rtd_xx_o0_t4_l0_p) + m_Rtd_xx_o0_t5_l0_p) + m_Rtd_xx_o0_t6_l0_p) + m_Rtd_xx_o0_t7_l0_p) + m_Rtd_xx_o0_t8_l0_p) + d_Rtd_xx_o0_t9_m0_l0_p;
					d_Rtd_xz_o0_t12_m0_l0_p = gtu_zz_p * (Ct_xxz_p * Ctd_zxz_p + Ct_xxz_p * Ctd_xzz_p + Ct_xzz_p * Ctd_xxz_p + Ct_yxz_p * Ctd_zyz_p + Ct_yxz_p * Ctd_yzz_p + Ct_yzz_p * Ctd_xyz_p + 2.0 * Ct_zxz_p * Ctd_zzz_p + Ct_zzz_p * Ctd_xzz_p) + gtu_yz_p * (Ct_xxy_p * Ctd_zxz_p + Ct_xxy_p * Ctd_xzz_p + Ct_xyz_p * Ctd_xxz_p + Ct_yxy_p * Ctd_zyz_p + Ct_yxy_p * Ctd_yzz_p + Ct_yyz_p * Ctd_xyz_p + 2.0 * Ct_zxy_p * Ctd_zzz_p + Ct_zyz_p * Ctd_xzz_p) + gtu_xz_p * (Ct_xxx_p * Ctd_zxz_p + Ct_xxx_p * Ctd_xzz_p + Ct_xxz_p * Ctd_xxz_p + Ct_yxx_p * Ctd_zyz_p + Ct_yxx_p * Ctd_yzz_p + Ct_yxz_p * Ctd_xyz_p + 2.0 * Ct_zxx_p * Ctd_zzz_p + Ct_zxz_p * Ctd_xzz_p) + gtu_yz_p * (Ct_xxz_p * Ctd_zxy_p + Ct_xxz_p * Ctd_xyz_p + Ct_xzz_p * Ctd_xxy_p + Ct_yxz_p * Ctd_zyy_p + Ct_yxz_p * Ctd_yyz_p + Ct_yzz_p * Ctd_xyy_p + 2.0 * Ct_zxz_p * Ctd_zyz_p + Ct_zzz_p * Ctd_xyz_p) + gtu_yy_p * (Ct_xxy_p * Ctd_zxy_p + Ct_xxy_p * Ctd_xyz_p + Ct_xyz_p * Ctd_xxy_p + Ct_yxy_p * Ctd_zyy_p + Ct_yxy_p * Ctd_yyz_p + Ct_yyz_p * Ctd_xyy_p + 2.0 * Ct_zxy_p * Ctd_zyz_p + Ct_zyz_p * Ctd_xyz_p) + gtu_xy_p * (Ct_xxx_p * Ctd_zxy_p + Ct_xxx_p * Ctd_xyz_p + Ct_xxz_p * Ctd_xxy_p + Ct_yxx_p * Ctd_zyy_p + Ct_yxx_p * Ctd_yyz_p + Ct_yxz_p * Ctd_xyy_p + 2.0 * Ct_zxx_p * Ctd_zyz_p + Ct_zxz_p * Ctd_xyz_p) + gtu_xz_p * (Ct_xxz_p * Ctd_zxx_p + Ct_xxz_p * Ctd_xxz_p + Ct_xzz_p * Ctd_xxx_p + Ct_yxz_p * Ctd_zxy_p + Ct_yxz_p * Ctd_yxz_p + Ct_yzz_p * Ctd_xxy_p + 2.0 * Ct_zxz_p * Ctd_zxz_p + Ct_zzz_p * Ctd_xxz_p) + gtu_xy_p * (Ct_xxy_p * Ctd_zxx_p + Ct_xxy_p * Ctd_xxz_p + Ct_xyz_p * Ctd_xxx_p + Ct_yxy_p * Ctd_zxy_p + Ct_yxy_p * Ctd_yxz_p + Ct_yyz_p * Ctd_xxy_p + 2.0 * Ct_zxy_p * Ctd_zxz_p + Ct_zyz_p * Ctd_xxz_p) + gtu_xx_p * (Ct_xxx_p * Ctd_zxx_p + Ct_xxx_p * Ctd_xxz_p + Ct_xxz_p * Ctd_xxx_p + Ct_yxx_p * Ctd_zxy_p + Ct_yxx_p * Ctd_yxz_p + Ct_yxz_p * Ctd_xxy_p + 2.0 * Ct_zxx_p * Ctd_zxz_p + Ct_zxz_p * Ctd_xxz_p) + .5 * un(i, j, k, Gamh_z) * (Ctd_xzz_p + Ctd_zxz_p) + .5 * un(i, j, k, Gamh_y) * (Ctd_xyz_p + Ctd_zxy_p) + .5 * un(i, j, k, Gamh_x) * (Ctd_xxz_p + Ctd_zxx_p);
					m_Rtd_xz_o0_t11_l0_p = .5 * un(i, j, k, gtd_zz) * d_Rtd_xx_o0_t8_m0_l0;
					m_Rtd_xz_o0_t10_l0_p = .5 * un(i, j, k, gtd_yz) * d_Rtd_xx_o0_t7_m0_l0;
					m_Rtd_xz_o0_t9_l0_p = .5 * un(i, j, k, gtd_xz) * d_Rtd_xx_o0_t6_m0_l0;
					m_Rtd_xz_o0_t8_l0_p = .5 * un(i, j, k, gtd_xz) * d_Rtd_xz_o0_t8_m0_l0;
					m_Rtd_xz_o0_t7_l0_p = .5 * un(i, j, k, gtd_xy) * d_Rtd_xz_o0_t7_m0_l0;
					m_Rtd_xz_o0_t6_l0_p = .5 * un(i, j, k, gtd_xx) * d_Rtd_xz_o0_t6_m0_l0;
					m_Rtd_xz_o0_t5_l0_p = (-.5 * gtu_zz_p) * d_Rtd_xz_o0_t5_m0_l0;
					m_Rtd_xz_o0_t4_l0_p = (-1.0 * gtu_yz_p) * d_Rtd_xz_o0_t4_m0_l0;
					m_Rtd_xz_o0_t3_l0_p = (-.5 * gtu_yy_p) * d_Rtd_xz_o0_t3_m0_l0;
					m_Rtd_xz_o0_t2_l0_p = (-1.0 * gtu_xz_p) * d_Rtd_xz_o0_t2_m0_l0;
					m_Rtd_xz_o0_t1_l0_p = (-1.0 * gtu_xy_p) * d_Rtd_xz_o0_t1_m0_l0;
					m_Rtd_xz_o0_t0_l0_p = (-.5 * gtu_xx_p) * d_Rtd_xz_o0_t0_m0_l0;
					Rtd_xz_p = (((((((((((m_Rtd_xz_o0_t0_l0_p + m_Rtd_xz_o0_t1_l0_p) + m_Rtd_xz_o0_t2_l0_p) + m_Rtd_xz_o0_t3_l0_p) + m_Rtd_xz_o0_t4_l0_p) + m_Rtd_xz_o0_t5_l0_p) + m_Rtd_xz_o0_t6_l0_p) + m_Rtd_xz_o0_t7_l0_p) + m_Rtd_xz_o0_t8_l0_p) + m_Rtd_xz_o0_t9_l0_p) + m_Rtd_xz_o0_t10_l0_p) + m_Rtd_xz_o0_t11_l0_p) + d_Rtd_xz_o0_t12_m0_l0_p;
					d_Rtd_zz_o0_t9_m0_l0_p = gtu_zz_p * (2.0 * Ct_xzz_p * Ctd_zxz_p + Ct_xzz_p * Ctd_xzz_p + 2.0 * Ct_yzz_p * Ctd_zyz_p + Ct_yzz_p * Ctd_yzz_p + 3.0 * Ct_zzz_p * Ctd_zzz_p) + gtu_yz_p * (2.0 * Ct_xyz_p * Ctd_zxz_p + Ct_xyz_p * Ctd_xzz_p + 2.0 * Ct_yyz_p * Ctd_zyz_p + Ct_yyz_p * Ctd_yzz_p + 3.0 * Ct_zyz_p * Ctd_zzz_p) + gtu_xz_p * (2.0 * Ct_xxz_p * Ctd_zxz_p + Ct_xxz_p * Ctd_xzz_p + 2.0 * Ct_yxz_p * Ctd_zyz_p + Ct_yxz_p * Ctd_yzz_p + 3.0 * Ct_zxz_p * Ctd_zzz_p) + gtu_yz_p * (2.0 * Ct_xzz_p * Ctd_zxy_p + Ct_xzz_p * Ctd_xyz_p + 2.0 * Ct_yzz_p * Ctd_zyy_p + Ct_yzz_p * Ctd_yyz_p + 3.0 * Ct_zzz_p * Ctd_zyz_p) + gtu_yy_p * (2.0 * Ct_xyz_p * Ctd_zxy_p + Ct_xyz_p * Ctd_xyz_p + 2.0 * Ct_yyz_p * Ctd_zyy_p + Ct_yyz_p * Ctd_yyz_p + 3.0 * Ct_zyz_p * Ctd_zyz_p) + gtu_xy_p * (2.0 * Ct_xxz_p * Ctd_zxy_p + Ct_xxz_p * Ctd_xyz_p + 2.0 * Ct_yxz_p * Ctd_zyy_p + Ct_yxz_p * Ctd_yyz_p + 3.0 * Ct_zxz_p * Ctd_zyz_p) + gtu_xz_p * (2.0 * Ct_xzz_p * Ctd_zxx_p + Ct_xzz_p * Ctd_xxz_p + 2.0 * Ct_yzz_p * Ctd_zxy_p + Ct_yzz_p * Ctd_yxz_p + 3.0 * Ct_zzz_p * Ctd_zxz_p) + gtu_xy_p * (2.0 * Ct_xyz_p * Ctd_zxx_p + Ct_xyz_p * Ctd_xxz_p + 2.0 * Ct_yyz_p * Ctd_zxy_p + Ct_yyz_p * Ctd_yxz_p + 3.0 * Ct_zyz_p * Ctd_zxz_p) + gtu_xx_p * (2.0 * Ct_xxz_p * Ctd_zxx_p + Ct_xxz_p * Ctd_xxz_p + 2.0 * Ct_yxz_p * Ctd_zxy_p + Ct_yxz_p * Ctd_yxz_p + 3.0 * Ct_zxz_p * Ctd_zxz_p) + 1.0 * un(i, j, k, Gamh_z) * Ctd_zzz_p + 1.0 * un(i, j, k, Gamh_y) * Ctd_zyz_p + 1.0 * un(i, j, k, Gamh_x) * Ctd_zxz_p;
					m_Rtd_zz_o0_t8_l0_p = 1.0 * un(i, j, k, gtd_zz) * d_Rtd_xz_o0_t8_m0_l0;
					m_Rtd_zz_o0_t7_l0_p = 1.0 * un(i, j, k, gtd_yz) * d_Rtd_xz_o0_t7_m0_l0;
					m_Rtd_zz_o0_t6_l0_p = 1.0 * un(i, j, k, gtd_xz) * d_Rtd_xz_o0_t6_m0_l0;
					m_Rtd_zz_o0_t5_l0_p = (-.5 * gtu_zz_p) * d_Rtd_zz_o0_t5_m0_l0;
					m_Rtd_zz_o0_t4_l0_p = (-1.0 * gtu_yz_p) * d_Rtd_zz_o0_t4_m0_l0;
					m_Rtd_zz_o0_t3_l0_p = (-.5 * gtu_yy_p) * d_Rtd_zz_o0_t3_m0_l0;
					m_Rtd_zz_o0_t2_l0_p = (-1.0 * gtu_xz_p) * d_Rtd_zz_o0_t2_m0_l0;
					m_Rtd_zz_o0_t1_l0_p = (-1.0 * gtu_xy_p) * d_Rtd_zz_o0_t1_m0_l0;
					m_Rtd_zz_o0_t0_l0_p = (-.5 * gtu_xx_p) * d_Rtd_zz_o0_t0_m0_l0;
					Rtd_zz_p = ((((((((m_Rtd_zz_o0_t0_l0_p + m_Rtd_zz_o0_t1_l0_p) + m_Rtd_zz_o0_t2_l0_p) + m_Rtd_zz_o0_t3_l0_p) + m_Rtd_zz_o0_t4_l0_p) + m_Rtd_zz_o0_t5_l0_p) + m_Rtd_zz_o0_t6_l0_p) + m_Rtd_zz_o0_t7_l0_p) + m_Rtd_zz_o0_t8_l0_p) + d_Rtd_zz_o0_t9_m0_l0_p;
					d_Rtd_xy_o0_t12_m0_l0_p = gtu_zz_p * (Ct_xxz_p * Ctd_yxz_p + Ct_xxz_p * Ctd_xyz_p + Ct_xyz_p * Ctd_xxz_p + 2.0 * Ct_yxz_p * Ctd_yyz_p + Ct_yyz_p * Ctd_xyz_p + Ct_zxz_p * Ctd_yzz_p + Ct_zxz_p * Ctd_zyz_p + Ct_zyz_p * Ctd_xzz_p) + gtu_yz_p * (Ct_xxy_p * Ctd_yxz_p + Ct_xxy_p * Ctd_xyz_p + Ct_xyy_p * Ctd_xxz_p + 2.0 * Ct_yxy_p * Ctd_yyz_p + Ct_yyy_p * Ctd_xyz_p + Ct_zxy_p * Ctd_yzz_p + Ct_zxy_p * Ctd_zyz_p + Ct_zyy_p * Ctd_xzz_p) + gtu_xz_p * (Ct_xxx_p * Ctd_yxz_p + Ct_xxx_p * Ctd_xyz_p + Ct_xxy_p * Ctd_xxz_p + 2.0 * Ct_yxx_p * Ctd_yyz_p + Ct_yxy_p * Ctd_xyz_p + Ct_zxx_p * Ctd_yzz_p + Ct_zxx_p * Ctd_zyz_p + Ct_zxy_p * Ctd_xzz_p) + gtu_yz_p * (Ct_xxz_p * Ctd_yxy_p + Ct_xxz_p * Ctd_xyy_p + Ct_xyz_p * Ctd_xxy_p + 2.0 * Ct_yxz_p * Ctd_yyy_p + Ct_yyz_p * Ctd_xyy_p + Ct_zxz_p * Ctd_yyz_p + Ct_zxz_p * Ctd_zyy_p + Ct_zyz_p * Ctd_xyz_p) + gtu_yy_p * (Ct_xxy_p * Ctd_yxy_p + Ct_xxy_p * Ctd_xyy_p + Ct_xyy_p * Ctd_xxy_p + 2.0 * Ct_yxy_p * Ctd_yyy_p + Ct_yyy_p * Ctd_xyy_p + Ct_zxy_p * Ctd_yyz_p + Ct_zxy_p * Ctd_zyy_p + Ct_zyy_p * Ctd_xyz_p) + gtu_xy_p * (Ct_xxx_p * Ctd_yxy_p + Ct_xxx_p * Ctd_xyy_p + Ct_xxy_p * Ctd_xxy_p + 2.0 * Ct_yxx_p * Ctd_yyy_p + Ct_yxy_p * Ctd_xyy_p + Ct_zxx_p * Ctd_yyz_p + Ct_zxx_p * Ctd_zyy_p + Ct_zxy_p * Ctd_xyz_p) + gtu_xz_p * (Ct_xxz_p * Ctd_yxx_p + Ct_xxz_p * Ctd_xxy_p + Ct_xyz_p * Ctd_xxx_p + 2.0 * Ct_yxz_p * Ctd_yxy_p + Ct_yyz_p * Ctd_xxy_p + Ct_zxz_p * Ctd_yxz_p + Ct_zxz_p * Ctd_zxy_p + Ct_zyz_p * Ctd_xxz_p) + gtu_xy_p * (Ct_xxy_p * Ctd_yxx_p + Ct_xxy_p * Ctd_xxy_p + Ct_xyy_p * Ctd_xxx_p + 2.0 * Ct_yxy_p * Ctd_yxy_p + Ct_yyy_p * Ctd_xxy_p + Ct_zxy_p * Ctd_yxz_p + Ct_zxy_p * Ctd_zxy_p + Ct_zyy_p * Ctd_xxz_p) + gtu_xx_p * (Ct_xxx_p * Ctd_yxx_p + Ct_xxx_p * Ctd_xxy_p + Ct_xxy_p * Ctd_xxx_p + 2.0 * Ct_yxx_p * Ctd_yxy_p + Ct_yxy_p * Ctd_xxy_p + Ct_zxx_p * Ctd_yxz_p + Ct_zxx_p * Ctd_zxy_p + Ct_zxy_p * Ctd_xxz_p) + .5 * un(i, j, k, Gamh_z) * (Ctd_xyz_p + Ctd_yxz_p) + .5 * un(i, j, k, Gamh_y) * (Ctd_xyy_p + Ctd_yxy_p) + .5 * un(i, j, k, Gamh_x) * (Ctd_xxy_p + Ctd_yxx_p);
					m_Rtd_xy_o0_t11_l0_p = .5 * un(i, j, k, gtd_yz) * d_Rtd_xx_o0_t8_m0_l0;
					m_Rtd_xy_o0_t10_l0_p = .5 * un(i, j, k, gtd_yy) * d_Rtd_xx_o0_t7_m0_l0;
					m_Rtd_xy_o0_t9_l0_p = .5 * un(i, j, k, gtd_xy) * d_Rtd_xx_o0_t6_m0_l0;
					m_Rtd_xy_o0_t8_l0_p = .5 * un(i, j, k, gtd_xz) * d_Rtd_xy_o0_t8_m0_l0;
					m_Rtd_xy_o0_t7_l0_p = .5 * un(i, j, k, gtd_xy) * d_Rtd_xy_o0_t7_m0_l0;
					m_Rtd_xy_o0_t6_l0_p = .5 * un(i, j, k, gtd_xx) * d_Rtd_xy_o0_t6_m0_l0;
					m_Rtd_xy_o0_t5_l0_p = (-.5 * gtu_zz_p) * d_Rtd_xy_o0_t5_m0_l0;
					m_Rtd_xy_o0_t4_l0_p = (-1.0 * gtu_yz_p) * d_Rtd_xy_o0_t4_m0_l0;
					m_Rtd_xy_o0_t3_l0_p = (-.5 * gtu_yy_p) * d_Rtd_xy_o0_t3_m0_l0;
					m_Rtd_xy_o0_t2_l0_p = (-1.0 * gtu_xz_p) * d_Rtd_xy_o0_t2_m0_l0;
					m_Rtd_xy_o0_t1_l0_p = (-1.0 * gtu_xy_p) * d_Rtd_xy_o0_t1_m0_l0;
					m_Rtd_xy_o0_t0_l0_p = (-.5 * gtu_xx_p) * d_Rtd_xy_o0_t0_m0_l0;
					Rtd_xy_p = (((((((((((m_Rtd_xy_o0_t0_l0_p + m_Rtd_xy_o0_t1_l0_p) + m_Rtd_xy_o0_t2_l0_p) + m_Rtd_xy_o0_t3_l0_p) + m_Rtd_xy_o0_t4_l0_p) + m_Rtd_xy_o0_t5_l0_p) + m_Rtd_xy_o0_t6_l0_p) + m_Rtd_xy_o0_t7_l0_p) + m_Rtd_xy_o0_t8_l0_p) + m_Rtd_xy_o0_t9_l0_p) + m_Rtd_xy_o0_t10_l0_p) + m_Rtd_xy_o0_t11_l0_p) + d_Rtd_xy_o0_t12_m0_l0_p;
					d_Rtd_yy_o0_t9_m0_l0_p = gtu_zz_p * (2.0 * Ct_xyz_p * Ctd_yxz_p + Ct_xyz_p * Ctd_xyz_p + 3.0 * Ct_yyz_p * Ctd_yyz_p + 2.0 * Ct_zyz_p * Ctd_yzz_p + Ct_zyz_p * Ctd_zyz_p) + gtu_yz_p * (2.0 * Ct_xyy_p * Ctd_yxz_p + Ct_xyy_p * Ctd_xyz_p + 3.0 * Ct_yyy_p * Ctd_yyz_p + 2.0 * Ct_zyy_p * Ctd_yzz_p + Ct_zyy_p * Ctd_zyz_p) + gtu_xz_p * (2.0 * Ct_xxy_p * Ctd_yxz_p + Ct_xxy_p * Ctd_xyz_p + 3.0 * Ct_yxy_p * Ctd_yyz_p + 2.0 * Ct_zxy_p * Ctd_yzz_p + Ct_zxy_p * Ctd_zyz_p) + gtu_yz_p * (2.0 * Ct_xyz_p * Ctd_yxy_p + Ct_xyz_p * Ctd_xyy_p + 3.0 * Ct_yyz_p * Ctd_yyy_p + 2.0 * Ct_zyz_p * Ctd_yyz_p + Ct_zyz_p * Ctd_zyy_p) + gtu_yy_p * (2.0 * Ct_xyy_p * Ctd_yxy_p + Ct_xyy_p * Ctd_xyy_p + 3.0 * Ct_yyy_p * Ctd_yyy_p + 2.0 * Ct_zyy_p * Ctd_yyz_p + Ct_zyy_p * Ctd_zyy_p) + gtu_xy_p * (2.0 * Ct_xxy_p * Ctd_yxy_p + Ct_xxy_p * Ctd_xyy_p + 3.0 * Ct_yxy_p * Ctd_yyy_p + 2.0 * Ct_zxy_p * Ctd_yyz_p + Ct_zxy_p * Ctd_zyy_p) + gtu_xz_p * (2.0 * Ct_xyz_p * Ctd_yxx_p + Ct_xyz_p * Ctd_xxy_p + 3.0 * Ct_yyz_p * Ctd_yxy_p + 2.0 * Ct_zyz_p * Ctd_yxz_p + Ct_zyz_p * Ctd_zxy_p) + gtu_xy_p * (2.0 * Ct_xyy_p * Ctd_yxx_p + Ct_xyy_p * Ctd_xxy_p + 3.0 * Ct_yyy_p * Ctd_yxy_p + 2.0 * Ct_zyy_p * Ctd_yxz_p + Ct_zyy_p * Ctd_zxy_p) + gtu_xx_p * (2.0 * Ct_xxy_p * Ctd_yxx_p + Ct_xxy_p * Ctd_xxy_p + 3.0 * Ct_yxy_p * Ctd_yxy_p + 2.0 * Ct_zxy_p * Ctd_yxz_p + Ct_zxy_p * Ctd_zxy_p) + 1.0 * un(i, j, k, Gamh_z) * Ctd_yyz_p + 1.0 * un(i, j, k, Gamh_y) * Ctd_yyy_p + 1.0 * un(i, j, k, Gamh_x) * Ctd_yxy_p;
					m_Rtd_yy_o0_t8_l0_p = 1.0 * un(i, j, k, gtd_yz) * d_Rtd_xy_o0_t8_m0_l0;
					m_Rtd_yy_o0_t7_l0_p = 1.0 * un(i, j, k, gtd_yy) * d_Rtd_xy_o0_t7_m0_l0;
					m_Rtd_yy_o0_t6_l0_p = 1.0 * un(i, j, k, gtd_xy) * d_Rtd_xy_o0_t6_m0_l0;
					m_Rtd_yy_o0_t5_l0_p = (-.5 * gtu_zz_p) * d_Rtd_yy_o0_t5_m0_l0;
					m_Rtd_yy_o0_t4_l0_p = (-1.0 * gtu_yz_p) * d_Rtd_yy_o0_t4_m0_l0;
					m_Rtd_yy_o0_t3_l0_p = (-.5 * gtu_yy_p) * d_Rtd_yy_o0_t3_m0_l0;
					m_Rtd_yy_o0_t2_l0_p = (-1.0 * gtu_xz_p) * d_Rtd_yy_o0_t2_m0_l0;
					m_Rtd_yy_o0_t1_l0_p = (-1.0 * gtu_xy_p) * d_Rtd_yy_o0_t1_m0_l0;
					m_Rtd_yy_o0_t0_l0_p = (-.5 * gtu_xx_p) * d_Rtd_yy_o0_t0_m0_l0;
					Rtd_yy_p = ((((((((m_Rtd_yy_o0_t0_l0_p + m_Rtd_yy_o0_t1_l0_p) + m_Rtd_yy_o0_t2_l0_p) + m_Rtd_yy_o0_t3_l0_p) + m_Rtd_yy_o0_t4_l0_p) + m_Rtd_yy_o0_t5_l0_p) + m_Rtd_yy_o0_t6_l0_p) + m_Rtd_yy_o0_t7_l0_p) + m_Rtd_yy_o0_t8_l0_p) + d_Rtd_yy_o0_t9_m0_l0_p;
					d_Rtd_yz_o0_t12_m0_l0_p = gtu_zz_p * (Ct_xyz_p * Ctd_zxz_p + Ct_xyz_p * Ctd_xzz_p + Ct_xzz_p * Ctd_yxz_p + Ct_yyz_p * Ctd_zyz_p + Ct_yyz_p * Ctd_yzz_p + Ct_yzz_p * Ctd_yyz_p + 2.0 * Ct_zyz_p * Ctd_zzz_p + Ct_zzz_p * Ctd_yzz_p) + gtu_yz_p * (Ct_xyy_p * Ctd_zxz_p + Ct_xyy_p * Ctd_xzz_p + Ct_xyz_p * Ctd_yxz_p + Ct_yyy_p * Ctd_zyz_p + Ct_yyy_p * Ctd_yzz_p + Ct_yyz_p * Ctd_yyz_p + 2.0 * Ct_zyy_p * Ctd_zzz_p + Ct_zyz_p * Ctd_yzz_p) + gtu_xz_p * (Ct_xxy_p * Ctd_zxz_p + Ct_xxy_p * Ctd_xzz_p + Ct_xxz_p * Ctd_yxz_p + Ct_yxy_p * Ctd_zyz_p + Ct_yxy_p * Ctd_yzz_p + Ct_yxz_p * Ctd_yyz_p + 2.0 * Ct_zxy_p * Ctd_zzz_p + Ct_zxz_p * Ctd_yzz_p) + gtu_yz_p * (Ct_xyz_p * Ctd_zxy_p + Ct_xyz_p * Ctd_xyz_p + Ct_xzz_p * Ctd_yxy_p + Ct_yyz_p * Ctd_zyy_p + Ct_yyz_p * Ctd_yyz_p + Ct_yzz_p * Ctd_yyy_p + 2.0 * Ct_zyz_p * Ctd_zyz_p + Ct_zzz_p * Ctd_yyz_p) + gtu_yy_p * (Ct_xyy_p * Ctd_zxy_p + Ct_xyy_p * Ctd_xyz_p + Ct_xyz_p * Ctd_yxy_p + Ct_yyy_p * Ctd_zyy_p + Ct_yyy_p * Ctd_yyz_p + Ct_yyz_p * Ctd_yyy_p + 2.0 * Ct_zyy_p * Ctd_zyz_p + Ct_zyz_p * Ctd_yyz_p) + gtu_xy_p * (Ct_xxy_p * Ctd_zxy_p + Ct_xxy_p * Ctd_xyz_p + Ct_xxz_p * Ctd_yxy_p + Ct_yxy_p * Ctd_zyy_p + Ct_yxy_p * Ctd_yyz_p + Ct_yxz_p * Ctd_yyy_p + 2.0 * Ct_zxy_p * Ctd_zyz_p + Ct_zxz_p * Ctd_yyz_p) + gtu_xz_p * (Ct_xyz_p * Ctd_zxx_p + Ct_xyz_p * Ctd_xxz_p + Ct_xzz_p * Ctd_yxx_p + Ct_yyz_p * Ctd_zxy_p + Ct_yyz_p * Ctd_yxz_p + Ct_yzz_p * Ctd_yxy_p + 2.0 * Ct_zyz_p * Ctd_zxz_p + Ct_zzz_p * Ctd_yxz_p) + gtu_xy_p * (Ct_xyy_p * Ctd_zxx_p + Ct_xyy_p * Ctd_xxz_p + Ct_xyz_p * Ctd_yxx_p + Ct_yyy_p * Ctd_zxy_p + Ct_yyy_p * Ctd_yxz_p + Ct_yyz_p * Ctd_yxy_p + 2.0 * Ct_zyy_p * Ctd_zxz_p + Ct_zyz_p * Ctd_yxz_p) + gtu_xx_p * (Ct_xxy_p * Ctd_zxx_p + Ct_xxy_p * Ctd_xxz_p + Ct_xxz_p * Ctd_yxx_p + Ct_yxy_p * Ctd_zxy_p + Ct_yxy_p * Ctd_yxz_p + Ct_yxz_p * Ctd_yxy_p + 2.0 * Ct_zxy_p * Ctd_zxz_p + Ct_zxz_p * Ctd_yxz_p) + .5 * un(i, j, k, Gamh_z) * (Ctd_yzz_p + Ctd_zyz_p) + .5 * un(i, j, k, Gamh_y) * (Ctd_yyz_p + Ctd_zyy_p) + .5 * un(i, j, k, Gamh_x) * (Ctd_yxz_p + Ctd_zxy_p);
					m_Rtd_yz_o0_t11_l0_p = .5 * un(i, j, k, gtd_zz) * d_Rtd_xy_o0_t8_m0_l0;
					m_Rtd_yz_o0_t10_l0_p = .5 * un(i, j, k, gtd_yz) * d_Rtd_xy_o0_t7_m0_l0;
					m_Rtd_yz_o0_t9_l0_p = .5 * un(i, j, k, gtd_xz) * d_Rtd_xy_o0_t6_m0_l0;
					m_Rtd_yz_o0_t8_l0_p = .5 * un(i, j, k, gtd_yz) * d_Rtd_xz_o0_t8_m0_l0;
					m_Rtd_yz_o0_t7_l0_p = .5 * un(i, j, k, gtd_yy) * d_Rtd_xz_o0_t7_m0_l0;
					m_Rtd_yz_o0_t6_l0_p = .5 * un(i, j, k, gtd_xy) * d_Rtd_xz_o0_t6_m0_l0;
					m_Rtd_yz_o0_t5_l0_p = (-.5 * gtu_zz_p) * d_Rtd_yz_o0_t5_m0_l0;
					m_Rtd_yz_o0_t4_l0_p = (-1.0 * gtu_yz_p) * d_Rtd_yz_o0_t4_m0_l0;
					m_Rtd_yz_o0_t3_l0_p = (-.5 * gtu_yy_p) * d_Rtd_yz_o0_t3_m0_l0;
					m_Rtd_yz_o0_t2_l0_p = (-1.0 * gtu_xz_p) * d_Rtd_yz_o0_t2_m0_l0;
					m_Rtd_yz_o0_t1_l0_p = (-1.0 * gtu_xy_p) * d_Rtd_yz_o0_t1_m0_l0;
					m_Rtd_yz_o0_t0_l0_p = (-.5 * gtu_xx_p) * d_Rtd_yz_o0_t0_m0_l0;
					Rtd_yz_p = (((((((((((m_Rtd_yz_o0_t0_l0_p + m_Rtd_yz_o0_t1_l0_p) + m_Rtd_yz_o0_t2_l0_p) + m_Rtd_yz_o0_t3_l0_p) + m_Rtd_yz_o0_t4_l0_p) + m_Rtd_yz_o0_t5_l0_p) + m_Rtd_yz_o0_t6_l0_p) + m_Rtd_yz_o0_t7_l0_p) + m_Rtd_yz_o0_t8_l0_p) + m_Rtd_yz_o0_t9_l0_p) + m_Rtd_yz_o0_t10_l0_p) + m_Rtd_yz_o0_t11_l0_p) + d_Rtd_yz_o0_t12_m0_l0_p;
					m_Rpd_xx_o0_t22_l0_p = .5 * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_xx_o0_t21_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xx) * gtu_zz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xx_o0_t20_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xx) * gtu_yy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xx_o0_t19_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xx) * gtu_xx_p * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t18_l0_p = 2.0 * inv_chi_p * Zu_z_p * un(i, j, k, gtd_xz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t17_l0_p = 2.0 * inv_chi_p * Zu_y_p * un(i, j, k, gtd_xy) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t16_l0_p = 2.0 * inv_chi_p * Zu_x_p * un(i, j, k, gtd_xx) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t15_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xx) * gtu_yz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xx_o0_t14_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xx) * gtu_xz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t13_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xx) * gtu_xy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t12_l0_p = (-.2500000000000000 * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t11_l0_p = (-.5 * Ct_zxx_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xx_o0_t10_l0_p = (-.5 * Ct_yxx_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xx_o0_t9_l0_p = (-.5 * Ct_xxx_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xx_o0_t8_l0_p = .5 * un(i, j, k, gtd_xx) * gtu_zz_p * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_xx_o0_t7_l0_p = 1.0 * un(i, j, k, gtd_xx) * gtu_yz_p * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_xx_o0_t6_l0_p = .5 * un(i, j, k, gtd_xx) * gtu_yy_p * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_xx_o0_t5_l0_p = 1.0 * un(i, j, k, gtd_xx) * gtu_xz_p * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_xx_o0_t4_l0_p = 1.0 * un(i, j, k, gtd_xx) * gtu_xy_p * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_xx_o0_t3_l0_p = .5 * un(i, j, k, gtd_xx) * gtu_xx_p * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_xx_o0_t2_l0_p = (-.5 * un(i, j, k, gtd_xx) * un(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xx_o0_t1_l0_p = (-.5 * un(i, j, k, gtd_xx) * un(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xx_o0_t0_l0_p = (-.5 * un(i, j, k, gtd_xx) * un(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					Rpd_xx_p = (((((((((((((((((((((m_Rpd_xx_o0_t0_l0_p + m_Rpd_xx_o0_t1_l0_p) + m_Rpd_xx_o0_t2_l0_p) + m_Rpd_xx_o0_t3_l0_p) + m_Rpd_xx_o0_t4_l0_p) + m_Rpd_xx_o0_t5_l0_p) + m_Rpd_xx_o0_t6_l0_p) + m_Rpd_xx_o0_t7_l0_p) + m_Rpd_xx_o0_t8_l0_p) + m_Rpd_xx_o0_t9_l0_p) + m_Rpd_xx_o0_t10_l0_p) + m_Rpd_xx_o0_t11_l0_p) + m_Rpd_xx_o0_t12_l0_p) + m_Rpd_xx_o0_t13_l0_p) + m_Rpd_xx_o0_t14_l0_p) + m_Rpd_xx_o0_t15_l0_p) + m_Rpd_xx_o0_t16_l0_p) + m_Rpd_xx_o0_t17_l0_p) + m_Rpd_xx_o0_t18_l0_p) + m_Rpd_xx_o0_t19_l0_p) + m_Rpd_xx_o0_t20_l0_p) + m_Rpd_xx_o0_t21_l0_p) + m_Rpd_xx_o0_t22_l0_p;
					m_Rpd_yy_o0_t22_l0_p = .5 * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_yy_o0_t21_l0_p = (-.7500000000000000 * un(i, j, k, gtd_yy) * gtu_zz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yy_o0_t20_l0_p = (-.7500000000000000 * un(i, j, k, gtd_yy) * gtu_yy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t19_l0_p = (-.7500000000000000 * un(i, j, k, gtd_yy) * gtu_xx_p * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yy_o0_t18_l0_p = 2.0 * inv_chi_p * Zu_z_p * un(i, j, k, gtd_yz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t17_l0_p = 2.0 * inv_chi_p * Zu_y_p * un(i, j, k, gtd_yy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t16_l0_p = 2.0 * inv_chi_p * Zu_x_p * un(i, j, k, gtd_xy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t15_l0_p = .5 * un(i, j, k, gtd_yy) * gtu_zz_p * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_yy_o0_t14_l0_p = 1.0 * un(i, j, k, gtd_yy) * gtu_yz_p * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_yy_o0_t13_l0_p = .5 * un(i, j, k, gtd_yy) * gtu_yy_p * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_yy_o0_t12_l0_p = 1.0 * un(i, j, k, gtd_yy) * gtu_xz_p * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_yy_o0_t11_l0_p = 1.0 * un(i, j, k, gtd_yy) * gtu_xy_p * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_yy_o0_t10_l0_p = .5 * un(i, j, k, gtd_yy) * gtu_xx_p * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_yy_o0_t9_l0_p = (-.5 * un(i, j, k, gtd_yy) * un(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yy_o0_t8_l0_p = (-.5 * un(i, j, k, gtd_yy) * un(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t7_l0_p = (-.5 * un(i, j, k, gtd_yy) * un(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yy_o0_t6_l0_p = (-.2500000000000000 * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t5_l0_p = (-.5 * Ct_zyy_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yy_o0_t4_l0_p = (-.5 * Ct_yyy_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t3_l0_p = (-.5 * Ct_xyy_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yy_o0_t2_l0_p = (-1.500000000000000 * un(i, j, k, gtd_yy) * gtu_yz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yy_o0_t1_l0_p = (-1.500000000000000 * un(i, j, k, gtd_yy) * gtu_xz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yy_o0_t0_l0_p = (-1.500000000000000 * un(i, j, k, gtd_yy) * gtu_xy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					Rpd_yy_p = (((((((((((((((((((((m_Rpd_yy_o0_t0_l0_p + m_Rpd_yy_o0_t1_l0_p) + m_Rpd_yy_o0_t2_l0_p) + m_Rpd_yy_o0_t3_l0_p) + m_Rpd_yy_o0_t4_l0_p) + m_Rpd_yy_o0_t5_l0_p) + m_Rpd_yy_o0_t6_l0_p) + m_Rpd_yy_o0_t7_l0_p) + m_Rpd_yy_o0_t8_l0_p) + m_Rpd_yy_o0_t9_l0_p) + m_Rpd_yy_o0_t10_l0_p) + m_Rpd_yy_o0_t11_l0_p) + m_Rpd_yy_o0_t12_l0_p) + m_Rpd_yy_o0_t13_l0_p) + m_Rpd_yy_o0_t14_l0_p) + m_Rpd_yy_o0_t15_l0_p) + m_Rpd_yy_o0_t16_l0_p) + m_Rpd_yy_o0_t17_l0_p) + m_Rpd_yy_o0_t18_l0_p) + m_Rpd_yy_o0_t19_l0_p) + m_Rpd_yy_o0_t20_l0_p) + m_Rpd_yy_o0_t21_l0_p) + m_Rpd_yy_o0_t22_l0_p;
					m_Rpd_yz_o0_t25_l0_p = .5 * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_yz_o0_t24_l0_p = (-.7500000000000000 * un(i, j, k, gtd_yz) * gtu_zz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t23_l0_p = (-.7500000000000000 * un(i, j, k, gtd_yz) * gtu_yy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t22_l0_p = (-.7500000000000000 * un(i, j, k, gtd_yz) * gtu_xx_p * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yz_o0_t21_l0_p = inv_chi_p * Zu_z_p * un(i, j, k, gtd_zz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t20_l0_p = inv_chi_p * Zu_y_p * un(i, j, k, gtd_yz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t19_l0_p = inv_chi_p * Zu_x_p * un(i, j, k, gtd_xz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t18_l0_p = inv_chi_p * Zu_z_p * un(i, j, k, gtd_yz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t17_l0_p = inv_chi_p * Zu_y_p * un(i, j, k, gtd_yy) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t16_l0_p = inv_chi_p * Zu_x_p * un(i, j, k, gtd_xy) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t15_l0_p = (-.2500000000000000 * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t14_l0_p = .5 * un(i, j, k, gtd_yz) * gtu_zz_p * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_yz_o0_t13_l0_p = 1.0 * un(i, j, k, gtd_yz) * gtu_yz_p * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_yz_o0_t12_l0_p = .5 * un(i, j, k, gtd_yz) * gtu_yy_p * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_yz_o0_t11_l0_p = 1.0 * un(i, j, k, gtd_yz) * gtu_xz_p * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_yz_o0_t10_l0_p = 1.0 * un(i, j, k, gtd_yz) * gtu_xy_p * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_yz_o0_t9_l0_p = .5 * un(i, j, k, gtd_yz) * gtu_xx_p * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_yz_o0_t8_l0_p = (-.5 * un(i, j, k, gtd_yz) * un(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t7_l0_p = (-.5 * un(i, j, k, gtd_yz) * un(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t6_l0_p = (-.5 * un(i, j, k, gtd_yz) * un(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yz_o0_t5_l0_p = (-.5 * Ct_zyz_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_yz_o0_t4_l0_p = (-.5 * Ct_yyz_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t3_l0_p = (-.5 * Ct_xyz_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yz_o0_t2_l0_p = (-1.500000000000000 * un(i, j, k, gtd_yz) * gtu_yz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_yz_o0_t1_l0_p = (-1.500000000000000 * un(i, j, k, gtd_yz) * gtu_xz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_yz_o0_t0_l0_p = (-1.500000000000000 * un(i, j, k, gtd_yz) * gtu_xy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					Rpd_yz_p = ((((((((((((((((((((((((m_Rpd_yz_o0_t0_l0_p + m_Rpd_yz_o0_t1_l0_p) + m_Rpd_yz_o0_t2_l0_p) + m_Rpd_yz_o0_t3_l0_p) + m_Rpd_yz_o0_t4_l0_p) + m_Rpd_yz_o0_t5_l0_p) + m_Rpd_yz_o0_t6_l0_p) + m_Rpd_yz_o0_t7_l0_p) + m_Rpd_yz_o0_t8_l0_p) + m_Rpd_yz_o0_t9_l0_p) + m_Rpd_yz_o0_t10_l0_p) + m_Rpd_yz_o0_t11_l0_p) + m_Rpd_yz_o0_t12_l0_p) + m_Rpd_yz_o0_t13_l0_p) + m_Rpd_yz_o0_t14_l0_p) + m_Rpd_yz_o0_t15_l0_p) + m_Rpd_yz_o0_t16_l0_p) + m_Rpd_yz_o0_t17_l0_p) + m_Rpd_yz_o0_t18_l0_p) + m_Rpd_yz_o0_t19_l0_p) + m_Rpd_yz_o0_t20_l0_p) + m_Rpd_yz_o0_t21_l0_p) + m_Rpd_yz_o0_t22_l0_p) + m_Rpd_yz_o0_t23_l0_p) + m_Rpd_yz_o0_t24_l0_p) + m_Rpd_yz_o0_t25_l0_p;
					m_Rpd_xz_o0_t25_l0_p = .5 * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_xz_o0_t24_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xz) * gtu_zz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t23_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xz) * gtu_yy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xz_o0_t22_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xz) * gtu_xx_p * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t21_l0_p = inv_chi_p * Zu_z_p * un(i, j, k, gtd_zz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t20_l0_p = inv_chi_p * Zu_y_p * un(i, j, k, gtd_yz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t19_l0_p = inv_chi_p * Zu_x_p * un(i, j, k, gtd_xz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t18_l0_p = inv_chi_p * Zu_z_p * un(i, j, k, gtd_xz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t17_l0_p = inv_chi_p * Zu_y_p * un(i, j, k, gtd_xy) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t16_l0_p = inv_chi_p * Zu_x_p * un(i, j, k, gtd_xx) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t15_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xz) * gtu_xz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t14_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xz) * gtu_xy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t13_l0_p = 1.0 * un(i, j, k, gtd_xz) * gtu_yz_p * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_xz_o0_t12_l0_p = .5 * un(i, j, k, gtd_xz) * gtu_yy_p * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_xz_o0_t11_l0_p = 1.0 * un(i, j, k, gtd_xz) * gtu_xz_p * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_xz_o0_t10_l0_p = 1.0 * un(i, j, k, gtd_xz) * gtu_xy_p * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_xz_o0_t9_l0_p = .5 * un(i, j, k, gtd_xz) * gtu_xx_p * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_xz_o0_t8_l0_p = (-.5 * un(i, j, k, gtd_xz) * un(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t7_l0_p = (-.5 * un(i, j, k, gtd_xz) * un(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xz_o0_t6_l0_p = (-.5 * un(i, j, k, gtd_xz) * un(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t5_l0_p = (-.2500000000000000 * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t4_l0_p = .5 * un(i, j, k, gtd_xz) * gtu_zz_p * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_xz_o0_t3_l0_p = (-.5 * Ct_zxz_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xz_o0_t2_l0_p = (-.5 * Ct_yxz_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xz_o0_t1_l0_p = (-.5 * Ct_xxz_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xz_o0_t0_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xz) * gtu_yz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					Rpd_xz_p = ((((((((((((((((((((((((m_Rpd_xz_o0_t0_l0_p + m_Rpd_xz_o0_t1_l0_p) + m_Rpd_xz_o0_t2_l0_p) + m_Rpd_xz_o0_t3_l0_p) + m_Rpd_xz_o0_t4_l0_p) + m_Rpd_xz_o0_t5_l0_p) + m_Rpd_xz_o0_t6_l0_p) + m_Rpd_xz_o0_t7_l0_p) + m_Rpd_xz_o0_t8_l0_p) + m_Rpd_xz_o0_t9_l0_p) + m_Rpd_xz_o0_t10_l0_p) + m_Rpd_xz_o0_t11_l0_p) + m_Rpd_xz_o0_t12_l0_p) + m_Rpd_xz_o0_t13_l0_p) + m_Rpd_xz_o0_t14_l0_p) + m_Rpd_xz_o0_t15_l0_p) + m_Rpd_xz_o0_t16_l0_p) + m_Rpd_xz_o0_t17_l0_p) + m_Rpd_xz_o0_t18_l0_p) + m_Rpd_xz_o0_t19_l0_p) + m_Rpd_xz_o0_t20_l0_p) + m_Rpd_xz_o0_t21_l0_p) + m_Rpd_xz_o0_t22_l0_p) + m_Rpd_xz_o0_t23_l0_p) + m_Rpd_xz_o0_t24_l0_p) + m_Rpd_xz_o0_t25_l0_p;
					m_Rpd_xy_o0_t25_l0_p = .5 * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_xy_o0_t24_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xy) * gtu_zz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xy_o0_t23_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xy) * gtu_yy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t22_l0_p = (-.7500000000000000 * un(i, j, k, gtd_xy) * gtu_xx_p * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t21_l0_p = inv_chi_p * Zu_z_p * un(i, j, k, gtd_yz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t20_l0_p = inv_chi_p * Zu_y_p * un(i, j, k, gtd_yy) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t19_l0_p = inv_chi_p * Zu_x_p * un(i, j, k, gtd_xy) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t18_l0_p = inv_chi_p * Zu_z_p * un(i, j, k, gtd_xz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t17_l0_p = inv_chi_p * Zu_y_p * un(i, j, k, gtd_xy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t16_l0_p = inv_chi_p * Zu_x_p * un(i, j, k, gtd_xx) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t15_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xy) * gtu_yz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t14_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xy) * gtu_xz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t13_l0_p = (-1.500000000000000 * un(i, j, k, gtd_xy) * gtu_xy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t12_l0_p = (-.2500000000000000 * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t11_l0_p = .5 * un(i, j, k, gtd_xy) * gtu_zz_p * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_xy_o0_t10_l0_p = 1.0 * un(i, j, k, gtd_xy) * gtu_yz_p * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_xy_o0_t9_l0_p = .5 * un(i, j, k, gtd_xy) * gtu_yy_p * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_xy_o0_t8_l0_p = 1.0 * un(i, j, k, gtd_xy) * gtu_xz_p * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_xy_o0_t7_l0_p = 1.0 * un(i, j, k, gtd_xy) * gtu_xy_p * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_xy_o0_t6_l0_p = .5 * un(i, j, k, gtd_xy) * gtu_xx_p * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_xy_o0_t5_l0_p = (-.5 * un(i, j, k, gtd_xy) * un(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xy_o0_t4_l0_p = (-.5 * un(i, j, k, gtd_xy) * un(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t3_l0_p = (-.5 * un(i, j, k, gtd_xy) * un(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_xy_o0_t2_l0_p = (-.5 * Ct_zxy_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_xy_o0_t1_l0_p = (-.5 * Ct_yxy_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_xy_o0_t0_l0_p = (-.5 * Ct_xxy_p) * d_Rpd_xx_o0_t0_m0_l0;
					Rpd_xy_p = ((((((((((((((((((((((((m_Rpd_xy_o0_t0_l0_p + m_Rpd_xy_o0_t1_l0_p) + m_Rpd_xy_o0_t2_l0_p) + m_Rpd_xy_o0_t3_l0_p) + m_Rpd_xy_o0_t4_l0_p) + m_Rpd_xy_o0_t5_l0_p) + m_Rpd_xy_o0_t6_l0_p) + m_Rpd_xy_o0_t7_l0_p) + m_Rpd_xy_o0_t8_l0_p) + m_Rpd_xy_o0_t9_l0_p) + m_Rpd_xy_o0_t10_l0_p) + m_Rpd_xy_o0_t11_l0_p) + m_Rpd_xy_o0_t12_l0_p) + m_Rpd_xy_o0_t13_l0_p) + m_Rpd_xy_o0_t14_l0_p) + m_Rpd_xy_o0_t15_l0_p) + m_Rpd_xy_o0_t16_l0_p) + m_Rpd_xy_o0_t17_l0_p) + m_Rpd_xy_o0_t18_l0_p) + m_Rpd_xy_o0_t19_l0_p) + m_Rpd_xy_o0_t20_l0_p) + m_Rpd_xy_o0_t21_l0_p) + m_Rpd_xy_o0_t22_l0_p) + m_Rpd_xy_o0_t23_l0_p) + m_Rpd_xy_o0_t24_l0_p) + m_Rpd_xy_o0_t25_l0_p;
					m_Rpd_zz_o0_t22_l0_p = .5 * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_zz_o0_t21_l0_p = (-.7500000000000000 * un(i, j, k, gtd_zz) * gtu_zz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t20_l0_p = (-.7500000000000000 * un(i, j, k, gtd_zz) * gtu_yy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_zz_o0_t19_l0_p = (-.7500000000000000 * un(i, j, k, gtd_zz) * gtu_xx_p * inv_chi_p) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_zz_o0_t18_l0_p = 2.0 * inv_chi_p * Zu_z_p * un(i, j, k, gtd_zz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t17_l0_p = 2.0 * inv_chi_p * Zu_y_p * un(i, j, k, gtd_yz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t16_l0_p = 2.0 * inv_chi_p * Zu_x_p * un(i, j, k, gtd_xz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t15_l0_p = .5 * un(i, j, k, gtd_zz) * gtu_zz_p * d_Rpd_xx_o0_t8_m0_l0;
					m_Rpd_zz_o0_t14_l0_p = 1.0 * un(i, j, k, gtd_zz) * gtu_yz_p * d_Rpd_xx_o0_t7_m0_l0;
					m_Rpd_zz_o0_t13_l0_p = .5 * un(i, j, k, gtd_zz) * gtu_yy_p * d_Rpd_xx_o0_t6_m0_l0;
					m_Rpd_zz_o0_t12_l0_p = 1.0 * un(i, j, k, gtd_zz) * gtu_xz_p * d_Rpd_xx_o0_t5_m0_l0;
					m_Rpd_zz_o0_t11_l0_p = 1.0 * un(i, j, k, gtd_zz) * gtu_xy_p * d_Rpd_xx_o0_t4_m0_l0;
					m_Rpd_zz_o0_t10_l0_p = .5 * un(i, j, k, gtd_zz) * gtu_xx_p * d_Rpd_xx_o0_t3_m0_l0;
					m_Rpd_zz_o0_t9_l0_p = (-.5 * un(i, j, k, gtd_zz) * un(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t8_l0_p = (-.5 * un(i, j, k, gtd_zz) * un(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_zz_o0_t7_l0_p = (-.5 * un(i, j, k, gtd_zz) * un(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_zz_o0_t6_l0_p = (-.2500000000000000 * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t5_l0_p = (-.5 * Ct_zzz_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Rpd_zz_o0_t4_l0_p = (-.5 * Ct_yzz_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_zz_o0_t3_l0_p = (-.5 * Ct_xzz_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_zz_o0_t2_l0_p = (-1.500000000000000 * un(i, j, k, gtd_zz) * gtu_yz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Rpd_zz_o0_t1_l0_p = (-1.500000000000000 * un(i, j, k, gtd_zz) * gtu_xz_p * inv_chi_p) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Rpd_zz_o0_t0_l0_p = (-1.500000000000000 * un(i, j, k, gtd_zz) * gtu_xy_p * inv_chi_p) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					Rpd_zz_p = (((((((((((((((((((((m_Rpd_zz_o0_t0_l0_p + m_Rpd_zz_o0_t1_l0_p) + m_Rpd_zz_o0_t2_l0_p) + m_Rpd_zz_o0_t3_l0_p) + m_Rpd_zz_o0_t4_l0_p) + m_Rpd_zz_o0_t5_l0_p) + m_Rpd_zz_o0_t6_l0_p) + m_Rpd_zz_o0_t7_l0_p) + m_Rpd_zz_o0_t8_l0_p) + m_Rpd_zz_o0_t9_l0_p) + m_Rpd_zz_o0_t10_l0_p) + m_Rpd_zz_o0_t11_l0_p) + m_Rpd_zz_o0_t12_l0_p) + m_Rpd_zz_o0_t13_l0_p) + m_Rpd_zz_o0_t14_l0_p) + m_Rpd_zz_o0_t15_l0_p) + m_Rpd_zz_o0_t16_l0_p) + m_Rpd_zz_o0_t17_l0_p) + m_Rpd_zz_o0_t18_l0_p) + m_Rpd_zz_o0_t19_l0_p) + m_Rpd_zz_o0_t20_l0_p) + m_Rpd_zz_o0_t21_l0_p) + m_Rpd_zz_o0_t22_l0_p;
					Rscalar_p = (chi_max_p * Rtd_xx_p + Rpd_xx_p) * gtu_xx_p + 2.0 * (chi_max_p * Rtd_xy_p + Rpd_xy_p) * gtu_xy_p + 2.0 * (chi_max_p * Rtd_xz_p + Rpd_xz_p) * gtu_xz_p + (chi_max_p * Rtd_yy_p + Rpd_yy_p) * gtu_yy_p + 2.0 * (chi_max_p * Rtd_yz_p + Rpd_yz_p) * gtu_yz_p + (chi_max_p * Rtd_zz_p + Rpd_zz_p) * gtu_zz_p;
					d_d_pheI4d_t_o0_t0_m0_l0_p = -un(i, j, k, Alpha) * un(i, j, k, peI);
					m_d_pheI4d_t_o0_t6_l0_p = std::min(0.0, un(i, j, k, Betau_z)) * d_d_pheI4d_t_o0_t3_m0_l0;
					m_d_pheI4d_t_o0_t5_l0_p = std::min(0.0, un(i, j, k, Betau_y)) * d_d_pheI4d_t_o0_t2_m0_l0;
					m_d_pheI4d_t_o0_t4_l0_p = std::min(0.0, un(i, j, k, Betau_x)) * d_d_pheI4d_t_o0_t1_m0_l0;
					m_d_pheI4d_t_o0_t3_l0_p = std::max(0.0, un(i, j, k, Betau_z)) * d_d_pheI4d_t_o0_t3_m0_l0;
					m_d_pheI4d_t_o0_t2_l0_p = std::max(0.0, un(i, j, k, Betau_y)) * d_d_pheI4d_t_o0_t2_m0_l0;
					m_d_pheI4d_t_o0_t1_l0_p = std::max(0.0, un(i, j, k, Betau_x)) * d_d_pheI4d_t_o0_t1_m0_l0;
					d_pheI4d_t_p = (((((d_d_pheI4d_t_o0_t0_m0_l0_p + m_d_pheI4d_t_o0_t1_l0_p) + m_d_pheI4d_t_o0_t2_l0_p) + m_d_pheI4d_t_o0_t3_l0_p) + m_d_pheI4d_t_o0_t4_l0_p) + m_d_pheI4d_t_o0_t5_l0_p) + m_d_pheI4d_t_o0_t6_l0_p;
					d_pheI4d_z_p = d_d_pheI4d_t_o0_t3_m0_l0;
					d_pheI4d_y_p = d_d_pheI4d_t_o0_t2_m0_l0;
					d_pheI4d_x_p = d_d_pheI4d_t_o0_t1_m0_l0;
					d_pheI4u_t_p = g4u_tt_p * d_pheI4d_t_p + g4u_tx_p * d_pheI4d_x_p + g4u_ty_p * d_pheI4d_y_p + g4u_tz_p * d_pheI4d_z_p;
					d_pheI4u_z_p = g4u_tz_p * d_pheI4d_t_p + g4u_xz_p * d_pheI4d_x_p + g4u_yz_p * d_pheI4d_y_p + g4u_zz_p * d_pheI4d_z_p;
					d_pheI4u_y_p = g4u_ty_p * d_pheI4d_t_p + g4u_xy_p * d_pheI4d_x_p + g4u_yy_p * d_pheI4d_y_p + g4u_yz_p * d_pheI4d_z_p;
					d_pheI4u_x_p = g4u_tx_p * d_pheI4d_t_p + g4u_xx_p * d_pheI4d_x_p + g4u_xy_p * d_pheI4d_y_p + g4u_xz_p * d_pheI4d_z_p;
					dphe4sq_p = d_pheR4u_t_p * d_pheR4d_t_p + d_pheR4u_x_p * d_pheR4d_x_p + d_pheR4u_y_p * d_pheR4d_y_p + d_pheR4u_z_p * d_pheR4d_z_p + d_pheI4u_t_p * d_pheI4d_t_p + d_pheI4u_x_p * d_pheI4d_x_p + d_pheI4u_y_p * d_pheI4d_y_p + d_pheI4u_z_p * d_pheI4d_z_p;
					Tsfu_zz_p = 2.0 * (d_phiR4u_z_p * d_phiR4u_z_p) + 2.0 * (d_phiI4u_z_p * d_phiI4u_z_p) + (-g4u_zz_p * (dphi4sq_p + sfVi_p)) + 2.0 * (d_pheR4u_z_p * d_pheR4u_z_p) + 2.0 * (d_pheI4u_z_p * d_pheI4u_z_p) + (-g4u_zz_p * (dphe4sq_p + sfVe_p));
					Tu_zz_p = Tsfu_zz_p;
					Tsfu_yz_p = 2.0 * d_phiR4u_y_p * d_phiR4u_z_p + 2.0 * d_phiI4u_y_p * d_phiI4u_z_p + (-g4u_yz_p * (dphi4sq_p + sfVi_p)) + 2.0 * d_pheR4u_y_p * d_pheR4u_z_p + 2.0 * d_pheI4u_y_p * d_pheI4u_z_p + (-g4u_yz_p * (dphe4sq_p + sfVe_p));
					Tu_yz_p = Tsfu_yz_p;
					Tsfu_yy_p = 2.0 * (d_phiR4u_y_p * d_phiR4u_y_p) + 2.0 * (d_phiI4u_y_p * d_phiI4u_y_p) + (-g4u_yy_p * (dphi4sq_p + sfVi_p)) + 2.0 * (d_pheR4u_y_p * d_pheR4u_y_p) + 2.0 * (d_pheI4u_y_p * d_pheI4u_y_p) + (-g4u_yy_p * (dphe4sq_p + sfVe_p));
					Tu_yy_p = Tsfu_yy_p;
					Tsfu_xz_p = 2.0 * d_phiR4u_x_p * d_phiR4u_z_p + 2.0 * d_phiI4u_x_p * d_phiI4u_z_p + (-g4u_xz_p * (dphi4sq_p + sfVi_p)) + 2.0 * d_pheR4u_x_p * d_pheR4u_z_p + 2.0 * d_pheI4u_x_p * d_pheI4u_z_p + (-g4u_xz_p * (dphe4sq_p + sfVe_p));
					Tu_xz_p = Tsfu_xz_p;
					Tsfu_xy_p = 2.0 * d_phiR4u_x_p * d_phiR4u_y_p + 2.0 * d_phiI4u_x_p * d_phiI4u_y_p + (-g4u_xy_p * (dphi4sq_p + sfVi_p)) + 2.0 * d_pheR4u_x_p * d_pheR4u_y_p + 2.0 * d_pheI4u_x_p * d_pheI4u_y_p + (-g4u_xy_p * (dphe4sq_p + sfVe_p));
					Tu_xy_p = Tsfu_xy_p;
					Tsfu_xx_p = 2.0 * (d_phiR4u_x_p * d_phiR4u_x_p) + 2.0 * (d_phiI4u_x_p * d_phiI4u_x_p) + (-g4u_xx_p * (dphi4sq_p + sfVi_p)) + 2.0 * (d_pheR4u_x_p * d_pheR4u_x_p) + 2.0 * (d_pheI4u_x_p * d_pheI4u_x_p) + (-g4u_xx_p * (dphe4sq_p + sfVe_p));
					Tu_xx_p = Tsfu_xx_p;
					Tsfu_tt_p = 2.0 * (d_phiR4u_t_p * d_phiR4u_t_p) + 2.0 * (d_phiI4u_t_p * d_phiI4u_t_p) + (-g4u_tt_p * (dphi4sq_p + sfVi_p)) + 2.0 * (d_pheR4u_t_p * d_pheR4u_t_p) + 2.0 * (d_pheI4u_t_p * d_pheI4u_t_p) + (-g4u_tt_p * (dphe4sq_p + sfVe_p));
					Tu_tt_p = Tsfu_tt_p;
					Tsfu_tz_p = 2.0 * d_phiR4u_t_p * d_phiR4u_z_p + 2.0 * d_phiI4u_t_p * d_phiI4u_z_p + (-g4u_tz_p * (dphi4sq_p + sfVi_p)) + 2.0 * d_pheR4u_t_p * d_pheR4u_z_p + 2.0 * d_pheI4u_t_p * d_pheI4u_z_p + (-g4u_tz_p * (dphe4sq_p + sfVe_p));
					Tu_tz_p = Tsfu_tz_p;
					Tsfu_ty_p = 2.0 * d_phiR4u_t_p * d_phiR4u_y_p + 2.0 * d_phiI4u_t_p * d_phiI4u_y_p + (-g4u_ty_p * (dphi4sq_p + sfVi_p)) + 2.0 * d_pheR4u_t_p * d_pheR4u_y_p + 2.0 * d_pheI4u_t_p * d_pheI4u_y_p + (-g4u_ty_p * (dphe4sq_p + sfVe_p));
					Tu_ty_p = Tsfu_ty_p;
					Tsfu_tx_p = 2.0 * d_phiR4u_t_p * d_phiR4u_x_p + 2.0 * d_phiI4u_t_p * d_phiI4u_x_p + (-g4u_tx_p * (dphi4sq_p + sfVi_p)) + 2.0 * d_pheR4u_t_p * d_pheR4u_x_p + 2.0 * d_pheI4u_t_p * d_pheI4u_x_p + (-g4u_tx_p * (dphe4sq_p + sfVe_p));
					Tu_tx_p = Tsfu_tx_p;
					pTtd_ADM_xz_p = Betatd_x_p * Betatd_z_p * Tu_tt_p + Betatd_x_p * (un(i, j, k, gtd_xz) * Tu_tx_p + un(i, j, k, gtd_yz) * Tu_ty_p + un(i, j, k, gtd_zz) * Tu_tz_p) + Betatd_z_p * (un(i, j, k, gtd_xx) * Tu_tx_p + un(i, j, k, gtd_xy) * Tu_ty_p + un(i, j, k, gtd_xz) * Tu_tz_p) + un(i, j, k, gtd_xx) * un(i, j, k, gtd_xz) * Tu_xx_p + un(i, j, k, gtd_xx) * un(i, j, k, gtd_yz) * Tu_xy_p + un(i, j, k, gtd_xx) * un(i, j, k, gtd_zz) * Tu_xz_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_xz) * Tu_xy_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_yz) * Tu_yy_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_zz) * Tu_yz_p + (un(i, j, k, gtd_xz) * un(i, j, k, gtd_xz)) * Tu_xz_p + un(i, j, k, gtd_xz) * un(i, j, k, gtd_yz) * Tu_yz_p + un(i, j, k, gtd_xz) * un(i, j, k, gtd_zz) * Tu_zz_p;
					pTtd_ADM_xy_p = Betatd_x_p * Betatd_y_p * Tu_tt_p + Betatd_x_p * (un(i, j, k, gtd_xy) * Tu_tx_p + un(i, j, k, gtd_yy) * Tu_ty_p + un(i, j, k, gtd_yz) * Tu_tz_p) + Betatd_y_p * (un(i, j, k, gtd_xx) * Tu_tx_p + un(i, j, k, gtd_xy) * Tu_ty_p + un(i, j, k, gtd_xz) * Tu_tz_p) + un(i, j, k, gtd_xx) * un(i, j, k, gtd_xy) * Tu_xx_p + un(i, j, k, gtd_xx) * un(i, j, k, gtd_yy) * Tu_xy_p + un(i, j, k, gtd_xx) * un(i, j, k, gtd_yz) * Tu_xz_p + (un(i, j, k, gtd_xy) * un(i, j, k, gtd_xy)) * Tu_xy_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_yy) * Tu_yy_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_yz) * Tu_yz_p + un(i, j, k, gtd_xz) * un(i, j, k, gtd_xy) * Tu_xz_p + un(i, j, k, gtd_xz) * un(i, j, k, gtd_yy) * Tu_yz_p + un(i, j, k, gtd_xz) * un(i, j, k, gtd_yz) * Tu_zz_p;
					pTtd_ADM_xx_p = (Betatd_x_p * Betatd_x_p) * Tu_tt_p + 2.0 * Betatd_x_p * (un(i, j, k, gtd_xx) * Tu_tx_p + un(i, j, k, gtd_xy) * Tu_ty_p + un(i, j, k, gtd_xz) * Tu_tz_p) + (un(i, j, k, gtd_xx) * un(i, j, k, gtd_xx)) * Tu_xx_p + 2.0 * un(i, j, k, gtd_xx) * un(i, j, k, gtd_xy) * Tu_xy_p + 2.0 * un(i, j, k, gtd_xx) * un(i, j, k, gtd_xz) * Tu_xz_p + (un(i, j, k, gtd_xy) * un(i, j, k, gtd_xy)) * Tu_yy_p + 2.0 * un(i, j, k, gtd_xy) * un(i, j, k, gtd_xz) * Tu_yz_p + (un(i, j, k, gtd_xz) * un(i, j, k, gtd_xz)) * Tu_zz_p;
					d_Psi1_xx_o0_t5_m0_l0_p = (-8.0 * M_PI * inv_chi_p * un(i, j, k, Alpha) * pTtd_ADM_xx_p) + un(i, j, k, Alpha) * Rpd_xx_p + chi_max_p * un(i, j, k, Alpha) * Rtd_xx_p;
					m_Psi1_xx_o0_t4_l0_p = (-1.0 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Psi1_xx_o0_t3_l0_p = chi_max_p * Ct_zxx_p * d_Psi1_xx_o0_t3_m0_l0;
					m_Psi1_xx_o0_t2_l0_p = chi_max_p * Ct_yxx_p * d_Psi1_xx_o0_t2_m0_l0;
					m_Psi1_xx_o0_t1_l0_p = chi_max_p * Ct_xxx_p * d_Psi1_xx_o0_t1_m0_l0;
					m_Psi1_xx_o0_t0_l0_p = (-chi_max_p) * d_Psi1_xx_o0_t0_m0_l0;
					Psi1_xx_p = ((((m_Psi1_xx_o0_t0_l0_p + m_Psi1_xx_o0_t1_l0_p) + m_Psi1_xx_o0_t2_l0_p) + m_Psi1_xx_o0_t3_l0_p) + m_Psi1_xx_o0_t4_l0_p) + d_Psi1_xx_o0_t5_m0_l0_p;
					d_Psi1_xy_o0_t6_m0_l0_p = (-8.0 * M_PI * inv_chi_p * un(i, j, k, Alpha) * pTtd_ADM_xy_p) + un(i, j, k, Alpha) * Rpd_xy_p + chi_max_p * un(i, j, k, Alpha) * Rtd_xy_p;
					m_Psi1_xy_o0_t5_l0_p = (-.5 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Psi1_xy_o0_t4_l0_p = (-.5 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Psi1_xy_o0_t3_l0_p = chi_max_p * Ct_zxy_p * d_Psi1_xx_o0_t3_m0_l0;
					m_Psi1_xy_o0_t2_l0_p = chi_max_p * Ct_yxy_p * d_Psi1_xx_o0_t2_m0_l0;
					m_Psi1_xy_o0_t1_l0_p = chi_max_p * Ct_xxy_p * d_Psi1_xx_o0_t1_m0_l0;
					m_Psi1_xy_o0_t0_l0_p = (-chi_max_p) * d_Psi1_xy_o0_t0_m0_l0;
					Psi1_xy_p = (((((m_Psi1_xy_o0_t0_l0_p + m_Psi1_xy_o0_t1_l0_p) + m_Psi1_xy_o0_t2_l0_p) + m_Psi1_xy_o0_t3_l0_p) + m_Psi1_xy_o0_t4_l0_p) + m_Psi1_xy_o0_t5_l0_p) + d_Psi1_xy_o0_t6_m0_l0_p;
					d_Psi1_xz_o0_t6_m0_l0_p = (-8.0 * M_PI * inv_chi_p * un(i, j, k, Alpha) * pTtd_ADM_xz_p) + un(i, j, k, Alpha) * Rpd_xz_p + chi_max_p * un(i, j, k, Alpha) * Rtd_xz_p;
					m_Psi1_xz_o0_t5_l0_p = (-.5 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_Psi1_xz_o0_t4_l0_p = (-.5 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Psi1_xz_o0_t3_l0_p = chi_max_p * Ct_zxz_p * d_Psi1_xx_o0_t3_m0_l0;
					m_Psi1_xz_o0_t2_l0_p = chi_max_p * Ct_yxz_p * d_Psi1_xx_o0_t2_m0_l0;
					m_Psi1_xz_o0_t1_l0_p = chi_max_p * Ct_xxz_p * d_Psi1_xx_o0_t1_m0_l0;
					m_Psi1_xz_o0_t0_l0_p = (-chi_max_p) * d_Psi1_xz_o0_t0_m0_l0;
					Psi1_xz_p = (((((m_Psi1_xz_o0_t0_l0_p + m_Psi1_xz_o0_t1_l0_p) + m_Psi1_xz_o0_t2_l0_p) + m_Psi1_xz_o0_t3_l0_p) + m_Psi1_xz_o0_t4_l0_p) + m_Psi1_xz_o0_t5_l0_p) + d_Psi1_xz_o0_t6_m0_l0_p;
					Jtd_ADM_z_p = un(i, j, k, Alpha) * ((un(i, j, k, Betau_x) * Tu_tt_p + Tu_tx_p) * un(i, j, k, gtd_xz) + (un(i, j, k, Betau_y) * Tu_tt_p + Tu_ty_p) * un(i, j, k, gtd_yz) + (un(i, j, k, Betau_z) * Tu_tt_p + Tu_tz_p) * un(i, j, k, gtd_zz));
					pTtd_ADM_zz_p = (Betatd_z_p * Betatd_z_p) * Tu_tt_p + 2.0 * Betatd_z_p * (un(i, j, k, gtd_xz) * Tu_tx_p + un(i, j, k, gtd_yz) * Tu_ty_p + un(i, j, k, gtd_zz) * Tu_tz_p) + (un(i, j, k, gtd_xz) * un(i, j, k, gtd_xz)) * Tu_xx_p + 2.0 * un(i, j, k, gtd_xz) * un(i, j, k, gtd_yz) * Tu_xy_p + 2.0 * un(i, j, k, gtd_xz) * un(i, j, k, gtd_zz) * Tu_xz_p + (un(i, j, k, gtd_yz) * un(i, j, k, gtd_yz)) * Tu_yy_p + 2.0 * un(i, j, k, gtd_yz) * un(i, j, k, gtd_zz) * Tu_yz_p + (un(i, j, k, gtd_zz) * un(i, j, k, gtd_zz)) * Tu_zz_p;
					d_Psi1_zz_o0_t5_m0_l0_p = (-8.0 * M_PI * inv_chi_p * un(i, j, k, Alpha) * pTtd_ADM_zz_p) + un(i, j, k, Alpha) * Rpd_zz_p + chi_max_p * un(i, j, k, Alpha) * Rtd_zz_p;
					m_Psi1_zz_o0_t4_l0_p = (-1.0 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Psi1_zz_o0_t3_l0_p = chi_max_p * Ct_zzz_p * d_Psi1_xx_o0_t3_m0_l0;
					m_Psi1_zz_o0_t2_l0_p = chi_max_p * Ct_yzz_p * d_Psi1_xx_o0_t2_m0_l0;
					m_Psi1_zz_o0_t1_l0_p = chi_max_p * Ct_xzz_p * d_Psi1_xx_o0_t1_m0_l0;
					m_Psi1_zz_o0_t0_l0_p = (-chi_max_p) * d_Psi1_zz_o0_t0_m0_l0;
					Psi1_zz_p = ((((m_Psi1_zz_o0_t0_l0_p + m_Psi1_zz_o0_t1_l0_p) + m_Psi1_zz_o0_t2_l0_p) + m_Psi1_zz_o0_t3_l0_p) + m_Psi1_zz_o0_t4_l0_p) + d_Psi1_zz_o0_t5_m0_l0_p;
					Jtd_ADM_y_p = un(i, j, k, Alpha) * ((un(i, j, k, Betau_x) * Tu_tt_p + Tu_tx_p) * un(i, j, k, gtd_xy) + (un(i, j, k, Betau_y) * Tu_tt_p + Tu_ty_p) * un(i, j, k, gtd_yy) + (un(i, j, k, Betau_z) * Tu_tt_p + Tu_tz_p) * un(i, j, k, gtd_yz));
					Jtd_ADM_x_p = un(i, j, k, Alpha) * ((un(i, j, k, Betau_x) * Tu_tt_p + Tu_tx_p) * un(i, j, k, gtd_xx) + (un(i, j, k, Betau_y) * Tu_tt_p + Tu_ty_p) * un(i, j, k, gtd_xy) + (un(i, j, k, Betau_z) * Tu_tt_p + Tu_tz_p) * un(i, j, k, gtd_xz));
					pTtd_ADM_yz_p = Betatd_y_p * Betatd_z_p * Tu_tt_p + Betatd_y_p * (un(i, j, k, gtd_xz) * Tu_tx_p + un(i, j, k, gtd_yz) * Tu_ty_p + un(i, j, k, gtd_zz) * Tu_tz_p) + Betatd_z_p * (un(i, j, k, gtd_xy) * Tu_tx_p + un(i, j, k, gtd_yy) * Tu_ty_p + un(i, j, k, gtd_yz) * Tu_tz_p) + un(i, j, k, gtd_xy) * un(i, j, k, gtd_xz) * Tu_xx_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_yz) * Tu_xy_p + un(i, j, k, gtd_xy) * un(i, j, k, gtd_zz) * Tu_xz_p + un(i, j, k, gtd_yy) * un(i, j, k, gtd_xz) * Tu_xy_p + un(i, j, k, gtd_yy) * un(i, j, k, gtd_yz) * Tu_yy_p + un(i, j, k, gtd_yy) * un(i, j, k, gtd_zz) * Tu_yz_p + un(i, j, k, gtd_yz) * un(i, j, k, gtd_xz) * Tu_xz_p + (un(i, j, k, gtd_yz) * un(i, j, k, gtd_yz)) * Tu_yz_p + un(i, j, k, gtd_yz) * un(i, j, k, gtd_zz) * Tu_zz_p;
					d_Psi1_yz_o0_t6_m0_l0_p = (-8.0 * M_PI * inv_chi_p * un(i, j, k, Alpha) * pTtd_ADM_yz_p) + un(i, j, k, Alpha) * Rpd_yz_p + chi_max_p * un(i, j, k, Alpha) * Rtd_yz_p;
					m_Psi1_yz_o0_t5_l0_p = (-.5 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Psi1_yz_o0_t4_l0_p = (-.5 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_Psi1_yz_o0_t3_l0_p = chi_max_p * Ct_zyz_p * d_Psi1_xx_o0_t3_m0_l0;
					m_Psi1_yz_o0_t2_l0_p = chi_max_p * Ct_yyz_p * d_Psi1_xx_o0_t2_m0_l0;
					m_Psi1_yz_o0_t1_l0_p = chi_max_p * Ct_xyz_p * d_Psi1_xx_o0_t1_m0_l0;
					m_Psi1_yz_o0_t0_l0_p = (-chi_max_p) * d_Psi1_yz_o0_t0_m0_l0;
					Psi1_yz_p = (((((m_Psi1_yz_o0_t0_l0_p + m_Psi1_yz_o0_t1_l0_p) + m_Psi1_yz_o0_t2_l0_p) + m_Psi1_yz_o0_t3_l0_p) + m_Psi1_yz_o0_t4_l0_p) + m_Psi1_yz_o0_t5_l0_p) + d_Psi1_yz_o0_t6_m0_l0_p;
					pTtd_ADM_yy_p = (Betatd_y_p * Betatd_y_p) * Tu_tt_p + 2.0 * Betatd_y_p * (un(i, j, k, gtd_xy) * Tu_tx_p + un(i, j, k, gtd_yy) * Tu_ty_p + un(i, j, k, gtd_yz) * Tu_tz_p) + (un(i, j, k, gtd_xy) * un(i, j, k, gtd_xy)) * Tu_xx_p + 2.0 * un(i, j, k, gtd_xy) * un(i, j, k, gtd_yy) * Tu_xy_p + 2.0 * un(i, j, k, gtd_xy) * un(i, j, k, gtd_yz) * Tu_xz_p + (un(i, j, k, gtd_yy) * un(i, j, k, gtd_yy)) * Tu_yy_p + 2.0 * un(i, j, k, gtd_yy) * un(i, j, k, gtd_yz) * Tu_yz_p + (un(i, j, k, gtd_yz) * un(i, j, k, gtd_yz)) * Tu_zz_p;
					tr_pT_p = inv_chi_p * (gtu_xx_p * pTtd_ADM_xx_p + 2.0 * gtu_xy_p * pTtd_ADM_xy_p + 2.0 * gtu_xz_p * pTtd_ADM_xz_p + gtu_yy_p * pTtd_ADM_yy_p + 2.0 * gtu_yz_p * pTtd_ADM_yz_p + gtu_zz_p * pTtd_ADM_zz_p);
					d_Psi1_yy_o0_t5_m0_l0_p = (-8.0 * M_PI * inv_chi_p * un(i, j, k, Alpha) * pTtd_ADM_yy_p) + un(i, j, k, Alpha) * Rpd_yy_p + chi_max_p * un(i, j, k, Alpha) * Rtd_yy_p;
					m_Psi1_yy_o0_t4_l0_p = (-1.0 * chi_max_p * inv_chi_p) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_Psi1_yy_o0_t3_l0_p = chi_max_p * Ct_zyy_p * d_Psi1_xx_o0_t3_m0_l0;
					m_Psi1_yy_o0_t2_l0_p = chi_max_p * Ct_yyy_p * d_Psi1_xx_o0_t2_m0_l0;
					m_Psi1_yy_o0_t1_l0_p = chi_max_p * Ct_xyy_p * d_Psi1_xx_o0_t1_m0_l0;
					m_Psi1_yy_o0_t0_l0_p = (-chi_max_p) * d_Psi1_yy_o0_t0_m0_l0;
					Psi1_yy_p = ((((m_Psi1_yy_o0_t0_l0_p + m_Psi1_yy_o0_t1_l0_p) + m_Psi1_yy_o0_t2_l0_p) + m_Psi1_yy_o0_t3_l0_p) + m_Psi1_yy_o0_t4_l0_p) + d_Psi1_yy_o0_t5_m0_l0_p;
					trPsi1_p = Psi1_xx_p * gtu_xx_p + 2.0 * Psi1_xy_p * gtu_xy_p + 2.0 * Psi1_xz_p * gtu_xz_p + Psi1_yy_p * gtu_yy_p + 2.0 * Psi1_yz_p * gtu_yz_p + Psi1_zz_p * gtu_zz_p;
					Psi1TF_yz_p = (-.3333333333333333 * trPsi1_p * un(i, j, k, gtd_yz)) + Psi1_yz_p;
					Psi1TF_yy_p = (-.3333333333333333 * trPsi1_p * un(i, j, k, gtd_yy)) + Psi1_yy_p;
					Psi1TF_xy_p = (-.3333333333333333 * trPsi1_p * un(i, j, k, gtd_xy)) + Psi1_xy_p;
					Psi1TF_xx_p = (-.3333333333333333 * trPsi1_p * un(i, j, k, gtd_xx)) + Psi1_xx_p;
					Psi1TF_xz_p = (-.3333333333333333 * trPsi1_p * un(i, j, k, gtd_xz)) + Psi1_xz_p;
					Psi1TF_zz_p = (-.3333333333333333 * trPsi1_p * un(i, j, k, gtd_zz)) + Psi1_zz_p;
					kappa_cc_p = std::min(parameters.p_kappa_cc, parameters.p_kappa_cc * decay_factor_p) / un(i, j, k, Alpha);
					rho_ADM_p = (un(i, j, k, Alpha) * un(i, j, k, Alpha)) * Tu_tt_p;
					d_gtd_xx_o2_t3_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_xx) * log(detgtd_p)) + (-2.0 * un(i, j, k, Alpha) * ((-.3333333333333333 * trAt_p * parameters.lambda_0 * un(i, j, k, gtd_xx)) + un(i, j, k, Atd_xx))) + (-.6666666666666667 * un(i, j, k, gtd_xx) * div_Beta_p);
					d_gtd_xy_o2_t6_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_xy) * log(detgtd_p)) + (-2.0 * un(i, j, k, Alpha) * ((-.3333333333333333 * trAt_p * parameters.lambda_0 * un(i, j, k, gtd_xy)) + un(i, j, k, Atd_xy))) + (-.6666666666666667 * un(i, j, k, gtd_xy) * div_Beta_p);
					d_gtd_xz_o2_t6_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_xz) * log(detgtd_p)) + (-2.0 * un(i, j, k, Alpha) * ((-.3333333333333333 * trAt_p * parameters.lambda_0 * un(i, j, k, gtd_xz)) + un(i, j, k, Atd_xz))) + (-.6666666666666667 * un(i, j, k, gtd_xz) * div_Beta_p);
					d_gtd_yy_o2_t3_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_yy) * log(detgtd_p)) + (-2.0 * un(i, j, k, Alpha) * ((-.3333333333333333 * trAt_p * parameters.lambda_0 * un(i, j, k, gtd_yy)) + un(i, j, k, Atd_yy))) + (-.6666666666666667 * un(i, j, k, gtd_yy) * div_Beta_p);
					d_gtd_yz_o2_t6_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_yz) * log(detgtd_p)) + (-2.0 * un(i, j, k, Alpha) * ((-.3333333333333333 * trAt_p * parameters.lambda_0 * un(i, j, k, gtd_yz)) + un(i, j, k, Atd_yz))) + (-.6666666666666667 * un(i, j, k, gtd_yz) * div_Beta_p);
					d_gtd_zz_o2_t3_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_zz) * log(detgtd_p)) + (-2.0 * un(i, j, k, Alpha) * ((-.3333333333333333 * trAt_p * parameters.lambda_0 * un(i, j, k, gtd_zz)) + un(i, j, k, Atd_zz))) + (-.6666666666666667 * un(i, j, k, gtd_zz) * div_Beta_p);
					d_Atd_xx_o2_t3_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_xx) * trAt_p) + un(i, j, k, Alpha) * (un(i, j, k, trK) * un(i, j, k, Atd_xx) + (-2.0 * un(i, j, k, Atd_xx) * Atud_xx_p) + (-2.0 * un(i, j, k, Atd_xy) * Atud_yx_p) + (-2.0 * un(i, j, k, Atd_xz) * Atud_zx_p)) + Psi1TF_xx_p + (-.6666666666666667 * un(i, j, k, Atd_xx) * div_Beta_p);
					d_Atd_xy_o2_t6_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_xy) * trAt_p) + un(i, j, k, Alpha) * (un(i, j, k, trK) * un(i, j, k, Atd_xy) + (-2.0 * un(i, j, k, Atd_xx) * Atud_xy_p) + (-2.0 * un(i, j, k, Atd_xy) * Atud_yy_p) + (-2.0 * un(i, j, k, Atd_xz) * Atud_zy_p)) + Psi1TF_xy_p + (-.6666666666666667 * un(i, j, k, Atd_xy) * div_Beta_p);
					d_Atd_xz_o2_t6_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_xz) * trAt_p) + un(i, j, k, Alpha) * (un(i, j, k, trK) * un(i, j, k, Atd_xz) + (-2.0 * un(i, j, k, Atd_xx) * Atud_xz_p) + (-2.0 * un(i, j, k, Atd_xy) * Atud_yz_p) + (-2.0 * un(i, j, k, Atd_xz) * Atud_zz_p)) + Psi1TF_xz_p + (-.6666666666666667 * un(i, j, k, Atd_xz) * div_Beta_p);
					d_Atd_yy_o2_t3_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_yy) * trAt_p) + un(i, j, k, Alpha) * (un(i, j, k, trK) * un(i, j, k, Atd_yy) + (-2.0 * un(i, j, k, Atd_xy) * Atud_xy_p) + (-2.0 * un(i, j, k, Atd_yy) * Atud_yy_p) + (-2.0 * un(i, j, k, Atd_yz) * Atud_zy_p)) + Psi1TF_yy_p + (-.6666666666666667 * un(i, j, k, Atd_yy) * div_Beta_p);
					d_Atd_yz_o2_t6_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_yz) * trAt_p) + un(i, j, k, Alpha) * (un(i, j, k, trK) * un(i, j, k, Atd_yz) + (-2.0 * un(i, j, k, Atd_xy) * Atud_xz_p) + (-2.0 * un(i, j, k, Atd_yy) * Atud_yz_p) + (-2.0 * un(i, j, k, Atd_yz) * Atud_zz_p)) + Psi1TF_yz_p + (-.6666666666666667 * un(i, j, k, Atd_yz) * div_Beta_p);
					d_Atd_zz_o2_t3_m0_l0 = (-.3333333333333333 * kappa_cc_p * un(i, j, k, Alpha) * un(i, j, k, gtd_zz) * trAt_p) + un(i, j, k, Alpha) * (un(i, j, k, trK) * un(i, j, k, Atd_zz) + (-2.0 * un(i, j, k, Atd_xz) * Atud_xz_p) + (-2.0 * un(i, j, k, Atd_yz) * Atud_yz_p) + (-2.0 * un(i, j, k, Atd_zz) * Atud_zz_p)) + Psi1TF_zz_p + (-.6666666666666667 * un(i, j, k, Atd_zz) * div_Beta_p);
					d_Gamh_x_o2_t24_m0_l0 = (-2.0 * un(i, j, k, Alpha) * inv_chi_p * Zu_x_p * (kappa_z1_p + 1.333333333333333 * un(i, j, k, theta) + .6666666666666667 * un(i, j, k, trK))) + (-50.26548245743669 * un(i, j, k, Alpha) * inv_chi_p * (gtu_xx_p * Jtd_ADM_x_p + gtu_xy_p * Jtd_ADM_y_p + gtu_xz_p * Jtd_ADM_z_p)) + 2.0 * un(i, j, k, Alpha) * (Ct_xxx_p * Atu_xx_p + 2.0 * Ct_xxy_p * Atu_xy_p + 2.0 * Ct_xxz_p * Atu_xz_p + Ct_xyy_p * Atu_yy_p + 2.0 * Ct_xyz_p * Atu_yz_p + Ct_xzz_p * Atu_zz_p) + .6666666666666667 * un(i, j, k, Gamh_x) * div_Beta_p + .3333333333333333 * gtu_xz_p * d_div_Beta_z_p + .3333333333333333 * gtu_xy_p * d_div_Beta_y_p + .3333333333333333 * gtu_xx_p * d_div_Beta_x_p;
					d_Gamh_y_o2_t24_m0_l0 = (-2.0 * un(i, j, k, Alpha) * inv_chi_p * Zu_y_p * (kappa_z1_p + 1.333333333333333 * un(i, j, k, theta) + .6666666666666667 * un(i, j, k, trK))) + .3333333333333333 * gtu_yz_p * d_div_Beta_z_p + .3333333333333333 * gtu_yy_p * d_div_Beta_y_p + .3333333333333333 * gtu_xy_p * d_div_Beta_x_p + 2.0 * un(i, j, k, Alpha) * (Ct_yxx_p * Atu_xx_p + 2.0 * Ct_yxy_p * Atu_xy_p + 2.0 * Ct_yxz_p * Atu_xz_p + Ct_yyy_p * Atu_yy_p + 2.0 * Ct_yyz_p * Atu_yz_p + Ct_yzz_p * Atu_zz_p) + .6666666666666667 * un(i, j, k, Gamh_y) * div_Beta_p + (-50.26548245743669 * un(i, j, k, Alpha) * inv_chi_p * (gtu_xy_p * Jtd_ADM_x_p + gtu_yy_p * Jtd_ADM_y_p + gtu_yz_p * Jtd_ADM_z_p));
					d_Betau_x_o0_t0_m0_l0 = (-un(i, j, k, Betau_x) * feta_p) + .7500000000000000 * (un(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * un(i, j, k, Gamh_x);
					d_Betau_y_o0_t0_m0_l0 = (-un(i, j, k, Betau_y) * feta_p) + .7500000000000000 * (un(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * un(i, j, k, Gamh_y);
					d_Betau_z_o0_t0_m0_l0 = (parameters.Betau_z_0 - un(i, j, k, Betau_z)) * feta_p + .7500000000000000 * (un(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * un(i, j, k, Gamh_z);
					d_Gamh_z_o2_t24_m0_l0 = .3333333333333333 * gtu_zz_p * d_div_Beta_z_p + .3333333333333333 * gtu_yz_p * d_div_Beta_y_p + .3333333333333333 * gtu_xz_p * d_div_Beta_x_p + 2.0 * un(i, j, k, Alpha) * (Ct_zxx_p * Atu_xx_p + 2.0 * Ct_zxy_p * Atu_xy_p + 2.0 * Ct_zxz_p * Atu_xz_p + Ct_zyy_p * Atu_yy_p + 2.0 * Ct_zyz_p * Atu_yz_p + Ct_zzz_p * Atu_zz_p) + .6666666666666667 * un(i, j, k, Gamh_z) * div_Beta_p + (-50.26548245743669 * un(i, j, k, Alpha) * inv_chi_p * (gtu_xz_p * Jtd_ADM_x_p + gtu_yz_p * Jtd_ADM_y_p + gtu_zz_p * Jtd_ADM_z_p)) + (-2.0 * un(i, j, k, Alpha) * inv_chi_p * Zu_z_p * (kappa_z1_p + 1.333333333333333 * un(i, j, k, theta) + .6666666666666667 * un(i, j, k, trK)));
					d_Alpha_o2_t0_m0_l0 = -2.0 * (un(i, j, k, Alpha) * parameters.lambda_f3 + parameters.lambda_f2) * un(i, j, k, Alpha) * (un(i, j, k, trK) - parameters.trK0);
					d_chi_o2_t0_m0_l0 = .6666666666666667 * chi_max_p * (un(i, j, k, Alpha) * (2.0 * un(i, j, k, theta) + un(i, j, k, trK)) - div_Beta_p);
					d_trK_o2_t21_m0_l0 = un(i, j, k, Alpha) * kappa_z1_p * (1.0 - kappa_z2_p) * un(i, j, k, theta) + .3333333333333333 * un(i, j, k, Alpha) * ((2.0 * un(i, j, k, theta) + un(i, j, k, trK)) * (2.0 * un(i, j, k, theta) + un(i, j, k, trK))) + un(i, j, k, Alpha) * (un(i, j, k, Atd_xx) * Atu_xx_p + 2.0 * un(i, j, k, Atd_xy) * Atu_xy_p + 2.0 * un(i, j, k, Atd_xz) * Atu_xz_p + un(i, j, k, Atd_yy) * Atu_yy_p + 2.0 * un(i, j, k, Atd_yz) * Atu_yz_p + un(i, j, k, Atd_zz) * Atu_zz_p) + 4.0 * un(i, j, k, Alpha) * M_PI * (rho_ADM_p + tr_pT_p);
					d_theta_o2_t3_m0_l0 = (-un(i, j, k, Alpha) * kappa_z1_p * (2.0 + kappa_z2_p) * un(i, j, k, theta)) + (-8.0 * un(i, j, k, Alpha) * M_PI * rho_ADM_p) + .5 * un(i, j, k, Alpha) * (Rscalar_p + .6666666666666667 * (un(i, j, k, trK) * un(i, j, k, trK)) + .6666666666666667 * un(i, j, k, theta) * ((-2.0 * un(i, j, k, theta)) + un(i, j, k, trK)) + (-un(i, j, k, Atd_xx) * Atu_xx_p) + (-2.0 * un(i, j, k, Atd_xy) * Atu_xy_p) + (-2.0 * un(i, j, k, Atd_xz) * Atu_xz_p) + (-un(i, j, k, Atd_yy) * Atu_yy_p) + (-2.0 * un(i, j, k, Atd_yz) * Atu_yz_p) + (-un(i, j, k, Atd_zz) * Atu_zz_p));
					d_piR_o2_t27_m0_l0 = un(i, j, k, Alpha) * (un(i, j, k, trK) + 2.0 * un(i, j, k, theta)) * un(i, j, k, piR) + un(i, j, k, Alpha) * dVdphi2_p * un(i, j, k, phiR);
					d_peR_o2_t27_m0_l0 = un(i, j, k, Alpha) * dVdphe2_p * un(i, j, k, pheR) + un(i, j, k, Alpha) * (un(i, j, k, trK) + 2.0 * un(i, j, k, theta)) * un(i, j, k, peR);
					d_piI_o2_t27_m0_l0 = un(i, j, k, Alpha) * (un(i, j, k, trK) + 2.0 * un(i, j, k, theta)) * un(i, j, k, piI) + un(i, j, k, Alpha) * dVdphi2_p * un(i, j, k, phiI);
					d_peI_o2_t27_m0_l0 = un(i, j, k, Alpha) * (un(i, j, k, trK) + 2.0 * un(i, j, k, theta)) * un(i, j, k, peI) + un(i, j, k, Alpha) * dVdphe2_p * un(i, j, k, pheI);
					m_peI_o2_t26_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_yz_p) * d_peI_o2_t26_m0_l0;
					m_peI_o2_t25_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_yy_p) * d_peI_o2_t25_m0_l0;
					m_peI_o2_t24_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xz_p) * d_peI_o2_t24_m0_l0;
					m_peI_o2_t23_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xy_p) * d_peI_o2_t23_m0_l0;
					m_peI_o2_t22_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_xx_p) * d_peI_o2_t22_m0_l0;
					m_peI_o2_t21_l0 = (-chi_max_p * gtu_zz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t20_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t19_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t18_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t17_l0 = (-chi_max_p * gtu_yy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t16_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t15_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t14_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t13_l0 = (-chi_max_p * gtu_xx_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t12_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_zz_p * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t11_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t10_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t9_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t8_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yy_p * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t7_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t6_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t5_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t4_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xx_p * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t3_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_z_p - 2.0 * Zu_z_p) * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t2_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_y_p - 2.0 * Zu_y_p) * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t1_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_x_p - 2.0 * Zu_x_p) * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t0_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_zz_p) * d_peI_o2_t0_m0_l0;
					m_peI_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_peI_o1_t2_m0_l0;
					m_peI_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_peI_o1_t1_m0_l0;
					m_peI_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_peI_o1_t0_m0_l0;
					m_peI_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_peI_o0_t2_m0_l0;
					m_peI_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_peI_o0_t1_m0_l0;
					m_peI_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_peI_o0_t0_m0_l0;
					m_piI_o2_t26_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xz_p) * d_piI_o2_t26_m0_l0;
					m_piI_o2_t25_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xy_p) * d_piI_o2_t25_m0_l0;
					m_piI_o2_t24_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_xx_p) * d_piI_o2_t24_m0_l0;
					m_piI_o2_t23_l0 = (-chi_max_p * gtu_zz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t22_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t21_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t20_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t19_l0 = (-chi_max_p * gtu_yy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t18_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t17_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t16_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t15_l0 = (-chi_max_p * gtu_xx_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t14_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_zz_p * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t13_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t12_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t11_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t10_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yy_p * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t9_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t8_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t7_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t6_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xx_p * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t5_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_z_p - 2.0 * Zu_z_p) * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t4_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_y_p - 2.0 * Zu_y_p) * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t3_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_x_p - 2.0 * Zu_x_p) * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t2_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_zz_p) * d_piI_o2_t2_m0_l0;
					m_piI_o2_t1_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_yz_p) * d_piI_o2_t1_m0_l0;
					m_piI_o2_t0_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_yy_p) * d_piI_o2_t0_m0_l0;
					m_piI_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_piI_o1_t2_m0_l0;
					m_piI_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_piI_o1_t1_m0_l0;
					m_piI_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_piI_o1_t0_m0_l0;
					m_piI_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_piI_o0_t2_m0_l0;
					m_piI_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_piI_o0_t1_m0_l0;
					m_piI_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_piI_o0_t0_m0_l0;
					m_peR_o2_t26_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xz_p) * d_peR_o2_t26_m0_l0;
					m_peR_o2_t25_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xy_p) * d_peR_o2_t25_m0_l0;
					m_peR_o2_t24_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_xx_p) * d_peR_o2_t24_m0_l0;
					m_peR_o2_t23_l0 = (-chi_max_p * gtu_zz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t22_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t21_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t20_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t19_l0 = (-chi_max_p * gtu_yy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t18_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t17_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t16_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t15_l0 = (-chi_max_p * gtu_xx_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t14_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_zz_p * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t13_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t12_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t11_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t10_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yy_p * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t9_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t8_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t7_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t6_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xx_p * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t5_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_z_p - 2.0 * Zu_z_p) * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t4_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_y_p - 2.0 * Zu_y_p) * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t3_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_x_p - 2.0 * Zu_x_p) * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t2_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_zz_p) * d_peR_o2_t2_m0_l0;
					m_peR_o2_t1_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_yz_p) * d_peR_o2_t1_m0_l0;
					m_peR_o2_t0_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_yy_p) * d_peR_o2_t0_m0_l0;
					m_peR_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_peR_o1_t2_m0_l0;
					m_peR_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_peR_o1_t1_m0_l0;
					m_peR_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_peR_o1_t0_m0_l0;
					m_peR_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_peR_o0_t2_m0_l0;
					m_peR_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_peR_o0_t1_m0_l0;
					m_peR_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_peR_o0_t0_m0_l0;
					m_piR_o2_t26_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_xx_p) * d_piR_o2_t26_m0_l0;
					m_piR_o2_t25_l0 = (-chi_max_p * gtu_zz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t24_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t23_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t22_l0 = (-chi_max_p * gtu_yz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t21_l0 = (-chi_max_p * gtu_yy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t20_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t19_l0 = (-chi_max_p * gtu_xz_p) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t18_l0 = (-chi_max_p * gtu_xy_p) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t17_l0 = (-chi_max_p * gtu_xx_p) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t16_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_zz_p * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t15_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t14_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t13_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yz_p * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t12_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_yy_p * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t11_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t10_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xz_p * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t9_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xy_p * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t8_l0 = .5000000000000000 * un(i, j, k, Alpha) * gtu_xx_p * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t7_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_z_p - 2.0 * Zu_z_p) * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t6_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_y_p - 2.0 * Zu_y_p) * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t5_l0 = un(i, j, k, Alpha) * (chi_max_p * Gamt_x_p - 2.0 * Zu_x_p) * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t4_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_zz_p) * d_piR_o2_t4_m0_l0;
					m_piR_o2_t3_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_yz_p) * d_piR_o2_t3_m0_l0;
					m_piR_o2_t2_l0 = (-un(i, j, k, Alpha) * chi_max_p * gtu_yy_p) * d_piR_o2_t2_m0_l0;
					m_piR_o2_t1_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xz_p) * d_piR_o2_t1_m0_l0;
					m_piR_o2_t0_l0 = (-2.0 * un(i, j, k, Alpha) * chi_max_p * gtu_xy_p) * d_piR_o2_t0_m0_l0;
					m_piR_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_piR_o1_t2_m0_l0;
					m_piR_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_piR_o1_t1_m0_l0;
					m_piR_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_piR_o1_t0_m0_l0;
					m_piR_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_piR_o0_t2_m0_l0;
					m_piR_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_piR_o0_t1_m0_l0;
					m_piR_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_piR_o0_t0_m0_l0;
					m_pheI_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_pheI_o1_t2_m0_l0;
					m_pheI_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_pheI_o1_t1_m0_l0;
					m_pheI_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_pheI_o1_t0_m0_l0;
					m_pheI_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_pheI_o0_t2_m0_l0;
					m_pheI_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_pheI_o0_t1_m0_l0;
					m_pheI_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_pheI_o0_t0_m0_l0;
					m_phiI_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_phiI_o1_t2_m0_l0;
					m_phiI_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_phiI_o1_t1_m0_l0;
					m_phiI_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_phiI_o1_t0_m0_l0;
					m_phiI_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_phiI_o0_t2_m0_l0;
					m_phiI_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_phiI_o0_t1_m0_l0;
					m_phiI_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_phiI_o0_t0_m0_l0;
					m_pheR_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_pheR_o1_t2_m0_l0;
					m_pheR_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_pheR_o1_t1_m0_l0;
					m_pheR_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_pheR_o1_t0_m0_l0;
					m_pheR_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_pheR_o0_t2_m0_l0;
					m_pheR_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_pheR_o0_t1_m0_l0;
					m_pheR_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_pheR_o0_t0_m0_l0;
					m_phiR_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_phiR_o1_t2_m0_l0;
					m_phiR_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_phiR_o1_t1_m0_l0;
					m_phiR_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_phiR_o1_t0_m0_l0;
					m_phiR_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_phiR_o0_t2_m0_l0;
					m_phiR_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_phiR_o0_t1_m0_l0;
					m_phiR_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_phiR_o0_t0_m0_l0;
					m_theta_o2_t2_l0 = (-Zu_z_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_theta_o2_t1_l0 = (-Zu_y_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_theta_o2_t0_l0 = (-Zu_x_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_theta_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_theta_o1_t2_m0_l0;
					m_theta_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_theta_o1_t1_m0_l0;
					m_theta_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_theta_o1_t0_m0_l0;
					m_theta_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_theta_o0_t2_m0_l0;
					m_theta_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_theta_o0_t1_m0_l0;
					m_theta_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_theta_o0_t0_m0_l0;
					m_trK_o2_t20_l0 = 2.0 * Zu_z_p * d_Psi1_xx_o0_t3_m0_l0;
					m_trK_o2_t19_l0 = 2.0 * Zu_y_p * d_Psi1_xx_o0_t2_m0_l0;
					m_trK_o2_t18_l0 = 2.0 * Zu_x_p * d_Psi1_xx_o0_t1_m0_l0;
					m_trK_o2_t17_l0 = .5 * gtu_xy_p * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t16_l0 = .5 * gtu_xx_p * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t15_l0 = chi_max_p * Gamt_z_p * d_Psi1_xx_o0_t3_m0_l0;
					m_trK_o2_t14_l0 = chi_max_p * Gamt_y_p * d_Psi1_xx_o0_t2_m0_l0;
					m_trK_o2_t13_l0 = chi_max_p * Gamt_x_p * d_Psi1_xx_o0_t1_m0_l0;
					m_trK_o2_t12_l0 = (-chi_max_p * gtu_zz_p) * d_Psi1_zz_o0_t0_m0_l0;
					m_trK_o2_t11_l0 = (-chi_max_p * gtu_yy_p) * d_Psi1_yy_o0_t0_m0_l0;
					m_trK_o2_t10_l0 = (-2.0 * chi_max_p * gtu_yz_p) * d_Psi1_yz_o0_t0_m0_l0;
					m_trK_o2_t9_l0 = (-2.0 * chi_max_p * gtu_xz_p) * d_Psi1_xz_o0_t0_m0_l0;
					m_trK_o2_t8_l0 = (-2.0 * chi_max_p * gtu_xy_p) * d_Psi1_xy_o0_t0_m0_l0;
					m_trK_o2_t7_l0 = (-chi_max_p * gtu_xx_p) * d_Psi1_xx_o0_t0_m0_l0;
					m_trK_o2_t6_l0 = .5 * gtu_zz_p * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o2_t5_l0 = .5 * gtu_yz_p * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t4_l0 = .5 * gtu_xz_p * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t3_l0 = .5 * gtu_yz_p * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o2_t2_l0 = .5 * gtu_yy_p * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t1_l0 = .5 * gtu_xy_p * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t0_l0 = .5 * gtu_xz_p * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_trK_o1_t2_m0_l0;
					m_trK_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_trK_o1_t1_m0_l0;
					m_trK_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_trK_o1_t0_m0_l0;
					m_trK_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_trK_o0_t2_m0_l0;
					m_trK_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_trK_o0_t1_m0_l0;
					m_trK_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_trK_o0_t0_m0_l0;
					m_chi_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_chi_o1_t2_m0_l0;
					m_chi_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_chi_o1_t1_m0_l0;
					m_chi_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_chi_o1_t0_m0_l0;
					m_chi_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_chi_o0_t2_m0_l0;
					m_chi_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_chi_o0_t1_m0_l0;
					m_chi_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_chi_o0_t0_m0_l0;
					m_Alpha_o1_t2_l0 = parameters.lambda_1 * std::min(0.0, un(i, j, k, Betau_z)) * d_Alpha_o1_t2_m0_l0;
					m_Alpha_o1_t1_l0 = parameters.lambda_1 * std::min(0.0, un(i, j, k, Betau_y)) * d_Alpha_o1_t1_m0_l0;
					m_Alpha_o1_t0_l0 = parameters.lambda_1 * std::min(0.0, un(i, j, k, Betau_x)) * d_Alpha_o1_t0_m0_l0;
					m_Alpha_o0_t2_l0 = parameters.lambda_1 * std::max(0.0, un(i, j, k, Betau_z)) * d_Alpha_o0_t2_m0_l0;
					m_Alpha_o0_t1_l0 = parameters.lambda_1 * std::max(0.0, un(i, j, k, Betau_y)) * d_Alpha_o0_t1_m0_l0;
					m_Alpha_o0_t0_l0 = parameters.lambda_1 * std::max(0.0, un(i, j, k, Betau_x)) * d_Alpha_o0_t0_m0_l0;
					m_Gamh_z_o2_t23_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_xz_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_z_o2_t22_l0 = (-2.0 * Atu_zz_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_z_o2_t21_l0 = (-2.0 * Atu_yz_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t20_l0 = (-2.0 * Atu_xz_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_z_o2_t19_l0 = gtu_zz_p * d_d_div_Beta_z_o0_t2_m0_l0;
					m_Gamh_z_o2_t18_l0 = 2.0 * gtu_yz_p * d_d_div_Beta_y_o0_t2_m0_l0;
					m_Gamh_z_o2_t17_l0 = gtu_yy_p * d_Gamh_z_o2_t17_m0_l0;
					m_Gamh_z_o2_t16_l0 = 2.0 * gtu_xz_p * d_d_div_Beta_x_o0_t2_m0_l0;
					m_Gamh_z_o2_t15_l0 = 2.0 * gtu_xy_p * d_Gamh_z_o2_t15_m0_l0;
					m_Gamh_z_o2_t14_l0 = gtu_xx_p * d_Gamh_z_o2_t14_m0_l0;
					m_Gamh_z_o2_t13_l0 = (-un(i, j, k, Gamh_z)) * d_div_Beta_o0_t2_m0_l0;
					m_Gamh_z_o2_t12_l0 = (-un(i, j, k, Gamh_y)) * d_gtd_xy_o2_t2_m0_l0;
					m_Gamh_z_o2_t11_l0 = (-un(i, j, k, Gamh_x)) * d_gtd_xx_o2_t2_m0_l0;
					m_Gamh_z_o2_t10_l0 = (-2.0 * un(i, j, k, theta) * gtu_zz_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_z_o2_t9_l0 = (-2.0 * un(i, j, k, theta) * gtu_yz_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t8_l0 = (-2.0 * un(i, j, k, theta) * gtu_xz_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_z_o2_t7_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_zz_p) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_z_o2_t6_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_yz_p) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_z_o2_t5_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_xz_p) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_z_o2_t4_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_zz_p) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_z_o2_t3_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_yz_p) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_z_o2_t2_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_xz_p) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_z_o2_t1_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_zz_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t0_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_yz_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_z_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Gamh_z_o1_t2_m0_l0;
					m_Gamh_z_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Gamh_z_o1_t1_m0_l0;
					m_Gamh_z_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Gamh_z_o1_t0_m0_l0;
					m_Gamh_z_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Gamh_z_o0_t2_m0_l0;
					m_Gamh_z_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Gamh_z_o0_t1_m0_l0;
					m_Gamh_z_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Gamh_z_o0_t0_m0_l0;
					m_Betau_z_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_z)) * d_Betau_z_o2_t2_m0_l0;
					m_Betau_z_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_y)) * d_Betau_z_o2_t1_m0_l0;
					m_Betau_z_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_x)) * d_Betau_z_o2_t0_m0_l0;
					m_Betau_z_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_z)) * d_Betau_z_o1_t2_m0_l0;
					m_Betau_z_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_y)) * d_Betau_z_o1_t1_m0_l0;
					m_Betau_z_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_x)) * d_Betau_z_o1_t0_m0_l0;
					m_Betau_y_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_z)) * d_Betau_y_o2_t2_m0_l0;
					m_Betau_y_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_y)) * d_Betau_y_o2_t1_m0_l0;
					m_Betau_y_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_x)) * d_Betau_y_o2_t0_m0_l0;
					m_Betau_y_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_z)) * d_Betau_y_o1_t2_m0_l0;
					m_Betau_y_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_y)) * d_Betau_y_o1_t1_m0_l0;
					m_Betau_y_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_x)) * d_Betau_y_o1_t0_m0_l0;
					m_Betau_x_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_z)) * d_Betau_x_o2_t2_m0_l0;
					m_Betau_x_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_y)) * d_Betau_x_o2_t1_m0_l0;
					m_Betau_x_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, un(i, j, k, Betau_x)) * d_Betau_x_o2_t0_m0_l0;
					m_Betau_x_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_z)) * d_Betau_x_o1_t2_m0_l0;
					m_Betau_x_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_y)) * d_Betau_x_o1_t1_m0_l0;
					m_Betau_x_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, un(i, j, k, Betau_x)) * d_Betau_x_o1_t0_m0_l0;
					m_Gamh_y_o2_t23_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_yz_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t22_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_yy_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t21_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_xy_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_y_o2_t20_l0 = (-2.0 * un(i, j, k, theta) * gtu_yy_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t19_l0 = (-2.0 * un(i, j, k, theta) * gtu_xy_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t18_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_yz_p) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_y_o2_t17_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_yy_p) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_y_o2_t16_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_xy_p) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_y_o2_t15_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_yz_p) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_y_o2_t14_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_yy_p) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_y_o2_t13_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_xy_p) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_y_o2_t12_l0 = (-2.0 * Atu_yz_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_y_o2_t11_l0 = (-2.0 * Atu_yy_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t10_l0 = (-2.0 * Atu_xy_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t9_l0 = gtu_zz_p * d_Gamh_y_o2_t9_m0_l0;
					m_Gamh_y_o2_t8_l0 = 2.0 * gtu_yz_p * d_d_div_Beta_z_o0_t1_m0_l0;
					m_Gamh_y_o2_t7_l0 = gtu_yy_p * d_d_div_Beta_y_o0_t1_m0_l0;
					m_Gamh_y_o2_t6_l0 = 2.0 * gtu_xz_p * d_Gamh_y_o2_t6_m0_l0;
					m_Gamh_y_o2_t5_l0 = 2.0 * gtu_xy_p * d_d_div_Beta_x_o0_t1_m0_l0;
					m_Gamh_y_o2_t4_l0 = gtu_xx_p * d_Gamh_y_o2_t4_m0_l0;
					m_Gamh_y_o2_t3_l0 = (-un(i, j, k, Gamh_z)) * d_gtd_xz_o2_t1_m0_l0;
					m_Gamh_y_o2_t2_l0 = (-un(i, j, k, Gamh_y)) * d_div_Beta_o0_t1_m0_l0;
					m_Gamh_y_o2_t1_l0 = (-un(i, j, k, Gamh_x)) * d_gtd_xx_o2_t1_m0_l0;
					m_Gamh_y_o2_t0_l0 = (-2.0 * un(i, j, k, theta) * gtu_yz_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_y_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Gamh_y_o1_t2_m0_l0;
					m_Gamh_y_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Gamh_y_o1_t1_m0_l0;
					m_Gamh_y_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Gamh_y_o1_t0_m0_l0;
					m_Gamh_y_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Gamh_y_o0_t2_m0_l0;
					m_Gamh_y_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Gamh_y_o0_t1_m0_l0;
					m_Gamh_y_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Gamh_y_o0_t0_m0_l0;
					m_Gamh_x_o2_t23_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_xz_p) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t22_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_xy_p) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t21_l0 = (-3.0 * un(i, j, k, Alpha) * inv_chi_p * Atu_xx_p) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_x_o2_t20_l0 = (-2.0 * un(i, j, k, theta) * gtu_xz_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_x_o2_t19_l0 = (-2.0 * un(i, j, k, theta) * gtu_xy_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t18_l0 = (-2.0 * un(i, j, k, theta) * gtu_xx_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t17_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_xz_p) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_x_o2_t16_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_xy_p) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_x_o2_t15_l0 = (-.6666666666666667 * un(i, j, k, Alpha) * gtu_xx_p) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_x_o2_t14_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_xz_p) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_x_o2_t13_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_xy_p) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_x_o2_t12_l0 = (-1.333333333333333 * un(i, j, k, Alpha) * gtu_xx_p) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_x_o2_t11_l0 = (-2.0 * Atu_xz_p) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_x_o2_t10_l0 = (-2.0 * Atu_xy_p) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t9_l0 = (-2.0 * Atu_xx_p) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t8_l0 = gtu_zz_p * d_Gamh_x_o2_t8_m0_l0;
					m_Gamh_x_o2_t7_l0 = 2.0 * gtu_yz_p * d_Gamh_x_o2_t7_m0_l0;
					m_Gamh_x_o2_t6_l0 = gtu_yy_p * d_Gamh_x_o2_t6_m0_l0;
					m_Gamh_x_o2_t5_l0 = 2.0 * gtu_xz_p * d_d_div_Beta_z_o0_t0_m0_l0;
					m_Gamh_x_o2_t4_l0 = 2.0 * gtu_xy_p * d_d_div_Beta_y_o0_t0_m0_l0;
					m_Gamh_x_o2_t3_l0 = gtu_xx_p * d_d_div_Beta_x_o0_t0_m0_l0;
					m_Gamh_x_o2_t2_l0 = (-un(i, j, k, Gamh_z)) * d_gtd_xz_o2_t0_m0_l0;
					m_Gamh_x_o2_t1_l0 = (-un(i, j, k, Gamh_y)) * d_gtd_xy_o2_t0_m0_l0;
					m_Gamh_x_o2_t0_l0 = (-un(i, j, k, Gamh_x)) * d_div_Beta_o0_t0_m0_l0;
					m_Gamh_x_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Gamh_x_o1_t2_m0_l0;
					m_Gamh_x_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Gamh_x_o1_t1_m0_l0;
					m_Gamh_x_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Gamh_x_o1_t0_m0_l0;
					m_Gamh_x_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Gamh_x_o0_t2_m0_l0;
					m_Gamh_x_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Gamh_x_o0_t1_m0_l0;
					m_Gamh_x_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Gamh_x_o0_t0_m0_l0;
					m_Atd_zz_o2_t2_l0 = 2.0 * un(i, j, k, Atd_zz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_zz_o2_t1_l0 = 2.0 * un(i, j, k, Atd_yz) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_zz_o2_t0_l0 = 2.0 * un(i, j, k, Atd_xz) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_zz_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Atd_zz_o1_t2_m0_l0;
					m_Atd_zz_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Atd_zz_o1_t1_m0_l0;
					m_Atd_zz_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Atd_zz_o1_t0_m0_l0;
					m_Atd_zz_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Atd_zz_o0_t2_m0_l0;
					m_Atd_zz_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Atd_zz_o0_t1_m0_l0;
					m_Atd_zz_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Atd_zz_o0_t0_m0_l0;
					m_Atd_yz_o2_t5_l0 = un(i, j, k, Atd_zz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_yz_o2_t4_l0 = un(i, j, k, Atd_yz) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_yz_o2_t3_l0 = un(i, j, k, Atd_xz) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_yz_o2_t2_l0 = un(i, j, k, Atd_yz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_yz_o2_t1_l0 = un(i, j, k, Atd_yy) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_yz_o2_t0_l0 = un(i, j, k, Atd_xy) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_yz_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Atd_yz_o1_t2_m0_l0;
					m_Atd_yz_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Atd_yz_o1_t1_m0_l0;
					m_Atd_yz_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Atd_yz_o1_t0_m0_l0;
					m_Atd_yz_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Atd_yz_o0_t2_m0_l0;
					m_Atd_yz_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Atd_yz_o0_t1_m0_l0;
					m_Atd_yz_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Atd_yz_o0_t0_m0_l0;
					m_Atd_yy_o2_t2_l0 = 2.0 * un(i, j, k, Atd_yz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_yy_o2_t1_l0 = 2.0 * un(i, j, k, Atd_yy) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_yy_o2_t0_l0 = 2.0 * un(i, j, k, Atd_xy) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_yy_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Atd_yy_o1_t2_m0_l0;
					m_Atd_yy_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Atd_yy_o1_t1_m0_l0;
					m_Atd_yy_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Atd_yy_o1_t0_m0_l0;
					m_Atd_yy_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Atd_yy_o0_t2_m0_l0;
					m_Atd_yy_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Atd_yy_o0_t1_m0_l0;
					m_Atd_yy_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Atd_yy_o0_t0_m0_l0;
					m_Atd_xz_o2_t5_l0 = un(i, j, k, Atd_zz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xz_o2_t4_l0 = un(i, j, k, Atd_yz) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xz_o2_t3_l0 = un(i, j, k, Atd_xz) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xz_o2_t2_l0 = un(i, j, k, Atd_xz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_xz_o2_t1_l0 = un(i, j, k, Atd_xy) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_xz_o2_t0_l0 = un(i, j, k, Atd_xx) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_xz_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Atd_xz_o1_t2_m0_l0;
					m_Atd_xz_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Atd_xz_o1_t1_m0_l0;
					m_Atd_xz_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Atd_xz_o1_t0_m0_l0;
					m_Atd_xz_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Atd_xz_o0_t2_m0_l0;
					m_Atd_xz_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Atd_xz_o0_t1_m0_l0;
					m_Atd_xz_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Atd_xz_o0_t0_m0_l0;
					m_Atd_xy_o2_t5_l0 = un(i, j, k, Atd_yz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xy_o2_t4_l0 = un(i, j, k, Atd_yy) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xy_o2_t3_l0 = un(i, j, k, Atd_xy) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xy_o2_t2_l0 = un(i, j, k, Atd_xz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_xy_o2_t1_l0 = un(i, j, k, Atd_xy) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_xy_o2_t0_l0 = un(i, j, k, Atd_xx) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_xy_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Atd_xy_o1_t2_m0_l0;
					m_Atd_xy_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Atd_xy_o1_t1_m0_l0;
					m_Atd_xy_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Atd_xy_o1_t0_m0_l0;
					m_Atd_xy_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Atd_xy_o0_t2_m0_l0;
					m_Atd_xy_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Atd_xy_o0_t1_m0_l0;
					m_Atd_xy_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Atd_xy_o0_t0_m0_l0;
					m_Atd_xx_o2_t2_l0 = 2.0 * un(i, j, k, Atd_xz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xx_o2_t1_l0 = 2.0 * un(i, j, k, Atd_xy) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xx_o2_t0_l0 = 2.0 * un(i, j, k, Atd_xx) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xx_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_Atd_xx_o1_t2_m0_l0;
					m_Atd_xx_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_Atd_xx_o1_t1_m0_l0;
					m_Atd_xx_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_Atd_xx_o1_t0_m0_l0;
					m_Atd_xx_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_Atd_xx_o0_t2_m0_l0;
					m_Atd_xx_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_Atd_xx_o0_t1_m0_l0;
					m_Atd_xx_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_Atd_xx_o0_t0_m0_l0;
					m_gtd_zz_o2_t2_l0 = 2.0 * un(i, j, k, gtd_zz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_zz_o2_t1_l0 = 2.0 * un(i, j, k, gtd_yz) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_zz_o2_t0_l0 = 2.0 * un(i, j, k, gtd_xz) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_zz_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_gtd_zz_o1_t2_m0_l0;
					m_gtd_zz_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_gtd_zz_o1_t1_m0_l0;
					m_gtd_zz_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_gtd_zz_o1_t0_m0_l0;
					m_gtd_zz_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_gtd_zz_o0_t2_m0_l0;
					m_gtd_zz_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_gtd_zz_o0_t1_m0_l0;
					m_gtd_zz_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_gtd_zz_o0_t0_m0_l0;
					m_gtd_yz_o2_t5_l0 = un(i, j, k, gtd_zz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_yz_o2_t4_l0 = un(i, j, k, gtd_yz) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_yz_o2_t3_l0 = un(i, j, k, gtd_xz) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_yz_o2_t2_l0 = un(i, j, k, gtd_yz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_yz_o2_t1_l0 = un(i, j, k, gtd_yy) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_yz_o2_t0_l0 = un(i, j, k, gtd_xy) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_yz_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_gtd_yz_o1_t2_m0_l0;
					m_gtd_yz_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_gtd_yz_o1_t1_m0_l0;
					m_gtd_yz_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_gtd_yz_o1_t0_m0_l0;
					m_gtd_yz_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_gtd_yz_o0_t2_m0_l0;
					m_gtd_yz_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_gtd_yz_o0_t1_m0_l0;
					m_gtd_yz_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_gtd_yz_o0_t0_m0_l0;
					m_gtd_yy_o2_t2_l0 = 2.0 * un(i, j, k, gtd_yz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_yy_o2_t1_l0 = 2.0 * un(i, j, k, gtd_yy) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_yy_o2_t0_l0 = 2.0 * un(i, j, k, gtd_xy) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_yy_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_gtd_yy_o1_t2_m0_l0;
					m_gtd_yy_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_gtd_yy_o1_t1_m0_l0;
					m_gtd_yy_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_gtd_yy_o1_t0_m0_l0;
					m_gtd_yy_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_gtd_yy_o0_t2_m0_l0;
					m_gtd_yy_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_gtd_yy_o0_t1_m0_l0;
					m_gtd_yy_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_gtd_yy_o0_t0_m0_l0;
					m_gtd_xz_o2_t5_l0 = un(i, j, k, gtd_zz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xz_o2_t4_l0 = un(i, j, k, gtd_yz) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xz_o2_t3_l0 = un(i, j, k, gtd_xz) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xz_o2_t2_l0 = un(i, j, k, gtd_xz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_xz_o2_t1_l0 = un(i, j, k, gtd_xy) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_xz_o2_t0_l0 = un(i, j, k, gtd_xx) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_xz_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_gtd_xz_o1_t2_m0_l0;
					m_gtd_xz_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_gtd_xz_o1_t1_m0_l0;
					m_gtd_xz_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_gtd_xz_o1_t0_m0_l0;
					m_gtd_xz_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_gtd_xz_o0_t2_m0_l0;
					m_gtd_xz_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_gtd_xz_o0_t1_m0_l0;
					m_gtd_xz_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_gtd_xz_o0_t0_m0_l0;
					m_gtd_xy_o2_t5_l0 = un(i, j, k, gtd_yz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xy_o2_t4_l0 = un(i, j, k, gtd_yy) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xy_o2_t3_l0 = un(i, j, k, gtd_xy) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xy_o2_t2_l0 = un(i, j, k, gtd_xz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_xy_o2_t1_l0 = un(i, j, k, gtd_xy) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_xy_o2_t0_l0 = un(i, j, k, gtd_xx) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_xy_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_gtd_xy_o1_t2_m0_l0;
					m_gtd_xy_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_gtd_xy_o1_t1_m0_l0;
					m_gtd_xy_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_gtd_xy_o1_t0_m0_l0;
					m_gtd_xy_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_gtd_xy_o0_t2_m0_l0;
					m_gtd_xy_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_gtd_xy_o0_t1_m0_l0;
					m_gtd_xy_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_gtd_xy_o0_t0_m0_l0;
					m_gtd_xx_o2_t2_l0 = 2.0 * un(i, j, k, gtd_xz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xx_o2_t1_l0 = 2.0 * un(i, j, k, gtd_xy) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xx_o2_t0_l0 = 2.0 * un(i, j, k, gtd_xx) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xx_o1_t2_l0 = std::min(0.0, un(i, j, k, Betau_z)) * d_gtd_xx_o1_t2_m0_l0;
					m_gtd_xx_o1_t1_l0 = std::min(0.0, un(i, j, k, Betau_y)) * d_gtd_xx_o1_t1_m0_l0;
					m_gtd_xx_o1_t0_l0 = std::min(0.0, un(i, j, k, Betau_x)) * d_gtd_xx_o1_t0_m0_l0;
					m_gtd_xx_o0_t2_l0 = std::max(0.0, un(i, j, k, Betau_z)) * d_gtd_xx_o0_t2_m0_l0;
					m_gtd_xx_o0_t1_l0 = std::max(0.0, un(i, j, k, Betau_y)) * d_gtd_xx_o0_t1_m0_l0;
					m_gtd_xx_o0_t0_l0 = std::max(0.0, un(i, j, k, Betau_x)) * d_gtd_xx_o0_t0_m0_l0;
					RHS_gtd_xx = ((((((((m_gtd_xx_o0_t0_l0 + m_gtd_xx_o0_t1_l0) + m_gtd_xx_o0_t2_l0) + m_gtd_xx_o1_t0_l0) + m_gtd_xx_o1_t1_l0) + m_gtd_xx_o1_t2_l0) + m_gtd_xx_o2_t0_l0) + m_gtd_xx_o2_t1_l0) + m_gtd_xx_o2_t2_l0) + d_gtd_xx_o2_t3_m0_l0;
					RHS_gtd_xy = (((((((((((m_gtd_xy_o0_t0_l0 + m_gtd_xy_o0_t1_l0) + m_gtd_xy_o0_t2_l0) + m_gtd_xy_o1_t0_l0) + m_gtd_xy_o1_t1_l0) + m_gtd_xy_o1_t2_l0) + m_gtd_xy_o2_t0_l0) + m_gtd_xy_o2_t1_l0) + m_gtd_xy_o2_t2_l0) + m_gtd_xy_o2_t3_l0) + m_gtd_xy_o2_t4_l0) + m_gtd_xy_o2_t5_l0) + d_gtd_xy_o2_t6_m0_l0;
					RHS_gtd_xz = (((((((((((m_gtd_xz_o0_t0_l0 + m_gtd_xz_o0_t1_l0) + m_gtd_xz_o0_t2_l0) + m_gtd_xz_o1_t0_l0) + m_gtd_xz_o1_t1_l0) + m_gtd_xz_o1_t2_l0) + m_gtd_xz_o2_t0_l0) + m_gtd_xz_o2_t1_l0) + m_gtd_xz_o2_t2_l0) + m_gtd_xz_o2_t3_l0) + m_gtd_xz_o2_t4_l0) + m_gtd_xz_o2_t5_l0) + d_gtd_xz_o2_t6_m0_l0;
					RHS_gtd_yy = ((((((((m_gtd_yy_o0_t0_l0 + m_gtd_yy_o0_t1_l0) + m_gtd_yy_o0_t2_l0) + m_gtd_yy_o1_t0_l0) + m_gtd_yy_o1_t1_l0) + m_gtd_yy_o1_t2_l0) + m_gtd_yy_o2_t0_l0) + m_gtd_yy_o2_t1_l0) + m_gtd_yy_o2_t2_l0) + d_gtd_yy_o2_t3_m0_l0;
					RHS_gtd_yz = (((((((((((m_gtd_yz_o0_t0_l0 + m_gtd_yz_o0_t1_l0) + m_gtd_yz_o0_t2_l0) + m_gtd_yz_o1_t0_l0) + m_gtd_yz_o1_t1_l0) + m_gtd_yz_o1_t2_l0) + m_gtd_yz_o2_t0_l0) + m_gtd_yz_o2_t1_l0) + m_gtd_yz_o2_t2_l0) + m_gtd_yz_o2_t3_l0) + m_gtd_yz_o2_t4_l0) + m_gtd_yz_o2_t5_l0) + d_gtd_yz_o2_t6_m0_l0;
					RHS_gtd_zz = ((((((((m_gtd_zz_o0_t0_l0 + m_gtd_zz_o0_t1_l0) + m_gtd_zz_o0_t2_l0) + m_gtd_zz_o1_t0_l0) + m_gtd_zz_o1_t1_l0) + m_gtd_zz_o1_t2_l0) + m_gtd_zz_o2_t0_l0) + m_gtd_zz_o2_t1_l0) + m_gtd_zz_o2_t2_l0) + d_gtd_zz_o2_t3_m0_l0;
					RHS_Atd_xx = ((((((((m_Atd_xx_o0_t0_l0 + m_Atd_xx_o0_t1_l0) + m_Atd_xx_o0_t2_l0) + m_Atd_xx_o1_t0_l0) + m_Atd_xx_o1_t1_l0) + m_Atd_xx_o1_t2_l0) + m_Atd_xx_o2_t0_l0) + m_Atd_xx_o2_t1_l0) + m_Atd_xx_o2_t2_l0) + d_Atd_xx_o2_t3_m0_l0;
					RHS_Atd_xy = (((((((((((m_Atd_xy_o0_t0_l0 + m_Atd_xy_o0_t1_l0) + m_Atd_xy_o0_t2_l0) + m_Atd_xy_o1_t0_l0) + m_Atd_xy_o1_t1_l0) + m_Atd_xy_o1_t2_l0) + m_Atd_xy_o2_t0_l0) + m_Atd_xy_o2_t1_l0) + m_Atd_xy_o2_t2_l0) + m_Atd_xy_o2_t3_l0) + m_Atd_xy_o2_t4_l0) + m_Atd_xy_o2_t5_l0) + d_Atd_xy_o2_t6_m0_l0;
					RHS_Atd_xz = (((((((((((m_Atd_xz_o0_t0_l0 + m_Atd_xz_o0_t1_l0) + m_Atd_xz_o0_t2_l0) + m_Atd_xz_o1_t0_l0) + m_Atd_xz_o1_t1_l0) + m_Atd_xz_o1_t2_l0) + m_Atd_xz_o2_t0_l0) + m_Atd_xz_o2_t1_l0) + m_Atd_xz_o2_t2_l0) + m_Atd_xz_o2_t3_l0) + m_Atd_xz_o2_t4_l0) + m_Atd_xz_o2_t5_l0) + d_Atd_xz_o2_t6_m0_l0;
					RHS_Atd_yy = ((((((((m_Atd_yy_o0_t0_l0 + m_Atd_yy_o0_t1_l0) + m_Atd_yy_o0_t2_l0) + m_Atd_yy_o1_t0_l0) + m_Atd_yy_o1_t1_l0) + m_Atd_yy_o1_t2_l0) + m_Atd_yy_o2_t0_l0) + m_Atd_yy_o2_t1_l0) + m_Atd_yy_o2_t2_l0) + d_Atd_yy_o2_t3_m0_l0;
					RHS_Atd_yz = (((((((((((m_Atd_yz_o0_t0_l0 + m_Atd_yz_o0_t1_l0) + m_Atd_yz_o0_t2_l0) + m_Atd_yz_o1_t0_l0) + m_Atd_yz_o1_t1_l0) + m_Atd_yz_o1_t2_l0) + m_Atd_yz_o2_t0_l0) + m_Atd_yz_o2_t1_l0) + m_Atd_yz_o2_t2_l0) + m_Atd_yz_o2_t3_l0) + m_Atd_yz_o2_t4_l0) + m_Atd_yz_o2_t5_l0) + d_Atd_yz_o2_t6_m0_l0;
					RHS_Atd_zz = ((((((((m_Atd_zz_o0_t0_l0 + m_Atd_zz_o0_t1_l0) + m_Atd_zz_o0_t2_l0) + m_Atd_zz_o1_t0_l0) + m_Atd_zz_o1_t1_l0) + m_Atd_zz_o1_t2_l0) + m_Atd_zz_o2_t0_l0) + m_Atd_zz_o2_t1_l0) + m_Atd_zz_o2_t2_l0) + d_Atd_zz_o2_t3_m0_l0;
					RHS_Gamh_x = (((((((((((((((((((((((((((((m_Gamh_x_o0_t0_l0 + m_Gamh_x_o0_t1_l0) + m_Gamh_x_o0_t2_l0) + m_Gamh_x_o1_t0_l0) + m_Gamh_x_o1_t1_l0) + m_Gamh_x_o1_t2_l0) + m_Gamh_x_o2_t0_l0) + m_Gamh_x_o2_t1_l0) + m_Gamh_x_o2_t2_l0) + m_Gamh_x_o2_t3_l0) + m_Gamh_x_o2_t4_l0) + m_Gamh_x_o2_t5_l0) + m_Gamh_x_o2_t6_l0) + m_Gamh_x_o2_t7_l0) + m_Gamh_x_o2_t8_l0) + m_Gamh_x_o2_t9_l0) + m_Gamh_x_o2_t10_l0) + m_Gamh_x_o2_t11_l0) + m_Gamh_x_o2_t12_l0) + m_Gamh_x_o2_t13_l0) + m_Gamh_x_o2_t14_l0) + m_Gamh_x_o2_t15_l0) + m_Gamh_x_o2_t16_l0) + m_Gamh_x_o2_t17_l0) + m_Gamh_x_o2_t18_l0) + m_Gamh_x_o2_t19_l0) + m_Gamh_x_o2_t20_l0) + m_Gamh_x_o2_t21_l0) + m_Gamh_x_o2_t22_l0) + m_Gamh_x_o2_t23_l0) + d_Gamh_x_o2_t24_m0_l0;
					RHS_Gamh_y = (((((((((((((((((((((((((((((m_Gamh_y_o0_t0_l0 + m_Gamh_y_o0_t1_l0) + m_Gamh_y_o0_t2_l0) + m_Gamh_y_o1_t0_l0) + m_Gamh_y_o1_t1_l0) + m_Gamh_y_o1_t2_l0) + m_Gamh_y_o2_t0_l0) + m_Gamh_y_o2_t1_l0) + m_Gamh_y_o2_t2_l0) + m_Gamh_y_o2_t3_l0) + m_Gamh_y_o2_t4_l0) + m_Gamh_y_o2_t5_l0) + m_Gamh_y_o2_t6_l0) + m_Gamh_y_o2_t7_l0) + m_Gamh_y_o2_t8_l0) + m_Gamh_y_o2_t9_l0) + m_Gamh_y_o2_t10_l0) + m_Gamh_y_o2_t11_l0) + m_Gamh_y_o2_t12_l0) + m_Gamh_y_o2_t13_l0) + m_Gamh_y_o2_t14_l0) + m_Gamh_y_o2_t15_l0) + m_Gamh_y_o2_t16_l0) + m_Gamh_y_o2_t17_l0) + m_Gamh_y_o2_t18_l0) + m_Gamh_y_o2_t19_l0) + m_Gamh_y_o2_t20_l0) + m_Gamh_y_o2_t21_l0) + m_Gamh_y_o2_t22_l0) + m_Gamh_y_o2_t23_l0) + d_Gamh_y_o2_t24_m0_l0;
					RHS_Betau_x = (((((d_Betau_x_o0_t0_m0_l0 + m_Betau_x_o1_t0_l0) + m_Betau_x_o1_t1_l0) + m_Betau_x_o1_t2_l0) + m_Betau_x_o2_t0_l0) + m_Betau_x_o2_t1_l0) + m_Betau_x_o2_t2_l0;
					RHS_Betau_y = (((((d_Betau_y_o0_t0_m0_l0 + m_Betau_y_o1_t0_l0) + m_Betau_y_o1_t1_l0) + m_Betau_y_o1_t2_l0) + m_Betau_y_o2_t0_l0) + m_Betau_y_o2_t1_l0) + m_Betau_y_o2_t2_l0;
					RHS_Betau_z = (((((d_Betau_z_o0_t0_m0_l0 + m_Betau_z_o1_t0_l0) + m_Betau_z_o1_t1_l0) + m_Betau_z_o1_t2_l0) + m_Betau_z_o2_t0_l0) + m_Betau_z_o2_t1_l0) + m_Betau_z_o2_t2_l0;
					RHS_Gamh_z = (((((((((((((((((((((((((((((m_Gamh_z_o0_t0_l0 + m_Gamh_z_o0_t1_l0) + m_Gamh_z_o0_t2_l0) + m_Gamh_z_o1_t0_l0) + m_Gamh_z_o1_t1_l0) + m_Gamh_z_o1_t2_l0) + m_Gamh_z_o2_t0_l0) + m_Gamh_z_o2_t1_l0) + m_Gamh_z_o2_t2_l0) + m_Gamh_z_o2_t3_l0) + m_Gamh_z_o2_t4_l0) + m_Gamh_z_o2_t5_l0) + m_Gamh_z_o2_t6_l0) + m_Gamh_z_o2_t7_l0) + m_Gamh_z_o2_t8_l0) + m_Gamh_z_o2_t9_l0) + m_Gamh_z_o2_t10_l0) + m_Gamh_z_o2_t11_l0) + m_Gamh_z_o2_t12_l0) + m_Gamh_z_o2_t13_l0) + m_Gamh_z_o2_t14_l0) + m_Gamh_z_o2_t15_l0) + m_Gamh_z_o2_t16_l0) + m_Gamh_z_o2_t17_l0) + m_Gamh_z_o2_t18_l0) + m_Gamh_z_o2_t19_l0) + m_Gamh_z_o2_t20_l0) + m_Gamh_z_o2_t21_l0) + m_Gamh_z_o2_t22_l0) + m_Gamh_z_o2_t23_l0) + d_Gamh_z_o2_t24_m0_l0;
					RHS_Alpha = (((((m_Alpha_o0_t0_l0 + m_Alpha_o0_t1_l0) + m_Alpha_o0_t2_l0) + m_Alpha_o1_t0_l0) + m_Alpha_o1_t1_l0) + m_Alpha_o1_t2_l0) + d_Alpha_o2_t0_m0_l0;
					RHS_chi = (((((m_chi_o0_t0_l0 + m_chi_o0_t1_l0) + m_chi_o0_t2_l0) + m_chi_o1_t0_l0) + m_chi_o1_t1_l0) + m_chi_o1_t2_l0) + d_chi_o2_t0_m0_l0;
					RHS_trK = ((((((((((((((((((((((((((m_trK_o0_t0_l0 + m_trK_o0_t1_l0) + m_trK_o0_t2_l0) + m_trK_o1_t0_l0) + m_trK_o1_t1_l0) + m_trK_o1_t2_l0) + m_trK_o2_t0_l0) + m_trK_o2_t1_l0) + m_trK_o2_t2_l0) + m_trK_o2_t3_l0) + m_trK_o2_t4_l0) + m_trK_o2_t5_l0) + m_trK_o2_t6_l0) + m_trK_o2_t7_l0) + m_trK_o2_t8_l0) + m_trK_o2_t9_l0) + m_trK_o2_t10_l0) + m_trK_o2_t11_l0) + m_trK_o2_t12_l0) + m_trK_o2_t13_l0) + m_trK_o2_t14_l0) + m_trK_o2_t15_l0) + m_trK_o2_t16_l0) + m_trK_o2_t17_l0) + m_trK_o2_t18_l0) + m_trK_o2_t19_l0) + m_trK_o2_t20_l0) + d_trK_o2_t21_m0_l0;
					RHS_theta = ((((((((m_theta_o0_t0_l0 + m_theta_o0_t1_l0) + m_theta_o0_t2_l0) + m_theta_o1_t0_l0) + m_theta_o1_t1_l0) + m_theta_o1_t2_l0) + m_theta_o2_t0_l0) + m_theta_o2_t1_l0) + m_theta_o2_t2_l0) + d_theta_o2_t3_m0_l0;
					RHS_phiR = (((((m_phiR_o0_t0_l0 + m_phiR_o0_t1_l0) + m_phiR_o0_t2_l0) + m_phiR_o1_t0_l0) + m_phiR_o1_t1_l0) + m_phiR_o1_t2_l0) + d_d_phiR4d_t_o0_t0_m0_l0_p;
					RHS_pheR = (((((m_pheR_o0_t0_l0 + m_pheR_o0_t1_l0) + m_pheR_o0_t2_l0) + m_pheR_o1_t0_l0) + m_pheR_o1_t1_l0) + m_pheR_o1_t2_l0) + d_d_pheR4d_t_o0_t0_m0_l0_p;
					RHS_phiI = (((((m_phiI_o0_t0_l0 + m_phiI_o0_t1_l0) + m_phiI_o0_t2_l0) + m_phiI_o1_t0_l0) + m_phiI_o1_t1_l0) + m_phiI_o1_t2_l0) + d_d_phiI4d_t_o0_t0_m0_l0_p;
					RHS_pheI = (((((m_pheI_o0_t0_l0 + m_pheI_o0_t1_l0) + m_pheI_o0_t2_l0) + m_pheI_o1_t0_l0) + m_pheI_o1_t1_l0) + m_pheI_o1_t2_l0) + d_d_pheI4d_t_o0_t0_m0_l0_p;
					RHS_piR = ((((((((((((((((((((((((((((((((m_piR_o0_t0_l0 + m_piR_o0_t1_l0) + m_piR_o0_t2_l0) + m_piR_o1_t0_l0) + m_piR_o1_t1_l0) + m_piR_o1_t2_l0) + m_piR_o2_t0_l0) + m_piR_o2_t1_l0) + m_piR_o2_t2_l0) + m_piR_o2_t3_l0) + m_piR_o2_t4_l0) + m_piR_o2_t5_l0) + m_piR_o2_t6_l0) + m_piR_o2_t7_l0) + m_piR_o2_t8_l0) + m_piR_o2_t9_l0) + m_piR_o2_t10_l0) + m_piR_o2_t11_l0) + m_piR_o2_t12_l0) + m_piR_o2_t13_l0) + m_piR_o2_t14_l0) + m_piR_o2_t15_l0) + m_piR_o2_t16_l0) + m_piR_o2_t17_l0) + m_piR_o2_t18_l0) + m_piR_o2_t19_l0) + m_piR_o2_t20_l0) + m_piR_o2_t21_l0) + m_piR_o2_t22_l0) + m_piR_o2_t23_l0) + m_piR_o2_t24_l0) + m_piR_o2_t25_l0) + m_piR_o2_t26_l0) + d_piR_o2_t27_m0_l0;
					RHS_peR = ((((((((((((((((((((((((((((((((m_peR_o0_t0_l0 + m_peR_o0_t1_l0) + m_peR_o0_t2_l0) + m_peR_o1_t0_l0) + m_peR_o1_t1_l0) + m_peR_o1_t2_l0) + m_peR_o2_t0_l0) + m_peR_o2_t1_l0) + m_peR_o2_t2_l0) + m_peR_o2_t3_l0) + m_peR_o2_t4_l0) + m_peR_o2_t5_l0) + m_peR_o2_t6_l0) + m_peR_o2_t7_l0) + m_peR_o2_t8_l0) + m_peR_o2_t9_l0) + m_peR_o2_t10_l0) + m_peR_o2_t11_l0) + m_peR_o2_t12_l0) + m_peR_o2_t13_l0) + m_peR_o2_t14_l0) + m_peR_o2_t15_l0) + m_peR_o2_t16_l0) + m_peR_o2_t17_l0) + m_peR_o2_t18_l0) + m_peR_o2_t19_l0) + m_peR_o2_t20_l0) + m_peR_o2_t21_l0) + m_peR_o2_t22_l0) + m_peR_o2_t23_l0) + m_peR_o2_t24_l0) + m_peR_o2_t25_l0) + m_peR_o2_t26_l0) + d_peR_o2_t27_m0_l0;
					RHS_piI = ((((((((((((((((((((((((((((((((m_piI_o0_t0_l0 + m_piI_o0_t1_l0) + m_piI_o0_t2_l0) + m_piI_o1_t0_l0) + m_piI_o1_t1_l0) + m_piI_o1_t2_l0) + m_piI_o2_t0_l0) + m_piI_o2_t1_l0) + m_piI_o2_t2_l0) + m_piI_o2_t3_l0) + m_piI_o2_t4_l0) + m_piI_o2_t5_l0) + m_piI_o2_t6_l0) + m_piI_o2_t7_l0) + m_piI_o2_t8_l0) + m_piI_o2_t9_l0) + m_piI_o2_t10_l0) + m_piI_o2_t11_l0) + m_piI_o2_t12_l0) + m_piI_o2_t13_l0) + m_piI_o2_t14_l0) + m_piI_o2_t15_l0) + m_piI_o2_t16_l0) + m_piI_o2_t17_l0) + m_piI_o2_t18_l0) + m_piI_o2_t19_l0) + m_piI_o2_t20_l0) + m_piI_o2_t21_l0) + m_piI_o2_t22_l0) + m_piI_o2_t23_l0) + m_piI_o2_t24_l0) + m_piI_o2_t25_l0) + m_piI_o2_t26_l0) + d_piI_o2_t27_m0_l0;
					RHS_peI = ((((((((((((((((((((((((((((((((m_peI_o0_t0_l0 + m_peI_o0_t1_l0) + m_peI_o0_t2_l0) + m_peI_o1_t0_l0) + m_peI_o1_t1_l0) + m_peI_o1_t2_l0) + m_peI_o2_t0_l0) + m_peI_o2_t1_l0) + m_peI_o2_t2_l0) + m_peI_o2_t3_l0) + m_peI_o2_t4_l0) + m_peI_o2_t5_l0) + m_peI_o2_t6_l0) + m_peI_o2_t7_l0) + m_peI_o2_t8_l0) + m_peI_o2_t9_l0) + m_peI_o2_t10_l0) + m_peI_o2_t11_l0) + m_peI_o2_t12_l0) + m_peI_o2_t13_l0) + m_peI_o2_t14_l0) + m_peI_o2_t15_l0) + m_peI_o2_t16_l0) + m_peI_o2_t17_l0) + m_peI_o2_t18_l0) + m_peI_o2_t19_l0) + m_peI_o2_t20_l0) + m_peI_o2_t21_l0) + m_peI_o2_t22_l0) + m_peI_o2_t23_l0) + m_peI_o2_t24_l0) + m_peI_o2_t25_l0) + m_peI_o2_t26_l0) + d_peI_o2_t27_m0_l0;
					n_x = 0.0;
					n_y = 0.0;
					n_z = 0.0;
					interaction_index = 0.0;
					if ((((((regions(i + 1, j, k, FOV_xLower) > 0.0) || (regions(i + 1, j, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k, FOV_yLower) > 0.0)) || (regions(i + 1, j, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k, FOV_zLower) > 0.0)) || (regions(i + 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x + 1.0 / dx[0];
					}
					if ((((((regions(i - 1, j, k, FOV_xLower) > 0.0) || (regions(i - 1, j, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k, FOV_yLower) > 0.0)) || (regions(i - 1, j, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k, FOV_zLower) > 0.0)) || (regions(i - 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x - 1.0 / dx[0];
					}
					if ((((((regions(i, j + 1, k, FOV_xLower) > 0.0) || (regions(i, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k, FOV_yLower) > 0.0)) || (regions(i, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k, FOV_zLower) > 0.0)) || (regions(i, j + 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y + 1.0 / dx[1];
					}
					if ((((((regions(i, j - 1, k, FOV_xLower) > 0.0) || (regions(i, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k, FOV_yLower) > 0.0)) || (regions(i, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k, FOV_zLower) > 0.0)) || (regions(i, j - 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y - 1.0 / dx[1];
					}
					if ((((((regions(i, j, k + 1, FOV_xLower) > 0.0) || (regions(i, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j, k + 1, FOV_yLower) > 0.0)) || (regions(i, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j, k + 1, FOV_zLower) > 0.0)) || (regions(i, j, k + 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z + 1.0 / dx[2];
					}
					if ((((((regions(i, j, k - 1, FOV_xLower) > 0.0) || (regions(i, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j, k - 1, FOV_yLower) > 0.0)) || (regions(i, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j, k - 1, FOV_zLower) > 0.0)) || (regions(i, j, k - 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z - 1.0 / dx[2];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k, FOV_xLower) > 0.0)) || (regions(i + 1, j, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k, FOV_yLower) > 0.0)) || (regions(i + 1, j, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k, FOV_zLower) > 0.0)) || (regions(i + 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x + 1.0 / dx[0];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k, FOV_xLower) > 0.0)) || (regions(i - 1, j, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k, FOV_yLower) > 0.0)) || (regions(i - 1, j, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k, FOV_zLower) > 0.0)) || (regions(i - 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x - 1.0 / dx[0];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k, FOV_xLower) > 0.0)) || (regions(i, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k, FOV_yLower) > 0.0)) || (regions(i, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k, FOV_zLower) > 0.0)) || (regions(i, j + 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y + 1.0 / dx[1];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k, FOV_xLower) > 0.0)) || (regions(i, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k, FOV_yLower) > 0.0)) || (regions(i, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k, FOV_zLower) > 0.0)) || (regions(i, j - 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y - 1.0 / dx[1];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j, k + 1, FOV_xLower) > 0.0)) || (regions(i, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j, k + 1, FOV_yLower) > 0.0)) || (regions(i, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j, k + 1, FOV_zLower) > 0.0)) || (regions(i, j, k + 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z + 1.0 / dx[2];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j, k - 1, FOV_xLower) > 0.0)) || (regions(i, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j, k - 1, FOV_yLower) > 0.0)) || (regions(i, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j, k - 1, FOV_zLower) > 0.0)) || (regions(i, j, k - 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z - 1.0 / dx[2];
					}
					if ((!equalsEq(n_x, 0.0) || !equalsEq(n_y, 0.0)) || !equalsEq(n_z, 0.0)) {
						mod_normal = sqrt((n_x * n_x + n_y * n_y) + n_z * n_z);
						n_x = n_x / mod_normal;
						n_y = n_y / mod_normal;
						n_z = n_z / mod_normal;
					}
					if (equalsEq(interaction_index, 1.0)) {
						i_d_Atd_xx_o0_t0_m0_l0 = D1CDO4_i(Atd_xx, un, i, j, k, dx, dt_lev);
						i_d_Atd_xx_o0_t1_m0_l0 = D1CDO4_j(Atd_xx, un, i, j, k, dx, dt_lev);
						i_d_Atd_xx_o0_t2_m0_l0 = D1CDO4_k(Atd_xx, un, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t0_m0_l0 = D1CDO4_i(Atd_xy, un, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t1_m0_l0 = D1CDO4_j(Atd_xy, un, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t2_m0_l0 = D1CDO4_k(Atd_xy, un, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t0_m0_l0 = D1CDO4_i(Atd_xz, un, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t1_m0_l0 = D1CDO4_j(Atd_xz, un, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t2_m0_l0 = D1CDO4_k(Atd_xz, un, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t0_m0_l0 = D1CDO4_i(Atd_yy, un, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t1_m0_l0 = D1CDO4_j(Atd_yy, un, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t2_m0_l0 = D1CDO4_k(Atd_yy, un, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t0_m0_l0 = D1CDO4_i(Atd_yz, un, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t1_m0_l0 = D1CDO4_j(Atd_yz, un, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t2_m0_l0 = D1CDO4_k(Atd_yz, un, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t0_m0_l0 = D1CDO4_i(Atd_zz, un, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t1_m0_l0 = D1CDO4_j(Atd_zz, un, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t2_m0_l0 = D1CDO4_k(Atd_zz, un, i, j, k, dx, dt_lev);
						i_d_piR_o0_t0_m0_l0 = D1CDO4_i(piR, un, i, j, k, dx, dt_lev);
						i_d_piR_o0_t1_m0_l0 = D1CDO4_j(piR, un, i, j, k, dx, dt_lev);
						i_d_piR_o0_t2_m0_l0 = D1CDO4_k(piR, un, i, j, k, dx, dt_lev);
						i_d_peR_o0_t0_m0_l0 = D1CDO4_i(peR, un, i, j, k, dx, dt_lev);
						i_d_peR_o0_t1_m0_l0 = D1CDO4_j(peR, un, i, j, k, dx, dt_lev);
						i_d_peR_o0_t2_m0_l0 = D1CDO4_k(peR, un, i, j, k, dx, dt_lev);
						i_d_piI_o0_t0_m0_l0 = D1CDO4_i(piI, un, i, j, k, dx, dt_lev);
						i_d_piI_o0_t1_m0_l0 = D1CDO4_j(piI, un, i, j, k, dx, dt_lev);
						i_d_piI_o0_t2_m0_l0 = D1CDO4_k(piI, un, i, j, k, dx, dt_lev);
						i_d_peI_o0_t0_m0_l0 = D1CDO4_i(peI, un, i, j, k, dx, dt_lev);
						i_d_peI_o0_t1_m0_l0 = D1CDO4_j(peI, un, i, j, k, dx, dt_lev);
						i_d_peI_o0_t2_m0_l0 = D1CDO4_k(peI, un, i, j, k, dx, dt_lev);
						i_d_gtd_xx_o0_t3_m0_l0 = -parameters.gtd_xx_falloff * (un(i, j, k, gtd_xx) - parameters.gtd_xx_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_xy_o0_t3_m0_l0 = -parameters.gtd_xy_falloff * (un(i, j, k, gtd_xy) - parameters.gtd_xy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_xz_o0_t3_m0_l0 = -parameters.gtd_xz_falloff * (un(i, j, k, gtd_xz) - parameters.gtd_xz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_yy_o0_t3_m0_l0 = -parameters.gtd_yy_falloff * (un(i, j, k, gtd_yy) - parameters.gtd_yy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_yz_o0_t3_m0_l0 = -parameters.gtd_yz_falloff * (un(i, j, k, gtd_yz) - parameters.gtd_yz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_zz_o0_t3_m0_l0 = -parameters.gtd_zz_falloff * (un(i, j, k, gtd_zz) - parameters.gtd_zz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xx_o0_t3_m0_l0 = -parameters.Atd_xx_falloff * (un(i, j, k, Atd_xx) - parameters.Atd_xx_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xy_o0_t3_m0_l0 = -parameters.Atd_xy_falloff * (un(i, j, k, Atd_xy) - parameters.Atd_xy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xz_o0_t3_m0_l0 = -parameters.Atd_xz_falloff * (un(i, j, k, Atd_xz) - parameters.Atd_xz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_yy_o0_t3_m0_l0 = -parameters.Atd_yy_falloff * (un(i, j, k, Atd_yy) - parameters.Atd_yy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_yz_o0_t3_m0_l0 = -parameters.Atd_yz_falloff * (un(i, j, k, Atd_yz) - parameters.Atd_yz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_zz_o0_t3_m0_l0 = -parameters.Atd_zz_falloff * (un(i, j, k, Atd_zz) - parameters.Atd_zz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_x_o0_t3_m0_l0 = -parameters.Gamh_x_falloff * (un(i, j, k, Gamh_x) - parameters.Gamh_x_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_y_o0_t3_m0_l0 = -parameters.Gamh_y_falloff * (un(i, j, k, Gamh_y) - parameters.Gamh_y_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_z_o0_t3_m0_l0 = -parameters.Gamh_z_falloff * (un(i, j, k, Gamh_z) - parameters.Gamh_z_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_x_o0_t3_m0_l0 = -parameters.Betau_x_falloff * (un(i, j, k, Betau_x) - parameters.Betau_x_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_y_o0_t3_m0_l0 = -parameters.Betau_y_falloff * (un(i, j, k, Betau_y) - parameters.Betau_y_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_z_o0_t3_m0_l0 = -parameters.Betau_z_falloff * (un(i, j, k, Betau_z) - parameters.Betau_z_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Alpha_o0_t3_m0_l0 = -parameters.Alpha_falloff * (un(i, j, k, Alpha) - parameters.Alpha_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_chi_o0_t3_m0_l0 = -parameters.chi_falloff * (un(i, j, k, chi) - parameters.chi_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_trK_o0_t3_m0_l0 = -parameters.trK_falloff * (un(i, j, k, trK) - parameters.trK_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_theta_o0_t3_m0_l0 = -parameters.theta_falloff * (un(i, j, k, theta) - parameters.theta_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_phiR_o0_t3_m0_l0 = -parameters.phiR_falloff * (un(i, j, k, phiR) - parameters.phiR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_phiI_o0_t3_m0_l0 = -parameters.phiI_falloff * (un(i, j, k, phiI) - parameters.phiI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_piR_o0_t3_m0_l0 = -parameters.piR_falloff * (un(i, j, k, piR) - parameters.piR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_piI_o0_t3_m0_l0 = -parameters.piI_falloff * (un(i, j, k, piI) - parameters.piI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_pheR_o0_t3_m0_l0 = -parameters.pheR_falloff * (un(i, j, k, pheR) - parameters.pheR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_pheI_o0_t3_m0_l0 = -parameters.pheI_falloff * (un(i, j, k, pheI) - parameters.pheI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_peR_o0_t3_m0_l0 = -parameters.peR_falloff * (un(i, j, k, peR) - parameters.peR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_peI_o0_t3_m0_l0 = -parameters.peI_falloff * (un(i, j, k, peI) - parameters.peI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_m_gtd_xx_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxx_o0_t0_m0_l0;
						i_m_gtd_xx_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxy_o0_t0_m0_l0;
						i_m_gtd_xx_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxz_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yxx_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyy_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t1_m0_l0;
						i_m_gtd_xz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zxx_o0_t0_m0_l0;
						i_m_gtd_xz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t0_m0_l0;
						i_m_gtd_xz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xzz_o0_t0_m0_l0;
						i_m_gtd_yy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyy_o0_t1_m0_l0;
						i_m_gtd_yy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yyy_o0_t0_m0_l0;
						i_m_gtd_yy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yyz_o0_t0_m0_l0;
						i_m_gtd_yz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t2_m0_l0;
						i_m_gtd_yz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zyy_o0_t0_m0_l0;
						i_m_gtd_yz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yzz_o0_t0_m0_l0;
						i_m_gtd_zz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xzz_o0_t1_m0_l0;
						i_m_gtd_zz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yzz_o0_t1_m0_l0;
						i_m_gtd_zz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zzz_o0_t0_m0_l0;
						i_m_Atd_xx_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t0_m0_l0;
						i_m_Atd_xx_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t1_m0_l0;
						i_m_Atd_xx_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t2_m0_l0;
						i_m_Atd_xy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t0_m0_l0;
						i_m_Atd_xy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t1_m0_l0;
						i_m_Atd_xy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t2_m0_l0;
						i_m_Atd_xz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t0_m0_l0;
						i_m_Atd_xz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t1_m0_l0;
						i_m_Atd_xz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t2_m0_l0;
						i_m_Atd_yy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t0_m0_l0;
						i_m_Atd_yy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t1_m0_l0;
						i_m_Atd_yy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t2_m0_l0;
						i_m_Atd_yz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t0_m0_l0;
						i_m_Atd_yz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t1_m0_l0;
						i_m_Atd_yz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t2_m0_l0;
						i_m_Atd_zz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t0_m0_l0;
						i_m_Atd_zz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t1_m0_l0;
						i_m_Atd_zz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t2_m0_l0;
						i_m_Gamh_x_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t6_m0_l0;
						i_m_Gamh_x_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t6_m0_l0;
						i_m_Gamh_x_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t6_m0_l0;
						i_m_Gamh_y_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t7_m0_l0;
						i_m_Gamh_y_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t7_m0_l0;
						i_m_Gamh_y_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t7_m0_l0;
						i_m_Gamh_z_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t8_m0_l0;
						i_m_Gamh_z_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t8_m0_l0;
						i_m_Gamh_z_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t8_m0_l0;
						i_m_Betau_x_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t0_m0_l0;
						i_m_Betau_x_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xy_o2_t0_m0_l0;
						i_m_Betau_x_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xz_o2_t0_m0_l0;
						i_m_Betau_y_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xx_o2_t1_m0_l0;
						i_m_Betau_y_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t1_m0_l0;
						i_m_Betau_y_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xz_o2_t1_m0_l0;
						i_m_Betau_z_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xx_o2_t2_m0_l0;
						i_m_Betau_z_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xy_o2_t2_m0_l0;
						i_m_Betau_z_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t2_m0_l0;
						i_m_Alpha_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t1_m0_l0;
						i_m_Alpha_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t2_m0_l0;
						i_m_Alpha_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t3_m0_l0;
						i_m_chi_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t0_m0_l0;
						i_m_chi_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t1_m0_l0;
						i_m_chi_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t2_m0_l0;
						i_m_trK_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t12_m0_l0;
						i_m_trK_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t13_m0_l0;
						i_m_trK_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t14_m0_l0;
						i_m_theta_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t15_m0_l0;
						i_m_theta_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t16_m0_l0;
						i_m_theta_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t17_m0_l0;
						i_m_phiR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t1_m0_l0;
						i_m_phiR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t2_m0_l0;
						i_m_phiR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t3_m0_l0;
						i_m_phiI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t1_m0_l0;
						i_m_phiI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t2_m0_l0;
						i_m_phiI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t3_m0_l0;
						i_m_piR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t0_m0_l0;
						i_m_piR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t1_m0_l0;
						i_m_piR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t2_m0_l0;
						i_m_piI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t0_m0_l0;
						i_m_piI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t1_m0_l0;
						i_m_piI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t2_m0_l0;
						i_m_pheR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t1_m0_l0;
						i_m_pheR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t2_m0_l0;
						i_m_pheR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t3_m0_l0;
						i_m_pheI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t1_m0_l0;
						i_m_pheI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t2_m0_l0;
						i_m_pheI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t3_m0_l0;
						i_m_peR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t0_m0_l0;
						i_m_peR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t1_m0_l0;
						i_m_peR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t2_m0_l0;
						i_m_peI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t0_m0_l0;
						i_m_peI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t1_m0_l0;
						i_m_peI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t2_m0_l0;
						RHS_gtd_xx = ((i_m_gtd_xx_o0_t0_l0 + i_m_gtd_xx_o0_t1_l0) + i_m_gtd_xx_o0_t2_l0) + i_d_gtd_xx_o0_t3_m0_l0;
						RHS_gtd_xy = ((i_m_gtd_xy_o0_t0_l0 + i_m_gtd_xy_o0_t1_l0) + i_m_gtd_xy_o0_t2_l0) + i_d_gtd_xy_o0_t3_m0_l0;
						RHS_gtd_xz = ((i_m_gtd_xz_o0_t0_l0 + i_m_gtd_xz_o0_t1_l0) + i_m_gtd_xz_o0_t2_l0) + i_d_gtd_xz_o0_t3_m0_l0;
						RHS_gtd_yy = ((i_m_gtd_yy_o0_t0_l0 + i_m_gtd_yy_o0_t1_l0) + i_m_gtd_yy_o0_t2_l0) + i_d_gtd_yy_o0_t3_m0_l0;
						RHS_gtd_yz = ((i_m_gtd_yz_o0_t0_l0 + i_m_gtd_yz_o0_t1_l0) + i_m_gtd_yz_o0_t2_l0) + i_d_gtd_yz_o0_t3_m0_l0;
						RHS_gtd_zz = ((i_m_gtd_zz_o0_t0_l0 + i_m_gtd_zz_o0_t1_l0) + i_m_gtd_zz_o0_t2_l0) + i_d_gtd_zz_o0_t3_m0_l0;
						RHS_Atd_xx = ((i_m_Atd_xx_o0_t0_l0 + i_m_Atd_xx_o0_t1_l0) + i_m_Atd_xx_o0_t2_l0) + i_d_Atd_xx_o0_t3_m0_l0;
						RHS_Atd_xy = ((i_m_Atd_xy_o0_t0_l0 + i_m_Atd_xy_o0_t1_l0) + i_m_Atd_xy_o0_t2_l0) + i_d_Atd_xy_o0_t3_m0_l0;
						RHS_Atd_xz = ((i_m_Atd_xz_o0_t0_l0 + i_m_Atd_xz_o0_t1_l0) + i_m_Atd_xz_o0_t2_l0) + i_d_Atd_xz_o0_t3_m0_l0;
						RHS_Atd_yy = ((i_m_Atd_yy_o0_t0_l0 + i_m_Atd_yy_o0_t1_l0) + i_m_Atd_yy_o0_t2_l0) + i_d_Atd_yy_o0_t3_m0_l0;
						RHS_Atd_yz = ((i_m_Atd_yz_o0_t0_l0 + i_m_Atd_yz_o0_t1_l0) + i_m_Atd_yz_o0_t2_l0) + i_d_Atd_yz_o0_t3_m0_l0;
						RHS_Atd_zz = ((i_m_Atd_zz_o0_t0_l0 + i_m_Atd_zz_o0_t1_l0) + i_m_Atd_zz_o0_t2_l0) + i_d_Atd_zz_o0_t3_m0_l0;
						RHS_Gamh_x = ((i_m_Gamh_x_o0_t0_l0 + i_m_Gamh_x_o0_t1_l0) + i_m_Gamh_x_o0_t2_l0) + i_d_Gamh_x_o0_t3_m0_l0;
						RHS_Gamh_y = ((i_m_Gamh_y_o0_t0_l0 + i_m_Gamh_y_o0_t1_l0) + i_m_Gamh_y_o0_t2_l0) + i_d_Gamh_y_o0_t3_m0_l0;
						RHS_Gamh_z = ((i_m_Gamh_z_o0_t0_l0 + i_m_Gamh_z_o0_t1_l0) + i_m_Gamh_z_o0_t2_l0) + i_d_Gamh_z_o0_t3_m0_l0;
						RHS_Betau_x = ((i_m_Betau_x_o0_t0_l0 + i_m_Betau_x_o0_t1_l0) + i_m_Betau_x_o0_t2_l0) + i_d_Betau_x_o0_t3_m0_l0;
						RHS_Betau_y = ((i_m_Betau_y_o0_t0_l0 + i_m_Betau_y_o0_t1_l0) + i_m_Betau_y_o0_t2_l0) + i_d_Betau_y_o0_t3_m0_l0;
						RHS_Betau_z = ((i_m_Betau_z_o0_t0_l0 + i_m_Betau_z_o0_t1_l0) + i_m_Betau_z_o0_t2_l0) + i_d_Betau_z_o0_t3_m0_l0;
						RHS_Alpha = ((i_m_Alpha_o0_t0_l0 + i_m_Alpha_o0_t1_l0) + i_m_Alpha_o0_t2_l0) + i_d_Alpha_o0_t3_m0_l0;
						RHS_chi = ((i_m_chi_o0_t0_l0 + i_m_chi_o0_t1_l0) + i_m_chi_o0_t2_l0) + i_d_chi_o0_t3_m0_l0;
						RHS_trK = ((i_m_trK_o0_t0_l0 + i_m_trK_o0_t1_l0) + i_m_trK_o0_t2_l0) + i_d_trK_o0_t3_m0_l0;
						RHS_theta = ((i_m_theta_o0_t0_l0 + i_m_theta_o0_t1_l0) + i_m_theta_o0_t2_l0) + i_d_theta_o0_t3_m0_l0;
						RHS_phiR = ((i_m_phiR_o0_t0_l0 + i_m_phiR_o0_t1_l0) + i_m_phiR_o0_t2_l0) + i_d_phiR_o0_t3_m0_l0;
						RHS_phiI = ((i_m_phiI_o0_t0_l0 + i_m_phiI_o0_t1_l0) + i_m_phiI_o0_t2_l0) + i_d_phiI_o0_t3_m0_l0;
						RHS_piR = ((i_m_piR_o0_t0_l0 + i_m_piR_o0_t1_l0) + i_m_piR_o0_t2_l0) + i_d_piR_o0_t3_m0_l0;
						RHS_piI = ((i_m_piI_o0_t0_l0 + i_m_piI_o0_t1_l0) + i_m_piI_o0_t2_l0) + i_d_piI_o0_t3_m0_l0;
						RHS_pheR = ((i_m_pheR_o0_t0_l0 + i_m_pheR_o0_t1_l0) + i_m_pheR_o0_t2_l0) + i_d_pheR_o0_t3_m0_l0;
						RHS_pheI = ((i_m_pheI_o0_t0_l0 + i_m_pheI_o0_t1_l0) + i_m_pheI_o0_t2_l0) + i_d_pheI_o0_t3_m0_l0;
						RHS_peR = ((i_m_peR_o0_t0_l0 + i_m_peR_o0_t1_l0) + i_m_peR_o0_t2_l0) + i_d_peR_o0_t3_m0_l0;
						RHS_peI = ((i_m_peI_o0_t0_l0 + i_m_peI_o0_t1_l0) + i_m_peI_o0_t2_l0) + i_d_peI_o0_t3_m0_l0;
					}
					if (parameters.dissipation_factor_gtd_xx > 0.0) {
						RHS_gtd_xx = RHS_gtd_xx + parameters.dissipation_factor_gtd_xx * (meshDissipation_i(gtd_xx, un, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xx, un, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xx, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_xy > 0.0) {
						RHS_gtd_xy = RHS_gtd_xy + parameters.dissipation_factor_gtd_xy * (meshDissipation_i(gtd_xy, un, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xy, un, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xy, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_xz > 0.0) {
						RHS_gtd_xz = RHS_gtd_xz + parameters.dissipation_factor_gtd_xz * (meshDissipation_i(gtd_xz, un, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xz, un, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xz, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_yy > 0.0) {
						RHS_gtd_yy = RHS_gtd_yy + parameters.dissipation_factor_gtd_yy * (meshDissipation_i(gtd_yy, un, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_yy, un, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_yy, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_yz > 0.0) {
						RHS_gtd_yz = RHS_gtd_yz + parameters.dissipation_factor_gtd_yz * (meshDissipation_i(gtd_yz, un, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_yz, un, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_yz, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_zz > 0.0) {
						RHS_gtd_zz = RHS_gtd_zz + parameters.dissipation_factor_gtd_zz * (meshDissipation_i(gtd_zz, un, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_zz, un, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_zz, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xx > 0.0) {
						RHS_Atd_xx = RHS_Atd_xx + parameters.dissipation_factor_Atd_xx * (meshDissipation_i(Atd_xx, un, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xx, un, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xx, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xy > 0.0) {
						RHS_Atd_xy = RHS_Atd_xy + parameters.dissipation_factor_Atd_xy * (meshDissipation_i(Atd_xy, un, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xy, un, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xy, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xz > 0.0) {
						RHS_Atd_xz = RHS_Atd_xz + parameters.dissipation_factor_Atd_xz * (meshDissipation_i(Atd_xz, un, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xz, un, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xz, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_yy > 0.0) {
						RHS_Atd_yy = RHS_Atd_yy + parameters.dissipation_factor_Atd_yy * (meshDissipation_i(Atd_yy, un, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_yy, un, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_yy, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_yz > 0.0) {
						RHS_Atd_yz = RHS_Atd_yz + parameters.dissipation_factor_Atd_yz * (meshDissipation_i(Atd_yz, un, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_yz, un, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_yz, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_zz > 0.0) {
						RHS_Atd_zz = RHS_Atd_zz + parameters.dissipation_factor_Atd_zz * (meshDissipation_i(Atd_zz, un, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_zz, un, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_zz, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_x > 0.0) {
						RHS_Gamh_x = RHS_Gamh_x + parameters.dissipation_factor_Gamh_x * (meshDissipation_i(Gamh_x, un, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_x, un, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_x, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_y > 0.0) {
						RHS_Gamh_y = RHS_Gamh_y + parameters.dissipation_factor_Gamh_y * (meshDissipation_i(Gamh_y, un, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_y, un, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_y, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_x > 0.0) {
						RHS_Betau_x = RHS_Betau_x + parameters.dissipation_factor_Betau_x * (meshDissipation_i(Betau_x, un, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_x, un, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_x, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_y > 0.0) {
						RHS_Betau_y = RHS_Betau_y + parameters.dissipation_factor_Betau_y * (meshDissipation_i(Betau_y, un, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_y, un, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_y, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_z > 0.0) {
						RHS_Betau_z = RHS_Betau_z + parameters.dissipation_factor_Betau_z * (meshDissipation_i(Betau_z, un, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_z, un, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_z, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_z > 0.0) {
						RHS_Gamh_z = RHS_Gamh_z + parameters.dissipation_factor_Gamh_z * (meshDissipation_i(Gamh_z, un, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_z, un, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_z, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_x > 0.0) {
						RHS_Betau_x = RHS_Betau_x + parameters.dissipation_factor_Betau_x * (meshDissipation_i(Betau_x, un, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_x, un, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_x, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_y > 0.0) {
						RHS_Betau_y = RHS_Betau_y + parameters.dissipation_factor_Betau_y * (meshDissipation_i(Betau_y, un, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_y, un, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_y, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_z > 0.0) {
						RHS_Betau_z = RHS_Betau_z + parameters.dissipation_factor_Betau_z * (meshDissipation_i(Betau_z, un, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_z, un, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_z, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Alpha > 0.0) {
						RHS_Alpha = RHS_Alpha + parameters.dissipation_factor_Alpha * (meshDissipation_i(Alpha, un, i, j, k, dx, dt_lev) + meshDissipation_j(Alpha, un, i, j, k, dx, dt_lev) + meshDissipation_k(Alpha, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_chi > 0.0) {
						RHS_chi = RHS_chi + parameters.dissipation_factor_chi * (meshDissipation_i(chi, un, i, j, k, dx, dt_lev) + meshDissipation_j(chi, un, i, j, k, dx, dt_lev) + meshDissipation_k(chi, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_trK > 0.0) {
						RHS_trK = RHS_trK + parameters.dissipation_factor_trK * (meshDissipation_i(trK, un, i, j, k, dx, dt_lev) + meshDissipation_j(trK, un, i, j, k, dx, dt_lev) + meshDissipation_k(trK, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_theta > 0.0) {
						RHS_theta = RHS_theta + parameters.dissipation_factor_theta * (meshDissipation_i(theta, un, i, j, k, dx, dt_lev) + meshDissipation_j(theta, un, i, j, k, dx, dt_lev) + meshDissipation_k(theta, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_phiR > 0.0) {
						RHS_phiR = RHS_phiR + parameters.dissipation_factor_phiR * (meshDissipation_i(phiR, un, i, j, k, dx, dt_lev) + meshDissipation_j(phiR, un, i, j, k, dx, dt_lev) + meshDissipation_k(phiR, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_pheR > 0.0) {
						RHS_pheR = RHS_pheR + parameters.dissipation_factor_pheR * (meshDissipation_i(pheR, un, i, j, k, dx, dt_lev) + meshDissipation_j(pheR, un, i, j, k, dx, dt_lev) + meshDissipation_k(pheR, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_phiI > 0.0) {
						RHS_phiI = RHS_phiI + parameters.dissipation_factor_phiI * (meshDissipation_i(phiI, un, i, j, k, dx, dt_lev) + meshDissipation_j(phiI, un, i, j, k, dx, dt_lev) + meshDissipation_k(phiI, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_pheI > 0.0) {
						RHS_pheI = RHS_pheI + parameters.dissipation_factor_pheI * (meshDissipation_i(pheI, un, i, j, k, dx, dt_lev) + meshDissipation_j(pheI, un, i, j, k, dx, dt_lev) + meshDissipation_k(pheI, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_piR > 0.0) {
						RHS_piR = RHS_piR + parameters.dissipation_factor_piR * (meshDissipation_i(piR, un, i, j, k, dx, dt_lev) + meshDissipation_j(piR, un, i, j, k, dx, dt_lev) + meshDissipation_k(piR, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_peR > 0.0) {
						RHS_peR = RHS_peR + parameters.dissipation_factor_peR * (meshDissipation_i(peR, un, i, j, k, dx, dt_lev) + meshDissipation_j(peR, un, i, j, k, dx, dt_lev) + meshDissipation_k(peR, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_piI > 0.0) {
						RHS_piI = RHS_piI + parameters.dissipation_factor_piI * (meshDissipation_i(piI, un, i, j, k, dx, dt_lev) + meshDissipation_j(piI, un, i, j, k, dx, dt_lev) + meshDissipation_k(piI, un, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_peI > 0.0) {
						RHS_peI = RHS_peI + parameters.dissipation_factor_peI * (meshDissipation_i(peI, un, i, j, k, dx, dt_lev) + meshDissipation_j(peI, un, i, j, k, dx, dt_lev) + meshDissipation_k(peI, un, i, j, k, dx, dt_lev));
					}
					rk1(i, j, k, gtd_xx) = RK4P1_(RHS_gtd_xx, un(i, j, k, gtd_xx), dx, dt_lev);
					rk1(i, j, k, gtd_xy) = RK4P1_(RHS_gtd_xy, un(i, j, k, gtd_xy), dx, dt_lev);
					rk1(i, j, k, gtd_xz) = RK4P1_(RHS_gtd_xz, un(i, j, k, gtd_xz), dx, dt_lev);
					rk1(i, j, k, gtd_yy) = RK4P1_(RHS_gtd_yy, un(i, j, k, gtd_yy), dx, dt_lev);
					rk1(i, j, k, gtd_yz) = RK4P1_(RHS_gtd_yz, un(i, j, k, gtd_yz), dx, dt_lev);
					rk1(i, j, k, gtd_zz) = RK4P1_(RHS_gtd_zz, un(i, j, k, gtd_zz), dx, dt_lev);
					rk1(i, j, k, Atd_xx) = RK4P1_(RHS_Atd_xx, un(i, j, k, Atd_xx), dx, dt_lev);
					rk1(i, j, k, Atd_xy) = RK4P1_(RHS_Atd_xy, un(i, j, k, Atd_xy), dx, dt_lev);
					rk1(i, j, k, Atd_xz) = RK4P1_(RHS_Atd_xz, un(i, j, k, Atd_xz), dx, dt_lev);
					rk1(i, j, k, Atd_yy) = RK4P1_(RHS_Atd_yy, un(i, j, k, Atd_yy), dx, dt_lev);
					rk1(i, j, k, Atd_yz) = RK4P1_(RHS_Atd_yz, un(i, j, k, Atd_yz), dx, dt_lev);
					rk1(i, j, k, Atd_zz) = RK4P1_(RHS_Atd_zz, un(i, j, k, Atd_zz), dx, dt_lev);
					rk1(i, j, k, Gamh_x) = RK4P1_(RHS_Gamh_x, un(i, j, k, Gamh_x), dx, dt_lev);
					rk1(i, j, k, Gamh_y) = RK4P1_(RHS_Gamh_y, un(i, j, k, Gamh_y), dx, dt_lev);
					rk1(i, j, k, Betau_x) = RK4P1_(RHS_Betau_x, un(i, j, k, Betau_x), dx, dt_lev);
					rk1(i, j, k, Betau_y) = RK4P1_(RHS_Betau_y, un(i, j, k, Betau_y), dx, dt_lev);
					rk1(i, j, k, Betau_z) = RK4P1_(RHS_Betau_z, un(i, j, k, Betau_z), dx, dt_lev);
					rk1(i, j, k, Gamh_z) = RK4P1_(RHS_Gamh_z, un(i, j, k, Gamh_z), dx, dt_lev);
					rk1(i, j, k, Alpha) = RK4P1_(RHS_Alpha, un(i, j, k, Alpha), dx, dt_lev);
					rk1(i, j, k, chi) = RK4P1_(RHS_chi, un(i, j, k, chi), dx, dt_lev);
					rk1(i, j, k, trK) = RK4P1_(RHS_trK, un(i, j, k, trK), dx, dt_lev);
					rk1(i, j, k, theta) = RK4P1_(RHS_theta, un(i, j, k, theta), dx, dt_lev);
					rk1(i, j, k, phiR) = RK4P1_(RHS_phiR, un(i, j, k, phiR), dx, dt_lev);
					rk1(i, j, k, pheR) = RK4P1_(RHS_pheR, un(i, j, k, pheR), dx, dt_lev);
					rk1(i, j, k, phiI) = RK4P1_(RHS_phiI, un(i, j, k, phiI), dx, dt_lev);
					rk1(i, j, k, pheI) = RK4P1_(RHS_pheI, un(i, j, k, pheI), dx, dt_lev);
					rk1(i, j, k, piR) = RK4P1_(RHS_piR, un(i, j, k, piR), dx, dt_lev);
					rk1(i, j, k, peR) = RK4P1_(RHS_peR, un(i, j, k, peR), dx, dt_lev);
					rk1(i, j, k, piI) = RK4P1_(RHS_piI, un(i, j, k, piI), dx, dt_lev);
					rk1(i, j, k, peI) = RK4P1_(RHS_peI, un(i, j, k, peI), dx, dt_lev);
				}
			});
		}
	}
	if (do_subcycle) {
		FillPatch(lev, current_time + dt_lev * 0.5, rk1_mf, unstate_var, rk1state_var, rk2state_var, rk3state_var, unp1state_var, NumFields, RK1STEP, iteration, state_interpolator_change);
	} else {
		FillPatch(lev, current_time + dt_lev * 0.5, rk1_mf, rk1state_var, NumFields, state_interpolator_change);
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> unSyncAuxFieldGroup = unSyncAuxFieldGroup_mf.array(mfi);
			Array4<Real> rk1 = rk1_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			const bool box_touches_lower_x_boundary = bx_lo.x + NUM_GHOST_CELLS == dom_lo.x;
			const bool box_touches_upper_x_boundary = bx_hi.x - NUM_GHOST_CELLS == dom_hi.x + 1;
			const bool box_touches_lower_y_boundary = bx_lo.y + NUM_GHOST_CELLS == dom_lo.y;
			const bool box_touches_upper_y_boundary = bx_hi.y - NUM_GHOST_CELLS == dom_hi.y + 1;
			const bool box_touches_lower_z_boundary = bx_lo.z + NUM_GHOST_CELLS == dom_lo.z;
			const bool box_touches_upper_z_boundary = bx_hi.z - NUM_GHOST_CELLS == dom_hi.z + 1;
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {

				if (((i + 3 <= bx_hi.x || !box_touches_upper_x_boundary) && (i - 3 >= bx_lo.x || !box_touches_lower_x_boundary) && (j + 3 <= bx_hi.y || !box_touches_upper_y_boundary) && (j - 3 >= bx_lo.y || !box_touches_lower_y_boundary) && (k + 3 <= bx_hi.z || !box_touches_upper_z_boundary) && (k - 3 >= bx_lo.z || !box_touches_lower_z_boundary))) {
					unSyncAuxFieldGroup(i, j, k, phi2) = rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI) + rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI);
				}
			});
		}
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> regions = regions_mf.array(mfi);
			Array4<Real> rk1 = rk1_mf.array(mfi);
			Array4<Real> unSyncAuxFieldGroup = unSyncAuxFieldGroup_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {

				if (i < dom_lo.x) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (i > dom_hi.x + 1) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (j < dom_lo.y) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (j > dom_hi.y + 1) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (k < dom_lo.z) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (k > dom_hi.z + 1) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk1, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
			});
		}
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> rk1 = rk1_mf.array(mfi);
			Array4<Real> regions = regions_mf.array(mfi);
			Array4<Real> rk2 = rk2_mf.array(mfi);
			Array4<Real> un = un_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {
				Real d_div_Beta_o0_t0_m0_l0, d_Betau_x_o1_t0_m0_l0, d_Betau_x_o2_t0_m0_l0, d_gtd_xy_o2_t0_m0_l0, d_Betau_x_o1_t1_m0_l0, d_Betau_x_o2_t1_m0_l0, d_gtd_xz_o2_t0_m0_l0, d_Betau_x_o1_t2_m0_l0, d_Betau_x_o2_t2_m0_l0, d_d_div_Beta_x_o0_t0_m0_l0, d_d_div_Beta_y_o0_t0_m0_l0, d_d_div_Beta_z_o0_t0_m0_l0, d_Gamh_x_o2_t6_m0_l0, d_Gamh_x_o2_t7_m0_l0, d_Gamh_x_o2_t8_m0_l0, d_gtd_xx_o2_t1_m0_l0, d_Betau_y_o1_t0_m0_l0, d_Betau_y_o2_t0_m0_l0, d_div_Beta_o0_t1_m0_l0, d_Betau_y_o1_t1_m0_l0, d_Betau_y_o2_t1_m0_l0, d_gtd_xz_o2_t1_m0_l0, d_Betau_y_o1_t2_m0_l0, d_Betau_y_o2_t2_m0_l0, d_Gamh_y_o2_t4_m0_l0, d_d_div_Beta_x_o0_t1_m0_l0, d_Gamh_y_o2_t6_m0_l0, d_d_div_Beta_y_o0_t1_m0_l0, d_d_div_Beta_z_o0_t1_m0_l0, d_Gamh_y_o2_t9_m0_l0, d_gtd_xx_o2_t2_m0_l0, d_Betau_z_o1_t0_m0_l0, d_Betau_z_o2_t0_m0_l0, d_gtd_xy_o2_t2_m0_l0, d_Betau_z_o1_t1_m0_l0, d_Betau_z_o2_t1_m0_l0, d_div_Beta_o0_t2_m0_l0, d_Betau_z_o1_t2_m0_l0, d_Betau_z_o2_t2_m0_l0, d_Gamh_z_o2_t14_m0_l0, d_Gamh_z_o2_t15_m0_l0, d_d_div_Beta_x_o0_t2_m0_l0, d_Gamh_z_o2_t17_m0_l0, d_d_div_Beta_y_o0_t2_m0_l0, d_d_div_Beta_z_o0_t2_m0_l0, d_Ctd_xxx_o0_t0_m0_l0, d_gtd_xx_o0_t0_m0_l0, d_gtd_xx_o1_t0_m0_l0, d_Ctd_xxy_o0_t0_m0_l0, d_gtd_xx_o0_t1_m0_l0, d_gtd_xx_o1_t1_m0_l0, d_Ctd_xxz_o0_t0_m0_l0, d_gtd_xx_o0_t2_m0_l0, d_gtd_xx_o1_t2_m0_l0, d_Ctd_yxx_o0_t0_m0_l0, d_gtd_xy_o0_t0_m0_l0, d_gtd_xy_o1_t0_m0_l0, d_Ctd_xyy_o0_t0_m0_l0, d_gtd_xy_o0_t1_m0_l0, d_gtd_xy_o1_t1_m0_l0, d_Ctd_xyz_o0_t1_m0_l0, d_gtd_xy_o0_t2_m0_l0, d_gtd_xy_o1_t2_m0_l0, d_Ctd_xyy_o0_t1_m0_l0, d_gtd_yy_o0_t0_m0_l0, d_gtd_yy_o1_t0_m0_l0, d_Ctd_yyy_o0_t0_m0_l0, d_gtd_yy_o0_t1_m0_l0, d_gtd_yy_o1_t1_m0_l0, d_Ctd_yyz_o0_t0_m0_l0, d_gtd_yy_o0_t2_m0_l0, d_gtd_yy_o1_t2_m0_l0, d_Ctd_zxx_o0_t0_m0_l0, d_gtd_xz_o0_t0_m0_l0, d_gtd_xz_o1_t0_m0_l0, d_Ctd_xyz_o0_t0_m0_l0, d_gtd_xz_o0_t1_m0_l0, d_gtd_xz_o1_t1_m0_l0, d_Ctd_xzz_o0_t0_m0_l0, d_gtd_xz_o0_t2_m0_l0, d_gtd_xz_o1_t2_m0_l0, d_Ctd_xyz_o0_t2_m0_l0, d_gtd_yz_o0_t0_m0_l0, d_gtd_yz_o1_t0_m0_l0, d_Ctd_zyy_o0_t0_m0_l0, d_gtd_yz_o0_t1_m0_l0, d_gtd_yz_o1_t1_m0_l0, d_Ctd_yzz_o0_t0_m0_l0, d_gtd_yz_o0_t2_m0_l0, d_gtd_yz_o1_t2_m0_l0, d_Ctd_xzz_o0_t1_m0_l0, d_gtd_zz_o0_t0_m0_l0, d_gtd_zz_o1_t0_m0_l0, d_Ctd_yzz_o0_t1_m0_l0, d_gtd_zz_o0_t1_m0_l0, d_gtd_zz_o1_t1_m0_l0, d_Ctd_zzz_o0_t0_m0_l0, d_gtd_zz_o0_t2_m0_l0, d_gtd_zz_o1_t2_m0_l0, d_Rpd_xx_o0_t0_m0_l0, d_chi_o0_t0_m0_l0, d_chi_o1_t0_m0_l0, d_Rpd_xx_o0_t1_m0_l0, d_chi_o0_t1_m0_l0, d_chi_o1_t1_m0_l0, d_Rpd_xx_o0_t2_m0_l0, d_chi_o0_t2_m0_l0, d_chi_o1_t2_m0_l0, d_Rtd_xx_o0_t6_m0_l0, d_Gamh_x_o0_t0_m0_l0, d_Gamh_x_o1_t0_m0_l0, d_Rtd_xy_o0_t6_m0_l0, d_Gamh_x_o0_t1_m0_l0, d_Gamh_x_o1_t1_m0_l0, d_Rtd_xz_o0_t6_m0_l0, d_Gamh_x_o0_t2_m0_l0, d_Gamh_x_o1_t2_m0_l0, d_Rtd_xx_o0_t7_m0_l0, d_Gamh_y_o0_t0_m0_l0, d_Gamh_y_o1_t0_m0_l0, d_Rtd_xy_o0_t7_m0_l0, d_Gamh_y_o0_t1_m0_l0, d_Gamh_y_o1_t1_m0_l0, d_Rtd_xz_o0_t7_m0_l0, d_Gamh_y_o0_t2_m0_l0, d_Gamh_y_o1_t2_m0_l0, d_Rtd_xx_o0_t8_m0_l0, d_Gamh_z_o0_t1_m0_l0, d_Gamh_z_o1_t0_m0_l0, d_Rtd_xy_o0_t8_m0_l0, d_Gamh_z_o0_t2_m0_l0, d_Gamh_z_o1_t1_m0_l0, d_Rtd_xz_o0_t8_m0_l0, d_Gamh_z_o0_t0_m0_l0, d_Gamh_z_o1_t2_m0_l0, d_Psi1_xx_o0_t1_m0_l0, d_Alpha_o0_t0_m0_l0, d_Alpha_o1_t0_m0_l0, d_Psi1_xx_o0_t2_m0_l0, d_Alpha_o0_t1_m0_l0, d_Alpha_o1_t1_m0_l0, d_Psi1_xx_o0_t3_m0_l0, d_Alpha_o0_t2_m0_l0, d_Alpha_o1_t2_m0_l0, d_Psi1_xx_o0_t0_m0_l0, d_Psi1_xy_o0_t0_m0_l0, d_Psi1_xz_o0_t0_m0_l0, d_Psi1_yy_o0_t0_m0_l0, d_Psi1_yz_o0_t0_m0_l0, d_Psi1_zz_o0_t0_m0_l0, d_d_phiR4d_t_o0_t1_m0_l0, d_phiR_o0_t0_m0_l0, d_phiR_o1_t0_m0_l0, d_d_phiR4d_t_o0_t2_m0_l0, d_phiR_o0_t1_m0_l0, d_phiR_o1_t1_m0_l0, d_d_phiR4d_t_o0_t3_m0_l0, d_phiR_o0_t2_m0_l0, d_phiR_o1_t2_m0_l0, d_piR_o2_t26_m0_l0, d_piR_o2_t0_m0_l0, d_piR_o2_t1_m0_l0, d_piR_o2_t2_m0_l0, d_piR_o2_t3_m0_l0, d_piR_o2_t4_m0_l0, d_d_phiI4d_t_o0_t1_m0_l0, d_phiI_o0_t0_m0_l0, d_phiI_o1_t0_m0_l0, d_d_phiI4d_t_o0_t2_m0_l0, d_phiI_o0_t1_m0_l0, d_phiI_o1_t1_m0_l0, d_d_phiI4d_t_o0_t3_m0_l0, d_phiI_o0_t2_m0_l0, d_phiI_o1_t2_m0_l0, d_piI_o2_t24_m0_l0, d_piI_o2_t25_m0_l0, d_piI_o2_t26_m0_l0, d_piI_o2_t0_m0_l0, d_piI_o2_t1_m0_l0, d_piI_o2_t2_m0_l0, d_d_pheR4d_t_o0_t1_m0_l0, d_pheR_o0_t0_m0_l0, d_pheR_o1_t0_m0_l0, d_d_pheR4d_t_o0_t2_m0_l0, d_pheR_o0_t1_m0_l0, d_pheR_o1_t1_m0_l0, d_d_pheR4d_t_o0_t3_m0_l0, d_pheR_o0_t2_m0_l0, d_pheR_o1_t2_m0_l0, d_peR_o2_t24_m0_l0, d_peR_o2_t25_m0_l0, d_peR_o2_t26_m0_l0, d_peR_o2_t0_m0_l0, d_peR_o2_t1_m0_l0, d_peR_o2_t2_m0_l0, d_d_pheI4d_t_o0_t1_m0_l0, d_pheI_o0_t0_m0_l0, d_pheI_o1_t0_m0_l0, d_d_pheI4d_t_o0_t2_m0_l0, d_pheI_o0_t1_m0_l0, d_pheI_o1_t1_m0_l0, d_d_pheI4d_t_o0_t3_m0_l0, d_pheI_o0_t2_m0_l0, d_pheI_o1_t2_m0_l0, d_peI_o2_t22_m0_l0, d_peI_o2_t23_m0_l0, d_peI_o2_t24_m0_l0, d_peI_o2_t25_m0_l0, d_peI_o2_t26_m0_l0, d_peI_o2_t0_m0_l0, d_Atd_xx_o0_t0_m0_l0, d_Atd_xx_o1_t0_m0_l0, d_Atd_xx_o0_t1_m0_l0, d_Atd_xx_o1_t1_m0_l0, d_Atd_xx_o0_t2_m0_l0, d_Atd_xx_o1_t2_m0_l0, d_Atd_xy_o0_t0_m0_l0, d_Atd_xy_o1_t0_m0_l0, d_Atd_xy_o0_t1_m0_l0, d_Atd_xy_o1_t1_m0_l0, d_Atd_xy_o0_t2_m0_l0, d_Atd_xy_o1_t2_m0_l0, d_Atd_xz_o0_t0_m0_l0, d_Atd_xz_o1_t0_m0_l0, d_Atd_xz_o0_t1_m0_l0, d_Atd_xz_o1_t1_m0_l0, d_Atd_xz_o0_t2_m0_l0, d_Atd_xz_o1_t2_m0_l0, d_Atd_yy_o0_t0_m0_l0, d_Atd_yy_o1_t0_m0_l0, d_Atd_yy_o0_t1_m0_l0, d_Atd_yy_o1_t1_m0_l0, d_Atd_yy_o0_t2_m0_l0, d_Atd_yy_o1_t2_m0_l0, d_Atd_yz_o0_t0_m0_l0, d_Atd_yz_o1_t0_m0_l0, d_Atd_yz_o0_t1_m0_l0, d_Atd_yz_o1_t1_m0_l0, d_Atd_yz_o0_t2_m0_l0, d_Atd_yz_o1_t2_m0_l0, d_Atd_zz_o0_t0_m0_l0, d_Atd_zz_o1_t0_m0_l0, d_Atd_zz_o0_t1_m0_l0, d_Atd_zz_o1_t1_m0_l0, d_Atd_zz_o0_t2_m0_l0, d_Atd_zz_o1_t2_m0_l0, d_Gamh_x_o2_t12_m0_l0, d_trK_o0_t0_m0_l0, d_trK_o1_t0_m0_l0, d_Gamh_x_o2_t13_m0_l0, d_trK_o0_t1_m0_l0, d_trK_o1_t1_m0_l0, d_Gamh_x_o2_t14_m0_l0, d_trK_o0_t2_m0_l0, d_trK_o1_t2_m0_l0, d_Gamh_x_o2_t15_m0_l0, d_theta_o0_t0_m0_l0, d_theta_o1_t0_m0_l0, d_Gamh_x_o2_t16_m0_l0, d_theta_o0_t1_m0_l0, d_theta_o1_t1_m0_l0, d_Gamh_x_o2_t17_m0_l0, d_theta_o0_t2_m0_l0, d_theta_o1_t2_m0_l0, d_piR_o0_t0_m0_l0, d_piR_o1_t0_m0_l0, d_piR_o0_t1_m0_l0, d_piR_o1_t1_m0_l0, d_piR_o0_t2_m0_l0, d_piR_o1_t2_m0_l0, d_peR_o0_t0_m0_l0, d_peR_o1_t0_m0_l0, d_peR_o0_t1_m0_l0, d_peR_o1_t1_m0_l0, d_peR_o0_t2_m0_l0, d_peR_o1_t2_m0_l0, d_piI_o0_t0_m0_l0, d_piI_o1_t0_m0_l0, d_piI_o0_t1_m0_l0, d_piI_o1_t1_m0_l0, d_piI_o0_t2_m0_l0, d_piI_o1_t2_m0_l0, d_peI_o0_t0_m0_l0, d_peI_o1_t2_m0_l0, d_peI_o0_t1_m0_l0, d_peI_o1_t0_m0_l0, d_peI_o0_t2_m0_l0, d_peI_o1_t1_m0_l0, d_Rtd_xx_o0_t0_m0_l0, d_Rtd_xx_o0_t1_m0_l0, d_Rtd_xx_o0_t2_m0_l0, d_Rtd_xx_o0_t3_m0_l0, d_Rtd_xx_o0_t4_m0_l0, d_Rtd_xx_o0_t5_m0_l0, d_Rtd_xy_o0_t0_m0_l0, d_Rtd_xy_o0_t1_m0_l0, d_Rtd_xy_o0_t2_m0_l0, d_Rtd_xy_o0_t3_m0_l0, d_Rtd_xy_o0_t4_m0_l0, d_Rtd_xy_o0_t5_m0_l0, d_Rtd_yy_o0_t0_m0_l0, d_Rtd_yy_o0_t1_m0_l0, d_Rtd_yy_o0_t2_m0_l0, d_Rtd_yy_o0_t3_m0_l0, d_Rtd_yy_o0_t4_m0_l0, d_Rtd_yy_o0_t5_m0_l0, d_Rtd_xz_o0_t0_m0_l0, d_Rtd_xz_o0_t1_m0_l0, d_Rtd_xz_o0_t2_m0_l0, d_Rtd_xz_o0_t3_m0_l0, d_Rtd_xz_o0_t4_m0_l0, d_Rtd_xz_o0_t5_m0_l0, d_Rtd_yz_o0_t0_m0_l0, d_Rtd_yz_o0_t1_m0_l0, d_Rtd_yz_o0_t2_m0_l0, d_Rtd_yz_o0_t3_m0_l0, d_Rtd_yz_o0_t4_m0_l0, d_Rtd_yz_o0_t5_m0_l0, d_Rtd_zz_o0_t0_m0_l0, d_Rtd_zz_o0_t1_m0_l0, d_Rtd_zz_o0_t2_m0_l0, d_Rtd_zz_o0_t3_m0_l0, d_Rtd_zz_o0_t4_m0_l0, d_Rtd_zz_o0_t5_m0_l0, d_Rpd_xx_o0_t3_m0_l0, d_Rpd_xx_o0_t4_m0_l0, d_Rpd_xx_o0_t5_m0_l0, d_Rpd_xx_o0_t6_m0_l0, d_Rpd_xx_o0_t7_m0_l0, d_Rpd_xx_o0_t8_m0_l0, rk1m_Ctd_yyz_o0_t0_l0, rk1Ctd_yyz, rk1m_Ctd_yyy_o0_t0_l0, rk1Ctd_yyy, rk1div_Beta, rk1m_Ctd_xxz_o0_t0_l0, rk1Ctd_xxz, rk1m_Ctd_xxx_o0_t0_l0, rk1Ctd_xxx, rk1m_Ctd_yzz_o0_t1_l0, rk1m_Ctd_yzz_o0_t0_l0, rk1Ctd_yzz, rk1m_Ctd_xxy_o0_t0_l0, rk1Ctd_xxy, rk1sfmass, rk1dVdphe2, rk1kappa_z2, rk1m_Ctd_xyy_o0_t1_l0, rk1m_Ctd_xyy_o0_t0_l0, rk1Ctd_xyy, rk1m_Ctd_xyz_o0_t2_l0, rk1m_Ctd_xyz_o0_t1_l0, rk1m_Ctd_xyz_o0_t0_l0, rk1Ctd_xyz, rk1d_div_Beta_y, rk1d_div_Beta_x, rk1d_div_Beta_z, rk1m_Ctd_xzz_o0_t1_l0, rk1m_Ctd_xzz_o0_t0_l0, rk1Ctd_xzz, rk1dVdphi2, rk1d_d_phiI4d_t_o0_t0_m0_l0, rk1m_d_phiI4d_t_o0_t6_l0, rk1m_d_phiI4d_t_o0_t5_l0, rk1m_d_phiI4d_t_o0_t4_l0, rk1m_d_phiI4d_t_o0_t3_l0, rk1m_d_phiI4d_t_o0_t2_l0, rk1m_d_phiI4d_t_o0_t1_l0, rk1d_phiI4d_t, rk1d_phiI4d_x, rk1d_phiI4d_y, rk1d_phiI4d_z, rk1g4u_tx, rk1g4u_tz, rk1g4u_ty, rk1g4u_tt, rk1d_phiI4u_t, rk1sfVe, rk1sfVi, rk1m_Ctd_zxz_o0_t0_l0, rk1Ctd_zxz, rk1m_Ctd_zxx_o0_t1_l0, rk1m_Ctd_zxx_o0_t0_l0, rk1Ctd_zxx, rk1detgtd, rk1d_d_phiR4d_t_o0_t0_m0_l0, rk1m_d_phiR4d_t_o0_t6_l0, rk1m_d_phiR4d_t_o0_t5_l0, rk1m_d_phiR4d_t_o0_t4_l0, rk1m_d_phiR4d_t_o0_t3_l0, rk1m_d_phiR4d_t_o0_t2_l0, rk1m_d_phiR4d_t_o0_t1_l0, rk1d_phiR4d_t, rk1d_phiR4d_x, rk1d_phiR4d_z, rk1d_phiR4d_y, rk1d_phiR4u_t, rk1chi_max, rk1inv_chi, rk1d_d_pheR4d_t_o0_t0_m0_l0, rk1m_d_pheR4d_t_o0_t6_l0, rk1m_d_pheR4d_t_o0_t5_l0, rk1m_d_pheR4d_t_o0_t4_l0, rk1m_d_pheR4d_t_o0_t3_l0, rk1m_d_pheR4d_t_o0_t2_l0, rk1m_d_pheR4d_t_o0_t1_l0, rk1d_pheR4d_t, rk1d_pheR4d_x, rk1d_pheR4d_y, rk1d_pheR4d_z, rk1d_pheR4u_t, rk1m_Ctd_zyy_o0_t1_l0, rk1m_Ctd_zyy_o0_t0_l0, rk1Ctd_zyy, rk1m_Ctd_zyz_o0_t0_l0, rk1Ctd_zyz, rk1Betatd_x, rk1Betatd_z, rk1Betatd_y, rk1idetgtd, rk1gtu_zz, rk1g4u_zz, rk1gtu_yy, rk1g4u_yy, rk1gtu_yz, rk1g4u_yz, rk1gtu_xx, rk1g4u_xx, rk1gtu_xz, rk1g4u_xz, rk1d_pheR4u_z, rk1d_phiR4u_z, rk1d_phiI4u_z, rk1Ct_zyz, rk1Ct_zyy, rk1Atud_zx, rk1Atud_zz, rk1Atud_zy, rk1Atu_zz, rk1gtu_xy, rk1g4u_xy, rk1d_pheR4u_x, rk1d_pheR4u_y, rk1d_phiR4u_y, rk1d_phiR4u_x, rk1d_phiI4u_y, rk1d_phiI4u_x, rk1dphi4sq, rk1Atud_yy, rk1Atud_yx, rk1Atud_yz, rk1Atu_yz, rk1Atu_yy, rk1Ct_yyy, rk1Ct_yyz, rk1Atud_xx, rk1trAt, rk1Atud_xz, rk1Atud_xy, rk1Atu_xz, rk1Atu_xy, rk1Atu_xx, rk1decay_factor, rk1kappa_z1, rk1feta, rk1m_Ctd_zzz_o0_t0_l0, rk1Ctd_zzz, rk1Ct_xzz, rk1Ct_zzz, rk1Ct_yzz, rk1m_Ctd_yxy_o0_t0_l0, rk1Ctd_yxy, rk1Ct_xyz, rk1m_Ctd_yxz_o0_t2_l0, rk1m_Ctd_yxz_o0_t0_l0, rk1Ctd_yxz, rk1Ct_zxz, rk1Ct_yxz, rk1m_Ctd_zxy_o0_t2_l0, rk1Ctd_zxy, rk1Ct_zxy, rk1Ct_yxy, rk1Ct_xxy, rk1Ct_xxz, rk1Ct_xyy, rk1m_Ctd_yxx_o0_t1_l0, rk1m_Ctd_yxx_o0_t0_l0, rk1Ctd_yxx, rk1Ct_zxx, rk1Gamt_z, rk1Zu_z, rk1Ct_yxx, rk1Gamt_y, rk1Zu_y, rk1Ct_xxx, rk1Gamt_x, rk1Zu_x, rk1d_Rtd_xx_o0_t9_m0_l0, rk1m_Rtd_xx_o0_t8_l0, rk1m_Rtd_xx_o0_t7_l0, rk1m_Rtd_xx_o0_t6_l0, rk1m_Rtd_xx_o0_t5_l0, rk1m_Rtd_xx_o0_t4_l0, rk1m_Rtd_xx_o0_t3_l0, rk1m_Rtd_xx_o0_t2_l0, rk1m_Rtd_xx_o0_t1_l0, rk1m_Rtd_xx_o0_t0_l0, rk1Rtd_xx, rk1d_Rtd_xz_o0_t12_m0_l0, rk1m_Rtd_xz_o0_t11_l0, rk1m_Rtd_xz_o0_t10_l0, rk1m_Rtd_xz_o0_t9_l0, rk1m_Rtd_xz_o0_t8_l0, rk1m_Rtd_xz_o0_t7_l0, rk1m_Rtd_xz_o0_t6_l0, rk1m_Rtd_xz_o0_t5_l0, rk1m_Rtd_xz_o0_t4_l0, rk1m_Rtd_xz_o0_t3_l0, rk1m_Rtd_xz_o0_t2_l0, rk1m_Rtd_xz_o0_t1_l0, rk1m_Rtd_xz_o0_t0_l0, rk1Rtd_xz, rk1d_Rtd_zz_o0_t9_m0_l0, rk1m_Rtd_zz_o0_t8_l0, rk1m_Rtd_zz_o0_t7_l0, rk1m_Rtd_zz_o0_t6_l0, rk1m_Rtd_zz_o0_t5_l0, rk1m_Rtd_zz_o0_t4_l0, rk1m_Rtd_zz_o0_t3_l0, rk1m_Rtd_zz_o0_t2_l0, rk1m_Rtd_zz_o0_t1_l0, rk1m_Rtd_zz_o0_t0_l0, rk1Rtd_zz, rk1d_Rtd_xy_o0_t12_m0_l0, rk1m_Rtd_xy_o0_t11_l0, rk1m_Rtd_xy_o0_t10_l0, rk1m_Rtd_xy_o0_t9_l0, rk1m_Rtd_xy_o0_t8_l0, rk1m_Rtd_xy_o0_t7_l0, rk1m_Rtd_xy_o0_t6_l0, rk1m_Rtd_xy_o0_t5_l0, rk1m_Rtd_xy_o0_t4_l0, rk1m_Rtd_xy_o0_t3_l0, rk1m_Rtd_xy_o0_t2_l0, rk1m_Rtd_xy_o0_t1_l0, rk1m_Rtd_xy_o0_t0_l0, rk1Rtd_xy, rk1d_Rtd_yy_o0_t9_m0_l0, rk1m_Rtd_yy_o0_t8_l0, rk1m_Rtd_yy_o0_t7_l0, rk1m_Rtd_yy_o0_t6_l0, rk1m_Rtd_yy_o0_t5_l0, rk1m_Rtd_yy_o0_t4_l0, rk1m_Rtd_yy_o0_t3_l0, rk1m_Rtd_yy_o0_t2_l0, rk1m_Rtd_yy_o0_t1_l0, rk1m_Rtd_yy_o0_t0_l0, rk1Rtd_yy, rk1d_Rtd_yz_o0_t12_m0_l0, rk1m_Rtd_yz_o0_t11_l0, rk1m_Rtd_yz_o0_t10_l0, rk1m_Rtd_yz_o0_t9_l0, rk1m_Rtd_yz_o0_t8_l0, rk1m_Rtd_yz_o0_t7_l0, rk1m_Rtd_yz_o0_t6_l0, rk1m_Rtd_yz_o0_t5_l0, rk1m_Rtd_yz_o0_t4_l0, rk1m_Rtd_yz_o0_t3_l0, rk1m_Rtd_yz_o0_t2_l0, rk1m_Rtd_yz_o0_t1_l0, rk1m_Rtd_yz_o0_t0_l0, rk1Rtd_yz, rk1m_Rpd_xx_o0_t22_l0, rk1m_Rpd_xx_o0_t21_l0, rk1m_Rpd_xx_o0_t20_l0, rk1m_Rpd_xx_o0_t19_l0, rk1m_Rpd_xx_o0_t18_l0, rk1m_Rpd_xx_o0_t17_l0, rk1m_Rpd_xx_o0_t16_l0, rk1m_Rpd_xx_o0_t15_l0, rk1m_Rpd_xx_o0_t14_l0, rk1m_Rpd_xx_o0_t13_l0, rk1m_Rpd_xx_o0_t12_l0, rk1m_Rpd_xx_o0_t11_l0, rk1m_Rpd_xx_o0_t10_l0, rk1m_Rpd_xx_o0_t9_l0, rk1m_Rpd_xx_o0_t8_l0, rk1m_Rpd_xx_o0_t7_l0, rk1m_Rpd_xx_o0_t6_l0, rk1m_Rpd_xx_o0_t5_l0, rk1m_Rpd_xx_o0_t4_l0, rk1m_Rpd_xx_o0_t3_l0, rk1m_Rpd_xx_o0_t2_l0, rk1m_Rpd_xx_o0_t1_l0, rk1m_Rpd_xx_o0_t0_l0, rk1Rpd_xx, rk1m_Rpd_yy_o0_t22_l0, rk1m_Rpd_yy_o0_t21_l0, rk1m_Rpd_yy_o0_t20_l0, rk1m_Rpd_yy_o0_t19_l0, rk1m_Rpd_yy_o0_t18_l0, rk1m_Rpd_yy_o0_t17_l0, rk1m_Rpd_yy_o0_t16_l0, rk1m_Rpd_yy_o0_t15_l0, rk1m_Rpd_yy_o0_t14_l0, rk1m_Rpd_yy_o0_t13_l0, rk1m_Rpd_yy_o0_t12_l0, rk1m_Rpd_yy_o0_t11_l0, rk1m_Rpd_yy_o0_t10_l0, rk1m_Rpd_yy_o0_t9_l0, rk1m_Rpd_yy_o0_t8_l0, rk1m_Rpd_yy_o0_t7_l0, rk1m_Rpd_yy_o0_t6_l0, rk1m_Rpd_yy_o0_t5_l0, rk1m_Rpd_yy_o0_t4_l0, rk1m_Rpd_yy_o0_t3_l0, rk1m_Rpd_yy_o0_t2_l0, rk1m_Rpd_yy_o0_t1_l0, rk1m_Rpd_yy_o0_t0_l0, rk1Rpd_yy, rk1m_Rpd_yz_o0_t25_l0, rk1m_Rpd_yz_o0_t24_l0, rk1m_Rpd_yz_o0_t23_l0, rk1m_Rpd_yz_o0_t22_l0, rk1m_Rpd_yz_o0_t21_l0, rk1m_Rpd_yz_o0_t20_l0, rk1m_Rpd_yz_o0_t19_l0, rk1m_Rpd_yz_o0_t18_l0, rk1m_Rpd_yz_o0_t17_l0, rk1m_Rpd_yz_o0_t16_l0, rk1m_Rpd_yz_o0_t15_l0, rk1m_Rpd_yz_o0_t14_l0, rk1m_Rpd_yz_o0_t13_l0, rk1m_Rpd_yz_o0_t12_l0, rk1m_Rpd_yz_o0_t11_l0, rk1m_Rpd_yz_o0_t10_l0, rk1m_Rpd_yz_o0_t9_l0, rk1m_Rpd_yz_o0_t8_l0, rk1m_Rpd_yz_o0_t7_l0, rk1m_Rpd_yz_o0_t6_l0, rk1m_Rpd_yz_o0_t5_l0, rk1m_Rpd_yz_o0_t4_l0, rk1m_Rpd_yz_o0_t3_l0, rk1m_Rpd_yz_o0_t2_l0, rk1m_Rpd_yz_o0_t1_l0, rk1m_Rpd_yz_o0_t0_l0, rk1Rpd_yz, rk1m_Rpd_xz_o0_t25_l0, rk1m_Rpd_xz_o0_t24_l0, rk1m_Rpd_xz_o0_t23_l0, rk1m_Rpd_xz_o0_t22_l0, rk1m_Rpd_xz_o0_t21_l0, rk1m_Rpd_xz_o0_t20_l0, rk1m_Rpd_xz_o0_t19_l0, rk1m_Rpd_xz_o0_t18_l0, rk1m_Rpd_xz_o0_t17_l0, rk1m_Rpd_xz_o0_t16_l0, rk1m_Rpd_xz_o0_t15_l0, rk1m_Rpd_xz_o0_t14_l0, rk1m_Rpd_xz_o0_t13_l0, rk1m_Rpd_xz_o0_t12_l0, rk1m_Rpd_xz_o0_t11_l0, rk1m_Rpd_xz_o0_t10_l0, rk1m_Rpd_xz_o0_t9_l0, rk1m_Rpd_xz_o0_t8_l0, rk1m_Rpd_xz_o0_t7_l0, rk1m_Rpd_xz_o0_t6_l0, rk1m_Rpd_xz_o0_t5_l0, rk1m_Rpd_xz_o0_t4_l0, rk1m_Rpd_xz_o0_t3_l0, rk1m_Rpd_xz_o0_t2_l0, rk1m_Rpd_xz_o0_t1_l0, rk1m_Rpd_xz_o0_t0_l0, rk1Rpd_xz, rk1m_Rpd_xy_o0_t25_l0, rk1m_Rpd_xy_o0_t24_l0, rk1m_Rpd_xy_o0_t23_l0, rk1m_Rpd_xy_o0_t22_l0, rk1m_Rpd_xy_o0_t21_l0, rk1m_Rpd_xy_o0_t20_l0, rk1m_Rpd_xy_o0_t19_l0, rk1m_Rpd_xy_o0_t18_l0, rk1m_Rpd_xy_o0_t17_l0, rk1m_Rpd_xy_o0_t16_l0, rk1m_Rpd_xy_o0_t15_l0, rk1m_Rpd_xy_o0_t14_l0, rk1m_Rpd_xy_o0_t13_l0, rk1m_Rpd_xy_o0_t12_l0, rk1m_Rpd_xy_o0_t11_l0, rk1m_Rpd_xy_o0_t10_l0, rk1m_Rpd_xy_o0_t9_l0, rk1m_Rpd_xy_o0_t8_l0, rk1m_Rpd_xy_o0_t7_l0, rk1m_Rpd_xy_o0_t6_l0, rk1m_Rpd_xy_o0_t5_l0, rk1m_Rpd_xy_o0_t4_l0, rk1m_Rpd_xy_o0_t3_l0, rk1m_Rpd_xy_o0_t2_l0, rk1m_Rpd_xy_o0_t1_l0, rk1m_Rpd_xy_o0_t0_l0, rk1Rpd_xy, rk1m_Rpd_zz_o0_t22_l0, rk1m_Rpd_zz_o0_t21_l0, rk1m_Rpd_zz_o0_t20_l0, rk1m_Rpd_zz_o0_t19_l0, rk1m_Rpd_zz_o0_t18_l0, rk1m_Rpd_zz_o0_t17_l0, rk1m_Rpd_zz_o0_t16_l0, rk1m_Rpd_zz_o0_t15_l0, rk1m_Rpd_zz_o0_t14_l0, rk1m_Rpd_zz_o0_t13_l0, rk1m_Rpd_zz_o0_t12_l0, rk1m_Rpd_zz_o0_t11_l0, rk1m_Rpd_zz_o0_t10_l0, rk1m_Rpd_zz_o0_t9_l0, rk1m_Rpd_zz_o0_t8_l0, rk1m_Rpd_zz_o0_t7_l0, rk1m_Rpd_zz_o0_t6_l0, rk1m_Rpd_zz_o0_t5_l0, rk1m_Rpd_zz_o0_t4_l0, rk1m_Rpd_zz_o0_t3_l0, rk1m_Rpd_zz_o0_t2_l0, rk1m_Rpd_zz_o0_t1_l0, rk1m_Rpd_zz_o0_t0_l0, rk1Rpd_zz, rk1Rscalar, rk1d_d_pheI4d_t_o0_t0_m0_l0, rk1m_d_pheI4d_t_o0_t6_l0, rk1m_d_pheI4d_t_o0_t5_l0, rk1m_d_pheI4d_t_o0_t4_l0, rk1m_d_pheI4d_t_o0_t3_l0, rk1m_d_pheI4d_t_o0_t2_l0, rk1m_d_pheI4d_t_o0_t1_l0, rk1d_pheI4d_t, rk1d_pheI4d_z, rk1d_pheI4d_y, rk1d_pheI4d_x, rk1d_pheI4u_t, rk1d_pheI4u_z, rk1d_pheI4u_y, rk1d_pheI4u_x, rk1dphe4sq, rk1Tsfu_zz, rk1Tu_zz, rk1Tsfu_yz, rk1Tu_yz, rk1Tsfu_yy, rk1Tu_yy, rk1Tsfu_xz, rk1Tu_xz, rk1Tsfu_xy, rk1Tu_xy, rk1Tsfu_xx, rk1Tu_xx, rk1Tsfu_tt, rk1Tu_tt, rk1Tsfu_tz, rk1Tu_tz, rk1Tsfu_ty, rk1Tu_ty, rk1Tsfu_tx, rk1Tu_tx, rk1pTtd_ADM_xz, rk1pTtd_ADM_xy, rk1pTtd_ADM_xx, rk1d_Psi1_xx_o0_t5_m0_l0, rk1m_Psi1_xx_o0_t4_l0, rk1m_Psi1_xx_o0_t3_l0, rk1m_Psi1_xx_o0_t2_l0, rk1m_Psi1_xx_o0_t1_l0, rk1m_Psi1_xx_o0_t0_l0, rk1Psi1_xx, rk1d_Psi1_xy_o0_t6_m0_l0, rk1m_Psi1_xy_o0_t5_l0, rk1m_Psi1_xy_o0_t4_l0, rk1m_Psi1_xy_o0_t3_l0, rk1m_Psi1_xy_o0_t2_l0, rk1m_Psi1_xy_o0_t1_l0, rk1m_Psi1_xy_o0_t0_l0, rk1Psi1_xy, rk1d_Psi1_xz_o0_t6_m0_l0, rk1m_Psi1_xz_o0_t5_l0, rk1m_Psi1_xz_o0_t4_l0, rk1m_Psi1_xz_o0_t3_l0, rk1m_Psi1_xz_o0_t2_l0, rk1m_Psi1_xz_o0_t1_l0, rk1m_Psi1_xz_o0_t0_l0, rk1Psi1_xz, rk1Jtd_ADM_z, rk1pTtd_ADM_zz, rk1d_Psi1_zz_o0_t5_m0_l0, rk1m_Psi1_zz_o0_t4_l0, rk1m_Psi1_zz_o0_t3_l0, rk1m_Psi1_zz_o0_t2_l0, rk1m_Psi1_zz_o0_t1_l0, rk1m_Psi1_zz_o0_t0_l0, rk1Psi1_zz, rk1Jtd_ADM_y, rk1Jtd_ADM_x, rk1pTtd_ADM_yz, rk1d_Psi1_yz_o0_t6_m0_l0, rk1m_Psi1_yz_o0_t5_l0, rk1m_Psi1_yz_o0_t4_l0, rk1m_Psi1_yz_o0_t3_l0, rk1m_Psi1_yz_o0_t2_l0, rk1m_Psi1_yz_o0_t1_l0, rk1m_Psi1_yz_o0_t0_l0, rk1Psi1_yz, rk1pTtd_ADM_yy, rk1tr_pT, rk1d_Psi1_yy_o0_t5_m0_l0, rk1m_Psi1_yy_o0_t4_l0, rk1m_Psi1_yy_o0_t3_l0, rk1m_Psi1_yy_o0_t2_l0, rk1m_Psi1_yy_o0_t1_l0, rk1m_Psi1_yy_o0_t0_l0, rk1Psi1_yy, rk1trPsi1, rk1Psi1TF_yz, rk1Psi1TF_yy, rk1Psi1TF_xy, rk1Psi1TF_xx, rk1Psi1TF_xz, rk1Psi1TF_zz, rk1kappa_cc, rk1rho_ADM, d_gtd_xx_o2_t3_m0_l0, d_gtd_xy_o2_t6_m0_l0, d_gtd_xz_o2_t6_m0_l0, d_gtd_yy_o2_t3_m0_l0, d_gtd_yz_o2_t6_m0_l0, d_gtd_zz_o2_t3_m0_l0, d_Atd_xx_o2_t3_m0_l0, d_Atd_xy_o2_t6_m0_l0, d_Atd_xz_o2_t6_m0_l0, d_Atd_yy_o2_t3_m0_l0, d_Atd_yz_o2_t6_m0_l0, d_Atd_zz_o2_t3_m0_l0, d_Gamh_x_o2_t24_m0_l0, d_Gamh_y_o2_t24_m0_l0, d_Betau_x_o0_t0_m0_l0, d_Betau_y_o0_t0_m0_l0, d_Betau_z_o0_t0_m0_l0, d_Gamh_z_o2_t24_m0_l0, d_Alpha_o2_t0_m0_l0, d_chi_o2_t0_m0_l0, d_trK_o2_t21_m0_l0, d_theta_o2_t3_m0_l0, d_piR_o2_t27_m0_l0, d_peR_o2_t27_m0_l0, d_piI_o2_t27_m0_l0, d_peI_o2_t27_m0_l0, m_peI_o2_t26_l0, m_peI_o2_t25_l0, m_peI_o2_t24_l0, m_peI_o2_t23_l0, m_peI_o2_t22_l0, m_peI_o2_t21_l0, m_peI_o2_t20_l0, m_peI_o2_t19_l0, m_peI_o2_t18_l0, m_peI_o2_t17_l0, m_peI_o2_t16_l0, m_peI_o2_t15_l0, m_peI_o2_t14_l0, m_peI_o2_t13_l0, m_peI_o2_t12_l0, m_peI_o2_t11_l0, m_peI_o2_t10_l0, m_peI_o2_t9_l0, m_peI_o2_t8_l0, m_peI_o2_t7_l0, m_peI_o2_t6_l0, m_peI_o2_t5_l0, m_peI_o2_t4_l0, m_peI_o2_t3_l0, m_peI_o2_t2_l0, m_peI_o2_t1_l0, m_peI_o2_t0_l0, m_peI_o1_t2_l0, m_peI_o1_t1_l0, m_peI_o1_t0_l0, m_peI_o0_t2_l0, m_peI_o0_t1_l0, m_peI_o0_t0_l0, m_piI_o2_t26_l0, m_piI_o2_t25_l0, m_piI_o2_t24_l0, m_piI_o2_t23_l0, m_piI_o2_t22_l0, m_piI_o2_t21_l0, m_piI_o2_t20_l0, m_piI_o2_t19_l0, m_piI_o2_t18_l0, m_piI_o2_t17_l0, m_piI_o2_t16_l0, m_piI_o2_t15_l0, m_piI_o2_t14_l0, m_piI_o2_t13_l0, m_piI_o2_t12_l0, m_piI_o2_t11_l0, m_piI_o2_t10_l0, m_piI_o2_t9_l0, m_piI_o2_t8_l0, m_piI_o2_t7_l0, m_piI_o2_t6_l0, m_piI_o2_t5_l0, m_piI_o2_t4_l0, m_piI_o2_t3_l0, m_piI_o2_t2_l0, m_piI_o2_t1_l0, m_piI_o2_t0_l0, m_piI_o1_t2_l0, m_piI_o1_t1_l0, m_piI_o1_t0_l0, m_piI_o0_t2_l0, m_piI_o0_t1_l0, m_piI_o0_t0_l0, m_peR_o2_t26_l0, m_peR_o2_t25_l0, m_peR_o2_t24_l0, m_peR_o2_t23_l0, m_peR_o2_t22_l0, m_peR_o2_t21_l0, m_peR_o2_t20_l0, m_peR_o2_t19_l0, m_peR_o2_t18_l0, m_peR_o2_t17_l0, m_peR_o2_t16_l0, m_peR_o2_t15_l0, m_peR_o2_t14_l0, m_peR_o2_t13_l0, m_peR_o2_t12_l0, m_peR_o2_t11_l0, m_peR_o2_t10_l0, m_peR_o2_t9_l0, m_peR_o2_t8_l0, m_peR_o2_t7_l0, m_peR_o2_t6_l0, m_peR_o2_t5_l0, m_peR_o2_t4_l0, m_peR_o2_t3_l0, m_peR_o2_t2_l0, m_peR_o2_t1_l0, m_peR_o2_t0_l0, m_peR_o1_t2_l0, m_peR_o1_t1_l0, m_peR_o1_t0_l0, m_peR_o0_t2_l0, m_peR_o0_t1_l0, m_peR_o0_t0_l0, m_piR_o2_t26_l0, m_piR_o2_t25_l0, m_piR_o2_t24_l0, m_piR_o2_t23_l0, m_piR_o2_t22_l0, m_piR_o2_t21_l0, m_piR_o2_t20_l0, m_piR_o2_t19_l0, m_piR_o2_t18_l0, m_piR_o2_t17_l0, m_piR_o2_t16_l0, m_piR_o2_t15_l0, m_piR_o2_t14_l0, m_piR_o2_t13_l0, m_piR_o2_t12_l0, m_piR_o2_t11_l0, m_piR_o2_t10_l0, m_piR_o2_t9_l0, m_piR_o2_t8_l0, m_piR_o2_t7_l0, m_piR_o2_t6_l0, m_piR_o2_t5_l0, m_piR_o2_t4_l0, m_piR_o2_t3_l0, m_piR_o2_t2_l0, m_piR_o2_t1_l0, m_piR_o2_t0_l0, m_piR_o1_t2_l0, m_piR_o1_t1_l0, m_piR_o1_t0_l0, m_piR_o0_t2_l0, m_piR_o0_t1_l0, m_piR_o0_t0_l0, m_pheI_o1_t2_l0, m_pheI_o1_t1_l0, m_pheI_o1_t0_l0, m_pheI_o0_t2_l0, m_pheI_o0_t1_l0, m_pheI_o0_t0_l0, m_phiI_o1_t2_l0, m_phiI_o1_t1_l0, m_phiI_o1_t0_l0, m_phiI_o0_t2_l0, m_phiI_o0_t1_l0, m_phiI_o0_t0_l0, m_pheR_o1_t2_l0, m_pheR_o1_t1_l0, m_pheR_o1_t0_l0, m_pheR_o0_t2_l0, m_pheR_o0_t1_l0, m_pheR_o0_t0_l0, m_phiR_o1_t2_l0, m_phiR_o1_t1_l0, m_phiR_o1_t0_l0, m_phiR_o0_t2_l0, m_phiR_o0_t1_l0, m_phiR_o0_t0_l0, m_theta_o2_t2_l0, m_theta_o2_t1_l0, m_theta_o2_t0_l0, m_theta_o1_t2_l0, m_theta_o1_t1_l0, m_theta_o1_t0_l0, m_theta_o0_t2_l0, m_theta_o0_t1_l0, m_theta_o0_t0_l0, m_trK_o2_t20_l0, m_trK_o2_t19_l0, m_trK_o2_t18_l0, m_trK_o2_t17_l0, m_trK_o2_t16_l0, m_trK_o2_t15_l0, m_trK_o2_t14_l0, m_trK_o2_t13_l0, m_trK_o2_t12_l0, m_trK_o2_t11_l0, m_trK_o2_t10_l0, m_trK_o2_t9_l0, m_trK_o2_t8_l0, m_trK_o2_t7_l0, m_trK_o2_t6_l0, m_trK_o2_t5_l0, m_trK_o2_t4_l0, m_trK_o2_t3_l0, m_trK_o2_t2_l0, m_trK_o2_t1_l0, m_trK_o2_t0_l0, m_trK_o1_t2_l0, m_trK_o1_t1_l0, m_trK_o1_t0_l0, m_trK_o0_t2_l0, m_trK_o0_t1_l0, m_trK_o0_t0_l0, m_chi_o1_t2_l0, m_chi_o1_t1_l0, m_chi_o1_t0_l0, m_chi_o0_t2_l0, m_chi_o0_t1_l0, m_chi_o0_t0_l0, m_Alpha_o1_t2_l0, m_Alpha_o1_t1_l0, m_Alpha_o1_t0_l0, m_Alpha_o0_t2_l0, m_Alpha_o0_t1_l0, m_Alpha_o0_t0_l0, m_Gamh_z_o2_t23_l0, m_Gamh_z_o2_t22_l0, m_Gamh_z_o2_t21_l0, m_Gamh_z_o2_t20_l0, m_Gamh_z_o2_t19_l0, m_Gamh_z_o2_t18_l0, m_Gamh_z_o2_t17_l0, m_Gamh_z_o2_t16_l0, m_Gamh_z_o2_t15_l0, m_Gamh_z_o2_t14_l0, m_Gamh_z_o2_t13_l0, m_Gamh_z_o2_t12_l0, m_Gamh_z_o2_t11_l0, m_Gamh_z_o2_t10_l0, m_Gamh_z_o2_t9_l0, m_Gamh_z_o2_t8_l0, m_Gamh_z_o2_t7_l0, m_Gamh_z_o2_t6_l0, m_Gamh_z_o2_t5_l0, m_Gamh_z_o2_t4_l0, m_Gamh_z_o2_t3_l0, m_Gamh_z_o2_t2_l0, m_Gamh_z_o2_t1_l0, m_Gamh_z_o2_t0_l0, m_Gamh_z_o1_t2_l0, m_Gamh_z_o1_t1_l0, m_Gamh_z_o1_t0_l0, m_Gamh_z_o0_t2_l0, m_Gamh_z_o0_t1_l0, m_Gamh_z_o0_t0_l0, m_Betau_z_o2_t2_l0, m_Betau_z_o2_t1_l0, m_Betau_z_o2_t0_l0, m_Betau_z_o1_t2_l0, m_Betau_z_o1_t1_l0, m_Betau_z_o1_t0_l0, m_Betau_y_o2_t2_l0, m_Betau_y_o2_t1_l0, m_Betau_y_o2_t0_l0, m_Betau_y_o1_t2_l0, m_Betau_y_o1_t1_l0, m_Betau_y_o1_t0_l0, m_Betau_x_o2_t2_l0, m_Betau_x_o2_t1_l0, m_Betau_x_o2_t0_l0, m_Betau_x_o1_t2_l0, m_Betau_x_o1_t1_l0, m_Betau_x_o1_t0_l0, m_Gamh_y_o2_t23_l0, m_Gamh_y_o2_t22_l0, m_Gamh_y_o2_t21_l0, m_Gamh_y_o2_t20_l0, m_Gamh_y_o2_t19_l0, m_Gamh_y_o2_t18_l0, m_Gamh_y_o2_t17_l0, m_Gamh_y_o2_t16_l0, m_Gamh_y_o2_t15_l0, m_Gamh_y_o2_t14_l0, m_Gamh_y_o2_t13_l0, m_Gamh_y_o2_t12_l0, m_Gamh_y_o2_t11_l0, m_Gamh_y_o2_t10_l0, m_Gamh_y_o2_t9_l0, m_Gamh_y_o2_t8_l0, m_Gamh_y_o2_t7_l0, m_Gamh_y_o2_t6_l0, m_Gamh_y_o2_t5_l0, m_Gamh_y_o2_t4_l0, m_Gamh_y_o2_t3_l0, m_Gamh_y_o2_t2_l0, m_Gamh_y_o2_t1_l0, m_Gamh_y_o2_t0_l0, m_Gamh_y_o1_t2_l0, m_Gamh_y_o1_t1_l0, m_Gamh_y_o1_t0_l0, m_Gamh_y_o0_t2_l0, m_Gamh_y_o0_t1_l0, m_Gamh_y_o0_t0_l0, m_Gamh_x_o2_t23_l0, m_Gamh_x_o2_t22_l0, m_Gamh_x_o2_t21_l0, m_Gamh_x_o2_t20_l0, m_Gamh_x_o2_t19_l0, m_Gamh_x_o2_t18_l0, m_Gamh_x_o2_t17_l0, m_Gamh_x_o2_t16_l0, m_Gamh_x_o2_t15_l0, m_Gamh_x_o2_t14_l0, m_Gamh_x_o2_t13_l0, m_Gamh_x_o2_t12_l0, m_Gamh_x_o2_t11_l0, m_Gamh_x_o2_t10_l0, m_Gamh_x_o2_t9_l0, m_Gamh_x_o2_t8_l0, m_Gamh_x_o2_t7_l0, m_Gamh_x_o2_t6_l0, m_Gamh_x_o2_t5_l0, m_Gamh_x_o2_t4_l0, m_Gamh_x_o2_t3_l0, m_Gamh_x_o2_t2_l0, m_Gamh_x_o2_t1_l0, m_Gamh_x_o2_t0_l0, m_Gamh_x_o1_t2_l0, m_Gamh_x_o1_t1_l0, m_Gamh_x_o1_t0_l0, m_Gamh_x_o0_t2_l0, m_Gamh_x_o0_t1_l0, m_Gamh_x_o0_t0_l0, m_Atd_zz_o2_t2_l0, m_Atd_zz_o2_t1_l0, m_Atd_zz_o2_t0_l0, m_Atd_zz_o1_t2_l0, m_Atd_zz_o1_t1_l0, m_Atd_zz_o1_t0_l0, m_Atd_zz_o0_t2_l0, m_Atd_zz_o0_t1_l0, m_Atd_zz_o0_t0_l0, m_Atd_yz_o2_t5_l0, m_Atd_yz_o2_t4_l0, m_Atd_yz_o2_t3_l0, m_Atd_yz_o2_t2_l0, m_Atd_yz_o2_t1_l0, m_Atd_yz_o2_t0_l0, m_Atd_yz_o1_t2_l0, m_Atd_yz_o1_t1_l0, m_Atd_yz_o1_t0_l0, m_Atd_yz_o0_t2_l0, m_Atd_yz_o0_t1_l0, m_Atd_yz_o0_t0_l0, m_Atd_yy_o2_t2_l0, m_Atd_yy_o2_t1_l0, m_Atd_yy_o2_t0_l0, m_Atd_yy_o1_t2_l0, m_Atd_yy_o1_t1_l0, m_Atd_yy_o1_t0_l0, m_Atd_yy_o0_t2_l0, m_Atd_yy_o0_t1_l0, m_Atd_yy_o0_t0_l0, m_Atd_xz_o2_t5_l0, m_Atd_xz_o2_t4_l0, m_Atd_xz_o2_t3_l0, m_Atd_xz_o2_t2_l0, m_Atd_xz_o2_t1_l0, m_Atd_xz_o2_t0_l0, m_Atd_xz_o1_t2_l0, m_Atd_xz_o1_t1_l0, m_Atd_xz_o1_t0_l0, m_Atd_xz_o0_t2_l0, m_Atd_xz_o0_t1_l0, m_Atd_xz_o0_t0_l0, m_Atd_xy_o2_t5_l0, m_Atd_xy_o2_t4_l0, m_Atd_xy_o2_t3_l0, m_Atd_xy_o2_t2_l0, m_Atd_xy_o2_t1_l0, m_Atd_xy_o2_t0_l0, m_Atd_xy_o1_t2_l0, m_Atd_xy_o1_t1_l0, m_Atd_xy_o1_t0_l0, m_Atd_xy_o0_t2_l0, m_Atd_xy_o0_t1_l0, m_Atd_xy_o0_t0_l0, m_Atd_xx_o2_t2_l0, m_Atd_xx_o2_t1_l0, m_Atd_xx_o2_t0_l0, m_Atd_xx_o1_t2_l0, m_Atd_xx_o1_t1_l0, m_Atd_xx_o1_t0_l0, m_Atd_xx_o0_t2_l0, m_Atd_xx_o0_t1_l0, m_Atd_xx_o0_t0_l0, m_gtd_zz_o2_t2_l0, m_gtd_zz_o2_t1_l0, m_gtd_zz_o2_t0_l0, m_gtd_zz_o1_t2_l0, m_gtd_zz_o1_t1_l0, m_gtd_zz_o1_t0_l0, m_gtd_zz_o0_t2_l0, m_gtd_zz_o0_t1_l0, m_gtd_zz_o0_t0_l0, m_gtd_yz_o2_t5_l0, m_gtd_yz_o2_t4_l0, m_gtd_yz_o2_t3_l0, m_gtd_yz_o2_t2_l0, m_gtd_yz_o2_t1_l0, m_gtd_yz_o2_t0_l0, m_gtd_yz_o1_t2_l0, m_gtd_yz_o1_t1_l0, m_gtd_yz_o1_t0_l0, m_gtd_yz_o0_t2_l0, m_gtd_yz_o0_t1_l0, m_gtd_yz_o0_t0_l0, m_gtd_yy_o2_t2_l0, m_gtd_yy_o2_t1_l0, m_gtd_yy_o2_t0_l0, m_gtd_yy_o1_t2_l0, m_gtd_yy_o1_t1_l0, m_gtd_yy_o1_t0_l0, m_gtd_yy_o0_t2_l0, m_gtd_yy_o0_t1_l0, m_gtd_yy_o0_t0_l0, m_gtd_xz_o2_t5_l0, m_gtd_xz_o2_t4_l0, m_gtd_xz_o2_t3_l0, m_gtd_xz_o2_t2_l0, m_gtd_xz_o2_t1_l0, m_gtd_xz_o2_t0_l0, m_gtd_xz_o1_t2_l0, m_gtd_xz_o1_t1_l0, m_gtd_xz_o1_t0_l0, m_gtd_xz_o0_t2_l0, m_gtd_xz_o0_t1_l0, m_gtd_xz_o0_t0_l0, m_gtd_xy_o2_t5_l0, m_gtd_xy_o2_t4_l0, m_gtd_xy_o2_t3_l0, m_gtd_xy_o2_t2_l0, m_gtd_xy_o2_t1_l0, m_gtd_xy_o2_t0_l0, m_gtd_xy_o1_t2_l0, m_gtd_xy_o1_t1_l0, m_gtd_xy_o1_t0_l0, m_gtd_xy_o0_t2_l0, m_gtd_xy_o0_t1_l0, m_gtd_xy_o0_t0_l0, m_gtd_xx_o2_t2_l0, m_gtd_xx_o2_t1_l0, m_gtd_xx_o2_t0_l0, m_gtd_xx_o1_t2_l0, m_gtd_xx_o1_t1_l0, m_gtd_xx_o1_t0_l0, m_gtd_xx_o0_t2_l0, m_gtd_xx_o0_t1_l0, m_gtd_xx_o0_t0_l0, RHS_gtd_xx, RHS_gtd_xy, RHS_gtd_xz, RHS_gtd_yy, RHS_gtd_yz, RHS_gtd_zz, RHS_Atd_xx, RHS_Atd_xy, RHS_Atd_xz, RHS_Atd_yy, RHS_Atd_yz, RHS_Atd_zz, RHS_Gamh_x, RHS_Gamh_y, RHS_Betau_x, RHS_Betau_y, RHS_Betau_z, RHS_Gamh_z, RHS_Alpha, RHS_chi, RHS_trK, RHS_theta, RHS_phiR, RHS_pheR, RHS_phiI, RHS_pheI, RHS_piR, RHS_peR, RHS_piI, RHS_peI, n_x, n_y, n_z, interaction_index, mod_normal, i_d_Atd_xx_o0_t0_m0_l0, i_d_Atd_xx_o0_t1_m0_l0, i_d_Atd_xx_o0_t2_m0_l0, i_d_Atd_xy_o0_t0_m0_l0, i_d_Atd_xy_o0_t1_m0_l0, i_d_Atd_xy_o0_t2_m0_l0, i_d_Atd_xz_o0_t0_m0_l0, i_d_Atd_xz_o0_t1_m0_l0, i_d_Atd_xz_o0_t2_m0_l0, i_d_Atd_yy_o0_t0_m0_l0, i_d_Atd_yy_o0_t1_m0_l0, i_d_Atd_yy_o0_t2_m0_l0, i_d_Atd_yz_o0_t0_m0_l0, i_d_Atd_yz_o0_t1_m0_l0, i_d_Atd_yz_o0_t2_m0_l0, i_d_Atd_zz_o0_t0_m0_l0, i_d_Atd_zz_o0_t1_m0_l0, i_d_Atd_zz_o0_t2_m0_l0, i_d_piR_o0_t0_m0_l0, i_d_piR_o0_t1_m0_l0, i_d_piR_o0_t2_m0_l0, i_d_peR_o0_t0_m0_l0, i_d_peR_o0_t1_m0_l0, i_d_peR_o0_t2_m0_l0, i_d_piI_o0_t0_m0_l0, i_d_piI_o0_t1_m0_l0, i_d_piI_o0_t2_m0_l0, i_d_peI_o0_t0_m0_l0, i_d_peI_o0_t1_m0_l0, i_d_peI_o0_t2_m0_l0, i_d_gtd_xx_o0_t3_m0_l0, i_d_gtd_xy_o0_t3_m0_l0, i_d_gtd_xz_o0_t3_m0_l0, i_d_gtd_yy_o0_t3_m0_l0, i_d_gtd_yz_o0_t3_m0_l0, i_d_gtd_zz_o0_t3_m0_l0, i_d_Atd_xx_o0_t3_m0_l0, i_d_Atd_xy_o0_t3_m0_l0, i_d_Atd_xz_o0_t3_m0_l0, i_d_Atd_yy_o0_t3_m0_l0, i_d_Atd_yz_o0_t3_m0_l0, i_d_Atd_zz_o0_t3_m0_l0, i_d_Gamh_x_o0_t3_m0_l0, i_d_Gamh_y_o0_t3_m0_l0, i_d_Gamh_z_o0_t3_m0_l0, i_d_Betau_x_o0_t3_m0_l0, i_d_Betau_y_o0_t3_m0_l0, i_d_Betau_z_o0_t3_m0_l0, i_d_Alpha_o0_t3_m0_l0, i_d_chi_o0_t3_m0_l0, i_d_trK_o0_t3_m0_l0, i_d_theta_o0_t3_m0_l0, i_d_phiR_o0_t3_m0_l0, i_d_phiI_o0_t3_m0_l0, i_d_piR_o0_t3_m0_l0, i_d_piI_o0_t3_m0_l0, i_d_pheR_o0_t3_m0_l0, i_d_pheI_o0_t3_m0_l0, i_d_peR_o0_t3_m0_l0, i_d_peI_o0_t3_m0_l0, i_m_gtd_xx_o0_t0_l0, i_m_gtd_xx_o0_t1_l0, i_m_gtd_xx_o0_t2_l0, i_m_gtd_xy_o0_t0_l0, i_m_gtd_xy_o0_t1_l0, i_m_gtd_xy_o0_t2_l0, i_m_gtd_xz_o0_t0_l0, i_m_gtd_xz_o0_t1_l0, i_m_gtd_xz_o0_t2_l0, i_m_gtd_yy_o0_t0_l0, i_m_gtd_yy_o0_t1_l0, i_m_gtd_yy_o0_t2_l0, i_m_gtd_yz_o0_t0_l0, i_m_gtd_yz_o0_t1_l0, i_m_gtd_yz_o0_t2_l0, i_m_gtd_zz_o0_t0_l0, i_m_gtd_zz_o0_t1_l0, i_m_gtd_zz_o0_t2_l0, i_m_Atd_xx_o0_t0_l0, i_m_Atd_xx_o0_t1_l0, i_m_Atd_xx_o0_t2_l0, i_m_Atd_xy_o0_t0_l0, i_m_Atd_xy_o0_t1_l0, i_m_Atd_xy_o0_t2_l0, i_m_Atd_xz_o0_t0_l0, i_m_Atd_xz_o0_t1_l0, i_m_Atd_xz_o0_t2_l0, i_m_Atd_yy_o0_t0_l0, i_m_Atd_yy_o0_t1_l0, i_m_Atd_yy_o0_t2_l0, i_m_Atd_yz_o0_t0_l0, i_m_Atd_yz_o0_t1_l0, i_m_Atd_yz_o0_t2_l0, i_m_Atd_zz_o0_t0_l0, i_m_Atd_zz_o0_t1_l0, i_m_Atd_zz_o0_t2_l0, i_m_Gamh_x_o0_t0_l0, i_m_Gamh_x_o0_t1_l0, i_m_Gamh_x_o0_t2_l0, i_m_Gamh_y_o0_t0_l0, i_m_Gamh_y_o0_t1_l0, i_m_Gamh_y_o0_t2_l0, i_m_Gamh_z_o0_t0_l0, i_m_Gamh_z_o0_t1_l0, i_m_Gamh_z_o0_t2_l0, i_m_Betau_x_o0_t0_l0, i_m_Betau_x_o0_t1_l0, i_m_Betau_x_o0_t2_l0, i_m_Betau_y_o0_t0_l0, i_m_Betau_y_o0_t1_l0, i_m_Betau_y_o0_t2_l0, i_m_Betau_z_o0_t0_l0, i_m_Betau_z_o0_t1_l0, i_m_Betau_z_o0_t2_l0, i_m_Alpha_o0_t0_l0, i_m_Alpha_o0_t1_l0, i_m_Alpha_o0_t2_l0, i_m_chi_o0_t0_l0, i_m_chi_o0_t1_l0, i_m_chi_o0_t2_l0, i_m_trK_o0_t0_l0, i_m_trK_o0_t1_l0, i_m_trK_o0_t2_l0, i_m_theta_o0_t0_l0, i_m_theta_o0_t1_l0, i_m_theta_o0_t2_l0, i_m_phiR_o0_t0_l0, i_m_phiR_o0_t1_l0, i_m_phiR_o0_t2_l0, i_m_phiI_o0_t0_l0, i_m_phiI_o0_t1_l0, i_m_phiI_o0_t2_l0, i_m_piR_o0_t0_l0, i_m_piR_o0_t1_l0, i_m_piR_o0_t2_l0, i_m_piI_o0_t0_l0, i_m_piI_o0_t1_l0, i_m_piI_o0_t2_l0, i_m_pheR_o0_t0_l0, i_m_pheR_o0_t1_l0, i_m_pheR_o0_t2_l0, i_m_pheI_o0_t0_l0, i_m_pheI_o0_t1_l0, i_m_pheI_o0_t2_l0, i_m_peR_o0_t0_l0, i_m_peR_o0_t1_l0, i_m_peR_o0_t2_l0, i_m_peI_o0_t0_l0, i_m_peI_o0_t1_l0, i_m_peI_o0_t2_l0;

				if ((i + 3 <= bx_hi.x && i - 3 >= bx_lo.x && j + 3 <= bx_hi.y && j - 3 >= bx_lo.y && k + 3 <= bx_hi.z && k - 3 >= bx_lo.z)) {
					d_div_Beta_o0_t0_m0_l0 = D1CDO4_i(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t0_m0_l0 = lieforward_i(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t0_m0_l0 = liebackward_i(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o2_t0_m0_l0 = D1CDO4_j(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t1_m0_l0 = lieforward_j(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t1_m0_l0 = liebackward_j(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o2_t0_m0_l0 = D1CDO4_k(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t2_m0_l0 = lieforward_k(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t2_m0_l0 = liebackward_k(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t0_m0_l0 = D2CDO4_i(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t0_m0_l0 = D1CDO4crossed_ij(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t0_m0_l0 = D1CDO4crossed_ik(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t6_m0_l0 = D2CDO4_j(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t7_m0_l0 = D1CDO4crossed_jk(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t8_m0_l0 = D2CDO4_k(Betau_x, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o2_t1_m0_l0 = D1CDO4_i(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t0_m0_l0 = lieforward_i(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t0_m0_l0 = liebackward_i(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_div_Beta_o0_t1_m0_l0 = D1CDO4_j(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t1_m0_l0 = lieforward_j(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t1_m0_l0 = liebackward_j(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o2_t1_m0_l0 = D1CDO4_k(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t2_m0_l0 = lieforward_k(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t2_m0_l0 = liebackward_k(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t4_m0_l0 = D2CDO4_i(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t1_m0_l0 = D1CDO4crossed_ij(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t6_m0_l0 = D1CDO4crossed_ik(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t1_m0_l0 = D2CDO4_j(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t1_m0_l0 = D1CDO4crossed_jk(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t9_m0_l0 = D2CDO4_k(Betau_y, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o2_t2_m0_l0 = D1CDO4_i(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t0_m0_l0 = lieforward_i(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t0_m0_l0 = liebackward_i(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o2_t2_m0_l0 = D1CDO4_j(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t1_m0_l0 = lieforward_j(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t1_m0_l0 = liebackward_j(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_div_Beta_o0_t2_m0_l0 = D1CDO4_k(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t2_m0_l0 = lieforward_k(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t2_m0_l0 = liebackward_k(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t14_m0_l0 = D2CDO4_i(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t15_m0_l0 = D1CDO4crossed_ij(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t2_m0_l0 = D1CDO4crossed_ik(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t17_m0_l0 = D2CDO4_j(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t2_m0_l0 = D1CDO4crossed_jk(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t2_m0_l0 = D2CDO4_k(Betau_z, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t0_m0_l0 = lieforward_i(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t0_m0_l0 = liebackward_i(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xxy_o0_t0_m0_l0 = D1CDO4_j(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t1_m0_l0 = lieforward_j(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t1_m0_l0 = liebackward_j(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xxz_o0_t0_m0_l0 = D1CDO4_k(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t2_m0_l0 = lieforward_k(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t2_m0_l0 = liebackward_k(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Ctd_yxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t0_m0_l0 = lieforward_i(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t0_m0_l0 = liebackward_i(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xyy_o0_t0_m0_l0 = D1CDO4_j(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t1_m0_l0 = lieforward_j(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t1_m0_l0 = liebackward_j(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t1_m0_l0 = D1CDO4_k(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t2_m0_l0 = lieforward_k(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t2_m0_l0 = liebackward_k(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xyy_o0_t1_m0_l0 = D1CDO4_i(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t0_m0_l0 = lieforward_i(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t0_m0_l0 = liebackward_i(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Ctd_yyy_o0_t0_m0_l0 = D1CDO4_j(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t1_m0_l0 = lieforward_j(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t1_m0_l0 = liebackward_j(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Ctd_yyz_o0_t0_m0_l0 = D1CDO4_k(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t2_m0_l0 = lieforward_k(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t2_m0_l0 = liebackward_k(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Ctd_zxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t0_m0_l0 = lieforward_i(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t0_m0_l0 = liebackward_i(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t0_m0_l0 = D1CDO4_j(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t1_m0_l0 = lieforward_j(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t1_m0_l0 = liebackward_j(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xzz_o0_t0_m0_l0 = D1CDO4_k(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t2_m0_l0 = lieforward_k(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t2_m0_l0 = liebackward_k(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t2_m0_l0 = D1CDO4_i(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t0_m0_l0 = lieforward_i(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t0_m0_l0 = liebackward_i(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_zyy_o0_t0_m0_l0 = D1CDO4_j(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t1_m0_l0 = lieforward_j(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t1_m0_l0 = liebackward_j(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_yzz_o0_t0_m0_l0 = D1CDO4_k(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t2_m0_l0 = lieforward_k(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t2_m0_l0 = liebackward_k(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_xzz_o0_t1_m0_l0 = D1CDO4_i(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t0_m0_l0 = lieforward_i(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t0_m0_l0 = liebackward_i(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_yzz_o0_t1_m0_l0 = D1CDO4_j(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t1_m0_l0 = lieforward_j(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t1_m0_l0 = liebackward_j(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Ctd_zzz_o0_t0_m0_l0 = D1CDO4_k(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t2_m0_l0 = lieforward_k(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t2_m0_l0 = liebackward_k(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t0_m0_l0 = D1CDO4_i(chi, rk1, i, j, k, dx, dt_lev);
					d_chi_o0_t0_m0_l0 = lieforward_i(chi, rk1, i, j, k, dx, dt_lev);
					d_chi_o1_t0_m0_l0 = liebackward_i(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t1_m0_l0 = D1CDO4_j(chi, rk1, i, j, k, dx, dt_lev);
					d_chi_o0_t1_m0_l0 = lieforward_j(chi, rk1, i, j, k, dx, dt_lev);
					d_chi_o1_t1_m0_l0 = liebackward_j(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t2_m0_l0 = D1CDO4_k(chi, rk1, i, j, k, dx, dt_lev);
					d_chi_o0_t2_m0_l0 = lieforward_k(chi, rk1, i, j, k, dx, dt_lev);
					d_chi_o1_t2_m0_l0 = liebackward_k(chi, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t6_m0_l0 = D1CDO4_i(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t0_m0_l0 = lieforward_i(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t0_m0_l0 = liebackward_i(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t6_m0_l0 = D1CDO4_j(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t1_m0_l0 = lieforward_j(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t1_m0_l0 = liebackward_j(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t6_m0_l0 = D1CDO4_k(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t2_m0_l0 = lieforward_k(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t2_m0_l0 = liebackward_k(Gamh_x, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t7_m0_l0 = D1CDO4_i(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t0_m0_l0 = lieforward_i(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t0_m0_l0 = liebackward_i(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t7_m0_l0 = D1CDO4_j(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t1_m0_l0 = lieforward_j(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t1_m0_l0 = liebackward_j(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t7_m0_l0 = D1CDO4_k(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t2_m0_l0 = lieforward_k(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t2_m0_l0 = liebackward_k(Gamh_y, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t8_m0_l0 = D1CDO4_i(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t1_m0_l0 = lieforward_i(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t0_m0_l0 = liebackward_i(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t8_m0_l0 = D1CDO4_j(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t2_m0_l0 = lieforward_j(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t1_m0_l0 = liebackward_j(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t8_m0_l0 = D1CDO4_k(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t0_m0_l0 = lieforward_k(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t2_m0_l0 = liebackward_k(Gamh_z, rk1, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t1_m0_l0 = D1CDO4_i(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Alpha_o0_t0_m0_l0 = lieforward_i(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Alpha_o1_t0_m0_l0 = liebackward_i(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t2_m0_l0 = D1CDO4_j(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Alpha_o0_t1_m0_l0 = lieforward_j(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Alpha_o1_t1_m0_l0 = liebackward_j(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t3_m0_l0 = D1CDO4_k(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Alpha_o0_t2_m0_l0 = lieforward_k(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Alpha_o1_t2_m0_l0 = liebackward_k(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t0_m0_l0 = D2CDO4_i(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_xy_o0_t0_m0_l0 = D1CDO4crossed_ij(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_xz_o0_t0_m0_l0 = D1CDO4crossed_ik(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_yy_o0_t0_m0_l0 = D2CDO4_j(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_yz_o0_t0_m0_l0 = D1CDO4crossed_jk(Alpha, rk1, i, j, k, dx, dt_lev);
					d_Psi1_zz_o0_t0_m0_l0 = D2CDO4_k(Alpha, rk1, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t1_m0_l0 = D1CDO4_i(phiR, rk1, i, j, k, dx, dt_lev);
					d_phiR_o0_t0_m0_l0 = lieforward_i(phiR, rk1, i, j, k, dx, dt_lev);
					d_phiR_o1_t0_m0_l0 = liebackward_i(phiR, rk1, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t2_m0_l0 = D1CDO4_j(phiR, rk1, i, j, k, dx, dt_lev);
					d_phiR_o0_t1_m0_l0 = lieforward_j(phiR, rk1, i, j, k, dx, dt_lev);
					d_phiR_o1_t1_m0_l0 = liebackward_j(phiR, rk1, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t3_m0_l0 = D1CDO4_k(phiR, rk1, i, j, k, dx, dt_lev);
					d_phiR_o0_t2_m0_l0 = lieforward_k(phiR, rk1, i, j, k, dx, dt_lev);
					d_phiR_o1_t2_m0_l0 = liebackward_k(phiR, rk1, i, j, k, dx, dt_lev);
					d_piR_o2_t26_m0_l0 = D2CDO4_i(phiR, rk1, i, j, k, dx, dt_lev);
					d_piR_o2_t0_m0_l0 = D1CDO4crossed_ij(phiR, rk1, i, j, k, dx, dt_lev);
					d_piR_o2_t1_m0_l0 = D1CDO4crossed_ik(phiR, rk1, i, j, k, dx, dt_lev);
					d_piR_o2_t2_m0_l0 = D2CDO4_j(phiR, rk1, i, j, k, dx, dt_lev);
					d_piR_o2_t3_m0_l0 = D1CDO4crossed_jk(phiR, rk1, i, j, k, dx, dt_lev);
					d_piR_o2_t4_m0_l0 = D2CDO4_k(phiR, rk1, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t1_m0_l0 = D1CDO4_i(phiI, rk1, i, j, k, dx, dt_lev);
					d_phiI_o0_t0_m0_l0 = lieforward_i(phiI, rk1, i, j, k, dx, dt_lev);
					d_phiI_o1_t0_m0_l0 = liebackward_i(phiI, rk1, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t2_m0_l0 = D1CDO4_j(phiI, rk1, i, j, k, dx, dt_lev);
					d_phiI_o0_t1_m0_l0 = lieforward_j(phiI, rk1, i, j, k, dx, dt_lev);
					d_phiI_o1_t1_m0_l0 = liebackward_j(phiI, rk1, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t3_m0_l0 = D1CDO4_k(phiI, rk1, i, j, k, dx, dt_lev);
					d_phiI_o0_t2_m0_l0 = lieforward_k(phiI, rk1, i, j, k, dx, dt_lev);
					d_phiI_o1_t2_m0_l0 = liebackward_k(phiI, rk1, i, j, k, dx, dt_lev);
					d_piI_o2_t24_m0_l0 = D2CDO4_i(phiI, rk1, i, j, k, dx, dt_lev);
					d_piI_o2_t25_m0_l0 = D1CDO4crossed_ij(phiI, rk1, i, j, k, dx, dt_lev);
					d_piI_o2_t26_m0_l0 = D1CDO4crossed_ik(phiI, rk1, i, j, k, dx, dt_lev);
					d_piI_o2_t0_m0_l0 = D2CDO4_j(phiI, rk1, i, j, k, dx, dt_lev);
					d_piI_o2_t1_m0_l0 = D1CDO4crossed_jk(phiI, rk1, i, j, k, dx, dt_lev);
					d_piI_o2_t2_m0_l0 = D2CDO4_k(phiI, rk1, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t1_m0_l0 = D1CDO4_i(pheR, rk1, i, j, k, dx, dt_lev);
					d_pheR_o0_t0_m0_l0 = lieforward_i(pheR, rk1, i, j, k, dx, dt_lev);
					d_pheR_o1_t0_m0_l0 = liebackward_i(pheR, rk1, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t2_m0_l0 = D1CDO4_j(pheR, rk1, i, j, k, dx, dt_lev);
					d_pheR_o0_t1_m0_l0 = lieforward_j(pheR, rk1, i, j, k, dx, dt_lev);
					d_pheR_o1_t1_m0_l0 = liebackward_j(pheR, rk1, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t3_m0_l0 = D1CDO4_k(pheR, rk1, i, j, k, dx, dt_lev);
					d_pheR_o0_t2_m0_l0 = lieforward_k(pheR, rk1, i, j, k, dx, dt_lev);
					d_pheR_o1_t2_m0_l0 = liebackward_k(pheR, rk1, i, j, k, dx, dt_lev);
					d_peR_o2_t24_m0_l0 = D2CDO4_i(pheR, rk1, i, j, k, dx, dt_lev);
					d_peR_o2_t25_m0_l0 = D1CDO4crossed_ij(pheR, rk1, i, j, k, dx, dt_lev);
					d_peR_o2_t26_m0_l0 = D1CDO4crossed_ik(pheR, rk1, i, j, k, dx, dt_lev);
					d_peR_o2_t0_m0_l0 = D2CDO4_j(pheR, rk1, i, j, k, dx, dt_lev);
					d_peR_o2_t1_m0_l0 = D1CDO4crossed_jk(pheR, rk1, i, j, k, dx, dt_lev);
					d_peR_o2_t2_m0_l0 = D2CDO4_k(pheR, rk1, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t1_m0_l0 = D1CDO4_i(pheI, rk1, i, j, k, dx, dt_lev);
					d_pheI_o0_t0_m0_l0 = lieforward_i(pheI, rk1, i, j, k, dx, dt_lev);
					d_pheI_o1_t0_m0_l0 = liebackward_i(pheI, rk1, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t2_m0_l0 = D1CDO4_j(pheI, rk1, i, j, k, dx, dt_lev);
					d_pheI_o0_t1_m0_l0 = lieforward_j(pheI, rk1, i, j, k, dx, dt_lev);
					d_pheI_o1_t1_m0_l0 = liebackward_j(pheI, rk1, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t3_m0_l0 = D1CDO4_k(pheI, rk1, i, j, k, dx, dt_lev);
					d_pheI_o0_t2_m0_l0 = lieforward_k(pheI, rk1, i, j, k, dx, dt_lev);
					d_pheI_o1_t2_m0_l0 = liebackward_k(pheI, rk1, i, j, k, dx, dt_lev);
					d_peI_o2_t22_m0_l0 = D2CDO4_i(pheI, rk1, i, j, k, dx, dt_lev);
					d_peI_o2_t23_m0_l0 = D1CDO4crossed_ij(pheI, rk1, i, j, k, dx, dt_lev);
					d_peI_o2_t24_m0_l0 = D1CDO4crossed_ik(pheI, rk1, i, j, k, dx, dt_lev);
					d_peI_o2_t25_m0_l0 = D2CDO4_j(pheI, rk1, i, j, k, dx, dt_lev);
					d_peI_o2_t26_m0_l0 = D1CDO4crossed_jk(pheI, rk1, i, j, k, dx, dt_lev);
					d_peI_o2_t0_m0_l0 = D2CDO4_k(pheI, rk1, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t0_m0_l0 = lieforward_i(Atd_xx, rk1, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t0_m0_l0 = liebackward_i(Atd_xx, rk1, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t1_m0_l0 = lieforward_j(Atd_xx, rk1, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t1_m0_l0 = liebackward_j(Atd_xx, rk1, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t2_m0_l0 = lieforward_k(Atd_xx, rk1, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t2_m0_l0 = liebackward_k(Atd_xx, rk1, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t0_m0_l0 = lieforward_i(Atd_xy, rk1, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t0_m0_l0 = liebackward_i(Atd_xy, rk1, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t1_m0_l0 = lieforward_j(Atd_xy, rk1, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t1_m0_l0 = liebackward_j(Atd_xy, rk1, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t2_m0_l0 = lieforward_k(Atd_xy, rk1, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t2_m0_l0 = liebackward_k(Atd_xy, rk1, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t0_m0_l0 = lieforward_i(Atd_xz, rk1, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t0_m0_l0 = liebackward_i(Atd_xz, rk1, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t1_m0_l0 = lieforward_j(Atd_xz, rk1, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t1_m0_l0 = liebackward_j(Atd_xz, rk1, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t2_m0_l0 = lieforward_k(Atd_xz, rk1, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t2_m0_l0 = liebackward_k(Atd_xz, rk1, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t0_m0_l0 = lieforward_i(Atd_yy, rk1, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t0_m0_l0 = liebackward_i(Atd_yy, rk1, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t1_m0_l0 = lieforward_j(Atd_yy, rk1, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t1_m0_l0 = liebackward_j(Atd_yy, rk1, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t2_m0_l0 = lieforward_k(Atd_yy, rk1, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t2_m0_l0 = liebackward_k(Atd_yy, rk1, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t0_m0_l0 = lieforward_i(Atd_yz, rk1, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t0_m0_l0 = liebackward_i(Atd_yz, rk1, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t1_m0_l0 = lieforward_j(Atd_yz, rk1, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t1_m0_l0 = liebackward_j(Atd_yz, rk1, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t2_m0_l0 = lieforward_k(Atd_yz, rk1, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t2_m0_l0 = liebackward_k(Atd_yz, rk1, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t0_m0_l0 = lieforward_i(Atd_zz, rk1, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t0_m0_l0 = liebackward_i(Atd_zz, rk1, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t1_m0_l0 = lieforward_j(Atd_zz, rk1, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t1_m0_l0 = liebackward_j(Atd_zz, rk1, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t2_m0_l0 = lieforward_k(Atd_zz, rk1, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t2_m0_l0 = liebackward_k(Atd_zz, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t12_m0_l0 = D1CDO4_i(trK, rk1, i, j, k, dx, dt_lev);
					d_trK_o0_t0_m0_l0 = lieforward_i(trK, rk1, i, j, k, dx, dt_lev);
					d_trK_o1_t0_m0_l0 = liebackward_i(trK, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t13_m0_l0 = D1CDO4_j(trK, rk1, i, j, k, dx, dt_lev);
					d_trK_o0_t1_m0_l0 = lieforward_j(trK, rk1, i, j, k, dx, dt_lev);
					d_trK_o1_t1_m0_l0 = liebackward_j(trK, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t14_m0_l0 = D1CDO4_k(trK, rk1, i, j, k, dx, dt_lev);
					d_trK_o0_t2_m0_l0 = lieforward_k(trK, rk1, i, j, k, dx, dt_lev);
					d_trK_o1_t2_m0_l0 = liebackward_k(trK, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t15_m0_l0 = D1CDO4_i(theta, rk1, i, j, k, dx, dt_lev);
					d_theta_o0_t0_m0_l0 = lieforward_i(theta, rk1, i, j, k, dx, dt_lev);
					d_theta_o1_t0_m0_l0 = liebackward_i(theta, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t16_m0_l0 = D1CDO4_j(theta, rk1, i, j, k, dx, dt_lev);
					d_theta_o0_t1_m0_l0 = lieforward_j(theta, rk1, i, j, k, dx, dt_lev);
					d_theta_o1_t1_m0_l0 = liebackward_j(theta, rk1, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t17_m0_l0 = D1CDO4_k(theta, rk1, i, j, k, dx, dt_lev);
					d_theta_o0_t2_m0_l0 = lieforward_k(theta, rk1, i, j, k, dx, dt_lev);
					d_theta_o1_t2_m0_l0 = liebackward_k(theta, rk1, i, j, k, dx, dt_lev);
					d_piR_o0_t0_m0_l0 = lieforward_i(piR, rk1, i, j, k, dx, dt_lev);
					d_piR_o1_t0_m0_l0 = liebackward_i(piR, rk1, i, j, k, dx, dt_lev);
					d_piR_o0_t1_m0_l0 = lieforward_j(piR, rk1, i, j, k, dx, dt_lev);
					d_piR_o1_t1_m0_l0 = liebackward_j(piR, rk1, i, j, k, dx, dt_lev);
					d_piR_o0_t2_m0_l0 = lieforward_k(piR, rk1, i, j, k, dx, dt_lev);
					d_piR_o1_t2_m0_l0 = liebackward_k(piR, rk1, i, j, k, dx, dt_lev);
					d_peR_o0_t0_m0_l0 = lieforward_i(peR, rk1, i, j, k, dx, dt_lev);
					d_peR_o1_t0_m0_l0 = liebackward_i(peR, rk1, i, j, k, dx, dt_lev);
					d_peR_o0_t1_m0_l0 = lieforward_j(peR, rk1, i, j, k, dx, dt_lev);
					d_peR_o1_t1_m0_l0 = liebackward_j(peR, rk1, i, j, k, dx, dt_lev);
					d_peR_o0_t2_m0_l0 = lieforward_k(peR, rk1, i, j, k, dx, dt_lev);
					d_peR_o1_t2_m0_l0 = liebackward_k(peR, rk1, i, j, k, dx, dt_lev);
					d_piI_o0_t0_m0_l0 = lieforward_i(piI, rk1, i, j, k, dx, dt_lev);
					d_piI_o1_t0_m0_l0 = liebackward_i(piI, rk1, i, j, k, dx, dt_lev);
					d_piI_o0_t1_m0_l0 = lieforward_j(piI, rk1, i, j, k, dx, dt_lev);
					d_piI_o1_t1_m0_l0 = liebackward_j(piI, rk1, i, j, k, dx, dt_lev);
					d_piI_o0_t2_m0_l0 = lieforward_k(piI, rk1, i, j, k, dx, dt_lev);
					d_piI_o1_t2_m0_l0 = liebackward_k(piI, rk1, i, j, k, dx, dt_lev);
					d_peI_o0_t0_m0_l0 = lieforward_i(peI, rk1, i, j, k, dx, dt_lev);
					d_peI_o1_t2_m0_l0 = liebackward_i(peI, rk1, i, j, k, dx, dt_lev);
					d_peI_o0_t1_m0_l0 = lieforward_j(peI, rk1, i, j, k, dx, dt_lev);
					d_peI_o1_t0_m0_l0 = liebackward_j(peI, rk1, i, j, k, dx, dt_lev);
					d_peI_o0_t2_m0_l0 = lieforward_k(peI, rk1, i, j, k, dx, dt_lev);
					d_peI_o1_t1_m0_l0 = liebackward_k(peI, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t0_m0_l0 = D2CDO4_i(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t3_m0_l0 = D2CDO4_j(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t5_m0_l0 = D2CDO4_k(gtd_xx, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t0_m0_l0 = D2CDO4_i(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t3_m0_l0 = D2CDO4_j(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t5_m0_l0 = D2CDO4_k(gtd_xy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t0_m0_l0 = D2CDO4_i(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t3_m0_l0 = D2CDO4_j(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t5_m0_l0 = D2CDO4_k(gtd_yy, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t0_m0_l0 = D2CDO4_i(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t3_m0_l0 = D2CDO4_j(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t5_m0_l0 = D2CDO4_k(gtd_xz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t0_m0_l0 = D2CDO4_i(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t3_m0_l0 = D2CDO4_j(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t5_m0_l0 = D2CDO4_k(gtd_yz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t0_m0_l0 = D2CDO4_i(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t3_m0_l0 = D2CDO4_j(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t5_m0_l0 = D2CDO4_k(gtd_zz, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t3_m0_l0 = D2CDO4_i(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t4_m0_l0 = D1CDO4crossed_ij(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t5_m0_l0 = D1CDO4crossed_ik(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t6_m0_l0 = D2CDO4_j(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t7_m0_l0 = D1CDO4crossed_jk(chi, rk1, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t8_m0_l0 = D2CDO4_k(chi, rk1, i, j, k, dx, dt_lev);
					rk1m_Ctd_yyz_o0_t0_l0 = .5 * d_Ctd_yyz_o0_t0_m0_l0;
					rk1Ctd_yyz = rk1m_Ctd_yyz_o0_t0_l0;
					rk1m_Ctd_yyy_o0_t0_l0 = .5 * d_Ctd_yyy_o0_t0_m0_l0;
					rk1Ctd_yyy = rk1m_Ctd_yyy_o0_t0_l0;
					rk1div_Beta = (d_div_Beta_o0_t0_m0_l0 + d_div_Beta_o0_t1_m0_l0) + d_div_Beta_o0_t2_m0_l0;
					rk1m_Ctd_xxz_o0_t0_l0 = .5 * d_Ctd_xxz_o0_t0_m0_l0;
					rk1Ctd_xxz = rk1m_Ctd_xxz_o0_t0_l0;
					rk1m_Ctd_xxx_o0_t0_l0 = .5 * d_Ctd_xxx_o0_t0_m0_l0;
					rk1Ctd_xxx = rk1m_Ctd_xxx_o0_t0_l0;
					rk1m_Ctd_yzz_o0_t1_l0 = (-.5) * d_Ctd_yzz_o0_t1_m0_l0;
					rk1m_Ctd_yzz_o0_t0_l0 = 1.0 * d_Ctd_yzz_o0_t0_m0_l0;
					rk1Ctd_yzz = rk1m_Ctd_yzz_o0_t0_l0 + rk1m_Ctd_yzz_o0_t1_l0;
					rk1m_Ctd_xxy_o0_t0_l0 = .5 * d_Ctd_xxy_o0_t0_m0_l0;
					rk1Ctd_xxy = rk1m_Ctd_xxy_o0_t0_l0;
					rk1sfmass = parameters.p_sfmass;
					rk1dVdphe2 = (rk1sfmass * rk1sfmass) * ((1.0 - 2.0 * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) + (-4.0 * ((rk1sfmass * rk1sfmass) * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) * (1.0 - 2.0 * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) / (parameters.sfsigma * parameters.sfsigma)) + parameters.sflambda * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI));
					rk1kappa_z2 = parameters.p_kappa_z2;
					rk1m_Ctd_xyy_o0_t1_l0 = (-.5) * d_Ctd_xyy_o0_t1_m0_l0;
					rk1m_Ctd_xyy_o0_t0_l0 = 1.0 * d_Ctd_xyy_o0_t0_m0_l0;
					rk1Ctd_xyy = rk1m_Ctd_xyy_o0_t0_l0 + rk1m_Ctd_xyy_o0_t1_l0;
					rk1m_Ctd_xyz_o0_t2_l0 = (-.5) * d_Ctd_xyz_o0_t2_m0_l0;
					rk1m_Ctd_xyz_o0_t1_l0 = .5 * d_Ctd_xyz_o0_t1_m0_l0;
					rk1m_Ctd_xyz_o0_t0_l0 = .5 * d_Ctd_xyz_o0_t0_m0_l0;
					rk1Ctd_xyz = (rk1m_Ctd_xyz_o0_t0_l0 + rk1m_Ctd_xyz_o0_t1_l0) + rk1m_Ctd_xyz_o0_t2_l0;
					rk1d_div_Beta_y = (d_d_div_Beta_y_o0_t0_m0_l0 + d_d_div_Beta_y_o0_t1_m0_l0) + d_d_div_Beta_y_o0_t2_m0_l0;
					rk1d_div_Beta_x = (d_d_div_Beta_x_o0_t0_m0_l0 + d_d_div_Beta_x_o0_t1_m0_l0) + d_d_div_Beta_x_o0_t2_m0_l0;
					rk1d_div_Beta_z = (d_d_div_Beta_z_o0_t0_m0_l0 + d_d_div_Beta_z_o0_t1_m0_l0) + d_d_div_Beta_z_o0_t2_m0_l0;
					rk1m_Ctd_xzz_o0_t1_l0 = (-.5) * d_Ctd_xzz_o0_t1_m0_l0;
					rk1m_Ctd_xzz_o0_t0_l0 = 1.0 * d_Ctd_xzz_o0_t0_m0_l0;
					rk1Ctd_xzz = rk1m_Ctd_xzz_o0_t0_l0 + rk1m_Ctd_xzz_o0_t1_l0;
					rk1dVdphi2 = (rk1sfmass * rk1sfmass) * ((1.0 - 2.0 * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) + (-4.0 * ((rk1sfmass * rk1sfmass) * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) * (1.0 - 2.0 * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) / (parameters.sfsigma * parameters.sfsigma)) + parameters.sflambda * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI));
					rk1d_d_phiI4d_t_o0_t0_m0_l0 = -rk1(i, j, k, Alpha) * rk1(i, j, k, piI);
					rk1m_d_phiI4d_t_o0_t6_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_d_phiI4d_t_o0_t3_m0_l0;
					rk1m_d_phiI4d_t_o0_t5_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_d_phiI4d_t_o0_t2_m0_l0;
					rk1m_d_phiI4d_t_o0_t4_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_d_phiI4d_t_o0_t1_m0_l0;
					rk1m_d_phiI4d_t_o0_t3_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_d_phiI4d_t_o0_t3_m0_l0;
					rk1m_d_phiI4d_t_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_d_phiI4d_t_o0_t2_m0_l0;
					rk1m_d_phiI4d_t_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_d_phiI4d_t_o0_t1_m0_l0;
					rk1d_phiI4d_t = (((((rk1d_d_phiI4d_t_o0_t0_m0_l0 + rk1m_d_phiI4d_t_o0_t1_l0) + rk1m_d_phiI4d_t_o0_t2_l0) + rk1m_d_phiI4d_t_o0_t3_l0) + rk1m_d_phiI4d_t_o0_t4_l0) + rk1m_d_phiI4d_t_o0_t5_l0) + rk1m_d_phiI4d_t_o0_t6_l0;
					rk1d_phiI4d_x = d_d_phiI4d_t_o0_t1_m0_l0;
					rk1d_phiI4d_y = d_d_phiI4d_t_o0_t2_m0_l0;
					rk1d_phiI4d_z = d_d_phiI4d_t_o0_t3_m0_l0;
					rk1g4u_tx = rk1(i, j, k, Betau_x) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha));
					rk1g4u_tz = rk1(i, j, k, Betau_z) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha));
					rk1g4u_ty = rk1(i, j, k, Betau_y) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha));
					rk1g4u_tt = -1.0 / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha));
					rk1d_phiI4u_t = rk1g4u_tt * rk1d_phiI4d_t + rk1g4u_tx * rk1d_phiI4d_x + rk1g4u_ty * rk1d_phiI4d_y + rk1g4u_tz * rk1d_phiI4d_z;
					rk1sfVe = (rk1sfmass * rk1sfmass) * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) * ((1.0 - 2.0 * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) + parameters.sflambda / 2.0 * ((rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)) * (rk1(i, j, k, pheR) * rk1(i, j, k, pheR) + rk1(i, j, k, pheI) * rk1(i, j, k, pheI)));
					rk1sfVi = (rk1sfmass * rk1sfmass) * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) * ((1.0 - 2.0 * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) + parameters.sflambda / 2.0 * ((rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)) * (rk1(i, j, k, phiR) * rk1(i, j, k, phiR) + rk1(i, j, k, phiI) * rk1(i, j, k, phiI)));
					rk1m_Ctd_zxz_o0_t0_l0 = .5 * d_Ctd_xzz_o0_t1_m0_l0;
					rk1Ctd_zxz = rk1m_Ctd_zxz_o0_t0_l0;
					rk1m_Ctd_zxx_o0_t1_l0 = (-.5) * d_Ctd_xxz_o0_t0_m0_l0;
					rk1m_Ctd_zxx_o0_t0_l0 = 1.0 * d_Ctd_zxx_o0_t0_m0_l0;
					rk1Ctd_zxx = rk1m_Ctd_zxx_o0_t0_l0 + rk1m_Ctd_zxx_o0_t1_l0;
					rk1detgtd = rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_zz) * rk1(i, j, k, gtd_xx) + (-rk1(i, j, k, gtd_yy) * (rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_xz))) + (-rk1(i, j, k, gtd_zz) * (rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xy))) + (-(rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_yz)) * rk1(i, j, k, gtd_xx)) + 2.0 * rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xz);
					rk1d_d_phiR4d_t_o0_t0_m0_l0 = -rk1(i, j, k, Alpha) * rk1(i, j, k, piR);
					rk1m_d_phiR4d_t_o0_t6_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_d_phiR4d_t_o0_t3_m0_l0;
					rk1m_d_phiR4d_t_o0_t5_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_d_phiR4d_t_o0_t2_m0_l0;
					rk1m_d_phiR4d_t_o0_t4_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_d_phiR4d_t_o0_t1_m0_l0;
					rk1m_d_phiR4d_t_o0_t3_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_d_phiR4d_t_o0_t3_m0_l0;
					rk1m_d_phiR4d_t_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_d_phiR4d_t_o0_t2_m0_l0;
					rk1m_d_phiR4d_t_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_d_phiR4d_t_o0_t1_m0_l0;
					rk1d_phiR4d_t = (((((rk1d_d_phiR4d_t_o0_t0_m0_l0 + rk1m_d_phiR4d_t_o0_t1_l0) + rk1m_d_phiR4d_t_o0_t2_l0) + rk1m_d_phiR4d_t_o0_t3_l0) + rk1m_d_phiR4d_t_o0_t4_l0) + rk1m_d_phiR4d_t_o0_t5_l0) + rk1m_d_phiR4d_t_o0_t6_l0;
					rk1d_phiR4d_x = d_d_phiR4d_t_o0_t1_m0_l0;
					rk1d_phiR4d_z = d_d_phiR4d_t_o0_t3_m0_l0;
					rk1d_phiR4d_y = d_d_phiR4d_t_o0_t2_m0_l0;
					rk1d_phiR4u_t = rk1g4u_tt * rk1d_phiR4d_t + rk1g4u_tx * rk1d_phiR4d_x + rk1g4u_ty * rk1d_phiR4d_y + rk1g4u_tz * rk1d_phiR4d_z;
					rk1chi_max = std::max(parameters.chi_floor, rk1(i, j, k, chi));
					rk1inv_chi = 1.0 / fabs(rk1chi_max);
					rk1d_d_pheR4d_t_o0_t0_m0_l0 = -rk1(i, j, k, Alpha) * rk1(i, j, k, peR);
					rk1m_d_pheR4d_t_o0_t6_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_d_pheR4d_t_o0_t3_m0_l0;
					rk1m_d_pheR4d_t_o0_t5_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_d_pheR4d_t_o0_t2_m0_l0;
					rk1m_d_pheR4d_t_o0_t4_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_d_pheR4d_t_o0_t1_m0_l0;
					rk1m_d_pheR4d_t_o0_t3_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_d_pheR4d_t_o0_t3_m0_l0;
					rk1m_d_pheR4d_t_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_d_pheR4d_t_o0_t2_m0_l0;
					rk1m_d_pheR4d_t_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_d_pheR4d_t_o0_t1_m0_l0;
					rk1d_pheR4d_t = (((((rk1d_d_pheR4d_t_o0_t0_m0_l0 + rk1m_d_pheR4d_t_o0_t1_l0) + rk1m_d_pheR4d_t_o0_t2_l0) + rk1m_d_pheR4d_t_o0_t3_l0) + rk1m_d_pheR4d_t_o0_t4_l0) + rk1m_d_pheR4d_t_o0_t5_l0) + rk1m_d_pheR4d_t_o0_t6_l0;
					rk1d_pheR4d_x = d_d_pheR4d_t_o0_t1_m0_l0;
					rk1d_pheR4d_y = d_d_pheR4d_t_o0_t2_m0_l0;
					rk1d_pheR4d_z = d_d_pheR4d_t_o0_t3_m0_l0;
					rk1d_pheR4u_t = rk1g4u_tt * rk1d_pheR4d_t + rk1g4u_tx * rk1d_pheR4d_x + rk1g4u_ty * rk1d_pheR4d_y + rk1g4u_tz * rk1d_pheR4d_z;
					rk1m_Ctd_zyy_o0_t1_l0 = (-.5) * d_Ctd_yyz_o0_t0_m0_l0;
					rk1m_Ctd_zyy_o0_t0_l0 = 1.0 * d_Ctd_zyy_o0_t0_m0_l0;
					rk1Ctd_zyy = rk1m_Ctd_zyy_o0_t0_l0 + rk1m_Ctd_zyy_o0_t1_l0;
					rk1m_Ctd_zyz_o0_t0_l0 = .5 * d_Ctd_yzz_o0_t1_m0_l0;
					rk1Ctd_zyz = rk1m_Ctd_zyz_o0_t0_l0;
					rk1Betatd_x = rk1(i, j, k, Betau_x) * rk1(i, j, k, gtd_xx) + rk1(i, j, k, Betau_y) * rk1(i, j, k, gtd_xy) + rk1(i, j, k, Betau_z) * rk1(i, j, k, gtd_xz);
					rk1Betatd_z = rk1(i, j, k, Betau_x) * rk1(i, j, k, gtd_xz) + rk1(i, j, k, Betau_y) * rk1(i, j, k, gtd_yz) + rk1(i, j, k, Betau_z) * rk1(i, j, k, gtd_zz);
					rk1Betatd_y = rk1(i, j, k, Betau_x) * rk1(i, j, k, gtd_xy) + rk1(i, j, k, Betau_y) * rk1(i, j, k, gtd_yy) + rk1(i, j, k, Betau_z) * rk1(i, j, k, gtd_yz);
					rk1idetgtd = 1.0 / rk1detgtd;
					rk1gtu_zz = rk1idetgtd * (rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_yy) - rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xy));
					rk1g4u_zz = rk1chi_max * rk1gtu_zz + (-(rk1(i, j, k, Betau_z) * rk1(i, j, k, Betau_z)) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)));
					rk1gtu_yy = rk1idetgtd * (rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_zz) - rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_xz));
					rk1g4u_yy = rk1chi_max * rk1gtu_yy + (-(rk1(i, j, k, Betau_y) * rk1(i, j, k, Betau_y)) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)));
					rk1gtu_yz = rk1idetgtd * ((-rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_yz)) + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xz));
					rk1g4u_yz = rk1chi_max * rk1gtu_yz + (-(rk1(i, j, k, Betau_y) * rk1(i, j, k, Betau_z)) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)));
					rk1gtu_xx = rk1idetgtd * (rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_zz) - rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_yz));
					rk1g4u_xx = rk1chi_max * rk1gtu_xx + (-(rk1(i, j, k, Betau_x) * rk1(i, j, k, Betau_x)) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)));
					rk1gtu_xz = rk1idetgtd * (rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yz) - rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_xz));
					rk1g4u_xz = rk1chi_max * rk1gtu_xz + (-(rk1(i, j, k, Betau_x) * rk1(i, j, k, Betau_z)) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)));
					rk1d_pheR4u_z = rk1g4u_tz * rk1d_pheR4d_t + rk1g4u_xz * rk1d_pheR4d_x + rk1g4u_yz * rk1d_pheR4d_y + rk1g4u_zz * rk1d_pheR4d_z;
					rk1d_phiR4u_z = rk1g4u_tz * rk1d_phiR4d_t + rk1g4u_xz * rk1d_phiR4d_x + rk1g4u_yz * rk1d_phiR4d_y + rk1g4u_zz * rk1d_phiR4d_z;
					rk1d_phiI4u_z = rk1g4u_tz * rk1d_phiI4d_t + rk1g4u_xz * rk1d_phiI4d_x + rk1g4u_yz * rk1d_phiI4d_y + rk1g4u_zz * rk1d_phiI4d_z;
					rk1Ct_zyz = rk1gtu_xz * rk1Ctd_xyz + rk1gtu_yz * rk1Ctd_yyz + rk1gtu_zz * rk1Ctd_zyz;
					rk1Ct_zyy = rk1gtu_xz * rk1Ctd_xyy + rk1gtu_yz * rk1Ctd_yyy + rk1gtu_zz * rk1Ctd_zyy;
					rk1Atud_zx = rk1gtu_xz * rk1(i, j, k, Atd_xx) + rk1gtu_yz * rk1(i, j, k, Atd_xy) + rk1gtu_zz * rk1(i, j, k, Atd_xz);
					rk1Atud_zz = rk1gtu_xz * rk1(i, j, k, Atd_xz) + rk1gtu_yz * rk1(i, j, k, Atd_yz) + rk1gtu_zz * rk1(i, j, k, Atd_zz);
					rk1Atud_zy = rk1gtu_xz * rk1(i, j, k, Atd_xy) + rk1gtu_yz * rk1(i, j, k, Atd_yy) + rk1gtu_zz * rk1(i, j, k, Atd_yz);
					rk1Atu_zz = rk1Atud_zx * rk1gtu_xz + rk1Atud_zy * rk1gtu_yz + rk1Atud_zz * rk1gtu_zz;
					rk1gtu_xy = rk1idetgtd * ((-rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_zz)) + rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_xz));
					rk1g4u_xy = rk1chi_max * rk1gtu_xy + (-(rk1(i, j, k, Betau_x) * rk1(i, j, k, Betau_y)) / (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)));
					rk1d_pheR4u_x = rk1g4u_tx * rk1d_pheR4d_t + rk1g4u_xx * rk1d_pheR4d_x + rk1g4u_xy * rk1d_pheR4d_y + rk1g4u_xz * rk1d_pheR4d_z;
					rk1d_pheR4u_y = rk1g4u_ty * rk1d_pheR4d_t + rk1g4u_xy * rk1d_pheR4d_x + rk1g4u_yy * rk1d_pheR4d_y + rk1g4u_yz * rk1d_pheR4d_z;
					rk1d_phiR4u_y = rk1g4u_ty * rk1d_phiR4d_t + rk1g4u_xy * rk1d_phiR4d_x + rk1g4u_yy * rk1d_phiR4d_y + rk1g4u_yz * rk1d_phiR4d_z;
					rk1d_phiR4u_x = rk1g4u_tx * rk1d_phiR4d_t + rk1g4u_xx * rk1d_phiR4d_x + rk1g4u_xy * rk1d_phiR4d_y + rk1g4u_xz * rk1d_phiR4d_z;
					rk1d_phiI4u_y = rk1g4u_ty * rk1d_phiI4d_t + rk1g4u_xy * rk1d_phiI4d_x + rk1g4u_yy * rk1d_phiI4d_y + rk1g4u_yz * rk1d_phiI4d_z;
					rk1d_phiI4u_x = rk1g4u_tx * rk1d_phiI4d_t + rk1g4u_xx * rk1d_phiI4d_x + rk1g4u_xy * rk1d_phiI4d_y + rk1g4u_xz * rk1d_phiI4d_z;
					rk1dphi4sq = rk1d_phiR4u_t * rk1d_phiR4d_t + rk1d_phiR4u_x * rk1d_phiR4d_x + rk1d_phiR4u_y * rk1d_phiR4d_y + rk1d_phiR4u_z * rk1d_phiR4d_z + rk1d_phiI4u_t * rk1d_phiI4d_t + rk1d_phiI4u_x * rk1d_phiI4d_x + rk1d_phiI4u_y * rk1d_phiI4d_y + rk1d_phiI4u_z * rk1d_phiI4d_z;
					rk1Atud_yy = rk1gtu_xy * rk1(i, j, k, Atd_xy) + rk1gtu_yy * rk1(i, j, k, Atd_yy) + rk1gtu_yz * rk1(i, j, k, Atd_yz);
					rk1Atud_yx = rk1gtu_xy * rk1(i, j, k, Atd_xx) + rk1gtu_yy * rk1(i, j, k, Atd_xy) + rk1gtu_yz * rk1(i, j, k, Atd_xz);
					rk1Atud_yz = rk1gtu_xy * rk1(i, j, k, Atd_xz) + rk1gtu_yy * rk1(i, j, k, Atd_yz) + rk1gtu_yz * rk1(i, j, k, Atd_zz);
					rk1Atu_yz = rk1Atud_yx * rk1gtu_xz + rk1Atud_yy * rk1gtu_yz + rk1Atud_yz * rk1gtu_zz;
					rk1Atu_yy = rk1Atud_yx * rk1gtu_xy + rk1Atud_yy * rk1gtu_yy + rk1Atud_yz * rk1gtu_yz;
					rk1Ct_yyy = rk1gtu_xy * rk1Ctd_xyy + rk1gtu_yy * rk1Ctd_yyy + rk1gtu_yz * rk1Ctd_zyy;
					rk1Ct_yyz = rk1gtu_xy * rk1Ctd_xyz + rk1gtu_yy * rk1Ctd_yyz + rk1gtu_yz * rk1Ctd_zyz;
					rk1Atud_xx = rk1gtu_xx * rk1(i, j, k, Atd_xx) + rk1gtu_xy * rk1(i, j, k, Atd_xy) + rk1gtu_xz * rk1(i, j, k, Atd_xz);
					rk1trAt = rk1Atud_xx + rk1Atud_yy + rk1Atud_zz;
					rk1Atud_xz = rk1gtu_xx * rk1(i, j, k, Atd_xz) + rk1gtu_xy * rk1(i, j, k, Atd_yz) + rk1gtu_xz * rk1(i, j, k, Atd_zz);
					rk1Atud_xy = rk1gtu_xx * rk1(i, j, k, Atd_xy) + rk1gtu_xy * rk1(i, j, k, Atd_yy) + rk1gtu_xz * rk1(i, j, k, Atd_yz);
					rk1Atu_xz = rk1Atud_xx * rk1gtu_xz + rk1Atud_xy * rk1gtu_yz + rk1Atud_xz * rk1gtu_zz;
					rk1Atu_xy = rk1Atud_xx * rk1gtu_xy + rk1Atud_xy * rk1gtu_yy + rk1Atud_xz * rk1gtu_yz;
					rk1Atu_xx = rk1Atud_xx * rk1gtu_xx + rk1Atud_xy * rk1gtu_xy + rk1Atud_xz * rk1gtu_xz;
					rk1decay_factor = std::min(1.0, pow((parameters.R_0 / std::max(0.0000000001, sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k)))), parameters.eta_damping_exp));
					rk1kappa_z1 = std::min(parameters.p_kappa_z1, parameters.p_kappa_z1 * rk1decay_factor) / rk1(i, j, k, Alpha);
					rk1feta = std::min(parameters.p_feta, parameters.p_feta * rk1decay_factor);
					rk1m_Ctd_zzz_o0_t0_l0 = .5 * d_Ctd_zzz_o0_t0_m0_l0;
					rk1Ctd_zzz = rk1m_Ctd_zzz_o0_t0_l0;
					rk1Ct_xzz = rk1gtu_xx * rk1Ctd_xzz + rk1gtu_xy * rk1Ctd_yzz + rk1gtu_xz * rk1Ctd_zzz;
					rk1Ct_zzz = rk1gtu_xz * rk1Ctd_xzz + rk1gtu_yz * rk1Ctd_yzz + rk1gtu_zz * rk1Ctd_zzz;
					rk1Ct_yzz = rk1gtu_xy * rk1Ctd_xzz + rk1gtu_yy * rk1Ctd_yzz + rk1gtu_yz * rk1Ctd_zzz;
					rk1m_Ctd_yxy_o0_t0_l0 = .5 * d_Ctd_xyy_o0_t1_m0_l0;
					rk1Ctd_yxy = rk1m_Ctd_yxy_o0_t0_l0;
					rk1Ct_xyz = rk1gtu_xx * rk1Ctd_xyz + rk1gtu_xy * rk1Ctd_yyz + rk1gtu_xz * rk1Ctd_zyz;
					rk1m_Ctd_yxz_o0_t2_l0 = (-.5) * d_Ctd_xyz_o0_t0_m0_l0;
					rk1m_Ctd_yxz_o0_t0_l0 = .5 * d_Ctd_xyz_o0_t2_m0_l0;
					rk1Ctd_yxz = (rk1m_Ctd_yxz_o0_t0_l0 + rk1m_Ctd_xyz_o0_t1_l0) + rk1m_Ctd_yxz_o0_t2_l0;
					rk1Ct_zxz = rk1gtu_xz * rk1Ctd_xxz + rk1gtu_yz * rk1Ctd_yxz + rk1gtu_zz * rk1Ctd_zxz;
					rk1Ct_yxz = rk1gtu_xy * rk1Ctd_xxz + rk1gtu_yy * rk1Ctd_yxz + rk1gtu_yz * rk1Ctd_zxz;
					rk1m_Ctd_zxy_o0_t2_l0 = (-.5) * d_Ctd_xyz_o0_t1_m0_l0;
					rk1Ctd_zxy = (rk1m_Ctd_yxz_o0_t0_l0 + rk1m_Ctd_xyz_o0_t0_l0) + rk1m_Ctd_zxy_o0_t2_l0;
					rk1Ct_zxy = rk1gtu_xz * rk1Ctd_xxy + rk1gtu_yz * rk1Ctd_yxy + rk1gtu_zz * rk1Ctd_zxy;
					rk1Ct_yxy = rk1gtu_xy * rk1Ctd_xxy + rk1gtu_yy * rk1Ctd_yxy + rk1gtu_yz * rk1Ctd_zxy;
					rk1Ct_xxy = rk1gtu_xx * rk1Ctd_xxy + rk1gtu_xy * rk1Ctd_yxy + rk1gtu_xz * rk1Ctd_zxy;
					rk1Ct_xxz = rk1gtu_xx * rk1Ctd_xxz + rk1gtu_xy * rk1Ctd_yxz + rk1gtu_xz * rk1Ctd_zxz;
					rk1Ct_xyy = rk1gtu_xx * rk1Ctd_xyy + rk1gtu_xy * rk1Ctd_yyy + rk1gtu_xz * rk1Ctd_zyy;
					rk1m_Ctd_yxx_o0_t1_l0 = (-.5) * d_Ctd_xxy_o0_t0_m0_l0;
					rk1m_Ctd_yxx_o0_t0_l0 = 1.0 * d_Ctd_yxx_o0_t0_m0_l0;
					rk1Ctd_yxx = rk1m_Ctd_yxx_o0_t0_l0 + rk1m_Ctd_yxx_o0_t1_l0;
					rk1Ct_zxx = rk1gtu_xz * rk1Ctd_xxx + rk1gtu_yz * rk1Ctd_yxx + rk1gtu_zz * rk1Ctd_zxx;
					rk1Gamt_z = rk1gtu_xx * rk1Ct_zxx + 2.0 * rk1gtu_xy * rk1Ct_zxy + 2.0 * rk1gtu_xz * rk1Ct_zxz + rk1gtu_yy * rk1Ct_zyy + 2.0 * rk1gtu_yz * rk1Ct_zyz + rk1gtu_zz * rk1Ct_zzz;
					rk1Zu_z = .5 * rk1chi_max * (rk1(i, j, k, Gamh_z) - rk1Gamt_z);
					rk1Ct_yxx = rk1gtu_xy * rk1Ctd_xxx + rk1gtu_yy * rk1Ctd_yxx + rk1gtu_yz * rk1Ctd_zxx;
					rk1Gamt_y = rk1gtu_xx * rk1Ct_yxx + 2.0 * rk1gtu_xy * rk1Ct_yxy + 2.0 * rk1gtu_xz * rk1Ct_yxz + rk1gtu_yy * rk1Ct_yyy + 2.0 * rk1gtu_yz * rk1Ct_yyz + rk1gtu_zz * rk1Ct_yzz;
					rk1Zu_y = .5 * rk1chi_max * (rk1(i, j, k, Gamh_y) - rk1Gamt_y);
					rk1Ct_xxx = rk1gtu_xx * rk1Ctd_xxx + rk1gtu_xy * rk1Ctd_yxx + rk1gtu_xz * rk1Ctd_zxx;
					rk1Gamt_x = rk1gtu_xx * rk1Ct_xxx + 2.0 * rk1gtu_xy * rk1Ct_xxy + 2.0 * rk1gtu_xz * rk1Ct_xxz + rk1gtu_yy * rk1Ct_xyy + 2.0 * rk1gtu_yz * rk1Ct_xyz + rk1gtu_zz * rk1Ct_xzz;
					rk1Zu_x = .5 * rk1chi_max * (rk1(i, j, k, Gamh_x) - rk1Gamt_x);
					rk1d_Rtd_xx_o0_t9_m0_l0 = rk1gtu_zz * (3.0 * rk1Ct_xxz * rk1Ctd_xxz + 2.0 * rk1Ct_yxz * rk1Ctd_xyz + rk1Ct_yxz * rk1Ctd_yxz + 2.0 * rk1Ct_zxz * rk1Ctd_xzz + rk1Ct_zxz * rk1Ctd_zxz) + rk1gtu_yz * (3.0 * rk1Ct_xxy * rk1Ctd_xxz + 2.0 * rk1Ct_yxy * rk1Ctd_xyz + rk1Ct_yxy * rk1Ctd_yxz + 2.0 * rk1Ct_zxy * rk1Ctd_xzz + rk1Ct_zxy * rk1Ctd_zxz) + rk1gtu_xz * (3.0 * rk1Ct_xxx * rk1Ctd_xxz + 2.0 * rk1Ct_yxx * rk1Ctd_xyz + rk1Ct_yxx * rk1Ctd_yxz + 2.0 * rk1Ct_zxx * rk1Ctd_xzz + rk1Ct_zxx * rk1Ctd_zxz) + rk1gtu_yz * (3.0 * rk1Ct_xxz * rk1Ctd_xxy + 2.0 * rk1Ct_yxz * rk1Ctd_xyy + rk1Ct_yxz * rk1Ctd_yxy + 2.0 * rk1Ct_zxz * rk1Ctd_xyz + rk1Ct_zxz * rk1Ctd_zxy) + rk1gtu_yy * (3.0 * rk1Ct_xxy * rk1Ctd_xxy + 2.0 * rk1Ct_yxy * rk1Ctd_xyy + rk1Ct_yxy * rk1Ctd_yxy + 2.0 * rk1Ct_zxy * rk1Ctd_xyz + rk1Ct_zxy * rk1Ctd_zxy) + rk1gtu_xy * (3.0 * rk1Ct_xxx * rk1Ctd_xxy + 2.0 * rk1Ct_yxx * rk1Ctd_xyy + rk1Ct_yxx * rk1Ctd_yxy + 2.0 * rk1Ct_zxx * rk1Ctd_xyz + rk1Ct_zxx * rk1Ctd_zxy) + rk1gtu_xz * (3.0 * rk1Ct_xxz * rk1Ctd_xxx + 2.0 * rk1Ct_yxz * rk1Ctd_xxy + rk1Ct_yxz * rk1Ctd_yxx + 2.0 * rk1Ct_zxz * rk1Ctd_xxz + rk1Ct_zxz * rk1Ctd_zxx) + rk1gtu_xy * (3.0 * rk1Ct_xxy * rk1Ctd_xxx + 2.0 * rk1Ct_yxy * rk1Ctd_xxy + rk1Ct_yxy * rk1Ctd_yxx + 2.0 * rk1Ct_zxy * rk1Ctd_xxz + rk1Ct_zxy * rk1Ctd_zxx) + rk1gtu_xx * (3.0 * rk1Ct_xxx * rk1Ctd_xxx + 2.0 * rk1Ct_yxx * rk1Ctd_xxy + rk1Ct_yxx * rk1Ctd_yxx + 2.0 * rk1Ct_zxx * rk1Ctd_xxz + rk1Ct_zxx * rk1Ctd_zxx) + 1.0 * rk1(i, j, k, Gamh_z) * rk1Ctd_xxz + 1.0 * rk1(i, j, k, Gamh_y) * rk1Ctd_xxy + 1.0 * rk1(i, j, k, Gamh_x) * rk1Ctd_xxx;
					rk1m_Rtd_xx_o0_t8_l0 = 1.0 * rk1(i, j, k, gtd_xz) * d_Rtd_xx_o0_t8_m0_l0;
					rk1m_Rtd_xx_o0_t7_l0 = 1.0 * rk1(i, j, k, gtd_xy) * d_Rtd_xx_o0_t7_m0_l0;
					rk1m_Rtd_xx_o0_t6_l0 = 1.0 * rk1(i, j, k, gtd_xx) * d_Rtd_xx_o0_t6_m0_l0;
					rk1m_Rtd_xx_o0_t5_l0 = (-.5 * rk1gtu_zz) * d_Rtd_xx_o0_t5_m0_l0;
					rk1m_Rtd_xx_o0_t4_l0 = (-1.0 * rk1gtu_yz) * d_Rtd_xx_o0_t4_m0_l0;
					rk1m_Rtd_xx_o0_t3_l0 = (-.5 * rk1gtu_yy) * d_Rtd_xx_o0_t3_m0_l0;
					rk1m_Rtd_xx_o0_t2_l0 = (-1.0 * rk1gtu_xz) * d_Rtd_xx_o0_t2_m0_l0;
					rk1m_Rtd_xx_o0_t1_l0 = (-1.0 * rk1gtu_xy) * d_Rtd_xx_o0_t1_m0_l0;
					rk1m_Rtd_xx_o0_t0_l0 = (-.5 * rk1gtu_xx) * d_Rtd_xx_o0_t0_m0_l0;
					rk1Rtd_xx = ((((((((rk1m_Rtd_xx_o0_t0_l0 + rk1m_Rtd_xx_o0_t1_l0) + rk1m_Rtd_xx_o0_t2_l0) + rk1m_Rtd_xx_o0_t3_l0) + rk1m_Rtd_xx_o0_t4_l0) + rk1m_Rtd_xx_o0_t5_l0) + rk1m_Rtd_xx_o0_t6_l0) + rk1m_Rtd_xx_o0_t7_l0) + rk1m_Rtd_xx_o0_t8_l0) + rk1d_Rtd_xx_o0_t9_m0_l0;
					rk1d_Rtd_xz_o0_t12_m0_l0 = rk1gtu_zz * (rk1Ct_xxz * rk1Ctd_zxz + rk1Ct_xxz * rk1Ctd_xzz + rk1Ct_xzz * rk1Ctd_xxz + rk1Ct_yxz * rk1Ctd_zyz + rk1Ct_yxz * rk1Ctd_yzz + rk1Ct_yzz * rk1Ctd_xyz + 2.0 * rk1Ct_zxz * rk1Ctd_zzz + rk1Ct_zzz * rk1Ctd_xzz) + rk1gtu_yz * (rk1Ct_xxy * rk1Ctd_zxz + rk1Ct_xxy * rk1Ctd_xzz + rk1Ct_xyz * rk1Ctd_xxz + rk1Ct_yxy * rk1Ctd_zyz + rk1Ct_yxy * rk1Ctd_yzz + rk1Ct_yyz * rk1Ctd_xyz + 2.0 * rk1Ct_zxy * rk1Ctd_zzz + rk1Ct_zyz * rk1Ctd_xzz) + rk1gtu_xz * (rk1Ct_xxx * rk1Ctd_zxz + rk1Ct_xxx * rk1Ctd_xzz + rk1Ct_xxz * rk1Ctd_xxz + rk1Ct_yxx * rk1Ctd_zyz + rk1Ct_yxx * rk1Ctd_yzz + rk1Ct_yxz * rk1Ctd_xyz + 2.0 * rk1Ct_zxx * rk1Ctd_zzz + rk1Ct_zxz * rk1Ctd_xzz) + rk1gtu_yz * (rk1Ct_xxz * rk1Ctd_zxy + rk1Ct_xxz * rk1Ctd_xyz + rk1Ct_xzz * rk1Ctd_xxy + rk1Ct_yxz * rk1Ctd_zyy + rk1Ct_yxz * rk1Ctd_yyz + rk1Ct_yzz * rk1Ctd_xyy + 2.0 * rk1Ct_zxz * rk1Ctd_zyz + rk1Ct_zzz * rk1Ctd_xyz) + rk1gtu_yy * (rk1Ct_xxy * rk1Ctd_zxy + rk1Ct_xxy * rk1Ctd_xyz + rk1Ct_xyz * rk1Ctd_xxy + rk1Ct_yxy * rk1Ctd_zyy + rk1Ct_yxy * rk1Ctd_yyz + rk1Ct_yyz * rk1Ctd_xyy + 2.0 * rk1Ct_zxy * rk1Ctd_zyz + rk1Ct_zyz * rk1Ctd_xyz) + rk1gtu_xy * (rk1Ct_xxx * rk1Ctd_zxy + rk1Ct_xxx * rk1Ctd_xyz + rk1Ct_xxz * rk1Ctd_xxy + rk1Ct_yxx * rk1Ctd_zyy + rk1Ct_yxx * rk1Ctd_yyz + rk1Ct_yxz * rk1Ctd_xyy + 2.0 * rk1Ct_zxx * rk1Ctd_zyz + rk1Ct_zxz * rk1Ctd_xyz) + rk1gtu_xz * (rk1Ct_xxz * rk1Ctd_zxx + rk1Ct_xxz * rk1Ctd_xxz + rk1Ct_xzz * rk1Ctd_xxx + rk1Ct_yxz * rk1Ctd_zxy + rk1Ct_yxz * rk1Ctd_yxz + rk1Ct_yzz * rk1Ctd_xxy + 2.0 * rk1Ct_zxz * rk1Ctd_zxz + rk1Ct_zzz * rk1Ctd_xxz) + rk1gtu_xy * (rk1Ct_xxy * rk1Ctd_zxx + rk1Ct_xxy * rk1Ctd_xxz + rk1Ct_xyz * rk1Ctd_xxx + rk1Ct_yxy * rk1Ctd_zxy + rk1Ct_yxy * rk1Ctd_yxz + rk1Ct_yyz * rk1Ctd_xxy + 2.0 * rk1Ct_zxy * rk1Ctd_zxz + rk1Ct_zyz * rk1Ctd_xxz) + rk1gtu_xx * (rk1Ct_xxx * rk1Ctd_zxx + rk1Ct_xxx * rk1Ctd_xxz + rk1Ct_xxz * rk1Ctd_xxx + rk1Ct_yxx * rk1Ctd_zxy + rk1Ct_yxx * rk1Ctd_yxz + rk1Ct_yxz * rk1Ctd_xxy + 2.0 * rk1Ct_zxx * rk1Ctd_zxz + rk1Ct_zxz * rk1Ctd_xxz) + .5 * rk1(i, j, k, Gamh_z) * (rk1Ctd_xzz + rk1Ctd_zxz) + .5 * rk1(i, j, k, Gamh_y) * (rk1Ctd_xyz + rk1Ctd_zxy) + .5 * rk1(i, j, k, Gamh_x) * (rk1Ctd_xxz + rk1Ctd_zxx);
					rk1m_Rtd_xz_o0_t11_l0 = .5 * rk1(i, j, k, gtd_zz) * d_Rtd_xx_o0_t8_m0_l0;
					rk1m_Rtd_xz_o0_t10_l0 = .5 * rk1(i, j, k, gtd_yz) * d_Rtd_xx_o0_t7_m0_l0;
					rk1m_Rtd_xz_o0_t9_l0 = .5 * rk1(i, j, k, gtd_xz) * d_Rtd_xx_o0_t6_m0_l0;
					rk1m_Rtd_xz_o0_t8_l0 = .5 * rk1(i, j, k, gtd_xz) * d_Rtd_xz_o0_t8_m0_l0;
					rk1m_Rtd_xz_o0_t7_l0 = .5 * rk1(i, j, k, gtd_xy) * d_Rtd_xz_o0_t7_m0_l0;
					rk1m_Rtd_xz_o0_t6_l0 = .5 * rk1(i, j, k, gtd_xx) * d_Rtd_xz_o0_t6_m0_l0;
					rk1m_Rtd_xz_o0_t5_l0 = (-.5 * rk1gtu_zz) * d_Rtd_xz_o0_t5_m0_l0;
					rk1m_Rtd_xz_o0_t4_l0 = (-1.0 * rk1gtu_yz) * d_Rtd_xz_o0_t4_m0_l0;
					rk1m_Rtd_xz_o0_t3_l0 = (-.5 * rk1gtu_yy) * d_Rtd_xz_o0_t3_m0_l0;
					rk1m_Rtd_xz_o0_t2_l0 = (-1.0 * rk1gtu_xz) * d_Rtd_xz_o0_t2_m0_l0;
					rk1m_Rtd_xz_o0_t1_l0 = (-1.0 * rk1gtu_xy) * d_Rtd_xz_o0_t1_m0_l0;
					rk1m_Rtd_xz_o0_t0_l0 = (-.5 * rk1gtu_xx) * d_Rtd_xz_o0_t0_m0_l0;
					rk1Rtd_xz = (((((((((((rk1m_Rtd_xz_o0_t0_l0 + rk1m_Rtd_xz_o0_t1_l0) + rk1m_Rtd_xz_o0_t2_l0) + rk1m_Rtd_xz_o0_t3_l0) + rk1m_Rtd_xz_o0_t4_l0) + rk1m_Rtd_xz_o0_t5_l0) + rk1m_Rtd_xz_o0_t6_l0) + rk1m_Rtd_xz_o0_t7_l0) + rk1m_Rtd_xz_o0_t8_l0) + rk1m_Rtd_xz_o0_t9_l0) + rk1m_Rtd_xz_o0_t10_l0) + rk1m_Rtd_xz_o0_t11_l0) + rk1d_Rtd_xz_o0_t12_m0_l0;
					rk1d_Rtd_zz_o0_t9_m0_l0 = rk1gtu_zz * (2.0 * rk1Ct_xzz * rk1Ctd_zxz + rk1Ct_xzz * rk1Ctd_xzz + 2.0 * rk1Ct_yzz * rk1Ctd_zyz + rk1Ct_yzz * rk1Ctd_yzz + 3.0 * rk1Ct_zzz * rk1Ctd_zzz) + rk1gtu_yz * (2.0 * rk1Ct_xyz * rk1Ctd_zxz + rk1Ct_xyz * rk1Ctd_xzz + 2.0 * rk1Ct_yyz * rk1Ctd_zyz + rk1Ct_yyz * rk1Ctd_yzz + 3.0 * rk1Ct_zyz * rk1Ctd_zzz) + rk1gtu_xz * (2.0 * rk1Ct_xxz * rk1Ctd_zxz + rk1Ct_xxz * rk1Ctd_xzz + 2.0 * rk1Ct_yxz * rk1Ctd_zyz + rk1Ct_yxz * rk1Ctd_yzz + 3.0 * rk1Ct_zxz * rk1Ctd_zzz) + rk1gtu_yz * (2.0 * rk1Ct_xzz * rk1Ctd_zxy + rk1Ct_xzz * rk1Ctd_xyz + 2.0 * rk1Ct_yzz * rk1Ctd_zyy + rk1Ct_yzz * rk1Ctd_yyz + 3.0 * rk1Ct_zzz * rk1Ctd_zyz) + rk1gtu_yy * (2.0 * rk1Ct_xyz * rk1Ctd_zxy + rk1Ct_xyz * rk1Ctd_xyz + 2.0 * rk1Ct_yyz * rk1Ctd_zyy + rk1Ct_yyz * rk1Ctd_yyz + 3.0 * rk1Ct_zyz * rk1Ctd_zyz) + rk1gtu_xy * (2.0 * rk1Ct_xxz * rk1Ctd_zxy + rk1Ct_xxz * rk1Ctd_xyz + 2.0 * rk1Ct_yxz * rk1Ctd_zyy + rk1Ct_yxz * rk1Ctd_yyz + 3.0 * rk1Ct_zxz * rk1Ctd_zyz) + rk1gtu_xz * (2.0 * rk1Ct_xzz * rk1Ctd_zxx + rk1Ct_xzz * rk1Ctd_xxz + 2.0 * rk1Ct_yzz * rk1Ctd_zxy + rk1Ct_yzz * rk1Ctd_yxz + 3.0 * rk1Ct_zzz * rk1Ctd_zxz) + rk1gtu_xy * (2.0 * rk1Ct_xyz * rk1Ctd_zxx + rk1Ct_xyz * rk1Ctd_xxz + 2.0 * rk1Ct_yyz * rk1Ctd_zxy + rk1Ct_yyz * rk1Ctd_yxz + 3.0 * rk1Ct_zyz * rk1Ctd_zxz) + rk1gtu_xx * (2.0 * rk1Ct_xxz * rk1Ctd_zxx + rk1Ct_xxz * rk1Ctd_xxz + 2.0 * rk1Ct_yxz * rk1Ctd_zxy + rk1Ct_yxz * rk1Ctd_yxz + 3.0 * rk1Ct_zxz * rk1Ctd_zxz) + 1.0 * rk1(i, j, k, Gamh_z) * rk1Ctd_zzz + 1.0 * rk1(i, j, k, Gamh_y) * rk1Ctd_zyz + 1.0 * rk1(i, j, k, Gamh_x) * rk1Ctd_zxz;
					rk1m_Rtd_zz_o0_t8_l0 = 1.0 * rk1(i, j, k, gtd_zz) * d_Rtd_xz_o0_t8_m0_l0;
					rk1m_Rtd_zz_o0_t7_l0 = 1.0 * rk1(i, j, k, gtd_yz) * d_Rtd_xz_o0_t7_m0_l0;
					rk1m_Rtd_zz_o0_t6_l0 = 1.0 * rk1(i, j, k, gtd_xz) * d_Rtd_xz_o0_t6_m0_l0;
					rk1m_Rtd_zz_o0_t5_l0 = (-.5 * rk1gtu_zz) * d_Rtd_zz_o0_t5_m0_l0;
					rk1m_Rtd_zz_o0_t4_l0 = (-1.0 * rk1gtu_yz) * d_Rtd_zz_o0_t4_m0_l0;
					rk1m_Rtd_zz_o0_t3_l0 = (-.5 * rk1gtu_yy) * d_Rtd_zz_o0_t3_m0_l0;
					rk1m_Rtd_zz_o0_t2_l0 = (-1.0 * rk1gtu_xz) * d_Rtd_zz_o0_t2_m0_l0;
					rk1m_Rtd_zz_o0_t1_l0 = (-1.0 * rk1gtu_xy) * d_Rtd_zz_o0_t1_m0_l0;
					rk1m_Rtd_zz_o0_t0_l0 = (-.5 * rk1gtu_xx) * d_Rtd_zz_o0_t0_m0_l0;
					rk1Rtd_zz = ((((((((rk1m_Rtd_zz_o0_t0_l0 + rk1m_Rtd_zz_o0_t1_l0) + rk1m_Rtd_zz_o0_t2_l0) + rk1m_Rtd_zz_o0_t3_l0) + rk1m_Rtd_zz_o0_t4_l0) + rk1m_Rtd_zz_o0_t5_l0) + rk1m_Rtd_zz_o0_t6_l0) + rk1m_Rtd_zz_o0_t7_l0) + rk1m_Rtd_zz_o0_t8_l0) + rk1d_Rtd_zz_o0_t9_m0_l0;
					rk1d_Rtd_xy_o0_t12_m0_l0 = rk1gtu_zz * (rk1Ct_xxz * rk1Ctd_yxz + rk1Ct_xxz * rk1Ctd_xyz + rk1Ct_xyz * rk1Ctd_xxz + 2.0 * rk1Ct_yxz * rk1Ctd_yyz + rk1Ct_yyz * rk1Ctd_xyz + rk1Ct_zxz * rk1Ctd_yzz + rk1Ct_zxz * rk1Ctd_zyz + rk1Ct_zyz * rk1Ctd_xzz) + rk1gtu_yz * (rk1Ct_xxy * rk1Ctd_yxz + rk1Ct_xxy * rk1Ctd_xyz + rk1Ct_xyy * rk1Ctd_xxz + 2.0 * rk1Ct_yxy * rk1Ctd_yyz + rk1Ct_yyy * rk1Ctd_xyz + rk1Ct_zxy * rk1Ctd_yzz + rk1Ct_zxy * rk1Ctd_zyz + rk1Ct_zyy * rk1Ctd_xzz) + rk1gtu_xz * (rk1Ct_xxx * rk1Ctd_yxz + rk1Ct_xxx * rk1Ctd_xyz + rk1Ct_xxy * rk1Ctd_xxz + 2.0 * rk1Ct_yxx * rk1Ctd_yyz + rk1Ct_yxy * rk1Ctd_xyz + rk1Ct_zxx * rk1Ctd_yzz + rk1Ct_zxx * rk1Ctd_zyz + rk1Ct_zxy * rk1Ctd_xzz) + rk1gtu_yz * (rk1Ct_xxz * rk1Ctd_yxy + rk1Ct_xxz * rk1Ctd_xyy + rk1Ct_xyz * rk1Ctd_xxy + 2.0 * rk1Ct_yxz * rk1Ctd_yyy + rk1Ct_yyz * rk1Ctd_xyy + rk1Ct_zxz * rk1Ctd_yyz + rk1Ct_zxz * rk1Ctd_zyy + rk1Ct_zyz * rk1Ctd_xyz) + rk1gtu_yy * (rk1Ct_xxy * rk1Ctd_yxy + rk1Ct_xxy * rk1Ctd_xyy + rk1Ct_xyy * rk1Ctd_xxy + 2.0 * rk1Ct_yxy * rk1Ctd_yyy + rk1Ct_yyy * rk1Ctd_xyy + rk1Ct_zxy * rk1Ctd_yyz + rk1Ct_zxy * rk1Ctd_zyy + rk1Ct_zyy * rk1Ctd_xyz) + rk1gtu_xy * (rk1Ct_xxx * rk1Ctd_yxy + rk1Ct_xxx * rk1Ctd_xyy + rk1Ct_xxy * rk1Ctd_xxy + 2.0 * rk1Ct_yxx * rk1Ctd_yyy + rk1Ct_yxy * rk1Ctd_xyy + rk1Ct_zxx * rk1Ctd_yyz + rk1Ct_zxx * rk1Ctd_zyy + rk1Ct_zxy * rk1Ctd_xyz) + rk1gtu_xz * (rk1Ct_xxz * rk1Ctd_yxx + rk1Ct_xxz * rk1Ctd_xxy + rk1Ct_xyz * rk1Ctd_xxx + 2.0 * rk1Ct_yxz * rk1Ctd_yxy + rk1Ct_yyz * rk1Ctd_xxy + rk1Ct_zxz * rk1Ctd_yxz + rk1Ct_zxz * rk1Ctd_zxy + rk1Ct_zyz * rk1Ctd_xxz) + rk1gtu_xy * (rk1Ct_xxy * rk1Ctd_yxx + rk1Ct_xxy * rk1Ctd_xxy + rk1Ct_xyy * rk1Ctd_xxx + 2.0 * rk1Ct_yxy * rk1Ctd_yxy + rk1Ct_yyy * rk1Ctd_xxy + rk1Ct_zxy * rk1Ctd_yxz + rk1Ct_zxy * rk1Ctd_zxy + rk1Ct_zyy * rk1Ctd_xxz) + rk1gtu_xx * (rk1Ct_xxx * rk1Ctd_yxx + rk1Ct_xxx * rk1Ctd_xxy + rk1Ct_xxy * rk1Ctd_xxx + 2.0 * rk1Ct_yxx * rk1Ctd_yxy + rk1Ct_yxy * rk1Ctd_xxy + rk1Ct_zxx * rk1Ctd_yxz + rk1Ct_zxx * rk1Ctd_zxy + rk1Ct_zxy * rk1Ctd_xxz) + .5 * rk1(i, j, k, Gamh_z) * (rk1Ctd_xyz + rk1Ctd_yxz) + .5 * rk1(i, j, k, Gamh_y) * (rk1Ctd_xyy + rk1Ctd_yxy) + .5 * rk1(i, j, k, Gamh_x) * (rk1Ctd_xxy + rk1Ctd_yxx);
					rk1m_Rtd_xy_o0_t11_l0 = .5 * rk1(i, j, k, gtd_yz) * d_Rtd_xx_o0_t8_m0_l0;
					rk1m_Rtd_xy_o0_t10_l0 = .5 * rk1(i, j, k, gtd_yy) * d_Rtd_xx_o0_t7_m0_l0;
					rk1m_Rtd_xy_o0_t9_l0 = .5 * rk1(i, j, k, gtd_xy) * d_Rtd_xx_o0_t6_m0_l0;
					rk1m_Rtd_xy_o0_t8_l0 = .5 * rk1(i, j, k, gtd_xz) * d_Rtd_xy_o0_t8_m0_l0;
					rk1m_Rtd_xy_o0_t7_l0 = .5 * rk1(i, j, k, gtd_xy) * d_Rtd_xy_o0_t7_m0_l0;
					rk1m_Rtd_xy_o0_t6_l0 = .5 * rk1(i, j, k, gtd_xx) * d_Rtd_xy_o0_t6_m0_l0;
					rk1m_Rtd_xy_o0_t5_l0 = (-.5 * rk1gtu_zz) * d_Rtd_xy_o0_t5_m0_l0;
					rk1m_Rtd_xy_o0_t4_l0 = (-1.0 * rk1gtu_yz) * d_Rtd_xy_o0_t4_m0_l0;
					rk1m_Rtd_xy_o0_t3_l0 = (-.5 * rk1gtu_yy) * d_Rtd_xy_o0_t3_m0_l0;
					rk1m_Rtd_xy_o0_t2_l0 = (-1.0 * rk1gtu_xz) * d_Rtd_xy_o0_t2_m0_l0;
					rk1m_Rtd_xy_o0_t1_l0 = (-1.0 * rk1gtu_xy) * d_Rtd_xy_o0_t1_m0_l0;
					rk1m_Rtd_xy_o0_t0_l0 = (-.5 * rk1gtu_xx) * d_Rtd_xy_o0_t0_m0_l0;
					rk1Rtd_xy = (((((((((((rk1m_Rtd_xy_o0_t0_l0 + rk1m_Rtd_xy_o0_t1_l0) + rk1m_Rtd_xy_o0_t2_l0) + rk1m_Rtd_xy_o0_t3_l0) + rk1m_Rtd_xy_o0_t4_l0) + rk1m_Rtd_xy_o0_t5_l0) + rk1m_Rtd_xy_o0_t6_l0) + rk1m_Rtd_xy_o0_t7_l0) + rk1m_Rtd_xy_o0_t8_l0) + rk1m_Rtd_xy_o0_t9_l0) + rk1m_Rtd_xy_o0_t10_l0) + rk1m_Rtd_xy_o0_t11_l0) + rk1d_Rtd_xy_o0_t12_m0_l0;
					rk1d_Rtd_yy_o0_t9_m0_l0 = rk1gtu_zz * (2.0 * rk1Ct_xyz * rk1Ctd_yxz + rk1Ct_xyz * rk1Ctd_xyz + 3.0 * rk1Ct_yyz * rk1Ctd_yyz + 2.0 * rk1Ct_zyz * rk1Ctd_yzz + rk1Ct_zyz * rk1Ctd_zyz) + rk1gtu_yz * (2.0 * rk1Ct_xyy * rk1Ctd_yxz + rk1Ct_xyy * rk1Ctd_xyz + 3.0 * rk1Ct_yyy * rk1Ctd_yyz + 2.0 * rk1Ct_zyy * rk1Ctd_yzz + rk1Ct_zyy * rk1Ctd_zyz) + rk1gtu_xz * (2.0 * rk1Ct_xxy * rk1Ctd_yxz + rk1Ct_xxy * rk1Ctd_xyz + 3.0 * rk1Ct_yxy * rk1Ctd_yyz + 2.0 * rk1Ct_zxy * rk1Ctd_yzz + rk1Ct_zxy * rk1Ctd_zyz) + rk1gtu_yz * (2.0 * rk1Ct_xyz * rk1Ctd_yxy + rk1Ct_xyz * rk1Ctd_xyy + 3.0 * rk1Ct_yyz * rk1Ctd_yyy + 2.0 * rk1Ct_zyz * rk1Ctd_yyz + rk1Ct_zyz * rk1Ctd_zyy) + rk1gtu_yy * (2.0 * rk1Ct_xyy * rk1Ctd_yxy + rk1Ct_xyy * rk1Ctd_xyy + 3.0 * rk1Ct_yyy * rk1Ctd_yyy + 2.0 * rk1Ct_zyy * rk1Ctd_yyz + rk1Ct_zyy * rk1Ctd_zyy) + rk1gtu_xy * (2.0 * rk1Ct_xxy * rk1Ctd_yxy + rk1Ct_xxy * rk1Ctd_xyy + 3.0 * rk1Ct_yxy * rk1Ctd_yyy + 2.0 * rk1Ct_zxy * rk1Ctd_yyz + rk1Ct_zxy * rk1Ctd_zyy) + rk1gtu_xz * (2.0 * rk1Ct_xyz * rk1Ctd_yxx + rk1Ct_xyz * rk1Ctd_xxy + 3.0 * rk1Ct_yyz * rk1Ctd_yxy + 2.0 * rk1Ct_zyz * rk1Ctd_yxz + rk1Ct_zyz * rk1Ctd_zxy) + rk1gtu_xy * (2.0 * rk1Ct_xyy * rk1Ctd_yxx + rk1Ct_xyy * rk1Ctd_xxy + 3.0 * rk1Ct_yyy * rk1Ctd_yxy + 2.0 * rk1Ct_zyy * rk1Ctd_yxz + rk1Ct_zyy * rk1Ctd_zxy) + rk1gtu_xx * (2.0 * rk1Ct_xxy * rk1Ctd_yxx + rk1Ct_xxy * rk1Ctd_xxy + 3.0 * rk1Ct_yxy * rk1Ctd_yxy + 2.0 * rk1Ct_zxy * rk1Ctd_yxz + rk1Ct_zxy * rk1Ctd_zxy) + 1.0 * rk1(i, j, k, Gamh_z) * rk1Ctd_yyz + 1.0 * rk1(i, j, k, Gamh_y) * rk1Ctd_yyy + 1.0 * rk1(i, j, k, Gamh_x) * rk1Ctd_yxy;
					rk1m_Rtd_yy_o0_t8_l0 = 1.0 * rk1(i, j, k, gtd_yz) * d_Rtd_xy_o0_t8_m0_l0;
					rk1m_Rtd_yy_o0_t7_l0 = 1.0 * rk1(i, j, k, gtd_yy) * d_Rtd_xy_o0_t7_m0_l0;
					rk1m_Rtd_yy_o0_t6_l0 = 1.0 * rk1(i, j, k, gtd_xy) * d_Rtd_xy_o0_t6_m0_l0;
					rk1m_Rtd_yy_o0_t5_l0 = (-.5 * rk1gtu_zz) * d_Rtd_yy_o0_t5_m0_l0;
					rk1m_Rtd_yy_o0_t4_l0 = (-1.0 * rk1gtu_yz) * d_Rtd_yy_o0_t4_m0_l0;
					rk1m_Rtd_yy_o0_t3_l0 = (-.5 * rk1gtu_yy) * d_Rtd_yy_o0_t3_m0_l0;
					rk1m_Rtd_yy_o0_t2_l0 = (-1.0 * rk1gtu_xz) * d_Rtd_yy_o0_t2_m0_l0;
					rk1m_Rtd_yy_o0_t1_l0 = (-1.0 * rk1gtu_xy) * d_Rtd_yy_o0_t1_m0_l0;
					rk1m_Rtd_yy_o0_t0_l0 = (-.5 * rk1gtu_xx) * d_Rtd_yy_o0_t0_m0_l0;
					rk1Rtd_yy = ((((((((rk1m_Rtd_yy_o0_t0_l0 + rk1m_Rtd_yy_o0_t1_l0) + rk1m_Rtd_yy_o0_t2_l0) + rk1m_Rtd_yy_o0_t3_l0) + rk1m_Rtd_yy_o0_t4_l0) + rk1m_Rtd_yy_o0_t5_l0) + rk1m_Rtd_yy_o0_t6_l0) + rk1m_Rtd_yy_o0_t7_l0) + rk1m_Rtd_yy_o0_t8_l0) + rk1d_Rtd_yy_o0_t9_m0_l0;
					rk1d_Rtd_yz_o0_t12_m0_l0 = rk1gtu_zz * (rk1Ct_xyz * rk1Ctd_zxz + rk1Ct_xyz * rk1Ctd_xzz + rk1Ct_xzz * rk1Ctd_yxz + rk1Ct_yyz * rk1Ctd_zyz + rk1Ct_yyz * rk1Ctd_yzz + rk1Ct_yzz * rk1Ctd_yyz + 2.0 * rk1Ct_zyz * rk1Ctd_zzz + rk1Ct_zzz * rk1Ctd_yzz) + rk1gtu_yz * (rk1Ct_xyy * rk1Ctd_zxz + rk1Ct_xyy * rk1Ctd_xzz + rk1Ct_xyz * rk1Ctd_yxz + rk1Ct_yyy * rk1Ctd_zyz + rk1Ct_yyy * rk1Ctd_yzz + rk1Ct_yyz * rk1Ctd_yyz + 2.0 * rk1Ct_zyy * rk1Ctd_zzz + rk1Ct_zyz * rk1Ctd_yzz) + rk1gtu_xz * (rk1Ct_xxy * rk1Ctd_zxz + rk1Ct_xxy * rk1Ctd_xzz + rk1Ct_xxz * rk1Ctd_yxz + rk1Ct_yxy * rk1Ctd_zyz + rk1Ct_yxy * rk1Ctd_yzz + rk1Ct_yxz * rk1Ctd_yyz + 2.0 * rk1Ct_zxy * rk1Ctd_zzz + rk1Ct_zxz * rk1Ctd_yzz) + rk1gtu_yz * (rk1Ct_xyz * rk1Ctd_zxy + rk1Ct_xyz * rk1Ctd_xyz + rk1Ct_xzz * rk1Ctd_yxy + rk1Ct_yyz * rk1Ctd_zyy + rk1Ct_yyz * rk1Ctd_yyz + rk1Ct_yzz * rk1Ctd_yyy + 2.0 * rk1Ct_zyz * rk1Ctd_zyz + rk1Ct_zzz * rk1Ctd_yyz) + rk1gtu_yy * (rk1Ct_xyy * rk1Ctd_zxy + rk1Ct_xyy * rk1Ctd_xyz + rk1Ct_xyz * rk1Ctd_yxy + rk1Ct_yyy * rk1Ctd_zyy + rk1Ct_yyy * rk1Ctd_yyz + rk1Ct_yyz * rk1Ctd_yyy + 2.0 * rk1Ct_zyy * rk1Ctd_zyz + rk1Ct_zyz * rk1Ctd_yyz) + rk1gtu_xy * (rk1Ct_xxy * rk1Ctd_zxy + rk1Ct_xxy * rk1Ctd_xyz + rk1Ct_xxz * rk1Ctd_yxy + rk1Ct_yxy * rk1Ctd_zyy + rk1Ct_yxy * rk1Ctd_yyz + rk1Ct_yxz * rk1Ctd_yyy + 2.0 * rk1Ct_zxy * rk1Ctd_zyz + rk1Ct_zxz * rk1Ctd_yyz) + rk1gtu_xz * (rk1Ct_xyz * rk1Ctd_zxx + rk1Ct_xyz * rk1Ctd_xxz + rk1Ct_xzz * rk1Ctd_yxx + rk1Ct_yyz * rk1Ctd_zxy + rk1Ct_yyz * rk1Ctd_yxz + rk1Ct_yzz * rk1Ctd_yxy + 2.0 * rk1Ct_zyz * rk1Ctd_zxz + rk1Ct_zzz * rk1Ctd_yxz) + rk1gtu_xy * (rk1Ct_xyy * rk1Ctd_zxx + rk1Ct_xyy * rk1Ctd_xxz + rk1Ct_xyz * rk1Ctd_yxx + rk1Ct_yyy * rk1Ctd_zxy + rk1Ct_yyy * rk1Ctd_yxz + rk1Ct_yyz * rk1Ctd_yxy + 2.0 * rk1Ct_zyy * rk1Ctd_zxz + rk1Ct_zyz * rk1Ctd_yxz) + rk1gtu_xx * (rk1Ct_xxy * rk1Ctd_zxx + rk1Ct_xxy * rk1Ctd_xxz + rk1Ct_xxz * rk1Ctd_yxx + rk1Ct_yxy * rk1Ctd_zxy + rk1Ct_yxy * rk1Ctd_yxz + rk1Ct_yxz * rk1Ctd_yxy + 2.0 * rk1Ct_zxy * rk1Ctd_zxz + rk1Ct_zxz * rk1Ctd_yxz) + .5 * rk1(i, j, k, Gamh_z) * (rk1Ctd_yzz + rk1Ctd_zyz) + .5 * rk1(i, j, k, Gamh_y) * (rk1Ctd_yyz + rk1Ctd_zyy) + .5 * rk1(i, j, k, Gamh_x) * (rk1Ctd_yxz + rk1Ctd_zxy);
					rk1m_Rtd_yz_o0_t11_l0 = .5 * rk1(i, j, k, gtd_zz) * d_Rtd_xy_o0_t8_m0_l0;
					rk1m_Rtd_yz_o0_t10_l0 = .5 * rk1(i, j, k, gtd_yz) * d_Rtd_xy_o0_t7_m0_l0;
					rk1m_Rtd_yz_o0_t9_l0 = .5 * rk1(i, j, k, gtd_xz) * d_Rtd_xy_o0_t6_m0_l0;
					rk1m_Rtd_yz_o0_t8_l0 = .5 * rk1(i, j, k, gtd_yz) * d_Rtd_xz_o0_t8_m0_l0;
					rk1m_Rtd_yz_o0_t7_l0 = .5 * rk1(i, j, k, gtd_yy) * d_Rtd_xz_o0_t7_m0_l0;
					rk1m_Rtd_yz_o0_t6_l0 = .5 * rk1(i, j, k, gtd_xy) * d_Rtd_xz_o0_t6_m0_l0;
					rk1m_Rtd_yz_o0_t5_l0 = (-.5 * rk1gtu_zz) * d_Rtd_yz_o0_t5_m0_l0;
					rk1m_Rtd_yz_o0_t4_l0 = (-1.0 * rk1gtu_yz) * d_Rtd_yz_o0_t4_m0_l0;
					rk1m_Rtd_yz_o0_t3_l0 = (-.5 * rk1gtu_yy) * d_Rtd_yz_o0_t3_m0_l0;
					rk1m_Rtd_yz_o0_t2_l0 = (-1.0 * rk1gtu_xz) * d_Rtd_yz_o0_t2_m0_l0;
					rk1m_Rtd_yz_o0_t1_l0 = (-1.0 * rk1gtu_xy) * d_Rtd_yz_o0_t1_m0_l0;
					rk1m_Rtd_yz_o0_t0_l0 = (-.5 * rk1gtu_xx) * d_Rtd_yz_o0_t0_m0_l0;
					rk1Rtd_yz = (((((((((((rk1m_Rtd_yz_o0_t0_l0 + rk1m_Rtd_yz_o0_t1_l0) + rk1m_Rtd_yz_o0_t2_l0) + rk1m_Rtd_yz_o0_t3_l0) + rk1m_Rtd_yz_o0_t4_l0) + rk1m_Rtd_yz_o0_t5_l0) + rk1m_Rtd_yz_o0_t6_l0) + rk1m_Rtd_yz_o0_t7_l0) + rk1m_Rtd_yz_o0_t8_l0) + rk1m_Rtd_yz_o0_t9_l0) + rk1m_Rtd_yz_o0_t10_l0) + rk1m_Rtd_yz_o0_t11_l0) + rk1d_Rtd_yz_o0_t12_m0_l0;
					rk1m_Rpd_xx_o0_t22_l0 = .5 * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_xx_o0_t21_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xx) * rk1gtu_zz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xx_o0_t20_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xx) * rk1gtu_yy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xx_o0_t19_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xx) * rk1gtu_xx * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t18_l0 = 2.0 * rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_xz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t17_l0 = 2.0 * rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_xy) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t16_l0 = 2.0 * rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xx) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t15_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xx) * rk1gtu_yz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xx_o0_t14_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xx) * rk1gtu_xz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t13_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xx) * rk1gtu_xy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t12_l0 = (-.2500000000000000 * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t11_l0 = (-.5 * rk1Ct_zxx) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xx_o0_t10_l0 = (-.5 * rk1Ct_yxx) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xx_o0_t9_l0 = (-.5 * rk1Ct_xxx) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xx_o0_t8_l0 = .5 * rk1(i, j, k, gtd_xx) * rk1gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_xx_o0_t7_l0 = 1.0 * rk1(i, j, k, gtd_xx) * rk1gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_xx_o0_t6_l0 = .5 * rk1(i, j, k, gtd_xx) * rk1gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_xx_o0_t5_l0 = 1.0 * rk1(i, j, k, gtd_xx) * rk1gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_xx_o0_t4_l0 = 1.0 * rk1(i, j, k, gtd_xx) * rk1gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_xx_o0_t3_l0 = .5 * rk1(i, j, k, gtd_xx) * rk1gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_xx_o0_t2_l0 = (-.5 * rk1(i, j, k, gtd_xx) * rk1(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xx_o0_t1_l0 = (-.5 * rk1(i, j, k, gtd_xx) * rk1(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xx_o0_t0_l0 = (-.5 * rk1(i, j, k, gtd_xx) * rk1(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk1Rpd_xx = (((((((((((((((((((((rk1m_Rpd_xx_o0_t0_l0 + rk1m_Rpd_xx_o0_t1_l0) + rk1m_Rpd_xx_o0_t2_l0) + rk1m_Rpd_xx_o0_t3_l0) + rk1m_Rpd_xx_o0_t4_l0) + rk1m_Rpd_xx_o0_t5_l0) + rk1m_Rpd_xx_o0_t6_l0) + rk1m_Rpd_xx_o0_t7_l0) + rk1m_Rpd_xx_o0_t8_l0) + rk1m_Rpd_xx_o0_t9_l0) + rk1m_Rpd_xx_o0_t10_l0) + rk1m_Rpd_xx_o0_t11_l0) + rk1m_Rpd_xx_o0_t12_l0) + rk1m_Rpd_xx_o0_t13_l0) + rk1m_Rpd_xx_o0_t14_l0) + rk1m_Rpd_xx_o0_t15_l0) + rk1m_Rpd_xx_o0_t16_l0) + rk1m_Rpd_xx_o0_t17_l0) + rk1m_Rpd_xx_o0_t18_l0) + rk1m_Rpd_xx_o0_t19_l0) + rk1m_Rpd_xx_o0_t20_l0) + rk1m_Rpd_xx_o0_t21_l0) + rk1m_Rpd_xx_o0_t22_l0;
					rk1m_Rpd_yy_o0_t22_l0 = .5 * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_yy_o0_t21_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_yy) * rk1gtu_zz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yy_o0_t20_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_yy) * rk1gtu_yy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t19_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_yy) * rk1gtu_xx * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yy_o0_t18_l0 = 2.0 * rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_yz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t17_l0 = 2.0 * rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_yy) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t16_l0 = 2.0 * rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xy) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t15_l0 = .5 * rk1(i, j, k, gtd_yy) * rk1gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_yy_o0_t14_l0 = 1.0 * rk1(i, j, k, gtd_yy) * rk1gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_yy_o0_t13_l0 = .5 * rk1(i, j, k, gtd_yy) * rk1gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_yy_o0_t12_l0 = 1.0 * rk1(i, j, k, gtd_yy) * rk1gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_yy_o0_t11_l0 = 1.0 * rk1(i, j, k, gtd_yy) * rk1gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_yy_o0_t10_l0 = .5 * rk1(i, j, k, gtd_yy) * rk1gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_yy_o0_t9_l0 = (-.5 * rk1(i, j, k, gtd_yy) * rk1(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yy_o0_t8_l0 = (-.5 * rk1(i, j, k, gtd_yy) * rk1(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t7_l0 = (-.5 * rk1(i, j, k, gtd_yy) * rk1(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yy_o0_t6_l0 = (-.2500000000000000 * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t5_l0 = (-.5 * rk1Ct_zyy) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yy_o0_t4_l0 = (-.5 * rk1Ct_yyy) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t3_l0 = (-.5 * rk1Ct_xyy) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yy_o0_t2_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_yy) * rk1gtu_yz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yy_o0_t1_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_yy) * rk1gtu_xz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yy_o0_t0_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_yy) * rk1gtu_xy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1Rpd_yy = (((((((((((((((((((((rk1m_Rpd_yy_o0_t0_l0 + rk1m_Rpd_yy_o0_t1_l0) + rk1m_Rpd_yy_o0_t2_l0) + rk1m_Rpd_yy_o0_t3_l0) + rk1m_Rpd_yy_o0_t4_l0) + rk1m_Rpd_yy_o0_t5_l0) + rk1m_Rpd_yy_o0_t6_l0) + rk1m_Rpd_yy_o0_t7_l0) + rk1m_Rpd_yy_o0_t8_l0) + rk1m_Rpd_yy_o0_t9_l0) + rk1m_Rpd_yy_o0_t10_l0) + rk1m_Rpd_yy_o0_t11_l0) + rk1m_Rpd_yy_o0_t12_l0) + rk1m_Rpd_yy_o0_t13_l0) + rk1m_Rpd_yy_o0_t14_l0) + rk1m_Rpd_yy_o0_t15_l0) + rk1m_Rpd_yy_o0_t16_l0) + rk1m_Rpd_yy_o0_t17_l0) + rk1m_Rpd_yy_o0_t18_l0) + rk1m_Rpd_yy_o0_t19_l0) + rk1m_Rpd_yy_o0_t20_l0) + rk1m_Rpd_yy_o0_t21_l0) + rk1m_Rpd_yy_o0_t22_l0;
					rk1m_Rpd_yz_o0_t25_l0 = .5 * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_yz_o0_t24_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_yz) * rk1gtu_zz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t23_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_yz) * rk1gtu_yy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t22_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_yz) * rk1gtu_xx * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yz_o0_t21_l0 = rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_zz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t20_l0 = rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_yz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t19_l0 = rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t18_l0 = rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_yz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t17_l0 = rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_yy) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t16_l0 = rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xy) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t15_l0 = (-.2500000000000000 * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t14_l0 = .5 * rk1(i, j, k, gtd_yz) * rk1gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_yz_o0_t13_l0 = 1.0 * rk1(i, j, k, gtd_yz) * rk1gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_yz_o0_t12_l0 = .5 * rk1(i, j, k, gtd_yz) * rk1gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_yz_o0_t11_l0 = 1.0 * rk1(i, j, k, gtd_yz) * rk1gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_yz_o0_t10_l0 = 1.0 * rk1(i, j, k, gtd_yz) * rk1gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_yz_o0_t9_l0 = .5 * rk1(i, j, k, gtd_yz) * rk1gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_yz_o0_t8_l0 = (-.5 * rk1(i, j, k, gtd_yz) * rk1(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t7_l0 = (-.5 * rk1(i, j, k, gtd_yz) * rk1(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t6_l0 = (-.5 * rk1(i, j, k, gtd_yz) * rk1(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yz_o0_t5_l0 = (-.5 * rk1Ct_zyz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_yz_o0_t4_l0 = (-.5 * rk1Ct_yyz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t3_l0 = (-.5 * rk1Ct_xyz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yz_o0_t2_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_yz) * rk1gtu_yz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_yz_o0_t1_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_yz) * rk1gtu_xz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_yz_o0_t0_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_yz) * rk1gtu_xy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1Rpd_yz = ((((((((((((((((((((((((rk1m_Rpd_yz_o0_t0_l0 + rk1m_Rpd_yz_o0_t1_l0) + rk1m_Rpd_yz_o0_t2_l0) + rk1m_Rpd_yz_o0_t3_l0) + rk1m_Rpd_yz_o0_t4_l0) + rk1m_Rpd_yz_o0_t5_l0) + rk1m_Rpd_yz_o0_t6_l0) + rk1m_Rpd_yz_o0_t7_l0) + rk1m_Rpd_yz_o0_t8_l0) + rk1m_Rpd_yz_o0_t9_l0) + rk1m_Rpd_yz_o0_t10_l0) + rk1m_Rpd_yz_o0_t11_l0) + rk1m_Rpd_yz_o0_t12_l0) + rk1m_Rpd_yz_o0_t13_l0) + rk1m_Rpd_yz_o0_t14_l0) + rk1m_Rpd_yz_o0_t15_l0) + rk1m_Rpd_yz_o0_t16_l0) + rk1m_Rpd_yz_o0_t17_l0) + rk1m_Rpd_yz_o0_t18_l0) + rk1m_Rpd_yz_o0_t19_l0) + rk1m_Rpd_yz_o0_t20_l0) + rk1m_Rpd_yz_o0_t21_l0) + rk1m_Rpd_yz_o0_t22_l0) + rk1m_Rpd_yz_o0_t23_l0) + rk1m_Rpd_yz_o0_t24_l0) + rk1m_Rpd_yz_o0_t25_l0;
					rk1m_Rpd_xz_o0_t25_l0 = .5 * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_xz_o0_t24_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xz) * rk1gtu_zz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t23_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xz) * rk1gtu_yy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xz_o0_t22_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xz) * rk1gtu_xx * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t21_l0 = rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_zz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t20_l0 = rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_yz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t19_l0 = rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t18_l0 = rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_xz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t17_l0 = rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_xy) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t16_l0 = rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xx) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t15_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xz) * rk1gtu_xz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t14_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xz) * rk1gtu_xy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t13_l0 = 1.0 * rk1(i, j, k, gtd_xz) * rk1gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_xz_o0_t12_l0 = .5 * rk1(i, j, k, gtd_xz) * rk1gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_xz_o0_t11_l0 = 1.0 * rk1(i, j, k, gtd_xz) * rk1gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_xz_o0_t10_l0 = 1.0 * rk1(i, j, k, gtd_xz) * rk1gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_xz_o0_t9_l0 = .5 * rk1(i, j, k, gtd_xz) * rk1gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_xz_o0_t8_l0 = (-.5 * rk1(i, j, k, gtd_xz) * rk1(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t7_l0 = (-.5 * rk1(i, j, k, gtd_xz) * rk1(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xz_o0_t6_l0 = (-.5 * rk1(i, j, k, gtd_xz) * rk1(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t5_l0 = (-.2500000000000000 * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t4_l0 = .5 * rk1(i, j, k, gtd_xz) * rk1gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_xz_o0_t3_l0 = (-.5 * rk1Ct_zxz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xz_o0_t2_l0 = (-.5 * rk1Ct_yxz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xz_o0_t1_l0 = (-.5 * rk1Ct_xxz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xz_o0_t0_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xz) * rk1gtu_yz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1Rpd_xz = ((((((((((((((((((((((((rk1m_Rpd_xz_o0_t0_l0 + rk1m_Rpd_xz_o0_t1_l0) + rk1m_Rpd_xz_o0_t2_l0) + rk1m_Rpd_xz_o0_t3_l0) + rk1m_Rpd_xz_o0_t4_l0) + rk1m_Rpd_xz_o0_t5_l0) + rk1m_Rpd_xz_o0_t6_l0) + rk1m_Rpd_xz_o0_t7_l0) + rk1m_Rpd_xz_o0_t8_l0) + rk1m_Rpd_xz_o0_t9_l0) + rk1m_Rpd_xz_o0_t10_l0) + rk1m_Rpd_xz_o0_t11_l0) + rk1m_Rpd_xz_o0_t12_l0) + rk1m_Rpd_xz_o0_t13_l0) + rk1m_Rpd_xz_o0_t14_l0) + rk1m_Rpd_xz_o0_t15_l0) + rk1m_Rpd_xz_o0_t16_l0) + rk1m_Rpd_xz_o0_t17_l0) + rk1m_Rpd_xz_o0_t18_l0) + rk1m_Rpd_xz_o0_t19_l0) + rk1m_Rpd_xz_o0_t20_l0) + rk1m_Rpd_xz_o0_t21_l0) + rk1m_Rpd_xz_o0_t22_l0) + rk1m_Rpd_xz_o0_t23_l0) + rk1m_Rpd_xz_o0_t24_l0) + rk1m_Rpd_xz_o0_t25_l0;
					rk1m_Rpd_xy_o0_t25_l0 = .5 * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_xy_o0_t24_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xy) * rk1gtu_zz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xy_o0_t23_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xy) * rk1gtu_yy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t22_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_xy) * rk1gtu_xx * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t21_l0 = rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_yz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t20_l0 = rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_yy) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t19_l0 = rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xy) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t18_l0 = rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_xz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t17_l0 = rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_xy) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t16_l0 = rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xx) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t15_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xy) * rk1gtu_yz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t14_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xy) * rk1gtu_xz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t13_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_xy) * rk1gtu_xy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t12_l0 = (-.2500000000000000 * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t11_l0 = .5 * rk1(i, j, k, gtd_xy) * rk1gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_xy_o0_t10_l0 = 1.0 * rk1(i, j, k, gtd_xy) * rk1gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_xy_o0_t9_l0 = .5 * rk1(i, j, k, gtd_xy) * rk1gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_xy_o0_t8_l0 = 1.0 * rk1(i, j, k, gtd_xy) * rk1gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_xy_o0_t7_l0 = 1.0 * rk1(i, j, k, gtd_xy) * rk1gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_xy_o0_t6_l0 = .5 * rk1(i, j, k, gtd_xy) * rk1gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_xy_o0_t5_l0 = (-.5 * rk1(i, j, k, gtd_xy) * rk1(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xy_o0_t4_l0 = (-.5 * rk1(i, j, k, gtd_xy) * rk1(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t3_l0 = (-.5 * rk1(i, j, k, gtd_xy) * rk1(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_xy_o0_t2_l0 = (-.5 * rk1Ct_zxy) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_xy_o0_t1_l0 = (-.5 * rk1Ct_yxy) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_xy_o0_t0_l0 = (-.5 * rk1Ct_xxy) * d_Rpd_xx_o0_t0_m0_l0;
					rk1Rpd_xy = ((((((((((((((((((((((((rk1m_Rpd_xy_o0_t0_l0 + rk1m_Rpd_xy_o0_t1_l0) + rk1m_Rpd_xy_o0_t2_l0) + rk1m_Rpd_xy_o0_t3_l0) + rk1m_Rpd_xy_o0_t4_l0) + rk1m_Rpd_xy_o0_t5_l0) + rk1m_Rpd_xy_o0_t6_l0) + rk1m_Rpd_xy_o0_t7_l0) + rk1m_Rpd_xy_o0_t8_l0) + rk1m_Rpd_xy_o0_t9_l0) + rk1m_Rpd_xy_o0_t10_l0) + rk1m_Rpd_xy_o0_t11_l0) + rk1m_Rpd_xy_o0_t12_l0) + rk1m_Rpd_xy_o0_t13_l0) + rk1m_Rpd_xy_o0_t14_l0) + rk1m_Rpd_xy_o0_t15_l0) + rk1m_Rpd_xy_o0_t16_l0) + rk1m_Rpd_xy_o0_t17_l0) + rk1m_Rpd_xy_o0_t18_l0) + rk1m_Rpd_xy_o0_t19_l0) + rk1m_Rpd_xy_o0_t20_l0) + rk1m_Rpd_xy_o0_t21_l0) + rk1m_Rpd_xy_o0_t22_l0) + rk1m_Rpd_xy_o0_t23_l0) + rk1m_Rpd_xy_o0_t24_l0) + rk1m_Rpd_xy_o0_t25_l0;
					rk1m_Rpd_zz_o0_t22_l0 = .5 * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_zz_o0_t21_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_zz) * rk1gtu_zz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t20_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_zz) * rk1gtu_yy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_zz_o0_t19_l0 = (-.7500000000000000 * rk1(i, j, k, gtd_zz) * rk1gtu_xx * rk1inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_zz_o0_t18_l0 = 2.0 * rk1inv_chi * rk1Zu_z * rk1(i, j, k, gtd_zz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t17_l0 = 2.0 * rk1inv_chi * rk1Zu_y * rk1(i, j, k, gtd_yz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t16_l0 = 2.0 * rk1inv_chi * rk1Zu_x * rk1(i, j, k, gtd_xz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t15_l0 = .5 * rk1(i, j, k, gtd_zz) * rk1gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk1m_Rpd_zz_o0_t14_l0 = 1.0 * rk1(i, j, k, gtd_zz) * rk1gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk1m_Rpd_zz_o0_t13_l0 = .5 * rk1(i, j, k, gtd_zz) * rk1gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk1m_Rpd_zz_o0_t12_l0 = 1.0 * rk1(i, j, k, gtd_zz) * rk1gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk1m_Rpd_zz_o0_t11_l0 = 1.0 * rk1(i, j, k, gtd_zz) * rk1gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk1m_Rpd_zz_o0_t10_l0 = .5 * rk1(i, j, k, gtd_zz) * rk1gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk1m_Rpd_zz_o0_t9_l0 = (-.5 * rk1(i, j, k, gtd_zz) * rk1(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t8_l0 = (-.5 * rk1(i, j, k, gtd_zz) * rk1(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_zz_o0_t7_l0 = (-.5 * rk1(i, j, k, gtd_zz) * rk1(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_zz_o0_t6_l0 = (-.2500000000000000 * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t5_l0 = (-.5 * rk1Ct_zzz) * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Rpd_zz_o0_t4_l0 = (-.5 * rk1Ct_yzz) * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_zz_o0_t3_l0 = (-.5 * rk1Ct_xzz) * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_zz_o0_t2_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_zz) * rk1gtu_yz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Rpd_zz_o0_t1_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_zz) * rk1gtu_xz * rk1inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Rpd_zz_o0_t0_l0 = (-1.500000000000000 * rk1(i, j, k, gtd_zz) * rk1gtu_xy * rk1inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1Rpd_zz = (((((((((((((((((((((rk1m_Rpd_zz_o0_t0_l0 + rk1m_Rpd_zz_o0_t1_l0) + rk1m_Rpd_zz_o0_t2_l0) + rk1m_Rpd_zz_o0_t3_l0) + rk1m_Rpd_zz_o0_t4_l0) + rk1m_Rpd_zz_o0_t5_l0) + rk1m_Rpd_zz_o0_t6_l0) + rk1m_Rpd_zz_o0_t7_l0) + rk1m_Rpd_zz_o0_t8_l0) + rk1m_Rpd_zz_o0_t9_l0) + rk1m_Rpd_zz_o0_t10_l0) + rk1m_Rpd_zz_o0_t11_l0) + rk1m_Rpd_zz_o0_t12_l0) + rk1m_Rpd_zz_o0_t13_l0) + rk1m_Rpd_zz_o0_t14_l0) + rk1m_Rpd_zz_o0_t15_l0) + rk1m_Rpd_zz_o0_t16_l0) + rk1m_Rpd_zz_o0_t17_l0) + rk1m_Rpd_zz_o0_t18_l0) + rk1m_Rpd_zz_o0_t19_l0) + rk1m_Rpd_zz_o0_t20_l0) + rk1m_Rpd_zz_o0_t21_l0) + rk1m_Rpd_zz_o0_t22_l0;
					rk1Rscalar = (rk1chi_max * rk1Rtd_xx + rk1Rpd_xx) * rk1gtu_xx + 2.0 * (rk1chi_max * rk1Rtd_xy + rk1Rpd_xy) * rk1gtu_xy + 2.0 * (rk1chi_max * rk1Rtd_xz + rk1Rpd_xz) * rk1gtu_xz + (rk1chi_max * rk1Rtd_yy + rk1Rpd_yy) * rk1gtu_yy + 2.0 * (rk1chi_max * rk1Rtd_yz + rk1Rpd_yz) * rk1gtu_yz + (rk1chi_max * rk1Rtd_zz + rk1Rpd_zz) * rk1gtu_zz;
					rk1d_d_pheI4d_t_o0_t0_m0_l0 = -rk1(i, j, k, Alpha) * rk1(i, j, k, peI);
					rk1m_d_pheI4d_t_o0_t6_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_d_pheI4d_t_o0_t3_m0_l0;
					rk1m_d_pheI4d_t_o0_t5_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_d_pheI4d_t_o0_t2_m0_l0;
					rk1m_d_pheI4d_t_o0_t4_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_d_pheI4d_t_o0_t1_m0_l0;
					rk1m_d_pheI4d_t_o0_t3_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_d_pheI4d_t_o0_t3_m0_l0;
					rk1m_d_pheI4d_t_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_d_pheI4d_t_o0_t2_m0_l0;
					rk1m_d_pheI4d_t_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_d_pheI4d_t_o0_t1_m0_l0;
					rk1d_pheI4d_t = (((((rk1d_d_pheI4d_t_o0_t0_m0_l0 + rk1m_d_pheI4d_t_o0_t1_l0) + rk1m_d_pheI4d_t_o0_t2_l0) + rk1m_d_pheI4d_t_o0_t3_l0) + rk1m_d_pheI4d_t_o0_t4_l0) + rk1m_d_pheI4d_t_o0_t5_l0) + rk1m_d_pheI4d_t_o0_t6_l0;
					rk1d_pheI4d_z = d_d_pheI4d_t_o0_t3_m0_l0;
					rk1d_pheI4d_y = d_d_pheI4d_t_o0_t2_m0_l0;
					rk1d_pheI4d_x = d_d_pheI4d_t_o0_t1_m0_l0;
					rk1d_pheI4u_t = rk1g4u_tt * rk1d_pheI4d_t + rk1g4u_tx * rk1d_pheI4d_x + rk1g4u_ty * rk1d_pheI4d_y + rk1g4u_tz * rk1d_pheI4d_z;
					rk1d_pheI4u_z = rk1g4u_tz * rk1d_pheI4d_t + rk1g4u_xz * rk1d_pheI4d_x + rk1g4u_yz * rk1d_pheI4d_y + rk1g4u_zz * rk1d_pheI4d_z;
					rk1d_pheI4u_y = rk1g4u_ty * rk1d_pheI4d_t + rk1g4u_xy * rk1d_pheI4d_x + rk1g4u_yy * rk1d_pheI4d_y + rk1g4u_yz * rk1d_pheI4d_z;
					rk1d_pheI4u_x = rk1g4u_tx * rk1d_pheI4d_t + rk1g4u_xx * rk1d_pheI4d_x + rk1g4u_xy * rk1d_pheI4d_y + rk1g4u_xz * rk1d_pheI4d_z;
					rk1dphe4sq = rk1d_pheR4u_t * rk1d_pheR4d_t + rk1d_pheR4u_x * rk1d_pheR4d_x + rk1d_pheR4u_y * rk1d_pheR4d_y + rk1d_pheR4u_z * rk1d_pheR4d_z + rk1d_pheI4u_t * rk1d_pheI4d_t + rk1d_pheI4u_x * rk1d_pheI4d_x + rk1d_pheI4u_y * rk1d_pheI4d_y + rk1d_pheI4u_z * rk1d_pheI4d_z;
					rk1Tsfu_zz = 2.0 * (rk1d_phiR4u_z * rk1d_phiR4u_z) + 2.0 * (rk1d_phiI4u_z * rk1d_phiI4u_z) + (-rk1g4u_zz * (rk1dphi4sq + rk1sfVi)) + 2.0 * (rk1d_pheR4u_z * rk1d_pheR4u_z) + 2.0 * (rk1d_pheI4u_z * rk1d_pheI4u_z) + (-rk1g4u_zz * (rk1dphe4sq + rk1sfVe));
					rk1Tu_zz = rk1Tsfu_zz;
					rk1Tsfu_yz = 2.0 * rk1d_phiR4u_y * rk1d_phiR4u_z + 2.0 * rk1d_phiI4u_y * rk1d_phiI4u_z + (-rk1g4u_yz * (rk1dphi4sq + rk1sfVi)) + 2.0 * rk1d_pheR4u_y * rk1d_pheR4u_z + 2.0 * rk1d_pheI4u_y * rk1d_pheI4u_z + (-rk1g4u_yz * (rk1dphe4sq + rk1sfVe));
					rk1Tu_yz = rk1Tsfu_yz;
					rk1Tsfu_yy = 2.0 * (rk1d_phiR4u_y * rk1d_phiR4u_y) + 2.0 * (rk1d_phiI4u_y * rk1d_phiI4u_y) + (-rk1g4u_yy * (rk1dphi4sq + rk1sfVi)) + 2.0 * (rk1d_pheR4u_y * rk1d_pheR4u_y) + 2.0 * (rk1d_pheI4u_y * rk1d_pheI4u_y) + (-rk1g4u_yy * (rk1dphe4sq + rk1sfVe));
					rk1Tu_yy = rk1Tsfu_yy;
					rk1Tsfu_xz = 2.0 * rk1d_phiR4u_x * rk1d_phiR4u_z + 2.0 * rk1d_phiI4u_x * rk1d_phiI4u_z + (-rk1g4u_xz * (rk1dphi4sq + rk1sfVi)) + 2.0 * rk1d_pheR4u_x * rk1d_pheR4u_z + 2.0 * rk1d_pheI4u_x * rk1d_pheI4u_z + (-rk1g4u_xz * (rk1dphe4sq + rk1sfVe));
					rk1Tu_xz = rk1Tsfu_xz;
					rk1Tsfu_xy = 2.0 * rk1d_phiR4u_x * rk1d_phiR4u_y + 2.0 * rk1d_phiI4u_x * rk1d_phiI4u_y + (-rk1g4u_xy * (rk1dphi4sq + rk1sfVi)) + 2.0 * rk1d_pheR4u_x * rk1d_pheR4u_y + 2.0 * rk1d_pheI4u_x * rk1d_pheI4u_y + (-rk1g4u_xy * (rk1dphe4sq + rk1sfVe));
					rk1Tu_xy = rk1Tsfu_xy;
					rk1Tsfu_xx = 2.0 * (rk1d_phiR4u_x * rk1d_phiR4u_x) + 2.0 * (rk1d_phiI4u_x * rk1d_phiI4u_x) + (-rk1g4u_xx * (rk1dphi4sq + rk1sfVi)) + 2.0 * (rk1d_pheR4u_x * rk1d_pheR4u_x) + 2.0 * (rk1d_pheI4u_x * rk1d_pheI4u_x) + (-rk1g4u_xx * (rk1dphe4sq + rk1sfVe));
					rk1Tu_xx = rk1Tsfu_xx;
					rk1Tsfu_tt = 2.0 * (rk1d_phiR4u_t * rk1d_phiR4u_t) + 2.0 * (rk1d_phiI4u_t * rk1d_phiI4u_t) + (-rk1g4u_tt * (rk1dphi4sq + rk1sfVi)) + 2.0 * (rk1d_pheR4u_t * rk1d_pheR4u_t) + 2.0 * (rk1d_pheI4u_t * rk1d_pheI4u_t) + (-rk1g4u_tt * (rk1dphe4sq + rk1sfVe));
					rk1Tu_tt = rk1Tsfu_tt;
					rk1Tsfu_tz = 2.0 * rk1d_phiR4u_t * rk1d_phiR4u_z + 2.0 * rk1d_phiI4u_t * rk1d_phiI4u_z + (-rk1g4u_tz * (rk1dphi4sq + rk1sfVi)) + 2.0 * rk1d_pheR4u_t * rk1d_pheR4u_z + 2.0 * rk1d_pheI4u_t * rk1d_pheI4u_z + (-rk1g4u_tz * (rk1dphe4sq + rk1sfVe));
					rk1Tu_tz = rk1Tsfu_tz;
					rk1Tsfu_ty = 2.0 * rk1d_phiR4u_t * rk1d_phiR4u_y + 2.0 * rk1d_phiI4u_t * rk1d_phiI4u_y + (-rk1g4u_ty * (rk1dphi4sq + rk1sfVi)) + 2.0 * rk1d_pheR4u_t * rk1d_pheR4u_y + 2.0 * rk1d_pheI4u_t * rk1d_pheI4u_y + (-rk1g4u_ty * (rk1dphe4sq + rk1sfVe));
					rk1Tu_ty = rk1Tsfu_ty;
					rk1Tsfu_tx = 2.0 * rk1d_phiR4u_t * rk1d_phiR4u_x + 2.0 * rk1d_phiI4u_t * rk1d_phiI4u_x + (-rk1g4u_tx * (rk1dphi4sq + rk1sfVi)) + 2.0 * rk1d_pheR4u_t * rk1d_pheR4u_x + 2.0 * rk1d_pheI4u_t * rk1d_pheI4u_x + (-rk1g4u_tx * (rk1dphe4sq + rk1sfVe));
					rk1Tu_tx = rk1Tsfu_tx;
					rk1pTtd_ADM_xz = rk1Betatd_x * rk1Betatd_z * rk1Tu_tt + rk1Betatd_x * (rk1(i, j, k, gtd_xz) * rk1Tu_tx + rk1(i, j, k, gtd_yz) * rk1Tu_ty + rk1(i, j, k, gtd_zz) * rk1Tu_tz) + rk1Betatd_z * (rk1(i, j, k, gtd_xx) * rk1Tu_tx + rk1(i, j, k, gtd_xy) * rk1Tu_ty + rk1(i, j, k, gtd_xz) * rk1Tu_tz) + rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_xz) * rk1Tu_xx + rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_yz) * rk1Tu_xy + rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_zz) * rk1Tu_xz + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xz) * rk1Tu_xy + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yz) * rk1Tu_yy + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_zz) * rk1Tu_yz + (rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_xz)) * rk1Tu_xz + rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_yz) * rk1Tu_yz + rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_zz) * rk1Tu_zz;
					rk1pTtd_ADM_xy = rk1Betatd_x * rk1Betatd_y * rk1Tu_tt + rk1Betatd_x * (rk1(i, j, k, gtd_xy) * rk1Tu_tx + rk1(i, j, k, gtd_yy) * rk1Tu_ty + rk1(i, j, k, gtd_yz) * rk1Tu_tz) + rk1Betatd_y * (rk1(i, j, k, gtd_xx) * rk1Tu_tx + rk1(i, j, k, gtd_xy) * rk1Tu_ty + rk1(i, j, k, gtd_xz) * rk1Tu_tz) + rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_xy) * rk1Tu_xx + rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_yy) * rk1Tu_xy + rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_yz) * rk1Tu_xz + (rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xy)) * rk1Tu_xy + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yy) * rk1Tu_yy + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yz) * rk1Tu_yz + rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_xy) * rk1Tu_xz + rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_yy) * rk1Tu_yz + rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_yz) * rk1Tu_zz;
					rk1pTtd_ADM_xx = (rk1Betatd_x * rk1Betatd_x) * rk1Tu_tt + 2.0 * rk1Betatd_x * (rk1(i, j, k, gtd_xx) * rk1Tu_tx + rk1(i, j, k, gtd_xy) * rk1Tu_ty + rk1(i, j, k, gtd_xz) * rk1Tu_tz) + (rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_xx)) * rk1Tu_xx + 2.0 * rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_xy) * rk1Tu_xy + 2.0 * rk1(i, j, k, gtd_xx) * rk1(i, j, k, gtd_xz) * rk1Tu_xz + (rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xy)) * rk1Tu_yy + 2.0 * rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xz) * rk1Tu_yz + (rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_xz)) * rk1Tu_zz;
					rk1d_Psi1_xx_o0_t5_m0_l0 = (-8.0 * M_PI * rk1inv_chi * rk1(i, j, k, Alpha) * rk1pTtd_ADM_xx) + rk1(i, j, k, Alpha) * rk1Rpd_xx + rk1chi_max * rk1(i, j, k, Alpha) * rk1Rtd_xx;
					rk1m_Psi1_xx_o0_t4_l0 = (-1.0 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Psi1_xx_o0_t3_l0 = rk1chi_max * rk1Ct_zxx * d_Psi1_xx_o0_t3_m0_l0;
					rk1m_Psi1_xx_o0_t2_l0 = rk1chi_max * rk1Ct_yxx * d_Psi1_xx_o0_t2_m0_l0;
					rk1m_Psi1_xx_o0_t1_l0 = rk1chi_max * rk1Ct_xxx * d_Psi1_xx_o0_t1_m0_l0;
					rk1m_Psi1_xx_o0_t0_l0 = (-rk1chi_max) * d_Psi1_xx_o0_t0_m0_l0;
					rk1Psi1_xx = ((((rk1m_Psi1_xx_o0_t0_l0 + rk1m_Psi1_xx_o0_t1_l0) + rk1m_Psi1_xx_o0_t2_l0) + rk1m_Psi1_xx_o0_t3_l0) + rk1m_Psi1_xx_o0_t4_l0) + rk1d_Psi1_xx_o0_t5_m0_l0;
					rk1d_Psi1_xy_o0_t6_m0_l0 = (-8.0 * M_PI * rk1inv_chi * rk1(i, j, k, Alpha) * rk1pTtd_ADM_xy) + rk1(i, j, k, Alpha) * rk1Rpd_xy + rk1chi_max * rk1(i, j, k, Alpha) * rk1Rtd_xy;
					rk1m_Psi1_xy_o0_t5_l0 = (-.5 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Psi1_xy_o0_t4_l0 = (-.5 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Psi1_xy_o0_t3_l0 = rk1chi_max * rk1Ct_zxy * d_Psi1_xx_o0_t3_m0_l0;
					rk1m_Psi1_xy_o0_t2_l0 = rk1chi_max * rk1Ct_yxy * d_Psi1_xx_o0_t2_m0_l0;
					rk1m_Psi1_xy_o0_t1_l0 = rk1chi_max * rk1Ct_xxy * d_Psi1_xx_o0_t1_m0_l0;
					rk1m_Psi1_xy_o0_t0_l0 = (-rk1chi_max) * d_Psi1_xy_o0_t0_m0_l0;
					rk1Psi1_xy = (((((rk1m_Psi1_xy_o0_t0_l0 + rk1m_Psi1_xy_o0_t1_l0) + rk1m_Psi1_xy_o0_t2_l0) + rk1m_Psi1_xy_o0_t3_l0) + rk1m_Psi1_xy_o0_t4_l0) + rk1m_Psi1_xy_o0_t5_l0) + rk1d_Psi1_xy_o0_t6_m0_l0;
					rk1d_Psi1_xz_o0_t6_m0_l0 = (-8.0 * M_PI * rk1inv_chi * rk1(i, j, k, Alpha) * rk1pTtd_ADM_xz) + rk1(i, j, k, Alpha) * rk1Rpd_xz + rk1chi_max * rk1(i, j, k, Alpha) * rk1Rtd_xz;
					rk1m_Psi1_xz_o0_t5_l0 = (-.5 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk1m_Psi1_xz_o0_t4_l0 = (-.5 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Psi1_xz_o0_t3_l0 = rk1chi_max * rk1Ct_zxz * d_Psi1_xx_o0_t3_m0_l0;
					rk1m_Psi1_xz_o0_t2_l0 = rk1chi_max * rk1Ct_yxz * d_Psi1_xx_o0_t2_m0_l0;
					rk1m_Psi1_xz_o0_t1_l0 = rk1chi_max * rk1Ct_xxz * d_Psi1_xx_o0_t1_m0_l0;
					rk1m_Psi1_xz_o0_t0_l0 = (-rk1chi_max) * d_Psi1_xz_o0_t0_m0_l0;
					rk1Psi1_xz = (((((rk1m_Psi1_xz_o0_t0_l0 + rk1m_Psi1_xz_o0_t1_l0) + rk1m_Psi1_xz_o0_t2_l0) + rk1m_Psi1_xz_o0_t3_l0) + rk1m_Psi1_xz_o0_t4_l0) + rk1m_Psi1_xz_o0_t5_l0) + rk1d_Psi1_xz_o0_t6_m0_l0;
					rk1Jtd_ADM_z = rk1(i, j, k, Alpha) * ((rk1(i, j, k, Betau_x) * rk1Tu_tt + rk1Tu_tx) * rk1(i, j, k, gtd_xz) + (rk1(i, j, k, Betau_y) * rk1Tu_tt + rk1Tu_ty) * rk1(i, j, k, gtd_yz) + (rk1(i, j, k, Betau_z) * rk1Tu_tt + rk1Tu_tz) * rk1(i, j, k, gtd_zz));
					rk1pTtd_ADM_zz = (rk1Betatd_z * rk1Betatd_z) * rk1Tu_tt + 2.0 * rk1Betatd_z * (rk1(i, j, k, gtd_xz) * rk1Tu_tx + rk1(i, j, k, gtd_yz) * rk1Tu_ty + rk1(i, j, k, gtd_zz) * rk1Tu_tz) + (rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_xz)) * rk1Tu_xx + 2.0 * rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_yz) * rk1Tu_xy + 2.0 * rk1(i, j, k, gtd_xz) * rk1(i, j, k, gtd_zz) * rk1Tu_xz + (rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_yz)) * rk1Tu_yy + 2.0 * rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_zz) * rk1Tu_yz + (rk1(i, j, k, gtd_zz) * rk1(i, j, k, gtd_zz)) * rk1Tu_zz;
					rk1d_Psi1_zz_o0_t5_m0_l0 = (-8.0 * M_PI * rk1inv_chi * rk1(i, j, k, Alpha) * rk1pTtd_ADM_zz) + rk1(i, j, k, Alpha) * rk1Rpd_zz + rk1chi_max * rk1(i, j, k, Alpha) * rk1Rtd_zz;
					rk1m_Psi1_zz_o0_t4_l0 = (-1.0 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Psi1_zz_o0_t3_l0 = rk1chi_max * rk1Ct_zzz * d_Psi1_xx_o0_t3_m0_l0;
					rk1m_Psi1_zz_o0_t2_l0 = rk1chi_max * rk1Ct_yzz * d_Psi1_xx_o0_t2_m0_l0;
					rk1m_Psi1_zz_o0_t1_l0 = rk1chi_max * rk1Ct_xzz * d_Psi1_xx_o0_t1_m0_l0;
					rk1m_Psi1_zz_o0_t0_l0 = (-rk1chi_max) * d_Psi1_zz_o0_t0_m0_l0;
					rk1Psi1_zz = ((((rk1m_Psi1_zz_o0_t0_l0 + rk1m_Psi1_zz_o0_t1_l0) + rk1m_Psi1_zz_o0_t2_l0) + rk1m_Psi1_zz_o0_t3_l0) + rk1m_Psi1_zz_o0_t4_l0) + rk1d_Psi1_zz_o0_t5_m0_l0;
					rk1Jtd_ADM_y = rk1(i, j, k, Alpha) * ((rk1(i, j, k, Betau_x) * rk1Tu_tt + rk1Tu_tx) * rk1(i, j, k, gtd_xy) + (rk1(i, j, k, Betau_y) * rk1Tu_tt + rk1Tu_ty) * rk1(i, j, k, gtd_yy) + (rk1(i, j, k, Betau_z) * rk1Tu_tt + rk1Tu_tz) * rk1(i, j, k, gtd_yz));
					rk1Jtd_ADM_x = rk1(i, j, k, Alpha) * ((rk1(i, j, k, Betau_x) * rk1Tu_tt + rk1Tu_tx) * rk1(i, j, k, gtd_xx) + (rk1(i, j, k, Betau_y) * rk1Tu_tt + rk1Tu_ty) * rk1(i, j, k, gtd_xy) + (rk1(i, j, k, Betau_z) * rk1Tu_tt + rk1Tu_tz) * rk1(i, j, k, gtd_xz));
					rk1pTtd_ADM_yz = rk1Betatd_y * rk1Betatd_z * rk1Tu_tt + rk1Betatd_y * (rk1(i, j, k, gtd_xz) * rk1Tu_tx + rk1(i, j, k, gtd_yz) * rk1Tu_ty + rk1(i, j, k, gtd_zz) * rk1Tu_tz) + rk1Betatd_z * (rk1(i, j, k, gtd_xy) * rk1Tu_tx + rk1(i, j, k, gtd_yy) * rk1Tu_ty + rk1(i, j, k, gtd_yz) * rk1Tu_tz) + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xz) * rk1Tu_xx + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yz) * rk1Tu_xy + rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_zz) * rk1Tu_xz + rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_xz) * rk1Tu_xy + rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_yz) * rk1Tu_yy + rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_zz) * rk1Tu_yz + rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_xz) * rk1Tu_xz + (rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_yz)) * rk1Tu_yz + rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_zz) * rk1Tu_zz;
					rk1d_Psi1_yz_o0_t6_m0_l0 = (-8.0 * M_PI * rk1inv_chi * rk1(i, j, k, Alpha) * rk1pTtd_ADM_yz) + rk1(i, j, k, Alpha) * rk1Rpd_yz + rk1chi_max * rk1(i, j, k, Alpha) * rk1Rtd_yz;
					rk1m_Psi1_yz_o0_t5_l0 = (-.5 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Psi1_yz_o0_t4_l0 = (-.5 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk1m_Psi1_yz_o0_t3_l0 = rk1chi_max * rk1Ct_zyz * d_Psi1_xx_o0_t3_m0_l0;
					rk1m_Psi1_yz_o0_t2_l0 = rk1chi_max * rk1Ct_yyz * d_Psi1_xx_o0_t2_m0_l0;
					rk1m_Psi1_yz_o0_t1_l0 = rk1chi_max * rk1Ct_xyz * d_Psi1_xx_o0_t1_m0_l0;
					rk1m_Psi1_yz_o0_t0_l0 = (-rk1chi_max) * d_Psi1_yz_o0_t0_m0_l0;
					rk1Psi1_yz = (((((rk1m_Psi1_yz_o0_t0_l0 + rk1m_Psi1_yz_o0_t1_l0) + rk1m_Psi1_yz_o0_t2_l0) + rk1m_Psi1_yz_o0_t3_l0) + rk1m_Psi1_yz_o0_t4_l0) + rk1m_Psi1_yz_o0_t5_l0) + rk1d_Psi1_yz_o0_t6_m0_l0;
					rk1pTtd_ADM_yy = (rk1Betatd_y * rk1Betatd_y) * rk1Tu_tt + 2.0 * rk1Betatd_y * (rk1(i, j, k, gtd_xy) * rk1Tu_tx + rk1(i, j, k, gtd_yy) * rk1Tu_ty + rk1(i, j, k, gtd_yz) * rk1Tu_tz) + (rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_xy)) * rk1Tu_xx + 2.0 * rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yy) * rk1Tu_xy + 2.0 * rk1(i, j, k, gtd_xy) * rk1(i, j, k, gtd_yz) * rk1Tu_xz + (rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_yy)) * rk1Tu_yy + 2.0 * rk1(i, j, k, gtd_yy) * rk1(i, j, k, gtd_yz) * rk1Tu_yz + (rk1(i, j, k, gtd_yz) * rk1(i, j, k, gtd_yz)) * rk1Tu_zz;
					rk1tr_pT = rk1inv_chi * (rk1gtu_xx * rk1pTtd_ADM_xx + 2.0 * rk1gtu_xy * rk1pTtd_ADM_xy + 2.0 * rk1gtu_xz * rk1pTtd_ADM_xz + rk1gtu_yy * rk1pTtd_ADM_yy + 2.0 * rk1gtu_yz * rk1pTtd_ADM_yz + rk1gtu_zz * rk1pTtd_ADM_zz);
					rk1d_Psi1_yy_o0_t5_m0_l0 = (-8.0 * M_PI * rk1inv_chi * rk1(i, j, k, Alpha) * rk1pTtd_ADM_yy) + rk1(i, j, k, Alpha) * rk1Rpd_yy + rk1chi_max * rk1(i, j, k, Alpha) * rk1Rtd_yy;
					rk1m_Psi1_yy_o0_t4_l0 = (-1.0 * rk1chi_max * rk1inv_chi) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk1m_Psi1_yy_o0_t3_l0 = rk1chi_max * rk1Ct_zyy * d_Psi1_xx_o0_t3_m0_l0;
					rk1m_Psi1_yy_o0_t2_l0 = rk1chi_max * rk1Ct_yyy * d_Psi1_xx_o0_t2_m0_l0;
					rk1m_Psi1_yy_o0_t1_l0 = rk1chi_max * rk1Ct_xyy * d_Psi1_xx_o0_t1_m0_l0;
					rk1m_Psi1_yy_o0_t0_l0 = (-rk1chi_max) * d_Psi1_yy_o0_t0_m0_l0;
					rk1Psi1_yy = ((((rk1m_Psi1_yy_o0_t0_l0 + rk1m_Psi1_yy_o0_t1_l0) + rk1m_Psi1_yy_o0_t2_l0) + rk1m_Psi1_yy_o0_t3_l0) + rk1m_Psi1_yy_o0_t4_l0) + rk1d_Psi1_yy_o0_t5_m0_l0;
					rk1trPsi1 = rk1Psi1_xx * rk1gtu_xx + 2.0 * rk1Psi1_xy * rk1gtu_xy + 2.0 * rk1Psi1_xz * rk1gtu_xz + rk1Psi1_yy * rk1gtu_yy + 2.0 * rk1Psi1_yz * rk1gtu_yz + rk1Psi1_zz * rk1gtu_zz;
					rk1Psi1TF_yz = (-.3333333333333333 * rk1trPsi1 * rk1(i, j, k, gtd_yz)) + rk1Psi1_yz;
					rk1Psi1TF_yy = (-.3333333333333333 * rk1trPsi1 * rk1(i, j, k, gtd_yy)) + rk1Psi1_yy;
					rk1Psi1TF_xy = (-.3333333333333333 * rk1trPsi1 * rk1(i, j, k, gtd_xy)) + rk1Psi1_xy;
					rk1Psi1TF_xx = (-.3333333333333333 * rk1trPsi1 * rk1(i, j, k, gtd_xx)) + rk1Psi1_xx;
					rk1Psi1TF_xz = (-.3333333333333333 * rk1trPsi1 * rk1(i, j, k, gtd_xz)) + rk1Psi1_xz;
					rk1Psi1TF_zz = (-.3333333333333333 * rk1trPsi1 * rk1(i, j, k, gtd_zz)) + rk1Psi1_zz;
					rk1kappa_cc = std::min(parameters.p_kappa_cc, parameters.p_kappa_cc * rk1decay_factor) / rk1(i, j, k, Alpha);
					rk1rho_ADM = (rk1(i, j, k, Alpha) * rk1(i, j, k, Alpha)) * rk1Tu_tt;
					d_gtd_xx_o2_t3_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_xx) * log(rk1detgtd)) + (-2.0 * rk1(i, j, k, Alpha) * ((-.3333333333333333 * rk1trAt * parameters.lambda_0 * rk1(i, j, k, gtd_xx)) + rk1(i, j, k, Atd_xx))) + (-.6666666666666667 * rk1(i, j, k, gtd_xx) * rk1div_Beta);
					d_gtd_xy_o2_t6_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_xy) * log(rk1detgtd)) + (-2.0 * rk1(i, j, k, Alpha) * ((-.3333333333333333 * rk1trAt * parameters.lambda_0 * rk1(i, j, k, gtd_xy)) + rk1(i, j, k, Atd_xy))) + (-.6666666666666667 * rk1(i, j, k, gtd_xy) * rk1div_Beta);
					d_gtd_xz_o2_t6_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_xz) * log(rk1detgtd)) + (-2.0 * rk1(i, j, k, Alpha) * ((-.3333333333333333 * rk1trAt * parameters.lambda_0 * rk1(i, j, k, gtd_xz)) + rk1(i, j, k, Atd_xz))) + (-.6666666666666667 * rk1(i, j, k, gtd_xz) * rk1div_Beta);
					d_gtd_yy_o2_t3_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_yy) * log(rk1detgtd)) + (-2.0 * rk1(i, j, k, Alpha) * ((-.3333333333333333 * rk1trAt * parameters.lambda_0 * rk1(i, j, k, gtd_yy)) + rk1(i, j, k, Atd_yy))) + (-.6666666666666667 * rk1(i, j, k, gtd_yy) * rk1div_Beta);
					d_gtd_yz_o2_t6_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_yz) * log(rk1detgtd)) + (-2.0 * rk1(i, j, k, Alpha) * ((-.3333333333333333 * rk1trAt * parameters.lambda_0 * rk1(i, j, k, gtd_yz)) + rk1(i, j, k, Atd_yz))) + (-.6666666666666667 * rk1(i, j, k, gtd_yz) * rk1div_Beta);
					d_gtd_zz_o2_t3_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_zz) * log(rk1detgtd)) + (-2.0 * rk1(i, j, k, Alpha) * ((-.3333333333333333 * rk1trAt * parameters.lambda_0 * rk1(i, j, k, gtd_zz)) + rk1(i, j, k, Atd_zz))) + (-.6666666666666667 * rk1(i, j, k, gtd_zz) * rk1div_Beta);
					d_Atd_xx_o2_t3_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_xx) * rk1trAt) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) * rk1(i, j, k, Atd_xx) + (-2.0 * rk1(i, j, k, Atd_xx) * rk1Atud_xx) + (-2.0 * rk1(i, j, k, Atd_xy) * rk1Atud_yx) + (-2.0 * rk1(i, j, k, Atd_xz) * rk1Atud_zx)) + rk1Psi1TF_xx + (-.6666666666666667 * rk1(i, j, k, Atd_xx) * rk1div_Beta);
					d_Atd_xy_o2_t6_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_xy) * rk1trAt) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) * rk1(i, j, k, Atd_xy) + (-2.0 * rk1(i, j, k, Atd_xx) * rk1Atud_xy) + (-2.0 * rk1(i, j, k, Atd_xy) * rk1Atud_yy) + (-2.0 * rk1(i, j, k, Atd_xz) * rk1Atud_zy)) + rk1Psi1TF_xy + (-.6666666666666667 * rk1(i, j, k, Atd_xy) * rk1div_Beta);
					d_Atd_xz_o2_t6_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_xz) * rk1trAt) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) * rk1(i, j, k, Atd_xz) + (-2.0 * rk1(i, j, k, Atd_xx) * rk1Atud_xz) + (-2.0 * rk1(i, j, k, Atd_xy) * rk1Atud_yz) + (-2.0 * rk1(i, j, k, Atd_xz) * rk1Atud_zz)) + rk1Psi1TF_xz + (-.6666666666666667 * rk1(i, j, k, Atd_xz) * rk1div_Beta);
					d_Atd_yy_o2_t3_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_yy) * rk1trAt) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) * rk1(i, j, k, Atd_yy) + (-2.0 * rk1(i, j, k, Atd_xy) * rk1Atud_xy) + (-2.0 * rk1(i, j, k, Atd_yy) * rk1Atud_yy) + (-2.0 * rk1(i, j, k, Atd_yz) * rk1Atud_zy)) + rk1Psi1TF_yy + (-.6666666666666667 * rk1(i, j, k, Atd_yy) * rk1div_Beta);
					d_Atd_yz_o2_t6_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_yz) * rk1trAt) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) * rk1(i, j, k, Atd_yz) + (-2.0 * rk1(i, j, k, Atd_xy) * rk1Atud_xz) + (-2.0 * rk1(i, j, k, Atd_yy) * rk1Atud_yz) + (-2.0 * rk1(i, j, k, Atd_yz) * rk1Atud_zz)) + rk1Psi1TF_yz + (-.6666666666666667 * rk1(i, j, k, Atd_yz) * rk1div_Beta);
					d_Atd_zz_o2_t3_m0_l0 = (-.3333333333333333 * rk1kappa_cc * rk1(i, j, k, Alpha) * rk1(i, j, k, gtd_zz) * rk1trAt) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) * rk1(i, j, k, Atd_zz) + (-2.0 * rk1(i, j, k, Atd_xz) * rk1Atud_xz) + (-2.0 * rk1(i, j, k, Atd_yz) * rk1Atud_yz) + (-2.0 * rk1(i, j, k, Atd_zz) * rk1Atud_zz)) + rk1Psi1TF_zz + (-.6666666666666667 * rk1(i, j, k, Atd_zz) * rk1div_Beta);
					d_Gamh_x_o2_t24_m0_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Zu_x * (rk1kappa_z1 + 1.333333333333333 * rk1(i, j, k, theta) + .6666666666666667 * rk1(i, j, k, trK))) + (-50.26548245743669 * rk1(i, j, k, Alpha) * rk1inv_chi * (rk1gtu_xx * rk1Jtd_ADM_x + rk1gtu_xy * rk1Jtd_ADM_y + rk1gtu_xz * rk1Jtd_ADM_z)) + 2.0 * rk1(i, j, k, Alpha) * (rk1Ct_xxx * rk1Atu_xx + 2.0 * rk1Ct_xxy * rk1Atu_xy + 2.0 * rk1Ct_xxz * rk1Atu_xz + rk1Ct_xyy * rk1Atu_yy + 2.0 * rk1Ct_xyz * rk1Atu_yz + rk1Ct_xzz * rk1Atu_zz) + .6666666666666667 * rk1(i, j, k, Gamh_x) * rk1div_Beta + .3333333333333333 * rk1gtu_xz * rk1d_div_Beta_z + .3333333333333333 * rk1gtu_xy * rk1d_div_Beta_y + .3333333333333333 * rk1gtu_xx * rk1d_div_Beta_x;
					d_Gamh_y_o2_t24_m0_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Zu_y * (rk1kappa_z1 + 1.333333333333333 * rk1(i, j, k, theta) + .6666666666666667 * rk1(i, j, k, trK))) + .3333333333333333 * rk1gtu_yz * rk1d_div_Beta_z + .3333333333333333 * rk1gtu_yy * rk1d_div_Beta_y + .3333333333333333 * rk1gtu_xy * rk1d_div_Beta_x + 2.0 * rk1(i, j, k, Alpha) * (rk1Ct_yxx * rk1Atu_xx + 2.0 * rk1Ct_yxy * rk1Atu_xy + 2.0 * rk1Ct_yxz * rk1Atu_xz + rk1Ct_yyy * rk1Atu_yy + 2.0 * rk1Ct_yyz * rk1Atu_yz + rk1Ct_yzz * rk1Atu_zz) + .6666666666666667 * rk1(i, j, k, Gamh_y) * rk1div_Beta + (-50.26548245743669 * rk1(i, j, k, Alpha) * rk1inv_chi * (rk1gtu_xy * rk1Jtd_ADM_x + rk1gtu_yy * rk1Jtd_ADM_y + rk1gtu_yz * rk1Jtd_ADM_z));
					d_Betau_x_o0_t0_m0_l0 = (-rk1(i, j, k, Betau_x) * rk1feta) + .7500000000000000 * (rk1(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * rk1(i, j, k, Gamh_x);
					d_Betau_y_o0_t0_m0_l0 = (-rk1(i, j, k, Betau_y) * rk1feta) + .7500000000000000 * (rk1(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * rk1(i, j, k, Gamh_y);
					d_Betau_z_o0_t0_m0_l0 = (parameters.Betau_z_0 - rk1(i, j, k, Betau_z)) * rk1feta + .7500000000000000 * (rk1(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * rk1(i, j, k, Gamh_z);
					d_Gamh_z_o2_t24_m0_l0 = .3333333333333333 * rk1gtu_zz * rk1d_div_Beta_z + .3333333333333333 * rk1gtu_yz * rk1d_div_Beta_y + .3333333333333333 * rk1gtu_xz * rk1d_div_Beta_x + 2.0 * rk1(i, j, k, Alpha) * (rk1Ct_zxx * rk1Atu_xx + 2.0 * rk1Ct_zxy * rk1Atu_xy + 2.0 * rk1Ct_zxz * rk1Atu_xz + rk1Ct_zyy * rk1Atu_yy + 2.0 * rk1Ct_zyz * rk1Atu_yz + rk1Ct_zzz * rk1Atu_zz) + .6666666666666667 * rk1(i, j, k, Gamh_z) * rk1div_Beta + (-50.26548245743669 * rk1(i, j, k, Alpha) * rk1inv_chi * (rk1gtu_xz * rk1Jtd_ADM_x + rk1gtu_yz * rk1Jtd_ADM_y + rk1gtu_zz * rk1Jtd_ADM_z)) + (-2.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Zu_z * (rk1kappa_z1 + 1.333333333333333 * rk1(i, j, k, theta) + .6666666666666667 * rk1(i, j, k, trK)));
					d_Alpha_o2_t0_m0_l0 = -2.0 * (rk1(i, j, k, Alpha) * parameters.lambda_f3 + parameters.lambda_f2) * rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) - parameters.trK0);
					d_chi_o2_t0_m0_l0 = .6666666666666667 * rk1chi_max * (rk1(i, j, k, Alpha) * (2.0 * rk1(i, j, k, theta) + rk1(i, j, k, trK)) - rk1div_Beta);
					d_trK_o2_t21_m0_l0 = rk1(i, j, k, Alpha) * rk1kappa_z1 * (1.0 - rk1kappa_z2) * rk1(i, j, k, theta) + .3333333333333333 * rk1(i, j, k, Alpha) * ((2.0 * rk1(i, j, k, theta) + rk1(i, j, k, trK)) * (2.0 * rk1(i, j, k, theta) + rk1(i, j, k, trK))) + rk1(i, j, k, Alpha) * (rk1(i, j, k, Atd_xx) * rk1Atu_xx + 2.0 * rk1(i, j, k, Atd_xy) * rk1Atu_xy + 2.0 * rk1(i, j, k, Atd_xz) * rk1Atu_xz + rk1(i, j, k, Atd_yy) * rk1Atu_yy + 2.0 * rk1(i, j, k, Atd_yz) * rk1Atu_yz + rk1(i, j, k, Atd_zz) * rk1Atu_zz) + 4.0 * rk1(i, j, k, Alpha) * M_PI * (rk1rho_ADM + rk1tr_pT);
					d_theta_o2_t3_m0_l0 = (-rk1(i, j, k, Alpha) * rk1kappa_z1 * (2.0 + rk1kappa_z2) * rk1(i, j, k, theta)) + (-8.0 * rk1(i, j, k, Alpha) * M_PI * rk1rho_ADM) + .5 * rk1(i, j, k, Alpha) * (rk1Rscalar + .6666666666666667 * (rk1(i, j, k, trK) * rk1(i, j, k, trK)) + .6666666666666667 * rk1(i, j, k, theta) * ((-2.0 * rk1(i, j, k, theta)) + rk1(i, j, k, trK)) + (-rk1(i, j, k, Atd_xx) * rk1Atu_xx) + (-2.0 * rk1(i, j, k, Atd_xy) * rk1Atu_xy) + (-2.0 * rk1(i, j, k, Atd_xz) * rk1Atu_xz) + (-rk1(i, j, k, Atd_yy) * rk1Atu_yy) + (-2.0 * rk1(i, j, k, Atd_yz) * rk1Atu_yz) + (-rk1(i, j, k, Atd_zz) * rk1Atu_zz));
					d_piR_o2_t27_m0_l0 = rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) + 2.0 * rk1(i, j, k, theta)) * rk1(i, j, k, piR) + rk1(i, j, k, Alpha) * rk1dVdphi2 * rk1(i, j, k, phiR);
					d_peR_o2_t27_m0_l0 = rk1(i, j, k, Alpha) * rk1dVdphe2 * rk1(i, j, k, pheR) + rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) + 2.0 * rk1(i, j, k, theta)) * rk1(i, j, k, peR);
					d_piI_o2_t27_m0_l0 = rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) + 2.0 * rk1(i, j, k, theta)) * rk1(i, j, k, piI) + rk1(i, j, k, Alpha) * rk1dVdphi2 * rk1(i, j, k, phiI);
					d_peI_o2_t27_m0_l0 = rk1(i, j, k, Alpha) * (rk1(i, j, k, trK) + 2.0 * rk1(i, j, k, theta)) * rk1(i, j, k, peI) + rk1(i, j, k, Alpha) * rk1dVdphe2 * rk1(i, j, k, pheI);
					m_peI_o2_t26_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yz) * d_peI_o2_t26_m0_l0;
					m_peI_o2_t25_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yy) * d_peI_o2_t25_m0_l0;
					m_peI_o2_t24_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xz) * d_peI_o2_t24_m0_l0;
					m_peI_o2_t23_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xy) * d_peI_o2_t23_m0_l0;
					m_peI_o2_t22_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xx) * d_peI_o2_t22_m0_l0;
					m_peI_o2_t21_l0 = (-rk1chi_max * rk1gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t20_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t19_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t18_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t17_l0 = (-rk1chi_max * rk1gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t16_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t15_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t14_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t13_l0 = (-rk1chi_max * rk1gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t12_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_zz * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t11_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t10_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t9_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t8_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yy * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t7_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t6_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t5_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t4_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xx * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t3_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_z - 2.0 * rk1Zu_z) * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t2_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_y - 2.0 * rk1Zu_y) * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t1_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_x - 2.0 * rk1Zu_x) * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t0_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_zz) * d_peI_o2_t0_m0_l0;
					m_peI_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_peI_o1_t2_m0_l0;
					m_peI_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_peI_o1_t1_m0_l0;
					m_peI_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_peI_o1_t0_m0_l0;
					m_peI_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_peI_o0_t2_m0_l0;
					m_peI_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_peI_o0_t1_m0_l0;
					m_peI_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_peI_o0_t0_m0_l0;
					m_piI_o2_t26_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xz) * d_piI_o2_t26_m0_l0;
					m_piI_o2_t25_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xy) * d_piI_o2_t25_m0_l0;
					m_piI_o2_t24_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xx) * d_piI_o2_t24_m0_l0;
					m_piI_o2_t23_l0 = (-rk1chi_max * rk1gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t22_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t21_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t20_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t19_l0 = (-rk1chi_max * rk1gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t18_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t17_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t16_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t15_l0 = (-rk1chi_max * rk1gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t14_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_zz * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t13_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t12_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t11_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t10_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yy * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t9_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t8_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t7_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t6_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xx * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t5_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_z - 2.0 * rk1Zu_z) * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t4_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_y - 2.0 * rk1Zu_y) * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t3_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_x - 2.0 * rk1Zu_x) * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t2_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_zz) * d_piI_o2_t2_m0_l0;
					m_piI_o2_t1_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yz) * d_piI_o2_t1_m0_l0;
					m_piI_o2_t0_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yy) * d_piI_o2_t0_m0_l0;
					m_piI_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_piI_o1_t2_m0_l0;
					m_piI_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_piI_o1_t1_m0_l0;
					m_piI_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_piI_o1_t0_m0_l0;
					m_piI_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_piI_o0_t2_m0_l0;
					m_piI_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_piI_o0_t1_m0_l0;
					m_piI_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_piI_o0_t0_m0_l0;
					m_peR_o2_t26_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xz) * d_peR_o2_t26_m0_l0;
					m_peR_o2_t25_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xy) * d_peR_o2_t25_m0_l0;
					m_peR_o2_t24_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xx) * d_peR_o2_t24_m0_l0;
					m_peR_o2_t23_l0 = (-rk1chi_max * rk1gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t22_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t21_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t20_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t19_l0 = (-rk1chi_max * rk1gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t18_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t17_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t16_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t15_l0 = (-rk1chi_max * rk1gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t14_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_zz * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t13_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t12_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t11_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t10_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yy * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t9_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t8_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t7_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t6_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xx * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t5_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_z - 2.0 * rk1Zu_z) * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t4_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_y - 2.0 * rk1Zu_y) * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t3_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_x - 2.0 * rk1Zu_x) * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t2_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_zz) * d_peR_o2_t2_m0_l0;
					m_peR_o2_t1_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yz) * d_peR_o2_t1_m0_l0;
					m_peR_o2_t0_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yy) * d_peR_o2_t0_m0_l0;
					m_peR_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_peR_o1_t2_m0_l0;
					m_peR_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_peR_o1_t1_m0_l0;
					m_peR_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_peR_o1_t0_m0_l0;
					m_peR_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_peR_o0_t2_m0_l0;
					m_peR_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_peR_o0_t1_m0_l0;
					m_peR_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_peR_o0_t0_m0_l0;
					m_piR_o2_t26_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xx) * d_piR_o2_t26_m0_l0;
					m_piR_o2_t25_l0 = (-rk1chi_max * rk1gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t24_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t23_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t22_l0 = (-rk1chi_max * rk1gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t21_l0 = (-rk1chi_max * rk1gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t20_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t19_l0 = (-rk1chi_max * rk1gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t18_l0 = (-rk1chi_max * rk1gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t17_l0 = (-rk1chi_max * rk1gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t16_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_zz * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t15_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t14_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t13_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yz * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t12_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_yy * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t11_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t10_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xz * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t9_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xy * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t8_l0 = .5000000000000000 * rk1(i, j, k, Alpha) * rk1gtu_xx * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t7_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_z - 2.0 * rk1Zu_z) * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t6_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_y - 2.0 * rk1Zu_y) * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t5_l0 = rk1(i, j, k, Alpha) * (rk1chi_max * rk1Gamt_x - 2.0 * rk1Zu_x) * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t4_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_zz) * d_piR_o2_t4_m0_l0;
					m_piR_o2_t3_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yz) * d_piR_o2_t3_m0_l0;
					m_piR_o2_t2_l0 = (-rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_yy) * d_piR_o2_t2_m0_l0;
					m_piR_o2_t1_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xz) * d_piR_o2_t1_m0_l0;
					m_piR_o2_t0_l0 = (-2.0 * rk1(i, j, k, Alpha) * rk1chi_max * rk1gtu_xy) * d_piR_o2_t0_m0_l0;
					m_piR_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_piR_o1_t2_m0_l0;
					m_piR_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_piR_o1_t1_m0_l0;
					m_piR_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_piR_o1_t0_m0_l0;
					m_piR_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_piR_o0_t2_m0_l0;
					m_piR_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_piR_o0_t1_m0_l0;
					m_piR_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_piR_o0_t0_m0_l0;
					m_pheI_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_pheI_o1_t2_m0_l0;
					m_pheI_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_pheI_o1_t1_m0_l0;
					m_pheI_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_pheI_o1_t0_m0_l0;
					m_pheI_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_pheI_o0_t2_m0_l0;
					m_pheI_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_pheI_o0_t1_m0_l0;
					m_pheI_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_pheI_o0_t0_m0_l0;
					m_phiI_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_phiI_o1_t2_m0_l0;
					m_phiI_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_phiI_o1_t1_m0_l0;
					m_phiI_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_phiI_o1_t0_m0_l0;
					m_phiI_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_phiI_o0_t2_m0_l0;
					m_phiI_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_phiI_o0_t1_m0_l0;
					m_phiI_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_phiI_o0_t0_m0_l0;
					m_pheR_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_pheR_o1_t2_m0_l0;
					m_pheR_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_pheR_o1_t1_m0_l0;
					m_pheR_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_pheR_o1_t0_m0_l0;
					m_pheR_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_pheR_o0_t2_m0_l0;
					m_pheR_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_pheR_o0_t1_m0_l0;
					m_pheR_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_pheR_o0_t0_m0_l0;
					m_phiR_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_phiR_o1_t2_m0_l0;
					m_phiR_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_phiR_o1_t1_m0_l0;
					m_phiR_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_phiR_o1_t0_m0_l0;
					m_phiR_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_phiR_o0_t2_m0_l0;
					m_phiR_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_phiR_o0_t1_m0_l0;
					m_phiR_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_phiR_o0_t0_m0_l0;
					m_theta_o2_t2_l0 = (-rk1Zu_z) * d_Psi1_xx_o0_t3_m0_l0;
					m_theta_o2_t1_l0 = (-rk1Zu_y) * d_Psi1_xx_o0_t2_m0_l0;
					m_theta_o2_t0_l0 = (-rk1Zu_x) * d_Psi1_xx_o0_t1_m0_l0;
					m_theta_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_theta_o1_t2_m0_l0;
					m_theta_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_theta_o1_t1_m0_l0;
					m_theta_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_theta_o1_t0_m0_l0;
					m_theta_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_theta_o0_t2_m0_l0;
					m_theta_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_theta_o0_t1_m0_l0;
					m_theta_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_theta_o0_t0_m0_l0;
					m_trK_o2_t20_l0 = 2.0 * rk1Zu_z * d_Psi1_xx_o0_t3_m0_l0;
					m_trK_o2_t19_l0 = 2.0 * rk1Zu_y * d_Psi1_xx_o0_t2_m0_l0;
					m_trK_o2_t18_l0 = 2.0 * rk1Zu_x * d_Psi1_xx_o0_t1_m0_l0;
					m_trK_o2_t17_l0 = .5 * rk1gtu_xy * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t16_l0 = .5 * rk1gtu_xx * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t15_l0 = rk1chi_max * rk1Gamt_z * d_Psi1_xx_o0_t3_m0_l0;
					m_trK_o2_t14_l0 = rk1chi_max * rk1Gamt_y * d_Psi1_xx_o0_t2_m0_l0;
					m_trK_o2_t13_l0 = rk1chi_max * rk1Gamt_x * d_Psi1_xx_o0_t1_m0_l0;
					m_trK_o2_t12_l0 = (-rk1chi_max * rk1gtu_zz) * d_Psi1_zz_o0_t0_m0_l0;
					m_trK_o2_t11_l0 = (-rk1chi_max * rk1gtu_yy) * d_Psi1_yy_o0_t0_m0_l0;
					m_trK_o2_t10_l0 = (-2.0 * rk1chi_max * rk1gtu_yz) * d_Psi1_yz_o0_t0_m0_l0;
					m_trK_o2_t9_l0 = (-2.0 * rk1chi_max * rk1gtu_xz) * d_Psi1_xz_o0_t0_m0_l0;
					m_trK_o2_t8_l0 = (-2.0 * rk1chi_max * rk1gtu_xy) * d_Psi1_xy_o0_t0_m0_l0;
					m_trK_o2_t7_l0 = (-rk1chi_max * rk1gtu_xx) * d_Psi1_xx_o0_t0_m0_l0;
					m_trK_o2_t6_l0 = .5 * rk1gtu_zz * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o2_t5_l0 = .5 * rk1gtu_yz * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t4_l0 = .5 * rk1gtu_xz * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t3_l0 = .5 * rk1gtu_yz * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o2_t2_l0 = .5 * rk1gtu_yy * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t1_l0 = .5 * rk1gtu_xy * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t0_l0 = .5 * rk1gtu_xz * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_trK_o1_t2_m0_l0;
					m_trK_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_trK_o1_t1_m0_l0;
					m_trK_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_trK_o1_t0_m0_l0;
					m_trK_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_trK_o0_t2_m0_l0;
					m_trK_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_trK_o0_t1_m0_l0;
					m_trK_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_trK_o0_t0_m0_l0;
					m_chi_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_chi_o1_t2_m0_l0;
					m_chi_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_chi_o1_t1_m0_l0;
					m_chi_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_chi_o1_t0_m0_l0;
					m_chi_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_chi_o0_t2_m0_l0;
					m_chi_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_chi_o0_t1_m0_l0;
					m_chi_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_chi_o0_t0_m0_l0;
					m_Alpha_o1_t2_l0 = parameters.lambda_1 * std::min(0.0, rk1(i, j, k, Betau_z)) * d_Alpha_o1_t2_m0_l0;
					m_Alpha_o1_t1_l0 = parameters.lambda_1 * std::min(0.0, rk1(i, j, k, Betau_y)) * d_Alpha_o1_t1_m0_l0;
					m_Alpha_o1_t0_l0 = parameters.lambda_1 * std::min(0.0, rk1(i, j, k, Betau_x)) * d_Alpha_o1_t0_m0_l0;
					m_Alpha_o0_t2_l0 = parameters.lambda_1 * std::max(0.0, rk1(i, j, k, Betau_z)) * d_Alpha_o0_t2_m0_l0;
					m_Alpha_o0_t1_l0 = parameters.lambda_1 * std::max(0.0, rk1(i, j, k, Betau_y)) * d_Alpha_o0_t1_m0_l0;
					m_Alpha_o0_t0_l0 = parameters.lambda_1 * std::max(0.0, rk1(i, j, k, Betau_x)) * d_Alpha_o0_t0_m0_l0;
					m_Gamh_z_o2_t23_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_xz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_z_o2_t22_l0 = (-2.0 * rk1Atu_zz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_z_o2_t21_l0 = (-2.0 * rk1Atu_yz) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t20_l0 = (-2.0 * rk1Atu_xz) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_z_o2_t19_l0 = rk1gtu_zz * d_d_div_Beta_z_o0_t2_m0_l0;
					m_Gamh_z_o2_t18_l0 = 2.0 * rk1gtu_yz * d_d_div_Beta_y_o0_t2_m0_l0;
					m_Gamh_z_o2_t17_l0 = rk1gtu_yy * d_Gamh_z_o2_t17_m0_l0;
					m_Gamh_z_o2_t16_l0 = 2.0 * rk1gtu_xz * d_d_div_Beta_x_o0_t2_m0_l0;
					m_Gamh_z_o2_t15_l0 = 2.0 * rk1gtu_xy * d_Gamh_z_o2_t15_m0_l0;
					m_Gamh_z_o2_t14_l0 = rk1gtu_xx * d_Gamh_z_o2_t14_m0_l0;
					m_Gamh_z_o2_t13_l0 = (-rk1(i, j, k, Gamh_z)) * d_div_Beta_o0_t2_m0_l0;
					m_Gamh_z_o2_t12_l0 = (-rk1(i, j, k, Gamh_y)) * d_gtd_xy_o2_t2_m0_l0;
					m_Gamh_z_o2_t11_l0 = (-rk1(i, j, k, Gamh_x)) * d_gtd_xx_o2_t2_m0_l0;
					m_Gamh_z_o2_t10_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_zz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_z_o2_t9_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_yz) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t8_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_xz) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_z_o2_t7_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_zz) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_z_o2_t6_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_yz) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_z_o2_t5_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_xz) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_z_o2_t4_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_zz) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_z_o2_t3_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_yz) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_z_o2_t2_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_xz) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_z_o2_t1_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_zz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t0_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_yz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_z_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Gamh_z_o1_t2_m0_l0;
					m_Gamh_z_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Gamh_z_o1_t1_m0_l0;
					m_Gamh_z_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Gamh_z_o1_t0_m0_l0;
					m_Gamh_z_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Gamh_z_o0_t2_m0_l0;
					m_Gamh_z_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Gamh_z_o0_t1_m0_l0;
					m_Gamh_z_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Gamh_z_o0_t0_m0_l0;
					m_Betau_z_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_z)) * d_Betau_z_o2_t2_m0_l0;
					m_Betau_z_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_y)) * d_Betau_z_o2_t1_m0_l0;
					m_Betau_z_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_x)) * d_Betau_z_o2_t0_m0_l0;
					m_Betau_z_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_z)) * d_Betau_z_o1_t2_m0_l0;
					m_Betau_z_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_y)) * d_Betau_z_o1_t1_m0_l0;
					m_Betau_z_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_x)) * d_Betau_z_o1_t0_m0_l0;
					m_Betau_y_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_z)) * d_Betau_y_o2_t2_m0_l0;
					m_Betau_y_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_y)) * d_Betau_y_o2_t1_m0_l0;
					m_Betau_y_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_x)) * d_Betau_y_o2_t0_m0_l0;
					m_Betau_y_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_z)) * d_Betau_y_o1_t2_m0_l0;
					m_Betau_y_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_y)) * d_Betau_y_o1_t1_m0_l0;
					m_Betau_y_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_x)) * d_Betau_y_o1_t0_m0_l0;
					m_Betau_x_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_z)) * d_Betau_x_o2_t2_m0_l0;
					m_Betau_x_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_y)) * d_Betau_x_o2_t1_m0_l0;
					m_Betau_x_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, rk1(i, j, k, Betau_x)) * d_Betau_x_o2_t0_m0_l0;
					m_Betau_x_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_z)) * d_Betau_x_o1_t2_m0_l0;
					m_Betau_x_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_y)) * d_Betau_x_o1_t1_m0_l0;
					m_Betau_x_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, rk1(i, j, k, Betau_x)) * d_Betau_x_o1_t0_m0_l0;
					m_Gamh_y_o2_t23_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_yz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t22_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_yy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t21_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_xy) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_y_o2_t20_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_yy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t19_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_xy) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t18_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_yz) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_y_o2_t17_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_yy) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_y_o2_t16_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_xy) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_y_o2_t15_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_yz) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_y_o2_t14_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_yy) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_y_o2_t13_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_xy) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_y_o2_t12_l0 = (-2.0 * rk1Atu_yz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_y_o2_t11_l0 = (-2.0 * rk1Atu_yy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t10_l0 = (-2.0 * rk1Atu_xy) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t9_l0 = rk1gtu_zz * d_Gamh_y_o2_t9_m0_l0;
					m_Gamh_y_o2_t8_l0 = 2.0 * rk1gtu_yz * d_d_div_Beta_z_o0_t1_m0_l0;
					m_Gamh_y_o2_t7_l0 = rk1gtu_yy * d_d_div_Beta_y_o0_t1_m0_l0;
					m_Gamh_y_o2_t6_l0 = 2.0 * rk1gtu_xz * d_Gamh_y_o2_t6_m0_l0;
					m_Gamh_y_o2_t5_l0 = 2.0 * rk1gtu_xy * d_d_div_Beta_x_o0_t1_m0_l0;
					m_Gamh_y_o2_t4_l0 = rk1gtu_xx * d_Gamh_y_o2_t4_m0_l0;
					m_Gamh_y_o2_t3_l0 = (-rk1(i, j, k, Gamh_z)) * d_gtd_xz_o2_t1_m0_l0;
					m_Gamh_y_o2_t2_l0 = (-rk1(i, j, k, Gamh_y)) * d_div_Beta_o0_t1_m0_l0;
					m_Gamh_y_o2_t1_l0 = (-rk1(i, j, k, Gamh_x)) * d_gtd_xx_o2_t1_m0_l0;
					m_Gamh_y_o2_t0_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_yz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_y_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Gamh_y_o1_t2_m0_l0;
					m_Gamh_y_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Gamh_y_o1_t1_m0_l0;
					m_Gamh_y_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Gamh_y_o1_t0_m0_l0;
					m_Gamh_y_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Gamh_y_o0_t2_m0_l0;
					m_Gamh_y_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Gamh_y_o0_t1_m0_l0;
					m_Gamh_y_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Gamh_y_o0_t0_m0_l0;
					m_Gamh_x_o2_t23_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_xz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t22_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_xy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t21_l0 = (-3.0 * rk1(i, j, k, Alpha) * rk1inv_chi * rk1Atu_xx) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_x_o2_t20_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_xz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_x_o2_t19_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_xy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t18_l0 = (-2.0 * rk1(i, j, k, theta) * rk1gtu_xx) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t17_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_xz) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_x_o2_t16_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_xy) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_x_o2_t15_l0 = (-.6666666666666667 * rk1(i, j, k, Alpha) * rk1gtu_xx) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_x_o2_t14_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_xz) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_x_o2_t13_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_xy) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_x_o2_t12_l0 = (-1.333333333333333 * rk1(i, j, k, Alpha) * rk1gtu_xx) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_x_o2_t11_l0 = (-2.0 * rk1Atu_xz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_x_o2_t10_l0 = (-2.0 * rk1Atu_xy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t9_l0 = (-2.0 * rk1Atu_xx) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t8_l0 = rk1gtu_zz * d_Gamh_x_o2_t8_m0_l0;
					m_Gamh_x_o2_t7_l0 = 2.0 * rk1gtu_yz * d_Gamh_x_o2_t7_m0_l0;
					m_Gamh_x_o2_t6_l0 = rk1gtu_yy * d_Gamh_x_o2_t6_m0_l0;
					m_Gamh_x_o2_t5_l0 = 2.0 * rk1gtu_xz * d_d_div_Beta_z_o0_t0_m0_l0;
					m_Gamh_x_o2_t4_l0 = 2.0 * rk1gtu_xy * d_d_div_Beta_y_o0_t0_m0_l0;
					m_Gamh_x_o2_t3_l0 = rk1gtu_xx * d_d_div_Beta_x_o0_t0_m0_l0;
					m_Gamh_x_o2_t2_l0 = (-rk1(i, j, k, Gamh_z)) * d_gtd_xz_o2_t0_m0_l0;
					m_Gamh_x_o2_t1_l0 = (-rk1(i, j, k, Gamh_y)) * d_gtd_xy_o2_t0_m0_l0;
					m_Gamh_x_o2_t0_l0 = (-rk1(i, j, k, Gamh_x)) * d_div_Beta_o0_t0_m0_l0;
					m_Gamh_x_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Gamh_x_o1_t2_m0_l0;
					m_Gamh_x_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Gamh_x_o1_t1_m0_l0;
					m_Gamh_x_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Gamh_x_o1_t0_m0_l0;
					m_Gamh_x_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Gamh_x_o0_t2_m0_l0;
					m_Gamh_x_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Gamh_x_o0_t1_m0_l0;
					m_Gamh_x_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Gamh_x_o0_t0_m0_l0;
					m_Atd_zz_o2_t2_l0 = 2.0 * rk1(i, j, k, Atd_zz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_zz_o2_t1_l0 = 2.0 * rk1(i, j, k, Atd_yz) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_zz_o2_t0_l0 = 2.0 * rk1(i, j, k, Atd_xz) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_zz_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Atd_zz_o1_t2_m0_l0;
					m_Atd_zz_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Atd_zz_o1_t1_m0_l0;
					m_Atd_zz_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Atd_zz_o1_t0_m0_l0;
					m_Atd_zz_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Atd_zz_o0_t2_m0_l0;
					m_Atd_zz_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Atd_zz_o0_t1_m0_l0;
					m_Atd_zz_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Atd_zz_o0_t0_m0_l0;
					m_Atd_yz_o2_t5_l0 = rk1(i, j, k, Atd_zz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_yz_o2_t4_l0 = rk1(i, j, k, Atd_yz) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_yz_o2_t3_l0 = rk1(i, j, k, Atd_xz) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_yz_o2_t2_l0 = rk1(i, j, k, Atd_yz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_yz_o2_t1_l0 = rk1(i, j, k, Atd_yy) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_yz_o2_t0_l0 = rk1(i, j, k, Atd_xy) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_yz_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Atd_yz_o1_t2_m0_l0;
					m_Atd_yz_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Atd_yz_o1_t1_m0_l0;
					m_Atd_yz_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Atd_yz_o1_t0_m0_l0;
					m_Atd_yz_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Atd_yz_o0_t2_m0_l0;
					m_Atd_yz_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Atd_yz_o0_t1_m0_l0;
					m_Atd_yz_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Atd_yz_o0_t0_m0_l0;
					m_Atd_yy_o2_t2_l0 = 2.0 * rk1(i, j, k, Atd_yz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_yy_o2_t1_l0 = 2.0 * rk1(i, j, k, Atd_yy) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_yy_o2_t0_l0 = 2.0 * rk1(i, j, k, Atd_xy) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_yy_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Atd_yy_o1_t2_m0_l0;
					m_Atd_yy_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Atd_yy_o1_t1_m0_l0;
					m_Atd_yy_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Atd_yy_o1_t0_m0_l0;
					m_Atd_yy_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Atd_yy_o0_t2_m0_l0;
					m_Atd_yy_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Atd_yy_o0_t1_m0_l0;
					m_Atd_yy_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Atd_yy_o0_t0_m0_l0;
					m_Atd_xz_o2_t5_l0 = rk1(i, j, k, Atd_zz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xz_o2_t4_l0 = rk1(i, j, k, Atd_yz) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xz_o2_t3_l0 = rk1(i, j, k, Atd_xz) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xz_o2_t2_l0 = rk1(i, j, k, Atd_xz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_xz_o2_t1_l0 = rk1(i, j, k, Atd_xy) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_xz_o2_t0_l0 = rk1(i, j, k, Atd_xx) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_xz_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Atd_xz_o1_t2_m0_l0;
					m_Atd_xz_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Atd_xz_o1_t1_m0_l0;
					m_Atd_xz_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Atd_xz_o1_t0_m0_l0;
					m_Atd_xz_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Atd_xz_o0_t2_m0_l0;
					m_Atd_xz_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Atd_xz_o0_t1_m0_l0;
					m_Atd_xz_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Atd_xz_o0_t0_m0_l0;
					m_Atd_xy_o2_t5_l0 = rk1(i, j, k, Atd_yz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xy_o2_t4_l0 = rk1(i, j, k, Atd_yy) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xy_o2_t3_l0 = rk1(i, j, k, Atd_xy) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xy_o2_t2_l0 = rk1(i, j, k, Atd_xz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_xy_o2_t1_l0 = rk1(i, j, k, Atd_xy) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_xy_o2_t0_l0 = rk1(i, j, k, Atd_xx) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_xy_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Atd_xy_o1_t2_m0_l0;
					m_Atd_xy_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Atd_xy_o1_t1_m0_l0;
					m_Atd_xy_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Atd_xy_o1_t0_m0_l0;
					m_Atd_xy_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Atd_xy_o0_t2_m0_l0;
					m_Atd_xy_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Atd_xy_o0_t1_m0_l0;
					m_Atd_xy_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Atd_xy_o0_t0_m0_l0;
					m_Atd_xx_o2_t2_l0 = 2.0 * rk1(i, j, k, Atd_xz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xx_o2_t1_l0 = 2.0 * rk1(i, j, k, Atd_xy) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xx_o2_t0_l0 = 2.0 * rk1(i, j, k, Atd_xx) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xx_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_Atd_xx_o1_t2_m0_l0;
					m_Atd_xx_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_Atd_xx_o1_t1_m0_l0;
					m_Atd_xx_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_Atd_xx_o1_t0_m0_l0;
					m_Atd_xx_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_Atd_xx_o0_t2_m0_l0;
					m_Atd_xx_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_Atd_xx_o0_t1_m0_l0;
					m_Atd_xx_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_Atd_xx_o0_t0_m0_l0;
					m_gtd_zz_o2_t2_l0 = 2.0 * rk1(i, j, k, gtd_zz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_zz_o2_t1_l0 = 2.0 * rk1(i, j, k, gtd_yz) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_zz_o2_t0_l0 = 2.0 * rk1(i, j, k, gtd_xz) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_zz_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_gtd_zz_o1_t2_m0_l0;
					m_gtd_zz_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_gtd_zz_o1_t1_m0_l0;
					m_gtd_zz_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_gtd_zz_o1_t0_m0_l0;
					m_gtd_zz_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_gtd_zz_o0_t2_m0_l0;
					m_gtd_zz_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_gtd_zz_o0_t1_m0_l0;
					m_gtd_zz_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_gtd_zz_o0_t0_m0_l0;
					m_gtd_yz_o2_t5_l0 = rk1(i, j, k, gtd_zz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_yz_o2_t4_l0 = rk1(i, j, k, gtd_yz) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_yz_o2_t3_l0 = rk1(i, j, k, gtd_xz) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_yz_o2_t2_l0 = rk1(i, j, k, gtd_yz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_yz_o2_t1_l0 = rk1(i, j, k, gtd_yy) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_yz_o2_t0_l0 = rk1(i, j, k, gtd_xy) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_yz_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_gtd_yz_o1_t2_m0_l0;
					m_gtd_yz_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_gtd_yz_o1_t1_m0_l0;
					m_gtd_yz_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_gtd_yz_o1_t0_m0_l0;
					m_gtd_yz_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_gtd_yz_o0_t2_m0_l0;
					m_gtd_yz_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_gtd_yz_o0_t1_m0_l0;
					m_gtd_yz_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_gtd_yz_o0_t0_m0_l0;
					m_gtd_yy_o2_t2_l0 = 2.0 * rk1(i, j, k, gtd_yz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_yy_o2_t1_l0 = 2.0 * rk1(i, j, k, gtd_yy) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_yy_o2_t0_l0 = 2.0 * rk1(i, j, k, gtd_xy) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_yy_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_gtd_yy_o1_t2_m0_l0;
					m_gtd_yy_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_gtd_yy_o1_t1_m0_l0;
					m_gtd_yy_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_gtd_yy_o1_t0_m0_l0;
					m_gtd_yy_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_gtd_yy_o0_t2_m0_l0;
					m_gtd_yy_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_gtd_yy_o0_t1_m0_l0;
					m_gtd_yy_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_gtd_yy_o0_t0_m0_l0;
					m_gtd_xz_o2_t5_l0 = rk1(i, j, k, gtd_zz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xz_o2_t4_l0 = rk1(i, j, k, gtd_yz) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xz_o2_t3_l0 = rk1(i, j, k, gtd_xz) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xz_o2_t2_l0 = rk1(i, j, k, gtd_xz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_xz_o2_t1_l0 = rk1(i, j, k, gtd_xy) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_xz_o2_t0_l0 = rk1(i, j, k, gtd_xx) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_xz_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_gtd_xz_o1_t2_m0_l0;
					m_gtd_xz_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_gtd_xz_o1_t1_m0_l0;
					m_gtd_xz_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_gtd_xz_o1_t0_m0_l0;
					m_gtd_xz_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_gtd_xz_o0_t2_m0_l0;
					m_gtd_xz_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_gtd_xz_o0_t1_m0_l0;
					m_gtd_xz_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_gtd_xz_o0_t0_m0_l0;
					m_gtd_xy_o2_t5_l0 = rk1(i, j, k, gtd_yz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xy_o2_t4_l0 = rk1(i, j, k, gtd_yy) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xy_o2_t3_l0 = rk1(i, j, k, gtd_xy) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xy_o2_t2_l0 = rk1(i, j, k, gtd_xz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_xy_o2_t1_l0 = rk1(i, j, k, gtd_xy) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_xy_o2_t0_l0 = rk1(i, j, k, gtd_xx) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_xy_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_gtd_xy_o1_t2_m0_l0;
					m_gtd_xy_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_gtd_xy_o1_t1_m0_l0;
					m_gtd_xy_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_gtd_xy_o1_t0_m0_l0;
					m_gtd_xy_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_gtd_xy_o0_t2_m0_l0;
					m_gtd_xy_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_gtd_xy_o0_t1_m0_l0;
					m_gtd_xy_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_gtd_xy_o0_t0_m0_l0;
					m_gtd_xx_o2_t2_l0 = 2.0 * rk1(i, j, k, gtd_xz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xx_o2_t1_l0 = 2.0 * rk1(i, j, k, gtd_xy) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xx_o2_t0_l0 = 2.0 * rk1(i, j, k, gtd_xx) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xx_o1_t2_l0 = std::min(0.0, rk1(i, j, k, Betau_z)) * d_gtd_xx_o1_t2_m0_l0;
					m_gtd_xx_o1_t1_l0 = std::min(0.0, rk1(i, j, k, Betau_y)) * d_gtd_xx_o1_t1_m0_l0;
					m_gtd_xx_o1_t0_l0 = std::min(0.0, rk1(i, j, k, Betau_x)) * d_gtd_xx_o1_t0_m0_l0;
					m_gtd_xx_o0_t2_l0 = std::max(0.0, rk1(i, j, k, Betau_z)) * d_gtd_xx_o0_t2_m0_l0;
					m_gtd_xx_o0_t1_l0 = std::max(0.0, rk1(i, j, k, Betau_y)) * d_gtd_xx_o0_t1_m0_l0;
					m_gtd_xx_o0_t0_l0 = std::max(0.0, rk1(i, j, k, Betau_x)) * d_gtd_xx_o0_t0_m0_l0;
					RHS_gtd_xx = ((((((((m_gtd_xx_o0_t0_l0 + m_gtd_xx_o0_t1_l0) + m_gtd_xx_o0_t2_l0) + m_gtd_xx_o1_t0_l0) + m_gtd_xx_o1_t1_l0) + m_gtd_xx_o1_t2_l0) + m_gtd_xx_o2_t0_l0) + m_gtd_xx_o2_t1_l0) + m_gtd_xx_o2_t2_l0) + d_gtd_xx_o2_t3_m0_l0;
					RHS_gtd_xy = (((((((((((m_gtd_xy_o0_t0_l0 + m_gtd_xy_o0_t1_l0) + m_gtd_xy_o0_t2_l0) + m_gtd_xy_o1_t0_l0) + m_gtd_xy_o1_t1_l0) + m_gtd_xy_o1_t2_l0) + m_gtd_xy_o2_t0_l0) + m_gtd_xy_o2_t1_l0) + m_gtd_xy_o2_t2_l0) + m_gtd_xy_o2_t3_l0) + m_gtd_xy_o2_t4_l0) + m_gtd_xy_o2_t5_l0) + d_gtd_xy_o2_t6_m0_l0;
					RHS_gtd_xz = (((((((((((m_gtd_xz_o0_t0_l0 + m_gtd_xz_o0_t1_l0) + m_gtd_xz_o0_t2_l0) + m_gtd_xz_o1_t0_l0) + m_gtd_xz_o1_t1_l0) + m_gtd_xz_o1_t2_l0) + m_gtd_xz_o2_t0_l0) + m_gtd_xz_o2_t1_l0) + m_gtd_xz_o2_t2_l0) + m_gtd_xz_o2_t3_l0) + m_gtd_xz_o2_t4_l0) + m_gtd_xz_o2_t5_l0) + d_gtd_xz_o2_t6_m0_l0;
					RHS_gtd_yy = ((((((((m_gtd_yy_o0_t0_l0 + m_gtd_yy_o0_t1_l0) + m_gtd_yy_o0_t2_l0) + m_gtd_yy_o1_t0_l0) + m_gtd_yy_o1_t1_l0) + m_gtd_yy_o1_t2_l0) + m_gtd_yy_o2_t0_l0) + m_gtd_yy_o2_t1_l0) + m_gtd_yy_o2_t2_l0) + d_gtd_yy_o2_t3_m0_l0;
					RHS_gtd_yz = (((((((((((m_gtd_yz_o0_t0_l0 + m_gtd_yz_o0_t1_l0) + m_gtd_yz_o0_t2_l0) + m_gtd_yz_o1_t0_l0) + m_gtd_yz_o1_t1_l0) + m_gtd_yz_o1_t2_l0) + m_gtd_yz_o2_t0_l0) + m_gtd_yz_o2_t1_l0) + m_gtd_yz_o2_t2_l0) + m_gtd_yz_o2_t3_l0) + m_gtd_yz_o2_t4_l0) + m_gtd_yz_o2_t5_l0) + d_gtd_yz_o2_t6_m0_l0;
					RHS_gtd_zz = ((((((((m_gtd_zz_o0_t0_l0 + m_gtd_zz_o0_t1_l0) + m_gtd_zz_o0_t2_l0) + m_gtd_zz_o1_t0_l0) + m_gtd_zz_o1_t1_l0) + m_gtd_zz_o1_t2_l0) + m_gtd_zz_o2_t0_l0) + m_gtd_zz_o2_t1_l0) + m_gtd_zz_o2_t2_l0) + d_gtd_zz_o2_t3_m0_l0;
					RHS_Atd_xx = ((((((((m_Atd_xx_o0_t0_l0 + m_Atd_xx_o0_t1_l0) + m_Atd_xx_o0_t2_l0) + m_Atd_xx_o1_t0_l0) + m_Atd_xx_o1_t1_l0) + m_Atd_xx_o1_t2_l0) + m_Atd_xx_o2_t0_l0) + m_Atd_xx_o2_t1_l0) + m_Atd_xx_o2_t2_l0) + d_Atd_xx_o2_t3_m0_l0;
					RHS_Atd_xy = (((((((((((m_Atd_xy_o0_t0_l0 + m_Atd_xy_o0_t1_l0) + m_Atd_xy_o0_t2_l0) + m_Atd_xy_o1_t0_l0) + m_Atd_xy_o1_t1_l0) + m_Atd_xy_o1_t2_l0) + m_Atd_xy_o2_t0_l0) + m_Atd_xy_o2_t1_l0) + m_Atd_xy_o2_t2_l0) + m_Atd_xy_o2_t3_l0) + m_Atd_xy_o2_t4_l0) + m_Atd_xy_o2_t5_l0) + d_Atd_xy_o2_t6_m0_l0;
					RHS_Atd_xz = (((((((((((m_Atd_xz_o0_t0_l0 + m_Atd_xz_o0_t1_l0) + m_Atd_xz_o0_t2_l0) + m_Atd_xz_o1_t0_l0) + m_Atd_xz_o1_t1_l0) + m_Atd_xz_o1_t2_l0) + m_Atd_xz_o2_t0_l0) + m_Atd_xz_o2_t1_l0) + m_Atd_xz_o2_t2_l0) + m_Atd_xz_o2_t3_l0) + m_Atd_xz_o2_t4_l0) + m_Atd_xz_o2_t5_l0) + d_Atd_xz_o2_t6_m0_l0;
					RHS_Atd_yy = ((((((((m_Atd_yy_o0_t0_l0 + m_Atd_yy_o0_t1_l0) + m_Atd_yy_o0_t2_l0) + m_Atd_yy_o1_t0_l0) + m_Atd_yy_o1_t1_l0) + m_Atd_yy_o1_t2_l0) + m_Atd_yy_o2_t0_l0) + m_Atd_yy_o2_t1_l0) + m_Atd_yy_o2_t2_l0) + d_Atd_yy_o2_t3_m0_l0;
					RHS_Atd_yz = (((((((((((m_Atd_yz_o0_t0_l0 + m_Atd_yz_o0_t1_l0) + m_Atd_yz_o0_t2_l0) + m_Atd_yz_o1_t0_l0) + m_Atd_yz_o1_t1_l0) + m_Atd_yz_o1_t2_l0) + m_Atd_yz_o2_t0_l0) + m_Atd_yz_o2_t1_l0) + m_Atd_yz_o2_t2_l0) + m_Atd_yz_o2_t3_l0) + m_Atd_yz_o2_t4_l0) + m_Atd_yz_o2_t5_l0) + d_Atd_yz_o2_t6_m0_l0;
					RHS_Atd_zz = ((((((((m_Atd_zz_o0_t0_l0 + m_Atd_zz_o0_t1_l0) + m_Atd_zz_o0_t2_l0) + m_Atd_zz_o1_t0_l0) + m_Atd_zz_o1_t1_l0) + m_Atd_zz_o1_t2_l0) + m_Atd_zz_o2_t0_l0) + m_Atd_zz_o2_t1_l0) + m_Atd_zz_o2_t2_l0) + d_Atd_zz_o2_t3_m0_l0;
					RHS_Gamh_x = (((((((((((((((((((((((((((((m_Gamh_x_o0_t0_l0 + m_Gamh_x_o0_t1_l0) + m_Gamh_x_o0_t2_l0) + m_Gamh_x_o1_t0_l0) + m_Gamh_x_o1_t1_l0) + m_Gamh_x_o1_t2_l0) + m_Gamh_x_o2_t0_l0) + m_Gamh_x_o2_t1_l0) + m_Gamh_x_o2_t2_l0) + m_Gamh_x_o2_t3_l0) + m_Gamh_x_o2_t4_l0) + m_Gamh_x_o2_t5_l0) + m_Gamh_x_o2_t6_l0) + m_Gamh_x_o2_t7_l0) + m_Gamh_x_o2_t8_l0) + m_Gamh_x_o2_t9_l0) + m_Gamh_x_o2_t10_l0) + m_Gamh_x_o2_t11_l0) + m_Gamh_x_o2_t12_l0) + m_Gamh_x_o2_t13_l0) + m_Gamh_x_o2_t14_l0) + m_Gamh_x_o2_t15_l0) + m_Gamh_x_o2_t16_l0) + m_Gamh_x_o2_t17_l0) + m_Gamh_x_o2_t18_l0) + m_Gamh_x_o2_t19_l0) + m_Gamh_x_o2_t20_l0) + m_Gamh_x_o2_t21_l0) + m_Gamh_x_o2_t22_l0) + m_Gamh_x_o2_t23_l0) + d_Gamh_x_o2_t24_m0_l0;
					RHS_Gamh_y = (((((((((((((((((((((((((((((m_Gamh_y_o0_t0_l0 + m_Gamh_y_o0_t1_l0) + m_Gamh_y_o0_t2_l0) + m_Gamh_y_o1_t0_l0) + m_Gamh_y_o1_t1_l0) + m_Gamh_y_o1_t2_l0) + m_Gamh_y_o2_t0_l0) + m_Gamh_y_o2_t1_l0) + m_Gamh_y_o2_t2_l0) + m_Gamh_y_o2_t3_l0) + m_Gamh_y_o2_t4_l0) + m_Gamh_y_o2_t5_l0) + m_Gamh_y_o2_t6_l0) + m_Gamh_y_o2_t7_l0) + m_Gamh_y_o2_t8_l0) + m_Gamh_y_o2_t9_l0) + m_Gamh_y_o2_t10_l0) + m_Gamh_y_o2_t11_l0) + m_Gamh_y_o2_t12_l0) + m_Gamh_y_o2_t13_l0) + m_Gamh_y_o2_t14_l0) + m_Gamh_y_o2_t15_l0) + m_Gamh_y_o2_t16_l0) + m_Gamh_y_o2_t17_l0) + m_Gamh_y_o2_t18_l0) + m_Gamh_y_o2_t19_l0) + m_Gamh_y_o2_t20_l0) + m_Gamh_y_o2_t21_l0) + m_Gamh_y_o2_t22_l0) + m_Gamh_y_o2_t23_l0) + d_Gamh_y_o2_t24_m0_l0;
					RHS_Betau_x = (((((d_Betau_x_o0_t0_m0_l0 + m_Betau_x_o1_t0_l0) + m_Betau_x_o1_t1_l0) + m_Betau_x_o1_t2_l0) + m_Betau_x_o2_t0_l0) + m_Betau_x_o2_t1_l0) + m_Betau_x_o2_t2_l0;
					RHS_Betau_y = (((((d_Betau_y_o0_t0_m0_l0 + m_Betau_y_o1_t0_l0) + m_Betau_y_o1_t1_l0) + m_Betau_y_o1_t2_l0) + m_Betau_y_o2_t0_l0) + m_Betau_y_o2_t1_l0) + m_Betau_y_o2_t2_l0;
					RHS_Betau_z = (((((d_Betau_z_o0_t0_m0_l0 + m_Betau_z_o1_t0_l0) + m_Betau_z_o1_t1_l0) + m_Betau_z_o1_t2_l0) + m_Betau_z_o2_t0_l0) + m_Betau_z_o2_t1_l0) + m_Betau_z_o2_t2_l0;
					RHS_Gamh_z = (((((((((((((((((((((((((((((m_Gamh_z_o0_t0_l0 + m_Gamh_z_o0_t1_l0) + m_Gamh_z_o0_t2_l0) + m_Gamh_z_o1_t0_l0) + m_Gamh_z_o1_t1_l0) + m_Gamh_z_o1_t2_l0) + m_Gamh_z_o2_t0_l0) + m_Gamh_z_o2_t1_l0) + m_Gamh_z_o2_t2_l0) + m_Gamh_z_o2_t3_l0) + m_Gamh_z_o2_t4_l0) + m_Gamh_z_o2_t5_l0) + m_Gamh_z_o2_t6_l0) + m_Gamh_z_o2_t7_l0) + m_Gamh_z_o2_t8_l0) + m_Gamh_z_o2_t9_l0) + m_Gamh_z_o2_t10_l0) + m_Gamh_z_o2_t11_l0) + m_Gamh_z_o2_t12_l0) + m_Gamh_z_o2_t13_l0) + m_Gamh_z_o2_t14_l0) + m_Gamh_z_o2_t15_l0) + m_Gamh_z_o2_t16_l0) + m_Gamh_z_o2_t17_l0) + m_Gamh_z_o2_t18_l0) + m_Gamh_z_o2_t19_l0) + m_Gamh_z_o2_t20_l0) + m_Gamh_z_o2_t21_l0) + m_Gamh_z_o2_t22_l0) + m_Gamh_z_o2_t23_l0) + d_Gamh_z_o2_t24_m0_l0;
					RHS_Alpha = (((((m_Alpha_o0_t0_l0 + m_Alpha_o0_t1_l0) + m_Alpha_o0_t2_l0) + m_Alpha_o1_t0_l0) + m_Alpha_o1_t1_l0) + m_Alpha_o1_t2_l0) + d_Alpha_o2_t0_m0_l0;
					RHS_chi = (((((m_chi_o0_t0_l0 + m_chi_o0_t1_l0) + m_chi_o0_t2_l0) + m_chi_o1_t0_l0) + m_chi_o1_t1_l0) + m_chi_o1_t2_l0) + d_chi_o2_t0_m0_l0;
					RHS_trK = ((((((((((((((((((((((((((m_trK_o0_t0_l0 + m_trK_o0_t1_l0) + m_trK_o0_t2_l0) + m_trK_o1_t0_l0) + m_trK_o1_t1_l0) + m_trK_o1_t2_l0) + m_trK_o2_t0_l0) + m_trK_o2_t1_l0) + m_trK_o2_t2_l0) + m_trK_o2_t3_l0) + m_trK_o2_t4_l0) + m_trK_o2_t5_l0) + m_trK_o2_t6_l0) + m_trK_o2_t7_l0) + m_trK_o2_t8_l0) + m_trK_o2_t9_l0) + m_trK_o2_t10_l0) + m_trK_o2_t11_l0) + m_trK_o2_t12_l0) + m_trK_o2_t13_l0) + m_trK_o2_t14_l0) + m_trK_o2_t15_l0) + m_trK_o2_t16_l0) + m_trK_o2_t17_l0) + m_trK_o2_t18_l0) + m_trK_o2_t19_l0) + m_trK_o2_t20_l0) + d_trK_o2_t21_m0_l0;
					RHS_theta = ((((((((m_theta_o0_t0_l0 + m_theta_o0_t1_l0) + m_theta_o0_t2_l0) + m_theta_o1_t0_l0) + m_theta_o1_t1_l0) + m_theta_o1_t2_l0) + m_theta_o2_t0_l0) + m_theta_o2_t1_l0) + m_theta_o2_t2_l0) + d_theta_o2_t3_m0_l0;
					RHS_phiR = (((((m_phiR_o0_t0_l0 + m_phiR_o0_t1_l0) + m_phiR_o0_t2_l0) + m_phiR_o1_t0_l0) + m_phiR_o1_t1_l0) + m_phiR_o1_t2_l0) + rk1d_d_phiR4d_t_o0_t0_m0_l0;
					RHS_pheR = (((((m_pheR_o0_t0_l0 + m_pheR_o0_t1_l0) + m_pheR_o0_t2_l0) + m_pheR_o1_t0_l0) + m_pheR_o1_t1_l0) + m_pheR_o1_t2_l0) + rk1d_d_pheR4d_t_o0_t0_m0_l0;
					RHS_phiI = (((((m_phiI_o0_t0_l0 + m_phiI_o0_t1_l0) + m_phiI_o0_t2_l0) + m_phiI_o1_t0_l0) + m_phiI_o1_t1_l0) + m_phiI_o1_t2_l0) + rk1d_d_phiI4d_t_o0_t0_m0_l0;
					RHS_pheI = (((((m_pheI_o0_t0_l0 + m_pheI_o0_t1_l0) + m_pheI_o0_t2_l0) + m_pheI_o1_t0_l0) + m_pheI_o1_t1_l0) + m_pheI_o1_t2_l0) + rk1d_d_pheI4d_t_o0_t0_m0_l0;
					RHS_piR = ((((((((((((((((((((((((((((((((m_piR_o0_t0_l0 + m_piR_o0_t1_l0) + m_piR_o0_t2_l0) + m_piR_o1_t0_l0) + m_piR_o1_t1_l0) + m_piR_o1_t2_l0) + m_piR_o2_t0_l0) + m_piR_o2_t1_l0) + m_piR_o2_t2_l0) + m_piR_o2_t3_l0) + m_piR_o2_t4_l0) + m_piR_o2_t5_l0) + m_piR_o2_t6_l0) + m_piR_o2_t7_l0) + m_piR_o2_t8_l0) + m_piR_o2_t9_l0) + m_piR_o2_t10_l0) + m_piR_o2_t11_l0) + m_piR_o2_t12_l0) + m_piR_o2_t13_l0) + m_piR_o2_t14_l0) + m_piR_o2_t15_l0) + m_piR_o2_t16_l0) + m_piR_o2_t17_l0) + m_piR_o2_t18_l0) + m_piR_o2_t19_l0) + m_piR_o2_t20_l0) + m_piR_o2_t21_l0) + m_piR_o2_t22_l0) + m_piR_o2_t23_l0) + m_piR_o2_t24_l0) + m_piR_o2_t25_l0) + m_piR_o2_t26_l0) + d_piR_o2_t27_m0_l0;
					RHS_peR = ((((((((((((((((((((((((((((((((m_peR_o0_t0_l0 + m_peR_o0_t1_l0) + m_peR_o0_t2_l0) + m_peR_o1_t0_l0) + m_peR_o1_t1_l0) + m_peR_o1_t2_l0) + m_peR_o2_t0_l0) + m_peR_o2_t1_l0) + m_peR_o2_t2_l0) + m_peR_o2_t3_l0) + m_peR_o2_t4_l0) + m_peR_o2_t5_l0) + m_peR_o2_t6_l0) + m_peR_o2_t7_l0) + m_peR_o2_t8_l0) + m_peR_o2_t9_l0) + m_peR_o2_t10_l0) + m_peR_o2_t11_l0) + m_peR_o2_t12_l0) + m_peR_o2_t13_l0) + m_peR_o2_t14_l0) + m_peR_o2_t15_l0) + m_peR_o2_t16_l0) + m_peR_o2_t17_l0) + m_peR_o2_t18_l0) + m_peR_o2_t19_l0) + m_peR_o2_t20_l0) + m_peR_o2_t21_l0) + m_peR_o2_t22_l0) + m_peR_o2_t23_l0) + m_peR_o2_t24_l0) + m_peR_o2_t25_l0) + m_peR_o2_t26_l0) + d_peR_o2_t27_m0_l0;
					RHS_piI = ((((((((((((((((((((((((((((((((m_piI_o0_t0_l0 + m_piI_o0_t1_l0) + m_piI_o0_t2_l0) + m_piI_o1_t0_l0) + m_piI_o1_t1_l0) + m_piI_o1_t2_l0) + m_piI_o2_t0_l0) + m_piI_o2_t1_l0) + m_piI_o2_t2_l0) + m_piI_o2_t3_l0) + m_piI_o2_t4_l0) + m_piI_o2_t5_l0) + m_piI_o2_t6_l0) + m_piI_o2_t7_l0) + m_piI_o2_t8_l0) + m_piI_o2_t9_l0) + m_piI_o2_t10_l0) + m_piI_o2_t11_l0) + m_piI_o2_t12_l0) + m_piI_o2_t13_l0) + m_piI_o2_t14_l0) + m_piI_o2_t15_l0) + m_piI_o2_t16_l0) + m_piI_o2_t17_l0) + m_piI_o2_t18_l0) + m_piI_o2_t19_l0) + m_piI_o2_t20_l0) + m_piI_o2_t21_l0) + m_piI_o2_t22_l0) + m_piI_o2_t23_l0) + m_piI_o2_t24_l0) + m_piI_o2_t25_l0) + m_piI_o2_t26_l0) + d_piI_o2_t27_m0_l0;
					RHS_peI = ((((((((((((((((((((((((((((((((m_peI_o0_t0_l0 + m_peI_o0_t1_l0) + m_peI_o0_t2_l0) + m_peI_o1_t0_l0) + m_peI_o1_t1_l0) + m_peI_o1_t2_l0) + m_peI_o2_t0_l0) + m_peI_o2_t1_l0) + m_peI_o2_t2_l0) + m_peI_o2_t3_l0) + m_peI_o2_t4_l0) + m_peI_o2_t5_l0) + m_peI_o2_t6_l0) + m_peI_o2_t7_l0) + m_peI_o2_t8_l0) + m_peI_o2_t9_l0) + m_peI_o2_t10_l0) + m_peI_o2_t11_l0) + m_peI_o2_t12_l0) + m_peI_o2_t13_l0) + m_peI_o2_t14_l0) + m_peI_o2_t15_l0) + m_peI_o2_t16_l0) + m_peI_o2_t17_l0) + m_peI_o2_t18_l0) + m_peI_o2_t19_l0) + m_peI_o2_t20_l0) + m_peI_o2_t21_l0) + m_peI_o2_t22_l0) + m_peI_o2_t23_l0) + m_peI_o2_t24_l0) + m_peI_o2_t25_l0) + m_peI_o2_t26_l0) + d_peI_o2_t27_m0_l0;
					n_x = 0.0;
					n_y = 0.0;
					n_z = 0.0;
					interaction_index = 0.0;
					if ((((((regions(i + 1, j, k, FOV_xLower) > 0.0) || (regions(i + 1, j, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k, FOV_yLower) > 0.0)) || (regions(i + 1, j, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k, FOV_zLower) > 0.0)) || (regions(i + 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x + 1.0 / dx[0];
					}
					if ((((((regions(i - 1, j, k, FOV_xLower) > 0.0) || (regions(i - 1, j, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k, FOV_yLower) > 0.0)) || (regions(i - 1, j, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k, FOV_zLower) > 0.0)) || (regions(i - 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x - 1.0 / dx[0];
					}
					if ((((((regions(i, j + 1, k, FOV_xLower) > 0.0) || (regions(i, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k, FOV_yLower) > 0.0)) || (regions(i, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k, FOV_zLower) > 0.0)) || (regions(i, j + 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y + 1.0 / dx[1];
					}
					if ((((((regions(i, j - 1, k, FOV_xLower) > 0.0) || (regions(i, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k, FOV_yLower) > 0.0)) || (regions(i, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k, FOV_zLower) > 0.0)) || (regions(i, j - 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y - 1.0 / dx[1];
					}
					if ((((((regions(i, j, k + 1, FOV_xLower) > 0.0) || (regions(i, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j, k + 1, FOV_yLower) > 0.0)) || (regions(i, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j, k + 1, FOV_zLower) > 0.0)) || (regions(i, j, k + 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z + 1.0 / dx[2];
					}
					if ((((((regions(i, j, k - 1, FOV_xLower) > 0.0) || (regions(i, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j, k - 1, FOV_yLower) > 0.0)) || (regions(i, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j, k - 1, FOV_zLower) > 0.0)) || (regions(i, j, k - 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z - 1.0 / dx[2];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k, FOV_xLower) > 0.0)) || (regions(i + 1, j, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k, FOV_yLower) > 0.0)) || (regions(i + 1, j, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k, FOV_zLower) > 0.0)) || (regions(i + 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x + 1.0 / dx[0];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k, FOV_xLower) > 0.0)) || (regions(i - 1, j, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k, FOV_yLower) > 0.0)) || (regions(i - 1, j, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k, FOV_zLower) > 0.0)) || (regions(i - 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x - 1.0 / dx[0];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k, FOV_xLower) > 0.0)) || (regions(i, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k, FOV_yLower) > 0.0)) || (regions(i, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k, FOV_zLower) > 0.0)) || (regions(i, j + 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y + 1.0 / dx[1];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k, FOV_xLower) > 0.0)) || (regions(i, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k, FOV_yLower) > 0.0)) || (regions(i, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k, FOV_zLower) > 0.0)) || (regions(i, j - 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y - 1.0 / dx[1];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j, k + 1, FOV_xLower) > 0.0)) || (regions(i, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j, k + 1, FOV_yLower) > 0.0)) || (regions(i, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j, k + 1, FOV_zLower) > 0.0)) || (regions(i, j, k + 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z + 1.0 / dx[2];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j, k - 1, FOV_xLower) > 0.0)) || (regions(i, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j, k - 1, FOV_yLower) > 0.0)) || (regions(i, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j, k - 1, FOV_zLower) > 0.0)) || (regions(i, j, k - 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z - 1.0 / dx[2];
					}
					if ((!equalsEq(n_x, 0.0) || !equalsEq(n_y, 0.0)) || !equalsEq(n_z, 0.0)) {
						mod_normal = sqrt((n_x * n_x + n_y * n_y) + n_z * n_z);
						n_x = n_x / mod_normal;
						n_y = n_y / mod_normal;
						n_z = n_z / mod_normal;
					}
					if (equalsEq(interaction_index, 1.0)) {
						i_d_Atd_xx_o0_t0_m0_l0 = D1CDO4_i(Atd_xx, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xx_o0_t1_m0_l0 = D1CDO4_j(Atd_xx, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xx_o0_t2_m0_l0 = D1CDO4_k(Atd_xx, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t0_m0_l0 = D1CDO4_i(Atd_xy, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t1_m0_l0 = D1CDO4_j(Atd_xy, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t2_m0_l0 = D1CDO4_k(Atd_xy, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t0_m0_l0 = D1CDO4_i(Atd_xz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t1_m0_l0 = D1CDO4_j(Atd_xz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t2_m0_l0 = D1CDO4_k(Atd_xz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t0_m0_l0 = D1CDO4_i(Atd_yy, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t1_m0_l0 = D1CDO4_j(Atd_yy, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t2_m0_l0 = D1CDO4_k(Atd_yy, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t0_m0_l0 = D1CDO4_i(Atd_yz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t1_m0_l0 = D1CDO4_j(Atd_yz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t2_m0_l0 = D1CDO4_k(Atd_yz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t0_m0_l0 = D1CDO4_i(Atd_zz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t1_m0_l0 = D1CDO4_j(Atd_zz, rk1, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t2_m0_l0 = D1CDO4_k(Atd_zz, rk1, i, j, k, dx, dt_lev);
						i_d_piR_o0_t0_m0_l0 = D1CDO4_i(piR, rk1, i, j, k, dx, dt_lev);
						i_d_piR_o0_t1_m0_l0 = D1CDO4_j(piR, rk1, i, j, k, dx, dt_lev);
						i_d_piR_o0_t2_m0_l0 = D1CDO4_k(piR, rk1, i, j, k, dx, dt_lev);
						i_d_peR_o0_t0_m0_l0 = D1CDO4_i(peR, rk1, i, j, k, dx, dt_lev);
						i_d_peR_o0_t1_m0_l0 = D1CDO4_j(peR, rk1, i, j, k, dx, dt_lev);
						i_d_peR_o0_t2_m0_l0 = D1CDO4_k(peR, rk1, i, j, k, dx, dt_lev);
						i_d_piI_o0_t0_m0_l0 = D1CDO4_i(piI, rk1, i, j, k, dx, dt_lev);
						i_d_piI_o0_t1_m0_l0 = D1CDO4_j(piI, rk1, i, j, k, dx, dt_lev);
						i_d_piI_o0_t2_m0_l0 = D1CDO4_k(piI, rk1, i, j, k, dx, dt_lev);
						i_d_peI_o0_t0_m0_l0 = D1CDO4_i(peI, rk1, i, j, k, dx, dt_lev);
						i_d_peI_o0_t1_m0_l0 = D1CDO4_j(peI, rk1, i, j, k, dx, dt_lev);
						i_d_peI_o0_t2_m0_l0 = D1CDO4_k(peI, rk1, i, j, k, dx, dt_lev);
						i_d_gtd_xx_o0_t3_m0_l0 = -parameters.gtd_xx_falloff * (rk1(i, j, k, gtd_xx) - parameters.gtd_xx_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_xy_o0_t3_m0_l0 = -parameters.gtd_xy_falloff * (rk1(i, j, k, gtd_xy) - parameters.gtd_xy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_xz_o0_t3_m0_l0 = -parameters.gtd_xz_falloff * (rk1(i, j, k, gtd_xz) - parameters.gtd_xz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_yy_o0_t3_m0_l0 = -parameters.gtd_yy_falloff * (rk1(i, j, k, gtd_yy) - parameters.gtd_yy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_yz_o0_t3_m0_l0 = -parameters.gtd_yz_falloff * (rk1(i, j, k, gtd_yz) - parameters.gtd_yz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_zz_o0_t3_m0_l0 = -parameters.gtd_zz_falloff * (rk1(i, j, k, gtd_zz) - parameters.gtd_zz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xx_o0_t3_m0_l0 = -parameters.Atd_xx_falloff * (rk1(i, j, k, Atd_xx) - parameters.Atd_xx_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xy_o0_t3_m0_l0 = -parameters.Atd_xy_falloff * (rk1(i, j, k, Atd_xy) - parameters.Atd_xy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xz_o0_t3_m0_l0 = -parameters.Atd_xz_falloff * (rk1(i, j, k, Atd_xz) - parameters.Atd_xz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_yy_o0_t3_m0_l0 = -parameters.Atd_yy_falloff * (rk1(i, j, k, Atd_yy) - parameters.Atd_yy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_yz_o0_t3_m0_l0 = -parameters.Atd_yz_falloff * (rk1(i, j, k, Atd_yz) - parameters.Atd_yz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_zz_o0_t3_m0_l0 = -parameters.Atd_zz_falloff * (rk1(i, j, k, Atd_zz) - parameters.Atd_zz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_x_o0_t3_m0_l0 = -parameters.Gamh_x_falloff * (rk1(i, j, k, Gamh_x) - parameters.Gamh_x_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_y_o0_t3_m0_l0 = -parameters.Gamh_y_falloff * (rk1(i, j, k, Gamh_y) - parameters.Gamh_y_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_z_o0_t3_m0_l0 = -parameters.Gamh_z_falloff * (rk1(i, j, k, Gamh_z) - parameters.Gamh_z_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_x_o0_t3_m0_l0 = -parameters.Betau_x_falloff * (rk1(i, j, k, Betau_x) - parameters.Betau_x_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_y_o0_t3_m0_l0 = -parameters.Betau_y_falloff * (rk1(i, j, k, Betau_y) - parameters.Betau_y_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_z_o0_t3_m0_l0 = -parameters.Betau_z_falloff * (rk1(i, j, k, Betau_z) - parameters.Betau_z_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Alpha_o0_t3_m0_l0 = -parameters.Alpha_falloff * (rk1(i, j, k, Alpha) - parameters.Alpha_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_chi_o0_t3_m0_l0 = -parameters.chi_falloff * (rk1(i, j, k, chi) - parameters.chi_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_trK_o0_t3_m0_l0 = -parameters.trK_falloff * (rk1(i, j, k, trK) - parameters.trK_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_theta_o0_t3_m0_l0 = -parameters.theta_falloff * (rk1(i, j, k, theta) - parameters.theta_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_phiR_o0_t3_m0_l0 = -parameters.phiR_falloff * (rk1(i, j, k, phiR) - parameters.phiR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_phiI_o0_t3_m0_l0 = -parameters.phiI_falloff * (rk1(i, j, k, phiI) - parameters.phiI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_piR_o0_t3_m0_l0 = -parameters.piR_falloff * (rk1(i, j, k, piR) - parameters.piR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_piI_o0_t3_m0_l0 = -parameters.piI_falloff * (rk1(i, j, k, piI) - parameters.piI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_pheR_o0_t3_m0_l0 = -parameters.pheR_falloff * (rk1(i, j, k, pheR) - parameters.pheR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_pheI_o0_t3_m0_l0 = -parameters.pheI_falloff * (rk1(i, j, k, pheI) - parameters.pheI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_peR_o0_t3_m0_l0 = -parameters.peR_falloff * (rk1(i, j, k, peR) - parameters.peR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_peI_o0_t3_m0_l0 = -parameters.peI_falloff * (rk1(i, j, k, peI) - parameters.peI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_m_gtd_xx_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxx_o0_t0_m0_l0;
						i_m_gtd_xx_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxy_o0_t0_m0_l0;
						i_m_gtd_xx_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxz_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yxx_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyy_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t1_m0_l0;
						i_m_gtd_xz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zxx_o0_t0_m0_l0;
						i_m_gtd_xz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t0_m0_l0;
						i_m_gtd_xz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xzz_o0_t0_m0_l0;
						i_m_gtd_yy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyy_o0_t1_m0_l0;
						i_m_gtd_yy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yyy_o0_t0_m0_l0;
						i_m_gtd_yy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yyz_o0_t0_m0_l0;
						i_m_gtd_yz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t2_m0_l0;
						i_m_gtd_yz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zyy_o0_t0_m0_l0;
						i_m_gtd_yz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yzz_o0_t0_m0_l0;
						i_m_gtd_zz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xzz_o0_t1_m0_l0;
						i_m_gtd_zz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yzz_o0_t1_m0_l0;
						i_m_gtd_zz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zzz_o0_t0_m0_l0;
						i_m_Atd_xx_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t0_m0_l0;
						i_m_Atd_xx_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t1_m0_l0;
						i_m_Atd_xx_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t2_m0_l0;
						i_m_Atd_xy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t0_m0_l0;
						i_m_Atd_xy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t1_m0_l0;
						i_m_Atd_xy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t2_m0_l0;
						i_m_Atd_xz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t0_m0_l0;
						i_m_Atd_xz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t1_m0_l0;
						i_m_Atd_xz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t2_m0_l0;
						i_m_Atd_yy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t0_m0_l0;
						i_m_Atd_yy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t1_m0_l0;
						i_m_Atd_yy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t2_m0_l0;
						i_m_Atd_yz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t0_m0_l0;
						i_m_Atd_yz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t1_m0_l0;
						i_m_Atd_yz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t2_m0_l0;
						i_m_Atd_zz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t0_m0_l0;
						i_m_Atd_zz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t1_m0_l0;
						i_m_Atd_zz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t2_m0_l0;
						i_m_Gamh_x_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t6_m0_l0;
						i_m_Gamh_x_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t6_m0_l0;
						i_m_Gamh_x_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t6_m0_l0;
						i_m_Gamh_y_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t7_m0_l0;
						i_m_Gamh_y_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t7_m0_l0;
						i_m_Gamh_y_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t7_m0_l0;
						i_m_Gamh_z_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t8_m0_l0;
						i_m_Gamh_z_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t8_m0_l0;
						i_m_Gamh_z_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t8_m0_l0;
						i_m_Betau_x_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t0_m0_l0;
						i_m_Betau_x_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xy_o2_t0_m0_l0;
						i_m_Betau_x_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xz_o2_t0_m0_l0;
						i_m_Betau_y_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xx_o2_t1_m0_l0;
						i_m_Betau_y_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t1_m0_l0;
						i_m_Betau_y_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xz_o2_t1_m0_l0;
						i_m_Betau_z_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xx_o2_t2_m0_l0;
						i_m_Betau_z_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xy_o2_t2_m0_l0;
						i_m_Betau_z_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t2_m0_l0;
						i_m_Alpha_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t1_m0_l0;
						i_m_Alpha_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t2_m0_l0;
						i_m_Alpha_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t3_m0_l0;
						i_m_chi_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t0_m0_l0;
						i_m_chi_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t1_m0_l0;
						i_m_chi_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t2_m0_l0;
						i_m_trK_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t12_m0_l0;
						i_m_trK_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t13_m0_l0;
						i_m_trK_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t14_m0_l0;
						i_m_theta_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t15_m0_l0;
						i_m_theta_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t16_m0_l0;
						i_m_theta_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t17_m0_l0;
						i_m_phiR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t1_m0_l0;
						i_m_phiR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t2_m0_l0;
						i_m_phiR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t3_m0_l0;
						i_m_phiI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t1_m0_l0;
						i_m_phiI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t2_m0_l0;
						i_m_phiI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t3_m0_l0;
						i_m_piR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t0_m0_l0;
						i_m_piR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t1_m0_l0;
						i_m_piR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t2_m0_l0;
						i_m_piI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t0_m0_l0;
						i_m_piI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t1_m0_l0;
						i_m_piI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t2_m0_l0;
						i_m_pheR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t1_m0_l0;
						i_m_pheR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t2_m0_l0;
						i_m_pheR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t3_m0_l0;
						i_m_pheI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t1_m0_l0;
						i_m_pheI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t2_m0_l0;
						i_m_pheI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t3_m0_l0;
						i_m_peR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t0_m0_l0;
						i_m_peR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t1_m0_l0;
						i_m_peR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t2_m0_l0;
						i_m_peI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t0_m0_l0;
						i_m_peI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t1_m0_l0;
						i_m_peI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t2_m0_l0;
						RHS_gtd_xx = ((i_m_gtd_xx_o0_t0_l0 + i_m_gtd_xx_o0_t1_l0) + i_m_gtd_xx_o0_t2_l0) + i_d_gtd_xx_o0_t3_m0_l0;
						RHS_gtd_xy = ((i_m_gtd_xy_o0_t0_l0 + i_m_gtd_xy_o0_t1_l0) + i_m_gtd_xy_o0_t2_l0) + i_d_gtd_xy_o0_t3_m0_l0;
						RHS_gtd_xz = ((i_m_gtd_xz_o0_t0_l0 + i_m_gtd_xz_o0_t1_l0) + i_m_gtd_xz_o0_t2_l0) + i_d_gtd_xz_o0_t3_m0_l0;
						RHS_gtd_yy = ((i_m_gtd_yy_o0_t0_l0 + i_m_gtd_yy_o0_t1_l0) + i_m_gtd_yy_o0_t2_l0) + i_d_gtd_yy_o0_t3_m0_l0;
						RHS_gtd_yz = ((i_m_gtd_yz_o0_t0_l0 + i_m_gtd_yz_o0_t1_l0) + i_m_gtd_yz_o0_t2_l0) + i_d_gtd_yz_o0_t3_m0_l0;
						RHS_gtd_zz = ((i_m_gtd_zz_o0_t0_l0 + i_m_gtd_zz_o0_t1_l0) + i_m_gtd_zz_o0_t2_l0) + i_d_gtd_zz_o0_t3_m0_l0;
						RHS_Atd_xx = ((i_m_Atd_xx_o0_t0_l0 + i_m_Atd_xx_o0_t1_l0) + i_m_Atd_xx_o0_t2_l0) + i_d_Atd_xx_o0_t3_m0_l0;
						RHS_Atd_xy = ((i_m_Atd_xy_o0_t0_l0 + i_m_Atd_xy_o0_t1_l0) + i_m_Atd_xy_o0_t2_l0) + i_d_Atd_xy_o0_t3_m0_l0;
						RHS_Atd_xz = ((i_m_Atd_xz_o0_t0_l0 + i_m_Atd_xz_o0_t1_l0) + i_m_Atd_xz_o0_t2_l0) + i_d_Atd_xz_o0_t3_m0_l0;
						RHS_Atd_yy = ((i_m_Atd_yy_o0_t0_l0 + i_m_Atd_yy_o0_t1_l0) + i_m_Atd_yy_o0_t2_l0) + i_d_Atd_yy_o0_t3_m0_l0;
						RHS_Atd_yz = ((i_m_Atd_yz_o0_t0_l0 + i_m_Atd_yz_o0_t1_l0) + i_m_Atd_yz_o0_t2_l0) + i_d_Atd_yz_o0_t3_m0_l0;
						RHS_Atd_zz = ((i_m_Atd_zz_o0_t0_l0 + i_m_Atd_zz_o0_t1_l0) + i_m_Atd_zz_o0_t2_l0) + i_d_Atd_zz_o0_t3_m0_l0;
						RHS_Gamh_x = ((i_m_Gamh_x_o0_t0_l0 + i_m_Gamh_x_o0_t1_l0) + i_m_Gamh_x_o0_t2_l0) + i_d_Gamh_x_o0_t3_m0_l0;
						RHS_Gamh_y = ((i_m_Gamh_y_o0_t0_l0 + i_m_Gamh_y_o0_t1_l0) + i_m_Gamh_y_o0_t2_l0) + i_d_Gamh_y_o0_t3_m0_l0;
						RHS_Gamh_z = ((i_m_Gamh_z_o0_t0_l0 + i_m_Gamh_z_o0_t1_l0) + i_m_Gamh_z_o0_t2_l0) + i_d_Gamh_z_o0_t3_m0_l0;
						RHS_Betau_x = ((i_m_Betau_x_o0_t0_l0 + i_m_Betau_x_o0_t1_l0) + i_m_Betau_x_o0_t2_l0) + i_d_Betau_x_o0_t3_m0_l0;
						RHS_Betau_y = ((i_m_Betau_y_o0_t0_l0 + i_m_Betau_y_o0_t1_l0) + i_m_Betau_y_o0_t2_l0) + i_d_Betau_y_o0_t3_m0_l0;
						RHS_Betau_z = ((i_m_Betau_z_o0_t0_l0 + i_m_Betau_z_o0_t1_l0) + i_m_Betau_z_o0_t2_l0) + i_d_Betau_z_o0_t3_m0_l0;
						RHS_Alpha = ((i_m_Alpha_o0_t0_l0 + i_m_Alpha_o0_t1_l0) + i_m_Alpha_o0_t2_l0) + i_d_Alpha_o0_t3_m0_l0;
						RHS_chi = ((i_m_chi_o0_t0_l0 + i_m_chi_o0_t1_l0) + i_m_chi_o0_t2_l0) + i_d_chi_o0_t3_m0_l0;
						RHS_trK = ((i_m_trK_o0_t0_l0 + i_m_trK_o0_t1_l0) + i_m_trK_o0_t2_l0) + i_d_trK_o0_t3_m0_l0;
						RHS_theta = ((i_m_theta_o0_t0_l0 + i_m_theta_o0_t1_l0) + i_m_theta_o0_t2_l0) + i_d_theta_o0_t3_m0_l0;
						RHS_phiR = ((i_m_phiR_o0_t0_l0 + i_m_phiR_o0_t1_l0) + i_m_phiR_o0_t2_l0) + i_d_phiR_o0_t3_m0_l0;
						RHS_phiI = ((i_m_phiI_o0_t0_l0 + i_m_phiI_o0_t1_l0) + i_m_phiI_o0_t2_l0) + i_d_phiI_o0_t3_m0_l0;
						RHS_piR = ((i_m_piR_o0_t0_l0 + i_m_piR_o0_t1_l0) + i_m_piR_o0_t2_l0) + i_d_piR_o0_t3_m0_l0;
						RHS_piI = ((i_m_piI_o0_t0_l0 + i_m_piI_o0_t1_l0) + i_m_piI_o0_t2_l0) + i_d_piI_o0_t3_m0_l0;
						RHS_pheR = ((i_m_pheR_o0_t0_l0 + i_m_pheR_o0_t1_l0) + i_m_pheR_o0_t2_l0) + i_d_pheR_o0_t3_m0_l0;
						RHS_pheI = ((i_m_pheI_o0_t0_l0 + i_m_pheI_o0_t1_l0) + i_m_pheI_o0_t2_l0) + i_d_pheI_o0_t3_m0_l0;
						RHS_peR = ((i_m_peR_o0_t0_l0 + i_m_peR_o0_t1_l0) + i_m_peR_o0_t2_l0) + i_d_peR_o0_t3_m0_l0;
						RHS_peI = ((i_m_peI_o0_t0_l0 + i_m_peI_o0_t1_l0) + i_m_peI_o0_t2_l0) + i_d_peI_o0_t3_m0_l0;
					}
					if (parameters.dissipation_factor_gtd_xx > 0.0) {
						RHS_gtd_xx = RHS_gtd_xx + parameters.dissipation_factor_gtd_xx * (meshDissipation_i(gtd_xx, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xx, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xx, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_xy > 0.0) {
						RHS_gtd_xy = RHS_gtd_xy + parameters.dissipation_factor_gtd_xy * (meshDissipation_i(gtd_xy, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xy, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xy, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_xz > 0.0) {
						RHS_gtd_xz = RHS_gtd_xz + parameters.dissipation_factor_gtd_xz * (meshDissipation_i(gtd_xz, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xz, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xz, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_yy > 0.0) {
						RHS_gtd_yy = RHS_gtd_yy + parameters.dissipation_factor_gtd_yy * (meshDissipation_i(gtd_yy, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_yy, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_yy, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_yz > 0.0) {
						RHS_gtd_yz = RHS_gtd_yz + parameters.dissipation_factor_gtd_yz * (meshDissipation_i(gtd_yz, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_yz, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_yz, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_zz > 0.0) {
						RHS_gtd_zz = RHS_gtd_zz + parameters.dissipation_factor_gtd_zz * (meshDissipation_i(gtd_zz, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_zz, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_zz, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xx > 0.0) {
						RHS_Atd_xx = RHS_Atd_xx + parameters.dissipation_factor_Atd_xx * (meshDissipation_i(Atd_xx, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xx, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xx, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xy > 0.0) {
						RHS_Atd_xy = RHS_Atd_xy + parameters.dissipation_factor_Atd_xy * (meshDissipation_i(Atd_xy, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xy, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xy, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xz > 0.0) {
						RHS_Atd_xz = RHS_Atd_xz + parameters.dissipation_factor_Atd_xz * (meshDissipation_i(Atd_xz, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xz, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xz, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_yy > 0.0) {
						RHS_Atd_yy = RHS_Atd_yy + parameters.dissipation_factor_Atd_yy * (meshDissipation_i(Atd_yy, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_yy, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_yy, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_yz > 0.0) {
						RHS_Atd_yz = RHS_Atd_yz + parameters.dissipation_factor_Atd_yz * (meshDissipation_i(Atd_yz, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_yz, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_yz, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_zz > 0.0) {
						RHS_Atd_zz = RHS_Atd_zz + parameters.dissipation_factor_Atd_zz * (meshDissipation_i(Atd_zz, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_zz, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_zz, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_x > 0.0) {
						RHS_Gamh_x = RHS_Gamh_x + parameters.dissipation_factor_Gamh_x * (meshDissipation_i(Gamh_x, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_x, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_x, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_y > 0.0) {
						RHS_Gamh_y = RHS_Gamh_y + parameters.dissipation_factor_Gamh_y * (meshDissipation_i(Gamh_y, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_y, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_y, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_x > 0.0) {
						RHS_Betau_x = RHS_Betau_x + parameters.dissipation_factor_Betau_x * (meshDissipation_i(Betau_x, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_x, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_x, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_y > 0.0) {
						RHS_Betau_y = RHS_Betau_y + parameters.dissipation_factor_Betau_y * (meshDissipation_i(Betau_y, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_y, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_y, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_z > 0.0) {
						RHS_Betau_z = RHS_Betau_z + parameters.dissipation_factor_Betau_z * (meshDissipation_i(Betau_z, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_z, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_z, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_z > 0.0) {
						RHS_Gamh_z = RHS_Gamh_z + parameters.dissipation_factor_Gamh_z * (meshDissipation_i(Gamh_z, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_z, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_z, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_x > 0.0) {
						RHS_Betau_x = RHS_Betau_x + parameters.dissipation_factor_Betau_x * (meshDissipation_i(Betau_x, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_x, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_x, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_y > 0.0) {
						RHS_Betau_y = RHS_Betau_y + parameters.dissipation_factor_Betau_y * (meshDissipation_i(Betau_y, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_y, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_y, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_z > 0.0) {
						RHS_Betau_z = RHS_Betau_z + parameters.dissipation_factor_Betau_z * (meshDissipation_i(Betau_z, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_z, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_z, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Alpha > 0.0) {
						RHS_Alpha = RHS_Alpha + parameters.dissipation_factor_Alpha * (meshDissipation_i(Alpha, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(Alpha, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(Alpha, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_chi > 0.0) {
						RHS_chi = RHS_chi + parameters.dissipation_factor_chi * (meshDissipation_i(chi, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(chi, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(chi, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_trK > 0.0) {
						RHS_trK = RHS_trK + parameters.dissipation_factor_trK * (meshDissipation_i(trK, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(trK, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(trK, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_theta > 0.0) {
						RHS_theta = RHS_theta + parameters.dissipation_factor_theta * (meshDissipation_i(theta, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(theta, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(theta, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_phiR > 0.0) {
						RHS_phiR = RHS_phiR + parameters.dissipation_factor_phiR * (meshDissipation_i(phiR, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(phiR, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(phiR, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_pheR > 0.0) {
						RHS_pheR = RHS_pheR + parameters.dissipation_factor_pheR * (meshDissipation_i(pheR, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(pheR, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(pheR, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_phiI > 0.0) {
						RHS_phiI = RHS_phiI + parameters.dissipation_factor_phiI * (meshDissipation_i(phiI, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(phiI, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(phiI, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_pheI > 0.0) {
						RHS_pheI = RHS_pheI + parameters.dissipation_factor_pheI * (meshDissipation_i(pheI, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(pheI, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(pheI, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_piR > 0.0) {
						RHS_piR = RHS_piR + parameters.dissipation_factor_piR * (meshDissipation_i(piR, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(piR, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(piR, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_peR > 0.0) {
						RHS_peR = RHS_peR + parameters.dissipation_factor_peR * (meshDissipation_i(peR, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(peR, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(peR, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_piI > 0.0) {
						RHS_piI = RHS_piI + parameters.dissipation_factor_piI * (meshDissipation_i(piI, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(piI, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(piI, rk1, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_peI > 0.0) {
						RHS_peI = RHS_peI + parameters.dissipation_factor_peI * (meshDissipation_i(peI, rk1, i, j, k, dx, dt_lev) + meshDissipation_j(peI, rk1, i, j, k, dx, dt_lev) + meshDissipation_k(peI, rk1, i, j, k, dx, dt_lev));
					}
					rk2(i, j, k, gtd_xx) = RK4P2_(RHS_gtd_xx, un(i, j, k, gtd_xx), dx, dt_lev);
					rk2(i, j, k, gtd_xy) = RK4P2_(RHS_gtd_xy, un(i, j, k, gtd_xy), dx, dt_lev);
					rk2(i, j, k, gtd_xz) = RK4P2_(RHS_gtd_xz, un(i, j, k, gtd_xz), dx, dt_lev);
					rk2(i, j, k, gtd_yy) = RK4P2_(RHS_gtd_yy, un(i, j, k, gtd_yy), dx, dt_lev);
					rk2(i, j, k, gtd_yz) = RK4P2_(RHS_gtd_yz, un(i, j, k, gtd_yz), dx, dt_lev);
					rk2(i, j, k, gtd_zz) = RK4P2_(RHS_gtd_zz, un(i, j, k, gtd_zz), dx, dt_lev);
					rk2(i, j, k, Atd_xx) = RK4P2_(RHS_Atd_xx, un(i, j, k, Atd_xx), dx, dt_lev);
					rk2(i, j, k, Atd_xy) = RK4P2_(RHS_Atd_xy, un(i, j, k, Atd_xy), dx, dt_lev);
					rk2(i, j, k, Atd_xz) = RK4P2_(RHS_Atd_xz, un(i, j, k, Atd_xz), dx, dt_lev);
					rk2(i, j, k, Atd_yy) = RK4P2_(RHS_Atd_yy, un(i, j, k, Atd_yy), dx, dt_lev);
					rk2(i, j, k, Atd_yz) = RK4P2_(RHS_Atd_yz, un(i, j, k, Atd_yz), dx, dt_lev);
					rk2(i, j, k, Atd_zz) = RK4P2_(RHS_Atd_zz, un(i, j, k, Atd_zz), dx, dt_lev);
					rk2(i, j, k, Gamh_x) = RK4P2_(RHS_Gamh_x, un(i, j, k, Gamh_x), dx, dt_lev);
					rk2(i, j, k, Gamh_y) = RK4P2_(RHS_Gamh_y, un(i, j, k, Gamh_y), dx, dt_lev);
					rk2(i, j, k, Betau_x) = RK4P2_(RHS_Betau_x, un(i, j, k, Betau_x), dx, dt_lev);
					rk2(i, j, k, Betau_y) = RK4P2_(RHS_Betau_y, un(i, j, k, Betau_y), dx, dt_lev);
					rk2(i, j, k, Betau_z) = RK4P2_(RHS_Betau_z, un(i, j, k, Betau_z), dx, dt_lev);
					rk2(i, j, k, Gamh_z) = RK4P2_(RHS_Gamh_z, un(i, j, k, Gamh_z), dx, dt_lev);
					rk2(i, j, k, Alpha) = RK4P2_(RHS_Alpha, un(i, j, k, Alpha), dx, dt_lev);
					rk2(i, j, k, chi) = RK4P2_(RHS_chi, un(i, j, k, chi), dx, dt_lev);
					rk2(i, j, k, trK) = RK4P2_(RHS_trK, un(i, j, k, trK), dx, dt_lev);
					rk2(i, j, k, theta) = RK4P2_(RHS_theta, un(i, j, k, theta), dx, dt_lev);
					rk2(i, j, k, phiR) = RK4P2_(RHS_phiR, un(i, j, k, phiR), dx, dt_lev);
					rk2(i, j, k, pheR) = RK4P2_(RHS_pheR, un(i, j, k, pheR), dx, dt_lev);
					rk2(i, j, k, phiI) = RK4P2_(RHS_phiI, un(i, j, k, phiI), dx, dt_lev);
					rk2(i, j, k, pheI) = RK4P2_(RHS_pheI, un(i, j, k, pheI), dx, dt_lev);
					rk2(i, j, k, piR) = RK4P2_(RHS_piR, un(i, j, k, piR), dx, dt_lev);
					rk2(i, j, k, peR) = RK4P2_(RHS_peR, un(i, j, k, peR), dx, dt_lev);
					rk2(i, j, k, piI) = RK4P2_(RHS_piI, un(i, j, k, piI), dx, dt_lev);
					rk2(i, j, k, peI) = RK4P2_(RHS_peI, un(i, j, k, peI), dx, dt_lev);
				}
			});
		}
	}
	if (do_subcycle) {
		FillPatch(lev, current_time + dt_lev * 0.5, rk2_mf, unstate_var, rk1state_var, rk2state_var, rk3state_var, unp1state_var, NumFields, RK2STEP, iteration, state_interpolator_change);
	} else {
		FillPatch(lev, current_time + dt_lev * 0.5, rk2_mf, rk2state_var, NumFields, state_interpolator_change);
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> unSyncAuxFieldGroup = unSyncAuxFieldGroup_mf.array(mfi);
			Array4<Real> rk2 = rk2_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			const bool box_touches_lower_x_boundary = bx_lo.x + NUM_GHOST_CELLS == dom_lo.x;
			const bool box_touches_upper_x_boundary = bx_hi.x - NUM_GHOST_CELLS == dom_hi.x + 1;
			const bool box_touches_lower_y_boundary = bx_lo.y + NUM_GHOST_CELLS == dom_lo.y;
			const bool box_touches_upper_y_boundary = bx_hi.y - NUM_GHOST_CELLS == dom_hi.y + 1;
			const bool box_touches_lower_z_boundary = bx_lo.z + NUM_GHOST_CELLS == dom_lo.z;
			const bool box_touches_upper_z_boundary = bx_hi.z - NUM_GHOST_CELLS == dom_hi.z + 1;
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {

				if (((i + 3 <= bx_hi.x || !box_touches_upper_x_boundary) && (i - 3 >= bx_lo.x || !box_touches_lower_x_boundary) && (j + 3 <= bx_hi.y || !box_touches_upper_y_boundary) && (j - 3 >= bx_lo.y || !box_touches_lower_y_boundary) && (k + 3 <= bx_hi.z || !box_touches_upper_z_boundary) && (k - 3 >= bx_lo.z || !box_touches_lower_z_boundary))) {
					unSyncAuxFieldGroup(i, j, k, phi2) = rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI) + rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI);
				}
			});
		}
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> regions = regions_mf.array(mfi);
			Array4<Real> rk2 = rk2_mf.array(mfi);
			Array4<Real> unSyncAuxFieldGroup = unSyncAuxFieldGroup_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {

				if (i < dom_lo.x) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (i > dom_hi.x + 1) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (j < dom_lo.y) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (j > dom_hi.y + 1) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (k < dom_lo.z) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
				if (k > dom_hi.z + 1) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peI, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Alpha, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xx, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_zz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_x, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, peR, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xy, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_y, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_xz, rk2, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phi2, unSyncAuxFieldGroup, FOV_1, regions, dx);
					}
				}
			});
		}
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> rk2 = rk2_mf.array(mfi);
			Array4<Real> regions = regions_mf.array(mfi);
			Array4<Real> rk3 = rk3_mf.array(mfi);
			Array4<Real> un = un_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {
				Real d_div_Beta_o0_t0_m0_l0, d_Betau_x_o1_t0_m0_l0, d_Betau_x_o2_t0_m0_l0, d_gtd_xy_o2_t0_m0_l0, d_Betau_x_o1_t1_m0_l0, d_Betau_x_o2_t1_m0_l0, d_gtd_xz_o2_t0_m0_l0, d_Betau_x_o1_t2_m0_l0, d_Betau_x_o2_t2_m0_l0, d_d_div_Beta_x_o0_t0_m0_l0, d_d_div_Beta_y_o0_t0_m0_l0, d_d_div_Beta_z_o0_t0_m0_l0, d_Gamh_x_o2_t6_m0_l0, d_Gamh_x_o2_t7_m0_l0, d_Gamh_x_o2_t8_m0_l0, d_gtd_xx_o2_t1_m0_l0, d_Betau_y_o1_t0_m0_l0, d_Betau_y_o2_t0_m0_l0, d_div_Beta_o0_t1_m0_l0, d_Betau_y_o1_t1_m0_l0, d_Betau_y_o2_t1_m0_l0, d_gtd_xz_o2_t1_m0_l0, d_Betau_y_o1_t2_m0_l0, d_Betau_y_o2_t2_m0_l0, d_Gamh_y_o2_t4_m0_l0, d_d_div_Beta_x_o0_t1_m0_l0, d_Gamh_y_o2_t6_m0_l0, d_d_div_Beta_y_o0_t1_m0_l0, d_d_div_Beta_z_o0_t1_m0_l0, d_Gamh_y_o2_t9_m0_l0, d_gtd_xx_o2_t2_m0_l0, d_Betau_z_o1_t0_m0_l0, d_Betau_z_o2_t0_m0_l0, d_gtd_xy_o2_t2_m0_l0, d_Betau_z_o1_t1_m0_l0, d_Betau_z_o2_t1_m0_l0, d_div_Beta_o0_t2_m0_l0, d_Betau_z_o1_t2_m0_l0, d_Betau_z_o2_t2_m0_l0, d_Gamh_z_o2_t14_m0_l0, d_Gamh_z_o2_t15_m0_l0, d_d_div_Beta_x_o0_t2_m0_l0, d_Gamh_z_o2_t17_m0_l0, d_d_div_Beta_y_o0_t2_m0_l0, d_d_div_Beta_z_o0_t2_m0_l0, d_Ctd_xxx_o0_t0_m0_l0, d_gtd_xx_o0_t0_m0_l0, d_gtd_xx_o1_t0_m0_l0, d_Ctd_xxy_o0_t0_m0_l0, d_gtd_xx_o0_t1_m0_l0, d_gtd_xx_o1_t1_m0_l0, d_Ctd_xxz_o0_t0_m0_l0, d_gtd_xx_o0_t2_m0_l0, d_gtd_xx_o1_t2_m0_l0, d_Ctd_yxx_o0_t0_m0_l0, d_gtd_xy_o0_t0_m0_l0, d_gtd_xy_o1_t0_m0_l0, d_Ctd_xyy_o0_t0_m0_l0, d_gtd_xy_o0_t1_m0_l0, d_gtd_xy_o1_t1_m0_l0, d_Ctd_xyz_o0_t1_m0_l0, d_gtd_xy_o0_t2_m0_l0, d_gtd_xy_o1_t2_m0_l0, d_Ctd_xyy_o0_t1_m0_l0, d_gtd_yy_o0_t0_m0_l0, d_gtd_yy_o1_t0_m0_l0, d_Ctd_yyy_o0_t0_m0_l0, d_gtd_yy_o0_t1_m0_l0, d_gtd_yy_o1_t1_m0_l0, d_Ctd_yyz_o0_t0_m0_l0, d_gtd_yy_o0_t2_m0_l0, d_gtd_yy_o1_t2_m0_l0, d_Ctd_zxx_o0_t0_m0_l0, d_gtd_xz_o0_t0_m0_l0, d_gtd_xz_o1_t0_m0_l0, d_Ctd_xyz_o0_t0_m0_l0, d_gtd_xz_o0_t1_m0_l0, d_gtd_xz_o1_t1_m0_l0, d_Ctd_xzz_o0_t0_m0_l0, d_gtd_xz_o0_t2_m0_l0, d_gtd_xz_o1_t2_m0_l0, d_Ctd_xyz_o0_t2_m0_l0, d_gtd_yz_o0_t0_m0_l0, d_gtd_yz_o1_t0_m0_l0, d_Ctd_zyy_o0_t0_m0_l0, d_gtd_yz_o0_t1_m0_l0, d_gtd_yz_o1_t1_m0_l0, d_Ctd_yzz_o0_t0_m0_l0, d_gtd_yz_o0_t2_m0_l0, d_gtd_yz_o1_t2_m0_l0, d_Ctd_xzz_o0_t1_m0_l0, d_gtd_zz_o0_t0_m0_l0, d_gtd_zz_o1_t0_m0_l0, d_Ctd_yzz_o0_t1_m0_l0, d_gtd_zz_o0_t1_m0_l0, d_gtd_zz_o1_t1_m0_l0, d_Ctd_zzz_o0_t0_m0_l0, d_gtd_zz_o0_t2_m0_l0, d_gtd_zz_o1_t2_m0_l0, d_Rpd_xx_o0_t0_m0_l0, d_chi_o0_t0_m0_l0, d_chi_o1_t0_m0_l0, d_Rpd_xx_o0_t1_m0_l0, d_chi_o0_t1_m0_l0, d_chi_o1_t1_m0_l0, d_Rpd_xx_o0_t2_m0_l0, d_chi_o0_t2_m0_l0, d_chi_o1_t2_m0_l0, d_Rtd_xx_o0_t6_m0_l0, d_Gamh_x_o0_t0_m0_l0, d_Gamh_x_o1_t0_m0_l0, d_Rtd_xy_o0_t6_m0_l0, d_Gamh_x_o0_t1_m0_l0, d_Gamh_x_o1_t1_m0_l0, d_Rtd_xz_o0_t6_m0_l0, d_Gamh_x_o0_t2_m0_l0, d_Gamh_x_o1_t2_m0_l0, d_Rtd_xx_o0_t7_m0_l0, d_Gamh_y_o0_t0_m0_l0, d_Gamh_y_o1_t0_m0_l0, d_Rtd_xy_o0_t7_m0_l0, d_Gamh_y_o0_t1_m0_l0, d_Gamh_y_o1_t1_m0_l0, d_Rtd_xz_o0_t7_m0_l0, d_Gamh_y_o0_t2_m0_l0, d_Gamh_y_o1_t2_m0_l0, d_Rtd_xx_o0_t8_m0_l0, d_Gamh_z_o0_t1_m0_l0, d_Gamh_z_o1_t0_m0_l0, d_Rtd_xy_o0_t8_m0_l0, d_Gamh_z_o0_t2_m0_l0, d_Gamh_z_o1_t1_m0_l0, d_Rtd_xz_o0_t8_m0_l0, d_Gamh_z_o0_t0_m0_l0, d_Gamh_z_o1_t2_m0_l0, d_Psi1_xx_o0_t1_m0_l0, d_Alpha_o0_t0_m0_l0, d_Alpha_o1_t0_m0_l0, d_Psi1_xx_o0_t2_m0_l0, d_Alpha_o0_t1_m0_l0, d_Alpha_o1_t1_m0_l0, d_Psi1_xx_o0_t3_m0_l0, d_Alpha_o0_t2_m0_l0, d_Alpha_o1_t2_m0_l0, d_Psi1_xx_o0_t0_m0_l0, d_Psi1_xy_o0_t0_m0_l0, d_Psi1_xz_o0_t0_m0_l0, d_Psi1_yy_o0_t0_m0_l0, d_Psi1_yz_o0_t0_m0_l0, d_Psi1_zz_o0_t0_m0_l0, d_d_phiR4d_t_o0_t1_m0_l0, d_phiR_o0_t0_m0_l0, d_phiR_o1_t0_m0_l0, d_d_phiR4d_t_o0_t2_m0_l0, d_phiR_o0_t1_m0_l0, d_phiR_o1_t1_m0_l0, d_d_phiR4d_t_o0_t3_m0_l0, d_phiR_o0_t2_m0_l0, d_phiR_o1_t2_m0_l0, d_piR_o2_t26_m0_l0, d_piR_o2_t0_m0_l0, d_piR_o2_t1_m0_l0, d_piR_o2_t2_m0_l0, d_piR_o2_t3_m0_l0, d_piR_o2_t4_m0_l0, d_d_phiI4d_t_o0_t1_m0_l0, d_phiI_o0_t0_m0_l0, d_phiI_o1_t0_m0_l0, d_d_phiI4d_t_o0_t2_m0_l0, d_phiI_o0_t1_m0_l0, d_phiI_o1_t1_m0_l0, d_d_phiI4d_t_o0_t3_m0_l0, d_phiI_o0_t2_m0_l0, d_phiI_o1_t2_m0_l0, d_piI_o2_t24_m0_l0, d_piI_o2_t25_m0_l0, d_piI_o2_t26_m0_l0, d_piI_o2_t0_m0_l0, d_piI_o2_t1_m0_l0, d_piI_o2_t2_m0_l0, d_d_pheR4d_t_o0_t1_m0_l0, d_pheR_o0_t0_m0_l0, d_pheR_o1_t0_m0_l0, d_d_pheR4d_t_o0_t2_m0_l0, d_pheR_o0_t1_m0_l0, d_pheR_o1_t1_m0_l0, d_d_pheR4d_t_o0_t3_m0_l0, d_pheR_o0_t2_m0_l0, d_pheR_o1_t2_m0_l0, d_peR_o2_t24_m0_l0, d_peR_o2_t25_m0_l0, d_peR_o2_t26_m0_l0, d_peR_o2_t0_m0_l0, d_peR_o2_t1_m0_l0, d_peR_o2_t2_m0_l0, d_d_pheI4d_t_o0_t1_m0_l0, d_pheI_o0_t0_m0_l0, d_pheI_o1_t0_m0_l0, d_d_pheI4d_t_o0_t2_m0_l0, d_pheI_o0_t1_m0_l0, d_pheI_o1_t1_m0_l0, d_d_pheI4d_t_o0_t3_m0_l0, d_pheI_o0_t2_m0_l0, d_pheI_o1_t2_m0_l0, d_peI_o2_t22_m0_l0, d_peI_o2_t23_m0_l0, d_peI_o2_t24_m0_l0, d_peI_o2_t25_m0_l0, d_peI_o2_t26_m0_l0, d_peI_o2_t0_m0_l0, d_Atd_xx_o0_t0_m0_l0, d_Atd_xx_o1_t0_m0_l0, d_Atd_xx_o0_t1_m0_l0, d_Atd_xx_o1_t1_m0_l0, d_Atd_xx_o0_t2_m0_l0, d_Atd_xx_o1_t2_m0_l0, d_Atd_xy_o0_t0_m0_l0, d_Atd_xy_o1_t0_m0_l0, d_Atd_xy_o0_t1_m0_l0, d_Atd_xy_o1_t1_m0_l0, d_Atd_xy_o0_t2_m0_l0, d_Atd_xy_o1_t2_m0_l0, d_Atd_xz_o0_t0_m0_l0, d_Atd_xz_o1_t0_m0_l0, d_Atd_xz_o0_t1_m0_l0, d_Atd_xz_o1_t1_m0_l0, d_Atd_xz_o0_t2_m0_l0, d_Atd_xz_o1_t2_m0_l0, d_Atd_yy_o0_t0_m0_l0, d_Atd_yy_o1_t0_m0_l0, d_Atd_yy_o0_t1_m0_l0, d_Atd_yy_o1_t1_m0_l0, d_Atd_yy_o0_t2_m0_l0, d_Atd_yy_o1_t2_m0_l0, d_Atd_yz_o0_t0_m0_l0, d_Atd_yz_o1_t0_m0_l0, d_Atd_yz_o0_t1_m0_l0, d_Atd_yz_o1_t1_m0_l0, d_Atd_yz_o0_t2_m0_l0, d_Atd_yz_o1_t2_m0_l0, d_Atd_zz_o0_t0_m0_l0, d_Atd_zz_o1_t0_m0_l0, d_Atd_zz_o0_t1_m0_l0, d_Atd_zz_o1_t1_m0_l0, d_Atd_zz_o0_t2_m0_l0, d_Atd_zz_o1_t2_m0_l0, d_Gamh_x_o2_t12_m0_l0, d_trK_o0_t0_m0_l0, d_trK_o1_t0_m0_l0, d_Gamh_x_o2_t13_m0_l0, d_trK_o0_t1_m0_l0, d_trK_o1_t1_m0_l0, d_Gamh_x_o2_t14_m0_l0, d_trK_o0_t2_m0_l0, d_trK_o1_t2_m0_l0, d_Gamh_x_o2_t15_m0_l0, d_theta_o0_t0_m0_l0, d_theta_o1_t0_m0_l0, d_Gamh_x_o2_t16_m0_l0, d_theta_o0_t1_m0_l0, d_theta_o1_t1_m0_l0, d_Gamh_x_o2_t17_m0_l0, d_theta_o0_t2_m0_l0, d_theta_o1_t2_m0_l0, d_piR_o0_t0_m0_l0, d_piR_o1_t0_m0_l0, d_piR_o0_t1_m0_l0, d_piR_o1_t1_m0_l0, d_piR_o0_t2_m0_l0, d_piR_o1_t2_m0_l0, d_peR_o0_t0_m0_l0, d_peR_o1_t0_m0_l0, d_peR_o0_t1_m0_l0, d_peR_o1_t1_m0_l0, d_peR_o0_t2_m0_l0, d_peR_o1_t2_m0_l0, d_piI_o0_t0_m0_l0, d_piI_o1_t0_m0_l0, d_piI_o0_t1_m0_l0, d_piI_o1_t1_m0_l0, d_piI_o0_t2_m0_l0, d_piI_o1_t2_m0_l0, d_peI_o0_t0_m0_l0, d_peI_o1_t2_m0_l0, d_peI_o0_t1_m0_l0, d_peI_o1_t0_m0_l0, d_peI_o0_t2_m0_l0, d_peI_o1_t1_m0_l0, d_Rtd_xx_o0_t0_m0_l0, d_Rtd_xx_o0_t1_m0_l0, d_Rtd_xx_o0_t2_m0_l0, d_Rtd_xx_o0_t3_m0_l0, d_Rtd_xx_o0_t4_m0_l0, d_Rtd_xx_o0_t5_m0_l0, d_Rtd_xy_o0_t0_m0_l0, d_Rtd_xy_o0_t1_m0_l0, d_Rtd_xy_o0_t2_m0_l0, d_Rtd_xy_o0_t3_m0_l0, d_Rtd_xy_o0_t4_m0_l0, d_Rtd_xy_o0_t5_m0_l0, d_Rtd_yy_o0_t0_m0_l0, d_Rtd_yy_o0_t1_m0_l0, d_Rtd_yy_o0_t2_m0_l0, d_Rtd_yy_o0_t3_m0_l0, d_Rtd_yy_o0_t4_m0_l0, d_Rtd_yy_o0_t5_m0_l0, d_Rtd_xz_o0_t0_m0_l0, d_Rtd_xz_o0_t1_m0_l0, d_Rtd_xz_o0_t2_m0_l0, d_Rtd_xz_o0_t3_m0_l0, d_Rtd_xz_o0_t4_m0_l0, d_Rtd_xz_o0_t5_m0_l0, d_Rtd_yz_o0_t0_m0_l0, d_Rtd_yz_o0_t1_m0_l0, d_Rtd_yz_o0_t2_m0_l0, d_Rtd_yz_o0_t3_m0_l0, d_Rtd_yz_o0_t4_m0_l0, d_Rtd_yz_o0_t5_m0_l0, d_Rtd_zz_o0_t0_m0_l0, d_Rtd_zz_o0_t1_m0_l0, d_Rtd_zz_o0_t2_m0_l0, d_Rtd_zz_o0_t3_m0_l0, d_Rtd_zz_o0_t4_m0_l0, d_Rtd_zz_o0_t5_m0_l0, d_Rpd_xx_o0_t3_m0_l0, d_Rpd_xx_o0_t4_m0_l0, d_Rpd_xx_o0_t5_m0_l0, d_Rpd_xx_o0_t6_m0_l0, d_Rpd_xx_o0_t7_m0_l0, d_Rpd_xx_o0_t8_m0_l0, rk2m_Ctd_yyz_o0_t0_l0, rk2Ctd_yyz, rk2m_Ctd_yyy_o0_t0_l0, rk2Ctd_yyy, rk2div_Beta, rk2m_Ctd_xxz_o0_t0_l0, rk2Ctd_xxz, rk2m_Ctd_xxx_o0_t0_l0, rk2Ctd_xxx, rk2m_Ctd_yzz_o0_t1_l0, rk2m_Ctd_yzz_o0_t0_l0, rk2Ctd_yzz, rk2m_Ctd_xxy_o0_t0_l0, rk2Ctd_xxy, rk2sfmass, rk2dVdphe2, rk2kappa_z2, rk2m_Ctd_xyy_o0_t1_l0, rk2m_Ctd_xyy_o0_t0_l0, rk2Ctd_xyy, rk2m_Ctd_xyz_o0_t2_l0, rk2m_Ctd_xyz_o0_t1_l0, rk2m_Ctd_xyz_o0_t0_l0, rk2Ctd_xyz, rk2d_div_Beta_y, rk2d_div_Beta_x, rk2d_div_Beta_z, rk2m_Ctd_xzz_o0_t1_l0, rk2m_Ctd_xzz_o0_t0_l0, rk2Ctd_xzz, rk2dVdphi2, rk2d_d_phiI4d_t_o0_t0_m0_l0, rk2m_d_phiI4d_t_o0_t6_l0, rk2m_d_phiI4d_t_o0_t5_l0, rk2m_d_phiI4d_t_o0_t4_l0, rk2m_d_phiI4d_t_o0_t3_l0, rk2m_d_phiI4d_t_o0_t2_l0, rk2m_d_phiI4d_t_o0_t1_l0, rk2d_phiI4d_t, rk2d_phiI4d_x, rk2d_phiI4d_y, rk2d_phiI4d_z, rk2g4u_tx, rk2g4u_tz, rk2g4u_ty, rk2g4u_tt, rk2d_phiI4u_t, rk2sfVe, rk2sfVi, rk2m_Ctd_zxz_o0_t0_l0, rk2Ctd_zxz, rk2m_Ctd_zxx_o0_t1_l0, rk2m_Ctd_zxx_o0_t0_l0, rk2Ctd_zxx, rk2detgtd, rk2d_d_phiR4d_t_o0_t0_m0_l0, rk2m_d_phiR4d_t_o0_t6_l0, rk2m_d_phiR4d_t_o0_t5_l0, rk2m_d_phiR4d_t_o0_t4_l0, rk2m_d_phiR4d_t_o0_t3_l0, rk2m_d_phiR4d_t_o0_t2_l0, rk2m_d_phiR4d_t_o0_t1_l0, rk2d_phiR4d_t, rk2d_phiR4d_x, rk2d_phiR4d_z, rk2d_phiR4d_y, rk2d_phiR4u_t, rk2chi_max, rk2inv_chi, rk2d_d_pheR4d_t_o0_t0_m0_l0, rk2m_d_pheR4d_t_o0_t6_l0, rk2m_d_pheR4d_t_o0_t5_l0, rk2m_d_pheR4d_t_o0_t4_l0, rk2m_d_pheR4d_t_o0_t3_l0, rk2m_d_pheR4d_t_o0_t2_l0, rk2m_d_pheR4d_t_o0_t1_l0, rk2d_pheR4d_t, rk2d_pheR4d_x, rk2d_pheR4d_y, rk2d_pheR4d_z, rk2d_pheR4u_t, rk2m_Ctd_zyy_o0_t1_l0, rk2m_Ctd_zyy_o0_t0_l0, rk2Ctd_zyy, rk2m_Ctd_zyz_o0_t0_l0, rk2Ctd_zyz, rk2Betatd_x, rk2Betatd_z, rk2Betatd_y, rk2idetgtd, rk2gtu_zz, rk2g4u_zz, rk2gtu_yy, rk2g4u_yy, rk2gtu_yz, rk2g4u_yz, rk2gtu_xx, rk2g4u_xx, rk2gtu_xz, rk2g4u_xz, rk2d_pheR4u_z, rk2d_phiR4u_z, rk2d_phiI4u_z, rk2Ct_zyz, rk2Ct_zyy, rk2Atud_zx, rk2Atud_zz, rk2Atud_zy, rk2Atu_zz, rk2gtu_xy, rk2g4u_xy, rk2d_pheR4u_x, rk2d_pheR4u_y, rk2d_phiR4u_y, rk2d_phiR4u_x, rk2d_phiI4u_y, rk2d_phiI4u_x, rk2dphi4sq, rk2Atud_yy, rk2Atud_yx, rk2Atud_yz, rk2Atu_yz, rk2Atu_yy, rk2Ct_yyy, rk2Ct_yyz, rk2Atud_xx, rk2trAt, rk2Atud_xz, rk2Atud_xy, rk2Atu_xz, rk2Atu_xy, rk2Atu_xx, rk2decay_factor, rk2kappa_z1, rk2feta, rk2m_Ctd_zzz_o0_t0_l0, rk2Ctd_zzz, rk2Ct_xzz, rk2Ct_zzz, rk2Ct_yzz, rk2m_Ctd_yxy_o0_t0_l0, rk2Ctd_yxy, rk2Ct_xyz, rk2m_Ctd_yxz_o0_t2_l0, rk2m_Ctd_yxz_o0_t0_l0, rk2Ctd_yxz, rk2Ct_zxz, rk2Ct_yxz, rk2m_Ctd_zxy_o0_t2_l0, rk2Ctd_zxy, rk2Ct_zxy, rk2Ct_yxy, rk2Ct_xxy, rk2Ct_xxz, rk2Ct_xyy, rk2m_Ctd_yxx_o0_t1_l0, rk2m_Ctd_yxx_o0_t0_l0, rk2Ctd_yxx, rk2Ct_zxx, rk2Gamt_z, rk2Zu_z, rk2Ct_yxx, rk2Gamt_y, rk2Zu_y, rk2Ct_xxx, rk2Gamt_x, rk2Zu_x, rk2d_Rtd_xx_o0_t9_m0_l0, rk2m_Rtd_xx_o0_t8_l0, rk2m_Rtd_xx_o0_t7_l0, rk2m_Rtd_xx_o0_t6_l0, rk2m_Rtd_xx_o0_t5_l0, rk2m_Rtd_xx_o0_t4_l0, rk2m_Rtd_xx_o0_t3_l0, rk2m_Rtd_xx_o0_t2_l0, rk2m_Rtd_xx_o0_t1_l0, rk2m_Rtd_xx_o0_t0_l0, rk2Rtd_xx, rk2d_Rtd_xz_o0_t12_m0_l0, rk2m_Rtd_xz_o0_t11_l0, rk2m_Rtd_xz_o0_t10_l0, rk2m_Rtd_xz_o0_t9_l0, rk2m_Rtd_xz_o0_t8_l0, rk2m_Rtd_xz_o0_t7_l0, rk2m_Rtd_xz_o0_t6_l0, rk2m_Rtd_xz_o0_t5_l0, rk2m_Rtd_xz_o0_t4_l0, rk2m_Rtd_xz_o0_t3_l0, rk2m_Rtd_xz_o0_t2_l0, rk2m_Rtd_xz_o0_t1_l0, rk2m_Rtd_xz_o0_t0_l0, rk2Rtd_xz, rk2d_Rtd_zz_o0_t9_m0_l0, rk2m_Rtd_zz_o0_t8_l0, rk2m_Rtd_zz_o0_t7_l0, rk2m_Rtd_zz_o0_t6_l0, rk2m_Rtd_zz_o0_t5_l0, rk2m_Rtd_zz_o0_t4_l0, rk2m_Rtd_zz_o0_t3_l0, rk2m_Rtd_zz_o0_t2_l0, rk2m_Rtd_zz_o0_t1_l0, rk2m_Rtd_zz_o0_t0_l0, rk2Rtd_zz, rk2d_Rtd_xy_o0_t12_m0_l0, rk2m_Rtd_xy_o0_t11_l0, rk2m_Rtd_xy_o0_t10_l0, rk2m_Rtd_xy_o0_t9_l0, rk2m_Rtd_xy_o0_t8_l0, rk2m_Rtd_xy_o0_t7_l0, rk2m_Rtd_xy_o0_t6_l0, rk2m_Rtd_xy_o0_t5_l0, rk2m_Rtd_xy_o0_t4_l0, rk2m_Rtd_xy_o0_t3_l0, rk2m_Rtd_xy_o0_t2_l0, rk2m_Rtd_xy_o0_t1_l0, rk2m_Rtd_xy_o0_t0_l0, rk2Rtd_xy, rk2d_Rtd_yy_o0_t9_m0_l0, rk2m_Rtd_yy_o0_t8_l0, rk2m_Rtd_yy_o0_t7_l0, rk2m_Rtd_yy_o0_t6_l0, rk2m_Rtd_yy_o0_t5_l0, rk2m_Rtd_yy_o0_t4_l0, rk2m_Rtd_yy_o0_t3_l0, rk2m_Rtd_yy_o0_t2_l0, rk2m_Rtd_yy_o0_t1_l0, rk2m_Rtd_yy_o0_t0_l0, rk2Rtd_yy, rk2d_Rtd_yz_o0_t12_m0_l0, rk2m_Rtd_yz_o0_t11_l0, rk2m_Rtd_yz_o0_t10_l0, rk2m_Rtd_yz_o0_t9_l0, rk2m_Rtd_yz_o0_t8_l0, rk2m_Rtd_yz_o0_t7_l0, rk2m_Rtd_yz_o0_t6_l0, rk2m_Rtd_yz_o0_t5_l0, rk2m_Rtd_yz_o0_t4_l0, rk2m_Rtd_yz_o0_t3_l0, rk2m_Rtd_yz_o0_t2_l0, rk2m_Rtd_yz_o0_t1_l0, rk2m_Rtd_yz_o0_t0_l0, rk2Rtd_yz, rk2m_Rpd_xx_o0_t22_l0, rk2m_Rpd_xx_o0_t21_l0, rk2m_Rpd_xx_o0_t20_l0, rk2m_Rpd_xx_o0_t19_l0, rk2m_Rpd_xx_o0_t18_l0, rk2m_Rpd_xx_o0_t17_l0, rk2m_Rpd_xx_o0_t16_l0, rk2m_Rpd_xx_o0_t15_l0, rk2m_Rpd_xx_o0_t14_l0, rk2m_Rpd_xx_o0_t13_l0, rk2m_Rpd_xx_o0_t12_l0, rk2m_Rpd_xx_o0_t11_l0, rk2m_Rpd_xx_o0_t10_l0, rk2m_Rpd_xx_o0_t9_l0, rk2m_Rpd_xx_o0_t8_l0, rk2m_Rpd_xx_o0_t7_l0, rk2m_Rpd_xx_o0_t6_l0, rk2m_Rpd_xx_o0_t5_l0, rk2m_Rpd_xx_o0_t4_l0, rk2m_Rpd_xx_o0_t3_l0, rk2m_Rpd_xx_o0_t2_l0, rk2m_Rpd_xx_o0_t1_l0, rk2m_Rpd_xx_o0_t0_l0, rk2Rpd_xx, rk2m_Rpd_yy_o0_t22_l0, rk2m_Rpd_yy_o0_t21_l0, rk2m_Rpd_yy_o0_t20_l0, rk2m_Rpd_yy_o0_t19_l0, rk2m_Rpd_yy_o0_t18_l0, rk2m_Rpd_yy_o0_t17_l0, rk2m_Rpd_yy_o0_t16_l0, rk2m_Rpd_yy_o0_t15_l0, rk2m_Rpd_yy_o0_t14_l0, rk2m_Rpd_yy_o0_t13_l0, rk2m_Rpd_yy_o0_t12_l0, rk2m_Rpd_yy_o0_t11_l0, rk2m_Rpd_yy_o0_t10_l0, rk2m_Rpd_yy_o0_t9_l0, rk2m_Rpd_yy_o0_t8_l0, rk2m_Rpd_yy_o0_t7_l0, rk2m_Rpd_yy_o0_t6_l0, rk2m_Rpd_yy_o0_t5_l0, rk2m_Rpd_yy_o0_t4_l0, rk2m_Rpd_yy_o0_t3_l0, rk2m_Rpd_yy_o0_t2_l0, rk2m_Rpd_yy_o0_t1_l0, rk2m_Rpd_yy_o0_t0_l0, rk2Rpd_yy, rk2m_Rpd_yz_o0_t25_l0, rk2m_Rpd_yz_o0_t24_l0, rk2m_Rpd_yz_o0_t23_l0, rk2m_Rpd_yz_o0_t22_l0, rk2m_Rpd_yz_o0_t21_l0, rk2m_Rpd_yz_o0_t20_l0, rk2m_Rpd_yz_o0_t19_l0, rk2m_Rpd_yz_o0_t18_l0, rk2m_Rpd_yz_o0_t17_l0, rk2m_Rpd_yz_o0_t16_l0, rk2m_Rpd_yz_o0_t15_l0, rk2m_Rpd_yz_o0_t14_l0, rk2m_Rpd_yz_o0_t13_l0, rk2m_Rpd_yz_o0_t12_l0, rk2m_Rpd_yz_o0_t11_l0, rk2m_Rpd_yz_o0_t10_l0, rk2m_Rpd_yz_o0_t9_l0, rk2m_Rpd_yz_o0_t8_l0, rk2m_Rpd_yz_o0_t7_l0, rk2m_Rpd_yz_o0_t6_l0, rk2m_Rpd_yz_o0_t5_l0, rk2m_Rpd_yz_o0_t4_l0, rk2m_Rpd_yz_o0_t3_l0, rk2m_Rpd_yz_o0_t2_l0, rk2m_Rpd_yz_o0_t1_l0, rk2m_Rpd_yz_o0_t0_l0, rk2Rpd_yz, rk2m_Rpd_xz_o0_t25_l0, rk2m_Rpd_xz_o0_t24_l0, rk2m_Rpd_xz_o0_t23_l0, rk2m_Rpd_xz_o0_t22_l0, rk2m_Rpd_xz_o0_t21_l0, rk2m_Rpd_xz_o0_t20_l0, rk2m_Rpd_xz_o0_t19_l0, rk2m_Rpd_xz_o0_t18_l0, rk2m_Rpd_xz_o0_t17_l0, rk2m_Rpd_xz_o0_t16_l0, rk2m_Rpd_xz_o0_t15_l0, rk2m_Rpd_xz_o0_t14_l0, rk2m_Rpd_xz_o0_t13_l0, rk2m_Rpd_xz_o0_t12_l0, rk2m_Rpd_xz_o0_t11_l0, rk2m_Rpd_xz_o0_t10_l0, rk2m_Rpd_xz_o0_t9_l0, rk2m_Rpd_xz_o0_t8_l0, rk2m_Rpd_xz_o0_t7_l0, rk2m_Rpd_xz_o0_t6_l0, rk2m_Rpd_xz_o0_t5_l0, rk2m_Rpd_xz_o0_t4_l0, rk2m_Rpd_xz_o0_t3_l0, rk2m_Rpd_xz_o0_t2_l0, rk2m_Rpd_xz_o0_t1_l0, rk2m_Rpd_xz_o0_t0_l0, rk2Rpd_xz, rk2m_Rpd_xy_o0_t25_l0, rk2m_Rpd_xy_o0_t24_l0, rk2m_Rpd_xy_o0_t23_l0, rk2m_Rpd_xy_o0_t22_l0, rk2m_Rpd_xy_o0_t21_l0, rk2m_Rpd_xy_o0_t20_l0, rk2m_Rpd_xy_o0_t19_l0, rk2m_Rpd_xy_o0_t18_l0, rk2m_Rpd_xy_o0_t17_l0, rk2m_Rpd_xy_o0_t16_l0, rk2m_Rpd_xy_o0_t15_l0, rk2m_Rpd_xy_o0_t14_l0, rk2m_Rpd_xy_o0_t13_l0, rk2m_Rpd_xy_o0_t12_l0, rk2m_Rpd_xy_o0_t11_l0, rk2m_Rpd_xy_o0_t10_l0, rk2m_Rpd_xy_o0_t9_l0, rk2m_Rpd_xy_o0_t8_l0, rk2m_Rpd_xy_o0_t7_l0, rk2m_Rpd_xy_o0_t6_l0, rk2m_Rpd_xy_o0_t5_l0, rk2m_Rpd_xy_o0_t4_l0, rk2m_Rpd_xy_o0_t3_l0, rk2m_Rpd_xy_o0_t2_l0, rk2m_Rpd_xy_o0_t1_l0, rk2m_Rpd_xy_o0_t0_l0, rk2Rpd_xy, rk2m_Rpd_zz_o0_t22_l0, rk2m_Rpd_zz_o0_t21_l0, rk2m_Rpd_zz_o0_t20_l0, rk2m_Rpd_zz_o0_t19_l0, rk2m_Rpd_zz_o0_t18_l0, rk2m_Rpd_zz_o0_t17_l0, rk2m_Rpd_zz_o0_t16_l0, rk2m_Rpd_zz_o0_t15_l0, rk2m_Rpd_zz_o0_t14_l0, rk2m_Rpd_zz_o0_t13_l0, rk2m_Rpd_zz_o0_t12_l0, rk2m_Rpd_zz_o0_t11_l0, rk2m_Rpd_zz_o0_t10_l0, rk2m_Rpd_zz_o0_t9_l0, rk2m_Rpd_zz_o0_t8_l0, rk2m_Rpd_zz_o0_t7_l0, rk2m_Rpd_zz_o0_t6_l0, rk2m_Rpd_zz_o0_t5_l0, rk2m_Rpd_zz_o0_t4_l0, rk2m_Rpd_zz_o0_t3_l0, rk2m_Rpd_zz_o0_t2_l0, rk2m_Rpd_zz_o0_t1_l0, rk2m_Rpd_zz_o0_t0_l0, rk2Rpd_zz, rk2Rscalar, rk2d_d_pheI4d_t_o0_t0_m0_l0, rk2m_d_pheI4d_t_o0_t6_l0, rk2m_d_pheI4d_t_o0_t5_l0, rk2m_d_pheI4d_t_o0_t4_l0, rk2m_d_pheI4d_t_o0_t3_l0, rk2m_d_pheI4d_t_o0_t2_l0, rk2m_d_pheI4d_t_o0_t1_l0, rk2d_pheI4d_t, rk2d_pheI4d_z, rk2d_pheI4d_y, rk2d_pheI4d_x, rk2d_pheI4u_t, rk2d_pheI4u_z, rk2d_pheI4u_y, rk2d_pheI4u_x, rk2dphe4sq, rk2Tsfu_zz, rk2Tu_zz, rk2Tsfu_yz, rk2Tu_yz, rk2Tsfu_yy, rk2Tu_yy, rk2Tsfu_xz, rk2Tu_xz, rk2Tsfu_xy, rk2Tu_xy, rk2Tsfu_xx, rk2Tu_xx, rk2Tsfu_tt, rk2Tu_tt, rk2Tsfu_tz, rk2Tu_tz, rk2Tsfu_ty, rk2Tu_ty, rk2Tsfu_tx, rk2Tu_tx, rk2pTtd_ADM_xz, rk2pTtd_ADM_xy, rk2pTtd_ADM_xx, rk2d_Psi1_xx_o0_t5_m0_l0, rk2m_Psi1_xx_o0_t4_l0, rk2m_Psi1_xx_o0_t3_l0, rk2m_Psi1_xx_o0_t2_l0, rk2m_Psi1_xx_o0_t1_l0, rk2m_Psi1_xx_o0_t0_l0, rk2Psi1_xx, rk2d_Psi1_xy_o0_t6_m0_l0, rk2m_Psi1_xy_o0_t5_l0, rk2m_Psi1_xy_o0_t4_l0, rk2m_Psi1_xy_o0_t3_l0, rk2m_Psi1_xy_o0_t2_l0, rk2m_Psi1_xy_o0_t1_l0, rk2m_Psi1_xy_o0_t0_l0, rk2Psi1_xy, rk2d_Psi1_xz_o0_t6_m0_l0, rk2m_Psi1_xz_o0_t5_l0, rk2m_Psi1_xz_o0_t4_l0, rk2m_Psi1_xz_o0_t3_l0, rk2m_Psi1_xz_o0_t2_l0, rk2m_Psi1_xz_o0_t1_l0, rk2m_Psi1_xz_o0_t0_l0, rk2Psi1_xz, rk2Jtd_ADM_z, rk2pTtd_ADM_zz, rk2d_Psi1_zz_o0_t5_m0_l0, rk2m_Psi1_zz_o0_t4_l0, rk2m_Psi1_zz_o0_t3_l0, rk2m_Psi1_zz_o0_t2_l0, rk2m_Psi1_zz_o0_t1_l0, rk2m_Psi1_zz_o0_t0_l0, rk2Psi1_zz, rk2Jtd_ADM_y, rk2Jtd_ADM_x, rk2pTtd_ADM_yz, rk2d_Psi1_yz_o0_t6_m0_l0, rk2m_Psi1_yz_o0_t5_l0, rk2m_Psi1_yz_o0_t4_l0, rk2m_Psi1_yz_o0_t3_l0, rk2m_Psi1_yz_o0_t2_l0, rk2m_Psi1_yz_o0_t1_l0, rk2m_Psi1_yz_o0_t0_l0, rk2Psi1_yz, rk2pTtd_ADM_yy, rk2tr_pT, rk2d_Psi1_yy_o0_t5_m0_l0, rk2m_Psi1_yy_o0_t4_l0, rk2m_Psi1_yy_o0_t3_l0, rk2m_Psi1_yy_o0_t2_l0, rk2m_Psi1_yy_o0_t1_l0, rk2m_Psi1_yy_o0_t0_l0, rk2Psi1_yy, rk2trPsi1, rk2Psi1TF_yz, rk2Psi1TF_yy, rk2Psi1TF_xy, rk2Psi1TF_xx, rk2Psi1TF_xz, rk2Psi1TF_zz, rk2kappa_cc, rk2rho_ADM, d_gtd_xx_o2_t3_m0_l0, d_gtd_xy_o2_t6_m0_l0, d_gtd_xz_o2_t6_m0_l0, d_gtd_yy_o2_t3_m0_l0, d_gtd_yz_o2_t6_m0_l0, d_gtd_zz_o2_t3_m0_l0, d_Atd_xx_o2_t3_m0_l0, d_Atd_xy_o2_t6_m0_l0, d_Atd_xz_o2_t6_m0_l0, d_Atd_yy_o2_t3_m0_l0, d_Atd_yz_o2_t6_m0_l0, d_Atd_zz_o2_t3_m0_l0, d_Gamh_x_o2_t24_m0_l0, d_Gamh_y_o2_t24_m0_l0, d_Betau_x_o0_t0_m0_l0, d_Betau_y_o0_t0_m0_l0, d_Betau_z_o0_t0_m0_l0, d_Gamh_z_o2_t24_m0_l0, d_Alpha_o2_t0_m0_l0, d_chi_o2_t0_m0_l0, d_trK_o2_t21_m0_l0, d_theta_o2_t3_m0_l0, d_piR_o2_t27_m0_l0, d_peR_o2_t27_m0_l0, d_piI_o2_t27_m0_l0, d_peI_o2_t27_m0_l0, m_peI_o2_t26_l0, m_peI_o2_t25_l0, m_peI_o2_t24_l0, m_peI_o2_t23_l0, m_peI_o2_t22_l0, m_peI_o2_t21_l0, m_peI_o2_t20_l0, m_peI_o2_t19_l0, m_peI_o2_t18_l0, m_peI_o2_t17_l0, m_peI_o2_t16_l0, m_peI_o2_t15_l0, m_peI_o2_t14_l0, m_peI_o2_t13_l0, m_peI_o2_t12_l0, m_peI_o2_t11_l0, m_peI_o2_t10_l0, m_peI_o2_t9_l0, m_peI_o2_t8_l0, m_peI_o2_t7_l0, m_peI_o2_t6_l0, m_peI_o2_t5_l0, m_peI_o2_t4_l0, m_peI_o2_t3_l0, m_peI_o2_t2_l0, m_peI_o2_t1_l0, m_peI_o2_t0_l0, m_peI_o1_t2_l0, m_peI_o1_t1_l0, m_peI_o1_t0_l0, m_peI_o0_t2_l0, m_peI_o0_t1_l0, m_peI_o0_t0_l0, m_piI_o2_t26_l0, m_piI_o2_t25_l0, m_piI_o2_t24_l0, m_piI_o2_t23_l0, m_piI_o2_t22_l0, m_piI_o2_t21_l0, m_piI_o2_t20_l0, m_piI_o2_t19_l0, m_piI_o2_t18_l0, m_piI_o2_t17_l0, m_piI_o2_t16_l0, m_piI_o2_t15_l0, m_piI_o2_t14_l0, m_piI_o2_t13_l0, m_piI_o2_t12_l0, m_piI_o2_t11_l0, m_piI_o2_t10_l0, m_piI_o2_t9_l0, m_piI_o2_t8_l0, m_piI_o2_t7_l0, m_piI_o2_t6_l0, m_piI_o2_t5_l0, m_piI_o2_t4_l0, m_piI_o2_t3_l0, m_piI_o2_t2_l0, m_piI_o2_t1_l0, m_piI_o2_t0_l0, m_piI_o1_t2_l0, m_piI_o1_t1_l0, m_piI_o1_t0_l0, m_piI_o0_t2_l0, m_piI_o0_t1_l0, m_piI_o0_t0_l0, m_peR_o2_t26_l0, m_peR_o2_t25_l0, m_peR_o2_t24_l0, m_peR_o2_t23_l0, m_peR_o2_t22_l0, m_peR_o2_t21_l0, m_peR_o2_t20_l0, m_peR_o2_t19_l0, m_peR_o2_t18_l0, m_peR_o2_t17_l0, m_peR_o2_t16_l0, m_peR_o2_t15_l0, m_peR_o2_t14_l0, m_peR_o2_t13_l0, m_peR_o2_t12_l0, m_peR_o2_t11_l0, m_peR_o2_t10_l0, m_peR_o2_t9_l0, m_peR_o2_t8_l0, m_peR_o2_t7_l0, m_peR_o2_t6_l0, m_peR_o2_t5_l0, m_peR_o2_t4_l0, m_peR_o2_t3_l0, m_peR_o2_t2_l0, m_peR_o2_t1_l0, m_peR_o2_t0_l0, m_peR_o1_t2_l0, m_peR_o1_t1_l0, m_peR_o1_t0_l0, m_peR_o0_t2_l0, m_peR_o0_t1_l0, m_peR_o0_t0_l0, m_piR_o2_t26_l0, m_piR_o2_t25_l0, m_piR_o2_t24_l0, m_piR_o2_t23_l0, m_piR_o2_t22_l0, m_piR_o2_t21_l0, m_piR_o2_t20_l0, m_piR_o2_t19_l0, m_piR_o2_t18_l0, m_piR_o2_t17_l0, m_piR_o2_t16_l0, m_piR_o2_t15_l0, m_piR_o2_t14_l0, m_piR_o2_t13_l0, m_piR_o2_t12_l0, m_piR_o2_t11_l0, m_piR_o2_t10_l0, m_piR_o2_t9_l0, m_piR_o2_t8_l0, m_piR_o2_t7_l0, m_piR_o2_t6_l0, m_piR_o2_t5_l0, m_piR_o2_t4_l0, m_piR_o2_t3_l0, m_piR_o2_t2_l0, m_piR_o2_t1_l0, m_piR_o2_t0_l0, m_piR_o1_t2_l0, m_piR_o1_t1_l0, m_piR_o1_t0_l0, m_piR_o0_t2_l0, m_piR_o0_t1_l0, m_piR_o0_t0_l0, m_pheI_o1_t2_l0, m_pheI_o1_t1_l0, m_pheI_o1_t0_l0, m_pheI_o0_t2_l0, m_pheI_o0_t1_l0, m_pheI_o0_t0_l0, m_phiI_o1_t2_l0, m_phiI_o1_t1_l0, m_phiI_o1_t0_l0, m_phiI_o0_t2_l0, m_phiI_o0_t1_l0, m_phiI_o0_t0_l0, m_pheR_o1_t2_l0, m_pheR_o1_t1_l0, m_pheR_o1_t0_l0, m_pheR_o0_t2_l0, m_pheR_o0_t1_l0, m_pheR_o0_t0_l0, m_phiR_o1_t2_l0, m_phiR_o1_t1_l0, m_phiR_o1_t0_l0, m_phiR_o0_t2_l0, m_phiR_o0_t1_l0, m_phiR_o0_t0_l0, m_theta_o2_t2_l0, m_theta_o2_t1_l0, m_theta_o2_t0_l0, m_theta_o1_t2_l0, m_theta_o1_t1_l0, m_theta_o1_t0_l0, m_theta_o0_t2_l0, m_theta_o0_t1_l0, m_theta_o0_t0_l0, m_trK_o2_t20_l0, m_trK_o2_t19_l0, m_trK_o2_t18_l0, m_trK_o2_t17_l0, m_trK_o2_t16_l0, m_trK_o2_t15_l0, m_trK_o2_t14_l0, m_trK_o2_t13_l0, m_trK_o2_t12_l0, m_trK_o2_t11_l0, m_trK_o2_t10_l0, m_trK_o2_t9_l0, m_trK_o2_t8_l0, m_trK_o2_t7_l0, m_trK_o2_t6_l0, m_trK_o2_t5_l0, m_trK_o2_t4_l0, m_trK_o2_t3_l0, m_trK_o2_t2_l0, m_trK_o2_t1_l0, m_trK_o2_t0_l0, m_trK_o1_t2_l0, m_trK_o1_t1_l0, m_trK_o1_t0_l0, m_trK_o0_t2_l0, m_trK_o0_t1_l0, m_trK_o0_t0_l0, m_chi_o1_t2_l0, m_chi_o1_t1_l0, m_chi_o1_t0_l0, m_chi_o0_t2_l0, m_chi_o0_t1_l0, m_chi_o0_t0_l0, m_Alpha_o1_t2_l0, m_Alpha_o1_t1_l0, m_Alpha_o1_t0_l0, m_Alpha_o0_t2_l0, m_Alpha_o0_t1_l0, m_Alpha_o0_t0_l0, m_Gamh_z_o2_t23_l0, m_Gamh_z_o2_t22_l0, m_Gamh_z_o2_t21_l0, m_Gamh_z_o2_t20_l0, m_Gamh_z_o2_t19_l0, m_Gamh_z_o2_t18_l0, m_Gamh_z_o2_t17_l0, m_Gamh_z_o2_t16_l0, m_Gamh_z_o2_t15_l0, m_Gamh_z_o2_t14_l0, m_Gamh_z_o2_t13_l0, m_Gamh_z_o2_t12_l0, m_Gamh_z_o2_t11_l0, m_Gamh_z_o2_t10_l0, m_Gamh_z_o2_t9_l0, m_Gamh_z_o2_t8_l0, m_Gamh_z_o2_t7_l0, m_Gamh_z_o2_t6_l0, m_Gamh_z_o2_t5_l0, m_Gamh_z_o2_t4_l0, m_Gamh_z_o2_t3_l0, m_Gamh_z_o2_t2_l0, m_Gamh_z_o2_t1_l0, m_Gamh_z_o2_t0_l0, m_Gamh_z_o1_t2_l0, m_Gamh_z_o1_t1_l0, m_Gamh_z_o1_t0_l0, m_Gamh_z_o0_t2_l0, m_Gamh_z_o0_t1_l0, m_Gamh_z_o0_t0_l0, m_Betau_z_o2_t2_l0, m_Betau_z_o2_t1_l0, m_Betau_z_o2_t0_l0, m_Betau_z_o1_t2_l0, m_Betau_z_o1_t1_l0, m_Betau_z_o1_t0_l0, m_Betau_y_o2_t2_l0, m_Betau_y_o2_t1_l0, m_Betau_y_o2_t0_l0, m_Betau_y_o1_t2_l0, m_Betau_y_o1_t1_l0, m_Betau_y_o1_t0_l0, m_Betau_x_o2_t2_l0, m_Betau_x_o2_t1_l0, m_Betau_x_o2_t0_l0, m_Betau_x_o1_t2_l0, m_Betau_x_o1_t1_l0, m_Betau_x_o1_t0_l0, m_Gamh_y_o2_t23_l0, m_Gamh_y_o2_t22_l0, m_Gamh_y_o2_t21_l0, m_Gamh_y_o2_t20_l0, m_Gamh_y_o2_t19_l0, m_Gamh_y_o2_t18_l0, m_Gamh_y_o2_t17_l0, m_Gamh_y_o2_t16_l0, m_Gamh_y_o2_t15_l0, m_Gamh_y_o2_t14_l0, m_Gamh_y_o2_t13_l0, m_Gamh_y_o2_t12_l0, m_Gamh_y_o2_t11_l0, m_Gamh_y_o2_t10_l0, m_Gamh_y_o2_t9_l0, m_Gamh_y_o2_t8_l0, m_Gamh_y_o2_t7_l0, m_Gamh_y_o2_t6_l0, m_Gamh_y_o2_t5_l0, m_Gamh_y_o2_t4_l0, m_Gamh_y_o2_t3_l0, m_Gamh_y_o2_t2_l0, m_Gamh_y_o2_t1_l0, m_Gamh_y_o2_t0_l0, m_Gamh_y_o1_t2_l0, m_Gamh_y_o1_t1_l0, m_Gamh_y_o1_t0_l0, m_Gamh_y_o0_t2_l0, m_Gamh_y_o0_t1_l0, m_Gamh_y_o0_t0_l0, m_Gamh_x_o2_t23_l0, m_Gamh_x_o2_t22_l0, m_Gamh_x_o2_t21_l0, m_Gamh_x_o2_t20_l0, m_Gamh_x_o2_t19_l0, m_Gamh_x_o2_t18_l0, m_Gamh_x_o2_t17_l0, m_Gamh_x_o2_t16_l0, m_Gamh_x_o2_t15_l0, m_Gamh_x_o2_t14_l0, m_Gamh_x_o2_t13_l0, m_Gamh_x_o2_t12_l0, m_Gamh_x_o2_t11_l0, m_Gamh_x_o2_t10_l0, m_Gamh_x_o2_t9_l0, m_Gamh_x_o2_t8_l0, m_Gamh_x_o2_t7_l0, m_Gamh_x_o2_t6_l0, m_Gamh_x_o2_t5_l0, m_Gamh_x_o2_t4_l0, m_Gamh_x_o2_t3_l0, m_Gamh_x_o2_t2_l0, m_Gamh_x_o2_t1_l0, m_Gamh_x_o2_t0_l0, m_Gamh_x_o1_t2_l0, m_Gamh_x_o1_t1_l0, m_Gamh_x_o1_t0_l0, m_Gamh_x_o0_t2_l0, m_Gamh_x_o0_t1_l0, m_Gamh_x_o0_t0_l0, m_Atd_zz_o2_t2_l0, m_Atd_zz_o2_t1_l0, m_Atd_zz_o2_t0_l0, m_Atd_zz_o1_t2_l0, m_Atd_zz_o1_t1_l0, m_Atd_zz_o1_t0_l0, m_Atd_zz_o0_t2_l0, m_Atd_zz_o0_t1_l0, m_Atd_zz_o0_t0_l0, m_Atd_yz_o2_t5_l0, m_Atd_yz_o2_t4_l0, m_Atd_yz_o2_t3_l0, m_Atd_yz_o2_t2_l0, m_Atd_yz_o2_t1_l0, m_Atd_yz_o2_t0_l0, m_Atd_yz_o1_t2_l0, m_Atd_yz_o1_t1_l0, m_Atd_yz_o1_t0_l0, m_Atd_yz_o0_t2_l0, m_Atd_yz_o0_t1_l0, m_Atd_yz_o0_t0_l0, m_Atd_yy_o2_t2_l0, m_Atd_yy_o2_t1_l0, m_Atd_yy_o2_t0_l0, m_Atd_yy_o1_t2_l0, m_Atd_yy_o1_t1_l0, m_Atd_yy_o1_t0_l0, m_Atd_yy_o0_t2_l0, m_Atd_yy_o0_t1_l0, m_Atd_yy_o0_t0_l0, m_Atd_xz_o2_t5_l0, m_Atd_xz_o2_t4_l0, m_Atd_xz_o2_t3_l0, m_Atd_xz_o2_t2_l0, m_Atd_xz_o2_t1_l0, m_Atd_xz_o2_t0_l0, m_Atd_xz_o1_t2_l0, m_Atd_xz_o1_t1_l0, m_Atd_xz_o1_t0_l0, m_Atd_xz_o0_t2_l0, m_Atd_xz_o0_t1_l0, m_Atd_xz_o0_t0_l0, m_Atd_xy_o2_t5_l0, m_Atd_xy_o2_t4_l0, m_Atd_xy_o2_t3_l0, m_Atd_xy_o2_t2_l0, m_Atd_xy_o2_t1_l0, m_Atd_xy_o2_t0_l0, m_Atd_xy_o1_t2_l0, m_Atd_xy_o1_t1_l0, m_Atd_xy_o1_t0_l0, m_Atd_xy_o0_t2_l0, m_Atd_xy_o0_t1_l0, m_Atd_xy_o0_t0_l0, m_Atd_xx_o2_t2_l0, m_Atd_xx_o2_t1_l0, m_Atd_xx_o2_t0_l0, m_Atd_xx_o1_t2_l0, m_Atd_xx_o1_t1_l0, m_Atd_xx_o1_t0_l0, m_Atd_xx_o0_t2_l0, m_Atd_xx_o0_t1_l0, m_Atd_xx_o0_t0_l0, m_gtd_zz_o2_t2_l0, m_gtd_zz_o2_t1_l0, m_gtd_zz_o2_t0_l0, m_gtd_zz_o1_t2_l0, m_gtd_zz_o1_t1_l0, m_gtd_zz_o1_t0_l0, m_gtd_zz_o0_t2_l0, m_gtd_zz_o0_t1_l0, m_gtd_zz_o0_t0_l0, m_gtd_yz_o2_t5_l0, m_gtd_yz_o2_t4_l0, m_gtd_yz_o2_t3_l0, m_gtd_yz_o2_t2_l0, m_gtd_yz_o2_t1_l0, m_gtd_yz_o2_t0_l0, m_gtd_yz_o1_t2_l0, m_gtd_yz_o1_t1_l0, m_gtd_yz_o1_t0_l0, m_gtd_yz_o0_t2_l0, m_gtd_yz_o0_t1_l0, m_gtd_yz_o0_t0_l0, m_gtd_yy_o2_t2_l0, m_gtd_yy_o2_t1_l0, m_gtd_yy_o2_t0_l0, m_gtd_yy_o1_t2_l0, m_gtd_yy_o1_t1_l0, m_gtd_yy_o1_t0_l0, m_gtd_yy_o0_t2_l0, m_gtd_yy_o0_t1_l0, m_gtd_yy_o0_t0_l0, m_gtd_xz_o2_t5_l0, m_gtd_xz_o2_t4_l0, m_gtd_xz_o2_t3_l0, m_gtd_xz_o2_t2_l0, m_gtd_xz_o2_t1_l0, m_gtd_xz_o2_t0_l0, m_gtd_xz_o1_t2_l0, m_gtd_xz_o1_t1_l0, m_gtd_xz_o1_t0_l0, m_gtd_xz_o0_t2_l0, m_gtd_xz_o0_t1_l0, m_gtd_xz_o0_t0_l0, m_gtd_xy_o2_t5_l0, m_gtd_xy_o2_t4_l0, m_gtd_xy_o2_t3_l0, m_gtd_xy_o2_t2_l0, m_gtd_xy_o2_t1_l0, m_gtd_xy_o2_t0_l0, m_gtd_xy_o1_t2_l0, m_gtd_xy_o1_t1_l0, m_gtd_xy_o1_t0_l0, m_gtd_xy_o0_t2_l0, m_gtd_xy_o0_t1_l0, m_gtd_xy_o0_t0_l0, m_gtd_xx_o2_t2_l0, m_gtd_xx_o2_t1_l0, m_gtd_xx_o2_t0_l0, m_gtd_xx_o1_t2_l0, m_gtd_xx_o1_t1_l0, m_gtd_xx_o1_t0_l0, m_gtd_xx_o0_t2_l0, m_gtd_xx_o0_t1_l0, m_gtd_xx_o0_t0_l0, RHS_gtd_xx, RHS_gtd_xy, RHS_gtd_xz, RHS_gtd_yy, RHS_gtd_yz, RHS_gtd_zz, RHS_Atd_xx, RHS_Atd_xy, RHS_Atd_xz, RHS_Atd_yy, RHS_Atd_yz, RHS_Atd_zz, RHS_Gamh_x, RHS_Gamh_y, RHS_Betau_x, RHS_Betau_y, RHS_Betau_z, RHS_Gamh_z, RHS_Alpha, RHS_chi, RHS_trK, RHS_theta, RHS_phiR, RHS_pheR, RHS_phiI, RHS_pheI, RHS_piR, RHS_peR, RHS_piI, RHS_peI, n_x, n_y, n_z, interaction_index, mod_normal, i_d_Atd_xx_o0_t0_m0_l0, i_d_Atd_xx_o0_t1_m0_l0, i_d_Atd_xx_o0_t2_m0_l0, i_d_Atd_xy_o0_t0_m0_l0, i_d_Atd_xy_o0_t1_m0_l0, i_d_Atd_xy_o0_t2_m0_l0, i_d_Atd_xz_o0_t0_m0_l0, i_d_Atd_xz_o0_t1_m0_l0, i_d_Atd_xz_o0_t2_m0_l0, i_d_Atd_yy_o0_t0_m0_l0, i_d_Atd_yy_o0_t1_m0_l0, i_d_Atd_yy_o0_t2_m0_l0, i_d_Atd_yz_o0_t0_m0_l0, i_d_Atd_yz_o0_t1_m0_l0, i_d_Atd_yz_o0_t2_m0_l0, i_d_Atd_zz_o0_t0_m0_l0, i_d_Atd_zz_o0_t1_m0_l0, i_d_Atd_zz_o0_t2_m0_l0, i_d_piR_o0_t0_m0_l0, i_d_piR_o0_t1_m0_l0, i_d_piR_o0_t2_m0_l0, i_d_peR_o0_t0_m0_l0, i_d_peR_o0_t1_m0_l0, i_d_peR_o0_t2_m0_l0, i_d_piI_o0_t0_m0_l0, i_d_piI_o0_t1_m0_l0, i_d_piI_o0_t2_m0_l0, i_d_peI_o0_t0_m0_l0, i_d_peI_o0_t1_m0_l0, i_d_peI_o0_t2_m0_l0, i_d_gtd_xx_o0_t3_m0_l0, i_d_gtd_xy_o0_t3_m0_l0, i_d_gtd_xz_o0_t3_m0_l0, i_d_gtd_yy_o0_t3_m0_l0, i_d_gtd_yz_o0_t3_m0_l0, i_d_gtd_zz_o0_t3_m0_l0, i_d_Atd_xx_o0_t3_m0_l0, i_d_Atd_xy_o0_t3_m0_l0, i_d_Atd_xz_o0_t3_m0_l0, i_d_Atd_yy_o0_t3_m0_l0, i_d_Atd_yz_o0_t3_m0_l0, i_d_Atd_zz_o0_t3_m0_l0, i_d_Gamh_x_o0_t3_m0_l0, i_d_Gamh_y_o0_t3_m0_l0, i_d_Gamh_z_o0_t3_m0_l0, i_d_Betau_x_o0_t3_m0_l0, i_d_Betau_y_o0_t3_m0_l0, i_d_Betau_z_o0_t3_m0_l0, i_d_Alpha_o0_t3_m0_l0, i_d_chi_o0_t3_m0_l0, i_d_trK_o0_t3_m0_l0, i_d_theta_o0_t3_m0_l0, i_d_phiR_o0_t3_m0_l0, i_d_phiI_o0_t3_m0_l0, i_d_piR_o0_t3_m0_l0, i_d_piI_o0_t3_m0_l0, i_d_pheR_o0_t3_m0_l0, i_d_pheI_o0_t3_m0_l0, i_d_peR_o0_t3_m0_l0, i_d_peI_o0_t3_m0_l0, i_m_gtd_xx_o0_t0_l0, i_m_gtd_xx_o0_t1_l0, i_m_gtd_xx_o0_t2_l0, i_m_gtd_xy_o0_t0_l0, i_m_gtd_xy_o0_t1_l0, i_m_gtd_xy_o0_t2_l0, i_m_gtd_xz_o0_t0_l0, i_m_gtd_xz_o0_t1_l0, i_m_gtd_xz_o0_t2_l0, i_m_gtd_yy_o0_t0_l0, i_m_gtd_yy_o0_t1_l0, i_m_gtd_yy_o0_t2_l0, i_m_gtd_yz_o0_t0_l0, i_m_gtd_yz_o0_t1_l0, i_m_gtd_yz_o0_t2_l0, i_m_gtd_zz_o0_t0_l0, i_m_gtd_zz_o0_t1_l0, i_m_gtd_zz_o0_t2_l0, i_m_Atd_xx_o0_t0_l0, i_m_Atd_xx_o0_t1_l0, i_m_Atd_xx_o0_t2_l0, i_m_Atd_xy_o0_t0_l0, i_m_Atd_xy_o0_t1_l0, i_m_Atd_xy_o0_t2_l0, i_m_Atd_xz_o0_t0_l0, i_m_Atd_xz_o0_t1_l0, i_m_Atd_xz_o0_t2_l0, i_m_Atd_yy_o0_t0_l0, i_m_Atd_yy_o0_t1_l0, i_m_Atd_yy_o0_t2_l0, i_m_Atd_yz_o0_t0_l0, i_m_Atd_yz_o0_t1_l0, i_m_Atd_yz_o0_t2_l0, i_m_Atd_zz_o0_t0_l0, i_m_Atd_zz_o0_t1_l0, i_m_Atd_zz_o0_t2_l0, i_m_Gamh_x_o0_t0_l0, i_m_Gamh_x_o0_t1_l0, i_m_Gamh_x_o0_t2_l0, i_m_Gamh_y_o0_t0_l0, i_m_Gamh_y_o0_t1_l0, i_m_Gamh_y_o0_t2_l0, i_m_Gamh_z_o0_t0_l0, i_m_Gamh_z_o0_t1_l0, i_m_Gamh_z_o0_t2_l0, i_m_Betau_x_o0_t0_l0, i_m_Betau_x_o0_t1_l0, i_m_Betau_x_o0_t2_l0, i_m_Betau_y_o0_t0_l0, i_m_Betau_y_o0_t1_l0, i_m_Betau_y_o0_t2_l0, i_m_Betau_z_o0_t0_l0, i_m_Betau_z_o0_t1_l0, i_m_Betau_z_o0_t2_l0, i_m_Alpha_o0_t0_l0, i_m_Alpha_o0_t1_l0, i_m_Alpha_o0_t2_l0, i_m_chi_o0_t0_l0, i_m_chi_o0_t1_l0, i_m_chi_o0_t2_l0, i_m_trK_o0_t0_l0, i_m_trK_o0_t1_l0, i_m_trK_o0_t2_l0, i_m_theta_o0_t0_l0, i_m_theta_o0_t1_l0, i_m_theta_o0_t2_l0, i_m_phiR_o0_t0_l0, i_m_phiR_o0_t1_l0, i_m_phiR_o0_t2_l0, i_m_phiI_o0_t0_l0, i_m_phiI_o0_t1_l0, i_m_phiI_o0_t2_l0, i_m_piR_o0_t0_l0, i_m_piR_o0_t1_l0, i_m_piR_o0_t2_l0, i_m_piI_o0_t0_l0, i_m_piI_o0_t1_l0, i_m_piI_o0_t2_l0, i_m_pheR_o0_t0_l0, i_m_pheR_o0_t1_l0, i_m_pheR_o0_t2_l0, i_m_pheI_o0_t0_l0, i_m_pheI_o0_t1_l0, i_m_pheI_o0_t2_l0, i_m_peR_o0_t0_l0, i_m_peR_o0_t1_l0, i_m_peR_o0_t2_l0, i_m_peI_o0_t0_l0, i_m_peI_o0_t1_l0, i_m_peI_o0_t2_l0;

				if ((i + 3 <= bx_hi.x && i - 3 >= bx_lo.x && j + 3 <= bx_hi.y && j - 3 >= bx_lo.y && k + 3 <= bx_hi.z && k - 3 >= bx_lo.z)) {
					d_div_Beta_o0_t0_m0_l0 = D1CDO4_i(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t0_m0_l0 = lieforward_i(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t0_m0_l0 = liebackward_i(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o2_t0_m0_l0 = D1CDO4_j(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t1_m0_l0 = lieforward_j(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t1_m0_l0 = liebackward_j(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o2_t0_m0_l0 = D1CDO4_k(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Betau_x_o1_t2_m0_l0 = lieforward_k(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Betau_x_o2_t2_m0_l0 = liebackward_k(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t0_m0_l0 = D2CDO4_i(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t0_m0_l0 = D1CDO4crossed_ij(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t0_m0_l0 = D1CDO4crossed_ik(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t6_m0_l0 = D2CDO4_j(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t7_m0_l0 = D1CDO4crossed_jk(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t8_m0_l0 = D2CDO4_k(Betau_x, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o2_t1_m0_l0 = D1CDO4_i(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t0_m0_l0 = lieforward_i(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t0_m0_l0 = liebackward_i(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_div_Beta_o0_t1_m0_l0 = D1CDO4_j(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t1_m0_l0 = lieforward_j(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t1_m0_l0 = liebackward_j(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o2_t1_m0_l0 = D1CDO4_k(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Betau_y_o1_t2_m0_l0 = lieforward_k(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Betau_y_o2_t2_m0_l0 = liebackward_k(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t4_m0_l0 = D2CDO4_i(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t1_m0_l0 = D1CDO4crossed_ij(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t6_m0_l0 = D1CDO4crossed_ik(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t1_m0_l0 = D2CDO4_j(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t1_m0_l0 = D1CDO4crossed_jk(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o2_t9_m0_l0 = D2CDO4_k(Betau_y, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o2_t2_m0_l0 = D1CDO4_i(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t0_m0_l0 = lieforward_i(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t0_m0_l0 = liebackward_i(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o2_t2_m0_l0 = D1CDO4_j(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t1_m0_l0 = lieforward_j(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t1_m0_l0 = liebackward_j(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_div_Beta_o0_t2_m0_l0 = D1CDO4_k(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Betau_z_o1_t2_m0_l0 = lieforward_k(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Betau_z_o2_t2_m0_l0 = liebackward_k(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t14_m0_l0 = D2CDO4_i(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t15_m0_l0 = D1CDO4crossed_ij(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_x_o0_t2_m0_l0 = D1CDO4crossed_ik(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o2_t17_m0_l0 = D2CDO4_j(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_y_o0_t2_m0_l0 = D1CDO4crossed_jk(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_d_div_Beta_z_o0_t2_m0_l0 = D2CDO4_k(Betau_z, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t0_m0_l0 = lieforward_i(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t0_m0_l0 = liebackward_i(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xxy_o0_t0_m0_l0 = D1CDO4_j(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t1_m0_l0 = lieforward_j(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t1_m0_l0 = liebackward_j(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xxz_o0_t0_m0_l0 = D1CDO4_k(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o0_t2_m0_l0 = lieforward_k(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_gtd_xx_o1_t2_m0_l0 = liebackward_k(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Ctd_yxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t0_m0_l0 = lieforward_i(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t0_m0_l0 = liebackward_i(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xyy_o0_t0_m0_l0 = D1CDO4_j(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t1_m0_l0 = lieforward_j(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t1_m0_l0 = liebackward_j(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t1_m0_l0 = D1CDO4_k(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o0_t2_m0_l0 = lieforward_k(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_gtd_xy_o1_t2_m0_l0 = liebackward_k(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xyy_o0_t1_m0_l0 = D1CDO4_i(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t0_m0_l0 = lieforward_i(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t0_m0_l0 = liebackward_i(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Ctd_yyy_o0_t0_m0_l0 = D1CDO4_j(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t1_m0_l0 = lieforward_j(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t1_m0_l0 = liebackward_j(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Ctd_yyz_o0_t0_m0_l0 = D1CDO4_k(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_gtd_yy_o0_t2_m0_l0 = lieforward_k(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_gtd_yy_o1_t2_m0_l0 = liebackward_k(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Ctd_zxx_o0_t0_m0_l0 = D1CDO4_i(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t0_m0_l0 = lieforward_i(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t0_m0_l0 = liebackward_i(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t0_m0_l0 = D1CDO4_j(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t1_m0_l0 = lieforward_j(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t1_m0_l0 = liebackward_j(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xzz_o0_t0_m0_l0 = D1CDO4_k(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o0_t2_m0_l0 = lieforward_k(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_gtd_xz_o1_t2_m0_l0 = liebackward_k(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xyz_o0_t2_m0_l0 = D1CDO4_i(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t0_m0_l0 = lieforward_i(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t0_m0_l0 = liebackward_i(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_zyy_o0_t0_m0_l0 = D1CDO4_j(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t1_m0_l0 = lieforward_j(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t1_m0_l0 = liebackward_j(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_yzz_o0_t0_m0_l0 = D1CDO4_k(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_gtd_yz_o0_t2_m0_l0 = lieforward_k(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_gtd_yz_o1_t2_m0_l0 = liebackward_k(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_xzz_o0_t1_m0_l0 = D1CDO4_i(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t0_m0_l0 = lieforward_i(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t0_m0_l0 = liebackward_i(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_yzz_o0_t1_m0_l0 = D1CDO4_j(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t1_m0_l0 = lieforward_j(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t1_m0_l0 = liebackward_j(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Ctd_zzz_o0_t0_m0_l0 = D1CDO4_k(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_gtd_zz_o0_t2_m0_l0 = lieforward_k(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_gtd_zz_o1_t2_m0_l0 = liebackward_k(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t0_m0_l0 = D1CDO4_i(chi, rk2, i, j, k, dx, dt_lev);
					d_chi_o0_t0_m0_l0 = lieforward_i(chi, rk2, i, j, k, dx, dt_lev);
					d_chi_o1_t0_m0_l0 = liebackward_i(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t1_m0_l0 = D1CDO4_j(chi, rk2, i, j, k, dx, dt_lev);
					d_chi_o0_t1_m0_l0 = lieforward_j(chi, rk2, i, j, k, dx, dt_lev);
					d_chi_o1_t1_m0_l0 = liebackward_j(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t2_m0_l0 = D1CDO4_k(chi, rk2, i, j, k, dx, dt_lev);
					d_chi_o0_t2_m0_l0 = lieforward_k(chi, rk2, i, j, k, dx, dt_lev);
					d_chi_o1_t2_m0_l0 = liebackward_k(chi, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t6_m0_l0 = D1CDO4_i(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t0_m0_l0 = lieforward_i(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t0_m0_l0 = liebackward_i(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t6_m0_l0 = D1CDO4_j(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t1_m0_l0 = lieforward_j(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t1_m0_l0 = liebackward_j(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t6_m0_l0 = D1CDO4_k(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o0_t2_m0_l0 = lieforward_k(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o1_t2_m0_l0 = liebackward_k(Gamh_x, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t7_m0_l0 = D1CDO4_i(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t0_m0_l0 = lieforward_i(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t0_m0_l0 = liebackward_i(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t7_m0_l0 = D1CDO4_j(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t1_m0_l0 = lieforward_j(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t1_m0_l0 = liebackward_j(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t7_m0_l0 = D1CDO4_k(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o0_t2_m0_l0 = lieforward_k(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Gamh_y_o1_t2_m0_l0 = liebackward_k(Gamh_y, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t8_m0_l0 = D1CDO4_i(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t1_m0_l0 = lieforward_i(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t0_m0_l0 = liebackward_i(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t8_m0_l0 = D1CDO4_j(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t2_m0_l0 = lieforward_j(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t1_m0_l0 = liebackward_j(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t8_m0_l0 = D1CDO4_k(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o0_t0_m0_l0 = lieforward_k(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Gamh_z_o1_t2_m0_l0 = liebackward_k(Gamh_z, rk2, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t1_m0_l0 = D1CDO4_i(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Alpha_o0_t0_m0_l0 = lieforward_i(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Alpha_o1_t0_m0_l0 = liebackward_i(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t2_m0_l0 = D1CDO4_j(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Alpha_o0_t1_m0_l0 = lieforward_j(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Alpha_o1_t1_m0_l0 = liebackward_j(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t3_m0_l0 = D1CDO4_k(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Alpha_o0_t2_m0_l0 = lieforward_k(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Alpha_o1_t2_m0_l0 = liebackward_k(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_xx_o0_t0_m0_l0 = D2CDO4_i(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_xy_o0_t0_m0_l0 = D1CDO4crossed_ij(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_xz_o0_t0_m0_l0 = D1CDO4crossed_ik(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_yy_o0_t0_m0_l0 = D2CDO4_j(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_yz_o0_t0_m0_l0 = D1CDO4crossed_jk(Alpha, rk2, i, j, k, dx, dt_lev);
					d_Psi1_zz_o0_t0_m0_l0 = D2CDO4_k(Alpha, rk2, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t1_m0_l0 = D1CDO4_i(phiR, rk2, i, j, k, dx, dt_lev);
					d_phiR_o0_t0_m0_l0 = lieforward_i(phiR, rk2, i, j, k, dx, dt_lev);
					d_phiR_o1_t0_m0_l0 = liebackward_i(phiR, rk2, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t2_m0_l0 = D1CDO4_j(phiR, rk2, i, j, k, dx, dt_lev);
					d_phiR_o0_t1_m0_l0 = lieforward_j(phiR, rk2, i, j, k, dx, dt_lev);
					d_phiR_o1_t1_m0_l0 = liebackward_j(phiR, rk2, i, j, k, dx, dt_lev);
					d_d_phiR4d_t_o0_t3_m0_l0 = D1CDO4_k(phiR, rk2, i, j, k, dx, dt_lev);
					d_phiR_o0_t2_m0_l0 = lieforward_k(phiR, rk2, i, j, k, dx, dt_lev);
					d_phiR_o1_t2_m0_l0 = liebackward_k(phiR, rk2, i, j, k, dx, dt_lev);
					d_piR_o2_t26_m0_l0 = D2CDO4_i(phiR, rk2, i, j, k, dx, dt_lev);
					d_piR_o2_t0_m0_l0 = D1CDO4crossed_ij(phiR, rk2, i, j, k, dx, dt_lev);
					d_piR_o2_t1_m0_l0 = D1CDO4crossed_ik(phiR, rk2, i, j, k, dx, dt_lev);
					d_piR_o2_t2_m0_l0 = D2CDO4_j(phiR, rk2, i, j, k, dx, dt_lev);
					d_piR_o2_t3_m0_l0 = D1CDO4crossed_jk(phiR, rk2, i, j, k, dx, dt_lev);
					d_piR_o2_t4_m0_l0 = D2CDO4_k(phiR, rk2, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t1_m0_l0 = D1CDO4_i(phiI, rk2, i, j, k, dx, dt_lev);
					d_phiI_o0_t0_m0_l0 = lieforward_i(phiI, rk2, i, j, k, dx, dt_lev);
					d_phiI_o1_t0_m0_l0 = liebackward_i(phiI, rk2, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t2_m0_l0 = D1CDO4_j(phiI, rk2, i, j, k, dx, dt_lev);
					d_phiI_o0_t1_m0_l0 = lieforward_j(phiI, rk2, i, j, k, dx, dt_lev);
					d_phiI_o1_t1_m0_l0 = liebackward_j(phiI, rk2, i, j, k, dx, dt_lev);
					d_d_phiI4d_t_o0_t3_m0_l0 = D1CDO4_k(phiI, rk2, i, j, k, dx, dt_lev);
					d_phiI_o0_t2_m0_l0 = lieforward_k(phiI, rk2, i, j, k, dx, dt_lev);
					d_phiI_o1_t2_m0_l0 = liebackward_k(phiI, rk2, i, j, k, dx, dt_lev);
					d_piI_o2_t24_m0_l0 = D2CDO4_i(phiI, rk2, i, j, k, dx, dt_lev);
					d_piI_o2_t25_m0_l0 = D1CDO4crossed_ij(phiI, rk2, i, j, k, dx, dt_lev);
					d_piI_o2_t26_m0_l0 = D1CDO4crossed_ik(phiI, rk2, i, j, k, dx, dt_lev);
					d_piI_o2_t0_m0_l0 = D2CDO4_j(phiI, rk2, i, j, k, dx, dt_lev);
					d_piI_o2_t1_m0_l0 = D1CDO4crossed_jk(phiI, rk2, i, j, k, dx, dt_lev);
					d_piI_o2_t2_m0_l0 = D2CDO4_k(phiI, rk2, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t1_m0_l0 = D1CDO4_i(pheR, rk2, i, j, k, dx, dt_lev);
					d_pheR_o0_t0_m0_l0 = lieforward_i(pheR, rk2, i, j, k, dx, dt_lev);
					d_pheR_o1_t0_m0_l0 = liebackward_i(pheR, rk2, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t2_m0_l0 = D1CDO4_j(pheR, rk2, i, j, k, dx, dt_lev);
					d_pheR_o0_t1_m0_l0 = lieforward_j(pheR, rk2, i, j, k, dx, dt_lev);
					d_pheR_o1_t1_m0_l0 = liebackward_j(pheR, rk2, i, j, k, dx, dt_lev);
					d_d_pheR4d_t_o0_t3_m0_l0 = D1CDO4_k(pheR, rk2, i, j, k, dx, dt_lev);
					d_pheR_o0_t2_m0_l0 = lieforward_k(pheR, rk2, i, j, k, dx, dt_lev);
					d_pheR_o1_t2_m0_l0 = liebackward_k(pheR, rk2, i, j, k, dx, dt_lev);
					d_peR_o2_t24_m0_l0 = D2CDO4_i(pheR, rk2, i, j, k, dx, dt_lev);
					d_peR_o2_t25_m0_l0 = D1CDO4crossed_ij(pheR, rk2, i, j, k, dx, dt_lev);
					d_peR_o2_t26_m0_l0 = D1CDO4crossed_ik(pheR, rk2, i, j, k, dx, dt_lev);
					d_peR_o2_t0_m0_l0 = D2CDO4_j(pheR, rk2, i, j, k, dx, dt_lev);
					d_peR_o2_t1_m0_l0 = D1CDO4crossed_jk(pheR, rk2, i, j, k, dx, dt_lev);
					d_peR_o2_t2_m0_l0 = D2CDO4_k(pheR, rk2, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t1_m0_l0 = D1CDO4_i(pheI, rk2, i, j, k, dx, dt_lev);
					d_pheI_o0_t0_m0_l0 = lieforward_i(pheI, rk2, i, j, k, dx, dt_lev);
					d_pheI_o1_t0_m0_l0 = liebackward_i(pheI, rk2, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t2_m0_l0 = D1CDO4_j(pheI, rk2, i, j, k, dx, dt_lev);
					d_pheI_o0_t1_m0_l0 = lieforward_j(pheI, rk2, i, j, k, dx, dt_lev);
					d_pheI_o1_t1_m0_l0 = liebackward_j(pheI, rk2, i, j, k, dx, dt_lev);
					d_d_pheI4d_t_o0_t3_m0_l0 = D1CDO4_k(pheI, rk2, i, j, k, dx, dt_lev);
					d_pheI_o0_t2_m0_l0 = lieforward_k(pheI, rk2, i, j, k, dx, dt_lev);
					d_pheI_o1_t2_m0_l0 = liebackward_k(pheI, rk2, i, j, k, dx, dt_lev);
					d_peI_o2_t22_m0_l0 = D2CDO4_i(pheI, rk2, i, j, k, dx, dt_lev);
					d_peI_o2_t23_m0_l0 = D1CDO4crossed_ij(pheI, rk2, i, j, k, dx, dt_lev);
					d_peI_o2_t24_m0_l0 = D1CDO4crossed_ik(pheI, rk2, i, j, k, dx, dt_lev);
					d_peI_o2_t25_m0_l0 = D2CDO4_j(pheI, rk2, i, j, k, dx, dt_lev);
					d_peI_o2_t26_m0_l0 = D1CDO4crossed_jk(pheI, rk2, i, j, k, dx, dt_lev);
					d_peI_o2_t0_m0_l0 = D2CDO4_k(pheI, rk2, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t0_m0_l0 = lieforward_i(Atd_xx, rk2, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t0_m0_l0 = liebackward_i(Atd_xx, rk2, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t1_m0_l0 = lieforward_j(Atd_xx, rk2, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t1_m0_l0 = liebackward_j(Atd_xx, rk2, i, j, k, dx, dt_lev);
					d_Atd_xx_o0_t2_m0_l0 = lieforward_k(Atd_xx, rk2, i, j, k, dx, dt_lev);
					d_Atd_xx_o1_t2_m0_l0 = liebackward_k(Atd_xx, rk2, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t0_m0_l0 = lieforward_i(Atd_xy, rk2, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t0_m0_l0 = liebackward_i(Atd_xy, rk2, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t1_m0_l0 = lieforward_j(Atd_xy, rk2, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t1_m0_l0 = liebackward_j(Atd_xy, rk2, i, j, k, dx, dt_lev);
					d_Atd_xy_o0_t2_m0_l0 = lieforward_k(Atd_xy, rk2, i, j, k, dx, dt_lev);
					d_Atd_xy_o1_t2_m0_l0 = liebackward_k(Atd_xy, rk2, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t0_m0_l0 = lieforward_i(Atd_xz, rk2, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t0_m0_l0 = liebackward_i(Atd_xz, rk2, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t1_m0_l0 = lieforward_j(Atd_xz, rk2, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t1_m0_l0 = liebackward_j(Atd_xz, rk2, i, j, k, dx, dt_lev);
					d_Atd_xz_o0_t2_m0_l0 = lieforward_k(Atd_xz, rk2, i, j, k, dx, dt_lev);
					d_Atd_xz_o1_t2_m0_l0 = liebackward_k(Atd_xz, rk2, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t0_m0_l0 = lieforward_i(Atd_yy, rk2, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t0_m0_l0 = liebackward_i(Atd_yy, rk2, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t1_m0_l0 = lieforward_j(Atd_yy, rk2, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t1_m0_l0 = liebackward_j(Atd_yy, rk2, i, j, k, dx, dt_lev);
					d_Atd_yy_o0_t2_m0_l0 = lieforward_k(Atd_yy, rk2, i, j, k, dx, dt_lev);
					d_Atd_yy_o1_t2_m0_l0 = liebackward_k(Atd_yy, rk2, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t0_m0_l0 = lieforward_i(Atd_yz, rk2, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t0_m0_l0 = liebackward_i(Atd_yz, rk2, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t1_m0_l0 = lieforward_j(Atd_yz, rk2, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t1_m0_l0 = liebackward_j(Atd_yz, rk2, i, j, k, dx, dt_lev);
					d_Atd_yz_o0_t2_m0_l0 = lieforward_k(Atd_yz, rk2, i, j, k, dx, dt_lev);
					d_Atd_yz_o1_t2_m0_l0 = liebackward_k(Atd_yz, rk2, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t0_m0_l0 = lieforward_i(Atd_zz, rk2, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t0_m0_l0 = liebackward_i(Atd_zz, rk2, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t1_m0_l0 = lieforward_j(Atd_zz, rk2, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t1_m0_l0 = liebackward_j(Atd_zz, rk2, i, j, k, dx, dt_lev);
					d_Atd_zz_o0_t2_m0_l0 = lieforward_k(Atd_zz, rk2, i, j, k, dx, dt_lev);
					d_Atd_zz_o1_t2_m0_l0 = liebackward_k(Atd_zz, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t12_m0_l0 = D1CDO4_i(trK, rk2, i, j, k, dx, dt_lev);
					d_trK_o0_t0_m0_l0 = lieforward_i(trK, rk2, i, j, k, dx, dt_lev);
					d_trK_o1_t0_m0_l0 = liebackward_i(trK, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t13_m0_l0 = D1CDO4_j(trK, rk2, i, j, k, dx, dt_lev);
					d_trK_o0_t1_m0_l0 = lieforward_j(trK, rk2, i, j, k, dx, dt_lev);
					d_trK_o1_t1_m0_l0 = liebackward_j(trK, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t14_m0_l0 = D1CDO4_k(trK, rk2, i, j, k, dx, dt_lev);
					d_trK_o0_t2_m0_l0 = lieforward_k(trK, rk2, i, j, k, dx, dt_lev);
					d_trK_o1_t2_m0_l0 = liebackward_k(trK, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t15_m0_l0 = D1CDO4_i(theta, rk2, i, j, k, dx, dt_lev);
					d_theta_o0_t0_m0_l0 = lieforward_i(theta, rk2, i, j, k, dx, dt_lev);
					d_theta_o1_t0_m0_l0 = liebackward_i(theta, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t16_m0_l0 = D1CDO4_j(theta, rk2, i, j, k, dx, dt_lev);
					d_theta_o0_t1_m0_l0 = lieforward_j(theta, rk2, i, j, k, dx, dt_lev);
					d_theta_o1_t1_m0_l0 = liebackward_j(theta, rk2, i, j, k, dx, dt_lev);
					d_Gamh_x_o2_t17_m0_l0 = D1CDO4_k(theta, rk2, i, j, k, dx, dt_lev);
					d_theta_o0_t2_m0_l0 = lieforward_k(theta, rk2, i, j, k, dx, dt_lev);
					d_theta_o1_t2_m0_l0 = liebackward_k(theta, rk2, i, j, k, dx, dt_lev);
					d_piR_o0_t0_m0_l0 = lieforward_i(piR, rk2, i, j, k, dx, dt_lev);
					d_piR_o1_t0_m0_l0 = liebackward_i(piR, rk2, i, j, k, dx, dt_lev);
					d_piR_o0_t1_m0_l0 = lieforward_j(piR, rk2, i, j, k, dx, dt_lev);
					d_piR_o1_t1_m0_l0 = liebackward_j(piR, rk2, i, j, k, dx, dt_lev);
					d_piR_o0_t2_m0_l0 = lieforward_k(piR, rk2, i, j, k, dx, dt_lev);
					d_piR_o1_t2_m0_l0 = liebackward_k(piR, rk2, i, j, k, dx, dt_lev);
					d_peR_o0_t0_m0_l0 = lieforward_i(peR, rk2, i, j, k, dx, dt_lev);
					d_peR_o1_t0_m0_l0 = liebackward_i(peR, rk2, i, j, k, dx, dt_lev);
					d_peR_o0_t1_m0_l0 = lieforward_j(peR, rk2, i, j, k, dx, dt_lev);
					d_peR_o1_t1_m0_l0 = liebackward_j(peR, rk2, i, j, k, dx, dt_lev);
					d_peR_o0_t2_m0_l0 = lieforward_k(peR, rk2, i, j, k, dx, dt_lev);
					d_peR_o1_t2_m0_l0 = liebackward_k(peR, rk2, i, j, k, dx, dt_lev);
					d_piI_o0_t0_m0_l0 = lieforward_i(piI, rk2, i, j, k, dx, dt_lev);
					d_piI_o1_t0_m0_l0 = liebackward_i(piI, rk2, i, j, k, dx, dt_lev);
					d_piI_o0_t1_m0_l0 = lieforward_j(piI, rk2, i, j, k, dx, dt_lev);
					d_piI_o1_t1_m0_l0 = liebackward_j(piI, rk2, i, j, k, dx, dt_lev);
					d_piI_o0_t2_m0_l0 = lieforward_k(piI, rk2, i, j, k, dx, dt_lev);
					d_piI_o1_t2_m0_l0 = liebackward_k(piI, rk2, i, j, k, dx, dt_lev);
					d_peI_o0_t0_m0_l0 = lieforward_i(peI, rk2, i, j, k, dx, dt_lev);
					d_peI_o1_t2_m0_l0 = liebackward_i(peI, rk2, i, j, k, dx, dt_lev);
					d_peI_o0_t1_m0_l0 = lieforward_j(peI, rk2, i, j, k, dx, dt_lev);
					d_peI_o1_t0_m0_l0 = liebackward_j(peI, rk2, i, j, k, dx, dt_lev);
					d_peI_o0_t2_m0_l0 = lieforward_k(peI, rk2, i, j, k, dx, dt_lev);
					d_peI_o1_t1_m0_l0 = liebackward_k(peI, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t0_m0_l0 = D2CDO4_i(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t3_m0_l0 = D2CDO4_j(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xx_o0_t5_m0_l0 = D2CDO4_k(gtd_xx, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t0_m0_l0 = D2CDO4_i(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t3_m0_l0 = D2CDO4_j(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xy_o0_t5_m0_l0 = D2CDO4_k(gtd_xy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t0_m0_l0 = D2CDO4_i(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t3_m0_l0 = D2CDO4_j(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yy_o0_t5_m0_l0 = D2CDO4_k(gtd_yy, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t0_m0_l0 = D2CDO4_i(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t3_m0_l0 = D2CDO4_j(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_xz_o0_t5_m0_l0 = D2CDO4_k(gtd_xz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t0_m0_l0 = D2CDO4_i(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t3_m0_l0 = D2CDO4_j(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_yz_o0_t5_m0_l0 = D2CDO4_k(gtd_yz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t0_m0_l0 = D2CDO4_i(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t1_m0_l0 = D1CDO4crossed_ij(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t2_m0_l0 = D1CDO4crossed_ik(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t3_m0_l0 = D2CDO4_j(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t4_m0_l0 = D1CDO4crossed_jk(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rtd_zz_o0_t5_m0_l0 = D2CDO4_k(gtd_zz, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t3_m0_l0 = D2CDO4_i(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t4_m0_l0 = D1CDO4crossed_ij(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t5_m0_l0 = D1CDO4crossed_ik(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t6_m0_l0 = D2CDO4_j(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t7_m0_l0 = D1CDO4crossed_jk(chi, rk2, i, j, k, dx, dt_lev);
					d_Rpd_xx_o0_t8_m0_l0 = D2CDO4_k(chi, rk2, i, j, k, dx, dt_lev);
					rk2m_Ctd_yyz_o0_t0_l0 = .5 * d_Ctd_yyz_o0_t0_m0_l0;
					rk2Ctd_yyz = rk2m_Ctd_yyz_o0_t0_l0;
					rk2m_Ctd_yyy_o0_t0_l0 = .5 * d_Ctd_yyy_o0_t0_m0_l0;
					rk2Ctd_yyy = rk2m_Ctd_yyy_o0_t0_l0;
					rk2div_Beta = (d_div_Beta_o0_t0_m0_l0 + d_div_Beta_o0_t1_m0_l0) + d_div_Beta_o0_t2_m0_l0;
					rk2m_Ctd_xxz_o0_t0_l0 = .5 * d_Ctd_xxz_o0_t0_m0_l0;
					rk2Ctd_xxz = rk2m_Ctd_xxz_o0_t0_l0;
					rk2m_Ctd_xxx_o0_t0_l0 = .5 * d_Ctd_xxx_o0_t0_m0_l0;
					rk2Ctd_xxx = rk2m_Ctd_xxx_o0_t0_l0;
					rk2m_Ctd_yzz_o0_t1_l0 = (-.5) * d_Ctd_yzz_o0_t1_m0_l0;
					rk2m_Ctd_yzz_o0_t0_l0 = 1.0 * d_Ctd_yzz_o0_t0_m0_l0;
					rk2Ctd_yzz = rk2m_Ctd_yzz_o0_t0_l0 + rk2m_Ctd_yzz_o0_t1_l0;
					rk2m_Ctd_xxy_o0_t0_l0 = .5 * d_Ctd_xxy_o0_t0_m0_l0;
					rk2Ctd_xxy = rk2m_Ctd_xxy_o0_t0_l0;
					rk2sfmass = parameters.p_sfmass;
					rk2dVdphe2 = (rk2sfmass * rk2sfmass) * ((1.0 - 2.0 * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) + (-4.0 * ((rk2sfmass * rk2sfmass) * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) * (1.0 - 2.0 * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) / (parameters.sfsigma * parameters.sfsigma)) + parameters.sflambda * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI));
					rk2kappa_z2 = parameters.p_kappa_z2;
					rk2m_Ctd_xyy_o0_t1_l0 = (-.5) * d_Ctd_xyy_o0_t1_m0_l0;
					rk2m_Ctd_xyy_o0_t0_l0 = 1.0 * d_Ctd_xyy_o0_t0_m0_l0;
					rk2Ctd_xyy = rk2m_Ctd_xyy_o0_t0_l0 + rk2m_Ctd_xyy_o0_t1_l0;
					rk2m_Ctd_xyz_o0_t2_l0 = (-.5) * d_Ctd_xyz_o0_t2_m0_l0;
					rk2m_Ctd_xyz_o0_t1_l0 = .5 * d_Ctd_xyz_o0_t1_m0_l0;
					rk2m_Ctd_xyz_o0_t0_l0 = .5 * d_Ctd_xyz_o0_t0_m0_l0;
					rk2Ctd_xyz = (rk2m_Ctd_xyz_o0_t0_l0 + rk2m_Ctd_xyz_o0_t1_l0) + rk2m_Ctd_xyz_o0_t2_l0;
					rk2d_div_Beta_y = (d_d_div_Beta_y_o0_t0_m0_l0 + d_d_div_Beta_y_o0_t1_m0_l0) + d_d_div_Beta_y_o0_t2_m0_l0;
					rk2d_div_Beta_x = (d_d_div_Beta_x_o0_t0_m0_l0 + d_d_div_Beta_x_o0_t1_m0_l0) + d_d_div_Beta_x_o0_t2_m0_l0;
					rk2d_div_Beta_z = (d_d_div_Beta_z_o0_t0_m0_l0 + d_d_div_Beta_z_o0_t1_m0_l0) + d_d_div_Beta_z_o0_t2_m0_l0;
					rk2m_Ctd_xzz_o0_t1_l0 = (-.5) * d_Ctd_xzz_o0_t1_m0_l0;
					rk2m_Ctd_xzz_o0_t0_l0 = 1.0 * d_Ctd_xzz_o0_t0_m0_l0;
					rk2Ctd_xzz = rk2m_Ctd_xzz_o0_t0_l0 + rk2m_Ctd_xzz_o0_t1_l0;
					rk2dVdphi2 = (rk2sfmass * rk2sfmass) * ((1.0 - 2.0 * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) + (-4.0 * ((rk2sfmass * rk2sfmass) * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) * (1.0 - 2.0 * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) / (parameters.sfsigma * parameters.sfsigma)) + parameters.sflambda * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI));
					rk2d_d_phiI4d_t_o0_t0_m0_l0 = -rk2(i, j, k, Alpha) * rk2(i, j, k, piI);
					rk2m_d_phiI4d_t_o0_t6_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_d_phiI4d_t_o0_t3_m0_l0;
					rk2m_d_phiI4d_t_o0_t5_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_d_phiI4d_t_o0_t2_m0_l0;
					rk2m_d_phiI4d_t_o0_t4_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_d_phiI4d_t_o0_t1_m0_l0;
					rk2m_d_phiI4d_t_o0_t3_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_d_phiI4d_t_o0_t3_m0_l0;
					rk2m_d_phiI4d_t_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_d_phiI4d_t_o0_t2_m0_l0;
					rk2m_d_phiI4d_t_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_d_phiI4d_t_o0_t1_m0_l0;
					rk2d_phiI4d_t = (((((rk2d_d_phiI4d_t_o0_t0_m0_l0 + rk2m_d_phiI4d_t_o0_t1_l0) + rk2m_d_phiI4d_t_o0_t2_l0) + rk2m_d_phiI4d_t_o0_t3_l0) + rk2m_d_phiI4d_t_o0_t4_l0) + rk2m_d_phiI4d_t_o0_t5_l0) + rk2m_d_phiI4d_t_o0_t6_l0;
					rk2d_phiI4d_x = d_d_phiI4d_t_o0_t1_m0_l0;
					rk2d_phiI4d_y = d_d_phiI4d_t_o0_t2_m0_l0;
					rk2d_phiI4d_z = d_d_phiI4d_t_o0_t3_m0_l0;
					rk2g4u_tx = rk2(i, j, k, Betau_x) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha));
					rk2g4u_tz = rk2(i, j, k, Betau_z) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha));
					rk2g4u_ty = rk2(i, j, k, Betau_y) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha));
					rk2g4u_tt = -1.0 / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha));
					rk2d_phiI4u_t = rk2g4u_tt * rk2d_phiI4d_t + rk2g4u_tx * rk2d_phiI4d_x + rk2g4u_ty * rk2d_phiI4d_y + rk2g4u_tz * rk2d_phiI4d_z;
					rk2sfVe = (rk2sfmass * rk2sfmass) * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) * ((1.0 - 2.0 * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) / (parameters.sfsigma * parameters.sfsigma))) + parameters.sflambda / 2.0 * ((rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)) * (rk2(i, j, k, pheR) * rk2(i, j, k, pheR) + rk2(i, j, k, pheI) * rk2(i, j, k, pheI)));
					rk2sfVi = (rk2sfmass * rk2sfmass) * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) * ((1.0 - 2.0 * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma)) * (1.0 - 2.0 * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) / (parameters.sfsigma * parameters.sfsigma))) + parameters.sflambda / 2.0 * ((rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)) * (rk2(i, j, k, phiR) * rk2(i, j, k, phiR) + rk2(i, j, k, phiI) * rk2(i, j, k, phiI)));
					rk2m_Ctd_zxz_o0_t0_l0 = .5 * d_Ctd_xzz_o0_t1_m0_l0;
					rk2Ctd_zxz = rk2m_Ctd_zxz_o0_t0_l0;
					rk2m_Ctd_zxx_o0_t1_l0 = (-.5) * d_Ctd_xxz_o0_t0_m0_l0;
					rk2m_Ctd_zxx_o0_t0_l0 = 1.0 * d_Ctd_zxx_o0_t0_m0_l0;
					rk2Ctd_zxx = rk2m_Ctd_zxx_o0_t0_l0 + rk2m_Ctd_zxx_o0_t1_l0;
					rk2detgtd = rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_zz) * rk2(i, j, k, gtd_xx) + (-rk2(i, j, k, gtd_yy) * (rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_xz))) + (-rk2(i, j, k, gtd_zz) * (rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xy))) + (-(rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_yz)) * rk2(i, j, k, gtd_xx)) + 2.0 * rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xz);
					rk2d_d_phiR4d_t_o0_t0_m0_l0 = -rk2(i, j, k, Alpha) * rk2(i, j, k, piR);
					rk2m_d_phiR4d_t_o0_t6_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_d_phiR4d_t_o0_t3_m0_l0;
					rk2m_d_phiR4d_t_o0_t5_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_d_phiR4d_t_o0_t2_m0_l0;
					rk2m_d_phiR4d_t_o0_t4_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_d_phiR4d_t_o0_t1_m0_l0;
					rk2m_d_phiR4d_t_o0_t3_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_d_phiR4d_t_o0_t3_m0_l0;
					rk2m_d_phiR4d_t_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_d_phiR4d_t_o0_t2_m0_l0;
					rk2m_d_phiR4d_t_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_d_phiR4d_t_o0_t1_m0_l0;
					rk2d_phiR4d_t = (((((rk2d_d_phiR4d_t_o0_t0_m0_l0 + rk2m_d_phiR4d_t_o0_t1_l0) + rk2m_d_phiR4d_t_o0_t2_l0) + rk2m_d_phiR4d_t_o0_t3_l0) + rk2m_d_phiR4d_t_o0_t4_l0) + rk2m_d_phiR4d_t_o0_t5_l0) + rk2m_d_phiR4d_t_o0_t6_l0;
					rk2d_phiR4d_x = d_d_phiR4d_t_o0_t1_m0_l0;
					rk2d_phiR4d_z = d_d_phiR4d_t_o0_t3_m0_l0;
					rk2d_phiR4d_y = d_d_phiR4d_t_o0_t2_m0_l0;
					rk2d_phiR4u_t = rk2g4u_tt * rk2d_phiR4d_t + rk2g4u_tx * rk2d_phiR4d_x + rk2g4u_ty * rk2d_phiR4d_y + rk2g4u_tz * rk2d_phiR4d_z;
					rk2chi_max = std::max(parameters.chi_floor, rk2(i, j, k, chi));
					rk2inv_chi = 1.0 / fabs(rk2chi_max);
					rk2d_d_pheR4d_t_o0_t0_m0_l0 = -rk2(i, j, k, Alpha) * rk2(i, j, k, peR);
					rk2m_d_pheR4d_t_o0_t6_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_d_pheR4d_t_o0_t3_m0_l0;
					rk2m_d_pheR4d_t_o0_t5_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_d_pheR4d_t_o0_t2_m0_l0;
					rk2m_d_pheR4d_t_o0_t4_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_d_pheR4d_t_o0_t1_m0_l0;
					rk2m_d_pheR4d_t_o0_t3_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_d_pheR4d_t_o0_t3_m0_l0;
					rk2m_d_pheR4d_t_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_d_pheR4d_t_o0_t2_m0_l0;
					rk2m_d_pheR4d_t_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_d_pheR4d_t_o0_t1_m0_l0;
					rk2d_pheR4d_t = (((((rk2d_d_pheR4d_t_o0_t0_m0_l0 + rk2m_d_pheR4d_t_o0_t1_l0) + rk2m_d_pheR4d_t_o0_t2_l0) + rk2m_d_pheR4d_t_o0_t3_l0) + rk2m_d_pheR4d_t_o0_t4_l0) + rk2m_d_pheR4d_t_o0_t5_l0) + rk2m_d_pheR4d_t_o0_t6_l0;
					rk2d_pheR4d_x = d_d_pheR4d_t_o0_t1_m0_l0;
					rk2d_pheR4d_y = d_d_pheR4d_t_o0_t2_m0_l0;
					rk2d_pheR4d_z = d_d_pheR4d_t_o0_t3_m0_l0;
					rk2d_pheR4u_t = rk2g4u_tt * rk2d_pheR4d_t + rk2g4u_tx * rk2d_pheR4d_x + rk2g4u_ty * rk2d_pheR4d_y + rk2g4u_tz * rk2d_pheR4d_z;
					rk2m_Ctd_zyy_o0_t1_l0 = (-.5) * d_Ctd_yyz_o0_t0_m0_l0;
					rk2m_Ctd_zyy_o0_t0_l0 = 1.0 * d_Ctd_zyy_o0_t0_m0_l0;
					rk2Ctd_zyy = rk2m_Ctd_zyy_o0_t0_l0 + rk2m_Ctd_zyy_o0_t1_l0;
					rk2m_Ctd_zyz_o0_t0_l0 = .5 * d_Ctd_yzz_o0_t1_m0_l0;
					rk2Ctd_zyz = rk2m_Ctd_zyz_o0_t0_l0;
					rk2Betatd_x = rk2(i, j, k, Betau_x) * rk2(i, j, k, gtd_xx) + rk2(i, j, k, Betau_y) * rk2(i, j, k, gtd_xy) + rk2(i, j, k, Betau_z) * rk2(i, j, k, gtd_xz);
					rk2Betatd_z = rk2(i, j, k, Betau_x) * rk2(i, j, k, gtd_xz) + rk2(i, j, k, Betau_y) * rk2(i, j, k, gtd_yz) + rk2(i, j, k, Betau_z) * rk2(i, j, k, gtd_zz);
					rk2Betatd_y = rk2(i, j, k, Betau_x) * rk2(i, j, k, gtd_xy) + rk2(i, j, k, Betau_y) * rk2(i, j, k, gtd_yy) + rk2(i, j, k, Betau_z) * rk2(i, j, k, gtd_yz);
					rk2idetgtd = 1.0 / rk2detgtd;
					rk2gtu_zz = rk2idetgtd * (rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_yy) - rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xy));
					rk2g4u_zz = rk2chi_max * rk2gtu_zz + (-(rk2(i, j, k, Betau_z) * rk2(i, j, k, Betau_z)) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)));
					rk2gtu_yy = rk2idetgtd * (rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_zz) - rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_xz));
					rk2g4u_yy = rk2chi_max * rk2gtu_yy + (-(rk2(i, j, k, Betau_y) * rk2(i, j, k, Betau_y)) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)));
					rk2gtu_yz = rk2idetgtd * ((-rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_yz)) + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xz));
					rk2g4u_yz = rk2chi_max * rk2gtu_yz + (-(rk2(i, j, k, Betau_y) * rk2(i, j, k, Betau_z)) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)));
					rk2gtu_xx = rk2idetgtd * (rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_zz) - rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_yz));
					rk2g4u_xx = rk2chi_max * rk2gtu_xx + (-(rk2(i, j, k, Betau_x) * rk2(i, j, k, Betau_x)) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)));
					rk2gtu_xz = rk2idetgtd * (rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yz) - rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_xz));
					rk2g4u_xz = rk2chi_max * rk2gtu_xz + (-(rk2(i, j, k, Betau_x) * rk2(i, j, k, Betau_z)) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)));
					rk2d_pheR4u_z = rk2g4u_tz * rk2d_pheR4d_t + rk2g4u_xz * rk2d_pheR4d_x + rk2g4u_yz * rk2d_pheR4d_y + rk2g4u_zz * rk2d_pheR4d_z;
					rk2d_phiR4u_z = rk2g4u_tz * rk2d_phiR4d_t + rk2g4u_xz * rk2d_phiR4d_x + rk2g4u_yz * rk2d_phiR4d_y + rk2g4u_zz * rk2d_phiR4d_z;
					rk2d_phiI4u_z = rk2g4u_tz * rk2d_phiI4d_t + rk2g4u_xz * rk2d_phiI4d_x + rk2g4u_yz * rk2d_phiI4d_y + rk2g4u_zz * rk2d_phiI4d_z;
					rk2Ct_zyz = rk2gtu_xz * rk2Ctd_xyz + rk2gtu_yz * rk2Ctd_yyz + rk2gtu_zz * rk2Ctd_zyz;
					rk2Ct_zyy = rk2gtu_xz * rk2Ctd_xyy + rk2gtu_yz * rk2Ctd_yyy + rk2gtu_zz * rk2Ctd_zyy;
					rk2Atud_zx = rk2gtu_xz * rk2(i, j, k, Atd_xx) + rk2gtu_yz * rk2(i, j, k, Atd_xy) + rk2gtu_zz * rk2(i, j, k, Atd_xz);
					rk2Atud_zz = rk2gtu_xz * rk2(i, j, k, Atd_xz) + rk2gtu_yz * rk2(i, j, k, Atd_yz) + rk2gtu_zz * rk2(i, j, k, Atd_zz);
					rk2Atud_zy = rk2gtu_xz * rk2(i, j, k, Atd_xy) + rk2gtu_yz * rk2(i, j, k, Atd_yy) + rk2gtu_zz * rk2(i, j, k, Atd_yz);
					rk2Atu_zz = rk2Atud_zx * rk2gtu_xz + rk2Atud_zy * rk2gtu_yz + rk2Atud_zz * rk2gtu_zz;
					rk2gtu_xy = rk2idetgtd * ((-rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_zz)) + rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_xz));
					rk2g4u_xy = rk2chi_max * rk2gtu_xy + (-(rk2(i, j, k, Betau_x) * rk2(i, j, k, Betau_y)) / (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)));
					rk2d_pheR4u_x = rk2g4u_tx * rk2d_pheR4d_t + rk2g4u_xx * rk2d_pheR4d_x + rk2g4u_xy * rk2d_pheR4d_y + rk2g4u_xz * rk2d_pheR4d_z;
					rk2d_pheR4u_y = rk2g4u_ty * rk2d_pheR4d_t + rk2g4u_xy * rk2d_pheR4d_x + rk2g4u_yy * rk2d_pheR4d_y + rk2g4u_yz * rk2d_pheR4d_z;
					rk2d_phiR4u_y = rk2g4u_ty * rk2d_phiR4d_t + rk2g4u_xy * rk2d_phiR4d_x + rk2g4u_yy * rk2d_phiR4d_y + rk2g4u_yz * rk2d_phiR4d_z;
					rk2d_phiR4u_x = rk2g4u_tx * rk2d_phiR4d_t + rk2g4u_xx * rk2d_phiR4d_x + rk2g4u_xy * rk2d_phiR4d_y + rk2g4u_xz * rk2d_phiR4d_z;
					rk2d_phiI4u_y = rk2g4u_ty * rk2d_phiI4d_t + rk2g4u_xy * rk2d_phiI4d_x + rk2g4u_yy * rk2d_phiI4d_y + rk2g4u_yz * rk2d_phiI4d_z;
					rk2d_phiI4u_x = rk2g4u_tx * rk2d_phiI4d_t + rk2g4u_xx * rk2d_phiI4d_x + rk2g4u_xy * rk2d_phiI4d_y + rk2g4u_xz * rk2d_phiI4d_z;
					rk2dphi4sq = rk2d_phiR4u_t * rk2d_phiR4d_t + rk2d_phiR4u_x * rk2d_phiR4d_x + rk2d_phiR4u_y * rk2d_phiR4d_y + rk2d_phiR4u_z * rk2d_phiR4d_z + rk2d_phiI4u_t * rk2d_phiI4d_t + rk2d_phiI4u_x * rk2d_phiI4d_x + rk2d_phiI4u_y * rk2d_phiI4d_y + rk2d_phiI4u_z * rk2d_phiI4d_z;
					rk2Atud_yy = rk2gtu_xy * rk2(i, j, k, Atd_xy) + rk2gtu_yy * rk2(i, j, k, Atd_yy) + rk2gtu_yz * rk2(i, j, k, Atd_yz);
					rk2Atud_yx = rk2gtu_xy * rk2(i, j, k, Atd_xx) + rk2gtu_yy * rk2(i, j, k, Atd_xy) + rk2gtu_yz * rk2(i, j, k, Atd_xz);
					rk2Atud_yz = rk2gtu_xy * rk2(i, j, k, Atd_xz) + rk2gtu_yy * rk2(i, j, k, Atd_yz) + rk2gtu_yz * rk2(i, j, k, Atd_zz);
					rk2Atu_yz = rk2Atud_yx * rk2gtu_xz + rk2Atud_yy * rk2gtu_yz + rk2Atud_yz * rk2gtu_zz;
					rk2Atu_yy = rk2Atud_yx * rk2gtu_xy + rk2Atud_yy * rk2gtu_yy + rk2Atud_yz * rk2gtu_yz;
					rk2Ct_yyy = rk2gtu_xy * rk2Ctd_xyy + rk2gtu_yy * rk2Ctd_yyy + rk2gtu_yz * rk2Ctd_zyy;
					rk2Ct_yyz = rk2gtu_xy * rk2Ctd_xyz + rk2gtu_yy * rk2Ctd_yyz + rk2gtu_yz * rk2Ctd_zyz;
					rk2Atud_xx = rk2gtu_xx * rk2(i, j, k, Atd_xx) + rk2gtu_xy * rk2(i, j, k, Atd_xy) + rk2gtu_xz * rk2(i, j, k, Atd_xz);
					rk2trAt = rk2Atud_xx + rk2Atud_yy + rk2Atud_zz;
					rk2Atud_xz = rk2gtu_xx * rk2(i, j, k, Atd_xz) + rk2gtu_xy * rk2(i, j, k, Atd_yz) + rk2gtu_xz * rk2(i, j, k, Atd_zz);
					rk2Atud_xy = rk2gtu_xx * rk2(i, j, k, Atd_xy) + rk2gtu_xy * rk2(i, j, k, Atd_yy) + rk2gtu_xz * rk2(i, j, k, Atd_yz);
					rk2Atu_xz = rk2Atud_xx * rk2gtu_xz + rk2Atud_xy * rk2gtu_yz + rk2Atud_xz * rk2gtu_zz;
					rk2Atu_xy = rk2Atud_xx * rk2gtu_xy + rk2Atud_xy * rk2gtu_yy + rk2Atud_xz * rk2gtu_yz;
					rk2Atu_xx = rk2Atud_xx * rk2gtu_xx + rk2Atud_xy * rk2gtu_xy + rk2Atud_xz * rk2gtu_xz;
					rk2decay_factor = std::min(1.0, pow((parameters.R_0 / std::max(0.0000000001, sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k)))), parameters.eta_damping_exp));
					rk2kappa_z1 = std::min(parameters.p_kappa_z1, parameters.p_kappa_z1 * rk2decay_factor) / rk2(i, j, k, Alpha);
					rk2feta = std::min(parameters.p_feta, parameters.p_feta * rk2decay_factor);
					rk2m_Ctd_zzz_o0_t0_l0 = .5 * d_Ctd_zzz_o0_t0_m0_l0;
					rk2Ctd_zzz = rk2m_Ctd_zzz_o0_t0_l0;
					rk2Ct_xzz = rk2gtu_xx * rk2Ctd_xzz + rk2gtu_xy * rk2Ctd_yzz + rk2gtu_xz * rk2Ctd_zzz;
					rk2Ct_zzz = rk2gtu_xz * rk2Ctd_xzz + rk2gtu_yz * rk2Ctd_yzz + rk2gtu_zz * rk2Ctd_zzz;
					rk2Ct_yzz = rk2gtu_xy * rk2Ctd_xzz + rk2gtu_yy * rk2Ctd_yzz + rk2gtu_yz * rk2Ctd_zzz;
					rk2m_Ctd_yxy_o0_t0_l0 = .5 * d_Ctd_xyy_o0_t1_m0_l0;
					rk2Ctd_yxy = rk2m_Ctd_yxy_o0_t0_l0;
					rk2Ct_xyz = rk2gtu_xx * rk2Ctd_xyz + rk2gtu_xy * rk2Ctd_yyz + rk2gtu_xz * rk2Ctd_zyz;
					rk2m_Ctd_yxz_o0_t2_l0 = (-.5) * d_Ctd_xyz_o0_t0_m0_l0;
					rk2m_Ctd_yxz_o0_t0_l0 = .5 * d_Ctd_xyz_o0_t2_m0_l0;
					rk2Ctd_yxz = (rk2m_Ctd_yxz_o0_t0_l0 + rk2m_Ctd_xyz_o0_t1_l0) + rk2m_Ctd_yxz_o0_t2_l0;
					rk2Ct_zxz = rk2gtu_xz * rk2Ctd_xxz + rk2gtu_yz * rk2Ctd_yxz + rk2gtu_zz * rk2Ctd_zxz;
					rk2Ct_yxz = rk2gtu_xy * rk2Ctd_xxz + rk2gtu_yy * rk2Ctd_yxz + rk2gtu_yz * rk2Ctd_zxz;
					rk2m_Ctd_zxy_o0_t2_l0 = (-.5) * d_Ctd_xyz_o0_t1_m0_l0;
					rk2Ctd_zxy = (rk2m_Ctd_yxz_o0_t0_l0 + rk2m_Ctd_xyz_o0_t0_l0) + rk2m_Ctd_zxy_o0_t2_l0;
					rk2Ct_zxy = rk2gtu_xz * rk2Ctd_xxy + rk2gtu_yz * rk2Ctd_yxy + rk2gtu_zz * rk2Ctd_zxy;
					rk2Ct_yxy = rk2gtu_xy * rk2Ctd_xxy + rk2gtu_yy * rk2Ctd_yxy + rk2gtu_yz * rk2Ctd_zxy;
					rk2Ct_xxy = rk2gtu_xx * rk2Ctd_xxy + rk2gtu_xy * rk2Ctd_yxy + rk2gtu_xz * rk2Ctd_zxy;
					rk2Ct_xxz = rk2gtu_xx * rk2Ctd_xxz + rk2gtu_xy * rk2Ctd_yxz + rk2gtu_xz * rk2Ctd_zxz;
					rk2Ct_xyy = rk2gtu_xx * rk2Ctd_xyy + rk2gtu_xy * rk2Ctd_yyy + rk2gtu_xz * rk2Ctd_zyy;
					rk2m_Ctd_yxx_o0_t1_l0 = (-.5) * d_Ctd_xxy_o0_t0_m0_l0;
					rk2m_Ctd_yxx_o0_t0_l0 = 1.0 * d_Ctd_yxx_o0_t0_m0_l0;
					rk2Ctd_yxx = rk2m_Ctd_yxx_o0_t0_l0 + rk2m_Ctd_yxx_o0_t1_l0;
					rk2Ct_zxx = rk2gtu_xz * rk2Ctd_xxx + rk2gtu_yz * rk2Ctd_yxx + rk2gtu_zz * rk2Ctd_zxx;
					rk2Gamt_z = rk2gtu_xx * rk2Ct_zxx + 2.0 * rk2gtu_xy * rk2Ct_zxy + 2.0 * rk2gtu_xz * rk2Ct_zxz + rk2gtu_yy * rk2Ct_zyy + 2.0 * rk2gtu_yz * rk2Ct_zyz + rk2gtu_zz * rk2Ct_zzz;
					rk2Zu_z = .5 * rk2chi_max * (rk2(i, j, k, Gamh_z) - rk2Gamt_z);
					rk2Ct_yxx = rk2gtu_xy * rk2Ctd_xxx + rk2gtu_yy * rk2Ctd_yxx + rk2gtu_yz * rk2Ctd_zxx;
					rk2Gamt_y = rk2gtu_xx * rk2Ct_yxx + 2.0 * rk2gtu_xy * rk2Ct_yxy + 2.0 * rk2gtu_xz * rk2Ct_yxz + rk2gtu_yy * rk2Ct_yyy + 2.0 * rk2gtu_yz * rk2Ct_yyz + rk2gtu_zz * rk2Ct_yzz;
					rk2Zu_y = .5 * rk2chi_max * (rk2(i, j, k, Gamh_y) - rk2Gamt_y);
					rk2Ct_xxx = rk2gtu_xx * rk2Ctd_xxx + rk2gtu_xy * rk2Ctd_yxx + rk2gtu_xz * rk2Ctd_zxx;
					rk2Gamt_x = rk2gtu_xx * rk2Ct_xxx + 2.0 * rk2gtu_xy * rk2Ct_xxy + 2.0 * rk2gtu_xz * rk2Ct_xxz + rk2gtu_yy * rk2Ct_xyy + 2.0 * rk2gtu_yz * rk2Ct_xyz + rk2gtu_zz * rk2Ct_xzz;
					rk2Zu_x = .5 * rk2chi_max * (rk2(i, j, k, Gamh_x) - rk2Gamt_x);
					rk2d_Rtd_xx_o0_t9_m0_l0 = rk2gtu_zz * (3.0 * rk2Ct_xxz * rk2Ctd_xxz + 2.0 * rk2Ct_yxz * rk2Ctd_xyz + rk2Ct_yxz * rk2Ctd_yxz + 2.0 * rk2Ct_zxz * rk2Ctd_xzz + rk2Ct_zxz * rk2Ctd_zxz) + rk2gtu_yz * (3.0 * rk2Ct_xxy * rk2Ctd_xxz + 2.0 * rk2Ct_yxy * rk2Ctd_xyz + rk2Ct_yxy * rk2Ctd_yxz + 2.0 * rk2Ct_zxy * rk2Ctd_xzz + rk2Ct_zxy * rk2Ctd_zxz) + rk2gtu_xz * (3.0 * rk2Ct_xxx * rk2Ctd_xxz + 2.0 * rk2Ct_yxx * rk2Ctd_xyz + rk2Ct_yxx * rk2Ctd_yxz + 2.0 * rk2Ct_zxx * rk2Ctd_xzz + rk2Ct_zxx * rk2Ctd_zxz) + rk2gtu_yz * (3.0 * rk2Ct_xxz * rk2Ctd_xxy + 2.0 * rk2Ct_yxz * rk2Ctd_xyy + rk2Ct_yxz * rk2Ctd_yxy + 2.0 * rk2Ct_zxz * rk2Ctd_xyz + rk2Ct_zxz * rk2Ctd_zxy) + rk2gtu_yy * (3.0 * rk2Ct_xxy * rk2Ctd_xxy + 2.0 * rk2Ct_yxy * rk2Ctd_xyy + rk2Ct_yxy * rk2Ctd_yxy + 2.0 * rk2Ct_zxy * rk2Ctd_xyz + rk2Ct_zxy * rk2Ctd_zxy) + rk2gtu_xy * (3.0 * rk2Ct_xxx * rk2Ctd_xxy + 2.0 * rk2Ct_yxx * rk2Ctd_xyy + rk2Ct_yxx * rk2Ctd_yxy + 2.0 * rk2Ct_zxx * rk2Ctd_xyz + rk2Ct_zxx * rk2Ctd_zxy) + rk2gtu_xz * (3.0 * rk2Ct_xxz * rk2Ctd_xxx + 2.0 * rk2Ct_yxz * rk2Ctd_xxy + rk2Ct_yxz * rk2Ctd_yxx + 2.0 * rk2Ct_zxz * rk2Ctd_xxz + rk2Ct_zxz * rk2Ctd_zxx) + rk2gtu_xy * (3.0 * rk2Ct_xxy * rk2Ctd_xxx + 2.0 * rk2Ct_yxy * rk2Ctd_xxy + rk2Ct_yxy * rk2Ctd_yxx + 2.0 * rk2Ct_zxy * rk2Ctd_xxz + rk2Ct_zxy * rk2Ctd_zxx) + rk2gtu_xx * (3.0 * rk2Ct_xxx * rk2Ctd_xxx + 2.0 * rk2Ct_yxx * rk2Ctd_xxy + rk2Ct_yxx * rk2Ctd_yxx + 2.0 * rk2Ct_zxx * rk2Ctd_xxz + rk2Ct_zxx * rk2Ctd_zxx) + 1.0 * rk2(i, j, k, Gamh_z) * rk2Ctd_xxz + 1.0 * rk2(i, j, k, Gamh_y) * rk2Ctd_xxy + 1.0 * rk2(i, j, k, Gamh_x) * rk2Ctd_xxx;
					rk2m_Rtd_xx_o0_t8_l0 = 1.0 * rk2(i, j, k, gtd_xz) * d_Rtd_xx_o0_t8_m0_l0;
					rk2m_Rtd_xx_o0_t7_l0 = 1.0 * rk2(i, j, k, gtd_xy) * d_Rtd_xx_o0_t7_m0_l0;
					rk2m_Rtd_xx_o0_t6_l0 = 1.0 * rk2(i, j, k, gtd_xx) * d_Rtd_xx_o0_t6_m0_l0;
					rk2m_Rtd_xx_o0_t5_l0 = (-.5 * rk2gtu_zz) * d_Rtd_xx_o0_t5_m0_l0;
					rk2m_Rtd_xx_o0_t4_l0 = (-1.0 * rk2gtu_yz) * d_Rtd_xx_o0_t4_m0_l0;
					rk2m_Rtd_xx_o0_t3_l0 = (-.5 * rk2gtu_yy) * d_Rtd_xx_o0_t3_m0_l0;
					rk2m_Rtd_xx_o0_t2_l0 = (-1.0 * rk2gtu_xz) * d_Rtd_xx_o0_t2_m0_l0;
					rk2m_Rtd_xx_o0_t1_l0 = (-1.0 * rk2gtu_xy) * d_Rtd_xx_o0_t1_m0_l0;
					rk2m_Rtd_xx_o0_t0_l0 = (-.5 * rk2gtu_xx) * d_Rtd_xx_o0_t0_m0_l0;
					rk2Rtd_xx = ((((((((rk2m_Rtd_xx_o0_t0_l0 + rk2m_Rtd_xx_o0_t1_l0) + rk2m_Rtd_xx_o0_t2_l0) + rk2m_Rtd_xx_o0_t3_l0) + rk2m_Rtd_xx_o0_t4_l0) + rk2m_Rtd_xx_o0_t5_l0) + rk2m_Rtd_xx_o0_t6_l0) + rk2m_Rtd_xx_o0_t7_l0) + rk2m_Rtd_xx_o0_t8_l0) + rk2d_Rtd_xx_o0_t9_m0_l0;
					rk2d_Rtd_xz_o0_t12_m0_l0 = rk2gtu_zz * (rk2Ct_xxz * rk2Ctd_zxz + rk2Ct_xxz * rk2Ctd_xzz + rk2Ct_xzz * rk2Ctd_xxz + rk2Ct_yxz * rk2Ctd_zyz + rk2Ct_yxz * rk2Ctd_yzz + rk2Ct_yzz * rk2Ctd_xyz + 2.0 * rk2Ct_zxz * rk2Ctd_zzz + rk2Ct_zzz * rk2Ctd_xzz) + rk2gtu_yz * (rk2Ct_xxy * rk2Ctd_zxz + rk2Ct_xxy * rk2Ctd_xzz + rk2Ct_xyz * rk2Ctd_xxz + rk2Ct_yxy * rk2Ctd_zyz + rk2Ct_yxy * rk2Ctd_yzz + rk2Ct_yyz * rk2Ctd_xyz + 2.0 * rk2Ct_zxy * rk2Ctd_zzz + rk2Ct_zyz * rk2Ctd_xzz) + rk2gtu_xz * (rk2Ct_xxx * rk2Ctd_zxz + rk2Ct_xxx * rk2Ctd_xzz + rk2Ct_xxz * rk2Ctd_xxz + rk2Ct_yxx * rk2Ctd_zyz + rk2Ct_yxx * rk2Ctd_yzz + rk2Ct_yxz * rk2Ctd_xyz + 2.0 * rk2Ct_zxx * rk2Ctd_zzz + rk2Ct_zxz * rk2Ctd_xzz) + rk2gtu_yz * (rk2Ct_xxz * rk2Ctd_zxy + rk2Ct_xxz * rk2Ctd_xyz + rk2Ct_xzz * rk2Ctd_xxy + rk2Ct_yxz * rk2Ctd_zyy + rk2Ct_yxz * rk2Ctd_yyz + rk2Ct_yzz * rk2Ctd_xyy + 2.0 * rk2Ct_zxz * rk2Ctd_zyz + rk2Ct_zzz * rk2Ctd_xyz) + rk2gtu_yy * (rk2Ct_xxy * rk2Ctd_zxy + rk2Ct_xxy * rk2Ctd_xyz + rk2Ct_xyz * rk2Ctd_xxy + rk2Ct_yxy * rk2Ctd_zyy + rk2Ct_yxy * rk2Ctd_yyz + rk2Ct_yyz * rk2Ctd_xyy + 2.0 * rk2Ct_zxy * rk2Ctd_zyz + rk2Ct_zyz * rk2Ctd_xyz) + rk2gtu_xy * (rk2Ct_xxx * rk2Ctd_zxy + rk2Ct_xxx * rk2Ctd_xyz + rk2Ct_xxz * rk2Ctd_xxy + rk2Ct_yxx * rk2Ctd_zyy + rk2Ct_yxx * rk2Ctd_yyz + rk2Ct_yxz * rk2Ctd_xyy + 2.0 * rk2Ct_zxx * rk2Ctd_zyz + rk2Ct_zxz * rk2Ctd_xyz) + rk2gtu_xz * (rk2Ct_xxz * rk2Ctd_zxx + rk2Ct_xxz * rk2Ctd_xxz + rk2Ct_xzz * rk2Ctd_xxx + rk2Ct_yxz * rk2Ctd_zxy + rk2Ct_yxz * rk2Ctd_yxz + rk2Ct_yzz * rk2Ctd_xxy + 2.0 * rk2Ct_zxz * rk2Ctd_zxz + rk2Ct_zzz * rk2Ctd_xxz) + rk2gtu_xy * (rk2Ct_xxy * rk2Ctd_zxx + rk2Ct_xxy * rk2Ctd_xxz + rk2Ct_xyz * rk2Ctd_xxx + rk2Ct_yxy * rk2Ctd_zxy + rk2Ct_yxy * rk2Ctd_yxz + rk2Ct_yyz * rk2Ctd_xxy + 2.0 * rk2Ct_zxy * rk2Ctd_zxz + rk2Ct_zyz * rk2Ctd_xxz) + rk2gtu_xx * (rk2Ct_xxx * rk2Ctd_zxx + rk2Ct_xxx * rk2Ctd_xxz + rk2Ct_xxz * rk2Ctd_xxx + rk2Ct_yxx * rk2Ctd_zxy + rk2Ct_yxx * rk2Ctd_yxz + rk2Ct_yxz * rk2Ctd_xxy + 2.0 * rk2Ct_zxx * rk2Ctd_zxz + rk2Ct_zxz * rk2Ctd_xxz) + .5 * rk2(i, j, k, Gamh_z) * (rk2Ctd_xzz + rk2Ctd_zxz) + .5 * rk2(i, j, k, Gamh_y) * (rk2Ctd_xyz + rk2Ctd_zxy) + .5 * rk2(i, j, k, Gamh_x) * (rk2Ctd_xxz + rk2Ctd_zxx);
					rk2m_Rtd_xz_o0_t11_l0 = .5 * rk2(i, j, k, gtd_zz) * d_Rtd_xx_o0_t8_m0_l0;
					rk2m_Rtd_xz_o0_t10_l0 = .5 * rk2(i, j, k, gtd_yz) * d_Rtd_xx_o0_t7_m0_l0;
					rk2m_Rtd_xz_o0_t9_l0 = .5 * rk2(i, j, k, gtd_xz) * d_Rtd_xx_o0_t6_m0_l0;
					rk2m_Rtd_xz_o0_t8_l0 = .5 * rk2(i, j, k, gtd_xz) * d_Rtd_xz_o0_t8_m0_l0;
					rk2m_Rtd_xz_o0_t7_l0 = .5 * rk2(i, j, k, gtd_xy) * d_Rtd_xz_o0_t7_m0_l0;
					rk2m_Rtd_xz_o0_t6_l0 = .5 * rk2(i, j, k, gtd_xx) * d_Rtd_xz_o0_t6_m0_l0;
					rk2m_Rtd_xz_o0_t5_l0 = (-.5 * rk2gtu_zz) * d_Rtd_xz_o0_t5_m0_l0;
					rk2m_Rtd_xz_o0_t4_l0 = (-1.0 * rk2gtu_yz) * d_Rtd_xz_o0_t4_m0_l0;
					rk2m_Rtd_xz_o0_t3_l0 = (-.5 * rk2gtu_yy) * d_Rtd_xz_o0_t3_m0_l0;
					rk2m_Rtd_xz_o0_t2_l0 = (-1.0 * rk2gtu_xz) * d_Rtd_xz_o0_t2_m0_l0;
					rk2m_Rtd_xz_o0_t1_l0 = (-1.0 * rk2gtu_xy) * d_Rtd_xz_o0_t1_m0_l0;
					rk2m_Rtd_xz_o0_t0_l0 = (-.5 * rk2gtu_xx) * d_Rtd_xz_o0_t0_m0_l0;
					rk2Rtd_xz = (((((((((((rk2m_Rtd_xz_o0_t0_l0 + rk2m_Rtd_xz_o0_t1_l0) + rk2m_Rtd_xz_o0_t2_l0) + rk2m_Rtd_xz_o0_t3_l0) + rk2m_Rtd_xz_o0_t4_l0) + rk2m_Rtd_xz_o0_t5_l0) + rk2m_Rtd_xz_o0_t6_l0) + rk2m_Rtd_xz_o0_t7_l0) + rk2m_Rtd_xz_o0_t8_l0) + rk2m_Rtd_xz_o0_t9_l0) + rk2m_Rtd_xz_o0_t10_l0) + rk2m_Rtd_xz_o0_t11_l0) + rk2d_Rtd_xz_o0_t12_m0_l0;
					rk2d_Rtd_zz_o0_t9_m0_l0 = rk2gtu_zz * (2.0 * rk2Ct_xzz * rk2Ctd_zxz + rk2Ct_xzz * rk2Ctd_xzz + 2.0 * rk2Ct_yzz * rk2Ctd_zyz + rk2Ct_yzz * rk2Ctd_yzz + 3.0 * rk2Ct_zzz * rk2Ctd_zzz) + rk2gtu_yz * (2.0 * rk2Ct_xyz * rk2Ctd_zxz + rk2Ct_xyz * rk2Ctd_xzz + 2.0 * rk2Ct_yyz * rk2Ctd_zyz + rk2Ct_yyz * rk2Ctd_yzz + 3.0 * rk2Ct_zyz * rk2Ctd_zzz) + rk2gtu_xz * (2.0 * rk2Ct_xxz * rk2Ctd_zxz + rk2Ct_xxz * rk2Ctd_xzz + 2.0 * rk2Ct_yxz * rk2Ctd_zyz + rk2Ct_yxz * rk2Ctd_yzz + 3.0 * rk2Ct_zxz * rk2Ctd_zzz) + rk2gtu_yz * (2.0 * rk2Ct_xzz * rk2Ctd_zxy + rk2Ct_xzz * rk2Ctd_xyz + 2.0 * rk2Ct_yzz * rk2Ctd_zyy + rk2Ct_yzz * rk2Ctd_yyz + 3.0 * rk2Ct_zzz * rk2Ctd_zyz) + rk2gtu_yy * (2.0 * rk2Ct_xyz * rk2Ctd_zxy + rk2Ct_xyz * rk2Ctd_xyz + 2.0 * rk2Ct_yyz * rk2Ctd_zyy + rk2Ct_yyz * rk2Ctd_yyz + 3.0 * rk2Ct_zyz * rk2Ctd_zyz) + rk2gtu_xy * (2.0 * rk2Ct_xxz * rk2Ctd_zxy + rk2Ct_xxz * rk2Ctd_xyz + 2.0 * rk2Ct_yxz * rk2Ctd_zyy + rk2Ct_yxz * rk2Ctd_yyz + 3.0 * rk2Ct_zxz * rk2Ctd_zyz) + rk2gtu_xz * (2.0 * rk2Ct_xzz * rk2Ctd_zxx + rk2Ct_xzz * rk2Ctd_xxz + 2.0 * rk2Ct_yzz * rk2Ctd_zxy + rk2Ct_yzz * rk2Ctd_yxz + 3.0 * rk2Ct_zzz * rk2Ctd_zxz) + rk2gtu_xy * (2.0 * rk2Ct_xyz * rk2Ctd_zxx + rk2Ct_xyz * rk2Ctd_xxz + 2.0 * rk2Ct_yyz * rk2Ctd_zxy + rk2Ct_yyz * rk2Ctd_yxz + 3.0 * rk2Ct_zyz * rk2Ctd_zxz) + rk2gtu_xx * (2.0 * rk2Ct_xxz * rk2Ctd_zxx + rk2Ct_xxz * rk2Ctd_xxz + 2.0 * rk2Ct_yxz * rk2Ctd_zxy + rk2Ct_yxz * rk2Ctd_yxz + 3.0 * rk2Ct_zxz * rk2Ctd_zxz) + 1.0 * rk2(i, j, k, Gamh_z) * rk2Ctd_zzz + 1.0 * rk2(i, j, k, Gamh_y) * rk2Ctd_zyz + 1.0 * rk2(i, j, k, Gamh_x) * rk2Ctd_zxz;
					rk2m_Rtd_zz_o0_t8_l0 = 1.0 * rk2(i, j, k, gtd_zz) * d_Rtd_xz_o0_t8_m0_l0;
					rk2m_Rtd_zz_o0_t7_l0 = 1.0 * rk2(i, j, k, gtd_yz) * d_Rtd_xz_o0_t7_m0_l0;
					rk2m_Rtd_zz_o0_t6_l0 = 1.0 * rk2(i, j, k, gtd_xz) * d_Rtd_xz_o0_t6_m0_l0;
					rk2m_Rtd_zz_o0_t5_l0 = (-.5 * rk2gtu_zz) * d_Rtd_zz_o0_t5_m0_l0;
					rk2m_Rtd_zz_o0_t4_l0 = (-1.0 * rk2gtu_yz) * d_Rtd_zz_o0_t4_m0_l0;
					rk2m_Rtd_zz_o0_t3_l0 = (-.5 * rk2gtu_yy) * d_Rtd_zz_o0_t3_m0_l0;
					rk2m_Rtd_zz_o0_t2_l0 = (-1.0 * rk2gtu_xz) * d_Rtd_zz_o0_t2_m0_l0;
					rk2m_Rtd_zz_o0_t1_l0 = (-1.0 * rk2gtu_xy) * d_Rtd_zz_o0_t1_m0_l0;
					rk2m_Rtd_zz_o0_t0_l0 = (-.5 * rk2gtu_xx) * d_Rtd_zz_o0_t0_m0_l0;
					rk2Rtd_zz = ((((((((rk2m_Rtd_zz_o0_t0_l0 + rk2m_Rtd_zz_o0_t1_l0) + rk2m_Rtd_zz_o0_t2_l0) + rk2m_Rtd_zz_o0_t3_l0) + rk2m_Rtd_zz_o0_t4_l0) + rk2m_Rtd_zz_o0_t5_l0) + rk2m_Rtd_zz_o0_t6_l0) + rk2m_Rtd_zz_o0_t7_l0) + rk2m_Rtd_zz_o0_t8_l0) + rk2d_Rtd_zz_o0_t9_m0_l0;
					rk2d_Rtd_xy_o0_t12_m0_l0 = rk2gtu_zz * (rk2Ct_xxz * rk2Ctd_yxz + rk2Ct_xxz * rk2Ctd_xyz + rk2Ct_xyz * rk2Ctd_xxz + 2.0 * rk2Ct_yxz * rk2Ctd_yyz + rk2Ct_yyz * rk2Ctd_xyz + rk2Ct_zxz * rk2Ctd_yzz + rk2Ct_zxz * rk2Ctd_zyz + rk2Ct_zyz * rk2Ctd_xzz) + rk2gtu_yz * (rk2Ct_xxy * rk2Ctd_yxz + rk2Ct_xxy * rk2Ctd_xyz + rk2Ct_xyy * rk2Ctd_xxz + 2.0 * rk2Ct_yxy * rk2Ctd_yyz + rk2Ct_yyy * rk2Ctd_xyz + rk2Ct_zxy * rk2Ctd_yzz + rk2Ct_zxy * rk2Ctd_zyz + rk2Ct_zyy * rk2Ctd_xzz) + rk2gtu_xz * (rk2Ct_xxx * rk2Ctd_yxz + rk2Ct_xxx * rk2Ctd_xyz + rk2Ct_xxy * rk2Ctd_xxz + 2.0 * rk2Ct_yxx * rk2Ctd_yyz + rk2Ct_yxy * rk2Ctd_xyz + rk2Ct_zxx * rk2Ctd_yzz + rk2Ct_zxx * rk2Ctd_zyz + rk2Ct_zxy * rk2Ctd_xzz) + rk2gtu_yz * (rk2Ct_xxz * rk2Ctd_yxy + rk2Ct_xxz * rk2Ctd_xyy + rk2Ct_xyz * rk2Ctd_xxy + 2.0 * rk2Ct_yxz * rk2Ctd_yyy + rk2Ct_yyz * rk2Ctd_xyy + rk2Ct_zxz * rk2Ctd_yyz + rk2Ct_zxz * rk2Ctd_zyy + rk2Ct_zyz * rk2Ctd_xyz) + rk2gtu_yy * (rk2Ct_xxy * rk2Ctd_yxy + rk2Ct_xxy * rk2Ctd_xyy + rk2Ct_xyy * rk2Ctd_xxy + 2.0 * rk2Ct_yxy * rk2Ctd_yyy + rk2Ct_yyy * rk2Ctd_xyy + rk2Ct_zxy * rk2Ctd_yyz + rk2Ct_zxy * rk2Ctd_zyy + rk2Ct_zyy * rk2Ctd_xyz) + rk2gtu_xy * (rk2Ct_xxx * rk2Ctd_yxy + rk2Ct_xxx * rk2Ctd_xyy + rk2Ct_xxy * rk2Ctd_xxy + 2.0 * rk2Ct_yxx * rk2Ctd_yyy + rk2Ct_yxy * rk2Ctd_xyy + rk2Ct_zxx * rk2Ctd_yyz + rk2Ct_zxx * rk2Ctd_zyy + rk2Ct_zxy * rk2Ctd_xyz) + rk2gtu_xz * (rk2Ct_xxz * rk2Ctd_yxx + rk2Ct_xxz * rk2Ctd_xxy + rk2Ct_xyz * rk2Ctd_xxx + 2.0 * rk2Ct_yxz * rk2Ctd_yxy + rk2Ct_yyz * rk2Ctd_xxy + rk2Ct_zxz * rk2Ctd_yxz + rk2Ct_zxz * rk2Ctd_zxy + rk2Ct_zyz * rk2Ctd_xxz) + rk2gtu_xy * (rk2Ct_xxy * rk2Ctd_yxx + rk2Ct_xxy * rk2Ctd_xxy + rk2Ct_xyy * rk2Ctd_xxx + 2.0 * rk2Ct_yxy * rk2Ctd_yxy + rk2Ct_yyy * rk2Ctd_xxy + rk2Ct_zxy * rk2Ctd_yxz + rk2Ct_zxy * rk2Ctd_zxy + rk2Ct_zyy * rk2Ctd_xxz) + rk2gtu_xx * (rk2Ct_xxx * rk2Ctd_yxx + rk2Ct_xxx * rk2Ctd_xxy + rk2Ct_xxy * rk2Ctd_xxx + 2.0 * rk2Ct_yxx * rk2Ctd_yxy + rk2Ct_yxy * rk2Ctd_xxy + rk2Ct_zxx * rk2Ctd_yxz + rk2Ct_zxx * rk2Ctd_zxy + rk2Ct_zxy * rk2Ctd_xxz) + .5 * rk2(i, j, k, Gamh_z) * (rk2Ctd_xyz + rk2Ctd_yxz) + .5 * rk2(i, j, k, Gamh_y) * (rk2Ctd_xyy + rk2Ctd_yxy) + .5 * rk2(i, j, k, Gamh_x) * (rk2Ctd_xxy + rk2Ctd_yxx);
					rk2m_Rtd_xy_o0_t11_l0 = .5 * rk2(i, j, k, gtd_yz) * d_Rtd_xx_o0_t8_m0_l0;
					rk2m_Rtd_xy_o0_t10_l0 = .5 * rk2(i, j, k, gtd_yy) * d_Rtd_xx_o0_t7_m0_l0;
					rk2m_Rtd_xy_o0_t9_l0 = .5 * rk2(i, j, k, gtd_xy) * d_Rtd_xx_o0_t6_m0_l0;
					rk2m_Rtd_xy_o0_t8_l0 = .5 * rk2(i, j, k, gtd_xz) * d_Rtd_xy_o0_t8_m0_l0;
					rk2m_Rtd_xy_o0_t7_l0 = .5 * rk2(i, j, k, gtd_xy) * d_Rtd_xy_o0_t7_m0_l0;
					rk2m_Rtd_xy_o0_t6_l0 = .5 * rk2(i, j, k, gtd_xx) * d_Rtd_xy_o0_t6_m0_l0;
					rk2m_Rtd_xy_o0_t5_l0 = (-.5 * rk2gtu_zz) * d_Rtd_xy_o0_t5_m0_l0;
					rk2m_Rtd_xy_o0_t4_l0 = (-1.0 * rk2gtu_yz) * d_Rtd_xy_o0_t4_m0_l0;
					rk2m_Rtd_xy_o0_t3_l0 = (-.5 * rk2gtu_yy) * d_Rtd_xy_o0_t3_m0_l0;
					rk2m_Rtd_xy_o0_t2_l0 = (-1.0 * rk2gtu_xz) * d_Rtd_xy_o0_t2_m0_l0;
					rk2m_Rtd_xy_o0_t1_l0 = (-1.0 * rk2gtu_xy) * d_Rtd_xy_o0_t1_m0_l0;
					rk2m_Rtd_xy_o0_t0_l0 = (-.5 * rk2gtu_xx) * d_Rtd_xy_o0_t0_m0_l0;
					rk2Rtd_xy = (((((((((((rk2m_Rtd_xy_o0_t0_l0 + rk2m_Rtd_xy_o0_t1_l0) + rk2m_Rtd_xy_o0_t2_l0) + rk2m_Rtd_xy_o0_t3_l0) + rk2m_Rtd_xy_o0_t4_l0) + rk2m_Rtd_xy_o0_t5_l0) + rk2m_Rtd_xy_o0_t6_l0) + rk2m_Rtd_xy_o0_t7_l0) + rk2m_Rtd_xy_o0_t8_l0) + rk2m_Rtd_xy_o0_t9_l0) + rk2m_Rtd_xy_o0_t10_l0) + rk2m_Rtd_xy_o0_t11_l0) + rk2d_Rtd_xy_o0_t12_m0_l0;
					rk2d_Rtd_yy_o0_t9_m0_l0 = rk2gtu_zz * (2.0 * rk2Ct_xyz * rk2Ctd_yxz + rk2Ct_xyz * rk2Ctd_xyz + 3.0 * rk2Ct_yyz * rk2Ctd_yyz + 2.0 * rk2Ct_zyz * rk2Ctd_yzz + rk2Ct_zyz * rk2Ctd_zyz) + rk2gtu_yz * (2.0 * rk2Ct_xyy * rk2Ctd_yxz + rk2Ct_xyy * rk2Ctd_xyz + 3.0 * rk2Ct_yyy * rk2Ctd_yyz + 2.0 * rk2Ct_zyy * rk2Ctd_yzz + rk2Ct_zyy * rk2Ctd_zyz) + rk2gtu_xz * (2.0 * rk2Ct_xxy * rk2Ctd_yxz + rk2Ct_xxy * rk2Ctd_xyz + 3.0 * rk2Ct_yxy * rk2Ctd_yyz + 2.0 * rk2Ct_zxy * rk2Ctd_yzz + rk2Ct_zxy * rk2Ctd_zyz) + rk2gtu_yz * (2.0 * rk2Ct_xyz * rk2Ctd_yxy + rk2Ct_xyz * rk2Ctd_xyy + 3.0 * rk2Ct_yyz * rk2Ctd_yyy + 2.0 * rk2Ct_zyz * rk2Ctd_yyz + rk2Ct_zyz * rk2Ctd_zyy) + rk2gtu_yy * (2.0 * rk2Ct_xyy * rk2Ctd_yxy + rk2Ct_xyy * rk2Ctd_xyy + 3.0 * rk2Ct_yyy * rk2Ctd_yyy + 2.0 * rk2Ct_zyy * rk2Ctd_yyz + rk2Ct_zyy * rk2Ctd_zyy) + rk2gtu_xy * (2.0 * rk2Ct_xxy * rk2Ctd_yxy + rk2Ct_xxy * rk2Ctd_xyy + 3.0 * rk2Ct_yxy * rk2Ctd_yyy + 2.0 * rk2Ct_zxy * rk2Ctd_yyz + rk2Ct_zxy * rk2Ctd_zyy) + rk2gtu_xz * (2.0 * rk2Ct_xyz * rk2Ctd_yxx + rk2Ct_xyz * rk2Ctd_xxy + 3.0 * rk2Ct_yyz * rk2Ctd_yxy + 2.0 * rk2Ct_zyz * rk2Ctd_yxz + rk2Ct_zyz * rk2Ctd_zxy) + rk2gtu_xy * (2.0 * rk2Ct_xyy * rk2Ctd_yxx + rk2Ct_xyy * rk2Ctd_xxy + 3.0 * rk2Ct_yyy * rk2Ctd_yxy + 2.0 * rk2Ct_zyy * rk2Ctd_yxz + rk2Ct_zyy * rk2Ctd_zxy) + rk2gtu_xx * (2.0 * rk2Ct_xxy * rk2Ctd_yxx + rk2Ct_xxy * rk2Ctd_xxy + 3.0 * rk2Ct_yxy * rk2Ctd_yxy + 2.0 * rk2Ct_zxy * rk2Ctd_yxz + rk2Ct_zxy * rk2Ctd_zxy) + 1.0 * rk2(i, j, k, Gamh_z) * rk2Ctd_yyz + 1.0 * rk2(i, j, k, Gamh_y) * rk2Ctd_yyy + 1.0 * rk2(i, j, k, Gamh_x) * rk2Ctd_yxy;
					rk2m_Rtd_yy_o0_t8_l0 = 1.0 * rk2(i, j, k, gtd_yz) * d_Rtd_xy_o0_t8_m0_l0;
					rk2m_Rtd_yy_o0_t7_l0 = 1.0 * rk2(i, j, k, gtd_yy) * d_Rtd_xy_o0_t7_m0_l0;
					rk2m_Rtd_yy_o0_t6_l0 = 1.0 * rk2(i, j, k, gtd_xy) * d_Rtd_xy_o0_t6_m0_l0;
					rk2m_Rtd_yy_o0_t5_l0 = (-.5 * rk2gtu_zz) * d_Rtd_yy_o0_t5_m0_l0;
					rk2m_Rtd_yy_o0_t4_l0 = (-1.0 * rk2gtu_yz) * d_Rtd_yy_o0_t4_m0_l0;
					rk2m_Rtd_yy_o0_t3_l0 = (-.5 * rk2gtu_yy) * d_Rtd_yy_o0_t3_m0_l0;
					rk2m_Rtd_yy_o0_t2_l0 = (-1.0 * rk2gtu_xz) * d_Rtd_yy_o0_t2_m0_l0;
					rk2m_Rtd_yy_o0_t1_l0 = (-1.0 * rk2gtu_xy) * d_Rtd_yy_o0_t1_m0_l0;
					rk2m_Rtd_yy_o0_t0_l0 = (-.5 * rk2gtu_xx) * d_Rtd_yy_o0_t0_m0_l0;
					rk2Rtd_yy = ((((((((rk2m_Rtd_yy_o0_t0_l0 + rk2m_Rtd_yy_o0_t1_l0) + rk2m_Rtd_yy_o0_t2_l0) + rk2m_Rtd_yy_o0_t3_l0) + rk2m_Rtd_yy_o0_t4_l0) + rk2m_Rtd_yy_o0_t5_l0) + rk2m_Rtd_yy_o0_t6_l0) + rk2m_Rtd_yy_o0_t7_l0) + rk2m_Rtd_yy_o0_t8_l0) + rk2d_Rtd_yy_o0_t9_m0_l0;
					rk2d_Rtd_yz_o0_t12_m0_l0 = rk2gtu_zz * (rk2Ct_xyz * rk2Ctd_zxz + rk2Ct_xyz * rk2Ctd_xzz + rk2Ct_xzz * rk2Ctd_yxz + rk2Ct_yyz * rk2Ctd_zyz + rk2Ct_yyz * rk2Ctd_yzz + rk2Ct_yzz * rk2Ctd_yyz + 2.0 * rk2Ct_zyz * rk2Ctd_zzz + rk2Ct_zzz * rk2Ctd_yzz) + rk2gtu_yz * (rk2Ct_xyy * rk2Ctd_zxz + rk2Ct_xyy * rk2Ctd_xzz + rk2Ct_xyz * rk2Ctd_yxz + rk2Ct_yyy * rk2Ctd_zyz + rk2Ct_yyy * rk2Ctd_yzz + rk2Ct_yyz * rk2Ctd_yyz + 2.0 * rk2Ct_zyy * rk2Ctd_zzz + rk2Ct_zyz * rk2Ctd_yzz) + rk2gtu_xz * (rk2Ct_xxy * rk2Ctd_zxz + rk2Ct_xxy * rk2Ctd_xzz + rk2Ct_xxz * rk2Ctd_yxz + rk2Ct_yxy * rk2Ctd_zyz + rk2Ct_yxy * rk2Ctd_yzz + rk2Ct_yxz * rk2Ctd_yyz + 2.0 * rk2Ct_zxy * rk2Ctd_zzz + rk2Ct_zxz * rk2Ctd_yzz) + rk2gtu_yz * (rk2Ct_xyz * rk2Ctd_zxy + rk2Ct_xyz * rk2Ctd_xyz + rk2Ct_xzz * rk2Ctd_yxy + rk2Ct_yyz * rk2Ctd_zyy + rk2Ct_yyz * rk2Ctd_yyz + rk2Ct_yzz * rk2Ctd_yyy + 2.0 * rk2Ct_zyz * rk2Ctd_zyz + rk2Ct_zzz * rk2Ctd_yyz) + rk2gtu_yy * (rk2Ct_xyy * rk2Ctd_zxy + rk2Ct_xyy * rk2Ctd_xyz + rk2Ct_xyz * rk2Ctd_yxy + rk2Ct_yyy * rk2Ctd_zyy + rk2Ct_yyy * rk2Ctd_yyz + rk2Ct_yyz * rk2Ctd_yyy + 2.0 * rk2Ct_zyy * rk2Ctd_zyz + rk2Ct_zyz * rk2Ctd_yyz) + rk2gtu_xy * (rk2Ct_xxy * rk2Ctd_zxy + rk2Ct_xxy * rk2Ctd_xyz + rk2Ct_xxz * rk2Ctd_yxy + rk2Ct_yxy * rk2Ctd_zyy + rk2Ct_yxy * rk2Ctd_yyz + rk2Ct_yxz * rk2Ctd_yyy + 2.0 * rk2Ct_zxy * rk2Ctd_zyz + rk2Ct_zxz * rk2Ctd_yyz) + rk2gtu_xz * (rk2Ct_xyz * rk2Ctd_zxx + rk2Ct_xyz * rk2Ctd_xxz + rk2Ct_xzz * rk2Ctd_yxx + rk2Ct_yyz * rk2Ctd_zxy + rk2Ct_yyz * rk2Ctd_yxz + rk2Ct_yzz * rk2Ctd_yxy + 2.0 * rk2Ct_zyz * rk2Ctd_zxz + rk2Ct_zzz * rk2Ctd_yxz) + rk2gtu_xy * (rk2Ct_xyy * rk2Ctd_zxx + rk2Ct_xyy * rk2Ctd_xxz + rk2Ct_xyz * rk2Ctd_yxx + rk2Ct_yyy * rk2Ctd_zxy + rk2Ct_yyy * rk2Ctd_yxz + rk2Ct_yyz * rk2Ctd_yxy + 2.0 * rk2Ct_zyy * rk2Ctd_zxz + rk2Ct_zyz * rk2Ctd_yxz) + rk2gtu_xx * (rk2Ct_xxy * rk2Ctd_zxx + rk2Ct_xxy * rk2Ctd_xxz + rk2Ct_xxz * rk2Ctd_yxx + rk2Ct_yxy * rk2Ctd_zxy + rk2Ct_yxy * rk2Ctd_yxz + rk2Ct_yxz * rk2Ctd_yxy + 2.0 * rk2Ct_zxy * rk2Ctd_zxz + rk2Ct_zxz * rk2Ctd_yxz) + .5 * rk2(i, j, k, Gamh_z) * (rk2Ctd_yzz + rk2Ctd_zyz) + .5 * rk2(i, j, k, Gamh_y) * (rk2Ctd_yyz + rk2Ctd_zyy) + .5 * rk2(i, j, k, Gamh_x) * (rk2Ctd_yxz + rk2Ctd_zxy);
					rk2m_Rtd_yz_o0_t11_l0 = .5 * rk2(i, j, k, gtd_zz) * d_Rtd_xy_o0_t8_m0_l0;
					rk2m_Rtd_yz_o0_t10_l0 = .5 * rk2(i, j, k, gtd_yz) * d_Rtd_xy_o0_t7_m0_l0;
					rk2m_Rtd_yz_o0_t9_l0 = .5 * rk2(i, j, k, gtd_xz) * d_Rtd_xy_o0_t6_m0_l0;
					rk2m_Rtd_yz_o0_t8_l0 = .5 * rk2(i, j, k, gtd_yz) * d_Rtd_xz_o0_t8_m0_l0;
					rk2m_Rtd_yz_o0_t7_l0 = .5 * rk2(i, j, k, gtd_yy) * d_Rtd_xz_o0_t7_m0_l0;
					rk2m_Rtd_yz_o0_t6_l0 = .5 * rk2(i, j, k, gtd_xy) * d_Rtd_xz_o0_t6_m0_l0;
					rk2m_Rtd_yz_o0_t5_l0 = (-.5 * rk2gtu_zz) * d_Rtd_yz_o0_t5_m0_l0;
					rk2m_Rtd_yz_o0_t4_l0 = (-1.0 * rk2gtu_yz) * d_Rtd_yz_o0_t4_m0_l0;
					rk2m_Rtd_yz_o0_t3_l0 = (-.5 * rk2gtu_yy) * d_Rtd_yz_o0_t3_m0_l0;
					rk2m_Rtd_yz_o0_t2_l0 = (-1.0 * rk2gtu_xz) * d_Rtd_yz_o0_t2_m0_l0;
					rk2m_Rtd_yz_o0_t1_l0 = (-1.0 * rk2gtu_xy) * d_Rtd_yz_o0_t1_m0_l0;
					rk2m_Rtd_yz_o0_t0_l0 = (-.5 * rk2gtu_xx) * d_Rtd_yz_o0_t0_m0_l0;
					rk2Rtd_yz = (((((((((((rk2m_Rtd_yz_o0_t0_l0 + rk2m_Rtd_yz_o0_t1_l0) + rk2m_Rtd_yz_o0_t2_l0) + rk2m_Rtd_yz_o0_t3_l0) + rk2m_Rtd_yz_o0_t4_l0) + rk2m_Rtd_yz_o0_t5_l0) + rk2m_Rtd_yz_o0_t6_l0) + rk2m_Rtd_yz_o0_t7_l0) + rk2m_Rtd_yz_o0_t8_l0) + rk2m_Rtd_yz_o0_t9_l0) + rk2m_Rtd_yz_o0_t10_l0) + rk2m_Rtd_yz_o0_t11_l0) + rk2d_Rtd_yz_o0_t12_m0_l0;
					rk2m_Rpd_xx_o0_t22_l0 = .5 * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_xx_o0_t21_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xx) * rk2gtu_zz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xx_o0_t20_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xx) * rk2gtu_yy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xx_o0_t19_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xx) * rk2gtu_xx * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t18_l0 = 2.0 * rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_xz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t17_l0 = 2.0 * rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_xy) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t16_l0 = 2.0 * rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xx) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t15_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xx) * rk2gtu_yz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xx_o0_t14_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xx) * rk2gtu_xz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t13_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xx) * rk2gtu_xy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t12_l0 = (-.2500000000000000 * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t11_l0 = (-.5 * rk2Ct_zxx) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xx_o0_t10_l0 = (-.5 * rk2Ct_yxx) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xx_o0_t9_l0 = (-.5 * rk2Ct_xxx) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xx_o0_t8_l0 = .5 * rk2(i, j, k, gtd_xx) * rk2gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_xx_o0_t7_l0 = 1.0 * rk2(i, j, k, gtd_xx) * rk2gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_xx_o0_t6_l0 = .5 * rk2(i, j, k, gtd_xx) * rk2gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_xx_o0_t5_l0 = 1.0 * rk2(i, j, k, gtd_xx) * rk2gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_xx_o0_t4_l0 = 1.0 * rk2(i, j, k, gtd_xx) * rk2gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_xx_o0_t3_l0 = .5 * rk2(i, j, k, gtd_xx) * rk2gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_xx_o0_t2_l0 = (-.5 * rk2(i, j, k, gtd_xx) * rk2(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xx_o0_t1_l0 = (-.5 * rk2(i, j, k, gtd_xx) * rk2(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xx_o0_t0_l0 = (-.5 * rk2(i, j, k, gtd_xx) * rk2(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk2Rpd_xx = (((((((((((((((((((((rk2m_Rpd_xx_o0_t0_l0 + rk2m_Rpd_xx_o0_t1_l0) + rk2m_Rpd_xx_o0_t2_l0) + rk2m_Rpd_xx_o0_t3_l0) + rk2m_Rpd_xx_o0_t4_l0) + rk2m_Rpd_xx_o0_t5_l0) + rk2m_Rpd_xx_o0_t6_l0) + rk2m_Rpd_xx_o0_t7_l0) + rk2m_Rpd_xx_o0_t8_l0) + rk2m_Rpd_xx_o0_t9_l0) + rk2m_Rpd_xx_o0_t10_l0) + rk2m_Rpd_xx_o0_t11_l0) + rk2m_Rpd_xx_o0_t12_l0) + rk2m_Rpd_xx_o0_t13_l0) + rk2m_Rpd_xx_o0_t14_l0) + rk2m_Rpd_xx_o0_t15_l0) + rk2m_Rpd_xx_o0_t16_l0) + rk2m_Rpd_xx_o0_t17_l0) + rk2m_Rpd_xx_o0_t18_l0) + rk2m_Rpd_xx_o0_t19_l0) + rk2m_Rpd_xx_o0_t20_l0) + rk2m_Rpd_xx_o0_t21_l0) + rk2m_Rpd_xx_o0_t22_l0;
					rk2m_Rpd_yy_o0_t22_l0 = .5 * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_yy_o0_t21_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_yy) * rk2gtu_zz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yy_o0_t20_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_yy) * rk2gtu_yy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t19_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_yy) * rk2gtu_xx * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yy_o0_t18_l0 = 2.0 * rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_yz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t17_l0 = 2.0 * rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_yy) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t16_l0 = 2.0 * rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xy) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t15_l0 = .5 * rk2(i, j, k, gtd_yy) * rk2gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_yy_o0_t14_l0 = 1.0 * rk2(i, j, k, gtd_yy) * rk2gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_yy_o0_t13_l0 = .5 * rk2(i, j, k, gtd_yy) * rk2gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_yy_o0_t12_l0 = 1.0 * rk2(i, j, k, gtd_yy) * rk2gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_yy_o0_t11_l0 = 1.0 * rk2(i, j, k, gtd_yy) * rk2gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_yy_o0_t10_l0 = .5 * rk2(i, j, k, gtd_yy) * rk2gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_yy_o0_t9_l0 = (-.5 * rk2(i, j, k, gtd_yy) * rk2(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yy_o0_t8_l0 = (-.5 * rk2(i, j, k, gtd_yy) * rk2(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t7_l0 = (-.5 * rk2(i, j, k, gtd_yy) * rk2(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yy_o0_t6_l0 = (-.2500000000000000 * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t5_l0 = (-.5 * rk2Ct_zyy) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yy_o0_t4_l0 = (-.5 * rk2Ct_yyy) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t3_l0 = (-.5 * rk2Ct_xyy) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yy_o0_t2_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_yy) * rk2gtu_yz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yy_o0_t1_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_yy) * rk2gtu_xz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yy_o0_t0_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_yy) * rk2gtu_xy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2Rpd_yy = (((((((((((((((((((((rk2m_Rpd_yy_o0_t0_l0 + rk2m_Rpd_yy_o0_t1_l0) + rk2m_Rpd_yy_o0_t2_l0) + rk2m_Rpd_yy_o0_t3_l0) + rk2m_Rpd_yy_o0_t4_l0) + rk2m_Rpd_yy_o0_t5_l0) + rk2m_Rpd_yy_o0_t6_l0) + rk2m_Rpd_yy_o0_t7_l0) + rk2m_Rpd_yy_o0_t8_l0) + rk2m_Rpd_yy_o0_t9_l0) + rk2m_Rpd_yy_o0_t10_l0) + rk2m_Rpd_yy_o0_t11_l0) + rk2m_Rpd_yy_o0_t12_l0) + rk2m_Rpd_yy_o0_t13_l0) + rk2m_Rpd_yy_o0_t14_l0) + rk2m_Rpd_yy_o0_t15_l0) + rk2m_Rpd_yy_o0_t16_l0) + rk2m_Rpd_yy_o0_t17_l0) + rk2m_Rpd_yy_o0_t18_l0) + rk2m_Rpd_yy_o0_t19_l0) + rk2m_Rpd_yy_o0_t20_l0) + rk2m_Rpd_yy_o0_t21_l0) + rk2m_Rpd_yy_o0_t22_l0;
					rk2m_Rpd_yz_o0_t25_l0 = .5 * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_yz_o0_t24_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_yz) * rk2gtu_zz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t23_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_yz) * rk2gtu_yy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t22_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_yz) * rk2gtu_xx * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yz_o0_t21_l0 = rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_zz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t20_l0 = rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_yz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t19_l0 = rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t18_l0 = rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_yz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t17_l0 = rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_yy) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t16_l0 = rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xy) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t15_l0 = (-.2500000000000000 * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t14_l0 = .5 * rk2(i, j, k, gtd_yz) * rk2gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_yz_o0_t13_l0 = 1.0 * rk2(i, j, k, gtd_yz) * rk2gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_yz_o0_t12_l0 = .5 * rk2(i, j, k, gtd_yz) * rk2gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_yz_o0_t11_l0 = 1.0 * rk2(i, j, k, gtd_yz) * rk2gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_yz_o0_t10_l0 = 1.0 * rk2(i, j, k, gtd_yz) * rk2gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_yz_o0_t9_l0 = .5 * rk2(i, j, k, gtd_yz) * rk2gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_yz_o0_t8_l0 = (-.5 * rk2(i, j, k, gtd_yz) * rk2(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t7_l0 = (-.5 * rk2(i, j, k, gtd_yz) * rk2(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t6_l0 = (-.5 * rk2(i, j, k, gtd_yz) * rk2(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yz_o0_t5_l0 = (-.5 * rk2Ct_zyz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_yz_o0_t4_l0 = (-.5 * rk2Ct_yyz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t3_l0 = (-.5 * rk2Ct_xyz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yz_o0_t2_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_yz) * rk2gtu_yz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_yz_o0_t1_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_yz) * rk2gtu_xz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_yz_o0_t0_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_yz) * rk2gtu_xy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2Rpd_yz = ((((((((((((((((((((((((rk2m_Rpd_yz_o0_t0_l0 + rk2m_Rpd_yz_o0_t1_l0) + rk2m_Rpd_yz_o0_t2_l0) + rk2m_Rpd_yz_o0_t3_l0) + rk2m_Rpd_yz_o0_t4_l0) + rk2m_Rpd_yz_o0_t5_l0) + rk2m_Rpd_yz_o0_t6_l0) + rk2m_Rpd_yz_o0_t7_l0) + rk2m_Rpd_yz_o0_t8_l0) + rk2m_Rpd_yz_o0_t9_l0) + rk2m_Rpd_yz_o0_t10_l0) + rk2m_Rpd_yz_o0_t11_l0) + rk2m_Rpd_yz_o0_t12_l0) + rk2m_Rpd_yz_o0_t13_l0) + rk2m_Rpd_yz_o0_t14_l0) + rk2m_Rpd_yz_o0_t15_l0) + rk2m_Rpd_yz_o0_t16_l0) + rk2m_Rpd_yz_o0_t17_l0) + rk2m_Rpd_yz_o0_t18_l0) + rk2m_Rpd_yz_o0_t19_l0) + rk2m_Rpd_yz_o0_t20_l0) + rk2m_Rpd_yz_o0_t21_l0) + rk2m_Rpd_yz_o0_t22_l0) + rk2m_Rpd_yz_o0_t23_l0) + rk2m_Rpd_yz_o0_t24_l0) + rk2m_Rpd_yz_o0_t25_l0;
					rk2m_Rpd_xz_o0_t25_l0 = .5 * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_xz_o0_t24_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xz) * rk2gtu_zz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t23_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xz) * rk2gtu_yy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xz_o0_t22_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xz) * rk2gtu_xx * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t21_l0 = rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_zz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t20_l0 = rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_yz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t19_l0 = rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t18_l0 = rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_xz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t17_l0 = rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_xy) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t16_l0 = rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xx) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t15_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xz) * rk2gtu_xz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t14_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xz) * rk2gtu_xy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t13_l0 = 1.0 * rk2(i, j, k, gtd_xz) * rk2gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_xz_o0_t12_l0 = .5 * rk2(i, j, k, gtd_xz) * rk2gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_xz_o0_t11_l0 = 1.0 * rk2(i, j, k, gtd_xz) * rk2gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_xz_o0_t10_l0 = 1.0 * rk2(i, j, k, gtd_xz) * rk2gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_xz_o0_t9_l0 = .5 * rk2(i, j, k, gtd_xz) * rk2gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_xz_o0_t8_l0 = (-.5 * rk2(i, j, k, gtd_xz) * rk2(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t7_l0 = (-.5 * rk2(i, j, k, gtd_xz) * rk2(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xz_o0_t6_l0 = (-.5 * rk2(i, j, k, gtd_xz) * rk2(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t5_l0 = (-.2500000000000000 * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t4_l0 = .5 * rk2(i, j, k, gtd_xz) * rk2gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_xz_o0_t3_l0 = (-.5 * rk2Ct_zxz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xz_o0_t2_l0 = (-.5 * rk2Ct_yxz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xz_o0_t1_l0 = (-.5 * rk2Ct_xxz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xz_o0_t0_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xz) * rk2gtu_yz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2Rpd_xz = ((((((((((((((((((((((((rk2m_Rpd_xz_o0_t0_l0 + rk2m_Rpd_xz_o0_t1_l0) + rk2m_Rpd_xz_o0_t2_l0) + rk2m_Rpd_xz_o0_t3_l0) + rk2m_Rpd_xz_o0_t4_l0) + rk2m_Rpd_xz_o0_t5_l0) + rk2m_Rpd_xz_o0_t6_l0) + rk2m_Rpd_xz_o0_t7_l0) + rk2m_Rpd_xz_o0_t8_l0) + rk2m_Rpd_xz_o0_t9_l0) + rk2m_Rpd_xz_o0_t10_l0) + rk2m_Rpd_xz_o0_t11_l0) + rk2m_Rpd_xz_o0_t12_l0) + rk2m_Rpd_xz_o0_t13_l0) + rk2m_Rpd_xz_o0_t14_l0) + rk2m_Rpd_xz_o0_t15_l0) + rk2m_Rpd_xz_o0_t16_l0) + rk2m_Rpd_xz_o0_t17_l0) + rk2m_Rpd_xz_o0_t18_l0) + rk2m_Rpd_xz_o0_t19_l0) + rk2m_Rpd_xz_o0_t20_l0) + rk2m_Rpd_xz_o0_t21_l0) + rk2m_Rpd_xz_o0_t22_l0) + rk2m_Rpd_xz_o0_t23_l0) + rk2m_Rpd_xz_o0_t24_l0) + rk2m_Rpd_xz_o0_t25_l0;
					rk2m_Rpd_xy_o0_t25_l0 = .5 * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_xy_o0_t24_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xy) * rk2gtu_zz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xy_o0_t23_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xy) * rk2gtu_yy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t22_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_xy) * rk2gtu_xx * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t21_l0 = rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_yz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t20_l0 = rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_yy) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t19_l0 = rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xy) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t18_l0 = rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_xz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t17_l0 = rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_xy) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t16_l0 = rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xx) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t15_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xy) * rk2gtu_yz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t14_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xy) * rk2gtu_xz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t13_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_xy) * rk2gtu_xy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t12_l0 = (-.2500000000000000 * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t11_l0 = .5 * rk2(i, j, k, gtd_xy) * rk2gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_xy_o0_t10_l0 = 1.0 * rk2(i, j, k, gtd_xy) * rk2gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_xy_o0_t9_l0 = .5 * rk2(i, j, k, gtd_xy) * rk2gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_xy_o0_t8_l0 = 1.0 * rk2(i, j, k, gtd_xy) * rk2gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_xy_o0_t7_l0 = 1.0 * rk2(i, j, k, gtd_xy) * rk2gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_xy_o0_t6_l0 = .5 * rk2(i, j, k, gtd_xy) * rk2gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_xy_o0_t5_l0 = (-.5 * rk2(i, j, k, gtd_xy) * rk2(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xy_o0_t4_l0 = (-.5 * rk2(i, j, k, gtd_xy) * rk2(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t3_l0 = (-.5 * rk2(i, j, k, gtd_xy) * rk2(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_xy_o0_t2_l0 = (-.5 * rk2Ct_zxy) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_xy_o0_t1_l0 = (-.5 * rk2Ct_yxy) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_xy_o0_t0_l0 = (-.5 * rk2Ct_xxy) * d_Rpd_xx_o0_t0_m0_l0;
					rk2Rpd_xy = ((((((((((((((((((((((((rk2m_Rpd_xy_o0_t0_l0 + rk2m_Rpd_xy_o0_t1_l0) + rk2m_Rpd_xy_o0_t2_l0) + rk2m_Rpd_xy_o0_t3_l0) + rk2m_Rpd_xy_o0_t4_l0) + rk2m_Rpd_xy_o0_t5_l0) + rk2m_Rpd_xy_o0_t6_l0) + rk2m_Rpd_xy_o0_t7_l0) + rk2m_Rpd_xy_o0_t8_l0) + rk2m_Rpd_xy_o0_t9_l0) + rk2m_Rpd_xy_o0_t10_l0) + rk2m_Rpd_xy_o0_t11_l0) + rk2m_Rpd_xy_o0_t12_l0) + rk2m_Rpd_xy_o0_t13_l0) + rk2m_Rpd_xy_o0_t14_l0) + rk2m_Rpd_xy_o0_t15_l0) + rk2m_Rpd_xy_o0_t16_l0) + rk2m_Rpd_xy_o0_t17_l0) + rk2m_Rpd_xy_o0_t18_l0) + rk2m_Rpd_xy_o0_t19_l0) + rk2m_Rpd_xy_o0_t20_l0) + rk2m_Rpd_xy_o0_t21_l0) + rk2m_Rpd_xy_o0_t22_l0) + rk2m_Rpd_xy_o0_t23_l0) + rk2m_Rpd_xy_o0_t24_l0) + rk2m_Rpd_xy_o0_t25_l0;
					rk2m_Rpd_zz_o0_t22_l0 = .5 * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_zz_o0_t21_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_zz) * rk2gtu_zz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t20_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_zz) * rk2gtu_yy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_zz_o0_t19_l0 = (-.7500000000000000 * rk2(i, j, k, gtd_zz) * rk2gtu_xx * rk2inv_chi) * d_Rpd_xx_o0_t0_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_zz_o0_t18_l0 = 2.0 * rk2inv_chi * rk2Zu_z * rk2(i, j, k, gtd_zz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t17_l0 = 2.0 * rk2inv_chi * rk2Zu_y * rk2(i, j, k, gtd_yz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t16_l0 = 2.0 * rk2inv_chi * rk2Zu_x * rk2(i, j, k, gtd_xz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t15_l0 = .5 * rk2(i, j, k, gtd_zz) * rk2gtu_zz * d_Rpd_xx_o0_t8_m0_l0;
					rk2m_Rpd_zz_o0_t14_l0 = 1.0 * rk2(i, j, k, gtd_zz) * rk2gtu_yz * d_Rpd_xx_o0_t7_m0_l0;
					rk2m_Rpd_zz_o0_t13_l0 = .5 * rk2(i, j, k, gtd_zz) * rk2gtu_yy * d_Rpd_xx_o0_t6_m0_l0;
					rk2m_Rpd_zz_o0_t12_l0 = 1.0 * rk2(i, j, k, gtd_zz) * rk2gtu_xz * d_Rpd_xx_o0_t5_m0_l0;
					rk2m_Rpd_zz_o0_t11_l0 = 1.0 * rk2(i, j, k, gtd_zz) * rk2gtu_xy * d_Rpd_xx_o0_t4_m0_l0;
					rk2m_Rpd_zz_o0_t10_l0 = .5 * rk2(i, j, k, gtd_zz) * rk2gtu_xx * d_Rpd_xx_o0_t3_m0_l0;
					rk2m_Rpd_zz_o0_t9_l0 = (-.5 * rk2(i, j, k, gtd_zz) * rk2(i, j, k, Gamh_z)) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t8_l0 = (-.5 * rk2(i, j, k, gtd_zz) * rk2(i, j, k, Gamh_y)) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_zz_o0_t7_l0 = (-.5 * rk2(i, j, k, gtd_zz) * rk2(i, j, k, Gamh_x)) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_zz_o0_t6_l0 = (-.2500000000000000 * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t5_l0 = (-.5 * rk2Ct_zzz) * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Rpd_zz_o0_t4_l0 = (-.5 * rk2Ct_yzz) * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_zz_o0_t3_l0 = (-.5 * rk2Ct_xzz) * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_zz_o0_t2_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_zz) * rk2gtu_yz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Rpd_zz_o0_t1_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_zz) * rk2gtu_xz * rk2inv_chi) * d_Rpd_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Rpd_zz_o0_t0_l0 = (-1.500000000000000 * rk2(i, j, k, gtd_zz) * rk2gtu_xy * rk2inv_chi) * d_Rpd_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2Rpd_zz = (((((((((((((((((((((rk2m_Rpd_zz_o0_t0_l0 + rk2m_Rpd_zz_o0_t1_l0) + rk2m_Rpd_zz_o0_t2_l0) + rk2m_Rpd_zz_o0_t3_l0) + rk2m_Rpd_zz_o0_t4_l0) + rk2m_Rpd_zz_o0_t5_l0) + rk2m_Rpd_zz_o0_t6_l0) + rk2m_Rpd_zz_o0_t7_l0) + rk2m_Rpd_zz_o0_t8_l0) + rk2m_Rpd_zz_o0_t9_l0) + rk2m_Rpd_zz_o0_t10_l0) + rk2m_Rpd_zz_o0_t11_l0) + rk2m_Rpd_zz_o0_t12_l0) + rk2m_Rpd_zz_o0_t13_l0) + rk2m_Rpd_zz_o0_t14_l0) + rk2m_Rpd_zz_o0_t15_l0) + rk2m_Rpd_zz_o0_t16_l0) + rk2m_Rpd_zz_o0_t17_l0) + rk2m_Rpd_zz_o0_t18_l0) + rk2m_Rpd_zz_o0_t19_l0) + rk2m_Rpd_zz_o0_t20_l0) + rk2m_Rpd_zz_o0_t21_l0) + rk2m_Rpd_zz_o0_t22_l0;
					rk2Rscalar = (rk2chi_max * rk2Rtd_xx + rk2Rpd_xx) * rk2gtu_xx + 2.0 * (rk2chi_max * rk2Rtd_xy + rk2Rpd_xy) * rk2gtu_xy + 2.0 * (rk2chi_max * rk2Rtd_xz + rk2Rpd_xz) * rk2gtu_xz + (rk2chi_max * rk2Rtd_yy + rk2Rpd_yy) * rk2gtu_yy + 2.0 * (rk2chi_max * rk2Rtd_yz + rk2Rpd_yz) * rk2gtu_yz + (rk2chi_max * rk2Rtd_zz + rk2Rpd_zz) * rk2gtu_zz;
					rk2d_d_pheI4d_t_o0_t0_m0_l0 = -rk2(i, j, k, Alpha) * rk2(i, j, k, peI);
					rk2m_d_pheI4d_t_o0_t6_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_d_pheI4d_t_o0_t3_m0_l0;
					rk2m_d_pheI4d_t_o0_t5_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_d_pheI4d_t_o0_t2_m0_l0;
					rk2m_d_pheI4d_t_o0_t4_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_d_pheI4d_t_o0_t1_m0_l0;
					rk2m_d_pheI4d_t_o0_t3_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_d_pheI4d_t_o0_t3_m0_l0;
					rk2m_d_pheI4d_t_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_d_pheI4d_t_o0_t2_m0_l0;
					rk2m_d_pheI4d_t_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_d_pheI4d_t_o0_t1_m0_l0;
					rk2d_pheI4d_t = (((((rk2d_d_pheI4d_t_o0_t0_m0_l0 + rk2m_d_pheI4d_t_o0_t1_l0) + rk2m_d_pheI4d_t_o0_t2_l0) + rk2m_d_pheI4d_t_o0_t3_l0) + rk2m_d_pheI4d_t_o0_t4_l0) + rk2m_d_pheI4d_t_o0_t5_l0) + rk2m_d_pheI4d_t_o0_t6_l0;
					rk2d_pheI4d_z = d_d_pheI4d_t_o0_t3_m0_l0;
					rk2d_pheI4d_y = d_d_pheI4d_t_o0_t2_m0_l0;
					rk2d_pheI4d_x = d_d_pheI4d_t_o0_t1_m0_l0;
					rk2d_pheI4u_t = rk2g4u_tt * rk2d_pheI4d_t + rk2g4u_tx * rk2d_pheI4d_x + rk2g4u_ty * rk2d_pheI4d_y + rk2g4u_tz * rk2d_pheI4d_z;
					rk2d_pheI4u_z = rk2g4u_tz * rk2d_pheI4d_t + rk2g4u_xz * rk2d_pheI4d_x + rk2g4u_yz * rk2d_pheI4d_y + rk2g4u_zz * rk2d_pheI4d_z;
					rk2d_pheI4u_y = rk2g4u_ty * rk2d_pheI4d_t + rk2g4u_xy * rk2d_pheI4d_x + rk2g4u_yy * rk2d_pheI4d_y + rk2g4u_yz * rk2d_pheI4d_z;
					rk2d_pheI4u_x = rk2g4u_tx * rk2d_pheI4d_t + rk2g4u_xx * rk2d_pheI4d_x + rk2g4u_xy * rk2d_pheI4d_y + rk2g4u_xz * rk2d_pheI4d_z;
					rk2dphe4sq = rk2d_pheR4u_t * rk2d_pheR4d_t + rk2d_pheR4u_x * rk2d_pheR4d_x + rk2d_pheR4u_y * rk2d_pheR4d_y + rk2d_pheR4u_z * rk2d_pheR4d_z + rk2d_pheI4u_t * rk2d_pheI4d_t + rk2d_pheI4u_x * rk2d_pheI4d_x + rk2d_pheI4u_y * rk2d_pheI4d_y + rk2d_pheI4u_z * rk2d_pheI4d_z;
					rk2Tsfu_zz = 2.0 * (rk2d_phiR4u_z * rk2d_phiR4u_z) + 2.0 * (rk2d_phiI4u_z * rk2d_phiI4u_z) + (-rk2g4u_zz * (rk2dphi4sq + rk2sfVi)) + 2.0 * (rk2d_pheR4u_z * rk2d_pheR4u_z) + 2.0 * (rk2d_pheI4u_z * rk2d_pheI4u_z) + (-rk2g4u_zz * (rk2dphe4sq + rk2sfVe));
					rk2Tu_zz = rk2Tsfu_zz;
					rk2Tsfu_yz = 2.0 * rk2d_phiR4u_y * rk2d_phiR4u_z + 2.0 * rk2d_phiI4u_y * rk2d_phiI4u_z + (-rk2g4u_yz * (rk2dphi4sq + rk2sfVi)) + 2.0 * rk2d_pheR4u_y * rk2d_pheR4u_z + 2.0 * rk2d_pheI4u_y * rk2d_pheI4u_z + (-rk2g4u_yz * (rk2dphe4sq + rk2sfVe));
					rk2Tu_yz = rk2Tsfu_yz;
					rk2Tsfu_yy = 2.0 * (rk2d_phiR4u_y * rk2d_phiR4u_y) + 2.0 * (rk2d_phiI4u_y * rk2d_phiI4u_y) + (-rk2g4u_yy * (rk2dphi4sq + rk2sfVi)) + 2.0 * (rk2d_pheR4u_y * rk2d_pheR4u_y) + 2.0 * (rk2d_pheI4u_y * rk2d_pheI4u_y) + (-rk2g4u_yy * (rk2dphe4sq + rk2sfVe));
					rk2Tu_yy = rk2Tsfu_yy;
					rk2Tsfu_xz = 2.0 * rk2d_phiR4u_x * rk2d_phiR4u_z + 2.0 * rk2d_phiI4u_x * rk2d_phiI4u_z + (-rk2g4u_xz * (rk2dphi4sq + rk2sfVi)) + 2.0 * rk2d_pheR4u_x * rk2d_pheR4u_z + 2.0 * rk2d_pheI4u_x * rk2d_pheI4u_z + (-rk2g4u_xz * (rk2dphe4sq + rk2sfVe));
					rk2Tu_xz = rk2Tsfu_xz;
					rk2Tsfu_xy = 2.0 * rk2d_phiR4u_x * rk2d_phiR4u_y + 2.0 * rk2d_phiI4u_x * rk2d_phiI4u_y + (-rk2g4u_xy * (rk2dphi4sq + rk2sfVi)) + 2.0 * rk2d_pheR4u_x * rk2d_pheR4u_y + 2.0 * rk2d_pheI4u_x * rk2d_pheI4u_y + (-rk2g4u_xy * (rk2dphe4sq + rk2sfVe));
					rk2Tu_xy = rk2Tsfu_xy;
					rk2Tsfu_xx = 2.0 * (rk2d_phiR4u_x * rk2d_phiR4u_x) + 2.0 * (rk2d_phiI4u_x * rk2d_phiI4u_x) + (-rk2g4u_xx * (rk2dphi4sq + rk2sfVi)) + 2.0 * (rk2d_pheR4u_x * rk2d_pheR4u_x) + 2.0 * (rk2d_pheI4u_x * rk2d_pheI4u_x) + (-rk2g4u_xx * (rk2dphe4sq + rk2sfVe));
					rk2Tu_xx = rk2Tsfu_xx;
					rk2Tsfu_tt = 2.0 * (rk2d_phiR4u_t * rk2d_phiR4u_t) + 2.0 * (rk2d_phiI4u_t * rk2d_phiI4u_t) + (-rk2g4u_tt * (rk2dphi4sq + rk2sfVi)) + 2.0 * (rk2d_pheR4u_t * rk2d_pheR4u_t) + 2.0 * (rk2d_pheI4u_t * rk2d_pheI4u_t) + (-rk2g4u_tt * (rk2dphe4sq + rk2sfVe));
					rk2Tu_tt = rk2Tsfu_tt;
					rk2Tsfu_tz = 2.0 * rk2d_phiR4u_t * rk2d_phiR4u_z + 2.0 * rk2d_phiI4u_t * rk2d_phiI4u_z + (-rk2g4u_tz * (rk2dphi4sq + rk2sfVi)) + 2.0 * rk2d_pheR4u_t * rk2d_pheR4u_z + 2.0 * rk2d_pheI4u_t * rk2d_pheI4u_z + (-rk2g4u_tz * (rk2dphe4sq + rk2sfVe));
					rk2Tu_tz = rk2Tsfu_tz;
					rk2Tsfu_ty = 2.0 * rk2d_phiR4u_t * rk2d_phiR4u_y + 2.0 * rk2d_phiI4u_t * rk2d_phiI4u_y + (-rk2g4u_ty * (rk2dphi4sq + rk2sfVi)) + 2.0 * rk2d_pheR4u_t * rk2d_pheR4u_y + 2.0 * rk2d_pheI4u_t * rk2d_pheI4u_y + (-rk2g4u_ty * (rk2dphe4sq + rk2sfVe));
					rk2Tu_ty = rk2Tsfu_ty;
					rk2Tsfu_tx = 2.0 * rk2d_phiR4u_t * rk2d_phiR4u_x + 2.0 * rk2d_phiI4u_t * rk2d_phiI4u_x + (-rk2g4u_tx * (rk2dphi4sq + rk2sfVi)) + 2.0 * rk2d_pheR4u_t * rk2d_pheR4u_x + 2.0 * rk2d_pheI4u_t * rk2d_pheI4u_x + (-rk2g4u_tx * (rk2dphe4sq + rk2sfVe));
					rk2Tu_tx = rk2Tsfu_tx;
					rk2pTtd_ADM_xz = rk2Betatd_x * rk2Betatd_z * rk2Tu_tt + rk2Betatd_x * (rk2(i, j, k, gtd_xz) * rk2Tu_tx + rk2(i, j, k, gtd_yz) * rk2Tu_ty + rk2(i, j, k, gtd_zz) * rk2Tu_tz) + rk2Betatd_z * (rk2(i, j, k, gtd_xx) * rk2Tu_tx + rk2(i, j, k, gtd_xy) * rk2Tu_ty + rk2(i, j, k, gtd_xz) * rk2Tu_tz) + rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_xz) * rk2Tu_xx + rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_yz) * rk2Tu_xy + rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_zz) * rk2Tu_xz + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xz) * rk2Tu_xy + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yz) * rk2Tu_yy + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_zz) * rk2Tu_yz + (rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_xz)) * rk2Tu_xz + rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_yz) * rk2Tu_yz + rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_zz) * rk2Tu_zz;
					rk2pTtd_ADM_xy = rk2Betatd_x * rk2Betatd_y * rk2Tu_tt + rk2Betatd_x * (rk2(i, j, k, gtd_xy) * rk2Tu_tx + rk2(i, j, k, gtd_yy) * rk2Tu_ty + rk2(i, j, k, gtd_yz) * rk2Tu_tz) + rk2Betatd_y * (rk2(i, j, k, gtd_xx) * rk2Tu_tx + rk2(i, j, k, gtd_xy) * rk2Tu_ty + rk2(i, j, k, gtd_xz) * rk2Tu_tz) + rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_xy) * rk2Tu_xx + rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_yy) * rk2Tu_xy + rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_yz) * rk2Tu_xz + (rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xy)) * rk2Tu_xy + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yy) * rk2Tu_yy + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yz) * rk2Tu_yz + rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_xy) * rk2Tu_xz + rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_yy) * rk2Tu_yz + rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_yz) * rk2Tu_zz;
					rk2pTtd_ADM_xx = (rk2Betatd_x * rk2Betatd_x) * rk2Tu_tt + 2.0 * rk2Betatd_x * (rk2(i, j, k, gtd_xx) * rk2Tu_tx + rk2(i, j, k, gtd_xy) * rk2Tu_ty + rk2(i, j, k, gtd_xz) * rk2Tu_tz) + (rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_xx)) * rk2Tu_xx + 2.0 * rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_xy) * rk2Tu_xy + 2.0 * rk2(i, j, k, gtd_xx) * rk2(i, j, k, gtd_xz) * rk2Tu_xz + (rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xy)) * rk2Tu_yy + 2.0 * rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xz) * rk2Tu_yz + (rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_xz)) * rk2Tu_zz;
					rk2d_Psi1_xx_o0_t5_m0_l0 = (-8.0 * M_PI * rk2inv_chi * rk2(i, j, k, Alpha) * rk2pTtd_ADM_xx) + rk2(i, j, k, Alpha) * rk2Rpd_xx + rk2chi_max * rk2(i, j, k, Alpha) * rk2Rtd_xx;
					rk2m_Psi1_xx_o0_t4_l0 = (-1.0 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Psi1_xx_o0_t3_l0 = rk2chi_max * rk2Ct_zxx * d_Psi1_xx_o0_t3_m0_l0;
					rk2m_Psi1_xx_o0_t2_l0 = rk2chi_max * rk2Ct_yxx * d_Psi1_xx_o0_t2_m0_l0;
					rk2m_Psi1_xx_o0_t1_l0 = rk2chi_max * rk2Ct_xxx * d_Psi1_xx_o0_t1_m0_l0;
					rk2m_Psi1_xx_o0_t0_l0 = (-rk2chi_max) * d_Psi1_xx_o0_t0_m0_l0;
					rk2Psi1_xx = ((((rk2m_Psi1_xx_o0_t0_l0 + rk2m_Psi1_xx_o0_t1_l0) + rk2m_Psi1_xx_o0_t2_l0) + rk2m_Psi1_xx_o0_t3_l0) + rk2m_Psi1_xx_o0_t4_l0) + rk2d_Psi1_xx_o0_t5_m0_l0;
					rk2d_Psi1_xy_o0_t6_m0_l0 = (-8.0 * M_PI * rk2inv_chi * rk2(i, j, k, Alpha) * rk2pTtd_ADM_xy) + rk2(i, j, k, Alpha) * rk2Rpd_xy + rk2chi_max * rk2(i, j, k, Alpha) * rk2Rtd_xy;
					rk2m_Psi1_xy_o0_t5_l0 = (-.5 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Psi1_xy_o0_t4_l0 = (-.5 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Psi1_xy_o0_t3_l0 = rk2chi_max * rk2Ct_zxy * d_Psi1_xx_o0_t3_m0_l0;
					rk2m_Psi1_xy_o0_t2_l0 = rk2chi_max * rk2Ct_yxy * d_Psi1_xx_o0_t2_m0_l0;
					rk2m_Psi1_xy_o0_t1_l0 = rk2chi_max * rk2Ct_xxy * d_Psi1_xx_o0_t1_m0_l0;
					rk2m_Psi1_xy_o0_t0_l0 = (-rk2chi_max) * d_Psi1_xy_o0_t0_m0_l0;
					rk2Psi1_xy = (((((rk2m_Psi1_xy_o0_t0_l0 + rk2m_Psi1_xy_o0_t1_l0) + rk2m_Psi1_xy_o0_t2_l0) + rk2m_Psi1_xy_o0_t3_l0) + rk2m_Psi1_xy_o0_t4_l0) + rk2m_Psi1_xy_o0_t5_l0) + rk2d_Psi1_xy_o0_t6_m0_l0;
					rk2d_Psi1_xz_o0_t6_m0_l0 = (-8.0 * M_PI * rk2inv_chi * rk2(i, j, k, Alpha) * rk2pTtd_ADM_xz) + rk2(i, j, k, Alpha) * rk2Rpd_xz + rk2chi_max * rk2(i, j, k, Alpha) * rk2Rtd_xz;
					rk2m_Psi1_xz_o0_t5_l0 = (-.5 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					rk2m_Psi1_xz_o0_t4_l0 = (-.5 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Psi1_xz_o0_t3_l0 = rk2chi_max * rk2Ct_zxz * d_Psi1_xx_o0_t3_m0_l0;
					rk2m_Psi1_xz_o0_t2_l0 = rk2chi_max * rk2Ct_yxz * d_Psi1_xx_o0_t2_m0_l0;
					rk2m_Psi1_xz_o0_t1_l0 = rk2chi_max * rk2Ct_xxz * d_Psi1_xx_o0_t1_m0_l0;
					rk2m_Psi1_xz_o0_t0_l0 = (-rk2chi_max) * d_Psi1_xz_o0_t0_m0_l0;
					rk2Psi1_xz = (((((rk2m_Psi1_xz_o0_t0_l0 + rk2m_Psi1_xz_o0_t1_l0) + rk2m_Psi1_xz_o0_t2_l0) + rk2m_Psi1_xz_o0_t3_l0) + rk2m_Psi1_xz_o0_t4_l0) + rk2m_Psi1_xz_o0_t5_l0) + rk2d_Psi1_xz_o0_t6_m0_l0;
					rk2Jtd_ADM_z = rk2(i, j, k, Alpha) * ((rk2(i, j, k, Betau_x) * rk2Tu_tt + rk2Tu_tx) * rk2(i, j, k, gtd_xz) + (rk2(i, j, k, Betau_y) * rk2Tu_tt + rk2Tu_ty) * rk2(i, j, k, gtd_yz) + (rk2(i, j, k, Betau_z) * rk2Tu_tt + rk2Tu_tz) * rk2(i, j, k, gtd_zz));
					rk2pTtd_ADM_zz = (rk2Betatd_z * rk2Betatd_z) * rk2Tu_tt + 2.0 * rk2Betatd_z * (rk2(i, j, k, gtd_xz) * rk2Tu_tx + rk2(i, j, k, gtd_yz) * rk2Tu_ty + rk2(i, j, k, gtd_zz) * rk2Tu_tz) + (rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_xz)) * rk2Tu_xx + 2.0 * rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_yz) * rk2Tu_xy + 2.0 * rk2(i, j, k, gtd_xz) * rk2(i, j, k, gtd_zz) * rk2Tu_xz + (rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_yz)) * rk2Tu_yy + 2.0 * rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_zz) * rk2Tu_yz + (rk2(i, j, k, gtd_zz) * rk2(i, j, k, gtd_zz)) * rk2Tu_zz;
					rk2d_Psi1_zz_o0_t5_m0_l0 = (-8.0 * M_PI * rk2inv_chi * rk2(i, j, k, Alpha) * rk2pTtd_ADM_zz) + rk2(i, j, k, Alpha) * rk2Rpd_zz + rk2chi_max * rk2(i, j, k, Alpha) * rk2Rtd_zz;
					rk2m_Psi1_zz_o0_t4_l0 = (-1.0 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Psi1_zz_o0_t3_l0 = rk2chi_max * rk2Ct_zzz * d_Psi1_xx_o0_t3_m0_l0;
					rk2m_Psi1_zz_o0_t2_l0 = rk2chi_max * rk2Ct_yzz * d_Psi1_xx_o0_t2_m0_l0;
					rk2m_Psi1_zz_o0_t1_l0 = rk2chi_max * rk2Ct_xzz * d_Psi1_xx_o0_t1_m0_l0;
					rk2m_Psi1_zz_o0_t0_l0 = (-rk2chi_max) * d_Psi1_zz_o0_t0_m0_l0;
					rk2Psi1_zz = ((((rk2m_Psi1_zz_o0_t0_l0 + rk2m_Psi1_zz_o0_t1_l0) + rk2m_Psi1_zz_o0_t2_l0) + rk2m_Psi1_zz_o0_t3_l0) + rk2m_Psi1_zz_o0_t4_l0) + rk2d_Psi1_zz_o0_t5_m0_l0;
					rk2Jtd_ADM_y = rk2(i, j, k, Alpha) * ((rk2(i, j, k, Betau_x) * rk2Tu_tt + rk2Tu_tx) * rk2(i, j, k, gtd_xy) + (rk2(i, j, k, Betau_y) * rk2Tu_tt + rk2Tu_ty) * rk2(i, j, k, gtd_yy) + (rk2(i, j, k, Betau_z) * rk2Tu_tt + rk2Tu_tz) * rk2(i, j, k, gtd_yz));
					rk2Jtd_ADM_x = rk2(i, j, k, Alpha) * ((rk2(i, j, k, Betau_x) * rk2Tu_tt + rk2Tu_tx) * rk2(i, j, k, gtd_xx) + (rk2(i, j, k, Betau_y) * rk2Tu_tt + rk2Tu_ty) * rk2(i, j, k, gtd_xy) + (rk2(i, j, k, Betau_z) * rk2Tu_tt + rk2Tu_tz) * rk2(i, j, k, gtd_xz));
					rk2pTtd_ADM_yz = rk2Betatd_y * rk2Betatd_z * rk2Tu_tt + rk2Betatd_y * (rk2(i, j, k, gtd_xz) * rk2Tu_tx + rk2(i, j, k, gtd_yz) * rk2Tu_ty + rk2(i, j, k, gtd_zz) * rk2Tu_tz) + rk2Betatd_z * (rk2(i, j, k, gtd_xy) * rk2Tu_tx + rk2(i, j, k, gtd_yy) * rk2Tu_ty + rk2(i, j, k, gtd_yz) * rk2Tu_tz) + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xz) * rk2Tu_xx + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yz) * rk2Tu_xy + rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_zz) * rk2Tu_xz + rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_xz) * rk2Tu_xy + rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_yz) * rk2Tu_yy + rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_zz) * rk2Tu_yz + rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_xz) * rk2Tu_xz + (rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_yz)) * rk2Tu_yz + rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_zz) * rk2Tu_zz;
					rk2d_Psi1_yz_o0_t6_m0_l0 = (-8.0 * M_PI * rk2inv_chi * rk2(i, j, k, Alpha) * rk2pTtd_ADM_yz) + rk2(i, j, k, Alpha) * rk2Rpd_yz + rk2chi_max * rk2(i, j, k, Alpha) * rk2Rtd_yz;
					rk2m_Psi1_yz_o0_t5_l0 = (-.5 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Psi1_yz_o0_t4_l0 = (-.5 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					rk2m_Psi1_yz_o0_t3_l0 = rk2chi_max * rk2Ct_zyz * d_Psi1_xx_o0_t3_m0_l0;
					rk2m_Psi1_yz_o0_t2_l0 = rk2chi_max * rk2Ct_yyz * d_Psi1_xx_o0_t2_m0_l0;
					rk2m_Psi1_yz_o0_t1_l0 = rk2chi_max * rk2Ct_xyz * d_Psi1_xx_o0_t1_m0_l0;
					rk2m_Psi1_yz_o0_t0_l0 = (-rk2chi_max) * d_Psi1_yz_o0_t0_m0_l0;
					rk2Psi1_yz = (((((rk2m_Psi1_yz_o0_t0_l0 + rk2m_Psi1_yz_o0_t1_l0) + rk2m_Psi1_yz_o0_t2_l0) + rk2m_Psi1_yz_o0_t3_l0) + rk2m_Psi1_yz_o0_t4_l0) + rk2m_Psi1_yz_o0_t5_l0) + rk2d_Psi1_yz_o0_t6_m0_l0;
					rk2pTtd_ADM_yy = (rk2Betatd_y * rk2Betatd_y) * rk2Tu_tt + 2.0 * rk2Betatd_y * (rk2(i, j, k, gtd_xy) * rk2Tu_tx + rk2(i, j, k, gtd_yy) * rk2Tu_ty + rk2(i, j, k, gtd_yz) * rk2Tu_tz) + (rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_xy)) * rk2Tu_xx + 2.0 * rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yy) * rk2Tu_xy + 2.0 * rk2(i, j, k, gtd_xy) * rk2(i, j, k, gtd_yz) * rk2Tu_xz + (rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_yy)) * rk2Tu_yy + 2.0 * rk2(i, j, k, gtd_yy) * rk2(i, j, k, gtd_yz) * rk2Tu_yz + (rk2(i, j, k, gtd_yz) * rk2(i, j, k, gtd_yz)) * rk2Tu_zz;
					rk2tr_pT = rk2inv_chi * (rk2gtu_xx * rk2pTtd_ADM_xx + 2.0 * rk2gtu_xy * rk2pTtd_ADM_xy + 2.0 * rk2gtu_xz * rk2pTtd_ADM_xz + rk2gtu_yy * rk2pTtd_ADM_yy + 2.0 * rk2gtu_yz * rk2pTtd_ADM_yz + rk2gtu_zz * rk2pTtd_ADM_zz);
					rk2d_Psi1_yy_o0_t5_m0_l0 = (-8.0 * M_PI * rk2inv_chi * rk2(i, j, k, Alpha) * rk2pTtd_ADM_yy) + rk2(i, j, k, Alpha) * rk2Rpd_yy + rk2chi_max * rk2(i, j, k, Alpha) * rk2Rtd_yy;
					rk2m_Psi1_yy_o0_t4_l0 = (-1.0 * rk2chi_max * rk2inv_chi) * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					rk2m_Psi1_yy_o0_t3_l0 = rk2chi_max * rk2Ct_zyy * d_Psi1_xx_o0_t3_m0_l0;
					rk2m_Psi1_yy_o0_t2_l0 = rk2chi_max * rk2Ct_yyy * d_Psi1_xx_o0_t2_m0_l0;
					rk2m_Psi1_yy_o0_t1_l0 = rk2chi_max * rk2Ct_xyy * d_Psi1_xx_o0_t1_m0_l0;
					rk2m_Psi1_yy_o0_t0_l0 = (-rk2chi_max) * d_Psi1_yy_o0_t0_m0_l0;
					rk2Psi1_yy = ((((rk2m_Psi1_yy_o0_t0_l0 + rk2m_Psi1_yy_o0_t1_l0) + rk2m_Psi1_yy_o0_t2_l0) + rk2m_Psi1_yy_o0_t3_l0) + rk2m_Psi1_yy_o0_t4_l0) + rk2d_Psi1_yy_o0_t5_m0_l0;
					rk2trPsi1 = rk2Psi1_xx * rk2gtu_xx + 2.0 * rk2Psi1_xy * rk2gtu_xy + 2.0 * rk2Psi1_xz * rk2gtu_xz + rk2Psi1_yy * rk2gtu_yy + 2.0 * rk2Psi1_yz * rk2gtu_yz + rk2Psi1_zz * rk2gtu_zz;
					rk2Psi1TF_yz = (-.3333333333333333 * rk2trPsi1 * rk2(i, j, k, gtd_yz)) + rk2Psi1_yz;
					rk2Psi1TF_yy = (-.3333333333333333 * rk2trPsi1 * rk2(i, j, k, gtd_yy)) + rk2Psi1_yy;
					rk2Psi1TF_xy = (-.3333333333333333 * rk2trPsi1 * rk2(i, j, k, gtd_xy)) + rk2Psi1_xy;
					rk2Psi1TF_xx = (-.3333333333333333 * rk2trPsi1 * rk2(i, j, k, gtd_xx)) + rk2Psi1_xx;
					rk2Psi1TF_xz = (-.3333333333333333 * rk2trPsi1 * rk2(i, j, k, gtd_xz)) + rk2Psi1_xz;
					rk2Psi1TF_zz = (-.3333333333333333 * rk2trPsi1 * rk2(i, j, k, gtd_zz)) + rk2Psi1_zz;
					rk2kappa_cc = std::min(parameters.p_kappa_cc, parameters.p_kappa_cc * rk2decay_factor) / rk2(i, j, k, Alpha);
					rk2rho_ADM = (rk2(i, j, k, Alpha) * rk2(i, j, k, Alpha)) * rk2Tu_tt;
					d_gtd_xx_o2_t3_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_xx) * log(rk2detgtd)) + (-2.0 * rk2(i, j, k, Alpha) * ((-.3333333333333333 * rk2trAt * parameters.lambda_0 * rk2(i, j, k, gtd_xx)) + rk2(i, j, k, Atd_xx))) + (-.6666666666666667 * rk2(i, j, k, gtd_xx) * rk2div_Beta);
					d_gtd_xy_o2_t6_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_xy) * log(rk2detgtd)) + (-2.0 * rk2(i, j, k, Alpha) * ((-.3333333333333333 * rk2trAt * parameters.lambda_0 * rk2(i, j, k, gtd_xy)) + rk2(i, j, k, Atd_xy))) + (-.6666666666666667 * rk2(i, j, k, gtd_xy) * rk2div_Beta);
					d_gtd_xz_o2_t6_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_xz) * log(rk2detgtd)) + (-2.0 * rk2(i, j, k, Alpha) * ((-.3333333333333333 * rk2trAt * parameters.lambda_0 * rk2(i, j, k, gtd_xz)) + rk2(i, j, k, Atd_xz))) + (-.6666666666666667 * rk2(i, j, k, gtd_xz) * rk2div_Beta);
					d_gtd_yy_o2_t3_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_yy) * log(rk2detgtd)) + (-2.0 * rk2(i, j, k, Alpha) * ((-.3333333333333333 * rk2trAt * parameters.lambda_0 * rk2(i, j, k, gtd_yy)) + rk2(i, j, k, Atd_yy))) + (-.6666666666666667 * rk2(i, j, k, gtd_yy) * rk2div_Beta);
					d_gtd_yz_o2_t6_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_yz) * log(rk2detgtd)) + (-2.0 * rk2(i, j, k, Alpha) * ((-.3333333333333333 * rk2trAt * parameters.lambda_0 * rk2(i, j, k, gtd_yz)) + rk2(i, j, k, Atd_yz))) + (-.6666666666666667 * rk2(i, j, k, gtd_yz) * rk2div_Beta);
					d_gtd_zz_o2_t3_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_zz) * log(rk2detgtd)) + (-2.0 * rk2(i, j, k, Alpha) * ((-.3333333333333333 * rk2trAt * parameters.lambda_0 * rk2(i, j, k, gtd_zz)) + rk2(i, j, k, Atd_zz))) + (-.6666666666666667 * rk2(i, j, k, gtd_zz) * rk2div_Beta);
					d_Atd_xx_o2_t3_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_xx) * rk2trAt) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) * rk2(i, j, k, Atd_xx) + (-2.0 * rk2(i, j, k, Atd_xx) * rk2Atud_xx) + (-2.0 * rk2(i, j, k, Atd_xy) * rk2Atud_yx) + (-2.0 * rk2(i, j, k, Atd_xz) * rk2Atud_zx)) + rk2Psi1TF_xx + (-.6666666666666667 * rk2(i, j, k, Atd_xx) * rk2div_Beta);
					d_Atd_xy_o2_t6_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_xy) * rk2trAt) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) * rk2(i, j, k, Atd_xy) + (-2.0 * rk2(i, j, k, Atd_xx) * rk2Atud_xy) + (-2.0 * rk2(i, j, k, Atd_xy) * rk2Atud_yy) + (-2.0 * rk2(i, j, k, Atd_xz) * rk2Atud_zy)) + rk2Psi1TF_xy + (-.6666666666666667 * rk2(i, j, k, Atd_xy) * rk2div_Beta);
					d_Atd_xz_o2_t6_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_xz) * rk2trAt) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) * rk2(i, j, k, Atd_xz) + (-2.0 * rk2(i, j, k, Atd_xx) * rk2Atud_xz) + (-2.0 * rk2(i, j, k, Atd_xy) * rk2Atud_yz) + (-2.0 * rk2(i, j, k, Atd_xz) * rk2Atud_zz)) + rk2Psi1TF_xz + (-.6666666666666667 * rk2(i, j, k, Atd_xz) * rk2div_Beta);
					d_Atd_yy_o2_t3_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_yy) * rk2trAt) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) * rk2(i, j, k, Atd_yy) + (-2.0 * rk2(i, j, k, Atd_xy) * rk2Atud_xy) + (-2.0 * rk2(i, j, k, Atd_yy) * rk2Atud_yy) + (-2.0 * rk2(i, j, k, Atd_yz) * rk2Atud_zy)) + rk2Psi1TF_yy + (-.6666666666666667 * rk2(i, j, k, Atd_yy) * rk2div_Beta);
					d_Atd_yz_o2_t6_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_yz) * rk2trAt) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) * rk2(i, j, k, Atd_yz) + (-2.0 * rk2(i, j, k, Atd_xy) * rk2Atud_xz) + (-2.0 * rk2(i, j, k, Atd_yy) * rk2Atud_yz) + (-2.0 * rk2(i, j, k, Atd_yz) * rk2Atud_zz)) + rk2Psi1TF_yz + (-.6666666666666667 * rk2(i, j, k, Atd_yz) * rk2div_Beta);
					d_Atd_zz_o2_t3_m0_l0 = (-.3333333333333333 * rk2kappa_cc * rk2(i, j, k, Alpha) * rk2(i, j, k, gtd_zz) * rk2trAt) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) * rk2(i, j, k, Atd_zz) + (-2.0 * rk2(i, j, k, Atd_xz) * rk2Atud_xz) + (-2.0 * rk2(i, j, k, Atd_yz) * rk2Atud_yz) + (-2.0 * rk2(i, j, k, Atd_zz) * rk2Atud_zz)) + rk2Psi1TF_zz + (-.6666666666666667 * rk2(i, j, k, Atd_zz) * rk2div_Beta);
					d_Gamh_x_o2_t24_m0_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Zu_x * (rk2kappa_z1 + 1.333333333333333 * rk2(i, j, k, theta) + .6666666666666667 * rk2(i, j, k, trK))) + (-50.26548245743669 * rk2(i, j, k, Alpha) * rk2inv_chi * (rk2gtu_xx * rk2Jtd_ADM_x + rk2gtu_xy * rk2Jtd_ADM_y + rk2gtu_xz * rk2Jtd_ADM_z)) + 2.0 * rk2(i, j, k, Alpha) * (rk2Ct_xxx * rk2Atu_xx + 2.0 * rk2Ct_xxy * rk2Atu_xy + 2.0 * rk2Ct_xxz * rk2Atu_xz + rk2Ct_xyy * rk2Atu_yy + 2.0 * rk2Ct_xyz * rk2Atu_yz + rk2Ct_xzz * rk2Atu_zz) + .6666666666666667 * rk2(i, j, k, Gamh_x) * rk2div_Beta + .3333333333333333 * rk2gtu_xz * rk2d_div_Beta_z + .3333333333333333 * rk2gtu_xy * rk2d_div_Beta_y + .3333333333333333 * rk2gtu_xx * rk2d_div_Beta_x;
					d_Gamh_y_o2_t24_m0_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Zu_y * (rk2kappa_z1 + 1.333333333333333 * rk2(i, j, k, theta) + .6666666666666667 * rk2(i, j, k, trK))) + .3333333333333333 * rk2gtu_yz * rk2d_div_Beta_z + .3333333333333333 * rk2gtu_yy * rk2d_div_Beta_y + .3333333333333333 * rk2gtu_xy * rk2d_div_Beta_x + 2.0 * rk2(i, j, k, Alpha) * (rk2Ct_yxx * rk2Atu_xx + 2.0 * rk2Ct_yxy * rk2Atu_xy + 2.0 * rk2Ct_yxz * rk2Atu_xz + rk2Ct_yyy * rk2Atu_yy + 2.0 * rk2Ct_yyz * rk2Atu_yz + rk2Ct_yzz * rk2Atu_zz) + .6666666666666667 * rk2(i, j, k, Gamh_y) * rk2div_Beta + (-50.26548245743669 * rk2(i, j, k, Alpha) * rk2inv_chi * (rk2gtu_xy * rk2Jtd_ADM_x + rk2gtu_yy * rk2Jtd_ADM_y + rk2gtu_yz * rk2Jtd_ADM_z));
					d_Betau_x_o0_t0_m0_l0 = (-rk2(i, j, k, Betau_x) * rk2feta) + .7500000000000000 * (rk2(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * rk2(i, j, k, Gamh_x);
					d_Betau_y_o0_t0_m0_l0 = (-rk2(i, j, k, Betau_y) * rk2feta) + .7500000000000000 * (rk2(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * rk2(i, j, k, Gamh_y);
					d_Betau_z_o0_t0_m0_l0 = (parameters.Betau_z_0 - rk2(i, j, k, Betau_z)) * rk2feta + .7500000000000000 * (rk2(i, j, k, Alpha) * parameters.lambda_f1 + parameters.lambda_f0) * rk2(i, j, k, Gamh_z);
					d_Gamh_z_o2_t24_m0_l0 = .3333333333333333 * rk2gtu_zz * rk2d_div_Beta_z + .3333333333333333 * rk2gtu_yz * rk2d_div_Beta_y + .3333333333333333 * rk2gtu_xz * rk2d_div_Beta_x + 2.0 * rk2(i, j, k, Alpha) * (rk2Ct_zxx * rk2Atu_xx + 2.0 * rk2Ct_zxy * rk2Atu_xy + 2.0 * rk2Ct_zxz * rk2Atu_xz + rk2Ct_zyy * rk2Atu_yy + 2.0 * rk2Ct_zyz * rk2Atu_yz + rk2Ct_zzz * rk2Atu_zz) + .6666666666666667 * rk2(i, j, k, Gamh_z) * rk2div_Beta + (-50.26548245743669 * rk2(i, j, k, Alpha) * rk2inv_chi * (rk2gtu_xz * rk2Jtd_ADM_x + rk2gtu_yz * rk2Jtd_ADM_y + rk2gtu_zz * rk2Jtd_ADM_z)) + (-2.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Zu_z * (rk2kappa_z1 + 1.333333333333333 * rk2(i, j, k, theta) + .6666666666666667 * rk2(i, j, k, trK)));
					d_Alpha_o2_t0_m0_l0 = -2.0 * (rk2(i, j, k, Alpha) * parameters.lambda_f3 + parameters.lambda_f2) * rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) - parameters.trK0);
					d_chi_o2_t0_m0_l0 = .6666666666666667 * rk2chi_max * (rk2(i, j, k, Alpha) * (2.0 * rk2(i, j, k, theta) + rk2(i, j, k, trK)) - rk2div_Beta);
					d_trK_o2_t21_m0_l0 = rk2(i, j, k, Alpha) * rk2kappa_z1 * (1.0 - rk2kappa_z2) * rk2(i, j, k, theta) + .3333333333333333 * rk2(i, j, k, Alpha) * ((2.0 * rk2(i, j, k, theta) + rk2(i, j, k, trK)) * (2.0 * rk2(i, j, k, theta) + rk2(i, j, k, trK))) + rk2(i, j, k, Alpha) * (rk2(i, j, k, Atd_xx) * rk2Atu_xx + 2.0 * rk2(i, j, k, Atd_xy) * rk2Atu_xy + 2.0 * rk2(i, j, k, Atd_xz) * rk2Atu_xz + rk2(i, j, k, Atd_yy) * rk2Atu_yy + 2.0 * rk2(i, j, k, Atd_yz) * rk2Atu_yz + rk2(i, j, k, Atd_zz) * rk2Atu_zz) + 4.0 * rk2(i, j, k, Alpha) * M_PI * (rk2rho_ADM + rk2tr_pT);
					d_theta_o2_t3_m0_l0 = (-rk2(i, j, k, Alpha) * rk2kappa_z1 * (2.0 + rk2kappa_z2) * rk2(i, j, k, theta)) + (-8.0 * rk2(i, j, k, Alpha) * M_PI * rk2rho_ADM) + .5 * rk2(i, j, k, Alpha) * (rk2Rscalar + .6666666666666667 * (rk2(i, j, k, trK) * rk2(i, j, k, trK)) + .6666666666666667 * rk2(i, j, k, theta) * ((-2.0 * rk2(i, j, k, theta)) + rk2(i, j, k, trK)) + (-rk2(i, j, k, Atd_xx) * rk2Atu_xx) + (-2.0 * rk2(i, j, k, Atd_xy) * rk2Atu_xy) + (-2.0 * rk2(i, j, k, Atd_xz) * rk2Atu_xz) + (-rk2(i, j, k, Atd_yy) * rk2Atu_yy) + (-2.0 * rk2(i, j, k, Atd_yz) * rk2Atu_yz) + (-rk2(i, j, k, Atd_zz) * rk2Atu_zz));
					d_piR_o2_t27_m0_l0 = rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) + 2.0 * rk2(i, j, k, theta)) * rk2(i, j, k, piR) + rk2(i, j, k, Alpha) * rk2dVdphi2 * rk2(i, j, k, phiR);
					d_peR_o2_t27_m0_l0 = rk2(i, j, k, Alpha) * rk2dVdphe2 * rk2(i, j, k, pheR) + rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) + 2.0 * rk2(i, j, k, theta)) * rk2(i, j, k, peR);
					d_piI_o2_t27_m0_l0 = rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) + 2.0 * rk2(i, j, k, theta)) * rk2(i, j, k, piI) + rk2(i, j, k, Alpha) * rk2dVdphi2 * rk2(i, j, k, phiI);
					d_peI_o2_t27_m0_l0 = rk2(i, j, k, Alpha) * (rk2(i, j, k, trK) + 2.0 * rk2(i, j, k, theta)) * rk2(i, j, k, peI) + rk2(i, j, k, Alpha) * rk2dVdphe2 * rk2(i, j, k, pheI);
					m_peI_o2_t26_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yz) * d_peI_o2_t26_m0_l0;
					m_peI_o2_t25_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yy) * d_peI_o2_t25_m0_l0;
					m_peI_o2_t24_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xz) * d_peI_o2_t24_m0_l0;
					m_peI_o2_t23_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xy) * d_peI_o2_t23_m0_l0;
					m_peI_o2_t22_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xx) * d_peI_o2_t22_m0_l0;
					m_peI_o2_t21_l0 = (-rk2chi_max * rk2gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t20_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t19_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t18_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t17_l0 = (-rk2chi_max * rk2gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t16_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t15_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t14_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t13_l0 = (-rk2chi_max * rk2gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t12_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_zz * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t11_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t10_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peI_o2_t9_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t8_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yy * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t7_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peI_o2_t6_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_pheI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t5_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_pheI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t4_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xx * d_d_pheI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peI_o2_t3_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_z - 2.0 * rk2Zu_z) * d_d_pheI4d_t_o0_t3_m0_l0;
					m_peI_o2_t2_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_y - 2.0 * rk2Zu_y) * d_d_pheI4d_t_o0_t2_m0_l0;
					m_peI_o2_t1_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_x - 2.0 * rk2Zu_x) * d_d_pheI4d_t_o0_t1_m0_l0;
					m_peI_o2_t0_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_zz) * d_peI_o2_t0_m0_l0;
					m_peI_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_peI_o1_t2_m0_l0;
					m_peI_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_peI_o1_t1_m0_l0;
					m_peI_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_peI_o1_t0_m0_l0;
					m_peI_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_peI_o0_t2_m0_l0;
					m_peI_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_peI_o0_t1_m0_l0;
					m_peI_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_peI_o0_t0_m0_l0;
					m_piI_o2_t26_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xz) * d_piI_o2_t26_m0_l0;
					m_piI_o2_t25_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xy) * d_piI_o2_t25_m0_l0;
					m_piI_o2_t24_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xx) * d_piI_o2_t24_m0_l0;
					m_piI_o2_t23_l0 = (-rk2chi_max * rk2gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t22_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t21_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t20_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t19_l0 = (-rk2chi_max * rk2gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t18_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t17_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t16_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t15_l0 = (-rk2chi_max * rk2gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t14_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_zz * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t13_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t12_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piI_o2_t11_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t10_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yy * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t9_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piI_o2_t8_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_phiI4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t7_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_phiI4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t6_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xx * d_d_phiI4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piI_o2_t5_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_z - 2.0 * rk2Zu_z) * d_d_phiI4d_t_o0_t3_m0_l0;
					m_piI_o2_t4_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_y - 2.0 * rk2Zu_y) * d_d_phiI4d_t_o0_t2_m0_l0;
					m_piI_o2_t3_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_x - 2.0 * rk2Zu_x) * d_d_phiI4d_t_o0_t1_m0_l0;
					m_piI_o2_t2_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_zz) * d_piI_o2_t2_m0_l0;
					m_piI_o2_t1_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yz) * d_piI_o2_t1_m0_l0;
					m_piI_o2_t0_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yy) * d_piI_o2_t0_m0_l0;
					m_piI_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_piI_o1_t2_m0_l0;
					m_piI_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_piI_o1_t1_m0_l0;
					m_piI_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_piI_o1_t0_m0_l0;
					m_piI_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_piI_o0_t2_m0_l0;
					m_piI_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_piI_o0_t1_m0_l0;
					m_piI_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_piI_o0_t0_m0_l0;
					m_peR_o2_t26_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xz) * d_peR_o2_t26_m0_l0;
					m_peR_o2_t25_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xy) * d_peR_o2_t25_m0_l0;
					m_peR_o2_t24_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xx) * d_peR_o2_t24_m0_l0;
					m_peR_o2_t23_l0 = (-rk2chi_max * rk2gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t22_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t21_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t20_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t19_l0 = (-rk2chi_max * rk2gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t18_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t17_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t16_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t15_l0 = (-rk2chi_max * rk2gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t14_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_zz * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t13_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t12_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_peR_o2_t11_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t10_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yy * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t9_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_peR_o2_t8_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_pheR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t7_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_pheR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t6_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xx * d_d_pheR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_peR_o2_t5_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_z - 2.0 * rk2Zu_z) * d_d_pheR4d_t_o0_t3_m0_l0;
					m_peR_o2_t4_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_y - 2.0 * rk2Zu_y) * d_d_pheR4d_t_o0_t2_m0_l0;
					m_peR_o2_t3_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_x - 2.0 * rk2Zu_x) * d_d_pheR4d_t_o0_t1_m0_l0;
					m_peR_o2_t2_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_zz) * d_peR_o2_t2_m0_l0;
					m_peR_o2_t1_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yz) * d_peR_o2_t1_m0_l0;
					m_peR_o2_t0_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yy) * d_peR_o2_t0_m0_l0;
					m_peR_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_peR_o1_t2_m0_l0;
					m_peR_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_peR_o1_t1_m0_l0;
					m_peR_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_peR_o1_t0_m0_l0;
					m_peR_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_peR_o0_t2_m0_l0;
					m_peR_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_peR_o0_t1_m0_l0;
					m_peR_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_peR_o0_t0_m0_l0;
					m_piR_o2_t26_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xx) * d_piR_o2_t26_m0_l0;
					m_piR_o2_t25_l0 = (-rk2chi_max * rk2gtu_zz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t24_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t23_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t22_l0 = (-rk2chi_max * rk2gtu_yz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t21_l0 = (-rk2chi_max * rk2gtu_yy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t20_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t19_l0 = (-rk2chi_max * rk2gtu_xz) * d_Psi1_xx_o0_t3_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t18_l0 = (-rk2chi_max * rk2gtu_xy) * d_Psi1_xx_o0_t2_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t17_l0 = (-rk2chi_max * rk2gtu_xx) * d_Psi1_xx_o0_t1_m0_l0 * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t16_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_zz * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t15_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t14_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_piR_o2_t13_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yz * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t12_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_yy * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t11_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_piR_o2_t10_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xz * d_d_phiR4d_t_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t9_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xy * d_d_phiR4d_t_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t8_l0 = .5000000000000000 * rk2(i, j, k, Alpha) * rk2gtu_xx * d_d_phiR4d_t_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_piR_o2_t7_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_z - 2.0 * rk2Zu_z) * d_d_phiR4d_t_o0_t3_m0_l0;
					m_piR_o2_t6_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_y - 2.0 * rk2Zu_y) * d_d_phiR4d_t_o0_t2_m0_l0;
					m_piR_o2_t5_l0 = rk2(i, j, k, Alpha) * (rk2chi_max * rk2Gamt_x - 2.0 * rk2Zu_x) * d_d_phiR4d_t_o0_t1_m0_l0;
					m_piR_o2_t4_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_zz) * d_piR_o2_t4_m0_l0;
					m_piR_o2_t3_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yz) * d_piR_o2_t3_m0_l0;
					m_piR_o2_t2_l0 = (-rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_yy) * d_piR_o2_t2_m0_l0;
					m_piR_o2_t1_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xz) * d_piR_o2_t1_m0_l0;
					m_piR_o2_t0_l0 = (-2.0 * rk2(i, j, k, Alpha) * rk2chi_max * rk2gtu_xy) * d_piR_o2_t0_m0_l0;
					m_piR_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_piR_o1_t2_m0_l0;
					m_piR_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_piR_o1_t1_m0_l0;
					m_piR_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_piR_o1_t0_m0_l0;
					m_piR_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_piR_o0_t2_m0_l0;
					m_piR_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_piR_o0_t1_m0_l0;
					m_piR_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_piR_o0_t0_m0_l0;
					m_pheI_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_pheI_o1_t2_m0_l0;
					m_pheI_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_pheI_o1_t1_m0_l0;
					m_pheI_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_pheI_o1_t0_m0_l0;
					m_pheI_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_pheI_o0_t2_m0_l0;
					m_pheI_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_pheI_o0_t1_m0_l0;
					m_pheI_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_pheI_o0_t0_m0_l0;
					m_phiI_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_phiI_o1_t2_m0_l0;
					m_phiI_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_phiI_o1_t1_m0_l0;
					m_phiI_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_phiI_o1_t0_m0_l0;
					m_phiI_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_phiI_o0_t2_m0_l0;
					m_phiI_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_phiI_o0_t1_m0_l0;
					m_phiI_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_phiI_o0_t0_m0_l0;
					m_pheR_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_pheR_o1_t2_m0_l0;
					m_pheR_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_pheR_o1_t1_m0_l0;
					m_pheR_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_pheR_o1_t0_m0_l0;
					m_pheR_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_pheR_o0_t2_m0_l0;
					m_pheR_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_pheR_o0_t1_m0_l0;
					m_pheR_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_pheR_o0_t0_m0_l0;
					m_phiR_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_phiR_o1_t2_m0_l0;
					m_phiR_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_phiR_o1_t1_m0_l0;
					m_phiR_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_phiR_o1_t0_m0_l0;
					m_phiR_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_phiR_o0_t2_m0_l0;
					m_phiR_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_phiR_o0_t1_m0_l0;
					m_phiR_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_phiR_o0_t0_m0_l0;
					m_theta_o2_t2_l0 = (-rk2Zu_z) * d_Psi1_xx_o0_t3_m0_l0;
					m_theta_o2_t1_l0 = (-rk2Zu_y) * d_Psi1_xx_o0_t2_m0_l0;
					m_theta_o2_t0_l0 = (-rk2Zu_x) * d_Psi1_xx_o0_t1_m0_l0;
					m_theta_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_theta_o1_t2_m0_l0;
					m_theta_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_theta_o1_t1_m0_l0;
					m_theta_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_theta_o1_t0_m0_l0;
					m_theta_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_theta_o0_t2_m0_l0;
					m_theta_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_theta_o0_t1_m0_l0;
					m_theta_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_theta_o0_t0_m0_l0;
					m_trK_o2_t20_l0 = 2.0 * rk2Zu_z * d_Psi1_xx_o0_t3_m0_l0;
					m_trK_o2_t19_l0 = 2.0 * rk2Zu_y * d_Psi1_xx_o0_t2_m0_l0;
					m_trK_o2_t18_l0 = 2.0 * rk2Zu_x * d_Psi1_xx_o0_t1_m0_l0;
					m_trK_o2_t17_l0 = .5 * rk2gtu_xy * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t16_l0 = .5 * rk2gtu_xx * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t15_l0 = rk2chi_max * rk2Gamt_z * d_Psi1_xx_o0_t3_m0_l0;
					m_trK_o2_t14_l0 = rk2chi_max * rk2Gamt_y * d_Psi1_xx_o0_t2_m0_l0;
					m_trK_o2_t13_l0 = rk2chi_max * rk2Gamt_x * d_Psi1_xx_o0_t1_m0_l0;
					m_trK_o2_t12_l0 = (-rk2chi_max * rk2gtu_zz) * d_Psi1_zz_o0_t0_m0_l0;
					m_trK_o2_t11_l0 = (-rk2chi_max * rk2gtu_yy) * d_Psi1_yy_o0_t0_m0_l0;
					m_trK_o2_t10_l0 = (-2.0 * rk2chi_max * rk2gtu_yz) * d_Psi1_yz_o0_t0_m0_l0;
					m_trK_o2_t9_l0 = (-2.0 * rk2chi_max * rk2gtu_xz) * d_Psi1_xz_o0_t0_m0_l0;
					m_trK_o2_t8_l0 = (-2.0 * rk2chi_max * rk2gtu_xy) * d_Psi1_xy_o0_t0_m0_l0;
					m_trK_o2_t7_l0 = (-rk2chi_max * rk2gtu_xx) * d_Psi1_xx_o0_t0_m0_l0;
					m_trK_o2_t6_l0 = .5 * rk2gtu_zz * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o2_t5_l0 = .5 * rk2gtu_yz * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t4_l0 = .5 * rk2gtu_xz * d_Psi1_xx_o0_t3_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t3_l0 = .5 * rk2gtu_yz * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o2_t2_l0 = .5 * rk2gtu_yy * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t1_m0_l0;
					m_trK_o2_t1_l0 = .5 * rk2gtu_xy * d_Psi1_xx_o0_t2_m0_l0 * d_Rpd_xx_o0_t0_m0_l0;
					m_trK_o2_t0_l0 = .5 * rk2gtu_xz * d_Psi1_xx_o0_t1_m0_l0 * d_Rpd_xx_o0_t2_m0_l0;
					m_trK_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_trK_o1_t2_m0_l0;
					m_trK_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_trK_o1_t1_m0_l0;
					m_trK_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_trK_o1_t0_m0_l0;
					m_trK_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_trK_o0_t2_m0_l0;
					m_trK_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_trK_o0_t1_m0_l0;
					m_trK_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_trK_o0_t0_m0_l0;
					m_chi_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_chi_o1_t2_m0_l0;
					m_chi_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_chi_o1_t1_m0_l0;
					m_chi_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_chi_o1_t0_m0_l0;
					m_chi_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_chi_o0_t2_m0_l0;
					m_chi_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_chi_o0_t1_m0_l0;
					m_chi_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_chi_o0_t0_m0_l0;
					m_Alpha_o1_t2_l0 = parameters.lambda_1 * std::min(0.0, rk2(i, j, k, Betau_z)) * d_Alpha_o1_t2_m0_l0;
					m_Alpha_o1_t1_l0 = parameters.lambda_1 * std::min(0.0, rk2(i, j, k, Betau_y)) * d_Alpha_o1_t1_m0_l0;
					m_Alpha_o1_t0_l0 = parameters.lambda_1 * std::min(0.0, rk2(i, j, k, Betau_x)) * d_Alpha_o1_t0_m0_l0;
					m_Alpha_o0_t2_l0 = parameters.lambda_1 * std::max(0.0, rk2(i, j, k, Betau_z)) * d_Alpha_o0_t2_m0_l0;
					m_Alpha_o0_t1_l0 = parameters.lambda_1 * std::max(0.0, rk2(i, j, k, Betau_y)) * d_Alpha_o0_t1_m0_l0;
					m_Alpha_o0_t0_l0 = parameters.lambda_1 * std::max(0.0, rk2(i, j, k, Betau_x)) * d_Alpha_o0_t0_m0_l0;
					m_Gamh_z_o2_t23_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_xz) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_z_o2_t22_l0 = (-2.0 * rk2Atu_zz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_z_o2_t21_l0 = (-2.0 * rk2Atu_yz) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t20_l0 = (-2.0 * rk2Atu_xz) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_z_o2_t19_l0 = rk2gtu_zz * d_d_div_Beta_z_o0_t2_m0_l0;
					m_Gamh_z_o2_t18_l0 = 2.0 * rk2gtu_yz * d_d_div_Beta_y_o0_t2_m0_l0;
					m_Gamh_z_o2_t17_l0 = rk2gtu_yy * d_Gamh_z_o2_t17_m0_l0;
					m_Gamh_z_o2_t16_l0 = 2.0 * rk2gtu_xz * d_d_div_Beta_x_o0_t2_m0_l0;
					m_Gamh_z_o2_t15_l0 = 2.0 * rk2gtu_xy * d_Gamh_z_o2_t15_m0_l0;
					m_Gamh_z_o2_t14_l0 = rk2gtu_xx * d_Gamh_z_o2_t14_m0_l0;
					m_Gamh_z_o2_t13_l0 = (-rk2(i, j, k, Gamh_z)) * d_div_Beta_o0_t2_m0_l0;
					m_Gamh_z_o2_t12_l0 = (-rk2(i, j, k, Gamh_y)) * d_gtd_xy_o2_t2_m0_l0;
					m_Gamh_z_o2_t11_l0 = (-rk2(i, j, k, Gamh_x)) * d_gtd_xx_o2_t2_m0_l0;
					m_Gamh_z_o2_t10_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_zz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_z_o2_t9_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_yz) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t8_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_xz) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_z_o2_t7_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_zz) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_z_o2_t6_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_yz) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_z_o2_t5_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_xz) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_z_o2_t4_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_zz) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_z_o2_t3_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_yz) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_z_o2_t2_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_xz) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_z_o2_t1_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_zz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_z_o2_t0_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_yz) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_z_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Gamh_z_o1_t2_m0_l0;
					m_Gamh_z_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Gamh_z_o1_t1_m0_l0;
					m_Gamh_z_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Gamh_z_o1_t0_m0_l0;
					m_Gamh_z_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Gamh_z_o0_t2_m0_l0;
					m_Gamh_z_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Gamh_z_o0_t1_m0_l0;
					m_Gamh_z_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Gamh_z_o0_t0_m0_l0;
					m_Betau_z_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_z)) * d_Betau_z_o2_t2_m0_l0;
					m_Betau_z_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_y)) * d_Betau_z_o2_t1_m0_l0;
					m_Betau_z_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_x)) * d_Betau_z_o2_t0_m0_l0;
					m_Betau_z_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_z)) * d_Betau_z_o1_t2_m0_l0;
					m_Betau_z_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_y)) * d_Betau_z_o1_t1_m0_l0;
					m_Betau_z_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_x)) * d_Betau_z_o1_t0_m0_l0;
					m_Betau_y_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_z)) * d_Betau_y_o2_t2_m0_l0;
					m_Betau_y_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_y)) * d_Betau_y_o2_t1_m0_l0;
					m_Betau_y_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_x)) * d_Betau_y_o2_t0_m0_l0;
					m_Betau_y_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_z)) * d_Betau_y_o1_t2_m0_l0;
					m_Betau_y_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_y)) * d_Betau_y_o1_t1_m0_l0;
					m_Betau_y_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_x)) * d_Betau_y_o1_t0_m0_l0;
					m_Betau_x_o2_t2_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_z)) * d_Betau_x_o2_t2_m0_l0;
					m_Betau_x_o2_t1_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_y)) * d_Betau_x_o2_t1_m0_l0;
					m_Betau_x_o2_t0_l0 = parameters.lambda_2 * std::min(0.0, rk2(i, j, k, Betau_x)) * d_Betau_x_o2_t0_m0_l0;
					m_Betau_x_o1_t2_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_z)) * d_Betau_x_o1_t2_m0_l0;
					m_Betau_x_o1_t1_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_y)) * d_Betau_x_o1_t1_m0_l0;
					m_Betau_x_o1_t0_l0 = parameters.lambda_2 * std::max(0.0, rk2(i, j, k, Betau_x)) * d_Betau_x_o1_t0_m0_l0;
					m_Gamh_y_o2_t23_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_yz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t22_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_yy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t21_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_xy) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_y_o2_t20_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_yy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t19_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_xy) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t18_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_yz) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_y_o2_t17_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_yy) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_y_o2_t16_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_xy) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_y_o2_t15_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_yz) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_y_o2_t14_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_yy) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_y_o2_t13_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_xy) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_y_o2_t12_l0 = (-2.0 * rk2Atu_yz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_y_o2_t11_l0 = (-2.0 * rk2Atu_yy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_y_o2_t10_l0 = (-2.0 * rk2Atu_xy) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_y_o2_t9_l0 = rk2gtu_zz * d_Gamh_y_o2_t9_m0_l0;
					m_Gamh_y_o2_t8_l0 = 2.0 * rk2gtu_yz * d_d_div_Beta_z_o0_t1_m0_l0;
					m_Gamh_y_o2_t7_l0 = rk2gtu_yy * d_d_div_Beta_y_o0_t1_m0_l0;
					m_Gamh_y_o2_t6_l0 = 2.0 * rk2gtu_xz * d_Gamh_y_o2_t6_m0_l0;
					m_Gamh_y_o2_t5_l0 = 2.0 * rk2gtu_xy * d_d_div_Beta_x_o0_t1_m0_l0;
					m_Gamh_y_o2_t4_l0 = rk2gtu_xx * d_Gamh_y_o2_t4_m0_l0;
					m_Gamh_y_o2_t3_l0 = (-rk2(i, j, k, Gamh_z)) * d_gtd_xz_o2_t1_m0_l0;
					m_Gamh_y_o2_t2_l0 = (-rk2(i, j, k, Gamh_y)) * d_div_Beta_o0_t1_m0_l0;
					m_Gamh_y_o2_t1_l0 = (-rk2(i, j, k, Gamh_x)) * d_gtd_xx_o2_t1_m0_l0;
					m_Gamh_y_o2_t0_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_yz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_y_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Gamh_y_o1_t2_m0_l0;
					m_Gamh_y_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Gamh_y_o1_t1_m0_l0;
					m_Gamh_y_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Gamh_y_o1_t0_m0_l0;
					m_Gamh_y_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Gamh_y_o0_t2_m0_l0;
					m_Gamh_y_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Gamh_y_o0_t1_m0_l0;
					m_Gamh_y_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Gamh_y_o0_t0_m0_l0;
					m_Gamh_x_o2_t23_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_xz) * d_Rpd_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t22_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_xy) * d_Rpd_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t21_l0 = (-3.0 * rk2(i, j, k, Alpha) * rk2inv_chi * rk2Atu_xx) * d_Rpd_xx_o0_t0_m0_l0;
					m_Gamh_x_o2_t20_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_xz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_x_o2_t19_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_xy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t18_l0 = (-2.0 * rk2(i, j, k, theta) * rk2gtu_xx) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t17_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_xz) * d_Gamh_x_o2_t17_m0_l0;
					m_Gamh_x_o2_t16_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_xy) * d_Gamh_x_o2_t16_m0_l0;
					m_Gamh_x_o2_t15_l0 = (-.6666666666666667 * rk2(i, j, k, Alpha) * rk2gtu_xx) * d_Gamh_x_o2_t15_m0_l0;
					m_Gamh_x_o2_t14_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_xz) * d_Gamh_x_o2_t14_m0_l0;
					m_Gamh_x_o2_t13_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_xy) * d_Gamh_x_o2_t13_m0_l0;
					m_Gamh_x_o2_t12_l0 = (-1.333333333333333 * rk2(i, j, k, Alpha) * rk2gtu_xx) * d_Gamh_x_o2_t12_m0_l0;
					m_Gamh_x_o2_t11_l0 = (-2.0 * rk2Atu_xz) * d_Psi1_xx_o0_t3_m0_l0;
					m_Gamh_x_o2_t10_l0 = (-2.0 * rk2Atu_xy) * d_Psi1_xx_o0_t2_m0_l0;
					m_Gamh_x_o2_t9_l0 = (-2.0 * rk2Atu_xx) * d_Psi1_xx_o0_t1_m0_l0;
					m_Gamh_x_o2_t8_l0 = rk2gtu_zz * d_Gamh_x_o2_t8_m0_l0;
					m_Gamh_x_o2_t7_l0 = 2.0 * rk2gtu_yz * d_Gamh_x_o2_t7_m0_l0;
					m_Gamh_x_o2_t6_l0 = rk2gtu_yy * d_Gamh_x_o2_t6_m0_l0;
					m_Gamh_x_o2_t5_l0 = 2.0 * rk2gtu_xz * d_d_div_Beta_z_o0_t0_m0_l0;
					m_Gamh_x_o2_t4_l0 = 2.0 * rk2gtu_xy * d_d_div_Beta_y_o0_t0_m0_l0;
					m_Gamh_x_o2_t3_l0 = rk2gtu_xx * d_d_div_Beta_x_o0_t0_m0_l0;
					m_Gamh_x_o2_t2_l0 = (-rk2(i, j, k, Gamh_z)) * d_gtd_xz_o2_t0_m0_l0;
					m_Gamh_x_o2_t1_l0 = (-rk2(i, j, k, Gamh_y)) * d_gtd_xy_o2_t0_m0_l0;
					m_Gamh_x_o2_t0_l0 = (-rk2(i, j, k, Gamh_x)) * d_div_Beta_o0_t0_m0_l0;
					m_Gamh_x_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Gamh_x_o1_t2_m0_l0;
					m_Gamh_x_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Gamh_x_o1_t1_m0_l0;
					m_Gamh_x_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Gamh_x_o1_t0_m0_l0;
					m_Gamh_x_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Gamh_x_o0_t2_m0_l0;
					m_Gamh_x_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Gamh_x_o0_t1_m0_l0;
					m_Gamh_x_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Gamh_x_o0_t0_m0_l0;
					m_Atd_zz_o2_t2_l0 = 2.0 * rk2(i, j, k, Atd_zz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_zz_o2_t1_l0 = 2.0 * rk2(i, j, k, Atd_yz) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_zz_o2_t0_l0 = 2.0 * rk2(i, j, k, Atd_xz) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_zz_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Atd_zz_o1_t2_m0_l0;
					m_Atd_zz_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Atd_zz_o1_t1_m0_l0;
					m_Atd_zz_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Atd_zz_o1_t0_m0_l0;
					m_Atd_zz_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Atd_zz_o0_t2_m0_l0;
					m_Atd_zz_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Atd_zz_o0_t1_m0_l0;
					m_Atd_zz_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Atd_zz_o0_t0_m0_l0;
					m_Atd_yz_o2_t5_l0 = rk2(i, j, k, Atd_zz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_yz_o2_t4_l0 = rk2(i, j, k, Atd_yz) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_yz_o2_t3_l0 = rk2(i, j, k, Atd_xz) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_yz_o2_t2_l0 = rk2(i, j, k, Atd_yz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_yz_o2_t1_l0 = rk2(i, j, k, Atd_yy) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_yz_o2_t0_l0 = rk2(i, j, k, Atd_xy) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_yz_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Atd_yz_o1_t2_m0_l0;
					m_Atd_yz_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Atd_yz_o1_t1_m0_l0;
					m_Atd_yz_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Atd_yz_o1_t0_m0_l0;
					m_Atd_yz_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Atd_yz_o0_t2_m0_l0;
					m_Atd_yz_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Atd_yz_o0_t1_m0_l0;
					m_Atd_yz_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Atd_yz_o0_t0_m0_l0;
					m_Atd_yy_o2_t2_l0 = 2.0 * rk2(i, j, k, Atd_yz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_yy_o2_t1_l0 = 2.0 * rk2(i, j, k, Atd_yy) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_yy_o2_t0_l0 = 2.0 * rk2(i, j, k, Atd_xy) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_yy_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Atd_yy_o1_t2_m0_l0;
					m_Atd_yy_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Atd_yy_o1_t1_m0_l0;
					m_Atd_yy_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Atd_yy_o1_t0_m0_l0;
					m_Atd_yy_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Atd_yy_o0_t2_m0_l0;
					m_Atd_yy_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Atd_yy_o0_t1_m0_l0;
					m_Atd_yy_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Atd_yy_o0_t0_m0_l0;
					m_Atd_xz_o2_t5_l0 = rk2(i, j, k, Atd_zz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xz_o2_t4_l0 = rk2(i, j, k, Atd_yz) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xz_o2_t3_l0 = rk2(i, j, k, Atd_xz) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xz_o2_t2_l0 = rk2(i, j, k, Atd_xz) * d_div_Beta_o0_t2_m0_l0;
					m_Atd_xz_o2_t1_l0 = rk2(i, j, k, Atd_xy) * d_gtd_xz_o2_t1_m0_l0;
					m_Atd_xz_o2_t0_l0 = rk2(i, j, k, Atd_xx) * d_gtd_xz_o2_t0_m0_l0;
					m_Atd_xz_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Atd_xz_o1_t2_m0_l0;
					m_Atd_xz_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Atd_xz_o1_t1_m0_l0;
					m_Atd_xz_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Atd_xz_o1_t0_m0_l0;
					m_Atd_xz_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Atd_xz_o0_t2_m0_l0;
					m_Atd_xz_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Atd_xz_o0_t1_m0_l0;
					m_Atd_xz_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Atd_xz_o0_t0_m0_l0;
					m_Atd_xy_o2_t5_l0 = rk2(i, j, k, Atd_yz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xy_o2_t4_l0 = rk2(i, j, k, Atd_yy) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xy_o2_t3_l0 = rk2(i, j, k, Atd_xy) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xy_o2_t2_l0 = rk2(i, j, k, Atd_xz) * d_gtd_xy_o2_t2_m0_l0;
					m_Atd_xy_o2_t1_l0 = rk2(i, j, k, Atd_xy) * d_div_Beta_o0_t1_m0_l0;
					m_Atd_xy_o2_t0_l0 = rk2(i, j, k, Atd_xx) * d_gtd_xy_o2_t0_m0_l0;
					m_Atd_xy_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Atd_xy_o1_t2_m0_l0;
					m_Atd_xy_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Atd_xy_o1_t1_m0_l0;
					m_Atd_xy_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Atd_xy_o1_t0_m0_l0;
					m_Atd_xy_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Atd_xy_o0_t2_m0_l0;
					m_Atd_xy_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Atd_xy_o0_t1_m0_l0;
					m_Atd_xy_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Atd_xy_o0_t0_m0_l0;
					m_Atd_xx_o2_t2_l0 = 2.0 * rk2(i, j, k, Atd_xz) * d_gtd_xx_o2_t2_m0_l0;
					m_Atd_xx_o2_t1_l0 = 2.0 * rk2(i, j, k, Atd_xy) * d_gtd_xx_o2_t1_m0_l0;
					m_Atd_xx_o2_t0_l0 = 2.0 * rk2(i, j, k, Atd_xx) * d_div_Beta_o0_t0_m0_l0;
					m_Atd_xx_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_Atd_xx_o1_t2_m0_l0;
					m_Atd_xx_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_Atd_xx_o1_t1_m0_l0;
					m_Atd_xx_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_Atd_xx_o1_t0_m0_l0;
					m_Atd_xx_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_Atd_xx_o0_t2_m0_l0;
					m_Atd_xx_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_Atd_xx_o0_t1_m0_l0;
					m_Atd_xx_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_Atd_xx_o0_t0_m0_l0;
					m_gtd_zz_o2_t2_l0 = 2.0 * rk2(i, j, k, gtd_zz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_zz_o2_t1_l0 = 2.0 * rk2(i, j, k, gtd_yz) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_zz_o2_t0_l0 = 2.0 * rk2(i, j, k, gtd_xz) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_zz_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_gtd_zz_o1_t2_m0_l0;
					m_gtd_zz_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_gtd_zz_o1_t1_m0_l0;
					m_gtd_zz_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_gtd_zz_o1_t0_m0_l0;
					m_gtd_zz_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_gtd_zz_o0_t2_m0_l0;
					m_gtd_zz_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_gtd_zz_o0_t1_m0_l0;
					m_gtd_zz_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_gtd_zz_o0_t0_m0_l0;
					m_gtd_yz_o2_t5_l0 = rk2(i, j, k, gtd_zz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_yz_o2_t4_l0 = rk2(i, j, k, gtd_yz) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_yz_o2_t3_l0 = rk2(i, j, k, gtd_xz) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_yz_o2_t2_l0 = rk2(i, j, k, gtd_yz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_yz_o2_t1_l0 = rk2(i, j, k, gtd_yy) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_yz_o2_t0_l0 = rk2(i, j, k, gtd_xy) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_yz_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_gtd_yz_o1_t2_m0_l0;
					m_gtd_yz_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_gtd_yz_o1_t1_m0_l0;
					m_gtd_yz_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_gtd_yz_o1_t0_m0_l0;
					m_gtd_yz_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_gtd_yz_o0_t2_m0_l0;
					m_gtd_yz_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_gtd_yz_o0_t1_m0_l0;
					m_gtd_yz_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_gtd_yz_o0_t0_m0_l0;
					m_gtd_yy_o2_t2_l0 = 2.0 * rk2(i, j, k, gtd_yz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_yy_o2_t1_l0 = 2.0 * rk2(i, j, k, gtd_yy) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_yy_o2_t0_l0 = 2.0 * rk2(i, j, k, gtd_xy) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_yy_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_gtd_yy_o1_t2_m0_l0;
					m_gtd_yy_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_gtd_yy_o1_t1_m0_l0;
					m_gtd_yy_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_gtd_yy_o1_t0_m0_l0;
					m_gtd_yy_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_gtd_yy_o0_t2_m0_l0;
					m_gtd_yy_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_gtd_yy_o0_t1_m0_l0;
					m_gtd_yy_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_gtd_yy_o0_t0_m0_l0;
					m_gtd_xz_o2_t5_l0 = rk2(i, j, k, gtd_zz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xz_o2_t4_l0 = rk2(i, j, k, gtd_yz) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xz_o2_t3_l0 = rk2(i, j, k, gtd_xz) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xz_o2_t2_l0 = rk2(i, j, k, gtd_xz) * d_div_Beta_o0_t2_m0_l0;
					m_gtd_xz_o2_t1_l0 = rk2(i, j, k, gtd_xy) * d_gtd_xz_o2_t1_m0_l0;
					m_gtd_xz_o2_t0_l0 = rk2(i, j, k, gtd_xx) * d_gtd_xz_o2_t0_m0_l0;
					m_gtd_xz_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_gtd_xz_o1_t2_m0_l0;
					m_gtd_xz_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_gtd_xz_o1_t1_m0_l0;
					m_gtd_xz_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_gtd_xz_o1_t0_m0_l0;
					m_gtd_xz_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_gtd_xz_o0_t2_m0_l0;
					m_gtd_xz_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_gtd_xz_o0_t1_m0_l0;
					m_gtd_xz_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_gtd_xz_o0_t0_m0_l0;
					m_gtd_xy_o2_t5_l0 = rk2(i, j, k, gtd_yz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xy_o2_t4_l0 = rk2(i, j, k, gtd_yy) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xy_o2_t3_l0 = rk2(i, j, k, gtd_xy) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xy_o2_t2_l0 = rk2(i, j, k, gtd_xz) * d_gtd_xy_o2_t2_m0_l0;
					m_gtd_xy_o2_t1_l0 = rk2(i, j, k, gtd_xy) * d_div_Beta_o0_t1_m0_l0;
					m_gtd_xy_o2_t0_l0 = rk2(i, j, k, gtd_xx) * d_gtd_xy_o2_t0_m0_l0;
					m_gtd_xy_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_gtd_xy_o1_t2_m0_l0;
					m_gtd_xy_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_gtd_xy_o1_t1_m0_l0;
					m_gtd_xy_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_gtd_xy_o1_t0_m0_l0;
					m_gtd_xy_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_gtd_xy_o0_t2_m0_l0;
					m_gtd_xy_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_gtd_xy_o0_t1_m0_l0;
					m_gtd_xy_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_gtd_xy_o0_t0_m0_l0;
					m_gtd_xx_o2_t2_l0 = 2.0 * rk2(i, j, k, gtd_xz) * d_gtd_xx_o2_t2_m0_l0;
					m_gtd_xx_o2_t1_l0 = 2.0 * rk2(i, j, k, gtd_xy) * d_gtd_xx_o2_t1_m0_l0;
					m_gtd_xx_o2_t0_l0 = 2.0 * rk2(i, j, k, gtd_xx) * d_div_Beta_o0_t0_m0_l0;
					m_gtd_xx_o1_t2_l0 = std::min(0.0, rk2(i, j, k, Betau_z)) * d_gtd_xx_o1_t2_m0_l0;
					m_gtd_xx_o1_t1_l0 = std::min(0.0, rk2(i, j, k, Betau_y)) * d_gtd_xx_o1_t1_m0_l0;
					m_gtd_xx_o1_t0_l0 = std::min(0.0, rk2(i, j, k, Betau_x)) * d_gtd_xx_o1_t0_m0_l0;
					m_gtd_xx_o0_t2_l0 = std::max(0.0, rk2(i, j, k, Betau_z)) * d_gtd_xx_o0_t2_m0_l0;
					m_gtd_xx_o0_t1_l0 = std::max(0.0, rk2(i, j, k, Betau_y)) * d_gtd_xx_o0_t1_m0_l0;
					m_gtd_xx_o0_t0_l0 = std::max(0.0, rk2(i, j, k, Betau_x)) * d_gtd_xx_o0_t0_m0_l0;
					RHS_gtd_xx = ((((((((m_gtd_xx_o0_t0_l0 + m_gtd_xx_o0_t1_l0) + m_gtd_xx_o0_t2_l0) + m_gtd_xx_o1_t0_l0) + m_gtd_xx_o1_t1_l0) + m_gtd_xx_o1_t2_l0) + m_gtd_xx_o2_t0_l0) + m_gtd_xx_o2_t1_l0) + m_gtd_xx_o2_t2_l0) + d_gtd_xx_o2_t3_m0_l0;
					RHS_gtd_xy = (((((((((((m_gtd_xy_o0_t0_l0 + m_gtd_xy_o0_t1_l0) + m_gtd_xy_o0_t2_l0) + m_gtd_xy_o1_t0_l0) + m_gtd_xy_o1_t1_l0) + m_gtd_xy_o1_t2_l0) + m_gtd_xy_o2_t0_l0) + m_gtd_xy_o2_t1_l0) + m_gtd_xy_o2_t2_l0) + m_gtd_xy_o2_t3_l0) + m_gtd_xy_o2_t4_l0) + m_gtd_xy_o2_t5_l0) + d_gtd_xy_o2_t6_m0_l0;
					RHS_gtd_xz = (((((((((((m_gtd_xz_o0_t0_l0 + m_gtd_xz_o0_t1_l0) + m_gtd_xz_o0_t2_l0) + m_gtd_xz_o1_t0_l0) + m_gtd_xz_o1_t1_l0) + m_gtd_xz_o1_t2_l0) + m_gtd_xz_o2_t0_l0) + m_gtd_xz_o2_t1_l0) + m_gtd_xz_o2_t2_l0) + m_gtd_xz_o2_t3_l0) + m_gtd_xz_o2_t4_l0) + m_gtd_xz_o2_t5_l0) + d_gtd_xz_o2_t6_m0_l0;
					RHS_gtd_yy = ((((((((m_gtd_yy_o0_t0_l0 + m_gtd_yy_o0_t1_l0) + m_gtd_yy_o0_t2_l0) + m_gtd_yy_o1_t0_l0) + m_gtd_yy_o1_t1_l0) + m_gtd_yy_o1_t2_l0) + m_gtd_yy_o2_t0_l0) + m_gtd_yy_o2_t1_l0) + m_gtd_yy_o2_t2_l0) + d_gtd_yy_o2_t3_m0_l0;
					RHS_gtd_yz = (((((((((((m_gtd_yz_o0_t0_l0 + m_gtd_yz_o0_t1_l0) + m_gtd_yz_o0_t2_l0) + m_gtd_yz_o1_t0_l0) + m_gtd_yz_o1_t1_l0) + m_gtd_yz_o1_t2_l0) + m_gtd_yz_o2_t0_l0) + m_gtd_yz_o2_t1_l0) + m_gtd_yz_o2_t2_l0) + m_gtd_yz_o2_t3_l0) + m_gtd_yz_o2_t4_l0) + m_gtd_yz_o2_t5_l0) + d_gtd_yz_o2_t6_m0_l0;
					RHS_gtd_zz = ((((((((m_gtd_zz_o0_t0_l0 + m_gtd_zz_o0_t1_l0) + m_gtd_zz_o0_t2_l0) + m_gtd_zz_o1_t0_l0) + m_gtd_zz_o1_t1_l0) + m_gtd_zz_o1_t2_l0) + m_gtd_zz_o2_t0_l0) + m_gtd_zz_o2_t1_l0) + m_gtd_zz_o2_t2_l0) + d_gtd_zz_o2_t3_m0_l0;
					RHS_Atd_xx = ((((((((m_Atd_xx_o0_t0_l0 + m_Atd_xx_o0_t1_l0) + m_Atd_xx_o0_t2_l0) + m_Atd_xx_o1_t0_l0) + m_Atd_xx_o1_t1_l0) + m_Atd_xx_o1_t2_l0) + m_Atd_xx_o2_t0_l0) + m_Atd_xx_o2_t1_l0) + m_Atd_xx_o2_t2_l0) + d_Atd_xx_o2_t3_m0_l0;
					RHS_Atd_xy = (((((((((((m_Atd_xy_o0_t0_l0 + m_Atd_xy_o0_t1_l0) + m_Atd_xy_o0_t2_l0) + m_Atd_xy_o1_t0_l0) + m_Atd_xy_o1_t1_l0) + m_Atd_xy_o1_t2_l0) + m_Atd_xy_o2_t0_l0) + m_Atd_xy_o2_t1_l0) + m_Atd_xy_o2_t2_l0) + m_Atd_xy_o2_t3_l0) + m_Atd_xy_o2_t4_l0) + m_Atd_xy_o2_t5_l0) + d_Atd_xy_o2_t6_m0_l0;
					RHS_Atd_xz = (((((((((((m_Atd_xz_o0_t0_l0 + m_Atd_xz_o0_t1_l0) + m_Atd_xz_o0_t2_l0) + m_Atd_xz_o1_t0_l0) + m_Atd_xz_o1_t1_l0) + m_Atd_xz_o1_t2_l0) + m_Atd_xz_o2_t0_l0) + m_Atd_xz_o2_t1_l0) + m_Atd_xz_o2_t2_l0) + m_Atd_xz_o2_t3_l0) + m_Atd_xz_o2_t4_l0) + m_Atd_xz_o2_t5_l0) + d_Atd_xz_o2_t6_m0_l0;
					RHS_Atd_yy = ((((((((m_Atd_yy_o0_t0_l0 + m_Atd_yy_o0_t1_l0) + m_Atd_yy_o0_t2_l0) + m_Atd_yy_o1_t0_l0) + m_Atd_yy_o1_t1_l0) + m_Atd_yy_o1_t2_l0) + m_Atd_yy_o2_t0_l0) + m_Atd_yy_o2_t1_l0) + m_Atd_yy_o2_t2_l0) + d_Atd_yy_o2_t3_m0_l0;
					RHS_Atd_yz = (((((((((((m_Atd_yz_o0_t0_l0 + m_Atd_yz_o0_t1_l0) + m_Atd_yz_o0_t2_l0) + m_Atd_yz_o1_t0_l0) + m_Atd_yz_o1_t1_l0) + m_Atd_yz_o1_t2_l0) + m_Atd_yz_o2_t0_l0) + m_Atd_yz_o2_t1_l0) + m_Atd_yz_o2_t2_l0) + m_Atd_yz_o2_t3_l0) + m_Atd_yz_o2_t4_l0) + m_Atd_yz_o2_t5_l0) + d_Atd_yz_o2_t6_m0_l0;
					RHS_Atd_zz = ((((((((m_Atd_zz_o0_t0_l0 + m_Atd_zz_o0_t1_l0) + m_Atd_zz_o0_t2_l0) + m_Atd_zz_o1_t0_l0) + m_Atd_zz_o1_t1_l0) + m_Atd_zz_o1_t2_l0) + m_Atd_zz_o2_t0_l0) + m_Atd_zz_o2_t1_l0) + m_Atd_zz_o2_t2_l0) + d_Atd_zz_o2_t3_m0_l0;
					RHS_Gamh_x = (((((((((((((((((((((((((((((m_Gamh_x_o0_t0_l0 + m_Gamh_x_o0_t1_l0) + m_Gamh_x_o0_t2_l0) + m_Gamh_x_o1_t0_l0) + m_Gamh_x_o1_t1_l0) + m_Gamh_x_o1_t2_l0) + m_Gamh_x_o2_t0_l0) + m_Gamh_x_o2_t1_l0) + m_Gamh_x_o2_t2_l0) + m_Gamh_x_o2_t3_l0) + m_Gamh_x_o2_t4_l0) + m_Gamh_x_o2_t5_l0) + m_Gamh_x_o2_t6_l0) + m_Gamh_x_o2_t7_l0) + m_Gamh_x_o2_t8_l0) + m_Gamh_x_o2_t9_l0) + m_Gamh_x_o2_t10_l0) + m_Gamh_x_o2_t11_l0) + m_Gamh_x_o2_t12_l0) + m_Gamh_x_o2_t13_l0) + m_Gamh_x_o2_t14_l0) + m_Gamh_x_o2_t15_l0) + m_Gamh_x_o2_t16_l0) + m_Gamh_x_o2_t17_l0) + m_Gamh_x_o2_t18_l0) + m_Gamh_x_o2_t19_l0) + m_Gamh_x_o2_t20_l0) + m_Gamh_x_o2_t21_l0) + m_Gamh_x_o2_t22_l0) + m_Gamh_x_o2_t23_l0) + d_Gamh_x_o2_t24_m0_l0;
					RHS_Gamh_y = (((((((((((((((((((((((((((((m_Gamh_y_o0_t0_l0 + m_Gamh_y_o0_t1_l0) + m_Gamh_y_o0_t2_l0) + m_Gamh_y_o1_t0_l0) + m_Gamh_y_o1_t1_l0) + m_Gamh_y_o1_t2_l0) + m_Gamh_y_o2_t0_l0) + m_Gamh_y_o2_t1_l0) + m_Gamh_y_o2_t2_l0) + m_Gamh_y_o2_t3_l0) + m_Gamh_y_o2_t4_l0) + m_Gamh_y_o2_t5_l0) + m_Gamh_y_o2_t6_l0) + m_Gamh_y_o2_t7_l0) + m_Gamh_y_o2_t8_l0) + m_Gamh_y_o2_t9_l0) + m_Gamh_y_o2_t10_l0) + m_Gamh_y_o2_t11_l0) + m_Gamh_y_o2_t12_l0) + m_Gamh_y_o2_t13_l0) + m_Gamh_y_o2_t14_l0) + m_Gamh_y_o2_t15_l0) + m_Gamh_y_o2_t16_l0) + m_Gamh_y_o2_t17_l0) + m_Gamh_y_o2_t18_l0) + m_Gamh_y_o2_t19_l0) + m_Gamh_y_o2_t20_l0) + m_Gamh_y_o2_t21_l0) + m_Gamh_y_o2_t22_l0) + m_Gamh_y_o2_t23_l0) + d_Gamh_y_o2_t24_m0_l0;
					RHS_Betau_x = (((((d_Betau_x_o0_t0_m0_l0 + m_Betau_x_o1_t0_l0) + m_Betau_x_o1_t1_l0) + m_Betau_x_o1_t2_l0) + m_Betau_x_o2_t0_l0) + m_Betau_x_o2_t1_l0) + m_Betau_x_o2_t2_l0;
					RHS_Betau_y = (((((d_Betau_y_o0_t0_m0_l0 + m_Betau_y_o1_t0_l0) + m_Betau_y_o1_t1_l0) + m_Betau_y_o1_t2_l0) + m_Betau_y_o2_t0_l0) + m_Betau_y_o2_t1_l0) + m_Betau_y_o2_t2_l0;
					RHS_Betau_z = (((((d_Betau_z_o0_t0_m0_l0 + m_Betau_z_o1_t0_l0) + m_Betau_z_o1_t1_l0) + m_Betau_z_o1_t2_l0) + m_Betau_z_o2_t0_l0) + m_Betau_z_o2_t1_l0) + m_Betau_z_o2_t2_l0;
					RHS_Gamh_z = (((((((((((((((((((((((((((((m_Gamh_z_o0_t0_l0 + m_Gamh_z_o0_t1_l0) + m_Gamh_z_o0_t2_l0) + m_Gamh_z_o1_t0_l0) + m_Gamh_z_o1_t1_l0) + m_Gamh_z_o1_t2_l0) + m_Gamh_z_o2_t0_l0) + m_Gamh_z_o2_t1_l0) + m_Gamh_z_o2_t2_l0) + m_Gamh_z_o2_t3_l0) + m_Gamh_z_o2_t4_l0) + m_Gamh_z_o2_t5_l0) + m_Gamh_z_o2_t6_l0) + m_Gamh_z_o2_t7_l0) + m_Gamh_z_o2_t8_l0) + m_Gamh_z_o2_t9_l0) + m_Gamh_z_o2_t10_l0) + m_Gamh_z_o2_t11_l0) + m_Gamh_z_o2_t12_l0) + m_Gamh_z_o2_t13_l0) + m_Gamh_z_o2_t14_l0) + m_Gamh_z_o2_t15_l0) + m_Gamh_z_o2_t16_l0) + m_Gamh_z_o2_t17_l0) + m_Gamh_z_o2_t18_l0) + m_Gamh_z_o2_t19_l0) + m_Gamh_z_o2_t20_l0) + m_Gamh_z_o2_t21_l0) + m_Gamh_z_o2_t22_l0) + m_Gamh_z_o2_t23_l0) + d_Gamh_z_o2_t24_m0_l0;
					RHS_Alpha = (((((m_Alpha_o0_t0_l0 + m_Alpha_o0_t1_l0) + m_Alpha_o0_t2_l0) + m_Alpha_o1_t0_l0) + m_Alpha_o1_t1_l0) + m_Alpha_o1_t2_l0) + d_Alpha_o2_t0_m0_l0;
					RHS_chi = (((((m_chi_o0_t0_l0 + m_chi_o0_t1_l0) + m_chi_o0_t2_l0) + m_chi_o1_t0_l0) + m_chi_o1_t1_l0) + m_chi_o1_t2_l0) + d_chi_o2_t0_m0_l0;
					RHS_trK = ((((((((((((((((((((((((((m_trK_o0_t0_l0 + m_trK_o0_t1_l0) + m_trK_o0_t2_l0) + m_trK_o1_t0_l0) + m_trK_o1_t1_l0) + m_trK_o1_t2_l0) + m_trK_o2_t0_l0) + m_trK_o2_t1_l0) + m_trK_o2_t2_l0) + m_trK_o2_t3_l0) + m_trK_o2_t4_l0) + m_trK_o2_t5_l0) + m_trK_o2_t6_l0) + m_trK_o2_t7_l0) + m_trK_o2_t8_l0) + m_trK_o2_t9_l0) + m_trK_o2_t10_l0) + m_trK_o2_t11_l0) + m_trK_o2_t12_l0) + m_trK_o2_t13_l0) + m_trK_o2_t14_l0) + m_trK_o2_t15_l0) + m_trK_o2_t16_l0) + m_trK_o2_t17_l0) + m_trK_o2_t18_l0) + m_trK_o2_t19_l0) + m_trK_o2_t20_l0) + d_trK_o2_t21_m0_l0;
					RHS_theta = ((((((((m_theta_o0_t0_l0 + m_theta_o0_t1_l0) + m_theta_o0_t2_l0) + m_theta_o1_t0_l0) + m_theta_o1_t1_l0) + m_theta_o1_t2_l0) + m_theta_o2_t0_l0) + m_theta_o2_t1_l0) + m_theta_o2_t2_l0) + d_theta_o2_t3_m0_l0;
					RHS_phiR = (((((m_phiR_o0_t0_l0 + m_phiR_o0_t1_l0) + m_phiR_o0_t2_l0) + m_phiR_o1_t0_l0) + m_phiR_o1_t1_l0) + m_phiR_o1_t2_l0) + rk2d_d_phiR4d_t_o0_t0_m0_l0;
					RHS_pheR = (((((m_pheR_o0_t0_l0 + m_pheR_o0_t1_l0) + m_pheR_o0_t2_l0) + m_pheR_o1_t0_l0) + m_pheR_o1_t1_l0) + m_pheR_o1_t2_l0) + rk2d_d_pheR4d_t_o0_t0_m0_l0;
					RHS_phiI = (((((m_phiI_o0_t0_l0 + m_phiI_o0_t1_l0) + m_phiI_o0_t2_l0) + m_phiI_o1_t0_l0) + m_phiI_o1_t1_l0) + m_phiI_o1_t2_l0) + rk2d_d_phiI4d_t_o0_t0_m0_l0;
					RHS_pheI = (((((m_pheI_o0_t0_l0 + m_pheI_o0_t1_l0) + m_pheI_o0_t2_l0) + m_pheI_o1_t0_l0) + m_pheI_o1_t1_l0) + m_pheI_o1_t2_l0) + rk2d_d_pheI4d_t_o0_t0_m0_l0;
					RHS_piR = ((((((((((((((((((((((((((((((((m_piR_o0_t0_l0 + m_piR_o0_t1_l0) + m_piR_o0_t2_l0) + m_piR_o1_t0_l0) + m_piR_o1_t1_l0) + m_piR_o1_t2_l0) + m_piR_o2_t0_l0) + m_piR_o2_t1_l0) + m_piR_o2_t2_l0) + m_piR_o2_t3_l0) + m_piR_o2_t4_l0) + m_piR_o2_t5_l0) + m_piR_o2_t6_l0) + m_piR_o2_t7_l0) + m_piR_o2_t8_l0) + m_piR_o2_t9_l0) + m_piR_o2_t10_l0) + m_piR_o2_t11_l0) + m_piR_o2_t12_l0) + m_piR_o2_t13_l0) + m_piR_o2_t14_l0) + m_piR_o2_t15_l0) + m_piR_o2_t16_l0) + m_piR_o2_t17_l0) + m_piR_o2_t18_l0) + m_piR_o2_t19_l0) + m_piR_o2_t20_l0) + m_piR_o2_t21_l0) + m_piR_o2_t22_l0) + m_piR_o2_t23_l0) + m_piR_o2_t24_l0) + m_piR_o2_t25_l0) + m_piR_o2_t26_l0) + d_piR_o2_t27_m0_l0;
					RHS_peR = ((((((((((((((((((((((((((((((((m_peR_o0_t0_l0 + m_peR_o0_t1_l0) + m_peR_o0_t2_l0) + m_peR_o1_t0_l0) + m_peR_o1_t1_l0) + m_peR_o1_t2_l0) + m_peR_o2_t0_l0) + m_peR_o2_t1_l0) + m_peR_o2_t2_l0) + m_peR_o2_t3_l0) + m_peR_o2_t4_l0) + m_peR_o2_t5_l0) + m_peR_o2_t6_l0) + m_peR_o2_t7_l0) + m_peR_o2_t8_l0) + m_peR_o2_t9_l0) + m_peR_o2_t10_l0) + m_peR_o2_t11_l0) + m_peR_o2_t12_l0) + m_peR_o2_t13_l0) + m_peR_o2_t14_l0) + m_peR_o2_t15_l0) + m_peR_o2_t16_l0) + m_peR_o2_t17_l0) + m_peR_o2_t18_l0) + m_peR_o2_t19_l0) + m_peR_o2_t20_l0) + m_peR_o2_t21_l0) + m_peR_o2_t22_l0) + m_peR_o2_t23_l0) + m_peR_o2_t24_l0) + m_peR_o2_t25_l0) + m_peR_o2_t26_l0) + d_peR_o2_t27_m0_l0;
					RHS_piI = ((((((((((((((((((((((((((((((((m_piI_o0_t0_l0 + m_piI_o0_t1_l0) + m_piI_o0_t2_l0) + m_piI_o1_t0_l0) + m_piI_o1_t1_l0) + m_piI_o1_t2_l0) + m_piI_o2_t0_l0) + m_piI_o2_t1_l0) + m_piI_o2_t2_l0) + m_piI_o2_t3_l0) + m_piI_o2_t4_l0) + m_piI_o2_t5_l0) + m_piI_o2_t6_l0) + m_piI_o2_t7_l0) + m_piI_o2_t8_l0) + m_piI_o2_t9_l0) + m_piI_o2_t10_l0) + m_piI_o2_t11_l0) + m_piI_o2_t12_l0) + m_piI_o2_t13_l0) + m_piI_o2_t14_l0) + m_piI_o2_t15_l0) + m_piI_o2_t16_l0) + m_piI_o2_t17_l0) + m_piI_o2_t18_l0) + m_piI_o2_t19_l0) + m_piI_o2_t20_l0) + m_piI_o2_t21_l0) + m_piI_o2_t22_l0) + m_piI_o2_t23_l0) + m_piI_o2_t24_l0) + m_piI_o2_t25_l0) + m_piI_o2_t26_l0) + d_piI_o2_t27_m0_l0;
					RHS_peI = ((((((((((((((((((((((((((((((((m_peI_o0_t0_l0 + m_peI_o0_t1_l0) + m_peI_o0_t2_l0) + m_peI_o1_t0_l0) + m_peI_o1_t1_l0) + m_peI_o1_t2_l0) + m_peI_o2_t0_l0) + m_peI_o2_t1_l0) + m_peI_o2_t2_l0) + m_peI_o2_t3_l0) + m_peI_o2_t4_l0) + m_peI_o2_t5_l0) + m_peI_o2_t6_l0) + m_peI_o2_t7_l0) + m_peI_o2_t8_l0) + m_peI_o2_t9_l0) + m_peI_o2_t10_l0) + m_peI_o2_t11_l0) + m_peI_o2_t12_l0) + m_peI_o2_t13_l0) + m_peI_o2_t14_l0) + m_peI_o2_t15_l0) + m_peI_o2_t16_l0) + m_peI_o2_t17_l0) + m_peI_o2_t18_l0) + m_peI_o2_t19_l0) + m_peI_o2_t20_l0) + m_peI_o2_t21_l0) + m_peI_o2_t22_l0) + m_peI_o2_t23_l0) + m_peI_o2_t24_l0) + m_peI_o2_t25_l0) + m_peI_o2_t26_l0) + d_peI_o2_t27_m0_l0;
					n_x = 0.0;
					n_y = 0.0;
					n_z = 0.0;
					interaction_index = 0.0;
					if ((((((regions(i + 1, j, k, FOV_xLower) > 0.0) || (regions(i + 1, j, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k, FOV_yLower) > 0.0)) || (regions(i + 1, j, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k, FOV_zLower) > 0.0)) || (regions(i + 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x + 1.0 / dx[0];
					}
					if ((((((regions(i - 1, j, k, FOV_xLower) > 0.0) || (regions(i - 1, j, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k, FOV_yLower) > 0.0)) || (regions(i - 1, j, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k, FOV_zLower) > 0.0)) || (regions(i - 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x - 1.0 / dx[0];
					}
					if ((((((regions(i, j + 1, k, FOV_xLower) > 0.0) || (regions(i, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k, FOV_yLower) > 0.0)) || (regions(i, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k, FOV_zLower) > 0.0)) || (regions(i, j + 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y + 1.0 / dx[1];
					}
					if ((((((regions(i, j - 1, k, FOV_xLower) > 0.0) || (regions(i, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k, FOV_yLower) > 0.0)) || (regions(i, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k, FOV_zLower) > 0.0)) || (regions(i, j - 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y - 1.0 / dx[1];
					}
					if ((((((regions(i, j, k + 1, FOV_xLower) > 0.0) || (regions(i, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j, k + 1, FOV_yLower) > 0.0)) || (regions(i, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j, k + 1, FOV_zLower) > 0.0)) || (regions(i, j, k + 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z + 1.0 / dx[2];
					}
					if ((((((regions(i, j, k - 1, FOV_xLower) > 0.0) || (regions(i, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j, k - 1, FOV_yLower) > 0.0)) || (regions(i, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j, k - 1, FOV_zLower) > 0.0)) || (regions(i, j, k - 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z - 1.0 / dx[2];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k, FOV_xLower) > 0.0)) || (regions(i + 1, j, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k, FOV_yLower) > 0.0)) || (regions(i + 1, j, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k, FOV_zLower) > 0.0)) || (regions(i + 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x + 1.0 / dx[0];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k, FOV_xLower) > 0.0)) || (regions(i - 1, j, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k, FOV_yLower) > 0.0)) || (regions(i - 1, j, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k, FOV_zLower) > 0.0)) || (regions(i - 1, j, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_x = n_x - 1.0 / dx[0];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k, FOV_xLower) > 0.0)) || (regions(i, j + 1, k, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k, FOV_yLower) > 0.0)) || (regions(i, j + 1, k, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k, FOV_zLower) > 0.0)) || (regions(i, j + 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y + 1.0 / dx[1];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k, FOV_xLower) > 0.0)) || (regions(i, j - 1, k, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k, FOV_yLower) > 0.0)) || (regions(i, j - 1, k, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k, FOV_zLower) > 0.0)) || (regions(i, j - 1, k, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_y = n_y - 1.0 / dx[1];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k + 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k + 1, FOV_zUpper) > 0.0)) || (regions(i, j, k + 1, FOV_xLower) > 0.0)) || (regions(i, j, k + 1, FOV_xUpper) > 0.0)) || (regions(i, j, k + 1, FOV_yLower) > 0.0)) || (regions(i, j, k + 1, FOV_yUpper) > 0.0)) || (regions(i, j, k + 1, FOV_zLower) > 0.0)) || (regions(i, j, k + 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z + 1.0 / dx[2];
					}
					if ((((((((((((((((((((((((((((((((((((((((((((((((((((((regions(i + 1, j + 1, k - 1, FOV_xLower) > 0.0) || (regions(i + 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i + 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zLower) > 0.0)) || (regions(i - 1, j, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j + 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zLower) > 0.0)) || (regions(i, j - 1, k - 1, FOV_zUpper) > 0.0)) || (regions(i, j, k - 1, FOV_xLower) > 0.0)) || (regions(i, j, k - 1, FOV_xUpper) > 0.0)) || (regions(i, j, k - 1, FOV_yLower) > 0.0)) || (regions(i, j, k - 1, FOV_yUpper) > 0.0)) || (regions(i, j, k - 1, FOV_zLower) > 0.0)) || (regions(i, j, k - 1, FOV_zUpper) > 0.0)) {
						interaction_index = 1.0;
						n_z = n_z - 1.0 / dx[2];
					}
					if ((!equalsEq(n_x, 0.0) || !equalsEq(n_y, 0.0)) || !equalsEq(n_z, 0.0)) {
						mod_normal = sqrt((n_x * n_x + n_y * n_y) + n_z * n_z);
						n_x = n_x / mod_normal;
						n_y = n_y / mod_normal;
						n_z = n_z / mod_normal;
					}
					if (equalsEq(interaction_index, 1.0)) {
						i_d_Atd_xx_o0_t0_m0_l0 = D1CDO4_i(Atd_xx, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xx_o0_t1_m0_l0 = D1CDO4_j(Atd_xx, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xx_o0_t2_m0_l0 = D1CDO4_k(Atd_xx, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t0_m0_l0 = D1CDO4_i(Atd_xy, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t1_m0_l0 = D1CDO4_j(Atd_xy, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xy_o0_t2_m0_l0 = D1CDO4_k(Atd_xy, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t0_m0_l0 = D1CDO4_i(Atd_xz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t1_m0_l0 = D1CDO4_j(Atd_xz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_xz_o0_t2_m0_l0 = D1CDO4_k(Atd_xz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t0_m0_l0 = D1CDO4_i(Atd_yy, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t1_m0_l0 = D1CDO4_j(Atd_yy, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_yy_o0_t2_m0_l0 = D1CDO4_k(Atd_yy, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t0_m0_l0 = D1CDO4_i(Atd_yz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t1_m0_l0 = D1CDO4_j(Atd_yz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_yz_o0_t2_m0_l0 = D1CDO4_k(Atd_yz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t0_m0_l0 = D1CDO4_i(Atd_zz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t1_m0_l0 = D1CDO4_j(Atd_zz, rk2, i, j, k, dx, dt_lev);
						i_d_Atd_zz_o0_t2_m0_l0 = D1CDO4_k(Atd_zz, rk2, i, j, k, dx, dt_lev);
						i_d_piR_o0_t0_m0_l0 = D1CDO4_i(piR, rk2, i, j, k, dx, dt_lev);
						i_d_piR_o0_t1_m0_l0 = D1CDO4_j(piR, rk2, i, j, k, dx, dt_lev);
						i_d_piR_o0_t2_m0_l0 = D1CDO4_k(piR, rk2, i, j, k, dx, dt_lev);
						i_d_peR_o0_t0_m0_l0 = D1CDO4_i(peR, rk2, i, j, k, dx, dt_lev);
						i_d_peR_o0_t1_m0_l0 = D1CDO4_j(peR, rk2, i, j, k, dx, dt_lev);
						i_d_peR_o0_t2_m0_l0 = D1CDO4_k(peR, rk2, i, j, k, dx, dt_lev);
						i_d_piI_o0_t0_m0_l0 = D1CDO4_i(piI, rk2, i, j, k, dx, dt_lev);
						i_d_piI_o0_t1_m0_l0 = D1CDO4_j(piI, rk2, i, j, k, dx, dt_lev);
						i_d_piI_o0_t2_m0_l0 = D1CDO4_k(piI, rk2, i, j, k, dx, dt_lev);
						i_d_peI_o0_t0_m0_l0 = D1CDO4_i(peI, rk2, i, j, k, dx, dt_lev);
						i_d_peI_o0_t1_m0_l0 = D1CDO4_j(peI, rk2, i, j, k, dx, dt_lev);
						i_d_peI_o0_t2_m0_l0 = D1CDO4_k(peI, rk2, i, j, k, dx, dt_lev);
						i_d_gtd_xx_o0_t3_m0_l0 = -parameters.gtd_xx_falloff * (rk2(i, j, k, gtd_xx) - parameters.gtd_xx_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_xy_o0_t3_m0_l0 = -parameters.gtd_xy_falloff * (rk2(i, j, k, gtd_xy) - parameters.gtd_xy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_xz_o0_t3_m0_l0 = -parameters.gtd_xz_falloff * (rk2(i, j, k, gtd_xz) - parameters.gtd_xz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_yy_o0_t3_m0_l0 = -parameters.gtd_yy_falloff * (rk2(i, j, k, gtd_yy) - parameters.gtd_yy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_yz_o0_t3_m0_l0 = -parameters.gtd_yz_falloff * (rk2(i, j, k, gtd_yz) - parameters.gtd_yz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_gtd_zz_o0_t3_m0_l0 = -parameters.gtd_zz_falloff * (rk2(i, j, k, gtd_zz) - parameters.gtd_zz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xx_o0_t3_m0_l0 = -parameters.Atd_xx_falloff * (rk2(i, j, k, Atd_xx) - parameters.Atd_xx_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xy_o0_t3_m0_l0 = -parameters.Atd_xy_falloff * (rk2(i, j, k, Atd_xy) - parameters.Atd_xy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_xz_o0_t3_m0_l0 = -parameters.Atd_xz_falloff * (rk2(i, j, k, Atd_xz) - parameters.Atd_xz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_yy_o0_t3_m0_l0 = -parameters.Atd_yy_falloff * (rk2(i, j, k, Atd_yy) - parameters.Atd_yy_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_yz_o0_t3_m0_l0 = -parameters.Atd_yz_falloff * (rk2(i, j, k, Atd_yz) - parameters.Atd_yz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Atd_zz_o0_t3_m0_l0 = -parameters.Atd_zz_falloff * (rk2(i, j, k, Atd_zz) - parameters.Atd_zz_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_x_o0_t3_m0_l0 = -parameters.Gamh_x_falloff * (rk2(i, j, k, Gamh_x) - parameters.Gamh_x_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_y_o0_t3_m0_l0 = -parameters.Gamh_y_falloff * (rk2(i, j, k, Gamh_y) - parameters.Gamh_y_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Gamh_z_o0_t3_m0_l0 = -parameters.Gamh_z_falloff * (rk2(i, j, k, Gamh_z) - parameters.Gamh_z_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_x_o0_t3_m0_l0 = -parameters.Betau_x_falloff * (rk2(i, j, k, Betau_x) - parameters.Betau_x_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_y_o0_t3_m0_l0 = -parameters.Betau_y_falloff * (rk2(i, j, k, Betau_y) - parameters.Betau_y_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Betau_z_o0_t3_m0_l0 = -parameters.Betau_z_falloff * (rk2(i, j, k, Betau_z) - parameters.Betau_z_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_Alpha_o0_t3_m0_l0 = -parameters.Alpha_falloff * (rk2(i, j, k, Alpha) - parameters.Alpha_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_chi_o0_t3_m0_l0 = -parameters.chi_falloff * (rk2(i, j, k, chi) - parameters.chi_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_trK_o0_t3_m0_l0 = -parameters.trK_falloff * (rk2(i, j, k, trK) - parameters.trK_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_theta_o0_t3_m0_l0 = -parameters.theta_falloff * (rk2(i, j, k, theta) - parameters.theta_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_phiR_o0_t3_m0_l0 = -parameters.phiR_falloff * (rk2(i, j, k, phiR) - parameters.phiR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_phiI_o0_t3_m0_l0 = -parameters.phiI_falloff * (rk2(i, j, k, phiI) - parameters.phiI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_piR_o0_t3_m0_l0 = -parameters.piR_falloff * (rk2(i, j, k, piR) - parameters.piR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_piI_o0_t3_m0_l0 = -parameters.piI_falloff * (rk2(i, j, k, piI) - parameters.piI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_pheR_o0_t3_m0_l0 = -parameters.pheR_falloff * (rk2(i, j, k, pheR) - parameters.pheR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_pheI_o0_t3_m0_l0 = -parameters.pheI_falloff * (rk2(i, j, k, pheI) - parameters.pheI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_peR_o0_t3_m0_l0 = -parameters.peR_falloff * (rk2(i, j, k, peR) - parameters.peR_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_d_peI_o0_t3_m0_l0 = -parameters.peI_falloff * (rk2(i, j, k, peI) - parameters.peI_asymptotic) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k));
						i_m_gtd_xx_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxx_o0_t0_m0_l0;
						i_m_gtd_xx_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxy_o0_t0_m0_l0;
						i_m_gtd_xx_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xxz_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yxx_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyy_o0_t0_m0_l0;
						i_m_gtd_xy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t1_m0_l0;
						i_m_gtd_xz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zxx_o0_t0_m0_l0;
						i_m_gtd_xz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t0_m0_l0;
						i_m_gtd_xz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xzz_o0_t0_m0_l0;
						i_m_gtd_yy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyy_o0_t1_m0_l0;
						i_m_gtd_yy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yyy_o0_t0_m0_l0;
						i_m_gtd_yy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yyz_o0_t0_m0_l0;
						i_m_gtd_yz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xyz_o0_t2_m0_l0;
						i_m_gtd_yz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zyy_o0_t0_m0_l0;
						i_m_gtd_yz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yzz_o0_t0_m0_l0;
						i_m_gtd_zz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_xzz_o0_t1_m0_l0;
						i_m_gtd_zz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_yzz_o0_t1_m0_l0;
						i_m_gtd_zz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Ctd_zzz_o0_t0_m0_l0;
						i_m_Atd_xx_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t0_m0_l0;
						i_m_Atd_xx_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t1_m0_l0;
						i_m_Atd_xx_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xx_o0_t2_m0_l0;
						i_m_Atd_xy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t0_m0_l0;
						i_m_Atd_xy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t1_m0_l0;
						i_m_Atd_xy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xy_o0_t2_m0_l0;
						i_m_Atd_xz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t0_m0_l0;
						i_m_Atd_xz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t1_m0_l0;
						i_m_Atd_xz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_xz_o0_t2_m0_l0;
						i_m_Atd_yy_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t0_m0_l0;
						i_m_Atd_yy_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t1_m0_l0;
						i_m_Atd_yy_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yy_o0_t2_m0_l0;
						i_m_Atd_yz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t0_m0_l0;
						i_m_Atd_yz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t1_m0_l0;
						i_m_Atd_yz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_yz_o0_t2_m0_l0;
						i_m_Atd_zz_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t0_m0_l0;
						i_m_Atd_zz_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t1_m0_l0;
						i_m_Atd_zz_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_Atd_zz_o0_t2_m0_l0;
						i_m_Gamh_x_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t6_m0_l0;
						i_m_Gamh_x_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t6_m0_l0;
						i_m_Gamh_x_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t6_m0_l0;
						i_m_Gamh_y_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t7_m0_l0;
						i_m_Gamh_y_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t7_m0_l0;
						i_m_Gamh_y_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t7_m0_l0;
						i_m_Gamh_z_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xx_o0_t8_m0_l0;
						i_m_Gamh_z_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xy_o0_t8_m0_l0;
						i_m_Gamh_z_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rtd_xz_o0_t8_m0_l0;
						i_m_Betau_x_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t0_m0_l0;
						i_m_Betau_x_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xy_o2_t0_m0_l0;
						i_m_Betau_x_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xz_o2_t0_m0_l0;
						i_m_Betau_y_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xx_o2_t1_m0_l0;
						i_m_Betau_y_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t1_m0_l0;
						i_m_Betau_y_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xz_o2_t1_m0_l0;
						i_m_Betau_z_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xx_o2_t2_m0_l0;
						i_m_Betau_z_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_gtd_xy_o2_t2_m0_l0;
						i_m_Betau_z_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_div_Beta_o0_t2_m0_l0;
						i_m_Alpha_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t1_m0_l0;
						i_m_Alpha_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t2_m0_l0;
						i_m_Alpha_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Psi1_xx_o0_t3_m0_l0;
						i_m_chi_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t0_m0_l0;
						i_m_chi_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t1_m0_l0;
						i_m_chi_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Rpd_xx_o0_t2_m0_l0;
						i_m_trK_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t12_m0_l0;
						i_m_trK_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t13_m0_l0;
						i_m_trK_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t14_m0_l0;
						i_m_theta_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t15_m0_l0;
						i_m_theta_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t16_m0_l0;
						i_m_theta_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_Gamh_x_o2_t17_m0_l0;
						i_m_phiR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t1_m0_l0;
						i_m_phiR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t2_m0_l0;
						i_m_phiR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiR4d_t_o0_t3_m0_l0;
						i_m_phiI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t1_m0_l0;
						i_m_phiI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t2_m0_l0;
						i_m_phiI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_phiI4d_t_o0_t3_m0_l0;
						i_m_piR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t0_m0_l0;
						i_m_piR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t1_m0_l0;
						i_m_piR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piR_o0_t2_m0_l0;
						i_m_piI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t0_m0_l0;
						i_m_piI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t1_m0_l0;
						i_m_piI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_piI_o0_t2_m0_l0;
						i_m_pheR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t1_m0_l0;
						i_m_pheR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t2_m0_l0;
						i_m_pheR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheR4d_t_o0_t3_m0_l0;
						i_m_pheI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t1_m0_l0;
						i_m_pheI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t2_m0_l0;
						i_m_pheI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * d_d_pheI4d_t_o0_t3_m0_l0;
						i_m_peR_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t0_m0_l0;
						i_m_peR_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t1_m0_l0;
						i_m_peR_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peR_o0_t2_m0_l0;
						i_m_peI_o0_t0_l0 = (-xcoord(i) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t0_m0_l0;
						i_m_peI_o0_t1_l0 = (-ycoord(j) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t1_m0_l0;
						i_m_peI_o0_t2_l0 = (-zcoord(k) / sqrt(xcoord(i) * xcoord(i) + ycoord(j) * ycoord(j) + zcoord(k) * zcoord(k))) * i_d_peI_o0_t2_m0_l0;
						RHS_gtd_xx = ((i_m_gtd_xx_o0_t0_l0 + i_m_gtd_xx_o0_t1_l0) + i_m_gtd_xx_o0_t2_l0) + i_d_gtd_xx_o0_t3_m0_l0;
						RHS_gtd_xy = ((i_m_gtd_xy_o0_t0_l0 + i_m_gtd_xy_o0_t1_l0) + i_m_gtd_xy_o0_t2_l0) + i_d_gtd_xy_o0_t3_m0_l0;
						RHS_gtd_xz = ((i_m_gtd_xz_o0_t0_l0 + i_m_gtd_xz_o0_t1_l0) + i_m_gtd_xz_o0_t2_l0) + i_d_gtd_xz_o0_t3_m0_l0;
						RHS_gtd_yy = ((i_m_gtd_yy_o0_t0_l0 + i_m_gtd_yy_o0_t1_l0) + i_m_gtd_yy_o0_t2_l0) + i_d_gtd_yy_o0_t3_m0_l0;
						RHS_gtd_yz = ((i_m_gtd_yz_o0_t0_l0 + i_m_gtd_yz_o0_t1_l0) + i_m_gtd_yz_o0_t2_l0) + i_d_gtd_yz_o0_t3_m0_l0;
						RHS_gtd_zz = ((i_m_gtd_zz_o0_t0_l0 + i_m_gtd_zz_o0_t1_l0) + i_m_gtd_zz_o0_t2_l0) + i_d_gtd_zz_o0_t3_m0_l0;
						RHS_Atd_xx = ((i_m_Atd_xx_o0_t0_l0 + i_m_Atd_xx_o0_t1_l0) + i_m_Atd_xx_o0_t2_l0) + i_d_Atd_xx_o0_t3_m0_l0;
						RHS_Atd_xy = ((i_m_Atd_xy_o0_t0_l0 + i_m_Atd_xy_o0_t1_l0) + i_m_Atd_xy_o0_t2_l0) + i_d_Atd_xy_o0_t3_m0_l0;
						RHS_Atd_xz = ((i_m_Atd_xz_o0_t0_l0 + i_m_Atd_xz_o0_t1_l0) + i_m_Atd_xz_o0_t2_l0) + i_d_Atd_xz_o0_t3_m0_l0;
						RHS_Atd_yy = ((i_m_Atd_yy_o0_t0_l0 + i_m_Atd_yy_o0_t1_l0) + i_m_Atd_yy_o0_t2_l0) + i_d_Atd_yy_o0_t3_m0_l0;
						RHS_Atd_yz = ((i_m_Atd_yz_o0_t0_l0 + i_m_Atd_yz_o0_t1_l0) + i_m_Atd_yz_o0_t2_l0) + i_d_Atd_yz_o0_t3_m0_l0;
						RHS_Atd_zz = ((i_m_Atd_zz_o0_t0_l0 + i_m_Atd_zz_o0_t1_l0) + i_m_Atd_zz_o0_t2_l0) + i_d_Atd_zz_o0_t3_m0_l0;
						RHS_Gamh_x = ((i_m_Gamh_x_o0_t0_l0 + i_m_Gamh_x_o0_t1_l0) + i_m_Gamh_x_o0_t2_l0) + i_d_Gamh_x_o0_t3_m0_l0;
						RHS_Gamh_y = ((i_m_Gamh_y_o0_t0_l0 + i_m_Gamh_y_o0_t1_l0) + i_m_Gamh_y_o0_t2_l0) + i_d_Gamh_y_o0_t3_m0_l0;
						RHS_Gamh_z = ((i_m_Gamh_z_o0_t0_l0 + i_m_Gamh_z_o0_t1_l0) + i_m_Gamh_z_o0_t2_l0) + i_d_Gamh_z_o0_t3_m0_l0;
						RHS_Betau_x = ((i_m_Betau_x_o0_t0_l0 + i_m_Betau_x_o0_t1_l0) + i_m_Betau_x_o0_t2_l0) + i_d_Betau_x_o0_t3_m0_l0;
						RHS_Betau_y = ((i_m_Betau_y_o0_t0_l0 + i_m_Betau_y_o0_t1_l0) + i_m_Betau_y_o0_t2_l0) + i_d_Betau_y_o0_t3_m0_l0;
						RHS_Betau_z = ((i_m_Betau_z_o0_t0_l0 + i_m_Betau_z_o0_t1_l0) + i_m_Betau_z_o0_t2_l0) + i_d_Betau_z_o0_t3_m0_l0;
						RHS_Alpha = ((i_m_Alpha_o0_t0_l0 + i_m_Alpha_o0_t1_l0) + i_m_Alpha_o0_t2_l0) + i_d_Alpha_o0_t3_m0_l0;
						RHS_chi = ((i_m_chi_o0_t0_l0 + i_m_chi_o0_t1_l0) + i_m_chi_o0_t2_l0) + i_d_chi_o0_t3_m0_l0;
						RHS_trK = ((i_m_trK_o0_t0_l0 + i_m_trK_o0_t1_l0) + i_m_trK_o0_t2_l0) + i_d_trK_o0_t3_m0_l0;
						RHS_theta = ((i_m_theta_o0_t0_l0 + i_m_theta_o0_t1_l0) + i_m_theta_o0_t2_l0) + i_d_theta_o0_t3_m0_l0;
						RHS_phiR = ((i_m_phiR_o0_t0_l0 + i_m_phiR_o0_t1_l0) + i_m_phiR_o0_t2_l0) + i_d_phiR_o0_t3_m0_l0;
						RHS_phiI = ((i_m_phiI_o0_t0_l0 + i_m_phiI_o0_t1_l0) + i_m_phiI_o0_t2_l0) + i_d_phiI_o0_t3_m0_l0;
						RHS_piR = ((i_m_piR_o0_t0_l0 + i_m_piR_o0_t1_l0) + i_m_piR_o0_t2_l0) + i_d_piR_o0_t3_m0_l0;
						RHS_piI = ((i_m_piI_o0_t0_l0 + i_m_piI_o0_t1_l0) + i_m_piI_o0_t2_l0) + i_d_piI_o0_t3_m0_l0;
						RHS_pheR = ((i_m_pheR_o0_t0_l0 + i_m_pheR_o0_t1_l0) + i_m_pheR_o0_t2_l0) + i_d_pheR_o0_t3_m0_l0;
						RHS_pheI = ((i_m_pheI_o0_t0_l0 + i_m_pheI_o0_t1_l0) + i_m_pheI_o0_t2_l0) + i_d_pheI_o0_t3_m0_l0;
						RHS_peR = ((i_m_peR_o0_t0_l0 + i_m_peR_o0_t1_l0) + i_m_peR_o0_t2_l0) + i_d_peR_o0_t3_m0_l0;
						RHS_peI = ((i_m_peI_o0_t0_l0 + i_m_peI_o0_t1_l0) + i_m_peI_o0_t2_l0) + i_d_peI_o0_t3_m0_l0;
					}
					if (parameters.dissipation_factor_gtd_xx > 0.0) {
						RHS_gtd_xx = RHS_gtd_xx + parameters.dissipation_factor_gtd_xx * (meshDissipation_i(gtd_xx, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xx, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xx, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_xy > 0.0) {
						RHS_gtd_xy = RHS_gtd_xy + parameters.dissipation_factor_gtd_xy * (meshDissipation_i(gtd_xy, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xy, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xy, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_xz > 0.0) {
						RHS_gtd_xz = RHS_gtd_xz + parameters.dissipation_factor_gtd_xz * (meshDissipation_i(gtd_xz, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_xz, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_xz, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_yy > 0.0) {
						RHS_gtd_yy = RHS_gtd_yy + parameters.dissipation_factor_gtd_yy * (meshDissipation_i(gtd_yy, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_yy, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_yy, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_yz > 0.0) {
						RHS_gtd_yz = RHS_gtd_yz + parameters.dissipation_factor_gtd_yz * (meshDissipation_i(gtd_yz, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_yz, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_yz, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_gtd_zz > 0.0) {
						RHS_gtd_zz = RHS_gtd_zz + parameters.dissipation_factor_gtd_zz * (meshDissipation_i(gtd_zz, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(gtd_zz, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(gtd_zz, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xx > 0.0) {
						RHS_Atd_xx = RHS_Atd_xx + parameters.dissipation_factor_Atd_xx * (meshDissipation_i(Atd_xx, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xx, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xx, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xy > 0.0) {
						RHS_Atd_xy = RHS_Atd_xy + parameters.dissipation_factor_Atd_xy * (meshDissipation_i(Atd_xy, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xy, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xy, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_xz > 0.0) {
						RHS_Atd_xz = RHS_Atd_xz + parameters.dissipation_factor_Atd_xz * (meshDissipation_i(Atd_xz, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_xz, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_xz, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_yy > 0.0) {
						RHS_Atd_yy = RHS_Atd_yy + parameters.dissipation_factor_Atd_yy * (meshDissipation_i(Atd_yy, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_yy, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_yy, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_yz > 0.0) {
						RHS_Atd_yz = RHS_Atd_yz + parameters.dissipation_factor_Atd_yz * (meshDissipation_i(Atd_yz, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_yz, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_yz, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Atd_zz > 0.0) {
						RHS_Atd_zz = RHS_Atd_zz + parameters.dissipation_factor_Atd_zz * (meshDissipation_i(Atd_zz, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Atd_zz, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Atd_zz, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_x > 0.0) {
						RHS_Gamh_x = RHS_Gamh_x + parameters.dissipation_factor_Gamh_x * (meshDissipation_i(Gamh_x, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_x, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_x, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_y > 0.0) {
						RHS_Gamh_y = RHS_Gamh_y + parameters.dissipation_factor_Gamh_y * (meshDissipation_i(Gamh_y, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_y, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_y, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_x > 0.0) {
						RHS_Betau_x = RHS_Betau_x + parameters.dissipation_factor_Betau_x * (meshDissipation_i(Betau_x, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_x, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_x, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_y > 0.0) {
						RHS_Betau_y = RHS_Betau_y + parameters.dissipation_factor_Betau_y * (meshDissipation_i(Betau_y, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_y, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_y, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_z > 0.0) {
						RHS_Betau_z = RHS_Betau_z + parameters.dissipation_factor_Betau_z * (meshDissipation_i(Betau_z, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_z, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_z, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Gamh_z > 0.0) {
						RHS_Gamh_z = RHS_Gamh_z + parameters.dissipation_factor_Gamh_z * (meshDissipation_i(Gamh_z, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Gamh_z, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Gamh_z, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_x > 0.0) {
						RHS_Betau_x = RHS_Betau_x + parameters.dissipation_factor_Betau_x * (meshDissipation_i(Betau_x, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_x, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_x, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_y > 0.0) {
						RHS_Betau_y = RHS_Betau_y + parameters.dissipation_factor_Betau_y * (meshDissipation_i(Betau_y, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_y, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_y, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Betau_z > 0.0) {
						RHS_Betau_z = RHS_Betau_z + parameters.dissipation_factor_Betau_z * (meshDissipation_i(Betau_z, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Betau_z, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Betau_z, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_Alpha > 0.0) {
						RHS_Alpha = RHS_Alpha + parameters.dissipation_factor_Alpha * (meshDissipation_i(Alpha, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(Alpha, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(Alpha, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_chi > 0.0) {
						RHS_chi = RHS_chi + parameters.dissipation_factor_chi * (meshDissipation_i(chi, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(chi, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(chi, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_trK > 0.0) {
						RHS_trK = RHS_trK + parameters.dissipation_factor_trK * (meshDissipation_i(trK, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(trK, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(trK, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_theta > 0.0) {
						RHS_theta = RHS_theta + parameters.dissipation_factor_theta * (meshDissipation_i(theta, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(theta, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(theta, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_phiR > 0.0) {
						RHS_phiR = RHS_phiR + parameters.dissipation_factor_phiR * (meshDissipation_i(phiR, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(phiR, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(phiR, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_pheR > 0.0) {
						RHS_pheR = RHS_pheR + parameters.dissipation_factor_pheR * (meshDissipation_i(pheR, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(pheR, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(pheR, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_phiI > 0.0) {
						RHS_phiI = RHS_phiI + parameters.dissipation_factor_phiI * (meshDissipation_i(phiI, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(phiI, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(phiI, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_pheI > 0.0) {
						RHS_pheI = RHS_pheI + parameters.dissipation_factor_pheI * (meshDissipation_i(pheI, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(pheI, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(pheI, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_piR > 0.0) {
						RHS_piR = RHS_piR + parameters.dissipation_factor_piR * (meshDissipation_i(piR, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(piR, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(piR, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_peR > 0.0) {
						RHS_peR = RHS_peR + parameters.dissipation_factor_peR * (meshDissipation_i(peR, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(peR, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(peR, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_piI > 0.0) {
						RHS_piI = RHS_piI + parameters.dissipation_factor_piI * (meshDissipation_i(piI, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(piI, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(piI, rk2, i, j, k, dx, dt_lev));
					}
					if (parameters.dissipation_factor_peI > 0.0) {
						RHS_peI = RHS_peI + parameters.dissipation_factor_peI * (meshDissipation_i(peI, rk2, i, j, k, dx, dt_lev) + meshDissipation_j(peI, rk2, i, j, k, dx, dt_lev) + meshDissipation_k(peI, rk2, i, j, k, dx, dt_lev));
					}
					rk3(i, j, k, gtd_xx) = RK4P3_(RHS_gtd_xx, un(i, j, k, gtd_xx), dx, dt_lev);
					rk3(i, j, k, gtd_xy) = RK4P3_(RHS_gtd_xy, un(i, j, k, gtd_xy), dx, dt_lev);
					rk3(i, j, k, gtd_xz) = RK4P3_(RHS_gtd_xz, un(i, j, k, gtd_xz), dx, dt_lev);
					rk3(i, j, k, gtd_yy) = RK4P3_(RHS_gtd_yy, un(i, j, k, gtd_yy), dx, dt_lev);
					rk3(i, j, k, gtd_yz) = RK4P3_(RHS_gtd_yz, un(i, j, k, gtd_yz), dx, dt_lev);
					rk3(i, j, k, gtd_zz) = RK4P3_(RHS_gtd_zz, un(i, j, k, gtd_zz), dx, dt_lev);
					rk3(i, j, k, Atd_xx) = RK4P3_(RHS_Atd_xx, un(i, j, k, Atd_xx), dx, dt_lev);
					rk3(i, j, k, Atd_xy) = RK4P3_(RHS_Atd_xy, un(i, j, k, Atd_xy), dx, dt_lev);
					rk3(i, j, k, Atd_xz) = RK4P3_(RHS_Atd_xz, un(i, j, k, Atd_xz), dx, dt_lev);
					rk3(i, j, k, Atd_yy) = RK4P3_(RHS_Atd_yy, un(i, j, k, Atd_yy), dx, dt_lev);
					rk3(i, j, k, Atd_yz) = RK4P3_(RHS_Atd_yz, un(i, j, k, Atd_yz), dx, dt_lev);
					rk3(i, j, k, Atd_zz) = RK4P3_(RHS_Atd_zz, un(i, j, k, Atd_zz), dx, dt_lev);
					rk3(i, j, k, Gamh_x) = RK4P3_(RHS_Gamh_x, un(i, j, k, Gamh_x), dx, dt_lev);
					rk3(i, j, k, Gamh_y) = RK4P3_(RHS_Gamh_y, un(i, j, k, Gamh_y), dx, dt_lev);
					rk3(i, j, k, Betau_x) = RK4P3_(RHS_Betau_x, un(i, j, k, Betau_x), dx, dt_lev);
					rk3(i, j, k, Betau_y) = RK4P3_(RHS_Betau_y, un(i, j, k, Betau_y), dx, dt_lev);
					rk3(i, j, k, Betau_z) = RK4P3_(RHS_Betau_z, un(i, j, k, Betau_z), dx, dt_lev);
					rk3(i, j, k, Gamh_z) = RK4P3_(RHS_Gamh_z, un(i, j, k, Gamh_z), dx, dt_lev);
					rk3(i, j, k, Alpha) = RK4P3_(RHS_Alpha, un(i, j, k, Alpha), dx, dt_lev);
					rk3(i, j, k, chi) = RK4P3_(RHS_chi, un(i, j, k, chi), dx, dt_lev);
					rk3(i, j, k, trK) = RK4P3_(RHS_trK, un(i, j, k, trK), dx, dt_lev);
					rk3(i, j, k, theta) = RK4P3_(RHS_theta, un(i, j, k, theta), dx, dt_lev);
					rk3(i, j, k, phiR) = RK4P3_(RHS_phiR, un(i, j, k, phiR), dx, dt_lev);
					rk3(i, j, k, pheR) = RK4P3_(RHS_pheR, un(i, j, k, pheR), dx, dt_lev);
					rk3(i, j, k, phiI) = RK4P3_(RHS_phiI, un(i, j, k, phiI), dx, dt_lev);
					rk3(i, j, k, pheI) = RK4P3_(RHS_pheI, un(i, j, k, pheI), dx, dt_lev);
					rk3(i, j, k, piR) = RK4P3_(RHS_piR, un(i, j, k, piR), dx, dt_lev);
					rk3(i, j, k, peR) = RK4P3_(RHS_peR, un(i, j, k, peR), dx, dt_lev);
					rk3(i, j, k, piI) = RK4P3_(RHS_piI, un(i, j, k, piI), dx, dt_lev);
					rk3(i, j, k, peI) = RK4P3_(RHS_peI, un(i, j, k, peI), dx, dt_lev);
				}
			});
		}
	}
	if (do_subcycle) {
		FillPatch(lev, current_time + dt_lev, rk3_mf, unstate_var, rk1state_var, rk2state_var, rk3state_var, unp1state_var, NumFields, RK3STEP, iteration, state_interpolator_change);
	} else {
		FillPatch(lev, current_time + dt_lev, rk3_mf, rk3state_var, NumFields, state_interpolator_change);
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> unSyncAuxFieldGroup = unSyncAuxFieldGroup_mf.array(mfi);
			Array4<Real> rk3 = rk3_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			const bool box_touches_lower_x_boundary = bx_lo.x + NUM_GHOST_CELLS == dom_lo.x;
			const bool box_touches_upper_x_boundary = bx_hi.x - NUM_GHOST_CELLS == dom_hi.x + 1;
			const bool box_touches_lower_y_boundary = bx_lo.y + NUM_GHOST_CELLS == dom_lo.y;
			const bool box_touches_upper_y_boundary = bx_hi.y - NUM_GHOST_CELLS == dom_hi.y + 1;
			const bool box_touches_lower_z_boundary = bx_lo.z + NUM_GHOST_CELLS == dom_lo.z;
			const bool box_touches_upper_z_boundary = bx_hi.z - NUM_GHOST_CELLS == dom_hi.z + 1;
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {

				if (((i + 3 <= bx_hi.x || !box_touches_upper_x_boundary) && (i - 3 >= bx_lo.x || !box_touches_lower_x_boundary) && (j + 3 <= bx_hi.y || !box_touches_upper_y_boundary) && (j - 3 >= bx_lo.y || !box_touches_lower_y_boundary) && (k + 3 <= bx_hi.z || !box_touches_upper_z_boundary) && (k - 3 >= bx_lo.z || !box_touches_lower_z_boundary))) {
					unSyncAuxFieldGroup(i, j, k, phi2) = rk3(i, j, k, phiR) * rk3(i, j, k, phiR) + rk3(i, j, k, phiI) * rk3(i, j, k, phiI) + rk3(i, j, k, pheR) * rk3(i, j, k, pheR) + rk3(i, j, k, pheI) * rk3(i, j, k, pheI);
				}
			});
		}
	}
#ifdef AMREX_USE_OMP
#pragma omp parallel if (Gpu::notInLaunchRegion())
#endif
	{
		for (MFIter mfi(un_mf, TilingIfNotGPU()); mfi.isValid(); ++mfi) {
			Array4<Real> regions = regions_mf.array(mfi);
			Array4<Real> rk3 = rk3_mf.array(mfi);
			Array4<Real> unSyncAuxFieldGroup = unSyncAuxFieldGroup_mf.array(mfi);

			// Set up tileboxes and nodal tileboxes
			const Box& vbx = mfi.validbox();
			const Box& gvbx = amrex::grow(vbx, NUM_GHOST_CELLS);
			const Box& bx = mfi.tilebox();
			const Box& gbx = mfi.growntilebox(NUM_GHOST_CELLS);

			const auto bx_lo = amrex::lbound(gvbx);
			const auto bx_hi = amrex::ubound(gvbx);
			const auto tbx_lo = amrex::lbound(gbx);
			const auto tbx_hi = amrex::ubound(gbx);
			const auto bx_size = gbx.size();

			const auto& domain = geom[lev].Domain();
			const auto& dom_lo = amrex::lbound(domain);
			const auto& dom_hi = amrex::ubound(domain);
			amrex::ParallelFor(gbx, 
			[=] AMREX_GPU_DEVICE (int i, int j, int k) noexcept {

				if (i < dom_lo.x) {
					//Region field extrapolations
					if ((regions(i, j, k, d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0 || regions(i, j, k, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI) != 0)) {
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheI, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, trK, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, phiI, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, theta, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yy, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_yz, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_y, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_x, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yy, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, gtd_yz, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Gamh_z, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Betau_z, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, chi, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xz, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, pheR, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, piI, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, k, Atd_xx, rk3, FOV_1, regions, dx);
						extrapolate_field(d_i_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, i, d_j_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_pheI_piR_peR_piI_peI, regions, j, d_k_phi2_gtd_xx_gtd_xy_gtd_xz_gtd_yy_gtd_yz_gtd_zz_Atd_xx_Atd_xy_Atd_xz_Atd_yy_Atd_yz_Atd_zz_Gamh_x_Gamh_y_Betau_x_Betau_y_Betau_z_Gamh_z_Alpha_chi_trK_theta_phiR_pheR_phiI_p